//*********************************************************
//        Joinmax Digital RTOS Module library 1.0
//*********************************************************
// File                 : jmdos.h 
// Version              : V0.3
// Compiler             : GCCARM
// Target               : E2RCU
// Author               : CZQ
// Date                 : 2015/09/08
// Brief                : FreeRTOS for E2RCU
//*********************************************************
#ifndef _JMDOS_H_
#define _JMDOS_H_

#include "FreeRTOSConfig.h"
#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
#include "list.h"
#include "portable.h"
#include "semphr.h"

//#define _MAIN_TASK_DISABLE_ 0//main
#define _TASK_WIFI_	1//WIFI
#define _PICTURETASK_EN_	1//ͼƬʾ
#define _UARTTASK_EN_			1//
//#define _TASK_1_ 1
//#define _TASK_2_ 1
//#define _TASK_3_ 1
//#define _TASK_4_ 1
//#define _TASK_5_ 1
//#define _TASK_6_ 1
//#define _TASK_7_ 1
//#define _TASK_8_ 1
//_TASK_WIFI_
//Ϊϵͳĺбûִ
void task_main_entry(void);
void task1_entry(void);
void task2_entry(void);
void task3_entry(void);
void task4_entry(void);
void task5_entry(void);
void task6_entry(void);
void task7_entry(void);
void task8_entry(void);
u16 OS_CreateTask(u8 tasknum);	//񴴽,һԲ
u16 OS_TaskDelete(u8 tasknum);	//ɾ,һԲ
u16 OS_TaskSuspend(u8 tasknum);	//
u16 OS_TaskResume(u8 tasknum);	//
//Ϊ,Ĺɾ
xTaskHandle xComTaskHandle;//WIFI
#ifndef _MAIN_TASK_DISABLE_//궨ûбʱ,Ĭϳʼ,scratch
xTaskHandle xMainHandle;
#endif//_MAIN_TASK_DISABLE_

#ifdef _TASK_1_
	xTaskHandle xTask1Handle;
#endif//_TASK_1_
#ifdef _TASK_2_
	xTaskHandle xTask2Handle;
#endif//_TASK_2_
#ifdef _TASK_3_
	xTaskHandle xTask3Handle;
#endif//_TASK_3_
#ifdef _TASK_4_
	xTaskHandle xTask4Handle;
#endif//_TASK_4_
#ifdef _TASK_5_
	xTaskHandle xTask5Handle;
#endif//_TASK_5_
#ifdef _TASK_6_
	xTaskHandle xTask6Handle;
#endif//_TASK_6_
#ifdef _TASK_7_
	xTaskHandle xTask7Handle;
#endif//_TASK_7_
#ifdef _TASK_8_
	xTaskHandle xTask8Handle;
#endif//_TASK_8_
void Create_Task(void);
void BoardHardware_Init(void)//RCUʼ
{
	RCU_Board_Init();//ʼRCUӲ
}
void EV5_Init(void)
{
}
#define RTOS_MAIN_TASK_STACK_SIZE	256//ջռ//ջռһҪֺ
#define RTOS_TASK_STACK_SIZE			192//256//128//ջռ
#define RTOS_TASK_PRIORITIES			3//ûȼ
void Create_Task(void)//񴴽ϵͳ
{
#ifndef _MAIN_TASK_DISABLE_//궨ûбʱ,Ĭϳʼ,scratch
	xTaskCreate(task_main_entry,//ַ,ָ
			        ( const signed char * )"task_main", //
			        RTOS_MAIN_TASK_STACK_SIZE,//RTOS_TASK_STACK_SIZE,//256,//ջռ
			        NULL, //ָڲ򴴽
			        RTOS_TASK_PRIORITIES,//RTOS_TASK_PRIORITIES,//2//ȼ
			        &xMainHandle );//,ӦôӶ
#endif//_MAIN_TASK_DISABLE_	
					
#if _TASK_1_ > 0//ԤΪ1ʱ,ʼ֮ǰʼõ
	OS_CreateTask(1);
#endif//_TASK_1_
#if _TASK_2_ > 0
	OS_CreateTask(2);
#endif//_TASK_2_
#if _TASK_3_ > 0
	OS_CreateTask(3);
#endif//_TASK_3_
#if _TASK_4_ > 0
	OS_CreateTask(4);
#endif//_TASK_4_
#if _TASK_5_ > 0
	OS_CreateTask(5);
#endif//_TASK_5_
#if _TASK_6_ > 0
	OS_CreateTask(6);
#endif//_TASK_6_
#if _TASK_7_ > 0
	OS_CreateTask(7);
#endif//_TASK_7_
#if _TASK_8_ > 0
	OS_CreateTask(8);
#endif//_TASK_8_
#ifdef _TASK_WIFI_
	Create_ComTask();
#endif//_TASK_WIFI_
	vTaskStartScheduler();//ʼ
}
#ifdef _TASK_WIFI_
void task_com_entry(void);
u8 Create_ComTaskFlag=0;
void Create_ComTask(void)//ͨ
{
	if(Create_ComTaskFlag)return;Create_ComTaskFlag=1;
	xTaskCreate(task_com_entry,//ַ,ָ
							( const signed char * )"task_com_entry", //
							128,//RTOS_TASK_STACK_SIZE,//256,//ջռ
							NULL, //ָڲ򴴽
							RTOS_TASK_PRIORITIES,//RTOS_TASK_PRIORITIES,//2//ȼ
							&xComTaskHandle );//,ӦôӶ
}

void os_com_task(void);//
void task_com_entry(void)//,붨
{
	os_com_task();
	vTaskDelete(NULL);//ֿⷵ
	return 0;
}
#endif//_TASK_WIFI_
#ifdef _PICTURETASK_EN_
xTaskHandle xPicTaskHandle;//WIFI
int Create_PicTask(void);
void task_pic_entry(void);
u8 _Create_PicTaskFlag=0;
int Create_PicTask(void)//ͨ
{
	if(_Create_PicTaskFlag)return _Create_PicTaskFlag;_Create_PicTaskFlag=1;
	xTaskCreate(task_pic_entry,//ַ,ָ
							( const signed char * )"task_com_entry", //
							1728,//2048,//RTOS_TASK_STACK_SIZE,//256,//ջռ
							NULL, //ָڲ򴴽
							RTOS_TASK_PRIORITIES,//RTOS_TASK_PRIORITIES,//2//ȼ
							&xPicTaskHandle);//,ӦôӶ
	return 0;
}
void os_picture_task(void);
void task_pic_entry(void)
{
	os_picture_task();
	vTaskDelete(NULL);//ֿⷵ
	return 0;
}
#endif//_PICTURETASK_EN_

#ifdef _UARTTASK_EN_//
xTaskHandle xUartHandle;
void task_uart_entry(void)
{
	os_uart_task();
	vTaskDelete(NULL);//ֿⷵ
	return 0;
}
u8 _Create_UartTaskFlag=0;
int Create_UartTask(void)//ͨ
{
	if(_Create_UartTaskFlag)return _Create_UartTaskFlag;_Create_UartTaskFlag=1;
	xTaskCreate(task_uart_entry,//ַ,ָ
							( const signed char * )"task_uart_entry", //
							100,//2048,//RTOS_TASK_STACK_SIZE,//256,//ջռ
							NULL, //ָڲ򴴽
							RTOS_TASK_PRIORITIES,//RTOS_TASK_PRIORITIES,//2//ȼ
							&xUartHandle );//,ӦôӶ
	return 0;
}
#endif//_UARTTASK_EN_
#ifndef _MAIN_TASK_DISABLE_//궨ûбʱ,Ĭϳʼ,scratch
int main(void);//
void task_main_entry(void)//,붨
{
  main();
	vTaskDelete(NULL);//ֿⷵ
	return 0;
}
#endif//#ifndef _MAIN_TASK_DISABLE_
#ifdef _TASK_1_
void task1(void);
void task1_entry(void)
{
	task1();
	vTaskDelete(NULL);
}
#endif//_TASK_1_
#ifdef _TASK_2_
void task2(void);
void task2_entry(void)
{
	task2();
	vTaskDelete(NULL);
}
#endif//_TASK_2_
#ifdef _TASK_3_
void task3(void);
void task3_entry(void)
{
	task3();
	vTaskDelete(NULL);
}
#endif//_TASK_3_
#ifdef _TASK_4_
void task4(void);
void task4_entry(void)
{
	task4();
	vTaskDelete(NULL);
}
#endif//_TASK_4_
#ifdef _TASK_5_
void task5(void);
void task5_entry(void)
{
	task5();
	vTaskDelete(NULL);
}
#endif//_TASK_5_
#ifdef _TASK_6_
void task6(void);
void task6_entry(void)
{
	task6();
	vTaskDelete(NULL);
}
#endif//_TASK_6_
#ifdef _TASK_7_
void task7(void);
void task7_entry(void)
{
	task7();
	vTaskDelete(NULL);
}
#endif//_TASK_7_
#ifdef _TASK_8_
void task8(void);
void task8_entry(void)
{
	task8();
	vTaskDelete(NULL);
}
#endif//_TASK_8_

//ҪȡռõĶ˿ʹȨʱ,볬ʱȴʹȨ,ʱȻûлȡ,Ӧ˳Աִ
#define MUTEXTAKETICKTOWAIT		100//100ms
vu16 MutexTakeWaitTime=MUTEXTAKETICKTOWAIT;//˿ڱռµĳʱʱ
void SetPortMutexTakeWaitTime(u16 time){MutexTakeWaitTime=time;}
//modeΪ˿:0/1:1pin,2:2pin
//ȡRCU˿ʹȨ,ͬһ˿ͬʱֻܱ1ռ,
#define RcuWhichMutexTake(which,mode,Return) if(RcuPortMutexTake(which,mode)==2)\
                                             {\
																										 if(mode!=0)\
																										 {\
																											 u32 t_time=GetSystemTime()+MutexTakeWaitTime;\
																											 while(RcuPortMutexTake(which,mode)==2)\
																											 {\
																												 if(t_time<GetSystemTime())return(Return);\
																											 }\
																										 }\
																									 }
//ͷRCU˿ʹȨֻռж˿ڵʹȨʹøö˿																									 
#define RcuWhichMutexGive(which,mode,Return) RcuPortMutexGive(which,mode)

#define _GET_FLAG(flagx,bity)					((flagx>>(bity<<1))&0X03)
#define _SET_FLAG(flagx,bity,state)		(flagx|=(state<<(bity<<1)))
#define _RESET_FLAG(flagx,bity,state)	(flagx&=~(state<<(bity<<1)))
static vu32 __task_create_flag=0;
static vu32 __task_management_flag=0;
//static vu8 _task_create_flag[16]={1,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
//static vu8 _task_management_flag[16]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
#define vTaskHardwareMutexRelease(taskhandle) //RcuPortMutexRelease(taskhandle)//ͷʹõ
#define vTaskManagement_Enter()								  os_setinterruptmask()//ںж
#define vTaskManagement_Leave()								  os_clearinterruptmask()//ںж

static u8 _Get_OSTaskNum(u8 tasknum)
{
	extern pxCurrentTCB;//ǰеջ
	if(tasknum)return tasknum;
	//if(pxCurrentTCB==xMainHandle)return 0;
#ifdef _TASK_1_
	if(pxCurrentTCB==xTask1Handle)return 1;
#endif//_TASK_1_
#ifdef _TASK_2_
	if(pxCurrentTCB==xTask2Handle)return 2;
#endif//_TASK_2_
#ifdef _TASK_3_
	if(pxCurrentTCB==xTask3Handle)return 3;
#endif//_TASK_3_
#ifdef _TASK_4_
	if(pxCurrentTCB==xTask4Handle)return 4;
#endif//_TASK_4_
#ifdef _TASK_5_
	if(pxCurrentTCB==xTask5Handle)return 5;
#endif//_TASK_5_
#ifdef _TASK_6_
	if(pxCurrentTCB==xTask6Handle)return 6;
#endif//_TASK_6_
#ifdef _TASK_7_
	if(pxCurrentTCB==xTask7Handle)return 7;
#endif//_TASK_7_
#ifdef _TASK_8_
	if(pxCurrentTCB==xTask8Handle)return 8;
#endif//_TASK_8_
	return 0;
}
static s16 RTOS_TaskManagement(xTaskHandle taskhandle,u8 mode)////ɾ
{
	switch(mode)
	{	//ɾ
		case 1:vTaskManagement_Enter();
			       vTaskHardwareMutexRelease(taskhandle);
			       vTaskDelete(taskhandle);
			       vTaskManagement_Leave();
	  return 1;
		//
		case 2:vTaskManagement_Enter();
			       vTaskHardwareMutexRelease(taskhandle);
		         vTaskSuspend(taskhandle);
		         vTaskManagement_Leave();
		return 2;
		break;
		//ѹ,ܻ
		case 3:vTaskResume(taskhandle);
		return 3;
		break;
	}
	return 0;
}
u16 OS_TaskManagement(u8 tasknum,u8 mode)//
{
	u16 state=NULL;
	extern pxCurrentTCB;//ǰеջ
	switch(tasknum)
	{
		case 0:///ɾԼ
#ifndef _MAIN_TASK_DISABLE_//궨ûбʱ,Ĭϳʼ,scratch
		if(pxCurrentTCB!=xMainHandle)//Ҫ/ɾmain
#endif//_MAIN_TASK_DISABLE_
		{
			state=RTOS_TaskManagement(NULL,mode);
		}
		break;
#ifdef _TASK_1_
		case 1:			state=RTOS_TaskManagement(xTask1Handle, mode);		break;
#endif//_TASK_1_
#ifdef _TASK_2_
		case 2:			state=RTOS_TaskManagement(xTask2Handle, mode);	  break;
#endif//_TASK_2_
#ifdef _TASK_3_
		case 3:			state=RTOS_TaskManagement(xTask3Handle, mode);		break;
#endif//_TASK_3_
#ifdef _TASK_4_
		case 4:			state=RTOS_TaskManagement(xTask4Handle, mode);    break;
#endif//_TASK_4_	
#ifdef _TASK_5_	
		case 5:			state=RTOS_TaskManagement(xTask5Handle, mode);    break;
#endif//_TASK_5_	
#ifdef _TASK_6_	
		case 6:			state=RTOS_TaskManagement(xTask6Handle, mode);    break;
#endif//_TASK_6_		
#ifdef _TASK_7_
		case 7:			state=RTOS_TaskManagement(xTask7Handle, mode);    break;
#endif//_TASK_7_
#ifdef _TASK_8_
		case 8:			state=RTOS_TaskManagement(xTask8Handle, mode);    break;
#endif//_TASK_8_		
	}
	return state;
}
u16 OS_TaskDelete(u8 tasknum)//ɾ
{
	u8 n=_Get_OSTaskNum(tasknum);//ȡ
	//if(_task_create_flag[n]==0)return 0;//ûбֱӷ
	//if(_task_management_flag[n]==1)return _task_management_flag[n];	_task_management_flag[n]=1;
	if(_GET_FLAG(__task_create_flag,n)==0)return 0;
	if(_GET_FLAG(__task_management_flag,n)==1)return 1;_SET_FLAG(__task_management_flag,n,1);
	OS_TaskManagement(tasknum, 1);
	//return _task_management_flag[n];
	return 1;
}
u16 OS_TaskSuspend(u8 tasknum)//
{//ѾͲҪٽйѾɾܹ
	u8 n=_Get_OSTaskNum(tasknum);//ȡ
	//if(_task_create_flag[n]==0)return 0;//ûбֱӷ
	//if(_task_management_flag[n]==2||_task_management_flag[n]==1)return _task_management_flag[n];
	//_task_management_flag[n]=2;
	if(_GET_FLAG(__task_create_flag,n)==0)return 0;
	u8 flag=_GET_FLAG(__task_management_flag,n);
	if(flag==1||flag==2)return flag;_SET_FLAG(__task_management_flag,n,2);
	OS_TaskManagement(tasknum, 2);
	//return _task_management_flag[n];
	return 2;
}
u16 OS_TaskResume(u8 tasknum)//
{//ѾѵͲҪٽлѣѾɾܻ
	u8 n=_Get_OSTaskNum(tasknum);//ȡ
	//if(_task_create_flag[n]==0)return 0;//ûбֱӷ
	//if(_task_management_flag[n]==3||_task_management_flag[n]==1)return _task_management_flag[n];
	//_task_management_flag[n]=3;
	if(_GET_FLAG(__task_create_flag,n)==0)return 0;
	u8 flag=_GET_FLAG(__task_management_flag,n);
	if(flag==1||flag==3)return flag;_SET_FLAG(__task_management_flag,n,0x03);
	OS_TaskManagement(tasknum, 3);
	//return _task_management_flag[n];
	return 3;
}
u16 OS_CreateTask(u8 tasknum)//
{
	//if(_task_create_flag[tasknum])return 0;
	//_task_management_flag[tasknum]=0;//־λ
	if(_GET_FLAG(__task_create_flag,tasknum))return 0;_RESET_FLAG(__task_management_flag,tasknum,0x03);
	switch(tasknum)
	{
#ifdef _TASK_1_	
		case 1:
			xTaskCreate(task1_entry,//ַ,ָ
					        ( const signed char * )"task1", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask1Handle );//,ӦôӶ
		break;
#endif//_TASK_1_	
#ifdef _TASK_2_
		case 2:
			xTaskCreate(task2_entry,//ַ,ָ
					        ( const signed char * )"task2", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask2Handle );//,ӦôӶ
	  break;
#endif//_TASK_2_
#ifdef _TASK_3_
		case 3:
			xTaskCreate(task3_entry,//ַ,ָ
					        ( const signed char * )"task3", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask3Handle );//,ӦôӶ
		break;
#endif//_TASK_3_
#ifdef _TASK_4_
		case 4:
			xTaskCreate(task4_entry,//ַ,ָ
					        ( const signed char * )"task4", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask4Handle );//,ӦôӶ
    break;
#endif//_TASK_4_	
#ifdef _TASK_5_
		case 5:
			xTaskCreate(task5_entry,//ַ,ָ
					        ( const signed char * )"task5", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask5Handle );//,ӦôӶ
    break;
#endif//_TASK_5_	
#ifdef _TASK_6_
		case 6:
			xTaskCreate(task6_entry,//ַ,ָ
					        ( const signed char * )"task6", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask6Handle );//,ӦôӶ
    break;
#endif//_TASK_6_
#ifdef _TASK_7_	
		case 7:
			xTaskCreate(task7_entry,//ַ,ָ
					        ( const signed char * )"task7", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask7Handle );//,ӦôӶ
    break;
#endif//_TASK_7_	
#ifdef _TASK_8_
		case 8:
			xTaskCreate(task8_entry,//ַ,ָ
					        ( const signed char * )"task8", //
					        RTOS_TASK_STACK_SIZE,//256,//ջռ
					        NULL, //ָڲ򴴽
					        RTOS_TASK_PRIORITIES,//2//ȼ
					        &xTask8Handle );//,ӦôӶ
    break;
#endif//_TASK_8_		
	}
	//_task_create_flag[tasknum]=1;//񱻴,ظ
	_SET_FLAG(__task_create_flag,tasknum,0x01);
	return 1;
}

u16 OS_WifiTaskSuspend(void)//WIFI
{
	vTaskManagement_Enter();
	vTaskHardwareMutexRelease(xComTaskHandle);
	vTaskSuspend(xComTaskHandle);
	vTaskManagement_Leave();
}
u16 OS_WifiTaskResume(void)//WIFI
{
	//ѹ,ܻ
	vTaskResume(xComTaskHandle);
}
u16 OS_PicTaskSuspend(void)//Pic
{
	vTaskSuspend(xPicTaskHandle);
}
u16 OS_PicTaskResume(void)//Pic
{
	//ѹ,ܻ
	vTaskResume(xPicTaskHandle);
}
#endif//_JMDOS_H_
