/*----------------------------------------------------------------------------/
/ TJpgDec - Tiny JPEG Decompressor include file               (C)ChaN, 2012
/----------------------------------------------------------------------------*/
#ifndef _TJPGDEC
#define _TJPGDEC
/*---------------------------------------------------------------------------*/
/* System Configurations */
#define PIC_UMKNOW	0//ֵ֧ͼƬʽ
#define PIC_BMP			1//BMP
#define PIC_JPEG		2//jpeg
#if 1
//뻺5123100,IN=1024&OUT=4096
#define JD_SZBUF		512//2048 	/* 뻺ĴС (512ı) */
#define JD_FORMAT		1			/* RGBʽ0:RGB888 (3 ֽ/), 1:RGB565 (1 /) */
#define JD_USE_SCALE	1			/* ʹͼ */
#define JD_TBLCLIP		0//1	   	/* ʹÿٲüĴСΪ1kB */
#define JD_TBLZI		1	   	/* ʹZig/ZigĴСΪ64B+64B */
#else
#define	JD_SZBUF		4096	/* Size of stream input buffer */
#define JD_FORMAT		1	/* Output pixel format 0:RGB888 (3 BYTE/pix), 1:RGB565 (1 WORD/pix) */
#define	JD_USE_SCALE	1	/* Use descaling feature for output */
#define JD_TBLCLIP		1	/* Use table for saturation (might be a bit faster but increases 1K bytes of code size) */
#endif
/*---------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

#include "integer.h"

/* Error code */
typedef enum {
	JDR_OK = 0,	/* 0: Succeeded ɹ*/
	JDR_INTR,	/* 1: Interrupted by output function ж*/
	JDR_INP,	/* 2: Device error or wrong termination of input stream ̴󣬻ݴ*/
	JDR_MEM1,	/* 3: Insufficient memory pool for the image Ϊ빤õĹС*/
	JDR_MEM2,	/* 4: Insufficient stream input buffer 뻺СJD_SZBUFݹС*/
	JDR_PAR,	/* 5: Parameter error */
	JDR_FMT1,	/* 6: Data format error (may be damaged data) ͼƬݴ*/
	JDR_FMT2,	/* 7: Right format but not supported ֵ֧ͼƬ*/
	JDR_FMT3,	/* 8: Not supported JPEG standard ֵ֧JPEG ʽ*/
	JDR_SCALE,	/* 9: ͼƬű*/
	JDR_NO_FILE	/* 10: ͼƬʧ*/
} JRESULT;



/* Rectangular structure ؿĴС*/
typedef struct {
	WORD left, right, top, bottom;
	INT xstart, ystart;//ʼʾ
} JRECT;



/* Decompressor object structure */
typedef struct JDEC JDEC;
struct JDEC {
	UINT dctr;				/* Number of bytes available in the input buffer 뻺*/
	BYTE* dptr;				/* Current data read ptr ָǰڶȡݵָ*/
	BYTE* inbuf;			/* Bit stream input buffer ָ뻺ָ*/
	BYTE dmsk;				/* Current bit in the current read byte ǰڶȡֽеĵǰһλ*/
	BYTE scale;				/* Output scaling ratio ͼ*/
	BYTE msx, msy;			/* MCU size in unit of block (width, height) ƬһڴĴС (Ⱥ͸߶)*/
	BYTE qtid[3];			/* Quantization table ID of each component ÿı*/
	SHORT dcv[3];			/* Previous DC element of each component */
	WORD nrst;				/* Restart inverval */
	UINT width, height;		/* Size of the input image (pixel) ͼƬĴСأ*/
	BYTE* huffbits[2][2];	/* Huffman bit distribution tables [id][dcac] طֲ [yc][dcac]*/
	WORD* huffcode[2][2];	/* Huffman code word tables [id][dcac] ֱ [yc][dcac]*/
	BYTE* huffdata[2][2];	/* Huffman decoded data tables [id][dcac] ݱ [yc][dcac]*/
	LONG* qttbl[4];			/* Dequaitizer tables [id] */
	void* workbuf;			/* Working buffer for IDCT and RGB output ָ빤ָ*/
	BYTE* mcubuf;			/* Working buffer for the MCU MCUָ*/
	void* pool;				/* Pointer to available memory pool õڴָ*/
	UINT sz_pool;			/* Size of momory pool (bytes available) õڴĴСֽΪλ*/
	UINT (*infunc)(JDEC*, BYTE*, UINT);/* Pointer to jpeg stream input function ָ뺯ָ*/
	void* device;			/* Pointer to I/O device identifiler for the session ָ빤õӦϢָ*/
#if JD_TBLZI==0
	BYTE *Zig;
	WORD *Ipsf;
#endif//JD_TBLZI
};
#if JD_TBLZI==0
typedef struct
{
	void *Zig;
	void *Ipsf;
}PicBuffer_Typedef;
#endif//#if JD_TBLZI==0
/* TJpgDec API functions */
JRESULT jd_prepare (JDEC*, UINT(*)(JDEC*,BYTE*,UINT), void*, UINT, void*);
JRESULT jd_decomp (JDEC*, UINT(*)(JDEC*,void*,JRECT*), BYTE,JRECT* );

#ifdef __cplusplus
}
#endif

#endif /* _TJPGDEC */
