#ifndef _LCD320240_H_
#define _LCD320240_H_

#include "charcter.h"
#include "LCD_COLOR.h"

#define LCD_Width 240
#define LCD_Heigh 320  

#define LCD_ILI9325		0//ɰҺ
#define LCD_ST7789		1//°Һ
#define LCD_ILI9341		2//°Һ
#define LCD_RM68090		3//ɰҺ

extern u8 gLcdVersion;

void Delay (u32 nCount)
{
	volatile int i;	 	
	for (i=0;i<nCount*1000;i++);
}

void LCD_PinInit(void)
{
RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOC, ENABLE);
RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOD, ENABLE);
RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOE, ENABLE);
//ʼ߶˿
  GPIO_InitTypeDef GPIO_InitStructure;
  GPIO_InitStructure.GPIO_Pin = 0x00FF;   //ʼPA0-7 data8-data15
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOD, &GPIO_InitStructure);

 //ʼ߶˿PD
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_13|GPIO_Pin_14|GPIO_Pin_15;   //ʼPD0=RS PD1
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOC, &GPIO_InitStructure);
  
   //ʼ߶˿PC
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5|GPIO_Pin_6;   //ʼPC11=CS PC10=WR
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_Init(GPIOE, &GPIO_InitStructure);
}

void SetCS(u8 temp){if(temp){GPIOC->BSRR=(1<<15);}else{GPIOC->BRR=(1<<15);}}

void SetRS(u8 temp){if(temp){GPIOC->BSRR=(1<<14);}else{GPIOC->BRR=(1<<14);}}

void SetWR(u8 temp){if(temp){GPIOC->BSRR=(1<<13);}else{GPIOC->BRR=(1<<13);}}

void SetRD(u8 temp){if(temp){GPIOE->BSRR=(1<<6);}else{GPIOE->BRR=(1<<6);}}

void SetReset(u8 temp){if(temp){GPIOE->BSRR=(1<<5);}else{GPIOE->BRR=(1<<5);}}

void SetBackLed(led) {if (led)	GPIO_SetBits(GPIOA,GPIO_Pin_4); else     GPIO_ResetBits(GPIOA,GPIO_Pin_4);}
//#####################################
void LCD_Write_Bus(u8 VH,u8 VL)
{
	u16 getdata,setdata;
	
	GPIOD->BSRR=(VH & 0xFF)|(((~VH) & 0xFF)<<16);
	SetWR(0);
	SetWR(1);
	
	GPIOD->BSRR=(VL & 0xFF)|(((~VL) & 0xFF)<<16);
	SetWR(0);
	SetWR(1);
}

void LCD_Write_Com(u8 VH,u8 VL)
{
SetRS(0);
LCD_Write_Bus(VH,VL);
}

void LCD_Write_Data(u8 VH,u8 VL)
{
SetRS(1);
LCD_Write_Bus(VH,VL);
}
void LCD_Write_Bus8Bit(u8 V)//9341
{
	SetWR(0);
	GPIOD->BSRR=(V & 0xFF)|(((~V) & 0xFF)<<16);
	SetWR(1);
}
void LCD_Write_Com8Bit(u8 V)//9341
{
	SetRS(0);
	LCD_Write_Bus8Bit(V);
}
void LCD_Write_Data8Bit(u8 V)//9341
{
	SetRS(1);
	LCD_Write_Bus8Bit(V);
}
void LCD_Write_Com16Bit(u16 V)//9341
{
	SetRS(0);
	LCD_Write_Bus8Bit(V>>8);
	LCD_Write_Bus8Bit(V&0xff);
}
void LCD_Write_Data16Bit(u16 V)//9341
{
	SetRS(1);
	LCD_Write_Bus8Bit(V>>8);
	LCD_Write_Bus8Bit(V&0xff);
}
void  LCD_WR_REG(u16 Command,u16 Data)
{
LCD_Write_Com(Command>>8,Command);
LCD_Write_Data(Data>>8,Data);
}

void LCD_Init(void)
{
SetReset(1);
Delay(10);
SetReset(0);
Delay(50);
SetReset(1);
SetCS(1);
SetRD(1);
SetWR(1);
Delay(50);

SetCS(0);
if(gLcdVersion==LCD_ILI9325)
{
//************* Start Initial Sequence **********// 
LCD_Write_Com(0x00,0x01); LCD_Write_Data(0x01,0x00); // set SS and SM bit 
LCD_Write_Com(0x00,0x02); LCD_Write_Data(0x07,0x00); // set 1 line inversion 
LCD_Write_Com(0x00,0x03); LCD_Write_Data(0x10,0x30); // set GRAM write direction and BGR=1. 
LCD_Write_Com(0x00,0x04); LCD_Write_Data(0x00,0x00); // Resize register 
LCD_Write_Com(0x00,0x08); LCD_Write_Data(0x02,0x07); // set the back porch and front porch 
LCD_Write_Com(0x00,0x09); LCD_Write_Data(0x00,0x00); // set non-display area refresh cycle ISC[3:0] 
LCD_Write_Com(0x00,0x0A); LCD_Write_Data(0x00,0x00); // FMARK function 
LCD_Write_Com(0x00,0x0C); LCD_Write_Data(0x00,0x00); // RGB interface setting 
LCD_Write_Com(0x00,0x0D); LCD_Write_Data(0x00,0x00); // Frame marker Position 
LCD_Write_Com(0x00,0x0F); LCD_Write_Data(0x00,0x00); // RGB interface polarity 
//*************Power On sequence ****************// 
LCD_Write_Com(0x00,0x10); LCD_Write_Data(0x00,0x00); // SAP, BT[3:0], AP, DSTB, SLP, STB 
LCD_Write_Com(0x00,0x11); LCD_Write_Data(0x00,0x07); // DC1[2:0], DC0[2:0], VC[2:0] 
LCD_Write_Com(0x00,0x12); LCD_Write_Data(0x00,0x00); // VREG1OUT voltage 
LCD_Write_Com(0x00,0x13); LCD_Write_Data(0x00,0x00); // VDV[4:0] for VCOM amplitude 
LCD_Write_Com(0x00,0x07); LCD_Write_Data(0x00,0x01); 
LCD_Write_Com(0x00,0x07); LCD_Write_Data(0x00,0x20); 
Delay(50); // Dis-charge capacitor power voltage 
LCD_Write_Com(0x00,0x10); LCD_Write_Data(0x12,0x90); // 1490//SAP, BT[3:0], AP, DSTB, SLP, STB 
LCD_Write_Com(0x00,0x11); LCD_Write_Data(0x02,0x21); // DC1[2:0], DC0[2:0], VC[2:0] 
Delay(50);// Delay 50ms 
LCD_Write_Com(0x00,0x12); LCD_Write_Data(0x00,0x81); //001C// Internal reference voltage= Vci; 
Delay(50); // Delay 50ms 
LCD_Write_Com(0x00,0x13); LCD_Write_Data(0x15,0x00); //0x1000//1400   Set VDV[4:0] for VCOM amplitude  1A00 
LCD_Write_Com(0x00,0x29); LCD_Write_Data(0x00,0x0C); //0x0012 //001a  Set VCM[5:0] for VCOMH  //0x0025  0034 
LCD_Write_Com(0x00,0x2B); LCD_Write_Data(0x00,0x0D); // Set Frame Rate   000C 
Delay(50);// Delay 50ms 
LCD_Write_Com(0x00,0x20); LCD_Write_Data(0x00,0x00); // GRAM horizontal Address 
LCD_Write_Com(0x00,0x21); LCD_Write_Data(0x00,0x00); // GRAM Vertical Address 
// ----------- Adjust the Gamma Curve ----------// 
LCD_Write_Com(0x00,0x30); LCD_Write_Data(0x03,0x03); 
LCD_Write_Com(0x00,0x31); LCD_Write_Data(0x00,0x06); 
LCD_Write_Com(0x00,0x32); LCD_Write_Data(0x00,0x01); 
LCD_Write_Com(0x00,0x35); LCD_Write_Data(0x02,0x04); 
LCD_Write_Com(0x00,0x36); LCD_Write_Data(0x00,0x04);//0207 
LCD_Write_Com(0x00,0x37); LCD_Write_Data(0x04,0x07);//0306 
LCD_Write_Com(0x00,0x38); LCD_Write_Data(0x00,0x00);//0102 
LCD_Write_Com(0x00,0x39); LCD_Write_Data(0x04,0x04);//0707 
LCD_Write_Com(0x00,0x3C); LCD_Write_Data(0x04,0x02);//0702 
LCD_Write_Com(0x00,0x3D); LCD_Write_Data(0x00,0x04);//1604 

//------------------ Set GRAM area ---------------// 
LCD_Write_Com(0x00,0x50); LCD_Write_Data(0x00,0x00); // Horizontal GRAM Start Address 
LCD_Write_Com(0x00,0x51); LCD_Write_Data(0x00,0xEF); // Horizontal GRAM End Address 
LCD_Write_Com(0x00,0x52); LCD_Write_Data(0x00,0x00); // Vertical GRAM Start Address 
LCD_Write_Com(0x00,0x53); LCD_Write_Data(0x01,0x3F); // Vertical GRAM Start Address 
LCD_Write_Com(0x00,0x60); LCD_Write_Data(0xA7,0x00); // Gate Scan Line 
LCD_Write_Com(0x00,0x61); LCD_Write_Data(0x00,0x01); // NDL,VLE, REV 
LCD_Write_Com(0x00,0x6A); LCD_Write_Data(0x00,0x00); // set scrolling line 
//-------------- Partial Display Control ---------// 
LCD_Write_Com(0x00,0x80); LCD_Write_Data(0x00,0x00); 
LCD_Write_Com(0x00,0x81); LCD_Write_Data(0x00,0x00); 
LCD_Write_Com(0x00,0x82); LCD_Write_Data(0x00,0x00); 
LCD_Write_Com(0x00,0x83); LCD_Write_Data(0x00,0x00); 
LCD_Write_Com(0x00,0x84); LCD_Write_Data(0x00,0x00); 
LCD_Write_Com(0x00,0x85); LCD_Write_Data(0x00,0x00); 
//-------------- Panel Control -------------------// 
LCD_Write_Com(0x00,0x90); LCD_Write_Data(0x00,0x10); 
LCD_Write_Com(0x00,0x92); LCD_Write_Data(0x06,0x00); 
LCD_Write_Com(0x00,0x07); LCD_Write_Data(0x01,0x33); // 262K color and display ON 
}
else if(gLcdVersion==LCD_ILI9341)
{
	//************* Start Initial Sequence **********
	LCD_Write_Com8Bit  (0xCF);
	LCD_Write_Data8Bit (0x00);
	LCD_Write_Data8Bit (0xC1);
	LCD_Write_Data8Bit (0X30);

	LCD_Write_Com8Bit  (0xED);
	LCD_Write_Data8Bit (0x64);
	LCD_Write_Data8Bit (0x03);
	LCD_Write_Data8Bit (0X12);
	LCD_Write_Data8Bit (0X81);

	LCD_Write_Com8Bit  (0xE8);
	LCD_Write_Data8Bit (0x85);
	LCD_Write_Data8Bit (0x10);
	LCD_Write_Data8Bit (0x7A);

	LCD_Write_Com8Bit  (0xCB);
	LCD_Write_Data8Bit (0x39);
	LCD_Write_Data8Bit (0x2C);
	LCD_Write_Data8Bit (0x00);
	LCD_Write_Data8Bit (0x34);
	LCD_Write_Data8Bit (0x02);

	LCD_Write_Com8Bit  (0xF7);
	LCD_Write_Data8Bit (0x20);

	LCD_Write_Com8Bit  (0xEA);
	LCD_Write_Data8Bit (0x00);
	LCD_Write_Data8Bit (0x00);

	LCD_Write_Com8Bit  (0xC0);    //Power control
	LCD_Write_Data8Bit (0x21);   //VRH[5:0]

	LCD_Write_Com8Bit  (0xC1);    //Power control
	LCD_Write_Data8Bit (0x13);   //SAP[2:0];BT[3:0]

	LCD_Write_Com8Bit  (0xC5);    //VCM control
	LCD_Write_Data8Bit (0x32);
	LCD_Write_Data8Bit (0x3C);

	LCD_Write_Com8Bit  (0xC7);    //VCM control2
	LCD_Write_Data8Bit (0X98);

	LCD_Write_Com8Bit  (0x36);    //ʾ  Memory Access Control
	LCD_Write_Data8Bit (0x08);// ԭϽ

	LCD_Write_Com8Bit  (0x3A);
	LCD_Write_Data8Bit (0x55);//16Bit

	LCD_Write_Com8Bit  (0xB1);
	LCD_Write_Data8Bit (0x00);
	LCD_Write_Data8Bit (0x16);

	LCD_Write_Com8Bit  (0xB6);    // Display Function Control
	LCD_Write_Data8Bit (0x0A);
	LCD_Write_Data8Bit (0xA2);

	LCD_Write_Com8Bit  (0xF6);
	LCD_Write_Data8Bit (0x01);
	LCD_Write_Data8Bit (0x30);

	LCD_Write_Com8Bit  (0xF2);
	LCD_Write_Data8Bit (0x00);

	LCD_Write_Com8Bit  (0x26);    //Gamma curve selected
	LCD_Write_Data8Bit (0x01);

	LCD_Write_Com8Bit  (0xE0);    //Set Gamma
	LCD_Write_Data8Bit (0x0F);
	LCD_Write_Data8Bit (0x1E);
	LCD_Write_Data8Bit (0x1B);
	LCD_Write_Data8Bit (0x0B);
	LCD_Write_Data8Bit (0x0E);
	LCD_Write_Data8Bit (0x08);
	LCD_Write_Data8Bit (0x47);
	LCD_Write_Data8Bit (0XB7);
	LCD_Write_Data8Bit (0x37);
	LCD_Write_Data8Bit (0x0B);
	LCD_Write_Data8Bit (0x14);
	LCD_Write_Data8Bit (0x05);
	LCD_Write_Data8Bit (0x0C);
	LCD_Write_Data8Bit (0x07);
	LCD_Write_Data8Bit (0x00);

	LCD_Write_Com8Bit  (0XE1);    //Set Gamma
	LCD_Write_Data8Bit (0x00);
	LCD_Write_Data8Bit (0x21);
	LCD_Write_Data8Bit (0x24);
	LCD_Write_Data8Bit (0x04);
	LCD_Write_Data8Bit (0x11);
	LCD_Write_Data8Bit (0x07);
	LCD_Write_Data8Bit (0x38);
	LCD_Write_Data8Bit (0x48);
	LCD_Write_Data8Bit (0x48);
	LCD_Write_Data8Bit (0x04);
	LCD_Write_Data8Bit (0x0B);
	LCD_Write_Data8Bit (0x0A);
	LCD_Write_Data8Bit (0x33);
	LCD_Write_Data8Bit (0x38);
	LCD_Write_Data8Bit (0x0F);

	LCD_Write_Com8Bit  (0x11);    //Exit Sleep
	Delay(280);
	LCD_Write_Com8Bit  (0x29);    //Display on
}
else //if(gLcdVersion==LCD_ST7789)
{
	//--------------------------------ST7789S Frame rate setting----------------------------------//
	LCD_Write_Com8Bit(0xb2);
	LCD_Write_Data8Bit(0x0c);
	LCD_Write_Data8Bit(0x0c);
	LCD_Write_Data8Bit(0x00);
	LCD_Write_Data8Bit(0x33);
	LCD_Write_Data8Bit(0x33);

	LCD_Write_Com8Bit(0xb7);
	LCD_Write_Data8Bit(0x35);


	LCD_Write_Com8Bit  (0x36);  //ʾ  Memory Access Control
	LCD_Write_Data8Bit (0x00);	//

	LCD_Write_Com8Bit(0x3A);
	LCD_Write_Data8Bit(0x55);//65K RGB color 16BIT
	//---------------------------------ST7789S Power setting--------------------------------------//
	LCD_Write_Com8Bit(0xbb);
	LCD_Write_Data8Bit(0x30);//vcom

	LCD_Write_Com8Bit(0xc3);
	LCD_Write_Data8Bit(0x20);//17ǳ


	LCD_Write_Com8Bit(0xc4);

	LCD_Write_Data8Bit(0x1E);//25

	LCD_Write_Com8Bit(0xc6);
	LCD_Write_Data8Bit(0x04);//82HZ

	LCD_Write_Com8Bit(0xd0);
	LCD_Write_Data8Bit(0xa4);
	LCD_Write_Data8Bit(0xa2);
	//--------------------------------ST7789S gamma setting---------------------------------------//
	LCD_Write_Com8Bit(0xe0);
	LCD_Write_Data8Bit(0xf0);
	LCD_Write_Data8Bit(0x00);
	LCD_Write_Data8Bit(0x0a);
	LCD_Write_Data8Bit(0x10);
	LCD_Write_Data8Bit(0x12);
	LCD_Write_Data8Bit(0x1b);
	LCD_Write_Data8Bit(0x39);
	LCD_Write_Data8Bit(0x44);
	LCD_Write_Data8Bit(0x47);
	LCD_Write_Data8Bit(0x28);
	LCD_Write_Data8Bit(0x12);
	LCD_Write_Data8Bit(0x10);
	LCD_Write_Data8Bit(0x16);
	LCD_Write_Data8Bit(0x1b);

	LCD_Write_Com8Bit(0xe1);
	LCD_Write_Data8Bit(0xf0);
	LCD_Write_Data8Bit(0x00);
	LCD_Write_Data8Bit(0x0a);
	LCD_Write_Data8Bit(0x10);
	LCD_Write_Data8Bit(0x11);
	LCD_Write_Data8Bit(0x1a);
	LCD_Write_Data8Bit(0x3b);
	LCD_Write_Data8Bit(0x34);
	LCD_Write_Data8Bit(0x4e);
	LCD_Write_Data8Bit(0x3a);
	LCD_Write_Data8Bit(0x17);
	LCD_Write_Data8Bit(0x16);
	LCD_Write_Data8Bit(0x21);
	LCD_Write_Data8Bit(0x22);

	LCD_Write_Com8Bit(0x3a);
	LCD_Write_Data8Bit(0x55); //18 RGB ,55-16BIT RGB

	//************************
	LCD_Write_Com8Bit(0x11);
	Delay(120);      //Delay 120ms

	LCD_Write_Com8Bit(0x29); //display on
	LCD_Write_Com8Bit(0x2c);
}
SetCS(1); //رƬѡʹ
}

void Address_set(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2) 
{ 
	if(gLcdVersion==LCD_ILI9325)
	{
		LCD_Write_Com(0x00, 0x20); LCD_Write_Data(x1 >> 8, x1); //Xλ 
		LCD_Write_Com(0x00, 0x21); LCD_Write_Data(y1 >> 8, y1); //Yλ 
		LCD_Write_Com(0x00, 0x50); LCD_Write_Data(x1 >> 8, x1); //ʼX 
		LCD_Write_Com(0x00, 0x52); LCD_Write_Data(y1 >> 8, y1); //ʼY 
		LCD_Write_Com(0x00, 0x51); LCD_Write_Data(x2 >> 8, x2); //X 
		LCD_Write_Com(0x00, 0x53); LCD_Write_Data(y2 >> 8, y2); //Y 
		LCD_Write_Com(0x00, 0x22); 
	}
	else
	{
		LCD_Write_Com8Bit  (0x2A);
		LCD_Write_Data16Bit(x1);//ʼX
		LCD_Write_Data16Bit(x2);//X
		LCD_Write_Com8Bit  (0x2B);
		LCD_Write_Data16Bit(y1);//ʼY
		LCD_Write_Data16Bit(y2);//Y
		LCD_Write_Com8Bit  (0x2C);
	}
} 

void LCD_Pant(u16 color) 
{ 
int i, j; 
SetCS(0); //Ƭѡʹ 
Address_set(0,0,239,319); 
for(i = 0; i < 320; i++) 
{ 
for (j = 0; j < 240; j++) 
{ 
LCD_Write_Data(color>>8, color); 
} 
} 
SetCS(1); //رƬѡʹ 
} 

void LCD_DrawPoint(u8 x,u16 y,u16 color)
{
//u16 x_start,y_start;
SetCS(0); //Ƭѡʹ 
//x_start = LCD_Width-y;
//y_start = x;
Address_set(x,y,x+1,y+1); 
LCD_Write_Data(color>>8, color); 
SetCS(1); //رƬѡʹ 
}

//ͼСΪ64*64
void LCD_DrawPicture(u8 x,u16 y,u8* pBuf,u16 F_Color,u16 B_Color)
{
u8 i,j,k,m_var0;
SetCS(0); //Ƭѡʹ 
Address_set(x,y,x+63,y+63); 
for(i=0;i<64;i++)
{
    for(j=0;j<8;j++)
	{
	m_var0=*(pBuf+8*i+j);
	for(k=0;k<8;k++)
	     {
		if((m_var0&(0x01<<k))!=0)
		    {
			LCD_Write_Data(F_Color>>8, F_Color); 
		    }
		else
		   {
		    	LCD_Write_Data(B_Color>>8, B_Color); 
		   }
	     }
	}

}
SetCS(1); //رƬѡʹ 
}

void LCD_en(u8 x,u16 y,u8 ch,u16 ch_color,u16 bg_color,u8 transparent)
{
 	u8 i,j,var0;
	u8* pic;
	ch-=32;
	pic=(u8*)CHARLIB[ch];
	SetCS(0); //Ƭѡʹ 
	Address_set(x,y,(x+7),(y+15)); 
	for(i=0;i<16;i++)
	{
      var0=*(pic+i);
	  for(j=0;j<8;j++)
	  {
		if((var0&(0x01<<j))!=0)
		{
		LCD_Write_Data(ch_color>>8, ch_color); 
		}
		else
		{
		LCD_Write_Data(bg_color>>8, bg_color); 
		}
	  }
	}
	SetCS(1); //رƬѡʹ 
}

void LCD_String(u8 x,u16 y,u8* ch,u16 ch_color,u16 bg_color)
{
    while((*ch)!='\0')
    	{
    	  LCD_en(x,y+1,*ch,ch_color,bg_color,0);
	      ch++;
	      x+=8;
    	}
}

void LCD_DrawRectangle(u16 x1,u16 y1,u16 x2,u16 y2,u16 color)
{
int i, j; 
SetCS(0); //Ƭѡʹ 
Address_set(x1,y1,x2,y2); 
for(i = x1; i <= x2; i++) 
{ 
for (j =y1; j <= y2; j++) 
{ 
LCD_Write_Data(color>>8, color); 
} 
}
SetCS(1); //رƬѡʹ 
}

void LCD_DispChar(u8 x,u16 y,u8 *ch,u16 F_Color,u16 B_Color)
{
u8 i,j,k,m_var0;

SetCS(0); //Ƭѡʹ 
Address_set(x,y,x+31,y+31); 
for(i=0;i<32;i++)
{
    for(j=0;j<4;j++)
	{
	m_var0=*(ch+4*i+j);
	for(k=0;k<8;k++)
	     {
		if((m_var0&(0x01<<k))!=0)
		    {
			LCD_Write_Data(F_Color>>8, F_Color); 
		    }
		else
		   {
		    	LCD_Write_Data(B_Color>>8, B_Color); 
		   }
	     }
	}

}

SetCS(1); //رƬѡʹ 
}

void LCD_3g(u16 x,u16 y,u32 num,u16 ch_color,u16 bg_color)
{
 u8 temp[3],i=0;
 	if(num>32767)
	{
	num	=	65536-num;
	LCD_en(x,y,'-',ch_color,bg_color,0);
	}
	else
	{
	LCD_en(x,y,' ',ch_color,bg_color,0);
	}
   for(i=0;i<3;i++)
   	{
   	temp[i]=num%10+48;
	num/=10;
	}
   	LCD_en(x+8,y,temp[2],ch_color,bg_color, 0);
	LCD_en((x+16),y,temp[1],ch_color,bg_color, 0);
	LCD_en((x+24),y,temp[0],ch_color,bg_color, 0);

}
//2147483647
//4294967296
void LCD_5g(u16 x,u16 y,u32 num,u16 ch_color,u16 bg_color,u8 transparent)
{
 u8 temp[5],i=0;
 	if(num>2147483647)
	{
	num	=	4294967296-num;
	LCD_en(x,y,'-',ch_color,bg_color,transparent);
	}
	else
	{
	LCD_en(x,y,' ',ch_color,bg_color,transparent);
	}
   for(i=0;i<5;i++)
   	{
   	temp[i]=num%10+48;
	num/=10;
	}
   	LCD_en(x+8,y,temp[4],ch_color,bg_color, transparent);
	LCD_en((x+16),y,temp[3],ch_color,bg_color, transparent);
	LCD_en((x+24),y,temp[2],ch_color,bg_color, transparent);
	LCD_en((x+32),y,temp[1],ch_color,bg_color, transparent);
	LCD_en((x+40),y,temp[0],ch_color,bg_color, transparent);
}

void LCD_8g(u16 x,u16 y,u32 num,u16 ch_color,u16 bg_color,u8 transparent)
{
 	u8 temp[9],i=0,flag=0;
	u8 NumSign=0;	//01Ǹ
 	if(num>2147483647)
	{
	num	=	4294967296-num;
	NumSign	=	1;
	}

   	for(i=0;i<8;i++)
   	{
   	temp[i]=num%10+48;
	num/=10;
	}
	
	temp[8]=' ';
	for(i=8;i>0;i--)
	{
		if((temp[i-1]!=48)&&(flag==0))
		{
		if(NumSign==1)temp[i]='-';
		flag=1;
		}
		else if((flag==0)&&(i>1))
		{
		temp[i-1]=' ';
		}
		else if(temp[0]==48)
		{
		temp[0]='0';
		}
	}
	LCD_en(x,y,temp[8],ch_color,bg_color, transparent);
   	LCD_en(x+8,y,temp[7],ch_color,bg_color, transparent);
	LCD_en((x+16),y,temp[6],ch_color,bg_color, transparent);
	LCD_en((x+24),y,temp[5],ch_color,bg_color, transparent);
	LCD_en((x+32),y,temp[4],ch_color,bg_color, transparent);
	LCD_en((x+40),y,temp[3],ch_color,bg_color, transparent);
	LCD_en((x+48),y,temp[2],ch_color,bg_color, transparent);
	LCD_en((x+56),y,temp[1],ch_color,bg_color, transparent);
	LCD_en((x+64),y,temp[0],ch_color,bg_color, transparent);
	
}


void LCD_4bit(u16 x,u16 y,u16 num,u16 ch_color,u16 bg_color,u8 transparent)
{
 u8 temp[4],i=0;
 
   for(i=0;i<5;i++)
   	{
   	temp[i]=num%10+48;
	num/=10;
	}


  for(i=3;i>0;i--)
   	{
   	if(temp[i]==48)temp[i]=32;//32ǿո
   	else
   	{break;}
   	}

	  
   	LCD_en(x,y,temp[3],ch_color,bg_color,transparent);
	LCD_en((x+8),y,temp[2],ch_color,bg_color,transparent);
	LCD_en((x+16),y,temp[1],ch_color,bg_color,transparent);
	LCD_en((x+24),y,temp[0],ch_color,bg_color,transparent);
}

void LCD_5bit(u16 x,u16 y,u16 num,u16 ch_color,u16 bg_color)
{
 u8 temp[5],i=0;
 
   for(i=0;i<5;i++)
   	{
   	temp[i]=num%10+48;
	num/=10;
	}
   	LCD_en(x,y,temp[4],ch_color,bg_color,0);
	LCD_en((x+8),y,temp[3],ch_color,bg_color,0);
	LCD_en((x+16),y,temp[2],ch_color,bg_color,0);
	LCD_en((x+24),y,temp[1],ch_color,bg_color,0);
	LCD_en((x+32),y,temp[0],ch_color,bg_color,0);
}

u8 g_RollLine=0;
u8 g_RollRow=0;//g_RollLineУg_RollRow
u8 g_FlashState=0;

void LCD_LineBreak(void)
{

	//
	g_RollLine++;
	if(g_RollLine>10)
	{
	g_RollLine=0;
	g_FlashState=1;
	}
	//
	g_RollRow=0;
	return 1;
}


void LCD_RollString(u8* ch,u16 ch_color,u16 bg_color,u8 linebreak,u8 transparent)
{
    u8 x=0;
	  if(g_FlashState==1){LCD_Pant(bg_color);g_FlashState=0;}
    while((*ch)!='\0')
    	{
    	  LCD_en(g_RollRow,g_RollLine*16+1,*ch,ch_color,bg_color,transparent);
	      ch++;
	      g_RollRow+=8;
    	}
	if(linebreak==1)
		{
		LCD_LineBreak();
		}

}

void LCD_Roll5bit(u16 num,u16 ch_color,u16 bg_color,u8 linebreak,u8 transparent)
{
 u8 temp[5],i=0;
   if(g_FlashState==1){LCD_Pant(bg_color);g_FlashState=0;}
   for(i=0;i<5;i++)
   	{
   	temp[i]=num%10+48;
	num/=10;
	}
   for(i=0;i<5;i++)
   	{
   	LCD_en(g_RollRow,g_RollLine*16+1,temp[4-i],ch_color,bg_color,transparent);
	g_RollRow+=8;
   	}
   if(linebreak==1)
   	{
   	LCD_LineBreak();
   	}
}

void LCD_cn(u8 x,u16 y,u8* pic,u16 ch_color,u16 bg_color,u8 transparent)
{
 	u8 i,j,var0,k,z=0;
	
	SetCS(0); //Ƭѡʹ 
	for(i=0;i<32;i++)
	{
	k=i;
      	var0=*(pic+i);
	if(i>=16){z=8;k-=16;}
	for(j=0;j<8;j++)
	 	{
		if((var0&(0x01<<j))!=0){LCD_DrawPoint(x+j+z,y+k, ch_color);}
		else{if(transparent !=1){LCD_DrawPoint(x+j+z,y+k, bg_color);}}//transparentΪ1͸
		}
	}
	SetCS(1); //رƬѡʹ 
}

#endif
#ifdef _GETCHOICEBOX_
 #ifndef ____CHARACTER_EXT
 #define ____CHARACTER_EXT
 #include "charcter.h"
void LCD_Display4Chioce(void)
{
	LCD_DrawRectangle(27,65,96,134,YELLOW);
	LCD_DrawRectangle(27,176,96,245,YELLOW);
	LCD_DrawRectangle(143,176,212,245,YELLOW);
	LCD_DrawRectangle(143,65,212,134,YELLOW);
	//
	LCD_DispChar(46,84,Char_A,BLACK,YELLOW);
	LCD_DispChar(162,84,Char_B,BLACK,YELLOW);
	LCD_DispChar(46,195,Char_C,BLACK,YELLOW);
	LCD_DispChar(162,195,Char_D,BLACK,YELLOW);
}
 #endif
#endif
#ifdef _SETLCDLINE_
#ifndef __LCD_LINE_EXISTS_
#define __LCD_LINE_EXISTS_
//abֵ
void Swap_Int(int *a,int *b)
{
	*a^=*b;	*b^=*a;	*a^=*b;
}
void LCD_DrawLine( int x1, int y1, int x2, int y2, u16 color,u8 size)
{
  int x,y;
  if(size)size-=1;
  int dx = abs(x2 - x1),
       dy = abs(y2 - y1),
       yy = 0;
  if(dx < dy)
  {
    yy = 1;
    Swap_Int(&x1, &y1);    Swap_Int(&x2, &y2);    Swap_Int(&dx, &dy);
  }
  int ix = (x2 - x1) > 0 ? 1 : -1, iy = (y2 - y1) > 0 ? 1 : -1,
       cx = x1, cy = y1, n2dy = dy * 2, n2dydx = (dy - dx) * 2, d = dy * 2 - dx;
  while(cx != x2)
	{
  	if(d < 0) { d += n2dy;  }
   	else
   	{
   		cy += iy;	d += n2dydx;
   	}
   	if(yy)	{x=cy;y=cx;	}//ֱ x ļнǴ45
   	else {x=cx;y=cy;}//ֱ x ļнС45
   	//LCD_DrawPoint(x, y, color);
   	LCD_DrawRectangle(x, y, x+size, y+size, color);//7(x,-y)4
   	cx += ix;
	}
}
//Ƕת /180Ƕ
//ȱǶ 180/С 
//y = kx + b
//b=y1-kx1
//y2-y1=k*(x2-x1)->y2=y1+k*(x2-x1)=k*x2+b->
//k=tanA=(y2-y1)/(x2-x1).
void LCD_Line( int x1, int y1, int angle, int lenght, u16 color,u8 size)
{
	float a;int x2,y2,x3,y3;
	angle%=360;
	switch(angle)
	{
		case 0:			y2=y1;x2=x1+lenght;		break;		
		case 180:		y2=y1;x2=x1-lenght;		break;
		case 90:			y2=y1-lenght;x2=x1;		break;
		case 270:		y2=y1+lenght;x2=x1;		break;
		default:
		angle=360-angle;
		a=angle*3.14159265/180;//תɻ
		y2=y1+lenght*(sin(a)*1000)/1000;x2=x1+lenght*(cos(a)*1000)/1000;
		break;
	}
	if(x2<0)x2=0;if(y2<0)y2=0;
	if(x2>=240)x2=240;if(y2>=320)y2=320;
	LCD_DrawLine(x1, y1,x2,y2,color,size);
}
#endif//__LCD_LINE_EXISTS_
#endif//_SETLCDLINE_
