#include "HardwareInfo.c"
#include "JMLib.c"
#include <SetLCDBack.h>
#include <SetDisplayString.h>
#include <SetRFPassWord.h>
#include <GetRFModuleRemoteGravity.h>
#include <SetDisplayVar.h>

int main(void)
{
    E2RCU_Init();
    int gx = 0;
    int gy = 0;
    int gz = 0;
    SetLCDBack(ON);
    SetDisplayString(1, "P1", YELLOW, BLACK);
    SetDisplayString(2, "Remote Gravity", YELLOW, BLACK);
    SetRFPassWord(_P1_, 1234567);
    SetDisplayString(3, "gx:", YELLOW, BLACK);
    SetDisplayString(4, "gy:", YELLOW, BLACK);
    SetDisplayString(5, "gz:", YELLOW, BLACK);
    while (1)
    {
        gx = GetRFModuleRemoteGravity(_P1_, 1);
        SetDisplayVar(3, gx, YELLOW, BLACK);
        gy = GetRFModuleRemoteGravity(_P1_, 2);
        SetDisplayVar(4, gy, YELLOW, BLACK);
        gz = GetRFModuleRemoteGravity(_P1_, 3);
        SetDisplayVar(5, gz, YELLOW, BLACK);
    }
    return 1;
}

