﻿#include "stm32f0xx.h"
#include "stm32f0xx_hal.h"
#include "jmkernel.h"

#ifdef _SETBLUETOOTHDATA_
 #ifndef  _SETBLUETOOTHDATA_EXISTS_
  #define _SETBLUETOOTHDATA_EXISTS_
 #include <jmkernel.h>

void SetBluetoothData(uint8_t data)
{
	BluetoothSendData(data);	
}
 #endif
#endif

#ifdef _GETBLUETOOTHDATA_
 #ifndef  _GETBLUETOOTHDATA_EXISTS_
  #define _GETBLUETOOTHDATA_EXISTS_
 #include <jmkernel.h>

uint8_t GetBluetoothData(void)
{
	return BluetoothReceiveData();	
}
 #endif
#endif

#ifdef _GETBLUETOOTHCONTROL_
 #ifndef  _GETBLUETOOTHCONTROL_EXISTS_
 #define  _GETBLUETOOTHCONTROL_EXISTS_
 #include <jmkernel.h>

uint32_t GetBluetoothControl(void)
{//读蓝牙手柄键码
	return BluetoothPhoneControl();	
}
 #endif
#endif

#ifdef _GETBLUETOOTHCONTROLDATA_
 #ifndef  _GETBLUETOOTHCONTROLDATA_EXISTS_
 #define  _GETBLUETOOTHCONTROLDATA_EXISTS_
 #include <jmkernel.h>

uint8_t GetBluetoothControlData(void)
{//读蓝牙手柄键值
  uint8_t key;
  uint32_t PhoneKey;  
  PhoneKey = BluetoothPhoneControl();
  switch(PhoneKey)
  {
    case 0x02:  key=1;
    break;
    case 0x04:  key=2;
    break;
    case 0x08:  key=3;
    break;
    case 0x10:  key=4;
    break;
    case 0x20:  key=5;
    break;
    case 0x40:  key=6;
    break;
    case 0x80:  key=7;
    break;
    case 0x100: key=8;
    break;
    default :   key=0;
    break;
  }
  return key;
}
 #endif
#endif

#ifdef _SETMOTORPOWER_
 #ifndef  _SETMOTORPOWER_EXISTS_
 #define _SETMOTORPOWER_EXISTS_
 #include <jmkernel.h>
extern int g_MotorPowerFlag;
extern int g_M1SpeedPer;
extern int g_M2SpeedPer;

void SetMotorPower(int m_Per1,int m_Per2)////调节输出马达功率
{
	g_MotorPowerFlag=1;
	g_M1SpeedPer=m_Per1;//M1
	g_M2SpeedPer=m_Per2;//M2
}
 #endif
#endif

#ifdef _SETMOTOR_
 #ifndef  _SETMOTOR_EXISTS_
 #define _SETMOTOR_EXISTS_
 #include <jmkernel.h>
extern int g_MotorPowerFlag;
extern int g_M1SpeedPer;
extern int g_M2SpeedPer;

void SetMotor(uint8_t which,int speed)
{
	uint8_t m_speedper;
	if(g_MotorPowerFlag)//读取马达功率
	{
		switch(which)
		{
			case 1:m_speedper=g_M1SpeedPer;break;
			case 2:m_speedper=g_M2SpeedPer;break;
		}
	}
	if(g_MotorPowerFlag)speed=m_speedper*speed/100;
	Setmotorspeed(which,speed);
	functionsfinish();
}
 #endif
#endif

#ifdef _SETWAITFORLIGHTER_
#ifndef  _SETWAITFORLIGHTER_EXISTS_
#define _SETWAITFORLIGHTER_EXISTS_
#include <jmkernel.h>

void SetWaitforLighter(uint8_t which,uint16_t value)
{//等待光电传感器检测数值增加设定范围值，才执行该图标后的程序
	uint16_t i,temp;
	temp = readADC(which);
	do
	{
    	i=readADC(which);
	}while(i<(temp-value));
	functionsfinish();
}
 #endif
#endif

#ifdef _SETWAITFORDARKER_
#ifndef  _SETWAITFORDARKER_EXISTS_
#define _SETWAITFORDARKER_EXISTS_
#include <jmkernel.h>

void SetWaitforDarker(uint8_t which,uint16_t value)
{//等待光电传感器检测数值减少设定范围值，才执行该图标后的程序
	uint16_t i,temp;
	temp = readADC(which);
	do
	{
    	i=readADC(which);
	}while(i>(temp-value));
	functionsfinish();
}
 #endif
#endif

#ifdef _SETWAITFORLIGHT_
#ifndef  _SETWAITFORLIGHT_EXISTS_
#define _SETWAITFORLIGHT_EXISTS_
#include <jmkernel.h>

void SetWaitforLight(uint8_t which,uint16_t value)
{//等待光电传感器检测数值大于设定界线值，才执行该图标后的程序
	uint16_t i;
	do
	{
    	i=readADC(which);
	}while(i>value);
    functionsfinish();
}
 #endif
#endif

#ifdef _SETWAITFORDARK_
#ifndef  _SETWAITFORDARK_EXISTS_
#define _SETWAITFORDARK_EXISTS_
#include <jmkernel.h>

void SetWaitforDark(uint8_t which,uint16_t value)
{//等待光电传感器检测数值小于设定界线值，才执行该图标后的程序
	uint16_t i;
	do
	{
    	i=readADC(which);
	}while(i>value);
    functionsfinish();
}
 #endif
#endif

#ifdef _GETLIGHTSENSOR_
#ifndef  _GETLIGHTSENSOR_EXISTS_
#define _GETLIGHTSENSOR_EXISTS_
#include <jmkernel.h>

uint16_t GetLightSensor(uint8_t which)
{   //读传感器数据，返回ADC值	
    functionsfinish();
	return readADC(which);
}
 #endif
#endif

#ifdef _SETLIGHTSENSORTHRESHOLD_
#ifndef  _SETLIGHTSENSORTHRESHOLD_EXISTS_
#define _SETLIGHTSENSORTHRESHOLD_EXISTS_
 #include <jmkernel.h>
void SetLightSensorThreshold(uint8_t which,uint16_t Threshold)
{	//修改光电比较值
	WriteEEP(100+which,Threshold);
	functionsfinish();	
}
 #endif
#endif

#ifdef _GETLIGHTSENSORTHRESHOLD_
#ifndef  _GETLIGHTSENSORTHRESHOLD_EXISTS_
#define _GETLIGHTSENSORTHRESHOLD_EXISTS_
 #include <jmkernel.h>
int GetLightSensorThreshold(uint8_t which)
{	//读取光电比较值
    functionsfinish();	
	return ReadEEP(100+which);
}
 #endif
#endif

#ifdef _GETLIGHTSENSORDATA_
#ifndef  _GETLIGHTSENSORDATA_EXISTS_
#define _GETLIGHTSENSORDATA_EXISTS_
 #include <jmkernel.h>
uint16_t GetLightSensorData(uint8_t which)
{	//读传感器数据，返回判断值
    functionsfinish();	
	if(readADC(which)>ReadEEP(100+which)) return 0;
	else return 1;
}
 #endif
#endif

#ifdef _SET3CLED_
 #ifndef  _SET3CLED_EXISTS_
  #define _SET3CLED_EXISTS_
 #include <jmkernel.h>
 
uint32_t LED_RED=0x00FF0001;//红色
uint32_t LED_GREEN=0xFF000002;//绿色
uint32_t LED_BLUE=0x0000FF03;//蓝色
uint32_t LED_YELLOW=0xFFFF0004;//黄色
uint32_t LED_VIOLET=0x00FFFF05;//紫色
uint32_t LED_BLUENESS=0xFF00FF06;//青色
uint32_t LED_WHITE=0xFFFFFF07;//白色
uint32_t L=0x000000FF;//亮度

uint32_t COLOR[5];
uint8_t COLORflag=0;

uint8_t NOWwhich=0;
uint16_t NOWColor=0;
void Set3CLed(uint8_t which,uint16_t Color)
{
	uint8_t i;
	if(COLORflag==0){
		for(i=0;i<5;i++)COLOR[i]=0;
		COLORflag=1;
	}
	if(NOWwhich!=which||NOWColor!=Color)
	{
	NOWwhich=which;
	NOWColor=Color;
	if(Color==1){COLOR[which-1]=LED_RED;}
	else if(Color==2){COLOR[which-1]=LED_GREEN;}
	else if(Color==3){COLOR[which-1]=LED_BLUE;}
	else if(Color==4){COLOR[which-1]=LED_YELLOW;}
	else if(Color==5){COLOR[which-1]=LED_VIOLET;}
	else if(Color==6){COLOR[which-1]=LED_BLUENESS;}
	else if(Color==7){COLOR[which-1]=LED_WHITE;}
	else if(Color==0){COLOR[which-1]=0;}
	Send_IC_Code_Reset();
	__disable_irq();
	Send_LEDData_32Bits(COLOR[0]);
	Send_LEDData_32Bits(COLOR[1]);
	Send_LEDData_32Bits(COLOR[2]);
	Send_LEDData_32Bits(COLOR[3]);
	Send_LEDData_32Bits(COLOR[4]);
	__enable_irq();
	}
	functionsfinish();
}
 #endif
#endif

#ifdef _SETRGB_
#ifndef  _SETRGB_EXISTS_
#define _SETRGB_EXISTS_
#include <jmkernel.h>
//设置5个RGB灯的颜色；
void SetRGB(uint32_t RGB1,uint32_t RGB2,uint32_t RGB3,uint32_t RGB4,uint32_t RGB5)
{
	uint32_t R,G,B;
	uint32_t COLOR1,COLOR2,COLOR3,COLOR4,COLOR5;
	B=RGB1&0xFF;G=RGB1&0xFF00;R=RGB1&0xFF0000;
	COLOR1=(G*0x10000)+R+(B*0x100);
	B=RGB2&0xFF;G=RGB2&0xFF00;R=RGB2&0xFF0000;
	COLOR2=(G*0x10000)+R+(B*0x100);
	B=RGB3&0xFF;G=RGB3&0xFF00;R=RGB3&0xFF0000;
	COLOR3=(G*0x10000)+R+(B*0x100);
	B=RGB4&0xFF;G=RGB4&0xFF00;R=RGB4&0xFF0000;
	COLOR4=(G*0x10000)+R+(B*0x100);
	B=RGB5&0xFF;G=RGB5&0xFF00;R=RGB5&0xFF0000;
	COLOR5=(G*0x10000)+R+(B*0x100);
	Send_IC_Code_Reset();
	__disable_irq();
	Send_LEDData_32Bits(COLOR1);
	Send_LEDData_32Bits(COLOR2);
	Send_LEDData_32Bits(COLOR3);
	Send_LEDData_32Bits(COLOR4);
	Send_LEDData_32Bits(COLOR5);
	__enable_irq();
	functionsfinish();
}
 #endif
#endif

#ifdef _SETWAITFORTIME_
 #ifndef  _SETWAITFORTIME_EXISTS_
  #define _SETWAITFORTIME_EXISTS_
 #include <jmkernel.h>

void SetWaitForTime(float a)
{
	HAL_Delay(a*800);
	functionsfinish();
}
 #endif
#endif

#ifdef _SETMUSIC_
 #ifndef  _SETMUSIC_EXISTS_
  #define _SETMUSIC_EXISTS_
 #include <jmkernel.h>
//改成音乐葫芦娃
int tune[] =		
{
	TONE_DH1,TONE_D6,TONE_D5,TONE_D6,TONE_0,  TONE_DH1,TONE_D6, TONE_D5, TONE_DH1,TONE_D6, TONE_0, TONE_D6,
	TONE_D6, TONE_D6,TONE_D5,TONE_D6,TONE_0,  TONE_D6, TONE_DH1,TONE_D6, TONE_D5, TONE_DH1,TONE_D6,TONE_0, 
	TONE_D1, TONE_D1,TONE_D3,TONE_D1,TONE_D1, TONE_D3, TONE_0,  TONE_D6, TONE_D6, TONE_D6, TONE_D5,TONE_D6,
	TONE_D5, TONE_D1,TONE_D3,TONE_0, TONE_DH1,TONE_D6, TONE_D6, TONE_D5, TONE_D6, TONE_D5, TONE_D1,TONE_D2,
	TONE_0,  TONE_D7,TONE_D7,TONE_D5,TONE_D3, TONE_D5, TONE_DH1,TONE_0,  TONE_D6, TONE_D6, TONE_D5,TONE_D5,
	TONE_D6, TONE_D6,TONE_0, TONE_D5,TONE_D1, TONE_D3, TONE_0,  TONE_DH1,TONE_0,  TONE_D6, TONE_D6,TONE_D5,
	TONE_D5, TONE_D6,TONE_D6,TONE_0, TONE_D5, TONE_D1, TONE_D2, TONE_0,  TONE_D3, TONE_D3, TONE_D1,TONE_DL6,
	TONE_D1, TONE_D3,TONE_D5,TONE_D6,TONE_D6, TONE_D3, TONE_D5, TONE_D6, TONE_D6, TONE_DH1,TONE_0, TONE_D7, 
	TONE_D5, TONE_D6
};//这部分就是整首曲子的音符部分
float duration[] =
{
	1,1,0.5,0.5,1,0.5,0.5,0.5,0.5,1,0.5,0.5,
	0.5,1,0.5,1,0.5,0.5,0.5,0.5,0.5,0.5,1,1,  
	1,1,1+1,0.5,1,1+0.5,1,1,1,0.5,0.5,1,
	0.5,1,1+0.5,1,0.5,0.5,0.5,0.5,1+1,
	0.5,1,1+0.5,1,1+1,0.5,0.5,1,1+1+1+1,
	0.5,0.5,0.5+0.25,0.25,0.5+0.25,0.25,0.5+0.25,0.25,
	0.5,1,0.5,1,1,
	0.5,0.5,0.5+0.25,0.25,0.5+0.25,0.25,0.5+0.25,0.25,
	0.5,1,0.5,1,1,1+1,0.5,0.5,1,1+1+1+1,
	0.5,1,0.5,1+1,0.5,1,0.5,1+1,1+1,0.5,0.5,1,
	1+1+1+1
};//这部分是整首曲子的节拍部分
int length;//这里定义一个变量，后面用来表示共有多少个音符

void setMusic(void)
{
	length = sizeof(tune)/sizeof(tune[0]);//这里用sizeof，可以查出tone序列里有多少个音符
	for(int x=0; x<length; x++)//循环音符的次数
	{
		BeepMusic(tune[x]);//此函数依次播放tune序列里的数组，即每个音符
		HAL_Delay(400*duration[x]);//每个音符持续的时间，即节拍duration，400是调整时间的越大，曲子速度越慢，越小曲子速度越快，自己掌握吧
	}
	Beep(OFF);
	functionsfinish();
}
 #endif
#endif

#ifdef   _GETLEFTBUTTON_
#ifndef  _GETLEFTBUTTON_EXISTS_
#define _GETLEFTBUTTON_EXISTS_
 #include <jmkernel.h>

uint8_t GetLeftButton(void)
{
	return key1;
}
#endif
#endif

#ifdef   _GETRIGHTBUTTON_
#ifndef  _GETRIGHTBUTTON_EXISTS_
#define _GETRIGHTBUTTON_EXISTS_
 #include <jmkernel.h>

uint8_t GetRightButton(void)
{
	return key2;
}
#endif
#endif

#ifdef _SETINBEEP_
 #ifndef  _SETINBEEP_EXISTS_
  #define _SETINBEEP_EXISTS_
 #include <jmkernel.h>

void SetInBeep(uint8_t state)
{
	Beep(state);
	functionsfinish();
}
 #endif
#endif

#ifdef _SETINSOUND_
 #ifndef  _SETINSOUND_EXISTS_
  #define _SETINSOUND_EXISTS_
 #include <jmkernel.h>
//蜂鸣器音乐
extern uint16_t BeeptimeNow;
extern uint16_t BeepHzNow;
void SetInSound(uint16_t BeepHz,uint16_t time)
{
	uint32_t i;
	if(time!=BeeptimeNow||BeepHz!=BeepHzNow)
	{
		BeepMusic(BeepHz);	
		HAL_Delay(time*10/14);
		Beep(OFF);
		BeeptimeNow=time;
		BeepHzNow=BeepHz;
	}
	functionsfinish();
}
 #endif
#endif

#ifdef _SETDATA_
 #ifndef  _SETDATA_EXISTS_
  #define _SETDATA_EXISTS_
 #include <jmkernel.h>
void SetData(uint16_t dataadr,uint16_t datacode)
{
	WriteEEP(dataadr,datacode);
	functionsfinish();
}
 #endif
#endif

#ifdef _GETDATA_
 #ifndef  _GETDATA_EXISTS_
  #define _GETDATA_EXISTS_
 #include <jmkernel.h>

uint16_t GetData(uint16_t dataadr)
{   
	functionsfinish();
	return ReadEEP(dataadr); 
}
 #endif
#endif

#ifdef _GETSYSTIME_
 #ifndef  _GETSYSTIME_EXISTS_
  #define _GETSYSTIME_EXISTS_
 #include <jmkernel.h>

uint32_t GetSysTime(void)
{
	functionsfinish();
	return GetSystemTime();
}
 #endif
#endif

#ifdef _SETSYSTIME_
 #ifndef  _SETSYSTIME_EXISTS_
  #define _SETSYSTIME_EXISTS_
 #include <jmkernel.h>

void SetSysTime(void)
{
	SetSystemTime();
	functionsfinish();
}
 #endif
#endif

#ifdef _SETMUSICADDDATA_
 #ifndef  _MUSICADDDATA_EXISTS_
  #define _MUSICADDDATA_EXISTS_
  #include <jmkernel.h>
	#include "jmmusic.h"
void Music_AddData(uint16_t Mdata,uint16_t delay_time)//保存频率以及播放时间
 {
	 if(LastMusicPos>MusicBufferSize-1)
	 {
		 LastMusicPos=MusicBufferSize-1;
	 }
	 else
	 {	
		 MusicData[LastMusicPos][0]=(uint16_t)Mdata;//0~60kHZ
		 MusicData[LastMusicPos][1]=(uint16_t)delay_time;//单位0.5ms
		 LastMusicPos++;
	 }
 }
 
  void SetMusicAddData(uint8_t mdata,int time)
  {
	MUSIC_typedef m_Music;
	InMusic_DataProcess(&m_Music, mdata, time);
	Music_AddData(m_Music.freq,m_Music.time);
  }
 #endif
#endif

#ifdef _SETNOTE_
 #ifndef  _SETNOTE_EXISTS_
  #define _SETNOTE_EXISTS_
  #include "jmmusic.h"
  void SetNote(int note)
  {//播放音符
		uint16_t freq;
		if(note==0)
		{
			Beep(OFF);
		}
		else
		{
			freq=NoteList[1][note-1];
			BeepMusic(freq);
		}
		functionsfinish();
  }
 #endif
#endif

#ifdef _GETRANDOM_
 #ifndef  _GETRANDOM_EXISTS_
  #define _GETRANDOM_EXISTS_
#include <jmkernel.h>
#define _MULTIPLIER 	0x015a4e35L 
#define _INCREMENT	 	1 
uint8_t g_GetRandomFirst=0;
int GetRandom(int m,int n)
{//生成min到max之间的随机数，并存储到所选的存储变量，有效范围0-32767
	static long seed;
	int rn=0,randn;
	if(g_GetRandomFirst==0)//第一次先设定随机种子
	{
		seed=GetSystemTime()+ReadMIC();
		HAL_Delay(1);
		seed=(GetSystemTime()+ReadMIC()+216)%0x8000;
		g_GetRandomFirst=1;
	}
	seed = _MULTIPLIER*seed + _INCREMENT; 
	randn=((int)(seed>>16) & 0x7fff); 
	rn=(int)(randn%(n-m+1)+m);//m~n随机数
	return((int)rn);
}
 #endif
#endif

#ifdef   _SETWAITFORQUIETER_
#ifndef  _SETWAITFORQUIETER_EXISTS_
#define _SETWAITFORQUIETER_EXISTS_
#include <jmkernel.h>

void SetWaitforQuieter(int value)
{//等待音量传感器检测数减少设定范围值，才执行该图标后的程序
    uint16_t temp,org;
	org=ReadMIC();
	do
	{
	temp=ReadMIC();
	}while(temp>(org-value));
	functionsfinish();
}
#endif
#endif

#ifdef   _SETWAITFORLOUDER_
#ifndef  _SETWAITFORLOUDER_EXISTS_
#define _SETWAITFORLOUDER_EXISTS_
#include <jmkernel.h>

void SetWaitforLouder(int value)
{//等待音量传感器检测数增加设定范围值，才执行该图标后的程序
    uint16_t temp,org;
	org=ReadMIC();
	do
	{
	temp=ReadMIC();
	}while(temp<(org+value));
	functionsfinish();
}
#endif
#endif

#ifdef   _SETWAITFORQUIET_
#ifndef  _SETWAITFORQUIET_EXISTS_
#define _SETWAITFORQUIET_EXISTS_
#include <jmkernel.h>

void SetWaitforQuiet(int value)
{//等待音量传感器检测数值小于设定界线值，才执行该图标后的程序
	uint16_t temp;
	do
	{
		temp=ReadMIC();
	}while(temp>value);
	functionsfinish();
}
#endif
#endif

#ifdef   _SETWAITFORLOUD_
#ifndef  _SETWAITFORLOUD_EXISTS_
#define _SETWAITFORLOUD_EXISTS_
#include <jmkernel.h>

void SetWaitforLoud(int value)
{//等待音量传感器检测数值大于设定界线值，才执行该图标后的程序
	uint16_t temp;
	do
	{
		temp=ReadMIC();
	}while(temp<value);
	functionsfinish();
}
#endif
#endif

#ifdef   _GETINMIC_
#ifndef  _GETINMIC_EXISTS_
#define _GETINMIC_EXISTS_
#include <jmkernel.h>

uint16_t GetInMic(void)
{
	//ADC_init();	
	functionsfinish();
	return ReadMIC();
}
#endif
#endif

#ifdef _GETTOUCH_
 #ifndef  _GETTOUCH_EXISTS_
  #define _GETTOUCH_EXISTS_
 #include <jmkernel.h>

uint16_t GetTouch(uint8_t which)
{
	functionsfinish();
	if(readADC(which)==0){return 1;}
	else return 0;
}
 #endif
#endif

#ifdef _SETLIGHTSENSORILAMP_
 #ifndef  _SETLIGHTSENSORILAMP_EXISTS_
  #define _SETLIGHTSENSORILAMP_EXISTS_
 #include <jmkernel.h>

void SetLightSensorILamp(uint8_t which,uint8_t ONOFF)
{
	onoff8LED(which,ONOFF);
	functionsfinish();
}
 #endif
#endif

#ifdef _GETIRCODE_
 #ifndef  _GETIRCODE_EXISTS_
  #define _GETIRCODE_EXISTS_
 #include <jmkernel.h>
extern uint32_t IRcode;
extern uint32_t ICcont;
uint32_t j=0;
uint32_t q=0;

uint8_t GetIRCode(void)
{
	uint32_t n;
	uint32_t i=0,rn=0,tmp=0;
	for(q=0;q<8;q++)
	{
	if(ICcont>=32)
	{
	n=IRcode;
	for(i=0;i<32;i++)
	{
		rn<<=1;
		rn+=(n&0x01);
		n>>=1;	
	}
	j++;
	if(j==8){IRcode=0;j=0;}
	}
	}
	return (rn/0x10000)%0x100;
}
 #endif
#endif

#ifdef _SETMOTORSERVO_
 #ifndef  _SETMOTORSERVO_EXISTS_
  #define _SETMOTORSERVO_EXISTS_
 #include <jmkernel.h>

void SetMotorServo(uint8_t which,uint8_t angle)
{
	Servo(which,angle);
	functionsfinish();
}
 #endif
#endif

#ifdef _GETULTRASOUND_
 #ifndef  _GETULTRASOUND_EXISTS_
  #define _GETULTRASOUND_EXISTS_
 #include <jmkernel.h>
#define _ULTRASOUND_ADDR_		0X04
uint16_t GetUltrasound(uint8_t which)
{
	uint32_t port1;
	uint32_t port2;
	uint8_t bit1;
	uint8_t bit2;

	uint16_t data;
	uint8_t	datah=0,datal=0,cmd=0,s=0,SUM=0;

	if(which==1)
	{
		port1=GPIOB;
		port2=GPIOB;
		bit1=14;
		bit2=13;
	}
	else if(which==2)
	{
		port1=GPIOB;
		port2=GPIOB;
		bit1=7;
		bit2=6;	
	}
	Soft_I2C_Typedef iic_typedef;
	Soft_I2C_BspInit(port2,bit2,//SDA
				   port1,bit1,//SCL
									   &iic_typedef);//设置引脚

	Soft_I2C_Start(&iic_typedef);//启动i2c
	Soft_I2C_Write(&iic_typedef,_ULTRASOUND_ADDR_);//写入一个字节数据
	
	Soft_I2C_Write(&iic_typedef,0xaa);//写入一个字节数据
	Soft_I2C_Stop(&iic_typedef);//停止i2c
	
	Soft_I2C_Start(&iic_typedef);//启动i2c
	Soft_I2C_Write(&iic_typedef,_ULTRASOUND_ADDR_+1);//写入编号＋1
	cmd=Soft_I2C_Read(&iic_typedef,0);	//数据开头
	datah=Soft_I2C_Read(&iic_typedef,0);	//数据高八位
	datal=Soft_I2C_Read(&iic_typedef,0);	//第八位
	s=Soft_I2C_Read(&iic_typedef,1);		//检验和，停止收数据
	Soft_I2C_Stop(&iic_typedef);//关闭i2c
	
	//OS_EXIT_CRITICAL();
	SUM=(uint8_t)(cmd+datah+datal);//校验
	if(SUM!=s)//错误数据
	{
		data=999;
	}
	else
	{
		return data=(uint16_t)(((uint16_t)datah<<8)|datal);	
	}
	functionsfinish();
}

 #endif
#endif

#ifdef _GETSHORTIRDIST_
 #ifndef  _GETSHORTIRDIST_EXISTS_
  #define _GETSHORTIRDIST_EXISTS_
 #include <jmkernel.h>
#define _IRULTRASOUND_ADDR_		0X06
uint16_t GetShortIRDist(uint8_t which)
{
	uint32_t port1;
	uint32_t port2;
	uint8_t bit1;
	uint8_t bit2;

	uint16_t data;
	uint8_t	datah=0,datal=0,cmd=0,s=0,SUM=0;
	
	uint16_t irdata[30];
	uint8_t i=0,j,t;
	
	if(which==1){
		port1=GPIOB;
		port2=GPIOB;
		bit1=14;
		bit2=13;
	}
	else if(which==2){
		port1=GPIOB;
		port2=GPIOB;
		bit1=7;
		bit2=6;	
	}
	Soft_I2C_Typedef iic_typedef;
	Soft_I2C_BspInit(port2,bit2,//SDA
				   port1,bit1,//SCL
									   &iic_typedef);//设置引脚
	for(i=0;i<3;i++)
	{		
	Soft_I2C_Start(&iic_typedef);//启动i2c
	Soft_I2C_Write(&iic_typedef,_IRULTRASOUND_ADDR_);//写入一个字节数据
	
	Soft_I2C_Write(&iic_typedef,0xaa);//写入一个字节数据
	Soft_I2C_Stop(&iic_typedef);//停止i2c
	
	Soft_I2C_Start(&iic_typedef);//启动i2c
	Soft_I2C_Write(&iic_typedef,_IRULTRASOUND_ADDR_+1);//写入编号＋1
	cmd=Soft_I2C_Read(&iic_typedef,0);	//数据开头
	datah=Soft_I2C_Read(&iic_typedef,0);	//数据高八位
	datal=Soft_I2C_Read(&iic_typedef,0);	//第八位
	s=Soft_I2C_Read(&iic_typedef,1);		//检验和，停止收数据
	Soft_I2C_Stop(&iic_typedef);//关闭i2c
	
	SUM=(uint8_t)(cmd+datah+datal);//校验
	
	irdata[i]=(uint16_t)(((uint16_t)datah<<8)|datal);
	}

	for(j=0;j<2;j++)
	{
		for(i=0;i<2-j;i++)
		{
			if(irdata[i]>irdata[i+1])
			{
				t=irdata[i];
				irdata[i]=irdata[i+1];
				irdata[i+1]=t;
			}
		}
	}
	
	if(SUM!=s)//错误数据
	{
		data=999;
	}
	else
	{
		//return data=(uint16_t)(((uint16_t)datah<<8)|datal);
		//return	irdata[10];	
		return	irdata[1];	
	}
	functionsfinish();
}
 #endif
#endif