#ifndef __jmkernel_H__
#define __jmkernel_H__

#ifdef __cplusplus
  extern "C" {
#endif

#include "stm32f0xx_hal.h"
#include "usb_device.h"
#include "app_eeprom.h"
#include "I2C_Soft.h"

//系统变量
ADC_HandleTypeDef hadc;
DMA_HandleTypeDef hdma_adc;
RTC_HandleTypeDef hrtc;//RTC时钟
TIM_HandleTypeDef htim2;//马达
TIM_HandleTypeDef htim16;//红外接收
UART_HandleTypeDef huart1;//串口
//jump
#define APPLICATION_ADDRESS4 (uint32_t)0x08010000
typedef  void (*pFunction)(void);
pFunction JumpToApplication;

//˿ڶ
#define _M1_ 1
#define _M2_ 2

#define _S1_ 1
#define _S2_ 2

#define _IIC1_ 1
#define _IIC2_ 2

#define _P1_ 1
#define _P2_ 2
#define _P3_ 3
#define _P4_ 4
#define _P5_ 5
#define _P6_ 6
#define _P7_ 7
#define _P8_ 8

#define _A1_ 1
#define _A2_ 2
#define _A3_ 3
#define _A4_ 4
#define _A5_ 5
#define _A6_ 6
#define _A7_ 7
#define _A8_ 8

#define _RGB1_ 1
#define _RGB2_ 2
#define _RGB3_ 3
#define _RGB4_ 4
#define _RGB5_ 5

//用户按键定义
#define key1 !HAL_GPIO_ReadPin(GPIOB,GPIO_PIN_12)
#define key2 !HAL_GPIO_ReadPin(GPIOA,GPIO_PIN_0)
//判断定义
#define ON 1
#define OFF 0
//彩灯定义
#define RED      1//红色
#define GREEN    2//绿色
#define BLUE     3//蓝色
#define YELLOW   4//黄色
#define VIOLET   5//紫色
#define BLUENESS 6//青色
#define WHITE    7//白色

//8位io口指示灯开
#define ON_LED1 GPIOA->BSRR = (uint32_t)GPIO_PIN_8;
#define ON_LED2 GPIOB->BSRR = (uint32_t)GPIO_PIN_15;
#define ON_LED3 GPIOB->BSRR = (uint32_t)GPIO_PIN_2;
#define ON_LED4 GPIOF->BSRR = (uint32_t)GPIO_PIN_1;
#define ON_LED5 GPIOF->BSRR = (uint32_t)GPIO_PIN_0;
#define ON_LED6 GPIOC->BSRR = (uint32_t)GPIO_PIN_15;
#define ON_LED7 GPIOC->BSRR = (uint32_t)GPIO_PIN_14;
#define ON_LED8 GPIOC->BSRR = (uint32_t)GPIO_PIN_13;
//8位io口指示灯?
#define OFF_LED1 GPIOA->BRR = (uint32_t)GPIO_PIN_8;
#define OFF_LED2 GPIOB->BRR = (uint32_t)GPIO_PIN_15; 
#define OFF_LED3 GPIOB->BRR = (uint32_t)GPIO_PIN_2;
#define OFF_LED4 GPIOF->BRR = (uint32_t)GPIO_PIN_1;
#define OFF_LED5 GPIOF->BRR = (uint32_t)GPIO_PIN_0;
#define OFF_LED6 GPIOC->BRR = (uint32_t)GPIO_PIN_15;
#define OFF_LED7 GPIOC->BRR = (uint32_t)GPIO_PIN_14;
#define OFF_LED8 GPIOC->BRR = (uint32_t)GPIO_PIN_13;
//三色灯逻辑电频与复位定?
#define Send_IC_Low_Code()    do{GPIOB->BSRR = (uint32_t)GPIO_PIN_9;__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();GPIOB->BRR = (uint32_t)GPIO_PIN_9;__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();}while(0)
#define Send_IC_High_Code()    do{GPIOB->BSRR = (uint32_t)GPIO_PIN_9;__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();GPIOB->BRR = (uint32_t)GPIO_PIN_9;__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();}while(0)
#define Send_IC_Code_Reset()  do{GPIOB->BRR = (uint32_t)GPIO_PIN_9;HAL_Delay(10);}while(0)
//系统函数声明
void SystemClock_Config(void);
void MX_GPIO_Init(void);
void MX_DMA_Init(void);
void MX_TIM16_Init(void);
void MX_USART1_UART_Init(void);
void MX_TIM2_Init(void);
void MX_ADC_Init(void);
void MX_RTC_Init(void);
void _Error_Handler(char *file, int line);
void assert_failed(uint8_t* file, uint32_t line);
void HAL_TIM_MspPostInit(TIM_HandleTypeDef *htim);
//自定义函数声?
void S_init(void);
void PWM_init(void);
void ADC_init(void);
void Setmotorspeed(uint8_t which,int speed);
void setADCthreshold(uint8_t which);
void switchADCLED(uint8_t which);
uint16_t readADCLED(uint8_t which);
uint16_t readADC(uint8_t which);
void Send_LEDData_32Bits(uint32_t dat);
void Beep(uint32_t state);
void SetSystemTime(void);
uint32_t GetSystemTime(void);
uint16_t ReadMIC(void);
void EEPROM(void);
void LED_ALL(uint32_t COLOR);

#ifdef __cplusplus
}
#endif

#endif /* __jmkernel_H__ */

