﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using RM.Interop.ReportMachine;
using AxRM.Interop.ReportMachine;

namespace RMReportEngine
{
    public class RMReport: System.ComponentModel.Component
    {
        private AxRMReportEngine FReport;
        private Boolean FShowProgress, FThreadPrepareReport, FShowPrintDialog, FModifyPrepared;
        private System.Windows.Forms.Form FForm;
        private ArrayList FAryDataSet;

        public delegate void TRMOnUserFunctionEvent(object sender, IRMReportEngineEvents_OnUserFunctionEvent e);
        public delegate void TRMOnGetValueEvent(object sender, IRMReportEngineEvents_OnGetValueEvent e);
        public delegate void TRMOnObjectClickEvent(object sender, IRMReportEngineEvents_OnObjectClickEvent e);
        public delegate void TRMOnBeforePrintEvent(object sender, IRMReportEngineEvents_OnBeforePrintEvent e);
        public delegate void TRMOnAfterPrintEvent(object sender, IRMReportEngineEvents_OnAfterPrintEvent e);
        public delegate void TRMOnBeforePrintBandEvent(object sender, IRMReportEngineEvents_OnBeforePrintBandEvent e);

        public delegate void TRMOnSaveReportEvent(object sender, IRMReportEngineEvents_OnDesignerSaveReportEvent e);
        public delegate void TRMOnNewReportEvent(object sender, IRMReportEngineEvents_OnDesignerNewReportEvent e);
        public delegate void TRMOnLoadReportEvent(object sender, IRMReportEngineEvents_OnDesignerLoadReportEvent e);
        public delegate void TRMOnBtnExitClickEvent();

        private TRMOnUserFunctionEvent FOnUserFunctionEvent;
        private TRMOnGetValueEvent FOnGetValueEvent;
        private TRMOnObjectClickEvent FOnObjectClickEvent;
        private TRMOnBeforePrintEvent FOnBeforePrintEvent;
        private TRMOnAfterPrintEvent FOnAfterPrintEvent;
        private TRMOnBeforePrintBandEvent FOnBeforePrintBandEvent;
        private TRMOnSaveReportEvent FOnSaveReportEvent;
        private TRMOnNewReportEvent FOnNewReportEvent;
        private TRMOnLoadReportEvent FOnOpenReportEvent;

        public RMReport()
        {
            FAryDataSet = new ArrayList();
            FShowProgress = true;
            FThreadPrepareReport = true;
            FShowPrintDialog = true;
            FModifyPrepared = false;
            FReport = null;
        }

        ~RMReport()
        {
            ClearDataSets();
            if (FReport != null)
            {
                FForm.Controls.Remove(FReport);
                FReport.Dispose();
                FReport = null;
            }
        }

        private AxRMReportEngine CurReport()
        {
            if ((FReport == null) && (FForm != null))
            {
                FReport = new AxRMReportEngine();
                FForm.Controls.Add(FReport);
                FReport.Visible = false;
            }

            return FReport;
        }

        private void ClearDataSets()
        {
            Int32 i;

            for (i = 0; i < FAryDataSet.Count; i++)
            {
                (FAryDataSet[i] as RMDataTable).FreeCom();
            }

            FAryDataSet.Clear();
            GC.Collect();
        }

        private void SetReportInfo()
        {
            CurReport().ShowProgress = FShowProgress;
            CurReport().ThreadPrepareReport = FThreadPrepareReport;
            CurReport().ShowPrintDialog = FShowPrintDialog;
            CurReport().ModifyPrepared = FModifyPrepared;

            OnUserFunction += FOnUserFunctionEvent;
            OnGetValue += FOnGetValueEvent;
            OnObjectClick += FOnObjectClickEvent;
            OnBeforePrint += FOnBeforePrintEvent;
            OnAfterPrint += FOnAfterPrintEvent;
            OnBeforePrintBand += FOnBeforePrintBandEvent;

            OnDesignerSaveReport += FOnSaveReportEvent;
            OnDesignerNewReport += FOnNewReportEvent;
            OnDesignerOpenReport += FOnOpenReportEvent;
        }

        public void Init(System.Windows.Forms.Form aOwner, TxRMReportType aReportType)
        {
            System.Diagnostics.Process lCurrent;

            FForm = aOwner;
            ClearDataSets();
            SetReportInfo();

            CurReport().Init(aReportType);

            lCurrent = System.Diagnostics.Process.GetCurrentProcess();
            CurReport().SetHandle((int)lCurrent.MainWindowHandle);
        }

        public void AddDataSet(DataTable aDataTable, string aDatasetName)
        {
            RMDataTable lRMDataTable;

            lRMDataTable = new RMDataTable(FForm);
            lRMDataTable.Init(aDatasetName, aDataTable);
            lRMDataTable.FDataSetX.SetParentReport((RM.Interop.ReportMachine.RMReportEngine)FReport.GetOcx());

            FAryDataSet.Add(lRMDataTable);
        }

        public void AddDataSet(DataView aDataView, string aDatasetName)
        {
            RMDataTable lRMDataTable;

            lRMDataTable = new RMDataTable(FForm);
            lRMDataTable.Init(aDatasetName, aDataView);
            lRMDataTable.FDataSetX.SetParentReport((RM.Interop.ReportMachine.RMReportEngine)FReport.GetOcx());

            FAryDataSet.Add(lRMDataTable); 
        }

        public void AddDetailDataSet(DataTable aDataTable, string aDatasetName, string aMasterName, DataRelation aDataRelation)
        {
            RMDataTable lMasterTable, lRMDataTable;
            Int32 i;

            for (i = 0; i < FAryDataSet.Count; i++)
            {
                lMasterTable = (RMDataTable)FAryDataSet[i];
                if (System.String.Compare(aMasterName, lMasterTable.FDataSetX.AliasName, true) == 0)
                {
                  lRMDataTable = new RMDataTable(FForm);
                  lRMDataTable.FIsDetailDataSet = true;
                  lRMDataTable.Init(aDatasetName, aDataTable);
                  lRMDataTable.FDataRelation = aDataRelation;
                  lRMDataTable.FDataSetX.SetParentReport((RM.Interop.ReportMachine.RMReportEngine)FReport.GetOcx());

                  lMasterTable.FAryDataSets.Add(lRMDataTable);
                  FAryDataSet.Add(lRMDataTable);
                 
                  break;
                }
            }
        }

        public void ShowReport()
        {
            CurReport().ShowReport();
        }

        public void DesignReport()
        {
            CurReport().DesignReport();
        }

        public void PrintReport()
        {
            CurReport().PrintReport();
        }

        public Boolean PrepareReport()
        {
            return CurReport().PrepareReport();
        }

        public void LoadFromFile(string aFileName)
        {
            CurReport().LoadFromFile(aFileName);
        }

        public void SaveToFile(string aFileName)
        {
            CurReport().SaveToFile(aFileName);
        }

        public void LoadPreparedReportFromFile(string aFileName)
        {
            CurReport().LoadPreparedReportFromFile(aFileName);
        }
        
        public void SavePreparedReportToFile(string aFileName)
        {
            CurReport().SavePreparedReportToFile(aFileName);
        }

        public void LoadReportFromStream(Object aStream)
        {
            CurReport().LoadReportFromStream(aStream);
        }

        public void SaveReportToStream(Object aStream)
        {
            CurReport().SaveReportToStream(aStream);
        }

        public void AddFunction(string aFuncName, string aCategory, string aDescription, string aParams)
        {
            CurReport().AddFunction(aFuncName, aCategory, aDescription, aParams);
        }

        public void AddVariable(string aVarName, object aVarValue, Boolean aIsString)
        {
            CurReport().AddVariable(aVarName, aVarValue, aIsString);
        }

        public void AddGlobalVariable(string aVarName, object aVarValue, Boolean aIsString)
        {
            CurReport().AddGlobalVariable(aVarName, aVarValue, aIsString);
        }

        public void ExportToRtf(string aFileName)
        {
            CurReport().ExportToRtf(aFileName);
        }

        public void ExportToHtml(string aFileName)
        {
            CurReport().ExportToHtml(aFileName);
        }

        public void ExportToXls(string aFileName, Boolean aOleMode)
        {
            CurReport().ExportToXls(aFileName, aOleMode);
        }

        public void ExportToPdf(string aFileName)
        {
            CurReport().ExportToPdf(aFileName);
        }

        public IRMReportPage AddReportPage()
        {
            return CurReport().AddReportPage();
        }

        public IRMGridPage AddGridPage()
        {
            return CurReport().AddGridPage();
        }

        public IRMDialogPage AddDialogPage()
        {
            return CurReport().AddDialogPage();
        }

        public IRMCellPage AddCellPage()
        {
            return CurReport().AddCellPage();
        }

        public void NewReport()
        {
            CurReport().NewReport();
        }

        public IRMView FindObject(string aObjectName)
        {
            return CurReport().FindObject(aObjectName);
        }

        public void DeletePage(int aPageIndex)
        {
            CurReport().DeletePage(aPageIndex);
        }

        public int PageCount()
        {
            return CurReport().PageCount;
        }

        public void LoadApplicationIconFromFile(string aFileName)
        {
            CurReport().LoadApplicationIconFromFile(aFileName);
        }

        public int ToBorlandColor(System.Drawing.Color aColor)
        {
            return aColor.B * 256 * 256 + aColor.G* 256 + aColor.R;
        }

        public RM.Interop.ReportMachine.RMReportEngine GetOcx()
        {
            return (RM.Interop.ReportMachine.RMReportEngine)GetOcx(); 
        }

        [Browsable(true),DefaultValue(false)]
        public Boolean ModifyPrepared
        {
            get
            {
                return FModifyPrepared;
            }
            set
            {
                FModifyPrepared = value;
            }

        }

        [Browsable(true), DefaultValue(true)]
        public Boolean ShowPrintDialog
        {
            get
            {
                return FShowPrintDialog;
            }
            set
            {
                FShowPrintDialog = value;
            }
        }

        [Browsable(true), DefaultValue(true)]
        public Boolean ThreadPrepareReport
        {
            get
            {
                return FThreadPrepareReport;
            }
            set
            {
                FThreadPrepareReport = value;
            }
        }

        [Browsable(true), DefaultValue(true)]
        public Boolean ShowProgress
        {
            get
            {
                return FShowProgress;
            }
            set
            {
                FShowProgress = value;
            }
        }

        [Browsable(false), DefaultValue("")]
        public string ScriptText
        {
            get
            {
                if (DesignMode) { return ""; }
                else { return CurReport().ScriptText; }
            }
            set
            {
                if ((!DesignMode) && (FForm != null)) { CurReport().ScriptText = value; }
            }
        }

        [Browsable(false), DefaultValue("")]
        public string FileName
        {
            get
            {
                if (DesignMode) { return ""; }
                else { return CurReport().FileName; }
            }
            set
            {
                if ((!DesignMode) && (FForm != null)) { CurReport().FileName = value; }
            }
        }

        [Browsable(false), DefaultValue("")]
        public string PrinterName
        {
            get
            {
                if (DesignMode) { return ""; }
                else { return CurReport().PrinterName; }
            }
            set
            {
                if ((!DesignMode) && (FForm != null)) { CurReport().PrinterName = value; }
            }
        }

        [Browsable(false)]
        public IRMReportInfo ReportInfo
        {
            get
            {
                if (DesignMode)
                {
                    return null;
                }
                else
                {
                    return CurReport().ReportInfo;
                }
            }
        }

        [Browsable(false)]
        public IRMParser Parser
        {
            get
            {
                return CurReport().Parser;
            }
        }

        [Browsable(false), DefaultValue(null)]
        public Byte[] ReportData
        {
            get
            {
                if (DesignMode) { return null; }
                else { return (Byte[])CurReport().ReportData; }
            }
            set
            {
                if ((!DesignMode) && (value != null) && (FForm != null)) { CurReport().ReportData = value; }
            }
        }

        [Browsable(false)]
        public RM.Interop.ReportMachine.RMReportEngine GetReportComObject()
        {
            return (RM.Interop.ReportMachine.RMReportEngine)FReport.GetOcx();
        }

        public class VarCollection
        {
            readonly RMReport lReport;

            internal VarCollection(RMReport aValue)
            {
                lReport = aValue;
            }

            public object this[string index]
            {
                get
                {
                    return lReport.CurReport().Get_Variable(index);
                }
                set
                {
                    lReport.CurReport().Set_Variable(index, value);
                }
            }
        }


        [Browsable(false)]
        public readonly VarCollection Variables;

        [Browsable(false)]
        public IRMPreviewOptions PreviewOptions
        {
            get
            {
                return CurReport().PreviewOptions;
            }
        }

        public event TRMOnUserFunctionEvent OnUserFunction
        {
            add
            {
                FOnUserFunctionEvent = value;
                if (FReport != null)
                {
                    FOnUserFunctionEvent += value;
                    FReport.OnUserFunction += MyOnUserFunctionEvent;
                }
            }
            remove
            {
                FOnUserFunctionEvent = null;
                if (FReport != null)
                {
                    FOnUserFunctionEvent -= value;
                    FReport.OnUserFunction -= MyOnUserFunctionEvent;
                }
            }
        }

        private void MyOnUserFunctionEvent(Object sender, IRMReportEngineEvents_OnUserFunctionEvent e)
        {
            if (FOnUserFunctionEvent != null)
            {
                FOnUserFunctionEvent(sender, e);
            }
        }

        public event TRMOnGetValueEvent OnGetValue
        {
            add
            {
                FOnGetValueEvent = value;
                if (FReport != null)
                {
                    FOnGetValueEvent += value;
                    FReport.OnGetValue += MyOnGetValueEvent;
                }
            }
            remove
            {
                FOnGetValueEvent = null;
                if (FReport != null)
                {
                    FOnGetValueEvent -= value;
                    FReport.OnGetValue -= MyOnGetValueEvent;
                }
            }
        }

        private void MyOnGetValueEvent(Object sender, IRMReportEngineEvents_OnGetValueEvent e)
        {
            if (FOnGetValueEvent != null)
            {
                FOnGetValueEvent(sender, e);
            }
        }

        public event TRMOnObjectClickEvent OnObjectClick
        {
            add
            {
                FOnObjectClickEvent = value;
                if (FReport != null)
                {
                    FOnObjectClickEvent += value;
                    FReport.OnObjectClick += MyOnObjectClickEvent;
                }
            }
            remove
            {
                FOnObjectClickEvent = null;
                if (FReport != null)
                {
                    FOnObjectClickEvent -= value;
                    FReport.OnObjectClick -= MyOnObjectClickEvent;
                }
            }
        }

        private void MyOnObjectClickEvent(Object sender, IRMReportEngineEvents_OnObjectClickEvent e)
        {
            if (FOnObjectClickEvent != null)
            {
                FOnObjectClickEvent(sender, e);
            }
        }

        public event TRMOnBeforePrintEvent OnBeforePrint
        {
            add
            {
                FOnBeforePrintEvent = value;
                if (FReport != null)
                {
                    FOnBeforePrintEvent += value;
                    FReport.OnBeforePrint += MyOnBeforePrintEvent;
                }
            }
            remove
            {
                FOnBeforePrintEvent = null;
                if (FReport != null)
                {
                    FOnBeforePrintEvent -= value;
                    FReport.OnBeforePrint -= MyOnBeforePrintEvent;
                }
            }
        }

        private void MyOnBeforePrintEvent(Object sender, IRMReportEngineEvents_OnBeforePrintEvent e)
        {
            if (FOnBeforePrintEvent != null)
            {
                FOnBeforePrintEvent(sender, e);
            }
        }

        public event TRMOnAfterPrintEvent OnAfterPrint
        {
            add
            {
                FOnAfterPrintEvent = value;
                if (FReport != null)
                {
                    FOnAfterPrintEvent += value;
                    FReport.OnAfterPrint += MyOnAfterPrintEvent;
                }
            }
            remove
            {
                FOnAfterPrintEvent = null;
                if (FReport != null)
                {
                    FOnAfterPrintEvent -= value;
                    FReport.OnAfterPrint -= MyOnAfterPrintEvent;
                }
            }
        }

        private void MyOnAfterPrintEvent(Object sender, IRMReportEngineEvents_OnAfterPrintEvent e)
        {
            if (FOnAfterPrintEvent != null)
            {
                FOnAfterPrintEvent(sender, e);
            }
        }

        public event TRMOnBeforePrintBandEvent OnBeforePrintBand
        {
            add
            {
                FOnBeforePrintBandEvent = value;
                if (FReport != null)
                {
                    FOnBeforePrintBandEvent += value;
                    FReport.OnBeforePrintBand += MyOnBeforePrintBandEvent;
                }
            }
            remove
            {
                FOnBeforePrintBandEvent = null;
                if (FReport != null)
                {
                    FOnBeforePrintBandEvent -= value;
                    FReport.OnBeforePrintBand -= MyOnBeforePrintBandEvent;
                }
            }
        }

        private void MyOnBeforePrintBandEvent(Object sender, IRMReportEngineEvents_OnBeforePrintBandEvent e)
        {
            if (FOnBeforePrintBandEvent != null)
            {
                FOnBeforePrintBandEvent(sender, e);
            }
        }

        public event TRMOnSaveReportEvent OnDesignerSaveReport
        {
            add
            {
                FOnSaveReportEvent = value;
                if (FReport != null)
                {
                    FOnSaveReportEvent += value;
                    FReport.OnDesignerSaveReport += MyOnSaveReportEvent;
                }
            }
            remove
            {
                FOnSaveReportEvent = null;
                if (FReport != null)
                {
                    FOnSaveReportEvent -= value;
                    FReport.OnDesignerSaveReport -= MyOnSaveReportEvent;
                }
            }
        }

        private void MyOnSaveReportEvent(Object sender, IRMReportEngineEvents_OnDesignerSaveReportEvent e)
        {
            if (FOnSaveReportEvent != null)
            {
                FOnSaveReportEvent(sender, e);
            }
        }

        public event TRMOnNewReportEvent OnDesignerNewReport
        {
            add
            {
                FOnNewReportEvent = value;
                if (FReport != null)
                {
                    FOnNewReportEvent += value;
                    FReport.OnDesignerNewReport += MyOnNewReportEvent;
                }
            }
            remove
            {
                FOnNewReportEvent = null;
                if (FReport != null)
                {
                    FOnNewReportEvent -= value;
                    FReport.OnDesignerNewReport -= MyOnNewReportEvent;
                }
            }
        }

        private void MyOnNewReportEvent(Object sender, IRMReportEngineEvents_OnDesignerNewReportEvent e)
        {
            if (FOnNewReportEvent != null)
            {
                FOnNewReportEvent(sender, e);
            }
        }

        public event TRMOnLoadReportEvent OnDesignerOpenReport
        {
            add
            {
                FOnOpenReportEvent = value;
                if (FReport != null)
                {
                    FOnOpenReportEvent += value;
                    FReport.OnDesignerLoadReport += MyOnOpenReportEvent;
                }
            }
            remove
            {
                FOnOpenReportEvent = null;
                if (FReport != null)
                {
                    FOnOpenReportEvent -= value;
                    FReport.OnDesignerLoadReport -= MyOnOpenReportEvent;
                }
            }
        }

        private void MyOnOpenReportEvent(Object sender, IRMReportEngineEvents_OnDesignerLoadReportEvent e)
        {
            if (FOnOpenReportEvent != null)
            {
                FOnOpenReportEvent(sender, e);
            }
        }
    }

    public class RMDataTable : System.Object
    {
        private System.Windows.Forms.Form FForm;
        private DataTable FDataTable;
        private DataView FDataView;
        private Int32 FRecordNo;
        private DataRow[] FDataRows;
        internal Boolean FIsDetailDataSet;
        internal DataRelation FDataRelation;
        internal AxRMDataSetX FDataSetX;
        internal ArrayList FAryDataSets;


        public RMDataTable(System.Windows.Forms.Form ParentForm)
        {
            FForm = ParentForm;

            FIsDetailDataSet = false;
            FDataTable = null;
            FDataView = null;
            FDataRows = new DataRow[0];
            FRecordNo = -1;

            FAryDataSets = new ArrayList();

            FDataSetX = new AxRMDataSetX();
            ParentForm.Controls.Add(FDataSetX);
            FDataSetX.Visible = false;

            FDataSetX.OnInit += OnInitEvent;
            FDataSetX.OnFirst += OnFirstEvent;
            FDataSetX.OnNext += OnNextEvent;
            FDataSetX.OnPrior += OnPriorEvent;
            FDataSetX.OnCheckEof += OnCheckEofEvent;
            FDataSetX.OnGetFieldList += OnGetFieldListEvent;
            FDataSetX.OnGetFieldValue += OnGetFieldValueEvent;
            FDataSetX.OnGetFieldDisplayText += OnGetFieldDisplayTextEvent;
        }

        ~RMDataTable()
        {
            FreeCom();
        }

        public void FreeCom()
        {
            if (FDataSetX != null)
            {
                FForm.Controls.Remove(FDataSetX);
                FDataSetX.Dispose();
                FDataSetX = null;
            }
        }

        public void Init(string aAliasName, DataTable aDataTable)
        {
            FDataSetX.Init();
            FDataSetX.AliasName = aAliasName;

            FDataTable = aDataTable;
            FDataView = null;
        }

        public void Init(string aAliasName, DataView aDataView)
        {
            FDataSetX.Init();
            FDataSetX.AliasName = aAliasName;

            FDataTable = null;
            FDataView = aDataView;
        }

        private void InitDetailDataSets()
        {
            Int32 i;
            RMDataTable lDataSet;

            for (i = 0; i < FAryDataSets.Count; i++)
            {
                lDataSet = (RMDataTable)FAryDataSets[i];
                if (FDataTable != null)
                {
                    if ((FRecordNo >= 0) && (FRecordNo < FDataTable.Rows.Count))
                    {
                        lDataSet.FDataRows = FDataTable.Rows[FRecordNo].GetChildRows(lDataSet.FDataRelation);
                    }
                    else
                    {
                        lDataSet.FDataRows = new DataRow[0];
                    }
                }
                else if (FDataView != null)
                {
                    if ((FRecordNo >= 0) && (FRecordNo < FDataView.Count))
                    {
                        lDataSet.FDataRows = FDataView[FRecordNo].Row.GetChildRows(lDataSet.FDataRelation);
                    }
                    else
                    {
                        lDataSet.FDataRows = new DataRow[0];
                    }
                }
            }
        }

        private void OnInitEvent(Object sender, EventArgs e)
        {
            FRecordNo = 0;
            InitDetailDataSets();
        }

        private void OnFirstEvent(Object sender, EventArgs e)
        {
            FRecordNo = 0;
            InitDetailDataSets();
        }

        private void OnNextEvent(Object sender, EventArgs e)
        {
            FRecordNo = FRecordNo + 1;
            InitDetailDataSets();
        }

        private void OnPriorEvent(Object sender, EventArgs e)
        {
            if (FRecordNo > 0)
            {
                FRecordNo = FRecordNo - 1;
                InitDetailDataSets();
            }
        }

        private void OnCheckEofEvent(Object sender, IRMDataSetXEvents_OnCheckEofEvent e)
        {
            e.aEof = true;
            if (FIsDetailDataSet)
            {
                e.aEof = FRecordNo >= FDataRows.Length;
            }
            else if(FDataTable != null)
            {
                e.aEof = FRecordNo >= FDataTable.Rows.Count;
            }
            else if(FDataView != null)
            {
                e.aEof = FRecordNo >= FDataView.Count;
            }
        }

        private Boolean IsBlobField(System.Type aSystemType)
        {
            Boolean lResult;

            lResult = false;
            if (aSystemType == typeof(System.Byte[]))
            {
                lResult = true;
            }

            return lResult;
        }

        private void OnGetFieldListEvent(Object sender, EventArgs e)
        {
            Int32 i;
            string lFieldName, lFieldAlias;
            Boolean lIsBlobField;
            DataTable lDataTable;

            if ((FDataTable == null) && (FDataView == null))
            {
                return;
            }

            lDataTable = null;
            if (FDataTable != null) 
            {
                lDataTable = FDataTable;
            }
            else if (FDataView != null)
            {
                lDataTable = FDataView.Table;
            }
            
            FDataSetX.Init();
            for (i = 0; i < lDataTable.Columns.Count; i++)
            {
                lFieldName = lDataTable.Columns[i].ColumnName;
                lIsBlobField = IsBlobField(lDataTable.Columns[i].DataType);
                lFieldAlias = lDataTable.Columns[i].Caption;
                if (lFieldAlias == "")
                    lFieldAlias = lFieldName;

                FDataSetX.AddFieldDef(lFieldName, lFieldAlias, lIsBlobField);
            }
        }

        private Boolean _IsThisColumn(DataColumn aColumn, string aFieldName)
        {
            if (aColumn.Caption != aColumn.ColumnName)
            {
                return System.String.Compare(aFieldName, aColumn.Caption, true) == 0;
            }
           else
            {
                return System.String.Compare(aFieldName, aColumn.ColumnName, true) == 0;
            }
        }

        private void OnGetFieldValueEvent(Object sender, IRMDataSetXEvents_OnGetFieldValueEvent e)
        {
            Int32 i;
            DataColumn lColumn;

            if (FDataTable != null)
            {
                for (i = 0; i < FDataTable.Columns.Count; i++)
                {
                    lColumn = FDataTable.Columns[i];
                    if (_IsThisColumn(lColumn, e.aFieldName))
                    {
                        if (FIsDetailDataSet)
                        {
                            e.aFieldValue = FDataRows[FRecordNo][i];
                        }
                        else
                        {
                            e.aFieldValue = FDataTable.Rows[FRecordNo][i];
                        }
                    }
                }
            }
            else if (FDataView != null)
            {
                for (i = 0; i < FDataView.Table.Columns.Count; i++)
                {
                    lColumn = FDataView.Table.Columns[i];
                    if (_IsThisColumn(lColumn, e.aFieldName))
                    {
                        if (FIsDetailDataSet)
                        {
                            e.aFieldValue = FDataRows[FRecordNo][i];
                        }
                        else
                        {
                            e.aFieldValue = FDataView[FRecordNo][i];
                        }
                    }
                }
            }
        }

        private void OnGetFieldDisplayTextEvent(Object sender, IRMDataSetXEvents_OnGetFieldDisplayTextEvent e)
        {
            Int32 i;
            DataColumn lColumn;

            if (FDataTable != null)
            {
                for (i = 0; i < FDataTable.Columns.Count; i++)
                {
                    lColumn = FDataTable.Columns[i];
                    if (_IsThisColumn(lColumn, e.aFieldName))
                    {
                        if (FIsDetailDataSet)
                        {
                            e.aFieldValue = FDataRows[FRecordNo][i].ToString();
                        }
                        else
                        {
                            e.aFieldValue = FDataTable.Rows[FRecordNo][i].ToString();
                        }
                    }
                }
            }
            else if (FDataView != null)
            {
                for (i = 0; i < FDataView.Table.Columns.Count; i++)
                {
                    lColumn = FDataView.Table.Columns[i];
                    if (_IsThisColumn(lColumn, e.aFieldName))
                    {
                        if (FIsDetailDataSet)
                        {
                            e.aFieldValue = FDataRows[FRecordNo][i].ToString();
                        }
                        else
                        {
                            e.aFieldValue = FDataView[FRecordNo][i].ToString();
                        }
                    }
                }
            }
        }
    }

    public class RMReportPreview : System.ComponentModel.Component
    {
        AxRMReportPreviewX FReportPreview;

        public delegate void TRMOnBtnExitClickEvent(object sender);

        System.EventHandler FOnBtnExitClick;

        public RMReportPreview(System.ComponentModel.IContainer Container)
        {
              Container.Add(this);

              FReportPreview = new AxRMReportPreviewX();
              FReportPreview.OnBtnExitClick += MyOnBtnExitEvent;              
        }

        ~RMReportPreview()
        {
            if (FReportPreview != null)
            {
                Container.Remove(FReportPreview);
                FReportPreview.Dispose();
                FReportPreview = null;
            }
        }

        private void MyOnBtnExitEvent(object sender, EventArgs e)
        {
            if (FOnBtnExitClick != null)
            {
                FOnBtnExitClick(sender, e);
            }
        }

        public event System.EventHandler OnBtnExitClick
        {
            add
            {
                FOnBtnExitClick = value;
            }
            remove
            {
                FOnBtnExitClick = null;
            }
        }
    }
}
