(function () {

    var reproduce = window.reproduce = {};

    /**
     * @param {Object} ctx
     * @param {Array<Object>} records Generated by Canteen.js
     */
    reproduce.reproduceCanvas = function (ctx, records) {
        for (var i = 0; i < records.length; i++) {
            var record = records[i];
            var attr = record.attr;
            var method = record.method;
            var val = record.val;
            var args = record.arguments;

            if (attr) {
                ctx[attr] = val;
            }
            else if (method) {
                ctx[method].apply(ctx, args);
            }
            else {
                throw new Error(record + ' ' + i);
            }
        }
    };

    /**
     * @param {Object} opt
     * @param {Number} opt.width
     * @param {Number} opt.height
     * @param {Number} opt.dpr
     * @return {Object} {canvas, ctx}
     */
    reproduce.createCanvas = function (opt) {
        var canvas = document.createElement('canvas');
        canvas.style.width = opt.width + 'px';
        canvas.style.height = opt.height + 'px';

        var dpr = opt.dpr || Math.max(window.devicePixelRatio || 1, 1);

        var ctx = canvas.getContext('2d');
        canvas.width = opt.width * dpr;
        canvas.height = opt.height * dpr;

        return {canvas: canvas, ctx: ctx};
    };

})();
