Ext.data.JsonP.qrenderer_graphic_transform_Transformable({"tagname":"class","name":"qrenderer.graphic.transform.Transformable","autodetected":{},"files":[{"filename":"Transformable.js","href":"Transformable.html#qrenderer-graphic-transform-Transformable"}],"abstract":true,"author":[{"tagname":"author","name":"pissang (https://www.github.com/pissang)","email":null}],"docauthor":[{"tagname":"docauthor","name":"大漠穷秋","email":"damoqiongqiu@126.com"}],"members":[{"name":"globalScaleRatio","tagname":"property","owner":"qrenderer.graphic.transform.Transformable","id":"property-globalScaleRatio","meta":{}},{"name":"inverseTransform","tagname":"property","owner":"qrenderer.graphic.transform.Transformable","id":"property-inverseTransform","meta":{}},{"name":"origin","tagname":"property","owner":"qrenderer.graphic.transform.Transformable","id":"property-origin","meta":{}},{"name":"position","tagname":"property","owner":"qrenderer.graphic.transform.Transformable","id":"property-position","meta":{}},{"name":"rotation","tagname":"property","owner":"qrenderer.graphic.transform.Transformable","id":"property-rotation","meta":{}},{"name":"scale","tagname":"property","owner":"qrenderer.graphic.transform.Transformable","id":"property-scale","meta":{}},{"name":"skew","tagname":"property","owner":"qrenderer.graphic.transform.Transformable","id":"property-skew","meta":{}},{"name":"transform","tagname":"property","owner":"qrenderer.graphic.transform.Transformable","id":"property-transform","meta":{}},{"name":"constructor","tagname":"method","owner":"qrenderer.graphic.transform.Transformable","id":"method-constructor","meta":{}},{"name":"applyTransform","tagname":"method","owner":"qrenderer.graphic.transform.Transformable","id":"method-applyTransform","meta":{}},{"name":"composeParentTransform","tagname":"method","owner":"qrenderer.graphic.transform.Transformable","id":"method-composeParentTransform","meta":{}},{"name":"getGlobalScale","tagname":"method","owner":"qrenderer.graphic.transform.Transformable","id":"method-getGlobalScale","meta":{}},{"name":"getLocalTransform","tagname":"method","owner":"qrenderer.graphic.transform.Transformable","id":"method-getLocalTransform","meta":{}},{"name":"getOuterBoundingRect","tagname":"method","owner":"qrenderer.graphic.transform.Transformable","id":"method-getOuterBoundingRect","meta":{}},{"name":"globalToLocal","tagname":"method","owner":"qrenderer.graphic.transform.Transformable","id":"method-globalToLocal","meta":{}},{"name":"localToGlobal","tagname":"method","owner":"qrenderer.graphic.transform.Transformable","id":"method-localToGlobal","meta":{}},{"name":"needLocalTransform","tagname":"method","owner":"qrenderer.graphic.transform.Transformable","id":"method-needLocalTransform","meta":{}},{"name":"restoreTransform","tagname":"method","owner":"qrenderer.graphic.transform.Transformable","id":"method-restoreTransform","meta":{}}],"alternateClassNames":[],"aliases":{},"id":"class-qrenderer.graphic.transform.Transformable","short_doc":"Provide transformation functions for Element class,\nsuch as translate, scale, skew, rotation, shape, style. ...","component":false,"superclasses":[],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable' target='_blank'>Transformable.js</a></div></pre><div class='doc-contents'><p>Provide transformation functions for Element class,\nsuch as translate, scale, skew, rotation, shape, style.</p>\n\n<p>为 Element 类提供变换功能，例如：平移、缩放、扭曲、旋转、翻转、形状、样式。</p>\n\n<p>TODO:用新的事件机制和继承机制，把 Element 类里面与变形有关的逻辑移到本类中来，保持 Element 干净整洁。</p>\n\n<p>@see https://developer.mozilla.org/en-US/docs/Web/API/Canvas_API/Tutorial/Transformations</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-globalScaleRatio' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-property-globalScaleRatio' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-property-globalScaleRatio' class='name expandable'>globalScaleRatio</a> : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>The global scale ratio. ...</div><div class='long'><p>The global scale ratio.</p>\n\n<p>全局缩放比例</p>\n<p>Defaults to: <code>1</code></p></div></div></div><div id='property-inverseTransform' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-property-inverseTransform' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-property-inverseTransform' class='name expandable'>inverseTransform</a> : Matrix<span class=\"signature\"></span></div><div class='description'><div class='short'>The inverse transform matrix. ...</div><div class='long'><p>The inverse transform matrix.</p>\n\n<p>逆变换矩阵。</p>\n</div></div></div><div id='property-origin' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-property-origin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-property-origin' class='name expandable'>origin</a> : Array&lt;Number&gt;<span class=\"signature\"></span></div><div class='description'><div class='short'>The origin point of transformation, default as (0,0) of canvas. ...</div><div class='long'><p>The origin point of transformation, default as (0,0) of canvas.</p>\n\n<p>几何变换的原点，默认为 canvas 最左上角的(0,0)点。</p>\n</div></div></div><div id='property-position' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-property-position' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-property-position' class='name expandable'>position</a> : Array&lt;Number&gt;<span class=\"signature\"></span></div><div class='description'><div class='short'>The translate array, for better understanding, we use position to replace the\nword translate defined in W3C canvas st...</div><div class='long'><p>The translate array, for better understanding, we use position to replace the\nword translate defined in W3C canvas standard.</p>\n\n<p>平移，数组。为了方便理解，用 position 这个名字来替代 W3C canvas 标准里面的 translate 。</p>\n</div></div></div><div id='property-rotation' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-property-rotation' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-property-rotation' class='name expandable'>rotation</a> : Array&lt;Number&gt;<span class=\"signature\"></span></div><div class='description'><div class='short'>The rotation in radian. ...</div><div class='long'><p>The rotation in radian.</p>\n\n<p>旋转弧度。</p>\n</div></div></div><div id='property-scale' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-property-scale' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-property-scale' class='name expandable'>scale</a> : Array&lt;Number&gt;<span class=\"signature\"></span></div><div class='description'><div class='short'>The scale array. ...</div><div class='long'><p>The scale array.</p>\n\n<p>缩放，数组。</p>\n</div></div></div><div id='property-skew' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-property-skew' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-property-skew' class='name expandable'>skew</a> : Array&lt;Number&gt;<span class=\"signature\"></span></div><div class='description'><div class='short'>The skew array. ...</div><div class='long'><p>The skew array.</p>\n\n<p>斜切，数组。</p>\n</div></div></div><div id='property-transform' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-property-transform' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-property-transform' class='name expandable'>transform</a> : Matrix<span class=\"signature\"></span></div><div class='description'><div class='short'>The transform matri. ...</div><div class='long'><p>The transform matri. To work with the animation system better,\ndo NOT modify transform directly, except SVGPainter.</p>\n\n<p>变换矩阵。为了能和动画机制很好地配合，请不要直接修改 transform 属性， SVGPainter 除外。</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/qrenderer.graphic.transform.Transformable-method-constructor' class='name expandable'>qrenderer.graphic.transform.Transformable</a>( <span class='pre'></span> ) : <a href=\"#!/api/qrenderer.graphic.transform.Transformable\" rel=\"qrenderer.graphic.transform.Transformable\" class=\"docClass\">qrenderer.graphic.transform.Transformable</a><span class=\"signature\"></span></div><div class='description'><div class='short'>Transformable ...</div><div class='long'><p>Transformable</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/qrenderer.graphic.transform.Transformable\" rel=\"qrenderer.graphic.transform.Transformable\" class=\"docClass\">qrenderer.graphic.transform.Transformable</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyTransform' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-method-applyTransform' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-method-applyTransform' class='name expandable'>applyTransform</a>( <span class='pre'>ctx</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Apply this.transform matrix to canvas context. ...</div><div class='long'><p>Apply this.transform matrix to canvas context.</p>\n\n<p>将 this.transform 应用到 canvas context 上。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ctx</span> : CanvasRenderingContext2D<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-composeParentTransform' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-method-composeParentTransform' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-method-composeParentTransform' class='name expandable'>composeParentTransform</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>This method is designed to compose the transform matrix from parent. ...</div><div class='long'><p>This method is designed to compose the transform matrix from parent.\nWe needt this method to compose the transfromation from parent when the elements are nested.</p>\n\n<p>此方法的主要作用是复合父层的变换矩阵，当元素出现嵌套时，需要此方法来复合父层上的变换。</p>\n</div></div></div><div id='method-getGlobalScale' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-method-getGlobalScale' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-method-getGlobalScale' class='name expandable'>getGlobalScale</a>( <span class='pre'></span> ) : Array&lt;Number&gt;<span class=\"signature\"></span></div><div class='description'><div class='short'>Get global scale. ...</div><div class='long'><p>Get global scale.</p>\n\n<p>获取全局缩放比例。</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array&lt;Number&gt;</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getLocalTransform' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-method-getLocalTransform' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-method-getLocalTransform' class='name expandable'>getLocalTransform</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Get local transform matrix. ...</div><div class='long'><p>Get local transform matrix.</p>\n\n<p>Note: This implementation did NOT consider the matrix multiplication order of\naffine, because the API invoker will not notice the transform order when provide\nthe config object, but always use the transform order of intuitive sense, that is:\nskew->scale->rotation->position.</p>\n\n<pre class='inline-example '><code>rect.animate()\n .when(1000,{\n     position:[100,100],\n     skew:[2,2],\n     scale:[2,2],\n     rotate:Math.PI\n })\n .when(2000,{\n     position:[200,100],\n     scale:[1,1],\n     skew:[1,1],\n     rotate:-Math.PI\n })\n .start();\n</code></pre>\n\n<p>There is a big disadvantage of this implementation, it can not coordinate with the\ntransform attribute in SVG tags.\nFor example: <path transform=\"rotation(Math.PI);scale(2,2);\">,\nmeans apply some rotation first, then apply scale, this require\nstrict operation orders of affine, but the implementation here can NOT support it.</path></p>\n\n<p>获取本地变换矩阵。</p>\n\n<p>注意：这里的实现没有考虑仿射变换中的矩阵乘法顺序，因为 API 调用者\n在提供配置项时并不会留意数学意义上的变换顺序，而总是采用的直觉意义\n上的变换顺序，也就是：skew->scale->rotation->position 。</p>\n\n<pre class='inline-example '><code>rect.animate()\n .when(1000,{\n     position:[100,100],\n     skew:[2,2],\n     scale:[2,2],\n     rotate:Math.PI\n })\n .when(2000,{\n     position:[200,100],\n     scale:[1,1],\n     skew:[1,1],\n     rotate:-Math.PI\n })\n .start();\n</code></pre>\n\n<p>这种实现方式有一个重大的缺点，它不能很好地对应 SVG 中的 transform 机制，\n比如：<path transform=\"rotation(Math.PI);scale(2,2);\">\n这个 transform 属性表达的意思是：先 rotation ，然后 scale ，这就要求严格按照\n仿射变换的顺序来进行矩阵运算，但是这里的实现不能支持这种操作。</path></p>\n</div></div></div><div id='method-getOuterBoundingRect' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-method-getOuterBoundingRect' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-method-getOuterBoundingRect' class='name expandable'>getOuterBoundingRect</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Get the bounding rect in global space, this rect will not apply transformation itself, but it will\nsurround the trans...</div><div class='long'><p>Get the bounding rect in global space, this rect will not apply transformation itself, but it will\nsurround the transformed element.</p>\n\n<p>全局坐标系中的边界矩形，此矩形本身不进行几何变换，但是会包围变形之后的元素。</p>\n</div></div></div><div id='method-globalToLocal' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-method-globalToLocal' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-method-globalToLocal' class='name expandable'>globalToLocal</a>( <span class='pre'>x, y</span> ) : Array&lt;Number&gt;<span class=\"signature\"></span></div><div class='description'><div class='short'>Tanslate global coordinate to local space of shape. ...</div><div class='long'><p>Tanslate global coordinate to local space of shape.</p>\n\n<p>变换坐标位置到 shape 的局部坐标空间。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : Number<div class='sub-desc'>\n</div></li><li><span class='pre'>y</span> : Number<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array&lt;Number&gt;</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-localToGlobal' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-method-localToGlobal' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-method-localToGlobal' class='name expandable'>localToGlobal</a>( <span class='pre'>x, y</span> ) : Array&lt;Number&gt;<span class=\"signature\"></span></div><div class='description'><div class='short'>Translate local coordinate of element to global space. ...</div><div class='long'><p>Translate local coordinate of element to global space.</p>\n\n<p>变换局部坐标位置到全局坐标空间。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : Number<div class='sub-desc'>\n</div></li><li><span class='pre'>y</span> : Number<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array&lt;Number&gt;</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-needLocalTransform' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-method-needLocalTransform' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-method-needLocalTransform' class='name expandable'>needLocalTransform</a>( <span class='pre'></span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>If the change is less than 5e-5(0.00005), there is no need to do any transform. ...</div><div class='long'><p>If the change is less than 5e-5(0.00005), there is no need to do any transform.</p>\n\n<p>如果变化的值小于5e-5（0.00005），则不需要变换。</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-restoreTransform' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.graphic.transform.Transformable'>qrenderer.graphic.transform.Transformable</span><br/><a href='source/Transformable.html#qrenderer-graphic-transform-Transformable-method-restoreTransform' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.graphic.transform.Transformable-method-restoreTransform' class='name expandable'>restoreTransform</a>( <span class='pre'>ctx</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Restore the transform matrix. ...</div><div class='long'><p>Restore the transform matrix.</p>\n\n<p>重置变换矩阵。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ctx</span> : Context<div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"abstract":true}});