Ext.data.JsonP.qrenderer_core_Storage({"tagname":"class","name":"qrenderer.core.Storage","autodetected":{},"files":[{"filename":"Storage.js","href":"Storage.html#qrenderer-core-Storage"}],"docauthor":[{"tagname":"docauthor","name":"大漠穷秋 damoqiongqiu@126.com","email":null}],"members":[{"name":"_displayList","tagname":"property","owner":"qrenderer.core.Storage","id":"property-_displayList","meta":{"private":true}},{"name":"_displayListLen","tagname":"property","owner":"qrenderer.core.Storage","id":"property-_displayListLen","meta":{"private":true}},{"name":"_roots","tagname":"property","owner":"qrenderer.core.Storage","id":"property-_roots","meta":{"private":true}},{"name":"constructor","tagname":"method","owner":"qrenderer.core.Storage","id":"method-constructor","meta":{}},{"name":"_updateAndAddDisplayable","tagname":"method","owner":"qrenderer.core.Storage","id":"method-_updateAndAddDisplayable","meta":{}},{"name":"addToRoot","tagname":"method","owner":"qrenderer.core.Storage","id":"method-addToRoot","meta":{}},{"name":"addToStorage","tagname":"method","owner":"qrenderer.core.Storage","id":"method-addToStorage","meta":{"chainable":true}},{"name":"delFromRoot","tagname":"method","owner":"qrenderer.core.Storage","id":"method-delFromRoot","meta":{}},{"name":"delFromStorage","tagname":"method","owner":"qrenderer.core.Storage","id":"method-delFromStorage","meta":{"chainable":true}},{"name":"dispose","tagname":"method","owner":"qrenderer.core.Storage","id":"method-dispose","meta":{}},{"name":"getDisplayList","tagname":"method","owner":"qrenderer.core.Storage","id":"method-getDisplayList","meta":{}},{"name":"traverse","tagname":"method","owner":"qrenderer.core.Storage","id":"method-traverse","meta":{}},{"name":"updateDisplayList","tagname":"method","owner":"qrenderer.core.Storage","id":"method-updateDisplayList","meta":{}}],"alternateClassNames":[],"aliases":{},"id":"class-qrenderer.core.Storage","short_doc":"Global storage, has 3 core features:\n- Store and manage all the objects in QuarkRenderer instance. ...","component":false,"superclasses":[],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/Storage.html#qrenderer-core-Storage' target='_blank'>Storage.js</a></div></pre><div class='doc-contents'><p>Global storage, has 3 core features:\n- Store and manage all the objects in QuarkRenderer instance.\n- Manage the displaylist.\n- Cooperate with Painter to render the elements. Painter will get the display list from Storage, in this case Storage is used as a transfer\nstation, we can skip the drawing process for those elements that do NOT need to be rendered, this will help us improve the performance.</p>\n\n<p>全局仓库，有3个主要核心功能：\n- 存储和管理 QuarkRenderer 中的所有对象。\n- 管理显示列表。\n- 与 Painter 配合，渲染元素。Painter 会从 Storage 中获取显示列表进行绘图，利用 Storage 作为中转站，对于不需要刷新的对象可以不绘制，从而可以提升整体性能。</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-_displayList' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.core.Storage'>qrenderer.core.Storage</span><br/><a href='source/Storage.html#qrenderer-core-Storage-property-_displayList' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.core.Storage-property-_displayList' class='name expandable'>_displayList</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>The display list. ...</div><div class='long'><p>The display list.</p>\n\n<p>显示列表。</p>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='property-_displayListLen' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.core.Storage'>qrenderer.core.Storage</span><br/><a href='source/Storage.html#qrenderer-core-Storage-property-_displayListLen' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.core.Storage-property-_displayListLen' class='name expandable'>_displayListLen</a> : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Length of display list. ...</div><div class='long'><p>Length of display list.</p>\n\n<p>显示列表的长度。</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='property-_roots' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.core.Storage'>qrenderer.core.Storage</span><br/><a href='source/Storage.html#qrenderer-core-Storage-property-_roots' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.core.Storage-property-_roots' class='name expandable'>_roots</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>This is used to store the elements displayed in the canvas itself, not nested in other element. ...</div><div class='long'><p>This is used to store the elements displayed in the canvas itself, not nested in other element.</p>\n\n<p>存储直接放在画布上的对象，而不是嵌套在其它元素中的对象。</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.core.Storage'>qrenderer.core.Storage</span><br/><a href='source/Storage.html#qrenderer-core-Storage-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/qrenderer.core.Storage-method-constructor' class='name expandable'>qrenderer.core.Storage</a>( <span class='pre'></span> ) : <a href=\"#!/api/qrenderer.core.Storage\" rel=\"qrenderer.core.Storage\" class=\"docClass\">qrenderer.core.Storage</a><span class=\"signature\"></span></div><div class='description'><div class='short'>Storage ...</div><div class='long'><p>Storage</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/qrenderer.core.Storage\" rel=\"qrenderer.core.Storage\" class=\"docClass\">qrenderer.core.Storage</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-_updateAndAddDisplayable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.core.Storage'>qrenderer.core.Storage</span><br/><a href='source/Storage.html#qrenderer-core-Storage-method-_updateAndAddDisplayable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.core.Storage-method-_updateAndAddDisplayable' class='name expandable'>_updateAndAddDisplayable</a>( <span class='pre'>el, clipPaths, includeIgnore</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : *<div class='sub-desc'>\n</div></li><li><span class='pre'>clipPaths</span> : *<div class='sub-desc'>\n</div></li><li><span class='pre'>includeIgnore</span> : *<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addToRoot' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.core.Storage'>qrenderer.core.Storage</span><br/><a href='source/Storage.html#qrenderer-core-Storage-method-addToRoot' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.core.Storage-method-addToRoot' class='name expandable'>addToRoot</a>( <span class='pre'>el</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Add element to root. ...</div><div class='long'><p>Add element to root.</p>\n\n<p>添加元素到根节点。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Element<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addToStorage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.core.Storage'>qrenderer.core.Storage</span><br/><a href='source/Storage.html#qrenderer-core-Storage-method-addToStorage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.core.Storage-method-addToStorage' class='name expandable'>addToStorage</a>( <span class='pre'>el</span> ) : <a href=\"#!/api/qrenderer.core.Storage\" rel=\"qrenderer.core.Storage\" class=\"docClass\">qrenderer.core.Storage</a><span class=\"signature\"><span class='chainable' >chainable</span></span></div><div class='description'><div class='short'>Add element to Storage. ...</div><div class='long'><p>Add element to Storage.</p>\n\n<p>把元素添加到 Storage 中。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Element<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/qrenderer.core.Storage\" rel=\"qrenderer.core.Storage\" class=\"docClass\">qrenderer.core.Storage</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-delFromRoot' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.core.Storage'>qrenderer.core.Storage</span><br/><a href='source/Storage.html#qrenderer-core-Storage-method-delFromRoot' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.core.Storage-method-delFromRoot' class='name expandable'>delFromRoot</a>( <span class='pre'>[el]</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Delete element from root. ...</div><div class='long'><p>Delete element from root.</p>\n\n<p>删除指定元素。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : string|Array.&lt;String&gt; (optional)<div class='sub-desc'><p>如果为空清空整个Storage</p>\n</div></li></ul></div></div></div><div id='method-delFromStorage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.core.Storage'>qrenderer.core.Storage</span><br/><a href='source/Storage.html#qrenderer-core-Storage-method-delFromStorage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.core.Storage-method-delFromStorage' class='name expandable'>delFromStorage</a>( <span class='pre'>el</span> ) : <a href=\"#!/api/qrenderer.core.Storage\" rel=\"qrenderer.core.Storage\" class=\"docClass\">qrenderer.core.Storage</a><span class=\"signature\"><span class='chainable' >chainable</span></span></div><div class='description'><div class='short'>Delete element from Storage. ...</div><div class='long'><p>Delete element from Storage.</p>\n\n<p>从 Storage 中删除元素。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Element<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/qrenderer.core.Storage\" rel=\"qrenderer.core.Storage\" class=\"docClass\">qrenderer.core.Storage</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-dispose' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.core.Storage'>qrenderer.core.Storage</span><br/><a href='source/Storage.html#qrenderer-core-Storage-method-dispose' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.core.Storage-method-dispose' class='name expandable'>dispose</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Clear and dispose Storage. ...</div><div class='long'><p>Clear and dispose Storage.</p>\n\n<p>清空并且释放 Storage。</p>\n</div></div></div><div id='method-getDisplayList' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.core.Storage'>qrenderer.core.Storage</span><br/><a href='source/Storage.html#qrenderer-core-Storage-method-getDisplayList' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.core.Storage-method-getDisplayList' class='name expandable'>getDisplayList</a>( <span class='pre'>[needUpdate], [includeIgnore]</span> ) : Array&lt;Displayable&gt;<span class=\"signature\"></span></div><div class='description'><div class='short'>Get the display list. ...</div><div class='long'><p>Get the display list.</p>\n\n<p>获取显示列表。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>needUpdate</span> : Boolean (optional)<div class='sub-desc'><p>Wether update the list before returnning.</p>\n\n<p>是否在返回前更新该数组。</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>includeIgnore</span> : Boolean (optional)<div class='sub-desc'><p>Wether include the ignore array, this is valid when needUpdate is true.</p>\n\n<p>是否包含 ignore 的数组, 在 needUpdate 为 true 的时候有效。</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array&lt;Displayable&gt;</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-traverse' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.core.Storage'>qrenderer.core.Storage</span><br/><a href='source/Storage.html#qrenderer-core-Storage-method-traverse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.core.Storage-method-traverse' class='name expandable'>traverse</a>( <span class='pre'>cb, context</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cb</span> : Function<div class='sub-desc'>\n</div></li><li><span class='pre'>context</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-updateDisplayList' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.core.Storage'>qrenderer.core.Storage</span><br/><a href='source/Storage.html#qrenderer-core-Storage-method-updateDisplayList' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.core.Storage-method-updateDisplayList' class='name expandable'>updateDisplayList</a>( <span class='pre'>[includeIgnore]</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Update the display list, will be invoked before each redering process. ...</div><div class='long'><p>Update the display list, will be invoked before each redering process.\nThis method will traverse the whole tree using deep first method, update all the transformations of Groups and Shapes,\nsave all the visiable Shapes into an array. Finally, the array is sorted by the piority, zlevel > z > insert order.</p>\n\n<p>更新显示列表，每次绘制前都会调用。\n该方法会先深度优先遍历整个树，更新所有 Group 和 Shape 的变换并且把所有可见的Shape保存到数组中，\n最后根据优先级排序得到绘制队列，zlevel > z > 插入顺序。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>includeIgnore</span> : Boolean (optional)<div class='sub-desc'><p>Wether include the ignore array.</p>\n\n<p>是否包含 ignore 的数组。</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></div></div></div></div></div></div>","meta":{}});