Ext.data.JsonP.qrenderer_animation_AnimationProcess({"tagname":"class","name":"qrenderer.animation.AnimationProcess","autodetected":{},"files":[{"filename":"AnimationProcess.js","href":"AnimationProcess.html#qrenderer-animation-AnimationProcess"}],"author":[{"tagname":"author","name":"大漠穷秋","email":"damoqiongqiu@126.com"}],"docauthor":[{"tagname":"docauthor","name":"大漠穷秋","email":"damoqiongqiu@126.com"}],"members":[{"name":"constructor","tagname":"method","owner":"qrenderer.animation.AnimationProcess","id":"method-constructor","meta":{}},{"name":"delay","tagname":"method","owner":"qrenderer.animation.AnimationProcess","id":"method-delay","meta":{}},{"name":"done","tagname":"method","owner":"qrenderer.animation.AnimationProcess","id":"method-done","meta":{}},{"name":"during","tagname":"method","owner":"qrenderer.animation.AnimationProcess","id":"method-during","meta":{}},{"name":"isFinished","tagname":"method","owner":"qrenderer.animation.AnimationProcess","id":"method-isFinished","meta":{}},{"name":"isPaused","tagname":"method","owner":"qrenderer.animation.AnimationProcess","id":"method-isPaused","meta":{}},{"name":"nextFrame","tagname":"method","owner":"qrenderer.animation.AnimationProcess","id":"method-nextFrame","meta":{}},{"name":"pause","tagname":"method","owner":"qrenderer.animation.AnimationProcess","id":"method-pause","meta":{}},{"name":"resume","tagname":"method","owner":"qrenderer.animation.AnimationProcess","id":"method-resume","meta":{}},{"name":"start","tagname":"method","owner":"qrenderer.animation.AnimationProcess","id":"method-start","meta":{}},{"name":"stop","tagname":"method","owner":"qrenderer.animation.AnimationProcess","id":"method-stop","meta":{}},{"name":"when","tagname":"method","owner":"qrenderer.animation.AnimationProcess","id":"method-when","meta":{}}],"alternateClassNames":[],"aliases":{},"id":"class-qrenderer.animation.AnimationProcess","short_doc":"AnimationProcess represents for an entire animation process, each instance of the Element class has a list to store a...","component":false,"superclasses":[],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/AnimationProcess.html#qrenderer-animation-AnimationProcess' target='_blank'>AnimationProcess.js</a></div></pre><div class='doc-contents'><p>AnimationProcess represents for an entire animation process, each instance of the Element class has a list to store all the animation processes.\nEach process in the list will be executed in order. Only one process can be in running state at a certain point. All the animation processes will be scheduled by the GlobalAnimationMgr class.\nAn event called 'done' will be trigged when the animation process finished. Current process will be deleted after the 'done' event is triggered.\nIf more than one process exists in the list, and one of them is set to run in loop mode, then any process behind it will not be executed.</p>\n\n<p>AnimationProcess 表示一次完整的动画过程，每一个元素（Element）中都有一个列表，用来存储本实例上的所有动画过程。\n列表中的动画过程按照顺序获得运行机会，在特定的时间点上只有一个 AnimationProcess 处于运行状态，系统中的所有动画过程都由 GlobalAnimationMgr 类进行调度。\nAnimationProcess 运行完成之后会触发一个 done 事件，Element 实例在收到 done 事件之后，会把当前的动画过程从列表中删除。\n如果 Element 实例的动画过程列表中存在多个实例，其中某个过程是无限循环运行的，那么后续所有动画过程都不会获得到运行机会。</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.animation.AnimationProcess'>qrenderer.animation.AnimationProcess</span><br/><a href='source/AnimationProcess.html#qrenderer-animation-AnimationProcess-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/qrenderer.animation.AnimationProcess-method-constructor' class='name expandable'>qrenderer.animation.AnimationProcess</a>( <span class='pre'>element</span> ) : <a href=\"#!/api/qrenderer.animation.AnimationProcess\" rel=\"qrenderer.animation.AnimationProcess\" class=\"docClass\">qrenderer.animation.AnimationProcess</a><span class=\"signature\"></span></div><div class='description'><div class='short'>AnimationProcess ...</div><div class='long'><p>AnimationProcess</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>element</span> : Object<div class='sub-desc'><p>The element needes animating functions.</p>\n\n<p>需要动画功能的元素。</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/qrenderer.animation.AnimationProcess\" rel=\"qrenderer.animation.AnimationProcess\" class=\"docClass\">qrenderer.animation.AnimationProcess</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-delay' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.animation.AnimationProcess'>qrenderer.animation.AnimationProcess</span><br/><a href='source/AnimationProcess.html#qrenderer-animation-AnimationProcess-method-delay' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.animation.AnimationProcess-method-delay' class='name expandable'>delay</a>( <span class='pre'>time</span> ) : <a href=\"#!/api/qrenderer.animation.AnimationProcess\" rel=\"qrenderer.animation.AnimationProcess\" class=\"docClass\">qrenderer.animation.AnimationProcess</a><span class=\"signature\"></span></div><div class='description'><div class='short'>Set the delay time of current process. ...</div><div class='long'><p>Set the delay time of current process.</p>\n\n<p>设置动画延迟开始的时间。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>time</span> : Number<div class='sub-desc'><p>In milliseconds.</p>\n\n<p>单位ms。</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/qrenderer.animation.AnimationProcess\" rel=\"qrenderer.animation.AnimationProcess\" class=\"docClass\">qrenderer.animation.AnimationProcess</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-done' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.animation.AnimationProcess'>qrenderer.animation.AnimationProcess</span><br/><a href='source/AnimationProcess.html#qrenderer-animation-AnimationProcess-method-done' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.animation.AnimationProcess-method-done' class='name expandable'>done</a>( <span class='pre'>callback</span> ) : <a href=\"#!/api/qrenderer.animation.AnimationProcess\" rel=\"qrenderer.animation.AnimationProcess\" class=\"docClass\">qrenderer.animation.AnimationProcess</a><span class=\"signature\"></span></div><div class='description'><div class='short'>Callback function for the end of animation, this is to facilitate chained calls. ...</div><div class='long'><p>Callback function for the end of animation, this is to facilitate chained calls.</p>\n\n<p>添加动画结束的回调，方便链式调用。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>callback</span> : Function<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/qrenderer.animation.AnimationProcess\" rel=\"qrenderer.animation.AnimationProcess\" class=\"docClass\">qrenderer.animation.AnimationProcess</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-during' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.animation.AnimationProcess'>qrenderer.animation.AnimationProcess</span><br/><a href='source/AnimationProcess.html#qrenderer-animation-AnimationProcess-method-during' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.animation.AnimationProcess-method-during' class='name expandable'>during</a>( <span class='pre'>callback</span> ) : <a href=\"#!/api/qrenderer.animation.AnimationProcess\" rel=\"qrenderer.animation.AnimationProcess\" class=\"docClass\">qrenderer.animation.AnimationProcess</a><span class=\"signature\"></span></div><div class='description'><div class='short'>Callback for each animation frame, this is to facilitate chained calls. ...</div><div class='long'><p>Callback for each animation frame, this is to facilitate chained calls.</p>\n\n<p>每一帧的回调函数，方便链式调用。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>callback</span> : Function<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/qrenderer.animation.AnimationProcess\" rel=\"qrenderer.animation.AnimationProcess\" class=\"docClass\">qrenderer.animation.AnimationProcess</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isFinished' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.animation.AnimationProcess'>qrenderer.animation.AnimationProcess</span><br/><a href='source/AnimationProcess.html#qrenderer-animation-AnimationProcess-method-isFinished' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.animation.AnimationProcess-method-isFinished' class='name expandable'>isFinished</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Determine wether the entire animation process has finished, when the animations of all the tracks are finished, the a...</div><div class='long'><p>Determine wether the entire animation process has finished, when the animations of all the tracks are finished, the animation process is finished.</p>\n\n<p>判断整个动画过程是否已经完成，所有 Track 上的动画都完成则整个动画过程完成。</p>\n</div></div></div><div id='method-isPaused' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.animation.AnimationProcess'>qrenderer.animation.AnimationProcess</span><br/><a href='source/AnimationProcess.html#qrenderer-animation-AnimationProcess-method-isPaused' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.animation.AnimationProcess-method-isPaused' class='name expandable'>isPaused</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Wether the process is paused. ...</div><div class='long'><p>Wether the process is paused.</p>\n\n<p>是否暂停。</p>\n</div></div></div><div id='method-nextFrame' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.animation.AnimationProcess'>qrenderer.animation.AnimationProcess</span><br/><a href='source/AnimationProcess.html#qrenderer-animation-AnimationProcess-method-nextFrame' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.animation.AnimationProcess-method-nextFrame' class='name expandable'>nextFrame</a>( <span class='pre'>time, delta</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Enter next frame. ...</div><div class='long'><p>Enter next frame.</p>\n\n<p>进入下一帧。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>time</span> : Number<div class='sub-desc'><p>Current time.</p>\n\n<p>当前时间。</p>\n</div></li><li><span class='pre'>delta</span> : Number<div class='sub-desc'><p>Time offset.</p>\n\n<p>时间偏移量。</p>\n</div></li></ul></div></div></div><div id='method-pause' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.animation.AnimationProcess'>qrenderer.animation.AnimationProcess</span><br/><a href='source/AnimationProcess.html#qrenderer-animation-AnimationProcess-method-pause' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.animation.AnimationProcess-method-pause' class='name expandable'>pause</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Pause the animation. ...</div><div class='long'><p>Pause the animation.</p>\n\n<p>暂停动画。</p>\n</div></div></div><div id='method-resume' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.animation.AnimationProcess'>qrenderer.animation.AnimationProcess</span><br/><a href='source/AnimationProcess.html#qrenderer-animation-AnimationProcess-method-resume' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.animation.AnimationProcess-method-resume' class='name expandable'>resume</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Resume the animation. ...</div><div class='long'><p>Resume the animation.</p>\n\n<p>恢复动画。</p>\n</div></div></div><div id='method-start' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.animation.AnimationProcess'>qrenderer.animation.AnimationProcess</span><br/><a href='source/AnimationProcess.html#qrenderer-animation-AnimationProcess-method-start' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.animation.AnimationProcess-method-start' class='name expandable'>start</a>( <span class='pre'>loop, [easing], forceAnimate</span> ) : <a href=\"#!/api/qrenderer.animation.AnimationProcess\" rel=\"qrenderer.animation.AnimationProcess\" class=\"docClass\">qrenderer.animation.AnimationProcess</a><span class=\"signature\"></span></div><div class='description'><div class='short'>Start to execute the animation. ...</div><div class='long'><p>Start to execute the animation.</p>\n\n<p>开始执行动画。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>loop</span> : Boolean<div class='sub-desc'><p>Whether loop the animation.</p>\n\n<p>是否循环。</p>\n</div></li><li><span class='pre'>easing</span> : String|Function (optional)<div class='sub-desc'><p>Name of the easing function, see easing engine.</p>\n\n<p>缓动函数名称，详见缓动引擎。</p>\n</div></li><li><span class='pre'>forceAnimate</span> : Boolean<div class='sub-desc'><p>Whethe to force the animation.</p>\n\n<p>是否强制开启动画。</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/qrenderer.animation.AnimationProcess\" rel=\"qrenderer.animation.AnimationProcess\" class=\"docClass\">qrenderer.animation.AnimationProcess</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-stop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.animation.AnimationProcess'>qrenderer.animation.AnimationProcess</span><br/><a href='source/AnimationProcess.html#qrenderer-animation-AnimationProcess-method-stop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.animation.AnimationProcess-method-stop' class='name expandable'>stop</a>( <span class='pre'>forwardToLast</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Stop the animation. ...</div><div class='long'><p>Stop the animation.</p>\n\n<p>停止动画。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>forwardToLast</span> : Boolean<div class='sub-desc'><p>Whether move to the last frame before animation stops.</p>\n\n<p>是否在动画停止之前跳到最后一帧。</p>\n</div></li></ul></div></div></div><div id='method-when' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='qrenderer.animation.AnimationProcess'>qrenderer.animation.AnimationProcess</span><br/><a href='source/AnimationProcess.html#qrenderer-animation-AnimationProcess-method-when' target='_blank' class='view-source'>view source</a></div><a href='#!/api/qrenderer.animation.AnimationProcess-method-when' class='name expandable'>when</a>( <span class='pre'>time, config</span> ) : <a href=\"#!/api/qrenderer.animation.AnimationProcess\" rel=\"qrenderer.animation.AnimationProcess\" class=\"docClass\">qrenderer.animation.AnimationProcess</a><span class=\"signature\"></span></div><div class='description'><div class='short'>Create a track for each property that needs to be animated. ...</div><div class='long'><p>Create a track for each property that needs to be animated. The animation properties supported by Quark Renderer are position, shape, and style.</p>\n\n<p>为每一种需要进行动画的属性创建一条轨道，Quark Renderer 能支持动画的属性有 position、shape、style。</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>time</span> : Number<div class='sub-desc'><p>Lifetime of the keyframe, in milliseconds.</p>\n\n<p>关键帧的存活时间，单位是毫秒ms。</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Properties of the keyframe, in key-value shape.</p>\n\n<p>关键帧的属性值，key-value 表示。</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/qrenderer.animation.AnimationProcess\" rel=\"qrenderer.animation.AnimationProcess\" class=\"docClass\">qrenderer.animation.AnimationProcess</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});