;================================================================================================
;
; STANDARD MOVES
; 
;================================================================================================

; Jump Start
;-----------

[Statedef 40]
type = S
movetype = I
physics = S
anim = 40
sprpriority = 1
velset = 0,0
ctrl = 0

[State 40, throw invincibility]
type = nothitby
trigger1 = 1
value = , NT, ST, HT

[State 40, long jump var init]
type = VarSet
trigger1 = time = 0
v = 2
value = (PrevStateNo = 100 || command = "DU")

[State 40, sys var init]
type = VarSet
trigger1 = Time = 0
sysvar(1) = 0

[State 40, var set]
type = VarSet
trigger1 = command = "holdfwd"
sysvar(1) = 1

[State 40, var set]
type = VarSet
trigger1 = command = "holdback"
sysvar(1) = -1

[State 40, fwd velocity]
type = VelSet
trigger1 = AnimTime = 0 && var(2) = 0 && sysvar(1) = 1
x = const(velocity.jump.fwd.x) - 0.5*(command != "holdup")

[State 40, fast fwd velocity]
type = VelSet
trigger1 = AnimTime = 0 && var(2) = 1 && sysvar(1) = 1
x = const(velocity.runjump.fwd.x) - 0.15*(command != "holdup")

[State 40, back velocity]
type = VelSet
trigger1 = AnimTime = 0 && var(2) = 0 && sysvar(1) = -1
x = const(velocity.jump.back.x) + 0.125*(command != "holdup")

[State 40, fast back velocity]
type = VelSet
trigger1 = AnimTime = 0 && var(2) = 1 && sysvar(1) = -1
x = const(velocity.runjump.back.x) + 0.15*(command != "holdup")

[State 40, vertical velocity]
type = VelSet
trigger1 = AnimTime = 0
y = const(velocity.jump.y) + 3.5*(command != "holdup")

[State 40, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 50
ctrl = 1



; Jump Up
;--------

[Statedef 50]
type = A
movetype = I
physics = A
sprpriority = 1

[State 50, var init]
type = VarSet
trigger1 = time = 0
sysvar(1) = 0

[State 50, standard animation]
type = ChangeAnim
trigger1 = time = 0 && vel y = const(velocity.jump.y)
value = ifelse((vel x)=0, 41, ifelse((vel x)>0, 42, 43))

[State 50, short animation]
type = ChangeAnim
trigger1 = time = 0 && vel y = (const(velocity.jump.y) + 3.5)
value = 48

[State 50, after images]
type = Afterimage
triggerall = time = 0
trigger1 = vel x > const(velocity.jump.fwd.x)
trigger2 = vel x < const(velocity.jump.back.x)
time = 10
PalBright = 0, 0, 0
PalContrast =  250,250,250
PalAdd = 0, 0, 0
PalMul = 1,1,1
Length = 7
FrameGap = 3

[State 50, control limiter] ;Can't attack after recovery
type = ctrlset
trigger1 = Time = 0
trigger1 = prevstateno = 5040
trigger1 = prevstateno = 5210
value = 0

[State 50, standard jump sound]
type = PlaySnd
triggerall = time = 0
trigger1 = vel x < const(velocity.jump.fwd.x)
trigger2 = vel x > const(velocity.jump.back.x)
value = 100,1
channel = 1

[State 50, fast jump sound]
type = PlaySnd
triggerall = time = 0
trigger1 = vel x > const(velocity.jump.fwd.x)
trigger2 = vel x < const(velocity.jump.back.x)
value = 100,2
channel = 1



; Jump Land
;----------

[Statedef 52]
type = S
movetype = I
physics = S
anim = 47
sprpriority = 1
ctrl = 1
facep2 = 1

[State 52, velocity]
type = VelSet
trigger1 = time = 0
x = 0
y = 0

[State 52, position]
type = PosSet
trigger1 = time = 0
y = 0

[State 52, land sound]
type = PlaySnd
trigger1 = time = 0
value = 100,3
channel = 1

[State 52, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



; Run
;----

[Statedef 100]
type    = S
physics = S
anim = 100
sprpriority = 1

[State 100, velocity]
type = VelSet
trigger1 = 1
x = const(velocity.run.fwd.x)

[State 100, dont walk]
type = AssertSpecial
trigger1 = 1
flag = NoWalk

[State 100, dont turn]
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 100, run sound]
type = PlaySnd
trigger1 = time = 0
trigger2 = Time%68 = 0
value = 110,1
channel = 1

[State 100, end state]
type = ChangeState
trigger1 = command != "holdfwd"
value = 0



; Hop Back - start
;---------

[Statedef 105]
type = S
movetype = I
physics = S
anim = 105
sprpriority = 1
ctrl = 0

[State 105, throw invincibility]
type = nothitby
trigger1 = statetype = S
value = , NT, ST, HT

[State 105, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 106

; Hop Back - air
;---------

[Statedef 106]
type = A
movetype = I
physics = A
anim = 106
sprpriority = 1
ctrl = 0

[State 106, velocity]
type = VelSet
trigger1 = time >= 0
x = const(velocity.run.back.x)
y = const(velocity.run.back.y)

[State 106, position]
type = PosSet
trigger1 = time = 0
y = -3

[State 106, jump sound]
type = PlaySnd
trigger1 = time = 2
value = 110,2
channel = 1

[State 106, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 107

; Hop Back - land
;---------

[Statedef 107]
type = S
movetype = I
physics = S
anim = 107
sprpriority = 1
ctrl = 0

[State 107, velocity]
type = VelSet
trigger1 = time = 0
x = 0
y = 0

[State 107, position]
type = PosSet
trigger1 = time = 0
y = 0

[State 107, land sound]
type = PlaySnd
trigger1 = time = 1
value = 100,3
channel = 1

[State 107, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



; Roll Forward ; Adapted from Sander's E-TerryX
;-------------

[Statedef 950]
type = S
movetype = I
physics = N
anim = 950
velset = 0,0
ctrl = 0

[State 950, evade pause]
type = SuperPause
trigger1 = PrevStateNo = 150 || PrevStateNo = 152
trigger1 = time = 0
time = 11
movetime = 9
anim = -1
darken = 0
poweradd = -1000

[State 950, hit by]
type = HitBy
trigger1 = time <= 27
value = SCA, NT, ST, HT

[State 950, ghost]
type = PlayerPush
trigger1 = time < 24
value = 0

[State 950, stop ghost]
type = PlayerPush
trigger1 = time >= 24
value = 1

[State 950, sprite priority]
type = SprPriority
trigger1 = AnimElem = 3
value = -1

[State 950, velocity]
type = VelSet
trigger1 = AnimElem = 3
x = 5 + 2*(PrevStateNo = 100)

[State 950, end roll velocity]
type = VelSet
trigger1 = AnimElem = 9
x = 0

[State 950, roll after images]
type = AfterImage
trigger1 = PrevStateNo != 150 && PrevStateNo != 152
trigger1 = time = 3
time = 15
PalBright = 0, 0, 0
PalContrast =  250,250,250
PalAdd = 0, 0, 0
PalMul = 1,1,1
Length = 6
FrameGap = 2

[State 950, evade after images]
type = AfterImage
trigger1 = PrevStateNo = 150 || PrevStateNo = 152
trigger1 = time = 3
time = 15
PalAdd = 0, 0, 0
PalMul = 1,1,1
Length = 9
FrameGap = 3

[State 950, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



; Roll Back ; Adapted from Sander's E-TerryX
;----------

[Statedef 960]
type = S
movetype = I
physics = N
anim = 960
sprpriority = -2
velset = 0,0
ctrl = 0

[State 960, evade pause]
type = SuperPause
trigger1 = PrevStateNo = 150 || PrevStateNo = 152
trigger1 = time = 0
time = 11
movetime = 9
anim = -1
darken = 0
poweradd = -1000

[State 960, hit by]
type = HitBy
trigger1 = time <= 25
value = SCA, NT, ST, HT

[State 960, ghost]
type = PlayerPush
trigger1 = time < 24
value = 0

[State 960, stop ghost]
type = PlayerPush
trigger1 = time >= 24
value = 1

[State 960, sprite priority]
type = SprPriority
trigger1 = AnimElem = 3
value = -1

[State 950, velocity]
type = VelSet
trigger1 = AnimElem = 2
x = -5

[State 960, end roll velocity]
type = VelSet
trigger1 = AnimElem = 9
x = 0

[State 960, roll after images]
type = AfterImage
trigger1 = PrevStateNo != 150 && PrevStateNo != 152
trigger1 = time = 3
time = 15
PalBright = 0, 0, 0
PalContrast =  250,250,250
PalAdd = 0, 0, 0
PalMul = 1,1,1
Length = 6
FrameGap = 2

[State 960, evade after images]
type = AfterImage
trigger1 = PrevStateNo = 150 || PrevStateNo = 152
trigger1 = time = 3
time = 15
PalAdd = 0, 0, 0
PalMul = 1,1,1
Length = 9
FrameGap = 3

[State 960, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



: Ground Recovery
;----------------

[Statedef 5201]
type = C
movetype= H
physics = C
anim = 5200

[State 5201, turn] ;Turn if not facing opponent
type = Turn
trigger1 = Time = 0
trigger1 = p2dist X < -5

[State 5201, position]
type = PosSet
trigger1 = Time = 0
y = 0

[State 5201, velocity]
type = VelSet
trigger1 = 1
x = -4
y = 0

[State 5201, invincibility]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 5201, after images]
type = AfterImage
trigger1 = time = 0
time = 19
length = 9
palbright = 72,72,72
palcontrast = 128,128,128
paladd = 0,0,0
palmul = 1,1,1
timegap = 1
framegap = 4

[State 5201, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



; Air Recovery
;-------------

[Statedef 5210]
type = A
movetype = I
physics = N
anim = 5210
ctrl = 0

[State 5210, 1]
type = PosFreeze
trigger1 = Time = 0
value = 4

[State 5210, 2] ;Turn if not facing opponent
type = Turn
trigger1 = Time = 0
trigger1 = p2dist X < -20

[State 5210, 1] 
type = VelMul
trigger1 = Time = 4
x = .8
y = .8

[State 5210, 1]
type = VelAdd
trigger1 = Time = 4
y = -4.5

[State 5210, 1] 
type = VelMul
trigger1 = Time = 4
trigger1 = Vel Y > 0
y = .5

[State 5210, 1]
type = VelAdd
trigger1 = Time = 4
trigger1 = Vel Y > -3
y = -2

[State 5210, 1]
type = VelAdd
trigger1 = Time = 4
trigger1 = Vel Y > -2
y = -1

[State 5210, 2] ;Go up
type = VelAdd
trigger1 = Time = 4
y = -2

[State 5210, 2] ;Go back
type = VelAdd
trigger1 = Time = 4
trigger1 = Command = "holdback"
x = -1

[State 5210, 3]
type = NotHitBy
trigger1 = Time = 0
value = SCA
time = 15

[State 5210, 4]
type = CtrlSet
trigger1 = Time = 20
value = 1

[State 5210, 5]
type = VelAdd;Gravity
trigger1 = Time >= 4
y = .35

[State 5210, 5] ;Land on ground
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value = 52 ;JUMP_LAND
ctrl = 1



;================================================================================================
;
; INTROS, ENDINGS & TAUNT
; 
;================================================================================================

; Loose
;------

[StateDef 170]
type = S
movetype = I
physics = S
anim = 175
sprpriority = 1
velset = 0,0
ctrl = 0

[State 170, invincibility]
type = NotHitBy
trigger1 = 1
value = SCA

[State 170, voice]
type = PlaySnd
trigger1 = AnimElem = 4
value = 10,3
channel = 0



; Win
;----

; Choose Win Pose
;----------------

[StateDef 180]
type = S
movetype = I
physics = S
velset = 0,0
ctrl = 0

[State 180, invincibility]
type = NotHitBy
trigger1 = 1
value = SCA

[State 180, assert special]
type = AssertSpecial
trigger1 = 1
flag = RoundNotOver

[State 180, randomizer]
type = VarRandom
trigger1 = time = 0
v = 1
range = 1,3

[State 180, end state]
type = ChangeState
trigger1 = var(1) = [1,3]
value = 180 + var(1)

; 1st Win Pose
;-------------

[StateDef 181]
type = S
movetype = I
physics = S
anim = 181
sprpriority = 1

[State 181, invincibility]
type = NotHitBy
trigger1 = 1
value = SCA

[State 181, voice]
type = PlaySnd
trigger1 = AnimElem = 4
value = 20,2
channel = 0

[State 181, assert special]
type = AssertSpecial
trigger1 = time <= 120
flag = RoundNotOver

; 2nd Win Pose
;-------------

[StateDef 182]
type = S
movetype = I
physics = S
anim = 182
sprpriority = 1

[State 182, invincibility]
type = NotHitBy
trigger1 = 1
value = SCA

[State 182, voice 1]
type = PlaySnd
trigger1 = AnimElem = 7, = 0
value = 30,2
channel = 0

[State 182, voice 2]
type = PlaySnd
trigger1 = AnimElem = 7, = 30
value = 20,3
channel = 0

[State 182, assert special]
type = AssertSpecial
trigger1 = time <= 120
flag = RoundNotOver

; 3rd Win Pose
;-------------

[StateDef 183]
type = S
movetype = I
physics = S
anim = 183
sprpriority = 1

[State 183, invincibility]
type = NotHitBy
trigger1 = 1
value = SCA

[State 183, sound]
type = PlaySnd
trigger1 = AnimElem = 6
value = 120,2
channel = 1

[State 183, assert special]
type = AssertSpecial
trigger1 = time <= 120
flag = RoundNotOver


; Intro
;------

[StateDef 190]
type = S
movetype = I
physics = S
sprpriority = 1

[State 190, animation]
type = ChangeAnim
trigger1 = RoundState = 0
trigger2 = RoundState = 1 && P2Name = "Billy" && time <= 70
value = 191

[State 190, assert special]
type = AssertSpecial
trigger1 = 1
flag = intro

[State 190, vs any opponent voice]
type = PlaySnd
trigger1 = P2Name != "Billy" &&  P2Name != "Johann" &&  P2Name != "Jones"
trigger1 = AnimElem = 3
value = 20,1
channel = 0

[State 190, vs Billy]
type = PlaySnd
trigger1 = P2Name = "Billy"
trigger1 = AnimElem = 3
value = 70,1
channel = 0

[State 190, vs Johann]
type = PlaySnd
trigger1 = P2Name = "Johann"
trigger1 = AnimElem = 12
value = 70,2
channel = 0

[State 190, vs Jones]
type = PlaySnd
trigger1 = P2Name = "Jones"
trigger1 = AnimElem = 12
value = 70,3
channel = 0

[State 190, sound]
type = PlaySnd
trigger1 = AnimElem = 8
value = 120,2
channel = 0

[State 190, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0


; Taunt
;------

[StateDef 195]
type = S
movetype = I
physics = S
sprpriority = 1
velset = 0,0

[State 195, animation]
type = ChangeAnim
trigger1 = anim != 195
value = 195

[State 170, voice]
type = PlaySnd
trigger1 = AnimElem = 3, = 1
value = 10,1
channel = 0

[State 195, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0



;================================================================================================
;
; STANDARD ATTACKS
;
;================================================================================================

; Stand Weak Punch
;-----------------

[StateDef 200]
type = S
movetype = A
physics = S
sprpriority = 2
velset = 0,0
ctrl = 0
juggle = 10

[State 200, animation]
type = ChangeAnim
trigger1 = time = 0
value = 200 + 5*(P2BodyDist x <= 20)

[State 200, voice]
type = PlaySnd
trigger1 = AnimElem = 2
value = 30,1
channel = 0

[State 200, sound]
type = PlaySnd
trigger1 = AnimElem = 1
value = 120,1
channel = 1

[State 200, hit def]
type = HitDef
triggerall = p2stateno != [5020,5040]
triggerall = p2stateno != [154,155] 
trigger1 = AnimElem = 2
attr = S, NA
hitflag = MAF
guardflag = MA
animtype = light
air.animtype = back
ground.type = high
priority = 7, hit
damage = 32,0
getpower = 45,45
givepower = 15,15
sparkno = 0
guard.sparkno = 40
sparkxy = 0, -64 - 6*(anim=205)
hitsound = s140,1
guardsound = s150,1
pausetime = 13,13
ground.slidetime = 9
ground.hittime = 9
ground.velocity = -6.3
ground.cornerpush.veloff = -6
guard.pausetime = 11,11
guard.slidetime = 10
guard.hittime = 20
guard.ctrtime = 20
guard.velocity = -6.1
guard.cornerpush.veloff = -6
air.velocity = -3.5,-6
airguard.velocity = -3.5,-1
air.cornerpush.veloff = 0
yaccel = 0.5 

[State 200, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



; Stand Weak Kick
;----------------

[StateDef 210]
type = S
movetype = A
physics = S
sprpriority = 2
velset = 0,0
ctrl = 0
juggle = 10

[State 210, animation]
type = ChangeAnim
trigger1 = time = 0
value = 210 + 5*(P2BodyDist x <= 20)

[State 210, sound]
type = PlaySnd
trigger1 = AnimElem = 3
value = 120,1
channel = 1

[State 210, hit def]
type = HitDef
triggerall = p2stateno != [5020,5040]
triggerall = p2stateno != [154,155] 
trigger1 = AnimElem = 3
attr = S, NA
hitflag = MAF
guardflag = MA
animtype = light
air.animtype = back
ground.type = low
priority = 7, hit
damage = 32,0
getpower = 45,45
givepower = 15,15
sparkno = 0
guard.sparkno = 40
sparkxy = 0, -32
hitsound = s140,2
guardsound = s150,1
pausetime = 13,13
ground.slidetime = 9
ground.hittime = 9
ground.velocity = -6.3
ground.cornerpush.veloff = -6
guard.pausetime = 11,11
guard.slidetime = 10
guard.hittime = 20
guard.ctrtime = 20
guard.velocity = -6.1
guard.cornerpush.veloff = -6
air.velocity = -3.5,-6
airguard.velocity = -3.5,-1
air.cornerpush.veloff = 0
yaccel = 0.5 

[State 210, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



; Stand Fierce Punch
;-------------------

[StateDef 220]
type = S
movetype = A
physics = S
sprpriority = 2
velset = 0,0
ctrl = 0
juggle = 10

[State 220, animation]
type = ChangeAnim
trigger1 = time = 0
value = 220 + 5*(P2BodyDist x <= 20)

[State 220, voice]
type = PlaySnd
trigger1 = anim = 220 && AnimElem = 5
trigger2 = anim = 225 && AnimElem = 4
value = 30,2
channel = 0

[State 220, sound]
type = PlaySnd
trigger1 = anim = 220 && AnimElem = 4
trigger2 = anim = 225 && AnimElem = 3
value = 120,2
channel = 1

[State 220, hit def]
type = HitDef
triggerall = p2stateno != [5020,5040]
triggerall = p2stateno != [154,155] 
trigger1 = AnimElem = 4
attr = S, NA
hitflag = MAF
guardflag = MA
animtype = hard
air.animtype = back
ground.type = high
priority = 4, hit
damage = 104,0
getpower = 90,90
givepower = 15,15
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -54 - 16*(anim=225)
hitsound = s140, 3
guardsound = s150, 0
pausetime = 13,13
ground.slidetime = 17
ground.hittime = 17
ground.velocity = -12
ground.cornerpush.veloff = -17
guard.pausetime = 11,11
guard.slidetime = 18
guard.hittime = 36
guard.ctrtime = 36
guard.velocity = -12
guard.cornerpush.veloff = -17
air.velocity = -3.5,-6
airguard.velocity = -4,-6
air.cornerpush.veloff = -6
yaccel = 0.5 

[State 220, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



; Stand Fierce Kick
;------------------

[StateDef 230]
type = S
movetype = A
physics = S
sprpriority = 2
velset = 0,0
ctrl = 0
juggle = 10

[State 230, animation]
type = ChangeAnim
trigger1 = time = 0
value = 230 + 5*(P2BodyDist x <= 20)

[State 230, sound]
type = PlaySnd
trigger1 = AnimElem = 2
value = 120,2
channel = 1

[State 230, hit def]
type = HitDef
triggerall = p2stateno != [5020,5040]
triggerall = p2stateno != [154,155] 
trigger1 = AnimElem = 4
attr = S, NA
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = high
air.animtype = back
priority = 4, hit
damage = 115,0
getpower = 90,90
givepower = 15,15
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -58 - 4*(anim=235)
hitsound = s140, 4
guardsound = s150, 0
pausetime = 13,13
ground.slidetime = 17
ground.hittime = 17
ground.velocity = -12
ground.cornerpush.veloff = -17
guard.pausetime = 11,11
guard.slidetime = 18
guard.hittime = 36
guard.ctrtime = 36
guard.velocity = -12
guard.cornerpush.veloff = -17
air.velocity = -3.5,-6
airguard.velocity = -4,-1.5
air.cornerpush.veloff = -6
yaccel = 0.5 

[State 230, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



; Crouch Weak Punch
;------------------

[StateDef 300]
type = C
movetype = A
physics = C
anim = 300
sprpriority = 2
velset = 0,0
ctrl = 0
juggle = 10

[State 300, voice]
type = PlaySnd
trigger1 = AnimElem = 2
value = 30,1
channel = 0

[State 300, sound]
type = PlaySnd
trigger1 = AnimElem = 1
value = 120,1
channel = 1

[State 300, hit def]
type = HitDef
triggerall = p2stateno != [5020,5040]
triggerall = p2stateno != [154,155] 
trigger1 = AnimElem = 2
attr = C, NA
hitflag = MAF
guardflag = MA
animtype = light
ground.type = low
air.animtype = back
priority = 7, hit
damage = 32,0
getpower = 45,45
givepower = 15,15
sparkno = 0
guard.sparkno = 40
sparkxy = 0, -42
hitsound = s140, 1
guardsound = s150, 0
pausetime = 13,13
ground.slidetime = 9
ground.hittime = 9
ground.velocity = -6.3
ground.cornerpush.veloff = -6
guard.pausetime = 11,11
guard.slidetime = 10
guard.hittime = 20
guard.ctrtime = 20
guard.velocity = -6.1
guard.cornerpush.veloff = -6
air.velocity = -3.5,-6
airguard.velocity = -2.5,-1
air.cornerpush.veloff = 0
yaccel = 0.5 

[State 300, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 11
ctrl = 1



; Crouch Weak Kick
;-----------------

[StateDef 310]
type = C
movetype = A
physics = C
anim = 310
sprpriority = 2
velset = 0,0
ctrl = 0
juggle = 10

[State 310, sound]
type = PlaySnd
trigger1 = AnimElem = 1
value = 120,1
channel = 1

[State 310, hit def]
type = HitDef
triggerall = p2stateno != [5020,5040]
triggerall = p2stateno != [154,155] 
trigger1 = AnimElem = 2
attr = C, NA
hitflag = MAF
guardflag = MA
animtype = light
ground.type = low
air.animtype = back
priority = 7, hit
damage = 32,0
getpower = 45,45
givepower = 15,15
sparkno = 0
guard.sparkno = 40
sparkxy = 0, -10
hitsound = s140, 2
guardsound = s150, 0
pausetime = 13,13
ground.slidetime = 9
ground.hittime = 9
ground.velocity = -6.3
ground.cornerpush.veloff = -6
guard.pausetime = 11,11
guard.slidetime = 10
guard.hittime = 20
guard.ctrtime = 20
guard.velocity = -6.1
guard.cornerpush.veloff = -6
air.velocity = -3.5,-6
airguard.velocity = -2.5,-1
air.cornerpush.veloff = 0
yaccel = 0.5 

[State 310, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 11
ctrl = 1



; Crouch Fierce Punch
;--------------------

[StateDef 320]
type = C
movetype = A
physics = C
anim = 320
sprpriority = 2
velset = 0,0
ctrl = 0
juggle = 10

[State 320, voice]
type = PlaySnd
trigger1 = AnimElem = 2
value = 30,2
channel = 0

[State 320, sound]
type = PlaySnd
trigger1 = AnimElem = 1
value = 120,2
channel = 1

[State 320, hit def]
type = HitDef
triggerall = p2stateno != [5020,5040]
triggerall = p2stateno != [154,155] 
trigger1 = AnimElem = 2
attr = C, NA
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = low
air.animtype = back
priority = 4, hit
damage = 94,0
getpower = 90,90
givepower = 15,15
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -54
hitsound = s140, 3
guardsound = s150, 0
pausetime = 13,13
ground.slidetime = 17
ground.hittime = 17
ground.velocity = -12
ground.cornerpush.veloff = -17
guard.pausetime = 11,11
guard.slidetime = 18
guard.hittime = 36
guard.ctrtime = 36
guard.velocity = -12
guard.cornerpush.veloff = -17
air.velocity = -3.5,-6
airguard.velocity = -4,-1.5
air.cornerpush.veloff = -6
yaccel = 0.5 

[State 320, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 11
ctrl = 1



; Crouch Fierce Kick
;-------------------

[StateDef 330]
type = C
movetype = A
physics = C
anim = 330
sprpriority = 2
velset = 0,0
ctrl = 0
juggle = 10

[State 330, sound]
type = PlaySnd
trigger1 = AnimElem = 3
value = 120,2
channel = 1

[State 330, hit def]
type = HitDef
triggerall = p2stateno != [5020,5040]
triggerall = p2stateno != [154,155] 
trigger1 = AnimElem = 4
attr = C, NA
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = trip
air.animtype = back
priority = 4, hit
damage = 115,0
getpower = 90,90
givepower = 15,15
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -10
hitsound = s140, 4
guardsound = s150, 0
pausetime = 13,13
ground.velocity = -3,-7
ground.cornerpush.veloff = -17
guard.pausetime = 11,11
guard.slidetime = 18
guard.hittime = 36
guard.ctrtime = 36
guard.velocity = -12
guard.cornerpush.veloff = -17
air.velocity = -3.5,-6
airguard.velocity = -4,-1.7
air.cornerpush.veloff = -6
fall = 1
fall.recovertime = 20
yaccel = 0.5 

[State 330, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 11
ctrl = 1



; Air Weak Punch
;---------------

[StateDef 400]
type = A
movetype = A
physics = A
anim = 400
sprpriority = 2
ctrl = 0
juggle = 10

[State 400, air animation]
type = ChangeAnim
trigger1 = anim = 400 && AnimTime = 0
value = 41
elem = 5

[State 400, voice]
type = PlaySnd
trigger1 = AnimElem = 2
value = 30,1
channel = 0

[State 400, sound]
type = PlaySnd
trigger1 = AnimElem = 1
value = 120,1
channel = 1

[State 400, hit def]
type = HitDef
triggerall = p2stateno != [5020,5040]
triggerall = p2stateno != [154,155] 
trigger1 = AnimElem = 2
attr = A, NA
hitflag = MAF
guardflag = HA
animtype = light
ground.type = high
air.animtype = back
priority = 7, hit
damage = 32,0
getpower = 45,45
givepower = 15,15
sparkno = 0
guard.sparkno = 40
sparkxy = 0, -55
hitsound = s140, 1
guardsound = s150, 0
pausetime = 11,13
ground.slidetime = 9
ground.hittime = 9
ground.velocity = -6.1
ground.cornerpush.veloff = -6
guard.pausetime = 11,11
guard.slidetime = 10
guard.hittime = 20
guard.ctrtime = 20
guard.velocity = -6.1
guard.cornerpush.veloff = -6
air.velocity = -3.5,-6
airguard.velocity = -2.5,-1
air.cornerpush.veloff = 0
yaccel = 0.5 



; Air Weak Kick
;--------------

[StateDef 410]
type = A
movetype = A
physics = A
anim = 410
sprpriority = 2
ctrl = 0
juggle = 10

[State 410, air animation]
type = ChangeAnim
trigger1 = anim = 410 && AnimTime = 0
value = 41
elem = 5

[State 410, sound]
type = PlaySnd
trigger1 = AnimElem = 2
value = 120,1
channel = 1

[State 410, hit def]
type = HitDef
triggerall = p2stateno != [5020,5040]
triggerall = p2stateno != [154,155] 
trigger1 = AnimElem = 2
attr = A, NA
hitflag = MAF
guardflag = HA
animtype = light
ground.type = high
air.animtype = back
priority = 7, hit
damage = 32,0
getpower = 45,45
givepower = 15,15
sparkno = 0
guard.sparkno = 40
sparkxy = 0, -40
hitsound = s140, 2
guardsound = s150, 0
pausetime = 11,13
ground.slidetime = 9
ground.hittime = 9
ground.velocity = -6.1
ground.cornerpush.veloff = -6
guard.pausetime = 11,11
guard.slidetime = 10
guard.hittime = 20
guard.ctrtime = 20
guard.velocity = -6.1
guard.cornerpush.veloff = -6
air.velocity = -3.5,-6
airguard.velocity = -2.5,-1
air.cornerpush.veloff = 0
yaccel = 0.5 



; Air Fierce Punch
;-----------------

[StateDef 420]
type = A
movetype = A
physics = A
sprpriority = 2
ctrl = 0
juggle = 10

[State 420, animation]
type = ChangeAnim
trigger1 = time = 0
value = 420 + 20*(vel x != 0)

[State 420, air animation]
type = ChangeAnim
trigger1 = (anim = 420 || anim = 440) && AnimTime = 0
value = 41
elem = 5

[State 420, voice]
type = PlaySnd
trigger1 = anim = 420 && AnimElem = 3
trigger2 = anim = 440 && AnimElem = 4
value = 30,2
channel = 0

[State 420, sound]
type = PlaySnd
trigger1 = anim = 420 && AnimElem = 2
trigger2 = anim = 440 && AnimElem = 3
value = 120,2
channel = 1

[State 420, hit def]
type = HitDef
triggerall = p2stateno != [5020,5040]
triggerall = p2stateno != [154,155] 
trigger1 = AnimElem = 3
attr = A, NA
hitflag = MAF
guardflag = HA
animtype = hard
ground.type = high
air.animtype = back
priority = 4, hit
damage = 104,0
getpower = 90,90
givepower = 15,15
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -85 + 10*(anim = 440)
hitsound = s140, 3
guardsound = s150, 0
pausetime = 11,13
ground.slidetime = 9
ground.hittime = 9
ground.velocity = -6.1
ground.cornerpush.veloff = -6
guard.pausetime = 11,11
guard.slidetime = 17
guard.hittime = 20
guard.ctrtime = 20
guard.velocity = -6.1
guard.cornerpush.veloff = -6
air.velocity = -3.5,-6
airguard.velocity = -3,-1.5
air.cornerpush.veloff = 0
yaccel = 0.5 



; Air Fierce Kick
;----------------

[StateDef 430]
type = A
movetype = A
physics = A
sprpriority = 2
ctrl = 0
juggle = 10

[State 430, animation]
type = ChangeAnim
trigger1 = time = 0
value = 430 + 20*(vel x != 0)

[State 430, air animation]
type = ChangeAnim
trigger1 = (anim = 430 || anim = 450) && AnimTime = 0
value = 41
elem = 5

[State 430, sound]
type = PlaySnd
trigger1 = anim = 430 && AnimElem = 2
trigger2 = anim = 450 && AnimElem = 3
value = 120,2
channel = 1

[State 430, hit def]
type = HitDef
triggerall = p2stateno != [5020,5040]
triggerall = p2stateno != [154,155] 
trigger1 = AnimElem = 3
attr = A, NA
hitflag = MAF
guardflag = HA
animtype = hard
ground.type = high
air.animtype = back
priority = 4, hit
damage = 104,0
getpower = 45,45
givepower = 15,15
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -45 - 25*(anim = 450)
hitsound = s140, 4
guardsound = s150, 0
pausetime = 11,13
ground.slidetime = 9
ground.hittime = 9
ground.velocity = -6.1
ground.cornerpush.veloff = -6
guard.pausetime = 11,11
guard.slidetime = 17
guard.hittime = 20
guard.ctrtime = 20
guard.velocity = -6.1
guard.cornerpush.veloff = -6
air.velocity = -3.5,-6
airguard.velocity = -3,-1.5
air.cornerpush.veloff = 0
yaccel = 0.5 



; Overhead Punch
;---------------

[StateDef 500]
type = S
movetype = A
physics = S
anim = 500
sprpriority = 2
velset = 0,0
ctrl = 0
juggle = 10

[State 500, voice]
type = PlaySnd
trigger1 = AnimElem = 6
value = 30,2
channel = 0

[State 500, sound]
type = PlaySnd
trigger1 = AnimElem = 4
value = 120,2
channel = 1

[State 500, hit def]
type = HitDef
triggerall = p2stateno != [5020,5040]
triggerall = p2stateno != [154,155] 
trigger1 = AnimElem = 6
attr = S, NA
hitflag = MAF
guardflag = HA
animtype = hard
ground.type = low
air.animtype = back
priority = 4, hit
damage = 94,0
getpower = 90,90
givepower = 15,15
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -48
hitsound = s140, 3
guardsound = s150, 0
pausetime = 11,13
ground.slidetime = 17
ground.hittime = 17
ground.velocity = -12
ground.cornerpush.veloff = -17
guard.pausetime = 11,11
guard.slidetime = 18
guard.hittime = 36
guard.ctrtime = 36
guard.velocity = -12
guard.cornerpush.veloff = -17
air.velocity = -3.5,-6
airguard.velocity = -4,-6
air.cornerpush.veloff = -6
air.fall = 1
yaccel = 0.5 

[State 500, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



; Ground Knock-Down Attack
;-------------------------

[StateDef 510]
type = S
movetype = A
physics = S
anim = 510
sprpriority = 2
velset = 0,0
ctrl = 0
juggle = 10

[State 510, evade pause] ; Adapted from Sander's E-TerryX
type = SuperPause
trigger1 = PrevStateNo = 150 || PrevStateNo = 152
trigger1 = time = 0
time = 11
movetime = 7
anim = -1
darken = 0
poweradd = -1000

[State 510, velocity]
type = VelSet
trigger1 = AnimElem = 4, >= 0
trigger1 = AnimElem = 6, < 0
x = 3.8

[State 510, voice]
type = PlaySnd
trigger1 = AnimElem = 5
value = 30,7
channel = 0

[State 510, sound]
type = PlaySnd
trigger1 = AnimElem = 4
value = 120,2
channel = 1

[State 510, hit def]
type = HitDef
trigger1 = AnimElem = 5
attr = S, NA
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = high
air.animtype = back
priority = 5, hit
damage = 132 - 40*(PrevStateNo = 150 || PrevStateNo = 152),0
getpower = 90,90
givepower = 15,15
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -55
hitsound = s140, 5
guardsound = s150, 0
pausetime = 11,13
ground.velocity = -4,-8
ground.cornerpush.veloff = -17
guard.pausetime = 11,11
guard.slidetime = 22
guard.hittime = 44
guard.ctrtime = 44
guard.velocity = -12
guard.cornerpush.veloff = -17
air.velocity = -4,-7
airguard.velocity = -4,-6
air.cornerpush.veloff = -6
fall = 1
fall.recover = 1
fall.recovertime = 65
yaccel = 0.5 

[State 510, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



; Air Back Kick
;--------------

[StateDef 600]
type = A
movetype = A
physics = A
anim = 600
sprpriority = 2
ctrl = 0
juggle = 10

[State 600, voice]
type = PlaySnd
trigger1 = AnimElem = 3
value = 30,2
channel = 0

[State 600, sound]
type = PlaySnd
trigger1 = AnimElem = 3
value = 120,2
channel = 1

[State 600, hit def]
type = HitDef
triggerall = p2stateno != [5020,5040]
triggerall = p2stateno != [154,155] 
trigger1 = AnimElem = 4
attr = A, NA
hitflag = MAF
guardflag = HA
animtype = hard
ground.type = high
air.type = low
priority = 4, hit
damage = 73,0
getpower = 90,90
givepower = 15,15
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -48
hitsound = s140, 4
guardsound = s150, 0
pausetime = 11,13
ground.slidetime = 9
ground.hittime = 9
ground.velocity = 6.1
ground.cornerpush.veloff = 6
guard.pausetime = 11,11
guard.slidetime = 17
guard.hittime = 20
guard.ctrtime = 20
guard.velocity = 6.1
guard.cornerpush.veloff = 6
air.velocity = 3.5,-6
airguard.velocity = 3,-1.5
air.cornerpush.veloff = 0
yaccel = 0.5 



; Air Knock-Down Attack
;----------------------

[StateDef 610]
type = A
movetype = A
physics = A
sprpriority = 2
ctrl = 0
juggle = 10

[State 610, animation]
type = ChangeAnim
trigger1 = time = 0
value = 610

[State 610, air animation]
type = ChangeAnim
trigger1 = anim = 610 && AnimTime = 0
value = 41
elem = 5

[State 610, voice]
type = PlaySnd
trigger1 = AnimElem = 4
value = 30,7
channel = 0

[State 610, sound]
type = PlaySnd
trigger1 = AnimElem = 3
value = 120,2
channel = 1

[State 610, hit def]
type = HitDef
trigger1 = AnimElem = 4
attr = S, NA
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = high
air.animtype = back
priority = 5, hit
damage = 132,0
getpower = 90,90
givepower = 15,15
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -80
hitsound = s140, 5
guardsound = s150, 0
pausetime = 11,13
ground.velocity = -4,-8
ground.cornerpush.veloff = -17
guard.pausetime = 11,11
guard.slidetime = 22
guard.hittime = 44
guard.ctrtime = 44
guard.velocity = -12
guard.cornerpush.veloff = -17
air.velocity = -4,-7
airguard.velocity = -4,-6
air.cornerpush.veloff = -6
fall = 1
fall.recover = 1
fall.recovertime = 65
yaccel = 0.5 



; Forward Ground Throw Attemp
;----------------------------

[StateDef 700]
type = S
movetype = A
physics = S
anim = 700
sprpriority = 2
velset = 0,0
ctrl = 0

[State 700, hit def]
type = HitDef
trigger1 = AnimElem = 1
attr = S, NT
hitflag = M
animtype = light
ground.type = high
priority = 4, miss
damage = 0, 0
getpower = 0, 0
pausetime = 0,0
sparkno = -1
p1facing = -1
p2facing = -1
p1stateno = 701
p2stateno = 710

[State 700, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 220

; Ground Throw
;-------------

[StateDef 701]
type = S
movetype = A
physics = S
anim = 701
sprpriority = 2
velset = 0,0
ctrl = 0

[State 701, invincibility]
type = NotHitBy
trigger1 = 1
value = SCA

[State 701, catch spark]
type = Explod
trigger1 = AnimElem = 3, = 1
anim = F0
sprpriority = 3
pos = -59,-58
ownpal = 1
removeongethit = 1

[State 701, catch sound]
type = PlaySnd
trigger1 = AnimElem = 3, = 1
value = 160,1
channel = 1

[State 701, voice]
type = PlaySnd
trigger1 = AnimElem = 5
value = 30,7
channel = 0

[State 701, throw sound]
type = PlaySnd
trigger1 = AnimElem = 6
value = 160,2
channel = 1

[State 701, target bind 1]
type = TargetBind
trigger1 = AnimElem = 1
pos = -48,-2

[State 701, target bind 2]
type = TargetBind
trigger1 = AnimElem = 2
pos = -59,-2

[State 701, target bind 3]
type = TargetBind
trigger1 = AnimElem = 3
pos = -59,0

[State 701, target bind 4]
type = TargetBind
trigger1 = AnimElem = 4
pos = -48,-100

[State 701, target bind 5]
type = TargetBind
trigger1 = AnimElem = 5
pos = 8,-120

[State 701, target bind 6]
type = TargetBind
trigger1 = AnimElem = 6
pos = 60,-105

[State 701, target bind 7]
type = TargetBind
trigger1 = AnimElem = 7
pos = 80,-100

[State 701, target velocity]
type = TargetVelSet
trigger1 = AnimElem = 7, = 1
x = 4
y = -3.5

[State 701, target life]
type = TargetLifeAdd
trigger1 = AnimElem = 7
value = -115

[State 701, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

; Ennemy Thrown
;--------------

[StateDef 710]
type = U
movetype = H
physics = N
sprpriority = -1
ctrl = 0

[State 710, animation]
type = ChangeAnim2
trigger1 = time = 0
value = 710

[State 710, velocity]
type = VelSet
trigger1 = time < 36
x = 0
y = 0

[State 710, gravity]
type = gravity
trigger1 = time > 36

[State 710, end state]
type = SelfState
trigger1 = vel y > 0 && pos y >= -5
value = 5100



; Back Ground Throw Attemp
;-------------------------

[StateDef 750]
type = S
movetype = A
physics = S
anim = 700
sprpriority = 2
velset = 0,0
ctrl = 0

[State 750, hit def]
type = HitDef
trigger1 = AnimElem = 1
attr = S, NT
hitflag = M
animtype = light
ground.type = high
priority = 4, miss
damage = 0, 0
getpower = 0, 0
pausetime = 0,0
sparkno = -1
p1facing = -1
p2facing = -1
p1stateno = 751
p2stateno = 760

[State 750, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 230

; Ground Throw
;-------------

[StateDef 751]
type = S
movetype = A
physics = S
anim = 701
sprpriority = 2
velset = 0,0
ctrl = 0

[State 751, invincibility]
type = NotHitBy
trigger1 = 1
value = SCA

[State 751, catch spark]
type = Explod
trigger1 = AnimElem = 3, = 1
anim = F0
sprpriority = 3
pos = -59,-58
ownpal = 1
removeongethit = 1

[State 751, catch sound]
type = PlaySnd
trigger1 = AnimElem = 3, = 1
value = 160,1
channel = 1

[State 751, voice]
type = PlaySnd
trigger1 = AnimElem = 5
value = 30,7
channel = 0

[State 751, throw sound]
type = PlaySnd
trigger1 = AnimElem = 6
value = 160,2
channel = 1

[State 751, target bind 1]
type = TargetBind
trigger1 = AnimElem = 1
pos = -48,-2

[State 751, target bind 2]
type = TargetBind
trigger1 = AnimElem = 2
pos = -59,-2

[State 751, target bind 3]
type = TargetBind
trigger1 = AnimElem = 3
pos = -59,0

[State 751, target bind 4]
type = TargetBind
trigger1 = AnimElem = 4
pos = -48,-100

[State 751, target bind 5]
type = TargetBind
trigger1 = AnimElem = 5
pos = 8,-120

[State 751, target bind 6]
type = TargetBind
trigger1 = AnimElem = 6
pos = 60,-105

[State 751, target bind 7]
type = TargetBind
trigger1 = AnimElem = 7
pos = 80,-100

[State 751, target velocity]
type = TargetVelSet
trigger1 = AnimElem = 7, = 1
x = 4
y = -3.5

[State 751, turn]
type = Turn
trigger1 = AnimElem = 4

[State 751, target life]
type = TargetLifeAdd
trigger1 = AnimElem = 7
value = -115

[State 751, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

; Ennemy Thrown
;--------------

[StateDef 760]
type = U
movetype = H
physics = N
sprpriority = -1
ctrl = 0

[State 760, animation]
type = ChangeAnim2
trigger1 = time = 0
value = 710

[State 760, velocity]
type = VelSet
trigger1 = time < 36
x = 0
y = 0

[State 760, gravity]
type = gravity
trigger1 = time > 36

[State 760, turn]
type = Turn
trigger1 = AnimElem = 2

[State 760, end state]
type = SelfState
trigger1 = vel y > 0 && pos y >= -5
value = 5100



; Air Throw Attemp
;-----------------

[StateDef 800]
type = A
movetype = A
physics = A
anim = 800
sprpriority = 2
ctrl = 0

[State 800, hit def]
type = HitDef
trigger1 = AnimElem = 1
attr = A, NT
hitflag = A
animtype = light
ground.type = high
priority = 4, miss
damage = 0, 0
getpower = 0, 0
pausetime = 0,0
sparkno = -1
p1facing = -1
p2facing = -1
p1stateno = 801
p2stateno = 810

[State 800, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 420

; Air Throw
;----------

[StateDef 801]
type = A
movetype = A
physics = A
anim = 801
sprpriority = 2
ctrl = 0

[State 801, invincibility]
type = NotHitBy
trigger1 = 1
value = SCA

[State 801, pos freeze]
type = PosFreeze
trigger1 = anim = 801
time = 1

[State 801, velocity]
type = VelSet
trigger1 = anim = 801
x = 0
y = 0

[State 801, animation]
type = ChangeAnim
trigger1 = anim = 801
trigger1 = AnimTime = 0
value = 41
elem = 5

[State 801, catch spark]
type = Explod
trigger1 = anim = 801
trigger1 = AnimElem = 2, = 1
anim = F0
sprpriority = 3
pos = -59,-58
ownpal = 1
removeongethit = 1

[State 801, catch sound]
type = PlaySnd
trigger1 = anim = 801
trigger1 = AnimElem = 2, = 1
value = 160,1
channel = 1

[State 801, voice]
type = PlaySnd
trigger1 = anim = 801
trigger1 = AnimElem = 4
value = 30,7
channel = 0

[State 801, throw sound]
type = PlaySnd
trigger1 = anim = 801
trigger1 = AnimElem = 5
value = 160,2
channel = 1

[State 801, target bind 1]
type = TargetBind
trigger1 = anim = 801
trigger1 = AnimElem = 1
pos = -48,-2

[State 801, target bind 2]
type = TargetBind
trigger1 = anim = 801
trigger1 = AnimElem = 2
pos = -59,-2

[State 801, target bind 3]
type = TargetBind
trigger1 = anim = 801
trigger1 = AnimElem = 3
pos = -48,-100

[State 801, target bind 4]
type = TargetBind
trigger1 = anim = 801
trigger1 = AnimElem = 4
pos = 8,-120

[State 801, target bind 5]
type = TargetBind
trigger1 = anim = 801
trigger1 = AnimElem = 5
pos = 60,-105

[State 801, target bind 6]
type = TargetBind
trigger1 = anim = 801
trigger1 = AnimElem = 6
pos = 80,-100

[State 801, target velocity]
type = TargetVelSet
trigger1 = anim = 801
trigger1 = AnimElem = 6, = 1
x = 6
y = -2.5

[State 801, target life]
type = TargetLifeAdd
trigger1 = anim = 801
trigger1 = AnimElem = 6
value = -115

; Ennemy Air Thrown
;------------------

[StateDef 810]
type = U
movetype = H
physics = N
sprpriority = -1
ctrl = 0

[State 810, animation]
type = ChangeAnim2
trigger1 = time = 0
value = 810

[State 810, velocity]
type = VelSet
trigger1 = time <= 40
x = 0
y = 0

[State 810, gravity]
type = gravity
trigger1 = time > 40

[State 810, end state]
type = SelfState
trigger1 = vel y > 0 && pos y >= -5
value = 5100



;================================================================================================
;
; SPECIAL ATTACKS
;
;================================================================================================

; Enretsu Ken
;------------

[StateDef 1000]
type = S
movetype = A
physics = N
anim = 1000
sprpriority = 2
velset = 0,0
ctrl = 0
poweradd = 20
juggle = 10

[State 1000, velocity]
type = VelSet
trigger1 = AnimElem = 4, = 1
x = 4

[State 1000, reduce velocity]
type = VelAdd
trigger1 = AnimElem = 5, = 1
trigger2 = AnimElem = 6, = 1
trigger3 = AnimElem = 6, = 3
trigger4 = AnimElem = 7, = 0
x = -1

[State 1000, player flame 1]
type = Explod
trigger1 = AnimElem = 5
anim = 1011
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1000, player flame 2]
type = Explod
trigger1 = AnimElem = 6, >= 0
trigger1 = AnimElem = 6, < 2
anim = 1012
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1000, player flame 3]
type = Explod
trigger1 = AnimElem = 6, = 2
anim = 1013
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1000, flame sound]
type = PlaySnd
trigger1 = AnimElem = 5
value = 130,1
channel = 1

[State 1000, voice]
type = PlaySnd
trigger1 = AnimElem = 4
value = 40,1
channel = 0

[State 1000, hit def]
type = HitDef
triggerall = !MoveContact
trigger1 = AnimElem = 6, >= 0
trigger1 = AnimElem = 6, < 2
attr = S, SA
hitflag = MAF
guardflag = MA
animtype = diagup
priority = 4, hit
damage = 95,10
getpower = 100,100
givepower = 50,50
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -46
hitsound = s140,5
guardsound = s150,2
pausetime = 18,18
ground.velocity = -6,-8
guard.pausetime = 18,18
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -6.47
air.velocity = -6,-8
P2facing = 1
fall = 1
fall.recovertime = 50
palfx.time = 80			; Burning pal fx code by Sander
palfx.add = 40,-70,-200
palfx.sinadd = 40,30,0,10
palfx.color = 0
palfx.invertall = 1

[State 1000, ennemy flame 1]
type = Explod
triggerall = NumExplod(1151) = 0
trigger1 = moveHit
ID = 1151
anim = 1150
pos = 10,-30
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 1000, ennemy flame 2]
type = Explod
triggerall = NumExplod(1152) = 0
trigger1 = moveHit
ID = 1152
anim = 1150
pos = const(size.mid.pos.x) - 10,const(size.mid.pos.y) - 20
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 1000, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



; Double Enretsu Ken
;-------------------
; (1st Hit)
;----------
[StateDef 1050]
type = S
movetype = A
physics = N
anim = 1050
sprpriority = 2
velset = 0,0
ctrl = 0
poweradd = 30
juggle = 10

[State 1050, velocity]
type = VelSet
trigger1 = AnimElem = 4, = 1
x = 6

[State 1050, reduce velocity]
type = VelAdd
trigger1 = AnimElem = 4, = 3
trigger2 = AnimElem = 4, = 4
trigger3 = AnimElem = 5, = 1
trigger4 = AnimElem = 6, = 1
trigger5 = AnimElem = 6, = 3
trigger6 = AnimElem = 6, = 4
x = -1

[State 1050, 1st flame 1]
type = Explod
trigger1 = AnimElem = 5
anim = 1061
bindtime = -1
sprpriority = 1
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1050, 1st flame 2]
type = Explod
trigger1 = AnimElem = 6, >= 0
trigger1 = AnimElem = 6, < 2
anim = 1062
bindtime = -1
sprpriority = 1
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1050, 1st flame 3]
type = Explod
trigger1 = AnimElem = 6, = 2
anim = 1063
bindtime = -1
sprpriority = 1
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1050, flames sound]
type = PlaySnd
trigger1 = AnimElem = 5
value = 130,1
channel = 1

[State 1050, voice]
type = PlaySnd
trigger1 = AnimElem = 4
value = 40,1
channel = 0

[State 1050, 1st hit def]
type = HitDef
triggerall = !MoveContact
trigger1 = AnimElem = 6, >= 0
trigger1 = AnimElem = 6, < 2
attr = S, SA
hitflag = MAF
guardflag = MA
animtype = light
ground.type = low
air.type = low
priority = 4, hit
damage = 50,5
getpower = 70,70
givepower = 35,35
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -46
hitsound = s140,5
guardsound = s150,2
pausetime = 16,16
ground.velocity = -2.35
ground.slidetime = 14
ground.hittime = 19
guard.pausetime = 16,16
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -2.35
air.velocity = -2,-3.5
palfx.time = 35			; Burning pal fx code by Sander
palfx.add = 40,-70,-200
palfx.sinadd = 40,30,0,10
palfx.color = 0
palfx.invertall = 1

[State 1050, ennemy flame 1]
type = Explod
triggerall = NumExplod(1151) = 0
trigger1 = moveHit
ID = 1151
anim = 1150
pos = 10,-30
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 1050, ennemy flame 2]
type = Explod
triggerall = NumExplod(1152) = 0
trigger1 = moveHit
ID = 1152
anim = 1150
pos = const(size.mid.pos.x) - 10,const(size.mid.pos.y) - 20
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 1050, end state]
type = ChangeState
trigger1 = AnimElem = 7
value = 1051

; (2nd Hit)
;----------
[StateDef 1051]
type = S
movetype = A
physics = N
sprpriority = 2
ctrl = 0

[State 1051, 2nd flame 1]
type = Explod
trigger1 = AnimElem = 7
anim = 1064
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1051, 2nd flame 2]
type = Explod
trigger1 = AnimElem = 8, >= 0
trigger1 = AnimElem = 8, < 2
anim = 1065
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1051, 2nd flame 3]
type = Explod
trigger1 = AnimElem = 8, = 2
anim = 1066
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1051, flames sound]
type = PlaySnd
trigger1 = AnimElem = 7
value = 130,1
channel = 1

[State 1051, 2nd hit def]
type = HitDef
triggerall = !MoveContact
trigger1 = AnimElem = 8, >= 0
trigger1 = AnimElem = 8, < 2
attr = S, SA
hitflag = MAF
guardflag = MA
animtype = diagup
priority = 4, hit
damage = 60,5
getpower = 70,70
givepower = 35,35
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -34
hitsound = s140,5
guardsound = s150,2
pausetime = 20,20
ground.velocity = -6,-8
guard.pausetime = 0,20
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -6.47
air.velocity = -6,-8
P2facing = 1
fall = 1
fall.recovertime = 50
palfx.time = 80			; Burning pal fx code by Sander
palfx.add = 40,-70,-200
palfx.sinadd = 40,30,0,10
palfx.color = 0
palfx.invertall = 1

[State 1051, ennemy flame 1]
type = Explod
triggerall = NumExplod(1151) = 0
trigger1 = moveHit
ID = 1151
anim = 1150
pos = 10,-30
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 1051, ennemy flame 2]
type = Explod
triggerall = NumExplod(1152) = 0
trigger1 = moveHit
ID = 1152
anim = 1150
pos = const(size.mid.pos.x) - 10,const(size.mid.pos.y) - 20
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 1050, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



; Ko Ryu Sho Zan
;---------------

[StateDef 1100]
type = S
movetype = A
physics = S
anim = 1100
sprpriority = 2
velset = 0,0
ctrl = 0
poweradd = 20
juggle = 15
juggle = 10

[State 1100, var set]
type = VarSet
trigger1 = time = 0
v = 5
value = 0 + command = "qcf_y"

[State 1100, flame]
type = Explod
trigger1 = AnimElem = 3
anim = 1110
bindtime = 12
sprpriority = 3
ownpal = 1
removeongethit = 1

[State 1100, projectile sound]
type = PlaySnd
trigger1 = AnimElem = 9
value = 130,2
channel = 1

[State 1100, voice]
type = PlaySnd
trigger1 = AnimElem = 4
value = 40,2
channel = 0

[State 1100, projectile]
type = projectile
trigger1 = AnimElem = 9
ProjID = 1100
projanim = 1120
projhitanim = 1130
velocity = 4 + 2*(var(5))
projedgebound = 0
attr = A, SP
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = high
air.type = low
priority = 4, hit
damage = 95,10
getpower = 100,100
givepower = 50,50
sparkno = 1
guard.sparkno = 40
sparkxy = 100, -58
hitsound = s140,3
guardsound = s150,2
pausetime = 0,20
ground.slidetime = 15
ground.hittime = 24
ground.velocity = -4.12
guard.pausetime = 0,20
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -4.12
air.velocity = -2,-3.5
palfx.time = 44			; Burning pal fx code by Sander
palfx.add = 40,-70,-200
palfx.sinadd = 40,30,0,10
palfx.color = 0
palfx.invertall = 1

[State 1100, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



; Ryu En Hou - Launcher 1
;------------------------

[StateDef 1200]
type = S
movetype = A
physics = S
anim = 1200
sprpriority = 2
velset = 0,0
ctrl = 0
poweradd = 50
juggle = 10

[State 1200, spark]
type = Explod
trigger1 = AnimElem = 5
anim = 1201
bindtime = 10
sprpriority = 3
ownpal = 1
removeongethit = 1

[State 1200, env shake]
type = EnvShake
trigger1 = AnimElem = 5
time = 20
ampl = 8

[State 1200, hit ground sound]
type = PlaySnd
trigger1 = AnimElem = 5
value = 130,3
channel = 1

[State 1200, voice]
type = PlaySnd
trigger1 = AnimElem = 5
value = 40,3
channel = 0

[State 1200, hit def]
type = HitDef
trigger1 = AnimElem = 5
attr = S, SA
hitflag = MAF
guardflag = MA
animtype = back
priority = 4, hit
damage = 60,5
getpower = 100,100
givepower = 50,50
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -60
hitsound = s140,5
guardsound = s150,2
pausetime = 26,26
ground.slidetime = 24
ground.hittime = 30
ground.velocity = -12
guard.pausetime = 26,26
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -8.24
air.velocity = -1.5,-5.5
P2facing = 1
palfx.time = 85			; Burning pal fx code by Sander
palfx.add = 40,-70,-200
palfx.sinadd = 40,30,0,10
palfx.color = 0
palfx.invertall = 1

[State 1200, ennemy flame 1]
type = Explod
triggerall = NumExplod(1151) = 0
trigger1 = moveHit
ID = 1151
anim = 1150
pos = 10,-30
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 1200, ennemy flame 2]
type = Explod
triggerall = NumExplod(1152) = 0
trigger1 = moveHit
ID = 1152
anim = 1150
pos = const(size.mid.pos.x) - 10,const(size.mid.pos.y) - 20
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 1200, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

; Ryu En Hou - 1st Punch
;-----------------------

[StateDef 1210]
type = S
movetype = A
physics = S
anim = 1210
sprpriority = 2
velset = 0,0
ctrl = 0
poweradd = 20

[State 1210, add pos]
type = PosAdd
trigger1 = AnimElem = 2
x = 20

[State 1210, add pos]
type = PosAdd
trigger1 = AnimElem = 5
x = 35

[State 1210, punch sound]
type = PlaySnd
trigger1 = AnimElem = 5
value = 120,2
channel = 1

[State 1210, voice]
type = PlaySnd
trigger1 = AnimElem = 5
value = 30,2
channel = 0

[State 1210, hit def]
type = HitDef
trigger1 = AnimElem = 6
attr = A, SA
hitflag = MAF
guardflag = MA
animtype = hard
air.animtype = back
ground.type = low
priority = 4, hit
damage = 20,5
getpower = 60,60
givepower = 30,30
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -45
hitsound = s140,5
guardsound = s150,2
pausetime = 24,24
ground.slidetime = 24
ground.hittime = 30
ground.velocity = -5.5
guard.pausetime = 24,24
guard.slidetime = 14
guard.hittime = 17
guard.ctrtime = 17
guard.velocity = -8.24
air.velocity = -1.5,-5.5

[State 1210, after images]
type = AfterImage
trigger1 = AnimElem = 3
time = 38
length = 9
palbright = 24,48,170
palcontrast = 256,192,210
paladd = 0,0,0
palmul = 1,1,1
timegap = 1
framegap = 4

[State 1210, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

; Ryu En Hou - 2nd Punch
;-----------------------

[StateDef 1220]
type = S
movetype = A
physics = S
anim = 1220
sprpriority = 2
velset = 0,0
ctrl = 0
poweradd = 20

[State 1220, velocity]
type = VelSet
trigger1 = AnimElem = 3, >= 0
trigger1 = AnimElem = 5, < 0
x = 4.88

[State 1220, voice]
type = PlaySnd
trigger1 = AnimElem = 4
value = 30,7
channel = 0

[State 510, sound]
type = PlaySnd
trigger1 = AnimElem = 3
value = 120,2
channel = 1

[State 1220, hit def]
type = HitDef
trigger1 = AnimElem = 4
attr = A, SA
hitflag = MAF
guardflag = MA
animtype = diagup
priority = 4, hit
damage = 60,5
getpower = 60,60
givepower = 30,30
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -55
hitsound = s140,5
guardsound = s150,2
pausetime = 24,24
ground.velocity = -6,-8
guard.pausetime = 24,24
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -8.24
air.velocity = -6,-8
fall = 1
fall.recovertime = 55

[State 1220, after images]
type = AfterImageTime
trigger1 = time = 0
time = 0

[State 1220, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1



; Ryu En Hou - Launcher 2
;------------------------

[StateDef 1250]
type = S
movetype = A
physics = S
anim = 1250
sprpriority = 2
velset = 0,0
ctrl = 0
poweradd = 50
juggle = 10

[State 1250, spark]
type = Explod
trigger1 = AnimElem = 5
anim = 1201
bindtime = 10
sprpriority = 3
ownpal = 1
removeongethit = 1

[State 1250, env shake]
type = EnvShake
trigger1 = AnimElem = 5
time = 20
ampl = 8

[State 1250, hit ground sound]
type = PlaySnd
trigger1 = AnimElem = 5
value = 130,3
channel = 1

[State 1250, voice]
type = PlaySnd
trigger1 = AnimElem = 5
value = 40,3
channel = 0

[State 1250, hit def]
type = HitDef
trigger1 = AnimElem = 5
attr = S, SA
hitflag = MAF
guardflag = MA
animtype = back
priority = 4, hit
damage = 60,5
getpower = 100,100
givepower = 50,50
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -60
hitsound = s140,5
guardsound = s150,2
pausetime = 26,26
ground.velocity = -1.5,-5.5
guard.pausetime = 26,26
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -8.24
air.velocity = -1.5,-5.5
P2facing = 1
fall = 1
fall.recovertime = 55
palfx.time = 85			; Burning pal fx code by Sander
palfx.add = 40,-70,-200
palfx.sinadd = 40,30,0,10
palfx.color = 0
palfx.invertall = 1

[State 1250, ennemy flame 1]
type = Explod
triggerall = NumExplod(1151) = 0
trigger1 = moveHit
ID = 1151
anim = 1150
pos = 10,-30
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 1250, ennemy flame 2]
type = Explod
triggerall = NumExplod(1152) = 0
trigger1 = moveHit
ID = 1152
anim = 1150
pos = const(size.mid.pos.x) - 10,const(size.mid.pos.y) - 20
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 1250, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

; Ryu En Hou - 1st Kick
;----------------------

[StateDef 1260]
type = S
movetype = A
physics = S
anim = 1260
sprpriority = 2
velset = 0,0
ctrl = 0
poweradd = 20

[State 1260, state type set]
type = StateTypeSet
triggerall = anim = 1260
trigger1 = AnimElem = 4
statetype = A
physics = A

[State 1260, pos add]
type = PosAdd
triggerall = anim = 1260
trigger1 = AnimElem = 4
x = 24

[State 1260, vel set 1]
type = VelSet
triggerall = anim = 1260
trigger1 = AnimElem = 4, >= 0
trigger1 = AnimElem = 4, < 5
x = 3.25
y = -5.5

[State 1260, vel set 2]
type = VelSet
triggerall = anim = 1260
trigger1 = AnimElem = 4, >= 5
trigger1 = AnimElem = 5, < 0
x = 3.25
y = -4.5

[State 1260, vel set 3]
type = VelSet
triggerall = anim = 1260
trigger1 = AnimElem = 5, >= 0
trigger1 = AnimElem = 6, < 0
x = 2
y = -3.5

[State 1260, vel set 4]
type = VelSet
triggerall = anim = 1260
trigger1 = AnimElem = 6, >= 0
trigger1 = AnimElem = 7, < 0
x = 1.5
y = -2.5

[State 1260, vel set 5]
type = VelSet
triggerall = anim = 1260
trigger1 = AnimElem = 7, >= 0
trigger1 = AnimElem = 7, < 3
x = 1
y = -1.5

[State 1260, vel set 6]
type = VelSet
triggerall = anim = 1260
trigger1 = AnimElem = 7, >= 3
trigger1 = AnimElem = 7, <= 7
x = 0.5
y = -0.5

[State 1260, vel set 7]
type = VelSet
triggerall = anim = 41
trigger1 = AnimElem = 5, = 1
x = 0
y = 0

[State 1260, air animation]
type = ChangeAnim
trigger1 = anim = 1260&& AnimTime = 0
value = 41
elem = 5

[State 1260, kick sound]
type = PlaySnd
trigger1 = AnimElem = 4
value = 120,2
channel = 1

[State 1260, voice]
type = PlaySnd
trigger1 = AnimElem = 4
value = 30,2
channel = 0

[State 1260, hit def]
type = HitDef
trigger1 = AnimElem = 4
attr = A, SA
hitflag = MAF
guardflag = MA
animtype = back
priority = 4, hit
damage = 20,5
getpower = 60,60
givepower = 30,30
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -45
hitsound = s140,5
guardsound = s150,2
pausetime = 24,24
ground.velocity = -1.5,-5.5
guard.pausetime = 24,24
guard.slidetime = 14
guard.hittime = 17
guard.ctrtime = 17
guard.velocity = -8.24
air.velocity = -1.5,-5.5
fall = 1
fall.recovertime = 55

[State 1260, after images]
type = AfterImage
trigger1 = AnimElem = 3
time = 24
length = 9
palbright = 24,48,170
palcontrast = 256,192,210
paladd = 0,0,0
palmul = 1,1,1
timegap = 1
framegap = 4

; Ryu En Hou - 2nd Kick
;----------------------

[StateDef 1270]
type = A
movetype = A
physics = A
anim = 1270
sprpriority = 2
ctrl = 0
poweradd = 30

[State 1270, pos freeze]
type = PosFreeze
trigger1 = anim = 1270

[State 1270, air animation]
type = ChangeAnim
trigger1 = anim = 1270 && AnimTime = 0
value = 41
elem = 5

[State 1270, velocity]
type = VelSet
trigger1 = anim = 1270 && AnimElem = 1
trigger2 = anim = 41 && AnimElem = 5,  = 1
x = 0
y = 0

[State 1270, kick sound]
type = PlaySnd
trigger1 = AnimElem = 2
value = 120,2
channel = 1

[State 1270, voice]
type = PlaySnd
trigger1 = AnimElem = 2
value = 30,7
channel = 0

[State 1270, hit def]
type = HitDef
trigger1 = AnimElem = 2
attr = A, SA
hitflag = MAF
guardflag = MA
animtype = diagup
priority = 4, hit
damage = 60,5
getpower = 60,60
givepower = 30,30
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -52
hitsound = s140,5
guardsound = s150,2
pausetime = 24,24
ground.velocity = -6,-8
guard.pausetime = 24,24
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -8.24
air.velocity = -6,-8
fall = 1
fall.recovertime = 55

[State 1270, after images]
type = AfterImageTime
trigger1 = time = 0
time = 0



; Ko Ryu Kyaku A
;---------------

[StateDef 1300]
type = S
movetype = A
physics = S
anim = 1300
sprpriority = 2
velset = 0,0
ctrl = 0
poweradd = 50
juggle = 10

[State 1300, state type set]
type = StateTypeSet
triggerall = anim = 1300
trigger1 = AnimElem = 5
statetype = A
physics = A

[State 1300, pos add]
type = PosAdd
triggerall = anim = 1300
trigger1 = AnimElem = 5
x = 24

[State 1300, vel set 1]
type = VelSet
triggerall = anim = 1300
trigger1 = AnimElem = 5, >= 0
trigger1 = AnimElem = 5, < 5
x = 3.5
y = -5.25

[State 1300, vel set 2]
type = VelSet
triggerall = anim = 1300
trigger1 = AnimElem = 5, >= 5
trigger1 = AnimElem = 6, < 0
x = 3
y = -4.5

[State 1300, vel set 3]
type = VelSet
triggerall = anim = 1300
trigger1 = AnimElem = 6, >= 0
trigger1 = AnimElem = 7, < 0
x = 2
y = -3.5

[State 1300, vel set 4]
type = VelSet
triggerall = anim = 1300
trigger1 = AnimElem = 7, >= 0
trigger1 = AnimElem = 8, < 0
x = 1.5
y = -2.5

[State 1300, vel set 5]
type = VelSet
triggerall = anim = 1300
trigger1 = AnimElem = 8, >= 0
trigger1 = AnimElem = 8, < 3
x = 1
y = -1.5

[State 1300, vel set 6]
type = VelSet
triggerall = anim = 1300
trigger1 = AnimElem = 8, >= 3
trigger1 = AnimElem = 8, <= 7
x = 0.5
y = -0.5

[State 1300, vel set 7]
type = VelSet
triggerall = anim = 41
trigger1 = AnimElem = 5, = 1
x = 0
y = 0

[State 1300, air animation]
type = ChangeAnim
trigger1 = anim = 1300 && AnimTime = 0
value = 41
elem = 5

[State 1300, flame 1]
type = Explod
trigger1 = anim = 1300
trigger1 = AnimElem = 4
anim = 1311
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1300, flame 2]
type = Explod
trigger1 = anim = 1300
trigger1 = AnimElem = 5, >= 0
trigger1 = AnimElem = 5, < 3
anim = 1312
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1300, flame 3]
type = Explod
trigger1 = anim = 1300
trigger1 = AnimElem = 5, >= 3
trigger1 = AnimElem = 5, < 6
anim = 1313
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1300, flame 4]
type = Explod
trigger1 = anim = 1300
trigger1 = AnimElem = 5, >= 6
trigger1 = AnimElem = 7, < 0
anim = 1314
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1300, flame 5]
type = Explod
trigger1 = anim = 1300
trigger1 = AnimElem = 7
anim = 1315
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1300, voice]
type = PlaySnd
trigger1 = anim = 1300 && AnimElem = 2
value = 40,4
channel = 0

[State 1300, flamme sound]
type = PlaySnd
trigger1 = anim = 1300 && AnimElem = 4
value = 130,4
channel = 1

[State 1300, hit def]
type = HitDef
trigger1 = AnimElem = 5
attr = A, SA
hitflag = MAF
guardflag = MA
animtype = back
priority = 4, hit
damage = 115,15
getpower = 120,120
givepower = 60,60
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -45
hitsound = s140,5
guardsound = s150,2
pausetime = 24,24
ground.velocity = -3,-4
guard.pausetime = 24,24
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -4.7
air.velocity = -3,-4
fall = 1
fall.recovertime = 55
palfx.time = 85			; Burning pal fx code by Sander
palfx.add = 40,-70,-200
palfx.sinadd = 40,30,0,10
palfx.color = 0
palfx.invertall = 1

[State 1300, ennemy flame 1]
type = Explod
triggerall = NumExplod(1151) = 0
trigger1 = moveHit
ID = 1151
anim = 1150
pos = 10,-30
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 1300, ennemy flame 2]
type = Explod
triggerall = NumExplod(1152) = 0
trigger1 = moveHit
ID = 1152
anim = 1150
pos = const(size.mid.pos.x) - 10,const(size.mid.pos.y) - 20
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0



; Ko Ryu Kyaku B
;---------------

; 1st Hit
;--------

[StateDef 1350]
type = S
movetype = A
physics = S
anim = 1350
sprpriority = 2
velset = 0,0
ctrl = 0
poweradd = 50
juggle = 10

[State 1350, state type set]
type = StateTypeSet
triggerall = anim = 1350
trigger1 = AnimElem = 5
statetype = A
physics = A

[State 1350, pos add]
type = PosAdd
triggerall = anim = 1350
trigger1 = AnimElem = 5
x = 24

[State 1350, vel set 1]
type = VelSet
triggerall = anim = 1350
trigger1 = AnimElem = 5, >= 0
trigger1 = AnimElem = 5, < 5
x = 3.75
y = -5.5

[State 1350, vel set 2]
type = VelSet
triggerall = anim = 1350
trigger1 = AnimElem = 5, >= 5
trigger1 = AnimElem = 6, < 0
x = 3.25
y = -5

[State 1350, flame 1]
type = Explod
trigger1 = anim = 1350
trigger1 = AnimElem = 4
anim = 1361
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1350, flame 2]
type = Explod
trigger1 = anim = 1350
trigger1 = AnimElem = 5, >= 0
trigger1 = AnimElem = 5, < 2
anim = 1362
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1350, flame 3]
type = Explod
trigger1 = anim = 1350
trigger1 = AnimElem = 5, >= 2
trigger1 = AnimElem = 6, < 0
anim = 1363
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1350, voice]
type = PlaySnd
trigger1 = anim = 1350 && AnimElem = 2
value = 40,4
channel = 0

[State 1350, flame sound]
type = PlaySnd
trigger1 = anim = 1350 && AnimElem = 4
value = 130,4
channel = 1

[State 1350, hit def]
type = HitDef
trigger1 = AnimElem = 5
attr = A, SA
hitflag = MAF
guardflag = MA
animtype = back
priority = 4, hit
damage = 70,10
getpower = 70,70
givepower = 35,35
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -45
hitsound = s140,5
guardsound = s150,2
pausetime = 24,24
ground.velocity = -2.5,-5
guard.pausetime = 24,24
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -4.7
air.velocity = -3,-4
fall = 1
fall.recovertime = 55
palfx.time = 85			; Burning pal fx code by Sander
palfx.add = 40,-70,-200
palfx.sinadd = 40,30,0,10
palfx.color = 0
palfx.invertall = 1

[State 1350, ennemy flame 1]
type = Explod
triggerall = NumExplod(1151) = 0
trigger1 = moveHit
ID = 1151
anim = 1150
pos = 10,-30
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 1350, ennemy flame 2]
type = Explod
triggerall = NumExplod(1152) = 0
trigger1 = moveHit
ID = 1152
anim = 1150
pos = const(size.mid.pos.x) - 10,const(size.mid.pos.y) - 20
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 1350, change state]
type = ChangeState
trigger1 = AnimElem = 6
value = 1351

; 2nd Hit
;--------

[StateDef 1351]
type = A
movetype = A
physics = A
sprpriority = 2
ctrl = 0

[State 1351, vel set 3]
type = VelSet
triggerall = anim = 1350
trigger1 = AnimElem = 6, >= 0
trigger1 = AnimElem = 7, < 0
x = 2.5
y = -4

[State 1351, vel set 4]
type = VelSet
triggerall = anim = 1350
trigger1 = AnimElem = 7, >= 0
trigger1 = AnimElem = 8, < 0
x = 2
y = -3

[State 1351, vel set 5]
type = VelSet
triggerall = anim = 1350
trigger1 = AnimElem = 8, >= 0
trigger1 = AnimElem = 9, < 0
x = 1.5
y = -2

[State 1351, vel set 6]
type = VelSet
triggerall = anim = 1350
trigger1 = AnimElem = 9, >= 0
trigger1 = AnimElem = 9, < 3
x = 1
y = -1.5

[State 1351, vel set 7]
type = VelSet
triggerall = anim = 1350
trigger1 = AnimElem = 9, >= 3
trigger1 = AnimElem = 9, < 6
x = 0.5
y = -1

[State 1351, vel set 8]
type = VelSet
triggerall = anim = 1350
trigger1 = AnimElem = 9, >= 7
x = 0
y = 0

[State 1351, air animation]
type = ChangeAnim
trigger1 = anim = 1350 && AnimTime = 0
value = 41
elem = 5

[State 1351, flame 4]
type = Explod
trigger1 = anim = 1350
trigger1 = AnimElem = 6, >= 0
trigger1 = AnimElem = 6, < 4
anim = 1364
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1351, flame 5]
type = Explod
trigger1 = anim = 1350
trigger1 = AnimElem = 6, >= 4
trigger1 = AnimElem = 6, < 6
anim = 1365
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1351, flame 6]
type = Explod
trigger1 = anim = 1350
trigger1 = AnimElem = 6, >= 6
trigger1 = AnimElem = 7, < 0
anim = 1366
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1351, flame 7]
type = Explod
trigger1 = anim = 1350
trigger1 = AnimElem = 7
anim = 1367
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 1351, hit def]
type = HitDef
trigger1 = AnimElem = 6
attr = A, SA
hitflag = MAF
guardflag = MA
animtype = back
priority = 4, hit
damage = 70,10
getpower = 70,70
givepower = 35,35
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -45
hitsound = s140,5
guardsound = s150,2
pausetime = 24,24
ground.velocity = -2.5,-5
guard.pausetime = 24,24
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -4.7
air.velocity = -3,-4
fall = 1
fall.recovertime = 55
palfx.time = 85			; Burning pal fx code by Sander
palfx.add = 40,-70,-200
palfx.sinadd = 40,30,0,10
palfx.color = 0
palfx.invertall = 1

[State 1351, ennemy flame 1]
type = Explod
triggerall = NumExplod(1151) = 0
trigger1 = MoveHit
ID = 1151
anim = 1150
pos = 10,-30
postype = p2
bindtime = 44
removetime = 44
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 1351, ennemy flame 2]
type = Explod
triggerall = NumExplod(1152) = 0
trigger1 = MoveHit
ID = 1152
anim = 1150
pos = const(size.mid.pos.x) - 10,const(size.mid.pos.y) - 20
postype = p2
bindtime = 44
removetime = 44
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0



;================================================================================================
;
; SUPER ATTACKS
;
;================================================================================================

; Tobi Ryu
;---------

; Prepare Level 1
;----------------

[StateDef 3001]
type = S
movetype = I
physics = S
anim = 3000
sprpriority = 2
velset = 0,0
ctrl = 0

[State 3001, super var]
type = VarSet
trigger1 = time = 0
v = 6
value = 1

[State 3001, super pause]
type = SuperPause
trigger1 = AnimElem = 2
anim = -1
pos = -26,-76
sound = s170,1
time = 28
movetime = 28
darken = 0
poweradd = -1000

[State 3001, dark background]
type = EnvColor
trigger1 = AnimElem = 2
value = 0, 0, 0
time = 28
under = 1

[State 3001, front spark]
type = Explod
trigger1 = AnimElem = 2
anim = 3500
bindtime = 1
sprpriority = 3
ownpal = 1
pos = -26,-76
supermovetime = 28

[State 3001, back spark]
type = Explod
trigger1 = AnimElem = 2
anim = 3501
bindtime = 1
sprpriority = -3
ownpal = 1
pos = -26,-76
supermovetime = 28

[State 3001, ground flames]
type = Explod
trigger1 = AnimElem = 5
anim = 3001
bindtime = 1
sprpriority = 3
ownpal = 1
removeongethit = 1

[State 3001, flames sound]
type = PlaySnd
trigger1 = AnimElem = 5
value = 130,5
channel = 1

[State 3001, voice]
type = PlaySnd
trigger1 = AnimElem = 5
value = 50,1
channel = 0

[State 3001, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 3010

; Prepare Level 2
;----------------

[StateDef 3002]
type = S
movetype = I
physics = S
anim = 3000
sprpriority = 2
velset = 0,0
ctrl = 0

[State 3002, super var]
type = VarSet
trigger1 = time = 0
v = 6
value = 2

[State 3002, super pause]
type = SuperPause
trigger1 = AnimElem = 2
anim = -1
pos = -26,-76
sound = s170,2
time = 28
movetime = 28
darken = 0
poweradd = -2000

[State 3002, dark background]
type = EnvColor
trigger1 = AnimElem = 2
value = 0, 0, 0
time = 28
under = 1

[State 3002, front spark]
type = Explod
trigger1 = AnimElem = 2
anim = 3600
bindtime = 1
sprpriority = 3
ownpal = 1
pos = -26,-76
supermovetime = 28

[State 3002, back spark]
type = Explod
trigger1 = AnimElem = 2
anim = 3601
bindtime = 1
sprpriority = -3
ownpal = 1
pos = -26,-76
supermovetime = 28

[State 3002, ground flames]
type = Explod
trigger1 = AnimElem = 5
anim = 3001
bindtime = 1
sprpriority = 3
ownpal = 1
removeongethit = 1

[State 3002, flames sound]
type = PlaySnd
trigger1 = AnimElem = 5
value = 130,5
channel = 1

[State 3002, voice]
type = PlaySnd
trigger1 = AnimElem = 5
value = 50,1
channel = 0

[State 3002, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 3010

; Rising Kick
;------------

[StateDef 3010]
type = A
movetype = A
physics = A
anim = 3010
sprpriority = 2
juggle = 5

[State 3010, pos add]
type = PosAdd
trigger1 = time = 0
x = 24

[State 3010, vel set 1]
type = VelSet
trigger1 = time = [0, 4)
x = 3.75
y = -8.5

[State 3010, vel set 2]
type = VelSet
trigger1 = time = [4, 8)
x = 3.5
y = -7.75

[State 3010, vel set 3]
type = VelSet
trigger1 = time = [8, 12)
x = 3
y = -7

[State 3010, flame 1]
type = Explod
trigger1 = AnimElem = 1, >= 0
trigger1 = AnimElem = 1, < 4
anim = 3011
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 3010, flame 2]
type = Explod
trigger1 = AnimElem = 1, >= 4
trigger1 = AnimElem = 1, < 8
anim = 3012
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 3010, flame 3]
type = Explod
trigger1 = AnimElem = 1, >= 8
trigger1 = AnimElem = 1, < 12
anim = 3013
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 3010, flame 4]
type = Explod
trigger1 = AnimElem = 1, = 12
anim = 3014
bindtime = 8
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 3010, hit def]
type = HitDef
trigger1 = AnimElem = 1
attr = A, HA
hitflag = MAF
guardflag = MA
animtype = back
priority = 5, hit
damage = 160,16
getpower = 0,0
givepower = 50,50
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -45
hitsound = s140,5
guardsound = s150,2
pausetime = 36,36
ground.velocity = -1.5,-10
guard.pausetime = 32,32
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -5.3
air.velocity = -1.5,-10
P2facing = 1
fall = 1
air.fall = 1
fall.recover = 0
palfx.time = 85			; Burning pal fx code by Sander
palfx.add = 40,-70,-200
palfx.sinadd = 40,30,0,10
palfx.color = 0
palfx.invertall = 1

[State 3010, ennemy flame 1]
type = Explod
triggerall = NumExplod(1151) = 0
trigger1 = moveHit
ID = 1151
anim = 1150
pos = 10,-30
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 3010, ennemy flame 2]
type = Explod
triggerall = NumExplod(1152) = 0
trigger1 = moveHit
ID = 1152
anim = 1150
pos = const(size.mid.pos.x) - 10,const(size.mid.pos.y) - 20
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1
persistent = 0

[State 3010, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 3020

; Air
;----

[StateDef 3020]
type = A
movetype = I
physics = A
anim = 3020
sprpriority = 2

[State 3020, vel set 1]
type = VelSet
trigger1 = Anim = 3020
trigger1 = AnimElem = 1, >= 0
trigger1 = AnimElem = 2, < 0
x = 2.5
y = -5.5

[State 3020, vel set 2]
type = VelSet
trigger1 = Anim = 3020
trigger1 = AnimElem = 2, >= 0
trigger1 = AnimElem = 3, < 0
x = 1.5
y = -4.5

[State 3020, vel set 3]
type = VelSet
trigger1 = Anim = 3020
trigger1 = AnimElem = 3, >= 0
trigger1 = AnimElem = 3, < 5
x = 1.25
y = -3.75

[State 3020, vel set 4]
type = VelSet
trigger1 = Anim = 3020
trigger1 = AnimElem = 3, >= 5
trigger1 = AnimElem = 4, < 0
x = 1
y = -2.5

[State 3020, vel set 5]
type = VelSet
trigger1 = Anim = 3020
trigger1 = AnimElem = 4, >= 0
trigger1 = AnimElem = 4, < 5
trigger2 = Anim = 41
trigger2 = AnimElem = 4, >= 0
trigger2 = AnimElem = 5, < 0
x = 0.5
y = -1.75

[State 3020, vel set 6]
type = VelSet
trigger1 = Anim = 3020
trigger1 = AnimElem = 4, >= 5
trigger1 = AnimElem = 4, < 9
trigger2 = Anim = 41
trigger2 = AnimElem = 5, >= 0
trigger2 = AnimElem = 5, < 5
x = 0.25
y = -0.25

[State 3020, vel set 7]
type = VelSet
trigger1 = Anim = 3020
trigger1 = AnimElem = 4, >= 9
trigger2 = Anim = 41
trigger2 = AnimElem = 5, >= 5
trigger2 = AnimElem = 6, < 0
x = 0
y = 0

[State 3020, end state]
type = ChangeState
triggerall = Anim = 3020
trigger1 = AnimTime = 0
value = 3030

; Diving Kick
;------------

[StateDef 3030]
type = A
movetype = A
physics = A
anim = 3030
sprpriority = 2

[State 3030, velocity]
type = VelSet
trigger1 = 1
x = 6
y = 8.5

[State 3030, flame 1]
type = Explod
trigger1 = AnimElem = 1, >= 0
trigger1 = AnimElem = 1, < 2
anim = 3031
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 3030, flame 2]
type = Explod
trigger1 = AnimElem = 1, >= 2
trigger1 = AnimElem = 1, < 4
anim = 3032
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 3030, flame 3]
type = Explod
trigger1 = AnimElem = 1, >= 4
trigger1 = AnimElem = 1, < 18
anim = 3033
bindtime = -1
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 3030, flame 4]
type = Explod
trigger1 = AnimElem = 1, = 18
anim = 3034
bindtime = 10
sprpriority = 3
ownpal = 1
ignorehitpause = 1
removeongethit = 1

[State 3030, flame sound]
type = PlaySnd
trigger1 = time = 0
value = 130,5
channel = 1

[State 3030, voice]
type = PlaySnd
trigger1 = AnimElem = 1
value = 50,2
channel = 2

[State 3030, medium hit def]
type = HitDef
trigger1 = var(6) = 1 && AnimElem = 1
attr = A, HA
hitflag = MAF
guardflag = MA
animtype = diagup
priority = 6, hit
damage = 120,12
getpower = 0,0
givepower = 50,50
sparkno = 2
guard.sparkno = 40
sparkxy = 0, -5
hitsound = s140,5
guardsound = s150,2
pausetime = 36,36
ground.velocity = -6,-8
guard.pausetime = 24,24
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -5.3
air.velocity = -6,-8
fall = 1
air.fall = 1
fall.recover = 0
palfx.time = 105			; Burning pal fx code by Sander
palfx.add = 40,-70,-200
palfx.sinadd = 40,30,0,10
palfx.color = 0
palfx.invertall = 1

[State 3030, fierce hit def]
type = HitDef
trigger1 = var(6) = 2 && AnimElem = 1
attr = A, HA
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = low
air.type = low
priority = 6, hit
damage = 140,15
getpower = 0,0
givepower = 50,50
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -5
hitsound = s140,4
guardsound = s150,2
pausetime = 36,36
guard.pausetime = 24,24
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -5.3
kill = 0
P2facing = 1
P2StateNo = 3035

[State 3030, invincibility]
type = NotHitBy
trigger1 = var(6) = 2 && MoveHit
value = SCA

[State 3030, target bind]
type = TargetBind
trigger1 = var(6) = 2 && MoveHit
pos = 50,0

[State 3030, hard landing state]
type = ChangeState
trigger1 = time = 18
trigger1 = var(6) = 2 && MoveHit
value = 3041

[State 3030, soft landing state]
type = ChangeState
trigger1 = time = 18
value = 3040

; Ennemy Caught
;--------------

[StateDef 3035]
type = A
movetype = H
physics = N
sprpriority = -1

[State 3035, animation]
type = ChangeAnim2
trigger1 = time = 0
value = 3035

[State 3035, velocity]
type = VelSet
trigger1 = time = 0
x = 0
y = 0

; Soft Landing
;-------------

[StateDef 3040]
type = S
movetype = I
physics = S
anim = 3040
sprpriority = 2

[State 3040, velocity]
type = VelSet
trigger1 = time = 0
x = 0
y = 0

[State 3040, position]
type = PosSet
trigger1 = time = 0
y = 0

[State 3040, land sound]
type = PlaySnd
trigger1 = time = 0
value = 100,3
channel = 1

[State 3040, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

; Hard Landing
;-------------

[StateDef 3041]
type = S
movetype = A
physics = S
sprpriority = 2

[State 3041, land velocity]
type = VelSet
trigger1 = time = 0
x = 0
y = 0

[State 3041, land position]
type = PosSet
trigger1 = time = 0
y = -12

[State 3041, slide velocity]
type = VelSet
trigger1 = time = 16
x = 6

[State 3041, animation]
type = ChangeAnim
trigger1 = 1
value = 3040

[State 3041, env shake]
type = EnvShake
trigger1 = time = 0
time = 20
ampl = 8

[State 3041, hit spark]
type = Explod
trigger1 = time = 0
anim = F1
bindtime = 11
sprpriority = 3
pos = 18,6
ownpal = 1
removeongethit = 1

[State 3041, ground shockwave]
type = Explod
trigger1 = time = 0
anim = F61
bindtime = 8
sprpriority = -5
pos = 18,12
ownpal = 1
removeongethit = 1

[State 3041, hit sound]
type = PlaySnd
trigger1 = time = 0
value = 140,5
channel = 1

[State 3041, hit ground sound]
type = PlaySnd
trigger1 = time = 0
value = 160,3
channel = 2

[State 3041, invincibility]
type = NotHitBy
trigger1 = 1
value = SCA

[state 3041, hit add]
type = HitAdd
trigger1 = time = 0
value = 1

[State 3041, target state]
type = TargetState
trigger1 = time = 0
value = 3045

[State 3041, target bind]
type = TargetBind
trigger1 = 1
pos = 20,12

[State 3041, target life]
type = TargetLifeAdd
trigger1 = time = 0
value = -160

[State 3041, target power]
type = TargetPowerAdd
trigger1 = time = 0
value = 50

[State 3041, end state]
type = ChangeState
trigger1 = time = 30
value = 3050

; Ennemy Caught
;--------------

[StateDef 3045]
type = A
movetype = H
physics = N
sprpriority = -1

[State 3045, animation]
type = ChangeAnim2
trigger1 = time = 0
value = 3045

[State 3045, velocity]
type = VelSet
trigger1 = time = 30
x = -2
y = -5.5

[State 3045, self state]
type = SelfState
trigger1 = time = 30
value = 5101

; Jump Back
;----------

[StateDef 3050]
type = A
movetype = I
physics = A
anim = 43
sprpriority = 1

[State 3050, velocity]
type = VelSet
trigger1 = time = 0
x = -3
y = -5.5

[State 3050, jump sound]
type = PlaySnd
trigger1 = time = 0
value = 100,1
channel = 1



; Super Combo 
;------------

; Prepare Level 1
;----------------

[StateDef 3101]
type = S
movetype = I
physics = S
anim = 3100
sprpriority = 2
velset = 0,0
ctrl = 0

[State 3101, super var]
type = VarSet
trigger1 = time = 0
v = 6
value = 1

[State 3101, super pause]
type = SuperPause
trigger1 = AnimElem = 3
anim = -1
pos = -26,-76
sound = s170,1
time = 28
movetime = 28
darken = 0
poweradd = -1000

[State 3101, dark background]
type = EnvColor
trigger1 = AnimElem = 3
value = 0, 0, 0
time = 28
under = 1

[State 3101, front spark]
type = Explod
trigger1 = AnimElem = 3
anim = 3500
bindtime = 1
sprpriority = 3
ownpal = 1
pos = -20,-90
supermovetime = 28

[State 3101, back spark]
type = Explod
trigger1 = AnimElem = 3
anim = 3501
bindtime = 1
sprpriority = -3
ownpal = 1
pos = -20,-90
supermovetime = 28

[State 3101, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 3110

; Prepare Level 2
;----------------

[StateDef 3102]
type = S
movetype = I
physics = S
anim = 3100
sprpriority = 2
velset = 0,0
ctrl = 0

[State 3102, super var]
type = VarSet
trigger1 = time = 0
v = 6
value = 2

[State 3102, super pause]
type = SuperPause
trigger1 = AnimElem = 3
anim = -1
pos = -26,-76
sound = s170,2
time = 28
movetime = 28
darken = 0
poweradd = -2000

[State 3102, dark background]
type = EnvColor
trigger1 = AnimElem = 3
value = 0, 0, 0
time = 28
under = 1

[State 3102, front spark]
type = Explod
trigger1 = AnimElem = 3
anim = 3600
bindtime = 1
sprpriority = 3
ownpal = 1
pos = -20,-90
supermovetime = 28

[State 3102, back spark]
type = Explod
trigger1 = AnimElem = 3
anim = 3601
bindtime = 1
sprpriority = -3
ownpal = 1
pos = -20,-90
supermovetime = 28

[State 3102, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 3110

; Run
;----

[StateDef 3110]
type = S
movetype = A
physics = S
anim = 3110
sprpriority = 2
juggle = 5

[State 3110, velocity]
type = VelSet
trigger1 = 1
x = 14.11

[State 3110, after images]
type = AfterImage
trigger1 = time = 0
time = 60
length = 9
palbright = 72,72,72
palcontrast = 128,128,128
paladd = 0,0,0
palmul = 1,1,1
timegap = 1
framegap = 4

[State 3110, hit def]
type = HitDef
trigger1 = !MoveContact
attr = S, HA
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = low
priority = 4, hit
damage = 0,0
getpower = 0,0
givepower = 0,0
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -32
hitsound = s140,3
guardsound = s150,2
pausetime = 8,8
ground.slidetime = 14
ground.hittime = 30
ground.velocity = -5.3
guard.pausetime = 8,8
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -5.3
NumHits = 0
P2Facing = 1
forcestand = 1

[State 3110, combo state]
type = ChangeState
triggerall = MoveHit
trigger1 = (facing * pos x) >= 0
value = 3120 + 10*(var(6)=2)

[State 3110, brake state]
type = ChangeState
triggerall = !MoveHit
trigger1 = MoveGuarded
trigger2 = time = 60
value = 3111

; Brake
;------

[StateDef 3111]
type = S
movetype = I
physics = S
anim = 3111
sprpriority = 2

[State 3111, after images]
type = AfterImageTime
trigger1 = time = 0
value = 0

[State 3111, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

; Combo - Level 1
;----------------

[StateDef 3120]
type = S
movetype = A
physics = S
anim = 3120
sprpriority = 2

[State 3120, after images]
type = AfterImageTime
trigger1 = time = 54
value = 0

[State 3120, screen bound]
type = ScreenBound
trigger1 = AnimElem = 25, >= 0
trigger1 = AnimElem = 28, < 0
value = 0

[State 3120, ghost]
type = PlayerPush
trigger1 = AnimElem = 25, >= 0
trigger1 = AnimElem = 28, < 0
value = 0

[State 3120, velocity]
type = VelSet
trigger1 = AnimElem = 25, < 0
x = 5.3

[State 3120, velocity]
type = VelSet
trigger1 = AnimElem = 25
x = 18

[State 3120, velocity]
type = VelSet
trigger1 = AnimElem = 28, = 1
x = 0

[State 3120, turn]
type = turn
trigger1 = AnimElem = 28, = 1 && P2Dist x < 0

[State 3120, target state]
type = TargetState
trigger1 = AnimElem = 25, < 0
trigger1 = NumTarget > 0
trigger1 = target, statetype = A
value = 3150

[State 3120, hit def 1]
type = HitDef
trigger1 = AnimElem = 2
trigger2 = AnimElem = 7
trigger3 = AnimElem = 12
trigger4 = AnimElem = 19
attr = S, HA
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = high
priority = 4, hit
damage = 20,2
getpower = 0,0
givepower = 10,10
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -70
hitsound = s140,3
guardsound = s150,2
pausetime = 8,8
ground.slidetime = 14
ground.hittime = 30
ground.velocity = -4.7
guard.pausetime = 8,8
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -4.7
kill = 0

[State 3120, hit def 2]
type = HitDef
trigger1 = AnimElem = 4
trigger2 = AnimElem = 9
trigger3 = AnimElem = 17
attr = S, HA
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = low
priority = 4, hit
damage = 20,2
getpower = 0,0
givepower = 10,10
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -65
hitsound = s140,3
guardsound = s150,2
pausetime = 8,8
ground.slidetime = 14
ground.hittime = 30
ground.velocity = -4.7
guard.pausetime = 8,8
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -4.7
kill = 0

[State 3120, hit def 3]
type = HitDef
trigger1 = AnimElem = 24
attr = S, HA
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = low
priority = 4, hit
damage = 20,2
getpower = 0,0
givepower = 10,10
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -65
hitsound = s140,3
guardsound = s150,2
pausetime = 14,16
ground.slidetime = 14
ground.hittime = 30
ground.velocity = 4.7
guard.pausetime = 8,8
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -4.7
P2Facing = -1
kill = 0

[State 3120, last hit def]
type = HitDef
trigger1 = AnimElem = 33
attr = S, HA
hitflag = MAF
guardflag = MA
animtype = up
priority = 4, hit
damage = 80,1
getpower = 0,0
givepower = 10,10
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -70
hitsound = s140,5
guardsound = s150,2
pausetime = 16,16
ground.velocity = -4, -6
guard.pausetime = 16,16
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -5.3
fall = 1
air.fall = 1
fall.recover = 0

[State 3120, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

; Combo - Level 2
;----------------

[StateDef 3130]
type = S
movetype = A
physics = S
anim = 3130
sprpriority = 2

[State 3130, after images]
type = AfterImageTime
trigger1 = time = 94
value = 0

[State 3130, velocity]
type = VelSet
trigger1 = AnimElem = 32, < 0
x = 5.3

[State 3130, velocity]
type = VelSet
trigger1 = AnimElem = 61, >= 0
trigger1 = AnimElem = 63, < 0
x = 3.8

[State 3130, target state]
type = TargetState
trigger1 = AnimElem = 54, < 0
trigger1 = NumTarget > 0
trigger1 = target, statetype = A
value = 3150

[State 3130, hit def 1]
type = HitDef
trigger1 = AnimElem = 2
trigger2 = AnimElem = 9
trigger3 = AnimElem = 12
trigger4 = AnimElem = 18
trigger5 = AnimElem = 25
trigger6 = AnimElem = 35
attr = S, HA
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = high
priority = 4, hit
damage = 20,2
getpower = 0,0
givepower = 10,10
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -70
hitsound = s140,3
guardsound = s150,2
pausetime = 8,8
ground.slidetime = 14
ground.hittime = 30
ground.velocity = -4.7
guard.pausetime = 8,8
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -4.7
kill = 0

[State 3130, hit def 2]
type = HitDef
trigger1 = AnimElem = 4
trigger2 = AnimElem = 15
trigger3 = AnimElem = 20
trigger4 = AnimElem = 28
trigger5 = AnimElem = 33
attr = S, HA
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = low
priority = 4, hit
damage = 20,2
getpower = 0,0
givepower = 10,10
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -65
hitsound = s140,3
guardsound = s150,2
pausetime = 8,8
ground.slidetime = 14
ground.hittime = 30
ground.velocity = -4.7
guard.pausetime = 8,8
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -4.7
kill = 0

[State 3130, hit def 3]
type = HitDef
trigger1 = AnimElem = 7
trigger2 = AnimElem = 23
attr = S, HA
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = low
priority = 4, hit
damage = 20,2
getpower = 0,0
givepower = 10,10
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -32
hitsound = s140,3
guardsound = s150,2
pausetime = 8,8
ground.slidetime = 14
ground.hittime = 30
ground.velocity = -4.7
guard.pausetime = 8,8
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -4.7
kill = 0

[State 3120, hit def 4]
type = HitDef
trigger1 = AnimElem = 39
trigger2 = AnimElem = 45
trigger3 = AnimElem = 53
attr = S, HA
hitflag = MAF
guardflag = MA
animtype = hard
ground.type = low
priority = 4, hit
damage = 20,2
getpower = 0,0
givepower = 10,10
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -65
hitsound = s140,3
guardsound = s150,2
pausetime = 14,16
ground.slidetime = 14
ground.hittime = 40
ground.velocity = -2.35
guard.pausetime = 8,8
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -4.7
kill = 0

[State 3130, last hit def]
type = HitDef
trigger1 = AnimElem = 62
attr = S, HA
hitflag = MAF
guardflag = MA
animtype = up
priority = 4, hit
damage = 80,1
getpower = 0,0
givepower = 10,10
sparkno = 1
guard.sparkno = 40
sparkxy = 0, -70
hitsound = s140,5
guardsound = s150,2
pausetime = 16,16
ground.velocity = -4, -6
guard.pausetime = 16,16
guard.slidetime = 14
guard.hittime = 19
guard.ctrtime = 19
guard.velocity = -5.3
fall = 1
air.fall = 1
fall.recover = 0

[State 3130, end state]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

; Put Enemy On Ground
;--------------------

[StateDef 3150]
type = S
movetype = H
physics = S

[State 3150, pos]
type = PosSet
trigger1 = time = 0
y = 0

[State 3150, self state]
type = SelfState
trigger1 = pos y = 0 && statetype = S
value = 5000



;================================================================================================
;
; AI ACTIVATION STATES - Code by Winane
;
;================================================================================================

; For more details on this code, download the commented version on Winane's website : http://winane.shinmugen.net/

[StateDef 9741]
type = S
movetype = I
physics = N
anim = 9741
ctrl = 0

[State 9741, Safety]; Just in case your opponent is very poorly coded.
type = SelfState
trigger1 = !IsHelper
value = 0

[State 9741, PauseCheck]
type = VarSet
trigger1 = (GameTime>(Parent,var(58)))
trigger2 = !(Parent,Alive)
trigger3 = (RoundState != 2)
trigger4 = Parent,var(59)
trigger5 = (var(3):=0)
var(2) = (var(3):=1)+(var(4):=0)

[State 9741, Facing]
type = Turn
trigger1 = (var(9):=(Facing != Parent,Facing))

[State 9741, DirTurnOnAI]
type = ParentVarSet
triggerall = !var(3)
triggerall = !var(9)
trigger1 = (Parent,command = "holdfwd")
trigger2 = (Parent,command = "holdback")
trigger3 = (Parent,command = "holdup")
trigger4 = (Parent,command = "holddown")
trigger5 = !(var(4):=1)
var(59) = var(4)

[State 9741, DirTurnOffAI]
type = ParentVarSet
triggerall = !var(3)
triggerall = Parent,var(59)
trigger1 = (command = "holdfwd")
trigger1 = (Parent,command = "holdfwd")
trigger2 = (command = "holdback")
trigger2 = (Parent,command = "holdback")
trigger3 = (command = "holdup")
trigger3 = (Parent,command = "holdup")
trigger4 = (command = "holddown")
trigger4 = (Parent,command = "holddown")
var(59) = (var(4):=0)

[State 9741, ButtonTurnOnAI]
type = ParentVarSet
triggerall = var(1)
triggerall = !var(2)
trigger1 = (Parent,command = "a")
trigger2 = (Parent,command = "b")
trigger3 = (Parent,command = "c")
trigger4 = (Parent,command = "x")
trigger5 = (Parent,command = "y")
trigger6 = (Parent,command = "z")
trigger7 = (Parent,command = "start")
var(59) = 1

[State 9741, ButtonTurnOffAI]
type = ParentVarSet
triggerall = !var(2)
trigger1 = (command = "a")
trigger1 = (Parent,command = "a")
trigger2 = (command = "b")
trigger2 = (Parent,command = "b")
trigger3 = (command = "c")
trigger3 = (Parent,command = "c")
trigger4 = (command = "x")
trigger4 = (Parent,command = "x")
trigger5 = (command = "y")
trigger5 = (Parent,command = "y")
trigger6 = (command = "z")
trigger6 = (Parent,command = "z")
trigger7 = (command = "start")
trigger7 = (Parent,command = "start")
var(59) = -1

[State 9741, UnPauseCheck]
type = VarSet
triggerall = var(2)
trigger1 = (Parent,command = "a")
trigger2 = (Parent,command = "b")
trigger3 = (Parent,command = "c")
trigger4 = (Parent,command = "x")
trigger5 = (Parent,command = "y")
trigger6 = (Parent,command = "z")
trigger7 = (Parent,command = "start")
trigger8 = (var(2) = 2)
trigger8 = (var(2):=0)
var(2) = 2

[State 9741, Goodbye]
type = DestroySelf
triggerall = (var(1):=1)
trigger1 = Parent,var(59)
trigger2 = !(Parent,Alive)
trigger3 = (RoundState != 2)



[StateDef 9742]
type = S
movetype = I
physics = N
anim = 9741
ctrl = 0

[State 9742, Safety]; Just in case your opponent is very poorly coded.
type = SelfState
trigger1 = !IsHelper
value = 0

[State 9742, PauseCheck]
type = VarSet
trigger1 = (GameTime>Parent,var(58))
trigger2 = !(Parent,Alive)
trigger3 = (RoundState != 2)
trigger4 = Parent,var(59)
trigger5 = (var(3):=0)
var(2) = (var(3):=1)

[State 9742, Facing]
type = Turn
trigger1 = (var(9):=(Facing != Parent,Facing))

[State 9742, ParentDirCheck]
type = VarSet
trigger1 = (Parent,command = "holdfwd")
trigger2 = (Parent,command = "holdback")
trigger3 = (Parent,command = "holdup")
trigger4 = (Parent,command = "holddown")
trigger5 = (var(6):=0)
var(6) = 1

[State 9742, ParentButtonCheck]
type = VarSet
trigger1 = (Parent,command = "a")
trigger2 = (Parent,command = "b")
trigger3 = (Parent,command = "c")
trigger4 = (Parent,command = "x")
trigger5 = (Parent,command = "y")
trigger6 = (Parent,command = "z")
trigger7 = (Parent,command = "start")
trigger8 = (var(7):=0)
var(7) = 1

[State 9742, SameButtonCheck]
type = VarSet
triggerall = var(7)
triggerall = !var(2)
trigger1 = (Parent,command = "a")
trigger1 = (Partner,command = "a")
trigger2 = (Parent,command = "b")
trigger2 = (Partner,command = "b")
trigger3 = (Parent,command = "c")
trigger3 = (Partner,command = "c")
trigger4 = (Parent,command = "x")
trigger4 = (Partner,command = "x")
trigger5 = (Parent,command = "y")
trigger5 = (Partner,command = "y")
trigger6 = (Parent,command = "z")
trigger6 = (Partner,command = "z")
trigger7 = (Parent,command = "start")
trigger7 = (Partner,command = "start")
trigger8 = (var(8):=0)
var(8) = 1

[State 9742, DirTurnOnAI]
type = ParentVarSet
trigger1 = var(1)
trigger1 = var(6)
trigger1 = !var(3)
trigger1 = !var(4)
trigger1 = !var(9)
var(59) = 1

[State 9742, DirTurnOffAI]
type = ParentVarSet
triggerall = var(6)
triggerall = !var(3)
triggerall = Parent,var(59)
trigger1 = (command = "holdfwd")
trigger1 = (Parent,command = "holdfwd")
trigger2 = (command = "holdback")
trigger2 = (Parent,command = "holdback")
trigger3 = (command = "holdup")
trigger3 = (Parent,command = "holdup")
trigger4 = (command = "holddown")
trigger4 = (Parent,command = "holddown")
var(59) = 0

[State 9742, ButtonTurnOnAI]
type = ParentVarSet
trigger1 = var(5)
trigger1 = var(7)
trigger1 = !var(2)
trigger1 = !var(8)
var(59) = 1

[State 9742, ButtonTurnOffAI]
type = ParentVarSet
triggerall = var(7)
triggerall = !var(2)
triggerall = !var(8)
trigger1 = (command = "a")
trigger1 = (Parent,command = "a")
trigger2 = (command = "b")
trigger2 = (Parent,command = "b")
trigger3 = (command = "c")
trigger3 = (Parent,command = "c")
trigger4 = (command = "x")
trigger4 = (Parent,command = "x")
trigger5 = (command = "y")
trigger5 = (Parent,command = "y")
trigger6 = (command = "z")
trigger6 = (Parent,command = "z")
trigger7 = (command = "start")
trigger7 = (Parent,command = "start")
var(59) = -1

[State 9742, UnPauseCheck]
type = VarSet
triggerall = var(2)
triggerall = !var(4)
trigger1 = var(7)
trigger2 = (var(2) = 2)
trigger2 = (var(2):=0)
var(2) = 2

[State 9742, Goodbye]
type = DestroySelf
trigger1 = Parent,var(59)
trigger2 = !(Parent,Alive)
trigger3 = (RoundState != 2)

[State 9742, HitPauseCheck]
type = VarSet
trigger1 = var(6)
trigger2 = var(7)
trigger3 = !(Parent,HitPauseTime)
var(4) = Parent,HitPauseTime

[State 9742, Delay]
type = VarSet
trigger1 = (var(1):=1)
var(5) = !var(7)



;================================================================================================
;
; MISC STATES
; 
;================================================================================================

[Statedef -3]

; Randomize Hit voices
;---------------------
[state -3, randomize hit voices]
type = VarRandom
triggerall = Life > 0 && time = 0
trigger1 = StateNo = 5000
trigger2 = StateNo = 5010
trigger3 = StateNo = 5020
trigger4 = StateNo = 5070
trigger5 = StateNo = 5080
trigger6 = StateNo = 5100
v = 3
range = 0, 3

; Hit voices
;-----------
[state -3, hit voices]
type = PlaySnd
triggerall = Life > 0 && time = 1
trigger1 = StateNo = 5000
trigger2 = StateNo = 5010
trigger3 = StateNo = 5020
trigger4 = StateNo = 5070
trigger5 = StateNo = 5080
trigger6 = StateNo = 5100
value = 10, var(3)
channel = 0

; AI - 1st part
;--------------

; The 2nd part is in the -2 states

[State -3, SetAI]
type = VarSet
triggerall = !RoundState
triggerall = IsHomeTeam
trigger1 = (TeamSide = 2)
trigger2 = (MatchNo > 1)
var(59) = 1

[State -3, Unfair]; Is this reliable?
type = VarSet
trigger1 = !RoundState
trigger1 = (var(59) != 1)
trigger1 = NumPartner
trigger1 = (ID > Partner,ID)
trigger1 = (TeamSide = 2)
var(59) = 1

[State -3, AI Helper (Compatibly Partnered Version)]
type = Helper
trigger1 = !var(59)
trigger1 = !NumHelper(9742)
trigger1 = (RoundState = 2)
trigger1 = Alive
trigger1 = NumPartner
trigger1 = Partner,SelfAnimExist(9741)
HelperType = normal
name = "AI Helper (Simul Version)"
ID = 9742
pos = 9999999,99999
StateNo = 9742
KeyCtrl = 1
PauseMoveTime = 999999999
SuperMoveTime = 999999999

[State -3, AI Helper]
type = Helper
triggerall = !var(59)
triggerall = !NumHelper(9741)
triggerall = (RoundState = 2)
triggerall = Alive
trigger1 = !NumPartner
trigger2 = !(Partner,SelfAnimExist(9741))
HelperType = normal
name = "AI Helper"
ID = 9741
pos = 9999999,99999
StateNo = 9741
KeyCtrl = 1
PauseMoveTime = 999999999
SuperMoveTime = 999999999

[State -3, TurnBackOnAI]
type = VarSet
trigger1 = (var(59) = -2)
trigger1 = (RoundState = 2)
trigger1 = Alive
var(59) = 1

[State -3, XOR]
type = VarSet
triggerall = var(59)!=1
trigger1 = (command = "a") ^^ (command = "a2")
trigger2 = (command = "b") ^^ (command = "b2")
trigger3 = (command = "c") ^^ (command = "c2")
trigger4 = (command = "x") ^^ (command = "x2")
trigger5 = (command = "y") ^^ (command = "y2")
trigger6 = (command = "z") ^^ (command = "z2")
trigger7 = (command = "start") ^^ (command = "start2")
trigger8 = (command = "holda") ^^ (command = "holda2")
trigger9 = (command = "holdb") ^^ (command = "holdb2")
trigger10 = (command = "holdc") ^^ (command = "holdc2")
trigger11 = (command = "holdx") ^^ (command = "holdx2")
trigger12 = (command = "holdy") ^^ (command = "holdy2")
trigger13 = (command = "holdz") ^^ (command = "holdz2")
trigger14 = (command = "holdstart") ^^ (command = "holdstart2")
trigger15 = (command = "holdfwd") ^^ (command = "holdfwd2")
trigger16 = (command = "holdback") ^^ (command = "holdback2")
trigger17 = (command = "holdup") ^^ (command = "holdup2")
trigger18 = (command = "holddown") ^^ (command = "holddown2")
;Add more as desired. (See my notes in the CMD.)
var(59) = 1

[State -3, GameTimeVar]
type = Null
trigger1 = (var(58):=GameTime)
IgnoreHitPause = 1



[Statedef -2]

; Display Infos
;--------------
[State -2, display vel & pos]
type = DisplayToClipboard
trigger1 = 1
text = "AI=%d, Vel(%f,%f) Pos(%f,%f)"
params = var(59), Vel X,Vel Y,Pos X,Pos Y

; Remove After Images
;--------------------
[State -2, remove after images]
type = AfterImageTime
triggerall = Name = "Lynn"
triggerall = time = 0
trigger1 = PrevStateNo = 50
value = 0

; Stop Run Sound
;---------------
[State -2, stop run sound]
type = StopSnd
triggerall = Name = "Lynn"
triggerall = time = 1
trigger1 = PrevStateNo = 100
trigger2 = PrevStateNo = 3110
channel = 1

; Ennemy Flamme 1
;----------------
[State -2, ennemy flame 1]
type = Explod
triggerall = Name = "Lynn"
triggerall = NumExplod(1151) = 0
trigger1 = ProjHit1100 = 1
trigger1 = NumTarget > 0
trigger1 = target, IsHelper = 0
ID = 1151
anim = 1150
pos = 10,-30
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1

; Ennemy Flamme 2
;----------------
[State -2, ennemy flame 2]
type = Explod
triggerall = Name = "Lynn"
triggerall = NumExplod(1152) = 0
trigger1 = ProjHit1100 = 1
trigger1 = NumTarget > 0
trigger1 = target, IsHelper = 0
ID = 1152
anim = 1150
pos = const(size.mid.pos.x) - 10,const(size.mid.pos.y) - 20
postype = p2
bindtime = 22;50
removetime = 22;50
sprpriority = 1
ownpal = 1
ignorehitpause = 1

; AI - 2nd part
;--------------

[State -2, StopAI]
type = VarSet
triggerall = (var(59) > 0)
trigger1 = (RoundState != 2)
trigger2 = !Alive
var(59) = -2
IgnoreHitPause = 1
