;==============================================================================================
;
; COMMANDS DEFINITION
;
;==============================================================================================

;-| Default Values |---------------------------------------------------------------------------
[Defaults]

command.time = 15
command.buffer.time = 1



;-| Single Button |----------------------------------------------------------------------------

[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1


;-| Hold Direction |---------------------------------------------------------------------------

[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1


;-| Hold Button |------------------------------------------------------------------------------

[Command]
name = "holda"
command = /a
time = 1

[Command]
name = "holdb"
command = /b
time = 1

[Command]
name = "holdc"
command = /c
time = 1

[Command]
name = "holdx"
command = /x
time = 1

[Command]
name = "holdy"
command = /y
time = 1

[Command]
name = "holdz"
command = /z
time = 1

[Command]
name = "holdstart"
command = /s
time = 1


;-| CPU |--------------------------------------------------------------------------------------


[Command]
name = "a2"
command = a
time = 1

[Command]
name = "b2"
command = b
time = 1

[Command]
name = "c2"
command = c
time = 1

[Command]
name = "x2"
command = x
time = 1

[Command]
name = "y2"
command = y
time = 1

[Command]
name = "z2"
command = z
time = 1

[Command]
name = "start2"
command = s
time = 1

[Command]
name = "holdfwd2"
command = /$F
time = 1

[Command]
name = "holdback2"
command = /$B
time = 1

[Command]
name = "holdup2"
command = /$U
time = 1

[Command]
name = "holddown2"
command = /$D
time = 1

[Command]
name = "holda2"
command = /a
time = 1

[Command]
name = "holdb2"
command = /b
time = 1

[Command]
name = "holdc2"
command = /c
time = 1

[Command]
name = "holdx2"
command = /x
time = 1

[Command]
name = "holdy2"
command = /y
time = 1

[Command]
name = "holdz2"
command = /z
time = 1

[Command]
name = "holdstart2"
command = /s
time = 1

[Command]
name = "recovery2"
command = x+a
time = 1


;-| Super Motions |----------------------------------------------------------------------------

[Command]
name 	= "super_combo_1"
command = ~D, F, D, F, x
time 	= 35

[Command]
name 	= "super_combo_2"
command = ~D, F, D, F, y
time 	= 35

[Command]
name 	= "tobi_ryu_1"
command = ~D, F, D, F, a
time 	= 35

[Command]
name 	= "tobi_ryu_2"
command = ~D, F, D, F, b
time 	= 35

[Command]
name 	= "tobi_ryu_3"
command = ~D, F, D, F, a+b
time 	= 35


;-| Special Motions |--------------------------------------------------------------------------

[Command]
name 	= "dp_x"
command = ~B, F, x
time 	= 15

[Command]
name 	= "dp_y"
command = ~B, F, y
time 	= 15

[Command]
name 	= "qcf_x"
command = ~D, DF, F, x
time 	= 15

[Command]
name 	= "qcf_y"
command = ~D, DF, F, y
time 	= 15

[Command]
name 	= "qcf_a"
command = ~D, DF, F, a
time 	= 15

[Command]
name 	= "qcf_b"
command = ~D, DF, F, b
time 	= 15

[Command]
name 	= "rdp_x"
command = ~B, DB, D, x
time 	= 20

[Command]
name 	= "rdp_y"
command = ~B, DB, D, y
time 	= 20

[Command]
name 	= "hcb_x"
command = ~D, DB, B, x
time 	= 20

[Command]
name 	= "hcb_y"
command = ~D, DB, B, y
time 	= 20

[Command]
name	= "du_a"
command = ~D, U, a
time = 20

[Command]
name	= "du_b"
command = ~D, U, b
time = 20


;-| Double Tap |-------------------------------------------------------------------------------

[Command]
name 	= "FF"     ; Required (do not remove)
command = F, F
time 	= 20

[Command]
name 	= "BB"     ; Required (do not remove)
command = B, B
time 	= 20

[Command]
name 	= "DU"
command = $D, $U
time 	= 5


;-| 2/3 Button Combination |-------------------------------------------------------------------

[Command]
name 	= "recovery";Required (do not remove)
command = x+a
time 	= 1

[Command]
name 	= "recovery";Required (do not remove)
command = z
time 	= 1

[Command]
name 	= "x+a"
command = x+a
time 	= 1

[Command]
name 	= "x+a"
command = z
time 	= 1

[Command]
name 	= "y+b"
command = y+b
time 	= 1

[Command]
name 	= "y+b"
command = c
time 	= 1



;==============================================================================================
;
; STATE ENTRY
;
;==============================================================================================

[Statedef -1]

;=========
; AI Mode
;=========

; AI Initialisation
;------------------

[State -1, AI Helper Check]
type = ChangeState
trigger1 = IsHelper(9741)
value = 9741

[State -1, AI Helper Check 2]
type = ChangeState
trigger1 = IsHelper(9742)
value = 9742


; AI Standard Moves
;------------------

[State -1, AI walk]
type = ChangeState
value = 20
triggerall = var(59) = 1
triggerall = (P2MoveType != A) && (enemy, numproj = 0) && (P2BodyDist x > 70)
triggerall = (life > 400) && (StateNo != 20)
trigger1 = (StateType = S) && (ctrl) && (random = [0, 400))

[State -1, AI run fwd]
type = ChangeState
value = 100
triggerall = var(59) = 1
triggerall = (P2MoveType != A) && (enemy, numproj = 0) && (P2BodyDist x > 100)
triggerall = (life > 400) && (StateNo != 100)
trigger1 = (StateType = S) && (ctrl) && (random = [400, 600))

[State -1, AI hop back]
type = ChangeState
value = 105
triggerall = var(59) = 1
triggerall = (P2MoveType != A) && (enemy, numproj = 0) && (P2BodyDist x <= 70)
triggerall = (life <= 400) && (backedgebodydist > 100)
trigger1 = (StateType = S) && (ctrl) && (random = [0, 400))


; AI Defensive Moves
;-------------------

[State -1, AI dodge fwd]
type = ChangeState
value = 950
triggerall = var(59) = 1
triggerall = (P2BodyDist x = [0, 50]) && (P2MoveType = A) && (facing != enemy, facing)
trigger1 = (StateType = S) && (frontedgedist >= 100) && (ctrl) && (random = [0, 100))

[State -1, AI dodge back]
type = ChangeState
value = 960
triggerall = var(59) = 1
triggerall = (P2BodyDist x = [0, 50]) && (P2MoveType = A) && (facing != enemy, facing)
trigger1 = (StateType = S) && (backedgedist >= 100) && (ctrl) && (random = [100, 200))

[State -1, blocking1]
type = ChangeState
triggerall = var(59) = 1 && (P2Life > 0)
triggerall = (StateType != A) && (P2statetype != C)
triggerall = (P2Movetype = A) || (enemy, NumProj > 0)
trigger1 = ctrl
value = 130

[State -1, blocking2]
type = ChangeState
triggerall = var(59) = 1 && (P2Life > 0)
triggerall = (StateType != A) && (P2statetype = C)
triggerall = (P2Movetype = A) || (enemy, NumProj > 0)
trigger1 = ctrl
value = 131

[State -1, blocking3]
type = ChangeState
triggerall = var(59) = 1 && (P2Life > 0)
triggerall = (StateType != A) && (P2statetype != C)
triggerall = (P2Movetype = A) || (enemy, NumProj > 0)
trigger1 = stateno = 152
value = 150

[State -1, blocking4]
type = ChangeState
triggerall = var(59)= 1 && (P2Life > 0)
triggerall = (StateType != A) && (P2statetype = C)
triggerall = (P2Movetype = A) || (enemy, NumProj > 0)
trigger1 = stateno = 150
value = 152

[State -1, blocking5]
type = ChangeState
triggerall = var(59) = 1 && (P2Life > 0)
triggerall = (StateType = A) && (P2Movetype = A) || (enemy, NumProj > 0)
trigger1 = ctrl
value = 132


; AI Supers
;----------

[State -1, AI tobi ryu 2]
type = ChangeState
value = 3002
triggerall = var(59) = 1 && power >= 2000
triggerall = (StateType != A) && (P2BodyDist x = [30, 75]) && (P2Life > 0)
trigger1 = (ctrl) && (P2MoveType = H) && (P2StateType != L) && (random = [0, 200])
trigger2 = (ctrl) && (P2MoveType != H) && (random = [0, 100])
trigger3 = (stateno = 220) && (movecontact) && (random = [0, 200])
trigger4 = (stateno = 230) && (movecontact) && (random = [0, 200])
trigger5 = (stateno = 500) && (movecontact) && (random = [0, 200])

[State -1, AI tobi ryu 1]
type = ChangeState
value = 3001
triggerall = var(59) = 1 && power >= 1000
triggerall = (StateType != A) && (P2BodyDist x = [30, 75]) && (P2Life > 0)
trigger1 = (ctrl) && (P2MoveType = H) && (P2StateType != L) && (random = [0, 100])
trigger2 = (ctrl) && (P2MoveType != H) && (random = [0, 150])
trigger3 = (stateno = 220) && (movecontact) && (random = [0, 100])
trigger4 = (stateno = 230) && (movecontact) && (random = [0, 100])
trigger5 = (stateno = 500) && (movecontact) && (random = [0, 100])

[State -1, AI super combo 2]
type = ChangeState
value = 3102
triggerall = var(59) = 1 && power >= 2000
triggerall = (P2BodyDist x > 70) && (enemy, numproj = 0) && (P2Life > 0) && (enemy, statetype != A) && (P2StateType != L)
trigger1 = (StateType != A) && (ctrl) && (random = [150, 200])
trigger2 = (stateno = 220) && (movecontact) && (random = [150, 200])
trigger3 = (stateno = 230) && (movecontact) && (random = [150, 200])
trigger4 = (stateno = 500) && (movecontact) && (random = [150, 200])

[State -1, AI super combo 1]
type = ChangeState
value = 3101
triggerall = var(59) = 1 && power >= 1000
triggerall = (P2BodyDist x > 70) && (enemy, numproj = 0) && (P2Life > 0) && (enemy, statetype != A) && (P2StateType != L)
trigger1 = (StateType != A) && (ctrl) && (random = [150, 250])
trigger2 = (stateno = 220) && (movecontact) && (random = [150, 250])
trigger3 = (stateno = 230) && (movecontact) && (random = [150, 250])
trigger4 = (stateno = 500) && (movecontact) && (random = [150, 250])


; AI Specials
;------------

[State -1, AI enretsu ken x1]
type = ChangeState
value = 1000
triggerall = var(59) = 1
triggerall = (P2BodyDist x = [0, 70]) && (P2Life > 0)
trigger1 = (StateType != A) && (ctrl) && (random = [0, 100])
trigger2 = (stateno = 220) && (movecontact) && (random = [250, 300])
trigger3 = (stateno = 230) && (movecontact) && (random = [250, 300])
trigger4 = (stateno = 500) && (movecontact) && (random = [250, 300])

[State -1, AI enretsu ken x2]
type = ChangeState
value = 1050
triggerall = var(59) = 1
triggerall = (P2BodyDist x = [0, 70]) && (P2Life > 0)
trigger1 = (StateType != A) && (ctrl) && (random = [100, 200])
trigger2 = (stateno = 220) && (movecontact) && (random = [300, 400])
trigger3 = (stateno = 230) && (movecontact) && (random = [300, 400])
trigger4 = (stateno = 500) && (movecontact) && (random = [300, 400])

[State -1, AI ryu en hou launcher 1]
type = ChangeState
value = 1200
triggerall = var(59) = 1
triggerall = (P2BodyDist x = [0, 70]) && (P2Life > 0)
trigger1 = (StateType != A) && (ctrl) && (random = [200, 300])
trigger2 = (stateno = 220) && (movecontact) && (random = [400, 450])
trigger3 = (stateno = 230) && (movecontact) && (random = [400, 450])
trigger4 = (stateno = 500) && (movecontact) && (random = [400, 450])

[State -1, AI ryu en hou launcher 2]
type = ChangeState
value = 1250
triggerall = var(59) = 1
triggerall = (P2BodyDist x = [0, 70]) && (P2Life > 0)
trigger1 = (StateType != A) && (ctrl) && (random = [300, 400])
trigger2 = (stateno = 220) && (movecontact) && (random = [450, 500])
trigger3 = (stateno = 230) && (movecontact) && (random = [450, 500])
trigger4 = (stateno = 500) && (movecontact) && (random = [450, 500])

[State -1, AI ryu en hou punch 1]
type = ChangeState
value = 1210
triggerall = var(59) = 1
triggerall = (P2BodyDist x = [30, 75]) && (P2Life > 0)
trigger1 = (StateNo = 1200) && (time = [20,25]) && (random <= 900)

[State -1, AI ryu en hou punch 2]
type = ChangeState
value = 1220
triggerall = var(59) = 1
triggerall = (P2BodyDist x = [0, 50]) && (P2BodyDist y = [-70,0]) && (P2Life > 0)
trigger1 = (StateNo = 1210) && (time > 16) && (random <= 900)

[State -1, AI ryu en hou kick 1]
type = ChangeState
value = 1260
triggerall = var(59) = 1
triggerall = (P2BodyDist x = [30, 75]) && (P2Life > 0)
trigger1 = (StateNo = 1250) && (time = [20,25]) && (random <= 900)

[State -1, AI ryu en hou kick 2]
type = ChangeState
value = 1270
triggerall = var(59) = 1
triggerall = (P2BodyDist x = [0, 50]) && (P2BodyDist y = [-60,-35]) && (P2Life > 0)
trigger1 = (StateNo = 1260) && (time > 16) && (random <= 900)

[State -1, AI ko ryu sho zan]
type = ChangeState
value = 1100
triggerall = var(59) = 1
triggerall = (P2Dist x >= 200) && (P2Life > 0)
triggerall = (StateType != A) && (ctrl)
trigger1 = ifelse(life > 400, (random = [0, 50]), (random = [0, 100]))
trigger2 = (enemy, numproj > 0) && (random = [0, 900))
trigger3 = (stateno = 220) && (movecontact) && (random = [700, 800])
trigger4 = (stateno = 230) && (movecontact) && (random = [700, 800])
trigger5 = (stateno = 500) && (movecontact) && (random = [700, 800])


; AI Throws
;----------

[State -1, AI ground throw]
type = ChangeState
value = 700
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 20]) && (P2StateType != A) && (P2MoveType != H)
trigger1 = (StateType != A) && (ctrl) && (random = [0, 100])

[State -1, AI ground throw]
type = ChangeState
value = 750
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 20]) && (P2StateType != A) && (P2MoveType != H)
trigger1 = (StateType != A) && (ctrl) && (random = [100, 200])

[State -1, AI air throw]
type = ChangeState
value = 800
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 20]) && (P2StateType = A) && (P2MoveType != H)
trigger1 = (StateType = A) && (ctrl) && (random = [0, 200])


; AI Standing Attacks
;--------------------

[State -1, AI stand knock-down attack]
type = ChangeState
value = 510
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 70]) && (P2BodyDist y = [-100,0]) && (P2Life > 0)
trigger1 = (StateType = S) && (ctrl) && (random = [800, 900))

[State -1, AI overhead punch]
type = ChangeState
value = 500
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 75]) && (P2StateType = C) && (P2Life > 0)
trigger1 = (StateType = S) && (ctrl) && (random = [0, 300])

[State -1, AI stand light punch]
type = ChangeState
value = 200
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 65]) && (P2BodyDist y = [-70,0]) && (P2Life > 0)
trigger1 = (StateType = S) && (ctrl) && (random = [0, 200))

[State -1, AI stand fierce punch]
type = ChangeState
value = 220
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 65]) && (P2BodyDist y = [-70,0]) && (P2Life > 0)
trigger1 = (StateType = S) && (ctrl) && (random = [200, 400))

[State -1, AI stand light kick]
type = ChangeState
value = 210
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 65]) && (P2BodyDist y = [-60,0]) && (P2Life > 0)
trigger1 = (StateType = S) && (ctrl) && (random = [400, 600))

[State -1, AI stand fierce kick]
type = ChangeState
value = 230
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 80]) && (P2BodyDist y = [-85,0]) && (P2Life > 0)
trigger1 = (StateType = S) && (ctrl) && (random = [600, 800])


; AI Crouching Attacks
;---------------------

[State -1, AI crouch light punch]
type = ChangeState
value = 300
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 55]) && (P2BodyDist y = [-50,0]) && (P2Life > 0)
trigger1 = (StateType = C) && (ctrl) && (random = [0, 200))

[State -1, AI crouch fierce punch]
type = ChangeState
value = 320
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 45]) && (P2BodyDist y = [-70,0]) && (P2Life > 0)
trigger1 = (StateType = C) && (ctrl) && (random = [200, 400))

[State -1, AI crouch light kick]
type = ChangeState
value = 310
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 50]) && (P2BodyDist y = [-20,0]) && (P2Life > 0)
trigger1 = (StateType = C) && (ctrl) && (random = [400, 600))

[State -1, AI crouch fierce kick]
type = ChangeState
value = 330
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 85]) && (P2BodyDist y = [-25,0]) && (P2Life > 0)
trigger1 = (StateType = C) && (ctrl) && (random = [600, 800))


; AI Aerial Attacks
;------------------

[State -1, AI air knock-down attack]
type = ChangeState
value = 610
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 65]) && (P2BodyDist y = [-65,0]) && (P2Life > 0)
trigger1 = (StateType = A) && (ctrl) && (random = [800, 900))

[State -1, AI air back kick]
type = ChangeState
value = 600
triggerall = var(59) = 1
triggerall = (P2bodydist x = [-65, 0]) && (P2Life > 0)
trigger1 = (StateType = A) && (ctrl) && (random = [0, 600))

[State -1, AI air light punch]
type = ChangeState
value = 400
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 35]) && (P2BodyDist y = [-90,-50]) && (P2Life > 0)
trigger1 = (StateType = A) && (ctrl) && (random = [0, 200))

[State -1, AI air neutral fierce punch]
type = ChangeState
value = 420
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 50]) && (P2BodyDist y = [-105,-65]) && (P2Life > 0)
trigger1 = (vel x = 0) && (StateType = A) && (ctrl) && (random = [200, 400))

[State -1, AI air diagonal fierce punch]
type = ChangeState
value = 420
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 35]) && (P2BodyDist y = [-100,-55]) && (P2Life > 0)
trigger1 = (vel x != 0) && (StateType = A) && (ctrl) && (random = [200, 400))

[State -1, AI air light kick]
type = ChangeState
value = 410
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 50]) && (P2BodyDist y = [-80,-20]) && (P2Life > 0)
trigger1 = (StateType = A) && (ctrl) && (random = [400, 600))

[State -1, AI air neutral fierce kick]
type = ChangeState
value = 430
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 45]) && (P2BodyDist y = [-85,-15]) && (P2Life > 0)
trigger1 = (vel x = 0) && (StateType = A) && (ctrl) && (random = [600, 800))

[State -1, AI air neutral fierce kick]
type = ChangeState
value = 430
triggerall = var(59) = 1
triggerall = (P2bodydist x = [0, 70]) && (P2BodyDist y = [-90,-50]) && (P2Life > 0)
trigger1 = (vel x != 0) && (StateType = A) && (ctrl) && (random = [600, 800))


; AI Taunt
;---------

[State -1, AI taunt]
type = ChangeState
value = 195
triggerall = var(59) = 1
triggerall = (P2StateNo = [195,199])
trigger1 = (StateType != A) && (ctrl) && (random <= 300)


;=================
; Supers / Hypers
;=================

; Tobi Ryu - Level 2
;-------------------
[State -1, tobi ryu 2]
type = ChangeState
value = 3002
triggerall = var(59) <= 0
triggerall = command = "tobi_ryu_2" && power >= 2000
trigger1 = statetype != A && ctrl
trigger2 = stateno = 220 && movecontact
trigger3 = stateno = 230 && movecontact
trigger4 = stateno = 500 && movecontact

; Tobi Ryu - Level 1
;-------------------
[State -1, tobi ryu 1]
type = ChangeState
value = 3001
triggerall = var(59) <= 0
triggerall = command = "tobi_ryu_1" && power >= 1000
trigger1 = statetype != A && ctrl
trigger2 = stateno = 220 && movecontact
trigger3 = stateno = 230 && movecontact
trigger4 = stateno = 500 && movecontact

; Super Combo - Level 2
;----------------------
[State -1, super combo 2]
type = ChangeState
value = 3102
triggerall = var(59) <= 0
triggerall = command = "super_combo_2" && power >= 2000
trigger1 = statetype != A && ctrl
trigger2 = stateno = 220 && movecontact
trigger3 = stateno = 230 && movecontact
trigger4 = stateno = 500 && movecontact

; Super Combo - Level 1
;----------------------
[State -1, super combo 1]
type = ChangeState
value = 3101
triggerall = var(59) <= 0
triggerall = command = "super_combo_1" && power >= 1000
trigger1 = statetype != A && ctrl
trigger2 = stateno = 220 && movecontact
trigger3 = stateno = 230 && movecontact
trigger4 = stateno = 500 && movecontact


;==========
; Specials
;==========

; Ko Ryu Kyaku A
;---------------
[State -1, ko ryu kyaku]
type = ChangeState
value = 1300
triggerall = var(59) <= 0
triggerall = command = "du_a"
trigger1 = statetype != A && ctrl
trigger2 = stateno = 40
trigger3 = stateno = 220 && movecontact
trigger4 = stateno = 230 && movecontact
trigger5 = stateno = 500 && movecontact

; Ko Ryu Kyaku B
;---------------
[State -1, high ko ryu kyaku]
type = ChangeState
value = 1350
triggerall = var(59) <= 0
triggerall = command = "du_b"
trigger1 = statetype != A && ctrl
trigger2 = stateno = 40
trigger3 = stateno = 220 && movecontact
trigger4 = stateno = 230 && movecontact
trigger5 = stateno = 500 && movecontact

; Ryu En Hou A (launcher)
;------------------------
[State -1, ryu en hou]
type = ChangeState
value = 1200
triggerall = var(59) <= 0
triggerall = command = "dp_x"
trigger1 = statetype != A && ctrl
trigger2 = stateno = 220 && movecontact
trigger3 = stateno = 230 && movecontact
trigger4 = stateno = 500 && movecontact

; Ryu En Hou B (launcher)
;------------------------
[State -1, ryu en hou]
type = ChangeState
value = 1250
triggerall = var(59) <= 0
triggerall = command = "dp_y"
trigger1 = statetype != A && ctrl
trigger2 = stateno = 220 && movecontact
trigger3 = stateno = 230 && movecontact
trigger4 = stateno = 500 && movecontact

; Ryu En Hou (1st punch)
;-----------------------
[State -1, ryu en hou]
type = ChangeState
value = 1210
triggerall = var(59) <= 0
triggerall = command = "qcf_x" || command = "qcf_y"
trigger1 = stateno = 1200 && time > 12
trigger2 = stateno = 1250 && time > 12

; Ryu En Hou (2nd punch)
;-----------------------
[State -1, ryu en hou]
type = ChangeState
value = 1220
triggerall = var(59) <= 0
triggerall = command = "x" || command = "y"
trigger1 = stateno = 1210 && time > 16

; Ryu En Hou (1st kick)
;----------------------
[State -1, ryu en hou]
type = ChangeState
value = 1260
triggerall = var(59) <= 0
triggerall = command = "qcf_a" || command = "qcf_b"
trigger1 = stateno = 1200 && time > 12
trigger2 = stateno = 1250 && time > 12

; Ryu En Hou (2nd kick)
;----------------------
[State -1, ryu en hou]
type = ChangeState
value = 1270
triggerall = var(59) <= 0
triggerall = command = "a" || command = "b"
trigger1 = stateno = 1260 && time > 16

; Ko Ryu Sho Zan
;---------------
[State -1, ko ryu sho zan]
type = ChangeState
value = 1100
triggerall = var(59) <= 0
triggerall = command = "qcf_x" || command = "qcf_y"
triggerall = numproj = 0
trigger1 = statetype != A && ctrl
trigger2 = stateno = 220 && movecontact
trigger3 = stateno = 230 && movecontact
trigger4 = stateno = 500 && movecontact

; Enretsu Ken
;------------
[State -1, enretsu ken]
type = ChangeState
value = 1000
triggerall = var(59) <= 0
triggerall = command = "hcb_x"
trigger1 = statetype != A && ctrl
trigger2 = stateno = 220 && movecontact
trigger3 = stateno = 230 && movecontact
trigger4 = stateno = 500 && movecontact

; Double Enretsu Ken
;-------------------
[State -1, double enretsu ken]
type = ChangeState
value = 1050
triggerall = var(59) <= 0
triggerall = command = "hcb_y"
trigger1 = statetype != A && ctrl
trigger2 = stateno = 220 && movecontact
trigger3 = stateno = 230 && movecontact
trigger4 = stateno = 500 && movecontact


;================
; Standard Moves
;================

; Run
;----
[State -1, run]
type = ChangeState
value = 100
triggerall = command = "FF"
trigger1 = statetype != A && ctrl

; Hop Back
;---------
[State -1, hop back]
type = ChangeState
value = 105
triggerall = command = "BB"
trigger1 = statetype != A && ctrl

; Roll Forward
;-------------
[State -1, roll fwd]
type = ChangeState
value = 950
triggerall = var(59) <= 0
triggerall = command = "x+a"
trigger1 = (StateType != A) && (ctrl) && (command != "holdback")
trigger2 = (power >= 1000) && (StateNo = 150 || StateNo = 152) && (command = "holdfwd")

; Roll Back
;----------
[State -1, roll back]
type = ChangeState
value = 960
triggerall = var(59) <= 0
triggerall = command = "x+a"
trigger1 = (StateType != A) && (ctrl) && (command = "holdback")
trigger2 = (power >= 1000) && (StateNo = 150 || StateNo = 152) && (command != "holdfwd")

; Taunt
;------
[State -1]
type = ChangeState
value = 195
triggerall = var(59) <= 0
trigger1 = command = "start"
trigger1 = StateType != A
trigger1 = ctrl



;========
; Throws
;========

; Ground Throw Back
;------------------
[State -1]
type = ChangeState
value = 700
triggerall = var(59) <= 0
triggerall = command = "b" && (command ="holdfwd" || command ="holdback")
trigger1 = StateType = S && ctrl
trigger1 = P2bodydist x <= 20 && P2StateType != A && P2MoveType != H

; Ground Throw Forward
;---------------------
[State -1]
type = ChangeState
value = 750
triggerall = var(59) <= 0
triggerall = command ="y" && (command ="holdfwd" || command ="holdback")
trigger1 = StateType = S && ctrl
trigger1 = P2bodydist x <= 20 && P2StateType != A && P2MoveType != H

; Air Throw
;----------
[State -1]
type = ChangeState
value = 800
triggerall = var(59) <= 0
triggerall = command = "y" && (command ="holdfwd" || command ="holdback")
trigger1 = StateType = A && ctrl
trigger1 = P2bodydist x <= 20 && P2StateType = A && P2MoveType != H



;===================
; Crouching Attacks
;===================

; Crouch Light Punch
;-------------------
[State -1, crouch light punch]
type = ChangeState
value = 300
triggerall = var(59) <= 0
triggerall = command = "x" && command = "holddown"
trigger1 = StateType != A && ctrl

; Crouch Light Kick
;------------------
[State -1, crouch light kick]
type = ChangeState
value = 310
triggerall = var(59) <= 0
triggerall = command = "a" && command = "holddown"
trigger1 = StateType != A && ctrl

; Crouch Fierce Punch
;--------------------
[State -1, crouch fierce punch]
type = ChangeState
value = 320
triggerall = var(59) <= 0
triggerall = command = "y" && command = "holddown"
trigger1 = StateType != A && ctrl

; Crouch Fierce Kick
;-------------------
[State -1, crouch fierce kick]
type = ChangeState
value = 330
triggerall = var(59) <= 0
triggerall = command = "b" && command = "holddown"
trigger1 = StateType != A && ctrl



;==================
; Standing Attacks
;==================

; Ground Knock-Down Attack
;-------------------------
[State -1, ground knock-down attack]
type = ChangeState
value = 510
triggerall = var(59) <= 0
triggerall = command = "y+b"
trigger1 = StateType != A && ctrl
trigger2 = (power >= 1000) && (StateNo = 150 || StateNo = 152)

; Overhead Punch
;---------------
[State -1, overhead punch]
type = ChangeState
value = 500
triggerall = var(59) <= 0
triggerall = command = "x" && command = "holdfwd"
trigger1 = StateType != A && ctrl

; Stand Light Punch
;------------------
[State -1, stand light punch]
type = ChangeState
value = 200
triggerall = var(59) <= 0
triggerall = command = "x"
trigger1 = StateType != A && ctrl

; Stand Light Kick
;-----------------
[State -1, stand light kick]
type = ChangeState
value = 210
triggerall = var(59) <= 0
triggerall = command = "a"
trigger1 = StateType != A && ctrl

; Stand Fierce Punch
;-------------------
[State -1, stand fierce punch]
type = ChangeState
value = 220
triggerall = var(59) <= 0
triggerall = command = "y"
trigger1 = StateType != A && ctrl

; Stand Fierce Kick
;------------------
[State -1, stand fierce kick]
type = ChangeState
value = 230
triggerall = var(59) <= 0
triggerall = command = "b"
trigger1 = StateType != A && ctrl



;================
; Aerial Attacks
;================

; Air Knock-Down Attack
;----------------------
[State -1, air knock-down attack]
type = ChangeState
value = 610
triggerall = var(59) <= 0
triggerall = command = "y+b"
trigger1 = StateType = A && ctrl

; Air Back Kick
;--------------
[State -1, air back kick]
type = ChangeState
value = 600
triggerall = var(59) <= 0
triggerall = command = "a" && command = "holdback"
triggerall = command != "holdup" && command != "holddown"
trigger1 = StateType = A && ctrl

; Air Light Punch
;----------------
[State -1, air light punch]
type = ChangeState
value = 400
triggerall = var(59) <= 0
triggerall = command = "x"
trigger1 = StateType = A && ctrl

; Air Light Kick
;---------------
[State -1, air light kick]
type = ChangeState
value = 410
triggerall = var(59) <= 0
triggerall = command = "a"
trigger1 = StateType = A && ctrl

; Air Fierce Punch
;-----------------
[State -1, air fierce punch]
type = ChangeState
value = 420
triggerall = var(59) <= 0
triggerall = command = "y"
trigger1 = StateType = A && ctrl

; Air Fierce Kick
;----------------
[State -1, air fierce kick]
type = ChangeState
value = 430
triggerall = var(59) <= 0
triggerall = command = "b"
trigger1 = StateType = A && ctrl
