; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.

[ReMap]
a = a
b = b
c = c
x = x
y = y
z = z
s = s

[Defaults]
Command.Time = 15
Command.Buffer.Time = 3

[Command]
name = "Ultimate Wild Smash"
command = ~F, D, B, F, a+b
time = 60

[Command]
name = "Ultimate Wild Smash"
command = ~D, B, D, F, a+b
time = 50

[Command]
name = "Gigaton Blow"
command = ~D, F, D, F, a
time = 35

[Command]
name = "Gigaton Blow"
command = ~D, F, D, F, ~a
time = 35

[Command]
name = "Gigaton Blow"
command = ~D, F, D, F, b
time = 35

[Command]
name = "Gigaton Blow"
command = ~D, F, D, F, ~b
time = 35

[Command]
name = "Gigaton Blow"
command = ~30$B, $F, $B, $F, a
time = 30

[Command]
name = "Gigaton Blow"
command = ~30$B, $F, $B, $F, ~a
time = 30

[Command]
name = "Gigaton Blow"
command = ~30$B, $F, $B, $F, b
time = 30

[Command]
name = "Gigaton Blow"
command = ~30$B, $F, $B, $F, ~b
time = 30

[Command]
name = "Crazy Buffalo"
command = ~D, F, D, F, x
time = 35

[Command]
name = "Crazy Buffalo"
command = ~D, F, D, F, ~x
time = 35

[Command]
name = "Crazy Buffalo"
command = ~D, F, D, F, y
time = 35

[Command]
name = "Crazy Buffalo"
command = ~D, F, D, F, ~y
time = 35

[Command]
name = "Crazy Buffalo"
command = ~30$B, $F, $B, $F, x
time = 30

[Command]
name = "Crazy Buffalo"
command = ~30$B, $F, $B, $F, ~x
time = 30

[Command]
name = "Crazy Buffalo"
command = ~30$B, $F, $B, $F, y
time = 30

[Command]
name = "Crazy Buffalo"
command = ~30$B, $F, $B, $F, ~y
time = 30

[Command]
name = "Wild Smash a"
command = ~D, F, a

[Command]
name = "Wild Smash a"
command = ~D, F, ~a

[Command]
name = "Wild Smash b"
command = ~D, F, b

[Command]
name = "Wild Smash b"
command = ~D, F, ~b

[Command]
name = "Dash Upper a"
command = ~D, B, a
time = 25

[Command]
name = "Dash Upper a"
command = ~D, B, ~a
time = 25

[Command]
name = "Dash Upper b"
command = ~D, B, b
time = 25

[Command]
name = "Dash Upper b"
command = ~D, B, ~b
time = 25

[Command]
name = "Dash Upper a"
command = ~30$B, F, a

[Command]
name = "Dash Upper a"
command = ~30$B, F, ~a

[Command]
name = "Dash Upper b"
command = ~30$B, F, b

[Command]
name = "Dash Upper b"
command = ~30$B, F, ~b

[Command]
name = "Dash Ground Upper a"
command = ~30$B, ~F, DF, a
time = 20

[Command]
name = "Dash Ground Upper a"
command = ~30$B, ~F, DF, ~a
time = 20

[Command]
name = "Dash Ground Upper b"
command = ~30$B, ~F, DF, b
time = 20

[Command]
name = "Dash Ground Upper b"
command = ~30$B, ~F, DF, ~b
time = 20

[Command]
name = "Dash Ground Upper a"
command = ~30$B, DF, a

[Command]
name = "Dash Ground Upper a"
command = ~30$B, DF, ~a

[Command]
name = "Dash Ground Upper b"
command = ~30$B, DF, b

[Command]
name = "Dash Ground Upper b"
command = ~30$B, DF, ~b

[Command]
name = "Buffalo Headbutt x"
command = ~D, F, x

[Command]
name = "Buffalo Headbutt x"
command = ~D, F, ~x

[Command]
name = "Buffalo Headbutt y"
command = ~D, F, y

[Command]
name = "Buffalo Headbutt y"
command = ~D, F, ~y

[Command]
name = "Dash Straight x"
command = ~30$B, ~F, F, x
time = 20

[Command]
name = "Dash Straight x"
command = ~30$B, ~F, F, ~x
time = 20

[Command]
name = "Dash Straight y"
command = ~30$B, ~F, F, y
time = 20

[Command]
name = "Dash Straight y"
command = ~30$B, ~F, F, ~y
time = 20

[Command]
name = "Dash Straight x"
command = ~30$B, F, x

[Command]
name = "Dash Straight x"
command = ~30$B, F, ~x

[Command]
name = "Dash Straight y"
command = ~30$B, F, y

[Command]
name = "Dash Straight y"
command = ~30$B, F, ~y

[Command]
name = "Dash Ground Straight x"
command = ~30$B, ~F, DF, x
time = 20

[Command]
name = "Dash Ground Straight x"
command = ~30$B, ~F, DF, ~x
time = 20

[Command]
name = "Dash Ground Straight y"
command = ~30$B, ~F, DF, y
time = 20

[Command]
name = "Dash Ground Straight y"
command = ~30$B, ~F, DF, ~y
time = 20

[Command]
name = "Dash Ground Straight x"
command = ~30$B, DF, x

[Command]
name = "Dash Ground Straight x"
command = ~30$B, DF, ~x

[Command]
name = "Dash Ground Straight y"
command = ~30$B, DF, y

[Command]
name = "Dash Ground Straight y"
command = ~30$B, DF, ~y

; Double Tap
[Command]
name = "FF"; Required
command = ~F, F
time = 10

[Command]
name = "BB"; Required
command = B, B
time = 10

[Command]
name = "High Jump"
command = $D, $U
time = 10

; 2/3 Button Combination
[Command]
name = "recovery"; Required
command = a+x
time = 1

[Command]
name = "Head Bomber"
command = a+x
time = 1

[Command]
name = "Guard Cancel Frontstep"
command = a+y
time = 1

[Command]
name = "Guard Cancel Attack"
command = b+y
time = 1

[Command]
name = "recovery"; Required
command = x+y
time = 1

[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "start"
command = s
time = 1

[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "holda"
command = /a
time = 1

[Command]
name = "holdb"
command = /b
time = 1

[Command]
name = "holdx"
command = /x
time = 1

[Command]
name = "holdy"
command = /y
time = 1

[StateDef -1]
[State -1, Ultimate Wild Smash]
Type = ChangeState
TriggerAll = !Var(58) && life <= lifemax / 2 && Command = "Ultimate Wild Smash"
Trigger1 = StateType != A && (Ctrl || stateno = 40 || stateno = 100)
trigger2 = var(5)
trigger3 = var(7)
value = 3010

[State -1, Gigaton Blow]
Type = ChangeState
TriggerAll = (Power >= 1000 || (var(6) = 1 && palno < 7)) && Command = "Gigaton Blow"
Trigger1 = StateType != A && (Ctrl || stateno = 100)
trigger2 = var(5)
trigger3 = var(7)
value = 3000

[State -1, Crazy Buffalo]
Type = ChangeState
TriggerAll = (Power >= 1000 || (var(6) = 1 && palno < 7)) && Command = "Crazy Buffalo"
Trigger1 = StateType != A && (ctrl || stateno = 100)
trigger2 = var(5)
trigger3 = var(7)
value = 3020

[state -1, reset after Anywhere Cancel from Turn Punch]
type = varset
trigger1 = prevstateno = 1600 && numhelper(6000)
var(10) = 0

[State -1, Turn Punch]
Type = ChangeState
triggerall = var(10) && !numhelper(6005) && stateno != 1600
Trigger1 = StateType != A && (ctrl || stateno = 100)
trigger2 = var(5)
trigger3 = var(7)
trigger4 = var(10) := 0
value = 1600

[State -1, Wild Smash]
Type = ChangeState
TriggerAll = (Command = "Wild Smash a" || Command = "Wild Smash b")
Trigger1 = StateType != A && (Ctrl || stateno = 40 || stateno = 100)
trigger2 = var(5)
trigger3 = var(7) && (stateno != [1400, 1410])
value = ifelse(command = "Wild Smash a", 1400, 1410)

[State -1, Dash Ground Uper]
Type = ChangeState
TriggerAll = (Command = "Dash Ground Upper a" || Command = "Dash Ground Upper b")
Trigger1 = StateType != A && (Ctrl || stateno = 100)
trigger2 = var(5)
trigger3 = var(7) && (stateno != [1300, 1310])
value = ifelse(command = "Dash Ground Upper a", 1300, 1310)

[State -1, Dash Uper]
Type = ChangeState
TriggerAll = (Command = "Dash Upper a" || Command = "Dash Upper b")
Trigger1 = StateType != A && (Ctrl || stateno = 100)
trigger2 = var(5)
trigger3 = var(7) && (stateno != [1100, 1110])
value = ifelse(command = "Dash Upper a", 1100, 1110)

[State -1, Buffalo Headbutt]
Type = ChangeState
TriggerAll = (Command = "Buffalo Headbutt x" || Command = "Buffalo Headbutt y")
Trigger1 = StateType != A && (Ctrl || stateno = 40 || stateno = 100)
trigger2 = var(5)
trigger3 = var(7) && (stateno != [1500, 1510])
value = ifelse(command = "Buffalo Headbutt x", 1500, 1510)

[State -1, Dash Ground Straight]
Type = ChangeState
TriggerAll = (Command = "Dash Ground Straight x" || Command = "Dash Ground Straight y")
Trigger1 = StateType != A && (Ctrl || stateno = 100)
trigger2 = var(5)
trigger3 = var(7) && (stateno != [1200, 1210])
value = ifelse(command = "Dash Ground Straight x", 1200, 1210)

[State -1, Dash Straight]
Type = ChangeState
TriggerAll = (Command = "Dash Straight x" || Command = "Dash Straight y")
Trigger1 = StateType != A && (Ctrl || stateno = 100)
trigger2 = var(5)
trigger3 = var(7) && (stateno != [1000, 1010])
value = ifelse(command = "Dash Straight x", 1000, 1010)

[State -1, Run Fwd]
type = ChangeState
triggerall = command = "FF" && stateno != 160
trigger1 = statetype = S && ctrl
value = 100

[State -1, Run Back]
type = ChangeState
triggerall = command = "BB"
trigger1 = statetype = S && ctrl
value = 105

[State -1, Guard Cancel Frontstep]
type = Changestate
triggerall = (stateno = 150 || stateno = 152) && alive
trigger1 = (power >= 606 || var(6) = 1) && command = "Guard Cancel Frontstep"
trigger2 = (power >= 212 || var(6) = 1) && command = "FF"
value = 160
ignorehitpause = 1

[State -1, Guard Cancel Attack]
type = ChangeState
triggerall = command = "Guard Cancel Attack" && (power >= 1000 || var(6) = 1) && alive
trigger1 = stateno = 150 || stateno = 152
value = 165
ignorehitpause = 1

[State -1, Head Bomber]
type = ChangeState
triggerall = command = "Head Bomber"
trigger1 = statetype = s && (ctrl || stateno = 100)
value = 800

[State -1, Throw]
type = ChangeState
triggerall = command = "Guard Cancel Attack"
trigger1 = statetype = s && (ctrl || stateno = 100)
value = 850

[State -1, Jab]
Type = ChangeState
TriggerAll = Command = "x" && Command != "holddown"
Trigger1 = StateType = S && (Ctrl || stateno = 100)
trigger2 = stateno = 200 && animelem = 4, > 0
trigger3 = stateno = 230 && animelem = 4, > 0
trigger4 = stateno = 400 && animelem = 4, > 0
value = 200

[State -1, Strong]
Type = ChangeState
TriggerAll = Command = "y" && Command != "holddown"
Trigger1 = StateType = S && (Ctrl || stateno = 100)
value = ifelse(p2bodydist x > 21, 310, 210)

[State -1, Short]
Type = ChangeState
TriggerAll = Command = "a" && Command != "holddown"
Trigger1 = StateType = S && (Ctrl || stateno = 100)
trigger2 = stateno = 200 && animelem = 4, > 0
trigger3 = stateno = 400 && animelem = 4, > 0
value = 230

[State -1, Forward]
Type = ChangeState
TriggerAll = Command = "b" && Command != "holddown"
Trigger1 = StateType = S && (Ctrl || stateno = 100)
value = ifelse(p2bodydist x > 30, 340, 240)

[State -1, Taunt]
type = ChangeState
triggerall = command = "start"
trigger1 = statetype = S && (ctrl || stateno = 100)
value = 195

[State -1, c Jab]
Type = ChangeState
TriggerAll = Command = "x" && Command = "holddown"
Trigger1 = StateType = C && Ctrl
trigger2 = stateno = 200 && animelem = 4, > 0
trigger3 = stateno = 230 && animelem = 4, > 0
trigger4 = stateno = 400 && animelem = 4, > 0
value = 400

[State -1, c Strong]
Type = ChangeState
TriggerAll = Command = "y" && Command = "holddown"
Trigger1 = StateType = C && Ctrl
value = 410

[State -1, c Short]
Type = ChangeState
TriggerAll = Command = "holda" && Command = "holddown"
Trigger1 = StateType = C && Ctrl
trigger2 = stateno = 200 && animelem = 4, > 0
trigger3 = stateno = 400 && animelem = 4, > 0
value = 430

[State -1, c Forward]
Type = ChangeState
TriggerAll = command = "b" && Command = "holddown"
Trigger1 = StateType = C && Ctrl
value = 440

[State -1, a Jab]
Type = ChangeState
TriggerAll = command = "x"
Trigger1 = StateType = A && Ctrl
trigger2 = (stateno = [1500, 1510]) && (animelem = 7, > 0 || movecontact)
Value = 600

[State -1, a Strong]
Type = ChangeState
TriggerAll = Command = "y"
Trigger1 = StateType = A && Ctrl
trigger2 = (stateno = [1500, 1510]) && (animelem = 7, > 0 || movecontact)
Value = 610

[State -1, a Short]
Type = ChangeState
TriggerAll = Command = "a"
Trigger1 = StateType = A && Ctrl
trigger2 = (stateno = [1500, 1510]) && (animelem = 7, > 0 || movecontact)
Value = 630

[State -1, a Forward]
Type = ChangeState
TriggerAll = Command = "b"
Trigger1 = StateType = A && Ctrl
trigger2 = (stateno = [1500, 1510]) && (animelem = 7, > 0 || movecontact)
Value = 640
