; 1. Command definition

;-| Super Motions |-----------------------------------------------------

; Slasher Combo
[Command]
name = "slasher"
command = ~D, F, D, F, y
time = 35

; Ultimate Stab
[Command]
name = "ultimate"
command = ~D, F, D, F, x
time = 35

;-| Special Motions |------------------------------------------------------

; Big Slash
[Command]
name = "QCB_x"
command = ~D, DB, B, x

; Rapid Stabs
[Command]
name = "QCB_y"
command = ~D, DB, B, y

; Speed Dash
[Command]
name = "QCB_a"
command = ~D, DB, B, a

; Upwards Slash
[Command]
name = "UpSl_x"
command = ~F, D, DF, x

; Upwards Slash 2
[Command]
name = "UpSl_y"
command = ~F, D, DF, y

; Ranged Slash
[Command]
name = "QCF_x"
command = ~D, DF, F, x

; Ranged Slash 2
[Command]
name = "QCF_y"
command = ~D, DF, F, y

;-| Double Tap |-----------------------------------------------------------

[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------

[Command]
name = "unguardable"
command = /y
time = 1

[Command]
name = "SpecialAttack"
command = /y+a
time = 1

[Command]
name = "dfB"
command = DF, B

[Command]
name = "holdfwdC"
command = F, a

[Command]
name = "recovery";Required (do not remove)
command = b
time = 1

;-| Dir + Button |---------------------------------------------------------

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------

[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry

[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------
; Slasher Combo
[State -1, Slasher Combo]
type = ChangeState
value = 3000
triggerall = command = "slasher"
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = Power = 3000 || Life < 201
trigger1 = ctrl
trigger2 = stateno = 235 || stateno = 306 || stateno = 210 || stateno = 225 || stateno = 200 || stateno = 220
trigger2 = ctrl = 0 && MoveHit
trigger3 = stateno = 1200 && ctrl = 0

;---------------------------------------------------------------------------
; Ultimate Stab
[State -1, Ultimate Stab]
type = ChangeState
value = 3200
triggerall = command = "ultimate"
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = Power = 3000 && Life < 201
trigger1 = ctrl
trigger2 = stateno = 235 || stateno = 200 || stateno = 210 || stateno = 220
trigger2 = MoveHit && ctrl = 0
trigger3 = stateno = 1200 && ctrl = 0

;===========================================================================
;---------------------------------------------------------------------------
; Big Slash
[State -1, Big Slash]
type = ChangeState
value = 1000
triggerall = command = "QCB_x"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = stateno = 235 || stateno = 250 || stateno = 210 || stateno = 225 || stateno = 200 || stateno = 220
trigger2 = ctrl = 0 && MoveHit
trigger3 = stateno = 1200 && ctrl = 0

;---------------------------------------------------------------------------
; Rapid Stabs
[State -1, Rapid Stabs]
type = ChangeState
value = 1100
triggerall = command = "QCB_y"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = stateno = 235 || stateno = 250 || stateno = 210 || stateno = 225 || stateno = 200 || stateno = 220
trigger2 = ctrl = 0 && MoveHit
trigger3 = stateno = 1200 && ctrl = 0

;---------------------------------------------------------------------------
; Speed Dash
[State -1, Speed Dash]
type = ChangeState
value = 1200
triggerall = command = "QCB_a"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = stateno = 235 || stateno = 250 || stateno = 210 || stateno = 225 || stateno = 200 || stateno = 220
trigger2 = ctrl = 0 && MoveHit
trigger3 = stateno = 1200 && ctrl = 0

;---------------------------------------------------------------------------
; Upwards Slash
[State -1, Upwards Slash]
type = ChangeState
value = 1300
triggerall = command = "UpSl_x"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = stateno = 235 || stateno = 250 || stateno = 210 || stateno = 225 || stateno = 200 || stateno = 220
trigger2 = ctrl = 0 && MoveHit
trigger3 = stateno = 1200 && ctrl = 0

;---------------------------------------------------------------------------
; Upwards Slash 2
[State -1, Upwards Slash 2]
type = ChangeState
value = 1350
triggerall = command = "UpSl_y"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = stateno = 235 || stateno = 250 || stateno = 210 || stateno = 225 || stateno = 200 || stateno = 220
trigger2 = ctrl = 0 && MoveHit
trigger3 = stateno = 1200 && ctrl = 0

;---------------------------------------------------------------------------
; Ranged Slash
[State -1, Ranged Slash]
type = ChangeState
value = 1400
triggerall = command = "QCF_x"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = stateno = 235 || stateno = 250 || stateno = 210 || stateno = 225 || stateno = 200 || stateno = 220
trigger2 = ctrl = 0 && MoveHit
trigger3 = stateno = 1200 && ctrl = 0

;---------------------------------------------------------------------------
; Ranged Slash 2
[State -1, Ranged Slash 2]
type = ChangeState
value = 1450
triggerall = command = "QCF_y"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = stateno = 235 || stateno = 250 || stateno = 210 || stateno = 225 || stateno = 200 || stateno = 220
trigger2 = ctrl = 0 && MoveHit
trigger3 = stateno = 1200 && ctrl = 0

;===========================================================================
;---------------------------------------------------------------------------
; Special Attack
[State -1, Special Attack]
type = ChangeState
value = 300
triggerall = command = "y" && command = "a"
triggerall = command != "holddown" && statetype = S
trigger1 = ctrl
trigger2 = stateno = 235 && MoveHit && ctrl = 0

;---------------------------------------------------------------------------
; Throw
[State -1, Throw]
type = ChangeState
value = 800
triggerall = command = "a" && command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = p2movetype != H
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype = S
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
; Run Slash
[State -1, Run Slash]
type = ChangeState
value = 250
triggerall = command = "x" || command = "y"
triggerall = stateno = 100
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 206
triggerall = command = "x"
triggerall = command = "holdback"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 235 && MoveHit
trigger2 = statetype = S
trigger2 = ctrl = 0

;---------------------------------------------------------------------------
;Stand Light Slash
[State -1, Stand Light Slash]
type = ChangeState
value = 200
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = P2StateType = S
trigger2 = stateno = 235 && MoveHit
trigger2 = statetype = S
trigger2 = ctrl = 0

;---------------------------------------------------------------------------
;Stand Strong Slash 2
[State -1, Stand Strong Slash 2]
type = ChangeState
value = 215
triggerall = command = "y"
triggerall = command = "holdfwd"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 235 && MoveHit
trigger2 = statetype = C
trigger2 = ctrl = 0

;---------------------------------------------------------------------------
;Stand Strong Slash
[State -1, Stand Strong Slash]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = P2StateType = S
trigger2 = stateno = 235 && MoveHit
trigger2 = statetype = S
trigger2 = ctrl = 0

;---------------------------------------------------------------------------
; Second Throw
[State -1, Second Throw]
type = ChangeState
value = 1220
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = stateno = 1200
trigger1 = ctrl = 0

;---------------------------------------------------------------------------
;Stand Strong Kick
[State -1, Stand Strong Kick]
type = ChangeState
value = 225
triggerall = command = "a"
triggerall = command = "holdfwd"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 235 && MoveHit
trigger2 = statetype = C
trigger2 = ctrl = 0

;---------------------------------------------------------------------------
;Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = 220
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl
trigger2 = P2StateType = S
trigger2 = stateno = 235 && MoveHit
trigger2 = ctrl = 0
trigger3 = stateno = 1000 && MoveHit
trigger3 = ctrl = 0

;---------------------------------------------------------------------------
; Stand Repel Sequence
[State -1, Stand Repel Sequence]
type = ChangeState
value = 240
triggerall = P2StateType = S
triggerall = command = "b"
trigger1 = stateno = 235 && MoveHit
trigger1 = statetype = S
trigger1 = ctrl = 0
trigger2 = stateno = 435 && MoveHit
trigger2 = statetype = C
trigger2 = ctrl = 0

;---------------------------------------------------------------------------
; Stand Repel
[State -1, Stand Repel]
type = ChangeState
value = 235
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = P2MoveType = A
trigger1 = P2Dist X < 100
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Stand Repel (try)
[State -1, Stand Repel (try)]
type = ChangeState
value = 230
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = P2MoveType != A
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = P2Dist X > 99
trigger2 = statetype = S
trigger2 = ctrl

;---------------------------------------------------------------------------
;Crouching Strong Kick
[State -1, Crouching Strong Kick]
type = ChangeState
value = 425
triggerall = command = "holdfwd"
triggerall = command = "holddown"
triggerall = statetype = C
triggerall = ctrl
trigger1 = command = "x" && Vel X > 2
trigger2 = command = "y" && Vel X > 2
trigger3 = command = "a"

;---------------------------------------------------------------------------
;Crouching Light Slash
[State -1, Crouching Light Slash]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 435 && MoveHit
trigger2 = statetype = C
trigger2 = ctrl = 0

;---------------------------------------------------------------------------
;Crouching Strong Slash
[State -1, Crouching Strong Slash]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 435 && MoveHit
trigger2 = statetype = C
trigger2 = ctrl = 0

;---------------------------------------------------------------------------
;Crouching Light Kick
[State -1, Crouching Light Kick]
type = ChangeState
value = 420
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 435 && MoveHit
trigger2 = statetype = C
trigger2 = ctrl = 0

;---------------------------------------------------------------------------
; Crouching Repel
[State -1, Crouching Repel]
type = ChangeState
value = 435
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = P2MoveType = A
trigger1 = P2Dist X < 100
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
; Crouching Repel (try)
[State -1, Crouching Repel (try)]
type = ChangeState
value = 430
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = P2MoveType != A
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = P2Dist X > 99
trigger2 = statetype = C
trigger2 = ctrl

;---------------------------------------------------------------------------
; Jump Light Slash
[State -1, Jump Light Slash]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Strong Slash
[State -1, Jump Strong Slash]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Kick
[State -1, Jump Kick]
type = ChangeState
value = 620
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Repel
[State -1, Jump Repel]
type = ChangeState
value = 635
triggerall = command = "b"
trigger1 = P2MoveType = A
trigger1 = P2Dist X < 100
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Jump Repel (try)
[State -1, Jump Repel (try)]
type = ChangeState
value = 630
triggerall = command = "b"
trigger1 = P2MoveType != A
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = P2Dist X > 99
trigger2 = statetype = A
trigger2 = ctrl
