; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = "some_name"
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /F, a    ;hold fwd while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;               command = ~30
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their engine.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;-| CPU Shortcuts |--------------------------------------------------------

;-| Super Motions |--------------------------------------------------------

[Command]
name = "FDBz"
command = ~F,D,B,z
time = 30

[Command]
name = "DBDBx"
command = ~D,B,D,B,x
time = 30

[Command]
name = "DBDBa"
command = ~D,B,D,B,a
time = 30

[Command]
name = "DFDFx"
command = ~D,F,D,DF,F,y
time = 40

[Command]
name = "DFDFa"
command = ~D,F,D,DF,F,x
time = 40

[Command]
name = "DDFx"
command = D,B,D,B,y
time = 40

[Command]
name = "DDFa"
command = ~D,B,D,B,x
time = 40

[Command]
name = "DBDFy"
command = ~D,F,D,DF,F,a
time = 40

[Command]
name = "DBDFb"
command = ~D,F,D,DF,F,b
time = 40

[Command]
name = "DBFy"
command = ~D,B,D,F,y
time = 40

[Command]
name = "DBFb"
command = ~D,B,D,F,b
time = 40

;-| Special Motions |------------------------------------------------------
[Command]
name = "JBy"
command = /B,y

[Command]
name = "FDFx"
command = ~F,D,DF,x
time = 20

[Command]
name = "FDFa"
command = ~F,D,DF,a
time = 20


[Command]
name = "DBy"
command = ~D,B,y
time = 20

[Command]
name = "DBb"
command = ~D,B,b
time = 20

[Command]
name = "DBx"
command = ~D,B,x
time = 20

[Command]
name = "DBa"
command = ~D,B,a
time = 20

[Command]
name = "BDFa"
command = ~B,D,F,a
time = 20

[Command]
name = "BDFb"
command = ~B,D,F,b
time = 20

[Command]
name = "BDFy"
command = ~B,D,F,y
time = 20

[Command]
name = "BDFx"
command = ~B,D,F,x
time = 20

[Command]
name = "FDFx"
command = ~F,D,DF,x
time = 20

[Command]
name = "BDFx"
command = ~B,D,F,x
time = 20

[Command]
name = "FDBx"
command = ~F,D.DB,B,x
time = 20

[Command]
name = "FDBa"
command = ~F,D.DB,B,a
time = 20

[Command]
name = "FDBy"
command = ~F,D.DB,B,y
time = 20

[Command]
name = "FDBb"
command = ~F,D.DB,B,b
time = 20


[Command]
name = "BFx"
command = ~B,F, x
time = 10

[Command]
name = "BFa"
command = ~B,F, a
time = 10

[Command]
name = "BFxs"
command = ~B,F, x

[Command]
name = "BFas"
command = ~B,F, a

[Command]
name = "DUx"
command = ~D,U, x
time = 10

[Command]
name = "DUa"
command = ~D,U, a
time = 10

[Command]
name = "DUxs"
command = ~D,U, x

[Command]
name = "DUas"
command = ~D,U, a

[Command]
name = "DUy"
command = ~D,U, y
time = 10

[Command]
name = "DUb"
command = ~D,U, b
time = 10

[Command]
name = "DUys"
command = ~D,U, y

[Command]
name = "DUbs"
command = ~D,U, b

[Command]
name = "DUxj"
command = ~D,U, x
time = 10

[Command]
name = "DUaj"
command = ~D,U, a
time = 10

[Command]
name = "DUyj"
command = ~D,U, y
time = 10

[Command]
name = "DUbj"
command = ~D,U, b
time = 10

[Command]
name = "holddowns";Required (do not remove)
command = /D
time = 1

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF";Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB";Required (do not remove)
command = B, B
time = 10

[Command]
name = "longjump"
command = D, $U
time = 18

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = a+b
time = 1

[Command]
name = "ab"
command = a+b
time = 1

[Command]
name = "xa"
command = x+a
time = 1

[Command]
name = "hold_c"
command = /c
time = 7

[Command]
name = "hold_b"
command = /b
time = 7

[Command]
name = "hold_x"
command = /x
time = 7

[Command]
name = "hold_y"
command = /y
time = 7

[Command]
name = "hold_back"
command = /B
time = 7

[Command]
name = "hold_a"
command = /a
time = 7

[Command]
name = "hold_z"
command = /z
time = 7

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "fwd_a"
command = /F,a
time = 1

[Command]
name = "fwd_b"
command = /F,b
time = 1

[Command]
name = "fwd_c"
command = /F,c
time = 1

[Command]
name = "downfwd_a"
command = /DF,a
time = 1

[Command]
name = "downfwd_b"
command = /DF,b
time = 1

[Command]
name = "back_a"
command = /B,a
time = 1

[Command]
name = "back_b"
command = /B,b
time = 1

[Command]
name = "back_c"
command = /B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_ab"
command = /F, a+b
time = 1

[Command]
name = "back_ab"
command = /B, a+b
time = 1

[Command]
name = "xy"
command = x+y
time = 1

[Command]
name = "yz"
command = y+z
time = 1

[Command]
name = "yb"
command = y+b
time = 1

[Command]
name = "xa"
command = x+a
time = 1

[Command]
name = "Fxy"
command = /F,x+y
time = 1

[Command]
name = "Bxy"
command = /B,x+y
time = 1

[Command]
name = "Fz"
command = /F,z
time = 1

[Command]
name = "Bz"
command = /B,z
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "B"
command = B
time = 1

[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 0

[Command]
name = "hold_s"
command = /s
time = 0

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "BD";Required (do not remove)
command = /$BD
time = 1

[Command]
name = "FD";Required (do not remove)
command = /$FD
time = 1

[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup";Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1]                  ;Don't change this
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = "command_name"
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;==========================================================================

;---------------------------------------------------------------------------
;DBxSa
[State -1]
type = ChangeState
value = 8160
triggerall = Var(18) = 8
triggerall = command = "DBx"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = stateno != 8160
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;DBaSa
[State -1]
type = ChangeState
value = 8160
triggerall = Var(18) = 8
triggerall = command = "DBa"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = stateno != 8160
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;DBxSb
[State -1]
type = ChangeState
value = 8165
triggerall = Var(18) = 8
triggerall = command = "DBx"
triggerall = statetype != A
trigger1 = stateno = 8160
trigger1 = time >= 21
trigger2 = stateno = 8160
trigger2 = movecontact = 1
trigger3 = NumExplod(900) = 1
trigger3 = stateno != 8165
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
;DBaSb
[State -1]
type = ChangeState
value = 8165
triggerall = Var(18) = 8
triggerall = command = "DBa"
triggerall = statetype != A
trigger1 = stateno = 8160
trigger1 = time >= 21
trigger2 = stateno = 8160
trigger2 = movecontact = 1
trigger3 = NumExplod(900) = 1
trigger3 = stateno != 8165
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
;DBySc
[State -1]
type = ChangeState
value = 8150
triggerall = Var(18) = 8
triggerall = NumHelper(8026) >= 1
triggerall = NumHelper(8027) = 0
triggerall = command = "DBy"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084
trigger25 = stateno = 8165
trigger25 = time >= 19
trigger26 = stateno = 8165
trigger26 = movecontact = 1

;---------------------------------------------------------------------------
;DBbSc
[State -1]
type = ChangeState
value = 8152
triggerall = Var(18) = 8
triggerall = NumHelper(8026) >= 1
triggerall = NumHelper(8027) = 0
triggerall = command = "DBb"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084
trigger25 = stateno = 8165
trigger25 = time >= 19
trigger26 = stateno = 8165
trigger26 = movecontact = 1


;---------------------------------------------------------------------------
;FDBySb
[State -1]
type = ChangeState
value = 81401
triggerall = Var(18) = 8
triggerall = NumHelper(8027) >= 1
triggerall = command = "FDBy"
triggerall = statetype != A
trigger1 = stateno = 515
trigger1 = movehit = 1

;---------------------------------------------------------------------------
;FDBbSb
[State -1]
type = ChangeState
value = 81401
triggerall = Var(18) = 8
triggerall = NumHelper(8027) >= 1
triggerall = command = "FDBb"
triggerall = statetype != A
trigger1 = stateno = 515
trigger1 = movehit = 1

;---------------------------------------------------------------------------
;FDBySb
[State -1]
type = ChangeState
value = 8140
triggerall = Var(18) = 8
triggerall = NumHelper(8027) >= 1
triggerall = command = "FDBy"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;FDBbSb
[State -1]
type = ChangeState
value = 8140
triggerall = Var(18) = 8
triggerall = NumHelper(8027) >= 1
triggerall = command = "FDBb"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;DBySaH
[State -1]
type = ChangeState
value = 81306
triggerall = Var(18) = 8
triggerall = NumHelper(8025) >= 1
triggerall = NumHelper(8026) = 0
triggerall = NumHelper(8027) = 0
triggerall = command = "DBy"
triggerall = statetype != A
trigger1 = stateno = 8165
trigger1 = time >= 19
trigger2 = stateno = 8165
trigger2 = movecontact = 1

;---------------------------------------------------------------------------
;DBbSaH
[State -1]
type = ChangeState
value = 81307
triggerall = Var(18) = 8
triggerall = NumHelper(8025) >= 1
triggerall = NumHelper(8026) = 0
triggerall = NumHelper(8027) = 0
triggerall = command = "DBb"
triggerall = statetype != A
trigger1 = stateno = 8165
trigger1 = time >= 19
trigger2 = stateno = 8165
trigger2 = movecontact = 1

;---------------------------------------------------------------------------
;DBySa
[State -1]
type = ChangeState
value = 8130
triggerall = Var(18) = 8
triggerall = NumHelper(8025) >= 1
triggerall = NumHelper(8026) = 0
triggerall = NumHelper(8027) = 0
triggerall = command = "DBy"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;DBbSa
[State -1]
type = ChangeState
value = 81305
triggerall = Var(18) = 8
triggerall = NumHelper(8025) >= 1
triggerall = NumHelper(8026) = 0
triggerall = NumHelper(8027) = 0
triggerall = command = "DBb"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;JBDFx
[State -1]
type = ChangeState
value = 8110
triggerall = Var(18) = 8
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = command = "BDFx"
triggerall = power >= 1000
triggerall = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 517
trigger2 = movecontact = 1
trigger3 = stateno = 518
trigger3 = movecontact = 1
trigger4 = stateno = 526
trigger4 = movecontact = 1
trigger5 = stateno = 527
trigger5 = movecontact = 1
trigger6 = stateno = 5301
trigger6 = movecontact = 1
trigger7 = stateno = 5302
trigger7 = movecontact = 1

;---------------------------------------------------------------------------
;JBDFxCM
[State -1]
type = ChangeState
value = 81109
triggerall = Var(18) = 8
triggerall = NumExplod(910) = 1
triggerall = command = "BDFx"
triggerall = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 517
trigger2 = movecontact = 1
trigger3 = stateno = 518
trigger3 = movecontact = 1
trigger4 = stateno = 526
trigger4 = movecontact = 1
trigger5 = stateno = 527
trigger5 = movecontact = 1
trigger6 = stateno = 5301
trigger6 = movecontact = 1
trigger7 = stateno = 5302
trigger7 = movecontact = 1
trigger8 = stateno = 8090
trigger8 = time >= 19
trigger9 = stateno = 8091

;---------------------------------------------------------------------------
;JBDFa
[State -1]
type = ChangeState
value = 8120
triggerall = Var(18) = 8
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = command = "BDFa"
triggerall = power >= 2000
triggerall = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 517
trigger2 = movecontact = 1
trigger3 = stateno = 518
trigger3 = movecontact = 1
trigger4 = stateno = 526
trigger4 = movecontact = 1
trigger5 = stateno = 527
trigger5 = movecontact = 1
trigger6 = stateno = 5301
trigger6 = movecontact = 1
trigger7 = stateno = 5302
trigger7 = movecontact = 1


;---------------------------------------------------------------------------
;JDBx
[State -1]
type = ChangeState
value = 8090
triggerall = Var(18) = 8
triggerall = command = "DBx"
triggerall = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 517
trigger2 = movecontact = 1
trigger3 = stateno = 518
trigger3 = movecontact = 1
trigger4 = stateno = 526
trigger4 = movecontact = 1
trigger5 = stateno = 527
trigger5 = movecontact = 1
trigger6 = stateno = 5301
trigger6 = movecontact = 1
trigger7 = stateno = 5302
trigger7 = movecontact = 1
trigger8 = NumExplod(900) = 1
trigger8 = movecontact = 1

;---------------------------------------------------------------------------
;JDBa
[State -1]
type = ChangeState
value = 8090
triggerall = Var(18) = 8
triggerall = command = "DBa"
triggerall = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 517
trigger2 = movecontact = 1
trigger3 = stateno = 518
trigger3 = movecontact = 1
trigger4 = stateno = 526
trigger4 = movecontact = 1
trigger5 = stateno = 527
trigger5 = movecontact = 1
trigger6 = stateno = 5301
trigger6 = movecontact = 1
trigger7 = stateno = 5302
trigger7 = movecontact = 1
trigger8 = NumExplod(900) = 1
trigger8 = movecontact = 1

;---------------------------------------------------------------------------
;DFDFxS
[State -1]
type = ChangeState
value = 8050
triggerall = Var(18) = 8
triggerall = command = "DFDFx"
triggerall = power >= 1000
triggerall = NumHelper(80698) = 0
triggerall = NumHelper(80455) >= 1
triggerall = NumHelper(8041) = 0
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084
;---------------------------------------------------------------------------
;DFDFaS
[State -1]
type = ChangeState
value = 8050
triggerall = Var(18) = 8
triggerall = command = "DFDFa"
triggerall = power >= 1000
triggerall = NumHelper(80698) = 0
triggerall = NumHelper(80455) >= 1
triggerall = NumHelper(8041) = 0
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;BBL
[State -1]
type = ChangeState
value = 8045
triggerall = Var(18) = 8
triggerall = NumHelper(8027) >= 1
triggerall = NumHelper(8041) = 0
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = power >= 1000
triggerall = command = "DFDFx"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;BBL
[State -1]
type = ChangeState
value = 8046
triggerall = Var(18) = 8
triggerall = NumHelper(8027) >= 1
triggerall = NumHelper(8041) = 0
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = power >= 2000
triggerall = command = "DFDFa"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;FDBxHBL
[State -1]
type = ChangeState
value = 8028
triggerall = Var(18) = 8
triggerall = NumHelper(81319) = 0
triggerall = NumHelper(8027) = 0
triggerall = NumHelper(80455) = 0
triggerall = command = "BDFx"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;FDBaHBL
[State -1]
type = ChangeState
value = 8041
triggerall = Var(18) = 8
triggerall = NumHelper(8025) >= 1
triggerall = command = "BDFa"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;FDBaHBL
[State -1]
type = ChangeState
value = 8041
triggerall = Var(18) = 8
triggerall = NumHelper(8026) >= 1
triggerall = command = "BDFa"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;FDBaHBL
[State -1]
type = ChangeState
value = 8041
triggerall = Var(18) = 8
triggerall = NumHelper(8027) >= 1
triggerall = command = "BDFa"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;FDBaHBL
[State -1]
type = ChangeState
value = 8041
triggerall = Var(18) = 8
triggerall = NumHelper(80698) = 0
triggerall = NumHelper(80455) >= 1
triggerall = command = "BDFa"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;BDFb
[State -1]
type = ChangeState
value = 8004
triggerall = Var(18) = 8
triggerall = command = "BDFb"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;BDFy
[State -1]
type = ChangeState
value = 8004
triggerall = Var(18) = 8
triggerall = command = "BDFy"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;BDFx
[State -1]
type = ChangeState
value = 8020
triggerall = Var(18) = 8
triggerall = command = "FDFx"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;BDFa
[State -1]
type = ChangeState
value = 8020
triggerall = Var(18) = 8
triggerall = command = "FDFa"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = NumExplod(900) = 1
trigger21 = movecontact = 1
trigger22 = stateno = 8002
trigger22 = movecontact = 1
trigger23 = stateno = 8003
trigger23 = movecontact = 1
trigger24 = stateno = 8084

;---------------------------------------------------------------------------
;FE
[State -1]
type = ChangeState
value = 901
triggerall = command = "yz"
triggerall = power >= 3000
triggerall = NumExplod(900) = 0
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299

;---------------------------------------------------------------------------
;CM
[State -1]
type = ChangeState
value = 911
triggerall = command = "xa"
triggerall = power >= 3000
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) = 0
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299

;---------------------------------------------------------------------------
;AM
[State -1]
type = ChangeState
value = 931
triggerall = command = "yb"
triggerall = power >= 3000
triggerall = NumExplod(900) != 1
triggerall = NumExplod(930) = 0
triggerall = NumExplod(910) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299

;---------------------------------------------------------------------------
;DFDFLR
[State -1]
type = ChangeState
value = 620
triggerall = Var(18) != 8
triggerall = command = "DFDFx"
triggerall = power >= 2000
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299

;---------------------------------------------------------------------------
;DFDFLRb
[State -1]
type = ChangeState
value = 6201
triggerall = Var(18) != 8
triggerall = command = "DFDFa"
triggerall = power >= 2000
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299

;---------------------------------------------------------------------------
;DFDFx
[State -1]
type = ChangeState
value = 600
triggerall = Var(18) != 8
triggerall = command = "DDFx"
triggerall = power >= 1000
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299

;---------------------------------------------------------------------------
;DFDFxCM
[State -1]
type = ChangeState
value = 918
triggerall = Var(18) != 8
triggerall = command = "DDFx"
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) = 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = stateno = 5341
trigger22 = stateno = 5381
trigger23 = stateno = 5342
trigger24 = stateno = 5382
trigger25 = stateno = 5401
trigger25 = movecontact = 1
trigger26 = stateno = 5421
trigger26 = movecontact = 1
trigger27 = stateno = 5402
trigger27 = movecontact = 1
trigger28 = stateno = 5422
trigger28 = movecontact = 1

;---------------------------------------------------------------------------
;DFDFa
[State -1]
type = ChangeState
value = 6001
triggerall = Var(18) != 8
triggerall = command = "DDFa"
triggerall = power >= 1000
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299

;---------------------------------------------------------------------------
;DFDFaCM
[State -1]
type = ChangeState
value = 919
triggerall = Var(18) != 8
triggerall = command = "DDFa"
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) = 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = stateno = 5341
trigger22 = stateno = 5381
trigger23 = stateno = 5342
trigger24 = stateno = 5382
trigger25 = stateno = 5401
trigger25 = movecontact = 1
trigger26 = stateno = 5421
trigger26 = movecontact = 1
trigger27 = stateno = 5402
trigger27 = movecontact = 1
trigger28 = stateno = 5422
trigger28 = movecontact = 1

;---------------------------------------------------------------------------
;DBDFy
[State -1]
type = ChangeState
value = 5980
triggerall = Var(18) != 8
triggerall = command = "DBDFy"
triggerall = power >= 2000
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 100
trigger19 = stateno = 101
trigger20 = stateno = 1199
trigger21 = stateno = 5277
trigger21 = P2bodydist X >= -1
trigger22 = stateno = 5299

;---------------------------------------------------------------------------
;DBDFb
[State -1]
type = ChangeState
value = 5980
triggerall = Var(18) != 8
triggerall = command = "DBDFb"
triggerall = power >= 2000
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 100
trigger19 = stateno = 101
trigger20 = stateno = 1199
trigger21 = stateno = 5277
trigger21 = P2bodydist X >= -1
trigger22 = stateno = 5299


;---------------------------------------------------------------------------
;DBFy
[State -1]
type = ChangeState
value = 590
triggerall = Var(18) != 8
triggerall = command = "DBFy"
triggerall = power >= 1000
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 100
trigger19 = stateno = 101
trigger20 = stateno = 1199
trigger21 = stateno = 5277
trigger21 = P2bodydist X >= -1
trigger22 = stateno = 5299

;---------------------------------------------------------------------------
;DBFyCM
[State -1]
type = ChangeState
value = 916
triggerall = Var(18) != 8
triggerall = command = "DBFy"
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) = 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 100
trigger19 = stateno = 101
trigger20 = stateno = 1199
trigger21 = stateno = 5277
trigger21 = P2bodydist X >= -1
trigger22 = stateno = 5299
trigger23 = stateno = 5341
trigger24 = stateno = 5381
trigger25 = stateno = 5342
trigger26 = stateno = 5382
trigger27 = stateno = 5401
trigger27 = movecontact = 1
trigger28 = stateno = 5421
trigger28 = movecontact = 1
trigger30 = stateno = 5402
trigger30 = movecontact = 1
trigger31 = stateno = 5422
trigger31 = movecontact = 1

;---------------------------------------------------------------------------
;DBFb
[State -1]
type = ChangeState
value = 5909
triggerall = Var(18) != 8
triggerall = command = "DBFb"
triggerall = power >= 1000
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 100
trigger19 = stateno = 101
trigger20 = stateno = 1199
trigger21 = stateno = 5277
trigger21 = P2bodydist X >= -1
trigger22 = stateno = 5299

;---------------------------------------------------------------------------
;DBFbCM
[State -1]
type = ChangeState
value = 917
triggerall = Var(18) != 8
triggerall = command = "DBFb"
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) = 1
triggerall = NumExplod(930) != 1
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 100
trigger19 = stateno = 101
trigger20 = stateno = 1199
trigger21 = stateno = 5277
trigger21 = P2bodydist X >= -1
trigger22 = stateno = 5299
trigger23 = stateno = 5341
trigger24 = stateno = 5381
trigger25 = stateno = 5342
trigger26 = stateno = 5382
trigger27 = stateno = 5401
trigger27 = movecontact = 1
trigger28 = stateno = 5421
trigger28 = movecontact = 1
trigger30 = stateno = 5402
trigger30 = movecontact = 1
trigger31 = stateno = 5422
trigger31 = movecontact = 1

;---------------------------------------------------------------------------
;FDBy
[State -1]
type = ChangeState
value = 57099
triggerall = Var(18) != 8
triggerall = command = "FDBy"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 100
trigger19 = stateno = 101
trigger20 = stateno = 1199
trigger21 = stateno = 5277
trigger21 = P2bodydist X >= -1
trigger22 = stateno = 5299
trigger23 = NumExplod(900) = 1
trigger23 = movecontact = 1
trigger23 = stateno != 546
trigger23 = stateno != 5461
trigger23 = stateno != 562
trigger23 = stateno != 5623
trigger23 = stateno != 5629
trigger23 = stateno != 5626
trigger23 = stateno != 57099
trigger23 = stateno != 57199
trigger23 = stateno != 57599

;---------------------------------------------------------------------------
;FDBb
[State -1]
type = ChangeState
value = 57599
triggerall = Var(18) != 8
triggerall = command = "FDBb"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 100
trigger19 = stateno = 101
trigger20 = stateno = 1199
trigger21 = stateno = 5277
trigger21 = P2bodydist X >= -1
trigger22 = stateno = 5299
trigger23 = NumExplod(900) = 1
trigger23 = movecontact = 1
trigger23 = stateno != 546
trigger23 = stateno != 5461
trigger23 = stateno != 562
trigger23 = stateno != 5623
trigger23 = stateno != 5629
trigger23 = stateno != 5626
trigger23 = stateno != 57099
trigger23 = stateno != 57199
trigger23 = stateno != 57599

;---------------------------------------------------------------------------
;FDBx
[State -1,1]
type = ChangeState
value = 562
triggerall = Var(18) != 8
triggerall = command = "FDBx"
triggerall = statetype != A
triggerall = p2stateno >= 5000
triggerall = p2stateno <= 5100
trigger1 = stateno = 514
trigger1 = movehit = 1
trigger2 = stateno = 515
trigger2 = movehit = 1
trigger3 = stateno = 100
trigger4 = stateno = 101

;---------------------------------------------------------------------------
;FDBa
[State -1]
type = ChangeState
value = 562
triggerall = Var(18) != 8
triggerall = command = "FDBa"
triggerall = statetype != A
triggerall = p2stateno >= 5000
triggerall = p2stateno <= 5100
trigger1 = stateno = 514
trigger1 = movehit = 1
trigger2 = stateno = 515
trigger2 = movehit = 1
trigger3 = stateno = 100
trigger4 = stateno = 101

;---------------------------------------------------------------------------
;FDBxS
[State -1]
type = ChangeState
value = 5623
triggerall = Var(18) != 8
triggerall = command = "FDBx"
triggerall = statetype != A
triggerall = p2statetype != L
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;FDBaS
[State -1]
type = ChangeState
value = 5623
triggerall = Var(18) != 8
triggerall = command = "FDBa"
triggerall = statetype != A
triggerall = p2statetype != L
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;FDBxG
[State -1]
type = ChangeState
value = 5629
triggerall = Var(18) != 8
triggerall = command = "FDBx"
triggerall = statetype = S
trigger1 = p2stateno >= 120
trigger1 = p2stateno <= 153
triggerall = ctrl = 1
trigger2 = p2movetype = H
trigger2 = P2bodydist X >= -1
trigger2 = P2bodydist X <= 22
trigger2 = stateno = 5277
trigger3 = p2movetype = H
trigger3 = stateno = 1199
trigger4 = p2statetype = L

;---------------------------------------------------------------------------
;FDBaG
[State -1]
type = ChangeState
value = 5629
triggerall = Var(18) != 8
triggerall = command = "FDBa"
triggerall = statetype = S
trigger1 = p2stateno >= 120
trigger1 = p2stateno <= 153
triggerall = ctrl = 1
trigger2 = p2movetype = H
trigger2 = P2bodydist X >= -1
trigger2 = P2bodydist X <= 22
trigger2 = stateno = 5277
trigger3 = p2movetype = H
trigger3 = stateno = 1199
trigger4 = p2statetype = L

;---------------------------------------------------------------------------
;FDBxL
[State -1]
type = ChangeState
value = 5626
triggerall = Var(18) != 8
triggerall = command = "FDBx"
triggerall = statetype != A
trigger1 = P2bodydist X >= -1
trigger1 = stateno = 5277
trigger2 = stateno = 1199
trigger3 = p2statetype = L
trigger3 = ctrl = 1

;---------------------------------------------------------------------------
;FDBaL
[State -1]
type = ChangeState
value = 5626
triggerall = Var(18) != 8
triggerall = command = "FDBa"
triggerall = statetype != A
trigger1 = P2bodydist X >= -1
trigger1 = stateno = 5277
trigger2 = stateno = 1199
trigger3 = p2statetype = L
trigger3 = ctrl = 1

;---------------------------------------------------------------------------

;FDBxN
[State -1]
type = ChangeState
value = 5629
triggerall = Var(18) != 8
triggerall = command = "FDBx"
triggerall = statetype != A
triggerall = movecontact = 1
trigger1 = stateno = 520
trigger1 = time >= 14
trigger2 = stateno = 539
trigger2 = time <= 23
trigger3 = stateno = 524
trigger4 = stateno = 503
trigger5 = stateno = 5291
trigger6 = stateno = 523
trigger7 = stateno = 5292
trigger8 = stateno = 5293
trigger9 = stateno = 5282
trigger10 = stateno = 5252
trigger10 = movehit = 1
trigger11 = stateno = 5253
trigger12 = stateno = 5281
trigger13 = stateno = 100
trigger14 = stateno = 531
trigger15 = stateno = 514
trigger16 = stateno = 515
trigger17 = NumExplod(900) = 1
trigger17 = stateno != 546
trigger17 = stateno != 5461
trigger17 = stateno != 562
trigger17 = stateno != 5623
trigger17 = stateno != 5629
trigger17 = stateno != 5626
trigger17 = stateno != 57099
trigger17 = stateno != 57199
trigger17 = stateno != 57599


;FDBxN
[State -1]
type = ChangeState
value = 5629
triggerall = Var(18) != 8
triggerall = command = "FDBa"
triggerall = statetype != A
triggerall = movecontact = 1
trigger1 = stateno = 520
trigger1 = time >= 14
trigger2 = stateno = 539
trigger2 = time <= 23
trigger3 = stateno = 524
trigger4 = stateno = 503
trigger5 = stateno = 5291
trigger6 = stateno = 523
trigger7 = stateno = 5292
trigger8 = stateno = 5293
trigger9 = stateno = 5282
trigger10 = stateno = 5252
trigger10 = movehit = 1
trigger11 = stateno = 5253
trigger12 = stateno = 5281
trigger13 = stateno = 100
trigger14 = stateno = 531
trigger15 = stateno = 514
trigger16 = stateno = 515
trigger17 = NumExplod(900) = 1
trigger17 = stateno != 546
trigger17 = stateno != 5461
trigger17 = stateno != 562
trigger17 = stateno != 5623
trigger17 = stateno != 5629
trigger17 = stateno != 5626
trigger17 = stateno != 57099
trigger17 = stateno != 57199
trigger17 = stateno != 57599


;---------------------------------------------------------------------------
;DUy
[State -1]
type = ChangeState
value = 543
triggerall = Var(18) != 8
triggerall = command = "DUy"
triggerall = NumExplod(900) != 1
trigger1 = stateno = 40
triggerall = statetype != A
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299

;DUy
[State -1]
type = ChangeState
value = 543
triggerall = Var(18) != 8
triggerall = command = "DUys"
trigger1 = stateno = 40
triggerall = statetype != A
triggerall = NumExplod(900) = 1
trigger2 = movecontact = 1
trigger2 = stateno != 546
trigger2 = stateno != 5461
trigger2 = stateno != 562
trigger2 = stateno != 5623
trigger2 = stateno != 5629
trigger2 = stateno != 5626
trigger2 = stateno != 57099
trigger2 = stateno != 57199
trigger2 = stateno != 57599



;---------------------------------------------------------------------------
;DUyj
[State -1]
type = ChangeState
value = 543
triggerall = Var(18) != 8
trigger1 = command = "DUyj"
trigger1 = stateno = 2042
trigger1 = time <= 5

;---------------------------------------------------------------------------
;DUb
[State -1]
type = ChangeState
value = 560
triggerall = Var(18) != 8
triggerall = command = "DUb"
triggerall = NumExplod(900) != 1
trigger1 = stateno = 40
triggerall = statetype != A
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 2042
trigger18 = time <= 3
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299

;DUb
[State -1]
type = ChangeState
value = 560
triggerall = Var(18) != 8
triggerall = command = "DUbs"
trigger1 = stateno = 40
triggerall = statetype != A
triggerall = NumExplod(900) = 1
trigger2 = movecontact = 1
trigger2 = stateno != 546
trigger2 = stateno != 5461
trigger2 = stateno != 562
trigger2 = stateno != 5623
trigger2 = stateno != 5629
trigger2 = stateno != 5626
trigger2 = stateno != 57099
trigger2 = stateno != 57199
trigger2 = stateno != 57599

;---------------------------------------------------------------------------
;DUbj
[State -1]
type = ChangeState
value = 560
triggerall = Var(18) != 8
trigger1 = command = "DUbj"
trigger1 = stateno = 2042
trigger1 = time <= 5

;---------------------------------------------------------------------------
;DUx
[State -1]
type = ChangeState
value = 540
triggerall = Var(18) != 8
triggerall = command = "DUx"
triggerall = NumExplod(900) != 1
trigger1 = stateno = 40
triggerall = statetype != A
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 1199
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger20 = stateno = 5299
trigger21 = stateno = 2042
trigger21 = time <= 3

;DUx
[State -1]
type = ChangeState
value = 540
triggerall = Var(18) != 8
triggerall = command = "DUxs"
trigger1 = stateno = 40
triggerall = statetype != A
triggerall = NumExplod(900) = 1
trigger2 = movecontact = 1
trigger2 = stateno != 546
trigger2 = stateno != 5461
trigger2 = stateno != 562
trigger2 = stateno != 5623
trigger2 = stateno != 5629
trigger2 = stateno != 5626
trigger2 = stateno != 57099
trigger2 = stateno != 57199
trigger2 = stateno != 57599


;---------------------------------------------------------------------------
;DUxj
[State -1]
type = ChangeState
value = 540
triggerall = Var(18) != 8
trigger1 = command = "DUxj"
trigger1 = stateno = 2042
trigger1 = time <= 5

;---------------------------------------------------------------------------
;DUa
[State -1]
type = ChangeState
value = 542
triggerall = Var(18) != 8
triggerall = command = "DUa"
triggerall = NumExplod(900) != 1
trigger1 = stateno = 40
triggerall = statetype != A
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = stateno = 2042
trigger18 = time <= 3
trigger19 = stateno = 1199
trigger20 = stateno = 5277
trigger20 = P2bodydist X >= -1
trigger21 = stateno = 5299

;DUa
[State -1]
type = ChangeState
value = 542
triggerall = Var(18) != 8
triggerall = command = "DUas"
trigger1 = stateno = 40
triggerall = statetype != A
triggerall = NumExplod(900) = 1
trigger2 = movecontact = 1
trigger2 = stateno != 546
trigger2 = stateno != 5461
trigger2 = stateno != 562
trigger2 = stateno != 5623
trigger2 = stateno != 5629
trigger2 = stateno != 5626
trigger2 = stateno != 57099
trigger2 = stateno != 57199
trigger2 = stateno != 57599

;---------------------------------------------------------------------------
;DUaj
[State -1]
type = ChangeState
value = 542
triggerall = Var(18) != 8
trigger1 = command = "DUaj"
trigger1 = stateno = 2042
trigger1 = time <= 5

;---------------------------------------------------------------------------
;BFx
[State -1]
type = ChangeState
value = 534
triggerall = Var(18) != 8
triggerall = numproj = 0
triggerall = command = "BFx"
triggerall = statetype != A
triggerall = NumExplod(900) != 1
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = anim = 11
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger19 = P2bodydist X <= 22
trigger20 = stateno = 1199
trigger21 = stateno = 5299


;BFx
[State -1]
type = ChangeState
value = 534
triggerall = Var(18) != 8
triggerall = command = "BFxs"
triggerall = statetype != A
triggerall = NumExplod(900) = 1
trigger1 = ctrl = 1
trigger2 = stateno = 5343
trigger3 = stateno = 5383
trigger4 = movecontact = 1
trigger4 = stateno != 546
trigger4 = stateno != 5461
trigger4 = stateno != 562
trigger4 = stateno != 5623
trigger4 = stateno != 5629
trigger4 = stateno != 5626
trigger4 = stateno != 57099
trigger4 = stateno != 57199
trigger4 = stateno != 57599


;---------------------------------------------------------------------------
;BFa
[State -1]
type = ChangeState
value = 538
triggerall = Var(18) != 8
triggerall = numproj = 0
triggerall = command = "BFa"
triggerall = statetype != A
triggerall = NumExplod(900) != 1
trigger1 = ctrl = 1
trigger2 = stateno = 520
trigger2 = movecontact = 1
trigger2 = time >= 14
trigger3 = stateno = 539
trigger3 = movecontact = 1
trigger3 = time <= 23
trigger4 = stateno = 524
trigger4 = movecontact = 1
trigger5 = stateno = 515
trigger5 = movecontact = 1
trigger6 = stateno = 503
trigger6 = movecontact = 1
trigger7 = stateno = 5291
trigger7 = movecontact = 1
trigger8 = stateno = 514
trigger8 = movecontact = 1
trigger9 = stateno = 523
trigger9 = movecontact = 1
trigger10 = stateno = 5292
trigger10 = movecontact = 1
trigger11 = stateno = 5293
trigger11 = movecontact = 1
trigger12 = stateno = 5282
trigger12 = movecontact = 1
trigger13 = stateno = 5252
trigger13 = movehit = 1
trigger14 = stateno = 5253
trigger15 = stateno = 5281
trigger15 = movecontact = 1
trigger16 = stateno = 100
trigger17 = stateno = 531
trigger17 = movecontact = 1
trigger18 = anim = 11
trigger19 = stateno = 5277
trigger19 = P2bodydist X >= -1
trigger19 = P2bodydist X <= 22
trigger20 = stateno = 1199
trigger21 = stateno = 5299

;BFa
[State -1]
type = ChangeState
value = 538
triggerall = Var(18) != 8
triggerall = command = "BFas"
triggerall = statetype != A
triggerall = NumExplod(900) = 1
trigger1 = ctrl = 1
trigger2 = stateno = 5343
trigger3 = stateno = 5383
trigger4 = movecontact = 1
trigger4 = stateno != 546
trigger4 = stateno != 5461
trigger4 = stateno != 562
trigger4 = stateno != 5623
trigger4 = stateno != 5629
trigger4 = stateno != 5626
trigger4 = stateno != 57099
trigger4 = stateno != 57199
trigger4 = stateno != 57599


;---------------------------------------------------------------------------
;PowerA
[State -1]
type = ChangeState
value = 504
triggerall = power != 3000
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
trigger1 = statetype = S
triggerall = ctrl = 1
trigger1 = command = "hold_x"
trigger1 = command = "hold_y"
trigger1 = command = "hold_a"
trigger2 = statetype = C
trigger2 = command = "holddown"
trigger2 = command = "hold_z"

;PowerAR
[State -1]
type = ChangeState
value = 504
triggerall = power != 3000
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
triggerall = stateno = 100
triggerall = ctrl = 0
trigger1 = command = "hold_x"
trigger1 = command = "hold_y"
trigger1 = command = "hold_a"
trigger2 = command = "holddown"
trigger2 = command = "hold_z"

;PowerAJ
[State -1]
type = ChangeState
value = 504
triggerall = power != 3000
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
trigger1 = stateno = 5277
trigger1 = command = "hold_x"
trigger1 = command = "hold_y"
trigger1 = command = "hold_a"
trigger2 = stateno = 5299
trigger2 = command = "hold_x"
trigger2 = command = "hold_y"
trigger2 = command = "hold_a"
trigger3 = stateno = 5277
trigger3 = command = "holddown"
trigger3 = command = "hold_z"
trigger4 = stateno = 5299
trigger4 = command = "holddown"
trigger4 = command = "hold_z"
trigger5 = anim = 11
trigger5 = command = "holddown"
trigger5 = command = "hold_z"


;===========================================================================

;---------------------------------------------------------------------------
;RunFwd
[State -1]
type = ChangeState
value = 100
triggerall = command = "FF"
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 5252
trigger2 = movehit = 1
trigger2 = ctrl = 0
trigger3 = stateno = 5253
trigger3 = ctrl = 0
trigger4 = stateno = 8141
trigger4 = time >= 23
;---------------------------------------------------------------------------

;RunBack
[State -1]
type = ChangeState
value = 105
triggerall = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 5252
trigger2 = movehit = 1
trigger3 = stateno = 5253

;---------------------------------------------------------------------------
;RunBackB
[State -1]
type = ChangeState
value = 8085
triggerall = var(18) = 8
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = ctrl = 1
trigger1 = command = "Bxy"
trigger2 = command = "Bz"

;RBBJ
[State -1]
type = ChangeState
value = 8085
triggerall = var(18) = 8
triggerall = command != "holddown"
trigger1 = command = "Bxy"
trigger1 = stateno = 5277
trigger2 = command = "Bxy"
trigger2 = stateno = 5299
trigger3 = command = "Bz"
trigger3 = stateno = 5277
trigger4 = command = "Bz"
trigger4 = stateno = 5299

;---------------------------------------------------------------------------
;SPG_CBB
[State -1]
type = ChangeState
value = 503
triggerall = var(18) = 8
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = ctrl = 1
trigger1 = command = "xy"
trigger2 = command = "z"

;SPG_CBB
[State -1]
type = ChangeState
value = 503
triggerall = var(18) = 8
triggerall = stateno = 100
triggerall = statetype != A
triggerall = ctrl = 0
trigger1 = command = "Fxy"
trigger2 = command = "Fz"

;---------------------------------------------------------------------------
;SPG_CJBB
[State -1]
type = ChangeState
value = 503
triggerall = var(18) = 8
triggerall = command != "holddown"
trigger1 = command = "xy"
trigger1 = stateno = 5277
trigger2 = command = "Bxy"
trigger2 = stateno = 5299
trigger3 = command = "z"
trigger3 = stateno = 5277
trigger4 = command = "z"
trigger4 = stateno = 5299

;---------------------------------------------------------------------------
;SPG_BG
[State -1]
type = ChangeState
value = 50211
triggerall = statetype != A
triggerall = anim = 150
triggerall = power >= 500
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
trigger1 = command = "Bxy"
trigger2 = command = "Bz"
trigger3 = command = "BD"
trigger3 = command = "xy"
trigger4 = command = "BD"
trigger4 = command = "z"

;SPG_BG
[State -1]
type = ChangeState
value = 50211
triggerall = statetype != A
triggerall = anim = 151
triggerall = power >= 500
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
trigger1 = command = "Bxy"
trigger2 = command = "Bz"
trigger3 = command = "BD"
trigger3 = command = "xy"
trigger4 = command = "BD"
trigger4 = command = "z"

;--------------------------------------------------------------------------
;SPG_A
[State -1]
type = ChangeState
value = 501
triggerall = var(18) != 8
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = ctrl = 1
trigger1 = command = "Fxy"
trigger2 = command = "Fz"

;SPG_AJ
[State -1]
type = ChangeState
value = 501
triggerall = var(18) != 8
triggerall = command != "holddown"
trigger1 = command = "Fxy"
trigger1 = stateno = 5277
trigger2 = command = "Fxy"
trigger2 = stateno = 5299
trigger3 = command = "Fz"
trigger3 = stateno = 5277
trigger4 = command = "Fz"
trigger4 = stateno = 5299

;SPG_AR
[State -1]
type = ChangeState
value = 50112
triggerall = var(18) != 8
triggerall = stateno = 100
triggerall = statetype != A
triggerall = ctrl = 0
trigger1 = command = "Fxy"
trigger2 = command = "Fz"


;SPG_AG
[State -1]
type = ChangeState
value = 50111
triggerall = statetype != A
triggerall = anim = 150
triggerall = power >= 500
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
trigger1 = command = "xy"
trigger2 = command = "z"

;SPG_AG
[State -1]
type = ChangeState
value = 50111
triggerall = statetype != A
triggerall = anim = 151
triggerall = power >= 500
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
trigger1 = command = "xy"
trigger2 = command = "z"

;---------------------------------------------------------------------------
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;SPG_C
[State -1]
type = ChangeState
value = 503
triggerall = var(18) != 8
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = ctrl = 1
trigger1 = command = "Bxy"
trigger2 = command = "Bz"

;---------------------------------------------------------------------------
;SPG_CJ
[State -1]
type = ChangeState
value = 503
triggerall = var(18) != 8
triggerall = command != "holddown"
trigger1 = command = "Bxy"
trigger1 = stateno = 5277
trigger2 = command = "Bxy"
trigger2 = stateno = 5299
trigger3 = command = "Bz"
trigger3 = stateno = 5277
trigger4 = command = "Bz"
trigger4 = stateno = 5299

[State -1]
type = ChangeState
triggerall = stateno = 503
triggerall = time <= 26
trigger1 = command = "x"
trigger2 = command = "y"
trigger3 = command = "a"
trigger4 = command = "b"
value = 531

;---------------------------------------------------------------------------
;SPG_B
[State -1]
type = ChangeState
value = 502
triggerall = var(18) != 8
triggerall = statetype != A
trigger1 = command != "holddown"
trigger1 = ctrl = 1
trigger1 = command = "xy"
trigger2 = command != "holddown"
trigger2 = ctrl = 1
trigger2 = command = "z"

;SPG_B
[State -1]
type = ChangeState
value = 502
triggerall = statetype != A
trigger1 = anim >= 5090
trigger1 = anim <= 5105
trigger1 = command = "xy"
trigger2 = anim >= 5090
trigger2 = anim <= 5105
trigger2 = command = "z"
trigger3 = anim >= 5090
trigger3 = anim <= 5105
trigger3 = command = "ab"

;SPG_BJ
[State -1]
type = ChangeState
value = 502
triggerall = var(18) != 8
triggerall = command != "holddown"
trigger1 = command = "xy"
trigger1 = stateno = 5277
trigger2 = command = "xy"
trigger2 = stateno = 5299
trigger3 = command = "z"
trigger3 = stateno = 5277
trigger4 = command = "z"
trigger4 = stateno = 5299


;---------------------------------------------------------------------------
;FyM
[State -1]
type = ChangeState
value = 5391
triggerall = command != "holddown"
triggerall = command = "holdfwd"
triggerall = command = "y"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 100
trigger3 = stateno = 5277
trigger3 = P2bodydist X >= -1
trigger3 = P2bodydist X <= 22
trigger4 = stateno = 5299


;---------------------------------------------------------------------------
;Fy
[State -1]
type = ChangeState
value = 539
triggerall = command != "holddown"
triggerall = command = "holdfwd"
triggerall = command = "y"
triggerall = statetype != A
trigger1 = stateno = 520
trigger1 = movecontact = 1
trigger1 = time >= 14
trigger2 = stateno = 524
trigger2 = movecontact = 1
trigger3 = stateno = 5281
trigger3 = movecontact = 1
trigger4 = stateno = 515
trigger4 = movecontact = 1
trigger5 = stateno = 503
trigger5 = movecontact = 1
trigger6 = stateno = 5253
trigger7 = stateno = 514
trigger7 = movecontact = 1
trigger8 = stateno = 523
trigger8 = movecontact = 1
trigger9 = stateno = 5282
trigger9 = movecontact = 1
trigger10 = stateno = 5252
trigger10 = movehit = 1
trigger11 = NumExplod(900) = 1
trigger11 = movecontact = 1
trigger11 = stateno != 546
trigger11 = stateno != 5461
trigger11 = stateno != 562
trigger11 = stateno != 5623
trigger11 = stateno != 5629
trigger11 = stateno != 5626
trigger11 = stateno != 57099
trigger11 = stateno != 57199
trigger11 = stateno != 57599
trigger12 = stateno = 8002
trigger12 = movecontact = 1

;---------------------------------------------------------------------------
;StCD
[State -1]
type = ChangeState
value = 529
triggerall = command != "holddown"
triggerall = statetype != A
triggerall = ctrl = 1
trigger1 = command = "c"
trigger2 = command = "ab"
trigger3 = NumExplod(900) = 1
trigger3 = movecontact = 1
trigger3 = stateno != 546
trigger3 = stateno != 5461
trigger3 = stateno != 562
trigger3 = stateno != 5623
trigger3 = stateno != 5629
trigger3 = stateno != 5626
trigger3 = stateno != 57099
trigger3 = stateno != 57199
trigger3 = stateno != 57599


;StCDR
[State -1]
type = ChangeState
value = 529
triggerall = stateno = 100
triggerall = ctrl = 0
trigger1 = command = "c"
trigger2 = command = "ab"

;StCD
[State -1]
type = ChangeState
value = 529
triggerall = command != "holddown"
trigger1 = stateno = 5277
trigger1 = command = "c"
trigger2 = stateno = 5299
trigger2 = command = "c"
trigger3 = stateno = 5277
trigger3 = command = "ab"
trigger4 = stateno = 5299
trigger4 = command = "ab"

;---------------------------------------------------------------------------
;StCDCERG
[State -1]
type = ChangeState
value = 5293
triggerall = statetype != A
triggerall = anim = 150
triggerall = power >= 500
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
trigger1 = command = "c"
trigger2 = command = "ab"

;---------------------------------------------------------------------------
;StCDCERG
[State -1]
type = ChangeState
value = 5293
triggerall = statetype != A
triggerall = anim = 151
triggerall = power >= 500
triggerall = NumExplod(900) != 1
triggerall = NumExplod(910) != 1
triggerall = NumExplod(930) != 1
trigger1 = command = "c"
trigger2 = command = "ab"

;---------------------------------------------------------------------------
;JCD
[State -1]
type = ChangeState
value = 530
triggerall = statetype = A
triggerall = ctrl = 1
trigger1 = command = "c"
trigger2 = command = "ab"
trigger3 = NumExplod(900) = 1
trigger3 = movecontact = 1
trigger3 = stateno != 546
trigger3 = stateno != 5461
trigger3 = stateno != 562
trigger3 = stateno != 5623
trigger3 = stateno != 5629
trigger3 = stateno != 5626
trigger3 = stateno != 57099
trigger3 = stateno != 57199
trigger3 = stateno != 57599
trigger4 = NumExplod(900) = 1
trigger4 = stateno = 8091

;===========================================================================

;---------------------------------------------------------------------------
;JNFA
[State -1]
type = ChangeState
value = 655
triggerall = statetype = A
triggerall = ctrl = 1
trigger1 = command = "fwd_a"
trigger1 = p2bodydist X < 7
trigger1 = p2statetype = A
trigger1 = p2movetype != H
trigger2 = command = "back_a"
trigger2 = p2bodydist X < 7
trigger2 = p2statetype = A
trigger2 = p2movetype != H
trigger3 = command = "fwd_b"
trigger3 = p2bodydist X < 7
trigger3 = p2statetype = A
trigger3 = p2movetype != H
trigger4 = command = "back_b"
trigger4 = p2bodydist X < 7
trigger4 = p2statetype = A
trigger4 = p2movetype != H

;---------------------------------------------------------------------------
;NFAS
[State -1]
type = ChangeState
value = 8042
triggerall = Var(18) = 8
triggerall = statetype = S
triggerall = stateno != 100
triggerall = P2movetype != H
triggerall = P2statetype != A
triggerall = P2bodydist X <= 7
triggerall = ctrl = 1
trigger1 = command = "fwd_a"
trigger2 = command = "back_a"

;---------------------------------------------------------------------------
;NFA
[State -1]
type = ChangeState
value = 630
triggerall = Var(18) != 8
triggerall = statetype = S
triggerall = stateno != 100
triggerall = P2movetype != H
triggerall = P2statetype != A
triggerall = P2bodydist X <= 7
triggerall = ctrl = 1
trigger1 = command = "fwd_a"
trigger2 = command = "back_a"

;---------------------------------------------------------------------------

;NFB
[State -1]
type = ChangeState
value = 645
triggerall = statetype = S
triggerall = stateno != 100
triggerall = P2movetype != H
triggerall = P2statetype != A
triggerall = P2bodydist X <= 7
triggerall = ctrl = 1
trigger1 = command = "fwd_b"
trigger2 = command = "back_b"

;---------------------------------------------------------------------------
;Fbs
[State -1]
type = ChangeState
value = 8003
triggerall = Var(18) = 8
triggerall = command != "holddown"
triggerall = command = "holdfwd"
triggerall = command = "b"
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 100
trigger3 = stateno = 5277
trigger3 = P2bodydist X >= -1
trigger3 = P2bodydist X <= 22
trigger4 = stateno = 5299

;---------------------------------------------------------------------------
;Fbs
[State -1]
type = ChangeState
value = 8003
triggerall = Var(18) = 8
triggerall = command != "holddown"
triggerall = command = "holdfwd"
triggerall = command = "b"
triggerall = statetype != A
trigger1 = stateno = 520
trigger1 = movecontact = 1
trigger1 = time >= 14
trigger2 = stateno = 524
trigger2 = movecontact = 1
trigger3 = stateno = 5281
trigger3 = movecontact = 1
trigger4 = stateno = 515
trigger4 = movecontact = 1
trigger5 = stateno = 503
trigger5 = movecontact = 1
trigger6 = stateno = 5253
trigger7 = stateno = 514
trigger7 = movecontact = 1
trigger8 = stateno = 523
trigger8 = movecontact = 1
trigger9 = stateno = 5282
trigger9 = movecontact = 1
trigger10 = stateno = 5252
trigger10 = movehit = 1
trigger11 = NumExplod(900) = 1
trigger11 = movecontact = 1
trigger11 = stateno != 546
trigger11 = stateno != 5461
trigger11 = stateno != 562
trigger11 = stateno != 5623
trigger11 = stateno != 5629
trigger11 = stateno != 5626
trigger11 = stateno != 57099
trigger11 = stateno != 57199
trigger11 = stateno != 57599
trigger12 = stateno = 8002
trigger12 = movecontact = 1

;---------------------------------------------------------------------------
;JBy
[State -1]
type = ChangeState
value = 8040
triggerall = Var(18) = 8
triggerall = command = "JBy"
triggerall = statetype = A
trigger1 = ctrl = 1
trigger2 = NumExplod(900) = 1
trigger2 = movecontact = 1
trigger2 = stateno != 546
trigger2 = stateno != 5461
trigger2 = stateno != 562
trigger2 = stateno != 5623
trigger2 = stateno != 5629
trigger2 = stateno != 5626
trigger2 = stateno != 57099
trigger2 = stateno != 57199
trigger2 = stateno != 57599
trigger3 = NumExplod(900) = 1
trigger3 = stateno = 8091

;---------------------------------------------------------------------------
;Stx
[State -1]
type = ChangeState
value = 510
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 510
trigger2 = movecontact = 1
trigger2 = time >= 6
trigger3 = stateno = 510
trigger3 = time >= 10
trigger4 = P2bodydist X >= -10
trigger4 = P2bodydist X <= 22
trigger4 = stateno = 5277
trigger5 = stateno = 5299
trigger6 = stateno = 100
trigger7 = NumExplod(900) = 1
trigger7 = movecontact = 1
trigger7 = stateno != 546
trigger7 = stateno != 5461
trigger7 = stateno != 562
trigger7 = stateno != 5623
trigger7 = stateno != 5629
trigger7 = stateno != 5626
trigger7 = stateno != 57099
trigger7 = stateno != 57199
trigger7 = stateno != 57599


;---------------------------------------------------------------------------
;Styn
[State -1]
type = ChangeState
value = 515
triggerall = command = "y"
triggerall = command != "holddown"
triggerall = P2bodydist X >= -10
triggerall = P2bodydist X <= 22
triggerall = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 5277
trigger3 = stateno = 5299
trigger4 = stateno = 100
trigger5 = NumExplod(900) = 1
trigger5 = movecontact = 1
trigger5 = stateno != 546
trigger5 = stateno != 5461
trigger5 = stateno != 562
trigger5 = stateno != 5623
trigger5 = stateno != 5629
trigger5 = stateno != 5626
trigger5 = stateno != 57099
trigger5 = stateno != 57199
trigger5 = stateno != 57599


;---------------------------------------------------------------------------
;Sty
[State -1]
type = ChangeState
value = 516
triggerall = command = "y"
triggerall = command != "holddown"
triggerall = P2bodydist X >= 23
triggerall = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 100
trigger3 = NumExplod(900) = 1
trigger3 = movecontact = 1
trigger3 = stateno != 546
trigger3 = stateno != 5461
trigger3 = stateno != 562
trigger3 = stateno != 5623
trigger3 = stateno != 5629
trigger3 = stateno != 5626
trigger3 = stateno != 57099
trigger3 = stateno != 57199
trigger3 = stateno != 57599


;---------------------------------------------------------------------------
;StAn
[State -1]
type = ChangeState
value = 520
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = NumExplod(900) != 1
triggerall = P2bodydist X >= -10
triggerall = P2bodydist X <= 22
triggerall = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 5277
trigger3 = stateno = 5299
trigger4 = stateno = 100
trigger5 = NumExplod(900) = 1
trigger5 = movecontact = 1
trigger5 = stateno != 546
trigger5 = stateno != 5461
trigger5 = stateno != 562
trigger5 = stateno != 5623
trigger5 = stateno != 5629
trigger5 = stateno != 5626
trigger5 = stateno != 57099
trigger5 = stateno != 57199
trigger5 = stateno != 57599

;---------------------------------------------------------------------------
;StAnFE
[State -1]
type = ChangeState
value = 5201
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = P2bodydist X >= -10
triggerall = P2bodydist X <= 22
triggerall = NumExplod(900) = 1
triggerall = NumExplod(930) != 1
triggerall = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 5277
trigger3 = stateno = 5299
trigger4 = stateno = 100
trigger5 = NumExplod(900) = 1
trigger5 = movecontact = 1
trigger5 = stateno != 546
trigger5 = stateno != 5461
trigger5 = stateno != 562
trigger5 = stateno != 5623
trigger5 = stateno != 5629
trigger5 = stateno != 5626
trigger5 = stateno != 57099
trigger5 = stateno != 57199
trigger5 = stateno != 57599

;---------------------------------------------------------------------------
;StA
[State -1]
type = ChangeState
value = 521
triggerall = command = "a"
triggerall = command != "holddown"
triggerall = P2bodydist X >= 23
triggerall = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 100
trigger3 = NumExplod(900) = 1
trigger3 = movecontact = 1
trigger3 = stateno != 546
trigger3 = stateno != 5461
trigger3 = stateno != 562
trigger3 = stateno != 5623
trigger3 = stateno != 5629
trigger3 = stateno != 5626
trigger3 = stateno != 57099
trigger3 = stateno != 57199
trigger3 = stateno != 57599


;---------------------------------------------------------------------------
;Stbn
[State -1]
type = ChangeState
value = 524
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = P2bodydist X >= -10
triggerall = P2bodydist X <= 22
triggerall = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 5277
trigger3 = stateno = 5299
trigger4 = stateno = 100
trigger5 = NumExplod(900) = 1
trigger5 = movecontact = 1
trigger5 = stateno != 546
trigger5 = stateno != 5461
trigger5 = stateno != 562
trigger5 = stateno != 5623
trigger5 = stateno != 5629
trigger5 = stateno != 5626
trigger5 = stateno != 57099
trigger5 = stateno != 57199
trigger5 = stateno != 57599

;---------------------------------------------------------------------------
;StbS
[State -1]
type = ChangeState
value = 8002
triggerall = Var(18) = 8
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = P2bodydist X >= 23
triggerall = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 100
trigger3 = NumExplod(900) = 1
trigger3 = movecontact = 1
trigger3 = stateno != 546
trigger3 = stateno != 5461
trigger3 = stateno != 562
trigger3 = stateno != 5623
trigger3 = stateno != 5629
trigger3 = stateno != 5626
trigger3 = stateno != 57099
trigger3 = stateno != 57199
trigger3 = stateno != 57599

;---------------------------------------------------------------------------
;Stb
[State -1]
type = ChangeState
value = 525
triggerall = Var(18) != 8
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = P2bodydist X >= 23
triggerall = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 100
trigger3 = NumExplod(900) = 1
trigger3 = movecontact = 1
trigger3 = stateno != 546
trigger3 = stateno != 5461
trigger3 = stateno != 562
trigger3 = stateno != 5623
trigger3 = stateno != 5629
trigger3 = stateno != 5626
trigger3 = stateno != 57099
trigger3 = stateno != 57199
trigger3 = stateno != 57599

;---------------------------------------------------------------------------
;CX
[State -1]
type = ChangeState
value = 514
triggerall = command = "x"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 514
trigger2 = movecontact = 1
trigger2 = time >= 6
trigger3 = stateno = 514
trigger3 = time >= 8
trigger4 = stateno = 100
trigger5 = anim = 11
trigger6 = NumExplod(900) = 1
trigger6 = movecontact = 1
trigger6 = stateno != 546
trigger6 = stateno != 5461
trigger6 = stateno != 562
trigger6 = stateno != 5623
trigger6 = stateno != 5629
trigger6 = stateno != 5626
trigger6 = stateno != 57099
trigger6 = stateno != 57199
trigger6 = stateno != 57599


;---------------------------------------------------------------------------
;CY
[State -1]
type = ChangeState
value = 519
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 100
trigger3 = anim = 11
trigger4 = NumExplod(900) = 1
trigger4 = movecontact = 1
trigger4 = stateno != 546
trigger4 = stateno != 5461
trigger4 = stateno != 562
trigger4 = stateno != 5623
trigger4 = stateno != 5629
trigger4 = stateno != 5626
trigger4 = stateno != 57099
trigger4 = stateno != 57199
trigger4 = stateno != 57599


;---------------------------------------------------------------------------
;CA
[State -1]
type = ChangeState
value = 523
triggerall = command = "a"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 100
trigger3 = anim = 11
trigger4 = NumExplod(900) = 1
trigger4 = movecontact = 1
trigger4 = stateno != 546
trigger4 = stateno != 5461
trigger4 = stateno != 562
trigger4 = stateno != 5623
trigger4 = stateno != 5629
trigger4 = stateno != 5626
trigger4 = stateno != 57099
trigger4 = stateno != 57199
trigger4 = stateno != 57599

;---------------------------------------------------------------------------
;CB
[State -1]
type = ChangeState
value = 528
triggerall = command = "b"
triggerall = command = "holddown"
triggerall = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 100
trigger3 = anim = 11
trigger4 = NumExplod(900) = 1
trigger4 = movecontact = 1
trigger4 = stateno != 546
trigger4 = stateno != 5461
trigger4 = stateno != 562
trigger4 = stateno != 5623
trigger4 = stateno != 5629
trigger4 = stateno != 5626
trigger4 = stateno != 57099
trigger4 = stateno != 57199
trigger4 = stateno != 57599


;---------------------------------------------------------------------------
;Jxn
[State -1]
type = ChangeState
value = 511
triggerall = command = "x"
triggerall = statetype = A
trigger1 = ctrl = 1
triggerall = anim = 41
trigger2 = NumExplod(900) = 1
trigger2 = movecontact = 1
trigger2 = stateno != 546
trigger2 = stateno != 5461
trigger2 = stateno != 562
trigger2 = stateno != 5623
trigger2 = stateno != 5629
trigger2 = stateno != 5626
trigger2 = stateno != 57099
trigger2 = stateno != 57199
trigger2 = stateno != 57599

;---------------------------------------------------------------------------
;Jx
[State -1]
type = ChangeState
value = 513
triggerall = command = "x"
triggerall = statetype = A
trigger1 = ctrl = 1
triggerall = anim != 41
triggerall = anim != 105
trigger2 = NumExplod(900) = 1
trigger2 = movecontact = 1
trigger2 = stateno != 546
trigger2 = stateno != 5461
trigger2 = stateno != 562
trigger2 = stateno != 5623
trigger2 = stateno != 5629
trigger2 = stateno != 5626
trigger2 = stateno != 57099
trigger2 = stateno != 57199
trigger2 = stateno != 57599
trigger3 = NumExplod(900) = 1
trigger3 = stateno = 8091

;---------------------------------------------------------------------------
;Jyn
[State -1]
type = ChangeState
value = 517
triggerall = command = "y"
triggerall = statetype = A
trigger1 = ctrl = 1
triggerall = anim = 41
trigger2 = NumExplod(900) = 1
trigger2 = movecontact = 1
trigger2 = stateno != 546
trigger2 = stateno != 5461
trigger2 = stateno != 562
trigger2 = stateno != 5623
trigger2 = stateno != 5629
trigger2 = stateno != 5626
trigger2 = stateno != 57099
trigger2 = stateno != 57199
trigger2 = stateno != 57599


;---------------------------------------------------------------------------
;Jy
[State -1]
type = ChangeState
value = 518
triggerall = command = "y"
triggerall = statetype = A
trigger1 = ctrl = 1
triggerall = anim != 41
triggerall = anim != 105
trigger2 = NumExplod(900) = 1
trigger2 = movecontact = 1
trigger2 = stateno != 546
trigger2 = stateno != 5461
trigger2 = stateno != 562
trigger2 = stateno != 5623
trigger2 = stateno != 5629
trigger2 = stateno != 5626
trigger2 = stateno != 57099
trigger2 = stateno != 57199
trigger2 = stateno != 57599
trigger3 = NumExplod(900) = 1
trigger3 = stateno = 8091


;---------------------------------------------------------------------------
;JA
[State -1]
type = ChangeState
value = 522
triggerall = command = "a"
triggerall = statetype = A
trigger1 = ctrl = 1
triggerall = anim != 105
trigger2 = NumExplod(900) = 1
trigger2 = movecontact = 1
trigger2 = stateno != 546
trigger2 = stateno != 5461
trigger2 = stateno != 562
trigger2 = stateno != 5623
trigger2 = stateno != 5629
trigger2 = stateno != 5626
trigger2 = stateno != 57099
trigger2 = stateno != 57199
trigger2 = stateno != 57599
trigger3 = NumExplod(900) = 1
trigger3 = stateno = 8091


;---------------------------------------------------------------------------
;JBN
[State -1]
type = ChangeState
value = 526
triggerall = command = "b"
triggerall = statetype = A
trigger1 = ctrl = 1
triggerall = anim = 41
trigger2 = NumExplod(900) = 1
trigger2 = movecontact = 1
trigger2 = stateno != 546
trigger2 = stateno != 5461
trigger2 = stateno != 562
trigger2 = stateno != 5623
trigger2 = stateno != 5629
trigger2 = stateno != 5626
trigger2 = stateno != 57099
trigger2 = stateno != 57199
trigger2 = stateno != 57599

;---------------------------------------------------------------------------
;JB
[State -1]
type = ChangeState
value = 527
triggerall = command = "b"
triggerall = statetype = A
trigger1 = ctrl = 1
triggerall = anim != 41
triggerall = anim != 105
trigger2 = NumExplod(900) = 1
trigger2 = movecontact = 1
trigger2 = stateno != 546
trigger2 = stateno != 5461
trigger2 = stateno != 562
trigger2 = stateno != 5623
trigger2 = stateno != 5629
trigger2 = stateno != 5626
trigger2 = stateno != 57099
trigger2 = stateno != 57199
trigger2 = stateno != 57599
trigger3 = NumExplod(900) = 1
trigger3 = stateno = 8091

;---------------------------------------------------------------------------
;PPK
[State -1]
type = ChangeState
value = 509
triggerall = statetype = C
trigger1 = ctrl = 1
triggerall = command = "holddown"
triggerall = command = "c"
trigger2 = NumExplod(900) = 1
trigger2 = movecontact = 1
trigger2 = stateno != 546
trigger2 = stateno != 5461
trigger2 = stateno != 562
trigger2 = stateno != 5623
trigger2 = stateno != 5629
trigger2 = stateno != 5626
trigger2 = stateno != 57099
trigger2 = stateno != 57199
trigger2 = stateno != 57599

