; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
;

;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.

[Command]
name = "Tenjihao"
command = ~D, DF, F, D, DF, F, x
time = 35

[Command]
name = "Tenjihao"
command = ~D, DF, F, D, DF, F, y
time = 35

[Command]
name = "Ryuko_max"
command = ~D, B, F, x+y
time = 35

[Command]
name = "Haoh_max"
command = ~F, B, D, F, x+y
time = 35

[Command]
name = "Ryuko_x"
command = ~D, B, F, x
time = 35

[Command]
name = "Ryuko_y"
command = ~D, B, F, y
time = 35

[Command]
name = "Haoh_x"
command = ~F, B, D, F, x
time = 35

[Command]
name = "Haoh_y"
command = ~F, B, D, F, y
time = 35

;-| Special Motions |------------------------------------------------------
[Command]
name = "upper_x"
command = ~F, D, DF, x

[Command]
name = "upper_y"
command = ~F, D, DF, y

[Command]
name = "QCF_x"
command = ~D, DF, F, x

[Command]
name = "QCF_y"
command = ~D, DF, F, y

[Command]
name = "F_upper_x"
command = ~B, DB, D, DF, F, x

[Command]
name = "F_upper_y"
command = ~B, DB, D, DF, F, y

[Command]
name = "HCB_x"
command = ~F, DF, D, DB, B, x
time = 15

[Command]
name = "HCB_y"
command = ~F, DF, D, DB, B, y
time = 15

[Command]
name = "Hien_a"
command = ~D, B, a

[Command]
name = "Hien_b"
command = ~D, B, b

[Command]
name = "Zan_x"
command = ~B, D, DB, x

[Command]
name = "Zan_y"
command = ~B, D, DB, y

[Command]
name = "longjump"
command = D, $U
time = 18

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = z
time = 1

[Command]
name = "escape"
command = x+a
time = 1

[Command]
name = "charge"
command = /$c
time = 1

;-| Dir + Button |---------------------------------------------------------

[Command]
name = "fwd_a"
command = /F,a
time = 1

[Command]
name = "fwd_b"
command = /F,b
time = 1

[Command]
name = "fwd_x"
command = /F,x
time = 1

[Command]
name = "fwd_y"
command = /F,y
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;-| Hold Button |-----------------------------------------------------------

[Command]
name = "hold_a"
command = /$a
time = 1

[Command]
name = "hold_b"
command = /$b
time = 1

[Command]
name = "hold_c"
command = /$c
time = 1

[Command]
name = "hold_x"
command = /$x
time = 1

[Command]
name = "hold_y"
command = /$y
time = 1

[Command]
name = "hold_z"
command = /$z
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------
;Teniji-Hao Ken õпձ
[State -1, Ryukoranmu]
type = ChangeState
value = 3200
triggerall = command = "Tenjihao" && power >= 3000
trigger1 = statetype != A && ctrl
trigger2 = movecontact
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger3 = movecontact
trigger3 = stateno = [400,440]

;---------------------------------------------------------------------------
;RyuKo Ranmu ȣ Lv3
[State -1, Ryukoranmu]
type = ChangeState
value = 3120
triggerall = command = "Ryuko_max" && power >= 3000
trigger1 = statetype != A && ctrl
trigger2 = movecontact
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger3 = movecontact
trigger3 = stateno = [400,440]

;---------------------------------------------------------------------------
;Hao Sho Ko Ken пջı Lv3
[State -1, HaoShoKoKen]
type = ChangeState
value = 3020
triggerall = numproj = 0 && command = "Haoh_max" && power >= 3000
trigger1 = statetype != A && ctrl
trigger2 = movecontact
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger3 = movecontact
trigger3 = stateno = [400,440]

;---------------------------------------------------------------------------
;RyuKo Ranmu ȣ Lv1
[State -1, Ryukoranmu]
type = ChangeState
value = 3100
triggerall = command = "Ryuko_x" && power >= 1000
trigger1 = statetype != A && ctrl
trigger2 = movecontact
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger3 = movecontact
trigger3 = stateno = [400,440]

;---------------------------------------------------------------------------
;RyuKo Ranmu ȣ Lv2
[State -1, Ryukoranmu]
type = ChangeState
value = 3110
triggerall = command = "Ryuko_y" && power >= 2000
trigger1 = statetype != A && ctrl
trigger2 = movecontact
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger3 = movecontact
trigger3 = stateno = [400,440]

;---------------------------------------------------------------------------
;Hao Sho Ko Ken пջı 
[State -1, HaoShoKoKen]
type = ChangeState
value = 3000
triggerall = numproj = 0 && command = "Haoh_x" && power >= 1000
trigger1 = statetype != A && ctrl
trigger2 = movecontact
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger3 = movecontact
trigger3 = stateno = [400,440]

;---------------------------------------------------------------------------
;Hao Sho Ko Ken пջı 
[State -1, HaoShoKoKen]
type = ChangeState
value = 3010
triggerall = numproj = 0 && command = "Haoh_y" && power >= 2000
trigger1 = statetype != A && ctrl
trigger2 = movecontact
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger3 = movecontact
trigger3 = stateno = [400,440]

;===========================================================================

;---------------------------------------------------------------------------
;Ko ho ȣ 
[State -1, Ko ho]
type = ChangeState
value = 1100
triggerall = command = "upper_x"
trigger1 = statetype != A && ctrl
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger2 = movecontact
trigger3 = stateno = [400,440]
trigger3 = movecontact

;---------------------------------------------------------------------------
;Ko ho ȣ 
[State -1, Ko ho]
type = ChangeState
value = 1110
triggerall = command = "upper_y"
trigger1 = statetype != A && ctrl
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger2 = movecontact
trigger3 = stateno = [400,440]
trigger3 = movecontact

;---------------------------------------------------------------------------
;Ko-oh Ken ȣȲ 
[State -1, Light Kung Fu Palm]
type = ChangeState
value = 1000
triggerall = numproj = 0 && command = "QCF_x" && command != "holddown"
trigger1 = statetype != A && ctrl
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger2 = movecontact
trigger3 = stateno = [400,440]
trigger3 = movecontact

;---------------------------------------------------------------------------
;Ko-oh Ken ȣȲ 
[State -1, Light Kung Fu Palm]
type = ChangeState
value = 1010
triggerall = numproj = 0 && command = "QCF_y" && command != "holddown"
trigger1 = statetype != A && ctrl
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger2 = movecontact
trigger3 = stateno = [400,440]
trigger3 = movecontact

;---------------------------------------------------------------------------
;Air Ko-oh Ken ȣȲ 
[State -1, Light Kung Fu Palm]
type = ChangeState
value = 1600
triggerall = numproj = 0 && command = "QCF_x" && command != "holddown"
trigger1 = statetype = A && ctrl

;---------------------------------------------------------------------------
;Air Ko-oh Ken ȣȲ 
[State -1, Light Kung Fu Palm]
type = ChangeState
value = 1610
triggerall = numproj = 0 && command = "QCF_y" && command != "holddown"
trigger1 = statetype = A && ctrl

;---------------------------------------------------------------------------
;Zan retsu Ken ı 
[State -1, ZanretsuKen]
type = ChangeState
value = 1300
triggerall = command = "Zan_x" && command != "holddown"
trigger1 = statetype != A && ctrl
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger2 = movecontact
trigger3 = stateno = [400,440]
trigger3 = movecontact

;---------------------------------------------------------------------------
;Zan retsu Ken ı 
[State -1, ZanretsuKen]
type = ChangeState
value = 1310
triggerall = command = "Zan_y" && command != "holddown"
trigger1 = statetype != A && ctrl
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger2 = movecontact
trigger3 = stateno = [400,440]
trigger3 = movecontact

;---------------------------------------------------------------------------
;Kyokuken-Ryu Renmu ken ѷ  
[State -1, Renmuken]
type = ChangeState
value = 1500
triggerall = command = "HCB_x" && command != "holddown"
trigger1 = statetype != A && ctrl
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger2 = movecontact
trigger3 = stateno = [400,440]
trigger3 = movecontact

;---------------------------------------------------------------------------
;Kyokuken-Ryu Renmu ken ѷ  
[State -1, Renmuken]
type = ChangeState
value = 1510
triggerall = command = "HCB_y" && command != "holddown"
trigger1 = statetype != A && ctrl
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger2 = movecontact
trigger3 = stateno = [400,440]
trigger3 = movecontact

;---------------------------------------------------------------------------
;Hiensi Pukiaku ǳ 
[State -1, light hien kick]
type = ChangeState
value = 1200
triggerall = command = "Hien_a"
trigger1 = statetype != A && ctrl
trigger2 = stateno = [400,440]
trigger2 = movecontact

;---------------------------------------------------------------------------
;Hiensi Pukiaku ǳ 
[State -1, light hien kick]
type = ChangeState
value = 1210
triggerall = command = "Hien_b"
trigger1 = statetype != A && ctrl
trigger2 = stateno = [400,440]
trigger2 = movecontact

;---------------------------------------------------------------------------
;Raidensetsu ȣ 
[State -1, Raidensetsu]
type = ChangeState
value = 1400
triggerall = command = "F_upper_x"
trigger1 = statetype != A && ctrl
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger2 = movecontact
trigger3 = stateno = [400,440]
trigger3 = movecontact

;---------------------------------------------------------------------------
;Raidensetsu ȣ 
[State -1, Raidensetsu]
type = ChangeState
value = 1410
triggerall = command = "F_upper_y"
trigger1 = statetype != A && ctrl
trigger2 = (stateno = [200,215]) || stateno = 235 || stateno = 245
trigger2 = movecontact
trigger3 = stateno = [400,440]
trigger3 = movecontact

;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd  ޸
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back 뽬
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Punch Throw ָԴ(ֱ)
[State -1, Punch Throw]
type = ChangeState
value = 800
triggerall = command = "y"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 13
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 15
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H

;---------------------------------------------------------------------------
; Kick Throw  ߴ
[State -1, Punch Throw]
type = ChangeState
value = 850
triggerall = command = "b"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 13
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 15
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H

;===========================================================================
;---------------------------------------------------------------------------
; Rolling Escape ȸȸ
[State -1]
type = ChangeState
value = 350
triggerall = command = "escape" || command = "z"
trigger1 = ctrl && statetype != A
trigger2 = stateno = 100

;---------------------------------------------------------------------------
;Gauge Charge 
[State -1]
type = ChangeState
value = 900
triggerall = Power < 3000 && ctrl && statetype != A
trigger1 =  command = "charge"

;---------------------------------------------------------------------------
; Ice Braker ֱ
[State -1]
type = ChangeState
value = 300
triggerall = command = "fwd_x"
trigger1 = ctrl && statetype = S

;===========================================================================
;---------------------------------------------------------------------------
;Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = ifelse(P2BodyDist X > 20, 200, 205)
triggerall = command = "x" && command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time > 6

;---------------------------------------------------------------------------
;Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = ifelse(P2BodyDist X > 25, 210, 215)
triggerall = command = "y" && command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = ifelse(P2BodyDist X > 25, 230, 235)
triggerall = command = "a" && command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 230) && time > 12

;---------------------------------------------------------------------------
;Standing Strong Kick
[State -1, Standing Strong Kick]
type = ChangeState
value = ifelse(P2BodyDist X > 30, 240, 245)
triggerall = command = "b" && command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Strong Punch
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Light Kick
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Strong Kick
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = statetime >= 7

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Strong Kick
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact


