; Common state file

;---------------------------------------------------------------------------
; Stand
[Statedef 0]
type = S
physics = S
sprpriority = 2
velset=0,0
anim=0

[State 0, 1]
type = ChangeAnim
triggerall = numexplod(2025) = 0
trigger1 = (Anim != 0) && Anim != 5
trigger2 = Anim = 5 && AnimTime = 0
value = 0

[State 0, 1]
type = ChangeAnim
triggerall = numexplod(2025)
trigger1 = (Anim != 1) && Anim != 5
trigger2 = Anim = 5 && AnimTime = 0
value = 1

[State 0, 2]
type = VelSet
trigger1 = Time = 0
y = 0

[State 0,5]
type=DestroySelf
trigger1=Ishelper
;////////////////////////////////////////////////

[STate 0]
type=PosSet
trigger1=Time=0
y=0

[State 0]
type = PlaySnd
trigger1 = animelem = 28
value = 1,36
volume = 100
;---------------------------------------------------------------------------
; Stand to Crouch
[Statedef 10]
type    = C
physics = C
anim = 10
velset=0,0
sprpriority = 2            

[State 10, 2]
type = ChangeState
trigger1 = AnimTime = 0
value = 11

;---------------------------------------------------------------------------
; Crouching
[Statedef 11]
type    = C
physics = C
anim = 11
sprpriority = 2
velset=0,0

[State 11, 1] ;Change from turning animation
type = ChangeAnim
trigger1 = Anim = 6 && AnimTime = 0
value = 11


;---------------------------------------------------------------------------
; Crouch to Stand
[Statedef 12]
type    = S
physics = S
anim = 12
velset=0,0
sprpriority = 2            

[State 12, 1]
type = ChangeState
trigger1 = AnimTime = 0
value = 0

;---------------------------------------------------------------------------
; Walk
[Statedef 20]
type    = S
physics = S
sprpriority = 2
movetype=I
velset=0,0

[STate 20]
type = null;Width
trigger1 = 1
value = 10,0

[State 20, 1]
type = VelSet
trigger1 = command = "holdfwd"
x = const(velocity.walk.fwd.x)

[State 20, 2]
type = VelSet
trigger1 = command = "holdback"
x = const(velocity.walk.back.x)

[State 20, 3]
type = ChangeAnim
triggerall = vel x > 0
trigger1 = Anim != 20 && Anim != 5
trigger2 = Anim = 5 && AnimTime = 0
value = 20

[State 20, 4]
type = ChangeAnim
triggerall = vel x < 0
trigger1 = Anim != 21 && Anim != 5
trigger2 = Anim = 5 && AnimTime = 0
value = 21
;---------------------------------------------------------------------------
; Jump Start
[Statedef 40]
type    = S
physics = S
anim = 40
ctrl = 0
sprpriority = 2
velset=0,0

[State 40, 1]
type = varSet
trigger1 = Time = 0
sysvar(1) = 0

[State 40, 2]
type = varSet
trigger1 = command = "holdfwd"
sysvar(1) = 1

[State 40, 3]
type = varSet
trigger1 = command = "holdback"
sysvar(1) = -1

[State 40, 4]
type = VelSet
trigger1 = AnimTime = 0
x = ifelse(sysvar(1)=0, const(velocity.jump.neu.x), ifelse(sysvar(1)=1, const(velocity.jump.fwd.x), const(velocity.jump.back.x)))
y = const(velocity.jump.y)

[State 40, 4]
type = VelSet
trigger1 = AnimTime = 0&&command="holdup"&&prevstateno=100&&var(5)=0
x = 5.5*sysvar(1)

[State 40, 4]
type = VelSet
trigger1 = AnimTime = 0&&command!="holdup"&&prevstateno=100&&var(5)=0
x = 5.6*sysvar(1)

[State 40, 6]
type = ChangeState
trigger1 = AnimTime=0&&prevstateno=100;&&var(5)=0
trigger1=Command="holdup"
value = 56
ctrl = 1

[State 40, 6]
type = ChangeState
trigger1 = AnimTime=0&&prevstateno=100;&&var(5)=0
trigger1=Command!="holdup"
value = 55
ctrl = 1

[State 40, 6]
type = ChangeState
trigger1 = Time=0&&var(12)=1
value = 53

[State 40, 6]
type = ChangeState
trigger1 = AnimTime=0&&var(12)=0
trigger1=Command!="holdup"
value = 54
ctrl = 1

[State 40, 6]
type = ChangeState
trigger1 = AnimTime=0&&var(12)=0
trigger1=Command="holdup"
trigger2=Animtime=0
value = 50
ctrl = 1

;---------------------------------------------------------------------------
; AirJump Start
[Statedef 45]
type    = A
physics = N
ctrl = 0
velset = 0,0

[State 45, 1]
type = ChangeAnim
trigger1 = SelfAnimExist(44)
value = 44

[State 45, 2]
type = ChangeAnim
trigger1 = !SelfAnimExist(44)
value = 41

[State 45, 3]
type = varSet
trigger1 = Time = 0
sysvar(1) = 0

[State 45, 4]
type = varSet
trigger1 = command = "holdfwd"
sysvar(1) = 1

[State 45, 5]
type = varSet
trigger1 = command = "holdback"
sysvar(1) = -1

[State 45, 6]
type = VelSet
trigger1 = Time = 2
x = ifelse(sysvar(1)=0, const(velocity.airjump.neu.x), ifelse(sysvar(1)=1, const(velocity.airjump.fwd.x), const(velocity.airjump.back.x)))
y = const(velocity.airjump.y)

[State 45, 7]
type = ChangeState
trigger1 = Time = 2
value = 50
ctrl = 1

;---------------------------------------------------------------------------
; Jump Up
[Statedef 50]
type    = A
physics = A

[State 50, 1]
type = varSet
trigger1 = Time = 0
sysvar(1) = 0

[State 50, 2]
type = ChangeAnim
trigger1 = Time = 0
value = ifelse((vel x)=0, 41, ifelse((vel x)>0, 42, 43))

[State 50, 3]
type = ChangeAnim
trigger1 = Vel y > -2
trigger1 = SelfAnimExist(anim + 3)
persistent = 0
value = Anim + 3

[State 50,4]
type=PlaySnd
trigger1=Time=0
value=1,3
channel=5
;---------------------------------------------------------------------------
; Jump Down (empty state for compatibility)
[Statedef 51]
type    = A
physics = A

[State 51, 1]
type = Null
trigger1 = 1

;---------------------------------------------------------------------------
; Jump Land
[Statedef 52]
type    = S
physics = S
ctrl = 0
anim = 47

[State 52]
type = MakeDust
trigger1 = animelem = 1
pos = -10,0
spacing = 1

[State 52, 1]
type = VelSet
trigger1 = Time = 0
x = 0
y = 0

[State 52, 2]
type = PosSet
trigger1 = Time = 0
y = 0

[State 52,1]
type=Turn
trigger1=Time=0&&P2bodydist X<-40

[State 52, 3]
type = CtrlSet
trigger1 = Time = 1
value = 1

[State 52, 4]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1
[State 0,5]
type=DestroySelf
trigger1=Ishelper
[State 50,4]
type=PlaySnd
trigger1=Time=0
value=1,12
channel=5

;---------------------------------------------------------------------------
;偕Jump Start
[Statedef 53]
type    = S
physics = S
anim = 40
ctrl = 0
sprpriority = 2

[State 40, 1]
type = varSet
trigger1 = Time = 0
sysvar(1) = 0

;///////////////////////////////
[State 0, 1];WvUp
type = varSet
trigger1 = Time = 0
var(15) = 0

[State 0, 1];WvUp
type = varSet
trigger1 = command="x"
var(15) = 1

[State 0, 1];WvUp
type = varSet
trigger1 = command="y"
var(15) = 2

[State 0, 1];WvUp
type = varSet
trigger1 = command="z"; || command="ӂƂ΂"
var(15) = 3

[State 0, 1];WvUp
type = varSet
trigger1 = command="a"
var(15) = 4

[State 0, 1];WvUp
type = varSet
trigger1 = command="b"
var(15) = 5

[State 0, 1];WvUp
type = varSet
trigger1 = command="c"
var(15) = 6

;///////////////////////////////

[State 40, 2]
type = varSet
trigger1 = command = "holdfwd"
sysvar(1) = 1

[State 40, 3]
type = varSet
trigger1 = command = "holdback"
sysvar(1) = -1


[State 40, 4]
type = VelSet
trigger1 = AnimTime = 0&&command!="holdup"
x = 4.4*sysvar(1)

[State 40, 4]
type = VelSet
trigger1 = AnimTime = 0&&command="holdup"
x = 4.4*sysvar(1)

[State 40, 6]
type = ChangeState
trigger1 =animTime=0&&command!="holdup"
value = 55
ctrl = 1

[State 40, 6]
type = ChangeState
trigger1 =animTime=0&&command="holdup"
value = 56
ctrl = 1
;---------------------------------------------------------------------------
;Wv
[Statedef 54]
type    = A
physics = A
ctrl=1

[STate 53,0]
type=VelSet
trigger1=time=0
y=-6
persistent=0

[STate 53,0]
type=VelSet
trigger1=Command="holdfwd"
trigger1=Time=0
x=2
persistent=0

[STate 53,0]
type=VelSet
trigger1=Command="holdback"
trigger1=Time=0
x=-3
persistent=0

[STate 53,0]
type=Veladd
trigger1=1
y=.05

[State 50, 1]
type = varSet
trigger1 = Time = 0
sysvar(1) = 0

[State 50, 2]
type = ChangeAnim
trigger1 = Time = 0
value = ifelse((vel x)=0, 41, ifelse((vel x)>0, 42, 43))

[State 53, 3]
type = ChangeAnim
trigger1 = Vel y > -2
trigger1 = SelfAnimExist(anim + 3)
persistent = 0
value = Anim + 3

[State 50,4]
type=PlaySnd
trigger1=Time=0
value=1,3
channel=5

;---------------------------------------------------------------------------
;Wv
[Statedef 55]
type    = A
physics = A
ctrl=1

[STate 54,0]
type=VelSet
trigger1=time=0
y=-6
persistent=0

[State 40,3]
type=AfterImage
trigger1 = Time = 1&&Vel X!=0
time=20
length=8
trans=none
invartall = 1

[STate 53,0]
type=Veladd
trigger1=1
y=.05

[State 50, 1]
type = varSet
trigger1 = Time = 0
sysvar(1) = 0

;/////////////////////////////////////
[State 54, 2]
type = Changestate
trigger1 = var(15) != 0
trigger1 = Time = 0
trigger1 = var(15) = 1
value = 600

[State 54, 2]
type = Changestate
trigger1 = var(15) != 0
trigger1 = Time = 0
trigger1 = var(15) = 2
value = 610

[State 54, 2]
type = Changestate
trigger1 = var(15) != 0
trigger1 = Time = 0
trigger1 = var(15) = 4
value = ifelse(vel X = 0,630,635)

[State 54, 2]
type = Changestate
trigger1 = var(15) != 0
trigger1 = Time = 0
trigger1 = var(15) = 5
value = 640

;/////////////////////////////////////
[State 54, 2]
type = ChangeAnim
trigger1 = Time = 0
value = ifelse((vel x)=0, 41, ifelse((vel x)>0, 42, 43))

[State 53, 3]
type = ChangeAnim
trigger1 = Vel y > -2
trigger1 = SelfAnimExist(anim + 3)
persistent = 0
value = Anim + 3

[State 50,4]
type=PlaySnd
trigger1=Time=0&&Vel X=0
value=1,3
channel=5

[State 50,4]
type=PlaySnd
trigger1=Time=0&&Vel X!=0
value=1,4
channel=5
;---------------------------------------------------------------------------
;Wv
[Statedef 56]
type    = A
physics = N
ctrl=1

[STate 54,0]
type=VelSet
trigger1=time=0
x = 5*(sysvar(1))
y=const(velocity.jump.y)-1
persistent=0

[State 55,2]
type=VelAdd
trigger1=1
y=.5

[State 50, 1]
type = varSet
trigger1 = Time = 0
sysvar(1) = 0

;/////////////////////////////////////
[State 54, 2]
type = Changestate
trigger1 = var(15) != 0
trigger1 = Time = 0
trigger1 = var(15) = 1
value = 600

[State 54, 2]
type = Changestate
trigger1 = var(15) != 0
trigger1 = Time = 0
trigger1 = var(15) = 2
value = 610

[State 54, 2]
type = Changestate
trigger1 = var(15) != 0
trigger1 = Time = 0
trigger1 = var(15) = 4
value = ifelse(vel X = 0,630,635)

[State 54, 2]
type = Changestate
trigger1 = var(15) != 0
trigger1 = Time = 0
trigger1 = var(15) = 5
value = 640

;/////////////////////////////////////

[State 54, 2]
type = ChangeAnim
trigger1 = Time = 0
value = ifelse((vel x)=0, 41, ifelse((vel x)>0, 42, 43))

[State 53, 3]
type = ChangeAnim
trigger1 = Vel y > -2
trigger1 = SelfAnimExist(anim + 3)
persistent = 0
value = Anim + 3

[State 50,4]
type=PlaySnd
trigger1=Time=0&&Vel X=0
value=1,3
channel=5

[State 50,4]
type=PlaySnd
trigger1=Time=0&&Vel X!=0
value=1,4
channel=5

[STate 53,5]
type=AfterImage
trigger1=Time=3&&Vel X!=0
time=30
trans=Add1
length=9
[State 55,5]
type=Changestate
trigger1=Pos Y>=0&Vel Y>0
value=52
;---------------------------------------------------------------------------
; RUN_FWD
[Statedef 100]
type    = S
physics = S
anim = 100
sprpriority = 2
velset=0,0

[State 100]
type = ChangeAnim
trigger1 = time = 0 && fvar(29) != 1
value = 101

[State 100]
type = playsnd
trigger1 = animelem = 2 && anim = 100
value = 1,0
volume = 200

[State 100]
type = playsnd
triggerall = anim = 101
trigger1 = animelem = 2
trigger2 = animelem = 2,>= 0
trigger2 = timemod = 32,0
value = 1,55
volume = 100
channel = 6

[State 100]
type = MakeDust
trigger1 = animelem = 2
pos = -10,0
spacing = 1

[State 100, 1]
type = VelSet
trigger1 = anim = 100
trigger1 = animelem = 2,>= 0
trigger1 = animelem = 5,<= 0
x = const(velocity.run.fwd.x)

[State 100, 1]
type = VelSet
triggerall = anim = 101
triggerall = animelem = 2,>= 0
trigger1 = command = "holdfwd"
trigger2 = var(1)
x = const(velocity.run.fwd.x)-2

[State 100, 1]
type = VelSet
trigger1 = animelem = 6 && anim = 100
x = 0

[State 100, 2] ;Prevent run from canceling into walk
type = AssertSpecial
trigger1 = 1
flag = NoWalk

[State 100, 3] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 100, 4]
type = ChangeState
triggerall = vel X > 0
trigger1 = command = "holdup"
value = 53

[State 100, 4]
type = ChangeState
triggerall = vel X > 0
trigger1 = command = "x"
trigger2 = var(1) && var(23) = [0,20]
value = 515

[State 100, 4]
type = ChangeState
triggerall = vel X > 0
trigger1 = command = "y"
trigger2 = var(1) && var(23) = [100,120]
value = 535

[State 100, 4]
type = ChangeState
triggerall = vel X > 0
trigger1 = command = "a"
trigger2 = var(1) && var(23) = [200,220]
value = 520

[State 100, 4]
type = ChangeState
triggerall = vel X > 0
trigger1 = command = "b"
trigger2 = var(1) && var(23) = [300,320]
value = 540

[State 100]
type = changestate
trigger1 = animtime = 0 && anim = 100
value = 0
ctrl = 1

[State 100]
type = changestate
triggerall = anim = 101
triggerall = animelem = 2,>= 0
triggerall = time >= 10
trigger1 = p2bodydist X <= 0
trigger2 = var(1) = 0 && command != "holdfwd"
trigger3 = var(1) && time >= 30
value = 101

;---------------------------------------------------------------------------
;Xgbv
[Statedef 101]
type    = S
physics = S
ctrl = 0
anim = 102
sprpriority = 2

[State 101]
type = playsnd
triggerall = anim = 102
trigger1 = time = 1
value = 1,56
volume = 100
channel = 6

[State 101]
type = MakeDust
trigger1 = timemod = 5,0
pos = 30,0
spacing = 1

[STate 101,2]
type = Changestate
trigger1 = animtime = 0
value = 0
ctrl = 1
;---------------------------------------------------------------------------
; RUN_BACK
[Statedef 105]
type    = S
physics = N
ctrl = 0
anim = 105
sprpriority = -2

[State 105, 1]
type = VelSet
trigger1 = animelem=1
x = -6
y = -4

[STate 105]
type=gravity
trigger1=1

[State 105, 3]
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= -1
value = 106

[State 105,4]
type=NotHitBy
trigger1=1
value=SAC

[State 105]
type = playsnd
trigger1 = animelem = 1
value = 1,17
volume = -50

[State 105]
type = playsnd
trigger1 = animelem = 1 && random <= 333
value = 0,49
volume = -100

[State 101,3]
type=AfterImage
trigger1=Time=0
time=10
trans=add1
length=8
;---------------------------------------------------------------------------
; RUN_BACK2 (land)
[Statedef 106]
type    = S
physics = S
velset=0,0
ctrl = 0
anim = 106

[State 101,3]
type=AfterImagetime
trigger1=Time=0
time=0

[State 106, 2]
type = PosSet
trigger1 = Time = 0
y = 0

[State 106, 3]
type = MakeDust
trigger1 = Time = 2
pos = -5,-2
spacing = 1

[State 106, 4]
type = ChangeState
trigger1 = animtime=0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; RUN_UP
[Statedef 110]
type    = S
physics = N

[State 110, 0]
type = CtrlSet
trigger1 = Time = 0
value = 0

[State 110, 1]
type = ChangeAnim
trigger1 = Time = 0
value = 110

[State 110, 2]
type = HitBy
trigger1 = Time = 0
value = SCA, NT, ST, HT
time = 30

[State 110, 3]
type = VelSet
trigger1 = Time = 0
x = 0
z = -7

[State 110, 4]
type = VelMul
trigger1 = 1
z = 0.8

[State 110, 5]
type = VelSet
trigger1 = AnimTime = -8
z = 0

[State 110, 7]
type = CtrlSet
trigger1 = AnimTime = 0
value = 1

[State 110, 8]
type = ChangeState
trigger1 = AnimTime = 0
value = 0

;---------------------------------------------------------------------------
; RUN_DOWN
[Statedef 115]
type    = S
physics = N

[State 115, 0]
type = CtrlSet
trigger1 = Time = 0
value = 0

[State 115, 1]
type = ChangeAnim
trigger1 = Time = 0
value = 110

[State 115, 2]
type = HitBy
trigger1 = Time = 0
value = SCA, NT, ST, HT
time = 30

[State 115, 3]
type = VelSet
trigger1 = Time = 0
x = 0
z = 7

[State 115, 4]
type = VelMul
trigger1 = 1
z = 0.8

[State 115, 5]
type = VelSet
trigger1 = AnimTime = -8
z = 0

[State 115, 7]
type = CtrlSet
trigger1 = AnimTime = 0
value = 1

[State 115, 8]
type = ChangeState
trigger1 = AnimTime = 0
value = 0

;---------------------------------------------------------------------------
; GUARD (start)
[Statedef 120]
type = U    ;Leave state type unchanged
physics = U ;Leave physics unchanged

[State 120, 1]
type = ChangeAnim
trigger1 = Time = 0
value = 120 + (statetype = C) + (statetype = A)*2

[State 120, 2]
type = StateTypeSet
trigger1 = Time = 0 && statetype = S
physics = S

[State 120, 3]
type = StateTypeSet
trigger1 = Time = 0 && statetype = C
physics = C

[State 120, 4]
type = StateTypeSet
trigger1 = Time = 0 && statetype = A
physics = A

[State 120, 5]
type = ChangeState
trigger1=Var(13)!=0&&Statetype=S
trigger1 = Time = 0
value = 0
ctrl=1

[State 120, 5]
type = ChangeState
trigger1=Var(13)!=0&&Statetype=C
trigger1 = Time = 0
value = 11
ctrl=1

[State 120, 5]
type = ChangeState
trigger1=Var(13)!=0&&Statetype=A
trigger1 = Time = 0
value = 50
ctrl=1

[State 120, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 130 + (statetype = C) + (statetype = A)*2

;---------------------------------------------------------------------------
; STAND GUARD (guarding)
[Statedef 130]
type    = S
physics = S

[State 130, 1]
type = ChangeAnim
trigger1 = Anim != 130
value = 130

;---------------------------------------------------------------------------
; CROUCH GUARD (guarding)
[Statedef 131]
type    = C
physics = C

[State 131, 1]
type = ChangeAnim
trigger1 = Anim != 131
value = 131

;---------------------------------------------------------------------------
; AIR GUARD (guarding)
[Statedef 132]
type    = A
physics = N

[State 132, 1]
type = ChangeAnim
trigger1 = Anim != 132
value = 132

[State 132, 2]
type = VelAdd
trigger1 = 1
y = Const(movement.yaccel)

[State 132, 3]
type = varSet
trigger1 = 1
sysvar(0) = (pos y >= 0) && (vel y > 0)

[State 132, 4]
type = VelSet
trigger1 = sysvar(0)
y = 0

[State 132, 5]
type = PosSet
trigger1 = sysvar(0)
y = 0

[State 132, 6]
type = ChangeState
trigger1 = sysvar(0)
trigger1 = command != "holdback"
value = 52

[State 132, 7]
type = ChangeState
trigger1 = sysvar(0)
value = 130

;---------------------------------------------------------------------------
; GUARD (end)
[Statedef 140]
type = U    ;Leave state type unchanged
physics = U ;Leave physics unchanged
ctrl = 1

[State 140, 1]
type = ChangeAnim
trigger1 = Time = 0
value = 140 + (statetype = C) + (statetype = A)*2

[State 140, 2]
type = StateTypeSet
trigger1 = Time = 0 && statetype = S
physics = S

[State 140, 3]
type = StateTypeSet
trigger1 = Time = 0 && statetype = C
physics = C

[State 140, 4]
type = StateTypeSet
trigger1 = Time = 0 && statetype = A
physics = A

;[State 140, 5] ;Implemented within engine
;type = ChangeState
;trigger1 = AnimTime = 0
;value = (statetype = C)*11 + (statetype = A)*51

;---------------------------------------------------------------------------
; SGUARDHIT (shaking)
[Statedef 150]
type    = S
movetype= H
physics = N
velset = 0,0

[State 150, 1]
type = ChangeAnim
trigger1 = 1
value = 150

[State 150, 2]
type = ChangeState
trigger1 = HitShakeOver
value = 151

[State 150, 3]
type = ForceFeedback
trigger1 = time = 0
waveform = square
time = 3

;---------------------------------------------------------------------------
; SGUARDHIT2 (knocked back)
[Statedef 151]
type    = S
movetype= H
physics = S
anim = 150

[State 151, 1]
type = HitVelSet
trigger1 = Time = 0
x = 1

[State 151, 2]
type = VelSet
trigger1 = Time = GetHitvar(slidetime)
trigger2 = Time >= GetHitvar(hittime)
x = 0

[State 151, 3]
type = CtrlSet
trigger1 = Time = GetHitvar(ctrltime)
value = 1

[State 151, 4]
type = ChangeState
trigger1 = Time >= GetHitvar(hittime)
value = 130
ctrl = 1

;---------------------------------------------------------------------------
; CGUARDHIT (shaking)
[Statedef 152]
type    = C
movetype= H
physics = N
velset = 0,0

[State 152, 1]
type = ChangeAnim
trigger1 = 1
value = 151

[State 152, 3]
type = ChangeState
trigger1 = HitShakeOver
value = 153

[State 152, 4]
type = ForceFeedback
trigger1 = time = 0
waveform = square
time = 4

;---------------------------------------------------------------------------
; CGUARDHIT2 (knocked back)
[Statedef 153]
type    = C
movetype= H
physics = C
anim = 151

[State 153, 1]
type = HitVelSet
trigger1 = Time = 0
x = 1

[State 153, 2]
type = VelSet
trigger1 = Time = GetHitvar(slidetime)
trigger2 = Time >= GetHitvar(hittime)
x = 0

[State 153, 3]
type = CtrlSet
trigger1 = Time = GetHitvar(ctrltime)
value = 1

[State 153, 4]
type = ChangeState
trigger1 = Time >= GetHitvar(hittime)
value = 131
ctrl = 1

;---------------------------------------------------------------------------
; AGUARDHIT (shaking)
[Statedef 154]
type    = A
movetype= H
physics = N
velset = 0,0

[State 154, 1]
type = ChangeAnim
trigger1 = 1
value = 152

[State 154, 2]
type = ChangeState
trigger1 = HitShakeOver
value = 155 ;AGUARDHIT2

[State 154, 3]
type = ForceFeedback
trigger1 = time = 0
waveform = square
time = 4

;---------------------------------------------------------------------------
; AGUARDHIT2 (knocked away)
[Statedef 155]
type    = A
movetype= H
physics = N
anim = 152

[State 155, 1]
type = HitVelSet
trigger1 = Time = 0
x = 1
y = 1

[State 155, 2]
type = VelAdd
trigger1 = 1
y = Const(movement.yaccel)

[State 155, 3]
type = CtrlSet
trigger1 = Time = GetHitvar(ctrltime)
value = 1

[State 155, 4]
type = varSet
trigger1 = 1
sysvar(0) = (pos y >= 0) && (vel y > 0)

[State 155, 5]
type = VelSet
trigger1 = sysvar(0)
y = 0

[State 155, 6]
type = PosSet
trigger1 = sysvar(0)
y = 0

[State 155, 7]
type = ChangeState
trigger1 = sysvar(0)
trigger1 = command != "holdback"
value = 52

[State 155, 8]
type = ChangeState
trigger1 = sysvar(0)
value = 130

;---------------------------------------------------------------------------
; LOSE (Time over)
[Statedef 170]
type = S
ctrl = 0
anim = 170
velset = 0,0

[State 170, 1]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

;---------------------------------------------------------------------------
; DRAWGAME (Time over)
[Statedef 175]
type = S
ctrl = 0
velset = 0,0

[State 175, 1] ; If no anim, use go to lose state.
type = ChangeState
trigger1 = Time = 0
trigger1 = !SelfAnimExist(175)
value = 170

[State 175, 2]
type = ChangeAnim
trigger1 = Time = 0
value = 175

[State 175, 3]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

;---------------------------------------------------------------------------
; PREINTRO
[Statedef 190]
type = S
ctrl = 0
velset = 0,0

[State 190, 1]
type = ChangeAnim
trigger1 = SelfAnimExist(190)
value = 190

;--------------------------------------

[State 190, 2] ;Go straight to intro.
type = ChangeState
trigger1 = Time = 0
value = 191

;---------------------------------------------------------------------------
; HITG_SHAKE
[Statedef 5000]
type    = S
movetype= H
physics = N
velset = 0,0

[State 5000, 1] ;Anim for HIT_LIGHT to HIT_HARD
type = ChangeAnim
trigger1 = Time = 0
trigger1 = GetHitvar(animtype) != [3,5]
value = ifelse((GetHitvar(groundtype) = 1),5000,5010) + GetHitvar(animtype)

[State 5000, 2] ;Anim for HIT_BACK
type = ChangeAnim
trigger1 = Time = 0
trigger1 = GetHitvar(animtype) = [3,5]
value = 5030

[State 5000, 3] ;Anim for HIT_UP/HIT_DIAGUP (only if it exists)
type = ChangeAnim
trigger1 = Time = 0
trigger1 = (GetHitvar(animtype) = [4,5]) && (SelfAnimExist(5047 + GetHitvar(animtype)))
value = 5047 + GetHitvar(animtype) ;5051 - 4 + type

[State 5000, 4] ;Freeze anim
type = ChangeAnim
trigger1 = Time > 0
value = anim

[State 5000, 5] ;State type gets set to aerial if getting hit up
type = StateTypeSet
trigger1 = Time = 0
trigger1 = GetHitvar(yvel) != 0 && GetHitvar(fall)
trigger2 = Pos Y != 0
type = a

[State 5000, 6]
type = ChangeState
trigger1 = HitShakeOver
trigger1 = GetHitvar(yvel) = 0
value = 5001 ;HITG_SLIDE

[State 5000, 7]
type = ChangeState
trigger1 = HitShakeOver
value = 5030

[State 5000, FFB Light]
type = ForceFeedback
trigger1 = anim = 5000
trigger2 = anim = 5010
persistent = 0
time = 6
waveform = square

[State 5000, FFB Medium]
type = ForceFeedback
trigger1 = anim = 5001
trigger2 = anim = 5011
persistent = 0
time = 8
waveform = sinesquare
ampl = 110,-1,-.3

[State 5000, FFB Hard]
type = ForceFeedback
trigger1 = anim = 5012
trigger2 = anim = 5002
trigger3 = anim = 5030
persistent = 0
time = 15
waveform = sinesquare
ampl = 140

[State 5000,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HITG_SLIDE
[Statedef 5001]
type    = S
movetype= H
physics = S

[State 5001, 1]
type = HitVelSet
trigger1 = Time = 0
x = 1

[State 5001, 2]
type = ChangeAnim
trigger1 = AnimTime = 0
value = 5005 + GetHitvar(animtype) + (GetHitvar(groundtype)=2)*10

[State 5001, 3] ;Stop sliding back
type = VelMul
trigger1 = Time >= GetHitvar(slidetime)
x = .6

[State 5001, 4]
type = VelSet
trigger1 = HitOver
x = 0

[State 5001, 5]
type = DefenceMulSet
trigger1 = HitOver
value = 1

[State 5001, 6]
type = ChangeState
trigger1 = HitOver
value = 0
ctrl = 1

[State 5001,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HITC_SHAKE
[Statedef 5010]
type    = C
movetype= H
physics = N
velset = 0,0

[State 5010, 1] ;Anim for HIT_LIGHT to HIT_HARD
type = ChangeAnim
trigger1 = Time = 0
trigger1 = GetHitvar(animtype) != [3,5]
value = 5020 + GetHitvar(animtype)

[State 5010, 2] ;Anim for HIT_BACK
type = ChangeAnim
trigger1 = Time = 0
trigger1 = GetHitvar(animtype) = [3,5]
value = 5030

[State 5010, 3] ;Anim for HIT_UP/HIT_DIAGUP (only if it exists)
type = ChangeAnim
trigger1 = Time = 0
trigger1 = (GetHitvar(animtype) = [4,5]) && (SelfAnimExist(5047 + GetHitvar(animtype)))
value = 5047 + GetHitvar(animtype) ;5051 - 4 + type

[State 5010, 4] ;Freeze anim
type = ChangeAnim
trigger1 = Time > 0
value = anim

[State 5010, 5]
type = ChangeState
trigger1 = HitShakeOver
trigger1 = GetHitvar(yvel) = 0
value = 5011 ;HITC_SLIDE

[State 5010, 6]
type = ChangeState
trigger1 = HitShakeOver
value = 5030

[State 5010, FFB Light]
type = ForceFeedback
trigger1 = anim = 5020
persistent = 0
time = 6
waveform = square

[State 5010, FFB Medium]
type = ForceFeedback
trigger1 = anim = 5021
persistent = 0
time = 8
waveform = sinesquare
ampl = 110,-1,-.3

[State 5010, FFB Hard]
type = ForceFeedback
trigger1 = anim = 5022
persistent = 0
time = 15
waveform = sinesquare
ampl = 140

[State 5010,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HITC_SLIDE
[Statedef 5011]
type    = C
movetype= H
physics = C

[State 5011, 1]
type = HitVelSet
trigger1 = Time = 0
x = 1

[State 5011, 2]
type = ChangeAnim
trigger1 = AnimTime = 0
value = 5025 + GetHitvar(animtype)

[State 5011, 3] ;Stop sliding back
type = VelMul
trigger1 = Time >= GetHitvar(slidetime)
x = .6

[State 5011, 4]
type = VelSet
trigger1 = HitOver
x = 0

[State 5011, 5]
type = DefenceMulSet
trigger1 = HitOver
value = 1

[State 5011, 6]
type = ChangeState
trigger1 = HitOver
value = 11
ctrl = 1

[State 5011,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HITA_SHAKE
[Statedef 5020]
type    = A
movetype= H
physics = N
velset = 0,0

[State 5020, 1] ;Anim for HIT_LIGHT to HIT_HARD
type = ChangeAnim
trigger1 = Time = 0
trigger1 = GetHitvar(animtype) != [3,5]
value = ifelse((GetHitvar(airtype) = 1),5000,5010) + GetHitvar(animtype)

[State 5020, 2] ;Anim for HIT_BACK
type = ChangeAnim
trigger1 = Time = 0
trigger1 = GetHitvar(animtype) = [3,5]
value = 5030

[State 5020, 3] ;Anim for HIT_UP/HIT_DIAGUP (only if it exists)
type = ChangeAnim
trigger1 = Time = 0
trigger1 = (GetHitvar(animtype) = [4,5]) && (SelfAnimExist(5047 + GetHitvar(animtype)))
value = 5047 + GetHitvar(animtype) ;5051 - 4 + type

[State 5020, 4] ;Freeze anim
type = ChangeAnim
trigger1 = Time > 0
value = anim

[State 5020, 5]
type = ChangeState
trigger1 = HitShakeOver
value = 5030

[State 5020, FFB Light]
type = ForceFeedback
trigger1 = anim = 5000
trigger2 = anim = 5010
persistent = 0
time = 6
waveform = square

[State 5020, FFB Medium]
type = ForceFeedback
trigger1 = anim = 5001
trigger2 = anim = 5011
persistent = 0
time = 8
waveform = sinesquare
ampl = 110,-1,-.3

[State 5020, FFB Hard]
type = ForceFeedback
trigger1 = anim = 5012
trigger2 = anim = 5002
trigger3 = anim = 5030
trigger4 = anim = [5051,5059]
persistent = 0
time = 15
waveform = sinesquare
ampl = 140

[State 5020,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HITA_UP (initial going up)
[Statedef 5030]
type    = A
movetype= H
physics = N
ctrl = 0

[State 5030, 1]
type = VelAdd;Gravity
trigger1 = 1
y = GetHitvar(yaccel)

[State 5030, 2]
type = HitVelSet
trigger1 = Time = 0
x = 1
y = 1

[State 5030, 3]
type = ChangeState
triggerall = !HitFall
trigger1 = HitOver
trigger2 = Vel Y > 0    ;Hit ground
trigger2 = Pos Y >= 10  ;.
value = 5040 ;HITA_RECOV

[State 5030, 4]
type = ChangeState
triggerall = HitFall
trigger1 = HitOver
trigger2 = Vel Y > 0    ;Hit ground
trigger2 = Pos Y >= 10  ;.
value = 5050 ;HITA_FALL

[State 5030, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 5035 ;HITA_UP (transition)

[State 5030,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HITA_UP_T (transition)
[Statedef 5035]
type    = A
movetype= H
physics = N

[State 5035, 1]
type = ChangeAnim
trigger1 = Time = 0
trigger1 = SelfAnimExist(5035)
trigger1 = Anim != [5051,5059] ;Not if in hit up anim
trigger1 = Anim != 5090 ;Not if hit off ground anim
value = 5035

[State 5035, 2]
type = VelAdd
trigger1 = 1
y = GetHitvar(yaccel)

[State 5035, 3]
type = ChangeState
triggerall = !HitFall
trigger1 = HitOver  ;Hit is over
trigger2 = AnimTime = 0 ;Animation over
trigger3 = Vel Y > 0    ;Hit ground
trigger3 = Pos Y >= 10  ;.
trigger4 = Time = 0     ;No transition anim
trigger4 = Anim != 5035 ;.
value = 5040 ;HITA_RECOV

[State 5035, 4]
type = ChangeState
triggerall = HitFall
trigger1 = HitOver  ;Hit is over
trigger2 = AnimTime = 0 ;Anim is over
trigger3 = Vel Y > 0    ;Hit ground
trigger3 = Pos Y >= 10  ;.
trigger4 = Time = 0     ;No transition anim
trigger4 = Anim != 5035 ;.
value = 5050 ;HITA_FALL

[State 5035,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HITA_RECOV (recovering in air, not falling)
[Statedef 5040]
type    = A
movetype= H
physics = N

[State 5040, 1]
type = ChangeState
trigger1 = !Alive
value = 5050

[State 5040, 2]
type = ChangeAnim
trigger1 = AnimTime = 0
trigger1 = Anim != 5040
trigger2 = Time = 0
trigger2 = Anim != 5035
value = 5040

[State 5040, 3]
type = CtrlSet
trigger1 = HitOver
value = 1

[State 5040, 4]
type = StateTypeSet
trigger1 = HitOver
movetype = I

[State 5040, 5]
type = VelAdd
trigger1 = 1
y = GetHitvar(yaccel)

[State 5040, 6]
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value = 52 ;JUMPLAND

[State 5040,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HITA_FALL (knocked up, falling)
[Statedef 5050]
type    = A
movetype= H
physics = N

[State 5050, 1] ;Change anim when done with transition
type = ChangeAnim
trigger1 = AnimTime = 0
trigger1 = Anim = 5035
trigger2 = Time = 0     ;If no transition anim
trigger2 = Anim != 5035
trigger2 = (Anim != [5051, 5059]) && (Anim != [5061, 5069])
trigger2 = Anim != 5090 ;Not if hit off ground anim
value = 5050

[State 5050, 2] ;Coming down anim
type = ChangeAnim
trigger1 = anim = [5050,5059]
trigger1 = Vel Y >= ifelse(anim = 5050, 1, -2)
trigger1 = SelfAnimExist(anim+10)
value = anim+10
persistent = 0

[State 5050, 3] ;Gravity
type = VelAdd
trigger1 = 1
y = GetHitvar(yaccel)

[State 5071,2]
type=Changestate
triggerall=Alive
triggerall=Canrecover
triggerall=Command="recovery"||Command="c"
triggerall= Vel Y > 0
trigger1 = Pos Y =[-20,15]
value=3999

[State 5071,2]
type=Changestate
triggerall=Alive&&var(1)=1
triggerall=Canrecover
triggerall= Vel Y > 0&&Random<=111
trigger1 = Pos Y =[-20,15]
value=3999

[State 5050, 4] ;Recover near ground
type = ChangeState
triggerall = Vel Y > 0
triggerall = Pos Y >= -20
triggerall = alive
triggerall = CanRecover
trigger1 = Command = "recovery" || Command = "c"
trigger2 = var(1) && fvar(24) && (var(23) = [100,333])
value = 5200 ;HITFALL_RECOVER

[State 5050, 5]; Recover in mid air
type = ChangeState
triggerall = Vel Y > -1
triggerall = alive
triggerall = CanRecover
trigger1 = Command = "recovery" || Command = "c"
trigger2 = var(1) && fvar(24) && (var(23) = [100,333])
value = 5210 ;HITFALL_AIRRECOVER

[State 5050, 6]
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= ifelse((anim = [5051,5059]) || (anim = [5061,5069]), 15, 10)
value = 5100 ;HIT_BOUNCE

[State 5050,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HIT_TRIP (shaking)
[Statedef 5070]
type    = A
movetype= H
physics = N
velset = 0,0

[State 5070, 1]
type = ChangeAnim 
trigger1 = 1
value = 5070

[State 5070, 2]
type = ChangeState
trigger1 = HitShakeOver
value = 5071

[State 5070, 3]
type = ForceFeedback
trigger1 = time = 0
time = 12
waveform = sinesquare
ampl = 140

[State 5070,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HIT_TRIP2 (fall through air)
[Statedef 5071]
type    = A
movetype= H
physics = N

[State 5071, 1]
type = HitVelSet
trigger1 = Time = 0
x = 1
y = 1

[State 5071, 2] ;Acceleration
type = VelAdd
trigger1 = 1
y = GetHitvar(yaccel)

[State 5071,2]
type=Changestate
triggerall=Alive
triggerall=Canrecover
triggerall=Command="recovery"||Command="c"
triggerall= Vel Y > 0
trigger1 = Pos Y =[-10,15]
value=3999

[State 5071,2]
type=Changestate
triggerall=Alive&&var(1)=1
triggerall=Canrecover
triggerall= Vel Y > 0&&Random<=111
trigger1 = Pos Y =[-10,15]
value=3999

[State 5071, 3] ;Hit ground
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 15
type = ChangeState
value = 5110

[State 5071,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HITL_SHAKE
[Statedef 5080]
type    = L
movetype= H
physics = N
velset = 0,0

[State 5080, 1] ;Set default anim
type = varSet
trigger1 = time = 0
sysvar(2) = ifelse (GetHitvar(yvel) = 0, 5080, 5090)

[State 5080, 2]
type = varAdd
trigger1 = time = 0
trigger1 = (anim = [5081,5089]) || (anim = [5111,5119])
trigger1 = SelfAnimExist(sysvar(2) + (anim % 10))
sysvar(2) = anim % 10

[State 5080, 3] ;If 5090 doesn't exist, default to 5030
type = varSet
trigger1 = time = 0
trigger1 = sysvar(2) = 5090
trigger1 = !SelfAnimExist(5090)
sysvar(2) = 5030

[State 5080, 3] ;Freeze
type = ChangeAnim
trigger1 = 1
value = sysvar(2)

[State 5080, 4]
type = ChangeState
trigger1 = HitShakeOver
trigger1 = GetHitvar(yvel) = 0
value = 5081 ;HITL_SLIDE

[State 5080, 5]
type = ChangeState
trigger1 = HitShakeOver
trigger1 = GetHitvar(yvel) != 0
value = 5030 ;HITA_UP

[State 5080,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HITL_SLIDE
[Statedef 5081]
type    = L
movetype= H
physics = C

[State 5081, 1]
type = HitVelSet
trigger1 = Time = 0
x = 1

[State 5081, 2]
type = VelSet
trigger1 = HitOver
x = 0

[State 5081, 3] ;Don't show hit ground frame
type = varSet
trigger1 = Time = 0
sysvar(0) = 1

[State 5081, 4]
type = ChangeState
trigger1 = HitOver
value = 5110 ;HIT_LIEDOWN

[State 5081,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HIT_BOUNCE (hit ground)
[Statedef 5100]
type    = L
movetype= H
physics = N

[State 5100, 1]
type = VelSet
trigger1 = Time = 0
trigger1 = GetHitvar(fall.yvel) = 0
trigger1 = vel x > 1
x = 1

[State 5100, EnvShake]
type = FallEnvShake
trigger1 = Time = 0

[State 5100, var] ;Save fall velocity
type = varSet
trigger1 = Time = 0
;trigger1 = GetHitvar(fall.yvel) = 0
sysvar(1) = floor(vel y)

[State 5100, 2] ;Hit ground anim (normal)
type = ChangeAnim
triggerall = time = 0
trigger1 = (anim != [5051,5059]) && (anim != [5061,5069])
trigger2 = !SelfAnimExist(5100 + (anim % 10))
value = 5100

[State 5100, 3] ;Hit ground anim (for hit up)
type = ChangeAnim
trigger1 = time = 0
trigger1 = (anim = [5051,5059]) || (anim = [5061,5069])
trigger1 = SelfAnimExist(5100 + (anim % 10))
value = 5100 + (anim % 10)

[State 5100, 4]
type = PosSet
trigger1 = Time = 0
y = 0

[State 5100, 5]
type = VelSet
trigger1 = Time = 0
y = 0

[State 5100, 6] ;Reduce speed
type = VelMul
trigger1 = Time = 0
x = 0.75

[State 5100, 7]
type = ChangeState
trigger1 = Time = 0
trigger1 = GetHitvar(fall.yvel) = 0
value = 5110 ;HIT_LIEDOWN

[State 5100, 8]
type = null;GameMakeAnim
trigger1 = Time = 1
;value = 61
;pos = 0, 0
;under = 1
value = 88;60 + (sysvar(1) > 5) + (sysvar(1) > 14)
pos = 0, 0
under = sysvar(1) <= 10

[State 5100]
type = Explod
trigger1 = Time = 1
anim = 88
pos = 0,0
sprpriority = -3
ownpal = 1

[State 5100, 9]
type = HitFallDamage
trigger1 = Time = 3

[State 5100, 10]
type = PlaySnd
trigger1 = Time = 1
;value = F7, 0 ;Hit ground
value = 1,2;F7, (sysvar(1) > 5) + (sysvar(1) > 14)

[State 5100, 11]
type = PosFreeze
trigger1 = 1

[State 5100, 12]
type = ChangeState
trigger1 = AnimTime = 0
value = 5101

[State 5100, 13]
type = ForceFeedback
trigger1 = Time = 0
waveform = sinesquare
ampl = 128,-3,-.2,.005
time = 20

[State 5100,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HIT_BOUNCE (bounce into air)
[Statedef 5101]
type    = L
movetype= H
physics = N

[State 5101, 1] ;Coming hit ground anim (normal)
type = ChangeAnim
triggerall = time = 0
trigger1 = anim != [5101,5109]
trigger2 = !SelfAnimExist(5160 + (anim % 10))
value = 5160

[State 5101, 2] ;Coming hit ground anim (for hit up)
type = ChangeAnim
triggerall = time = 0
trigger1 = anim = [5101,5109]
trigger1 = SelfAnimExist(5160 + (anim % 10))
value = 5160 + (anim % 10)

[State 5101, 3]
type = HitFallVel
trigger1 = Time = 0

[State 5101, 4]
type = PosSet
trigger1 = Time = 0
y = 20

[State 5101, 5] ;Acceleration
type = VelAdd
trigger1 = 1
y = .4

[State 5101, 6] ;Hit ground
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 12
type = ChangeState
value = 5110

[State 5101,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HIT_LIEDOWN
[Statedef 5110]
type    = L
movetype= H
physics = N

[State 5110, EnvShake]
type = FallEnvShake
trigger1 = Time = 0

[State 5110, 1] ;For hit up/up-diag type (from state 5081)
type = ChangeAnim
persistent = 0
trigger1 = SelfAnimExist(5110 + (anim % 10))
trigger1 = anim = [5081,5089]
value = 5110 + (anim % 10)

[State 5110, 2] ;Hit ground anim (normal)
type = ChangeAnim
triggerall = time = 0
triggerall = anim != [5110,5119] ;Not already changed anim
trigger1 = anim != [5161,5169]
trigger2 = !SelfAnimExist(5170 + (anim % 10))
value = 5170

[State 5110, 3] ;Hit ground anim (for hit up)
type = ChangeAnim
triggerall = time = 0
triggerall = anim != [5110,5119] ;Not already changed anim
trigger1 = anim = [5161,5169]
trigger1 = SelfAnimExist(5170 + (anim % 10))
value = 5170 + (anim % 10)

[State 5110, 4]
type = HitFallDamage
trigger1 = Time = 0

[State 5110, 5]
type = PosSet
trigger1 = Time = 0
y = 0

[State 5110, var] ;Get fall velocity
type = varSet
trigger1 = Time = 0
trigger1 = GetHitvar(fall.yvel) != 0
sysvar(1) = floor(vel y)

[State 5110, 6]
type = PlaySnd
trigger1 = Time = 0
trigger1 = !Sysvar(0)
;value = F7, 0 ;Hit ground
value =1,2; F7, (sysvar(1) > 5) + (sysvar(1) > 14)

[State 5110, 7]
type = null;GameMakeAnim
trigger1 = Time = 0
trigger1 = !Sysvar(0)
value = 88;60 + (sysvar(1) > 5) + (sysvar(1) > 14)
pos = 0, 0
under = sysvar(1) <= 10

[State 5110]
type = Explod
trigger1 = Time = 0
trigger1 = !Sysvar(0)
anim = 88
pos = 0,0
sprpriority = -3
ownpal = 1

[State 5110, 8]
type = VelSet
trigger1 = Time = 0
y = 0

[State 5110, 9] ;For hit up type
type = ChangeAnim
persistent = 0
triggerall = anim = [5171,5179]
triggerall = SelfAnimExist(5110 + (anim % 10))
trigger1 = AnimTime = 0
trigger2 = Sysvar(0) ;Sysvar(0) = 1 avoids hit ground anim
value = 5110 + (anim % 10)

[State 5110, 10] ;For normal
type = ChangeAnim
persistent = 0
triggerall = Anim != [5111,5119]
trigger1 = AnimTime = 0
trigger2 = Sysvar(0) ;Sysvar(0) = 1 avoids hit ground frame
value = 5110

[State 5110, 11] ;If just died
type = ChangeState
triggerall = !alive
trigger1 = AnimTime = 0
trigger2 = Sysvar(0) ;Sysvar(0) = 1 avoids hit ground frame
trigger3 = Anim = [5110,5119]
value = 5150

[State 5110, 12]
type = varSet
trigger1 = Sysvar(0)
trigger1 = Time = 0
sysvar(0) = 0

[State 5110, 13] ;Friction
type = VelMul
trigger1 = 1
x = 0.85

[State 5110, 14]
type = ForceFeedback
trigger1 = alive
trigger1 = Time = 0
time = 8
ampl = 240
waveform = sine

[State 5110, 15]
type = ForceFeedback
trigger1 = !alive
trigger1 = Time = 0
ampl = 200, 7, -.467
time = 30
waveform = sine

[State 5110,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HIT_GETUP
[Statedef 5120]
type    = L
movetype= I
physics = N

[State 5120, 1a] ;Get up anim (normal)
type = ChangeAnim
triggerall = time = 0
trigger1 = anim != [5111,5119]
trigger2 = !SelfAnimExist(5120 + (anim % 10))
value = 5120

[State 5120, 1b] ;Get up anim (for hit up/diag-up)
type = ChangeAnim
triggerall = time = 0
trigger1 = anim = [5111,5119]
trigger1 = SelfAnimExist(5120 + (anim % 10))
value = 5120 + (anim % 10)

[State 5120, 2]
type = VelSet
trigger1 = Time = 0
x = 0

[State 5120, 3]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 5120, 4]
type = HitFallSet
trigger1 = AnimTime = 0
value = 1

[State 5120, 5] ;Can't be thrown right after getting up
type = NotHitBy
trigger1 = AnimTime = 0
value = , NT,ST,HT
time = 12

[State 5120, 6] ;Can't be hit right after getting up (short time)
type = NotHitBy
trigger1 = AnimTime = 0
value2 = SCA
time = 3

[State 5120, 7]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

[State 5120,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HIT_LIEDEAD
[Statedef 5150]
type    = L
movetype= H
physics = N
sprpriority = -3

[State 5150, 1] ;Normal anim
type = ChangeAnim
triggerall = Time = 0 && prevstateno != 5950
triggerall = SelfAnimExist(5140)
trigger1 = (anim != [5111,5119]) && (anim != [5171,5179])
trigger2 = !SelfAnimExist(5140 + (anim % 10))
value = 5140

[State 5150, 3] ;Hit up type anim
type = ChangeAnim
trigger1 = Time = 0 && prevstateno != 5950
trigger1 = (anim = [5111,5119]) || (anim = [5171,5179])
trigger1 = SelfAnimExist(5140 + (anim % 10))
value = 5140 + (anim % 10)

[State 5150, 4] ;Match over anim
type = ChangeAnim
persistent = 0
;trigger1 = Time = 0
trigger1 = MatchOver = 1 && prevstateno != 5950
trigger1 = Anim = [5140,5149]
trigger1 = SelfAnimExist(anim+10)
value = anim+10

[State 5150, 5] ;Switch to 5110 if liedead anim does not exist
type = ChangeAnim
trigger1 = Time = 0 && prevstateno != 5950
trigger1 = Anim != [5140,5159]
trigger1 = Anim != [5110,5119]
value = 5110

[State 5150]
type = ChangeAnim
trigger1 = time = 0
trigger1 = prevstateno = 5950
value = 5950
elem = 11

[State 5150, 6] ;Friction
type = VelMul
trigger1 = 1
x = 0.85

[State 5150, 7] ;Friction
type = VelSet
trigger1 = Vel x < .05
persistent = 0
x = 0

[State 5150, 8]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 5150,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HIT_FALLRECOVER (still falling)
[Statedef 5200]
type    = A
movetype= H
physics = N

[State 5200]
type=Changestate
triggerall = Alive
triggerall = time <= 1
trigger1 = Pos Y = [-5,15]
trigger1 = vel Y > 0
value = 3999

[State 5200, 1] ;Change anim if done with transition
type = ChangeAnim
trigger1 = Anim = 5035
trigger1 = AnimTime = 0
value = 5050

[State 5200]
type = veladd
trigger1 = time = 0
trigger1 = command ="holdfwd"
x = 4

[State 5200]
type = veladd
trigger1 = time = 0
trigger1 = command ="holdback"
x = -4

[State 5200, 2]
type = VelAdd
trigger1 = 1
y = GetHitvar(yaccel)

[State 5200, 3]
type = SelfState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 10
value = 5201

[State 5200,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HIT_FALLRECOVER (on the ground)
[Statedef 5201]
type    = A
movetype= H
physics = A
anim = 5200

[State 5201, 1] ;Turn if not facing opponent
type = Turn
trigger1 = Time = 0
trigger1 = p2dist X < -5

[State 5201,2]
type=Changestate
triggerall = Alive
;triggerall = time <= 1
trigger1 = Pos Y <= -5
value = 3999

[State 5201, 2]
type = VelSet
trigger1 = Time = 0
x = -.15
y = -3.5

[State 5201, 3]
type = PosSet
trigger1 = Time = 0
y = 0

[State 5201, 4]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 5201, 5] ;Blink white
type = PalFX
trigger1 = Time = 0
time = 3
add = 128,128,128 ;256,256,256

[State 5201, 6]
type = GameMakeAnim
trigger1 = Time = 1
value = 60
pos = 0, 0
under = 1

[State 5201,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; HIT_AIRFALLRECOVER
[Statedef 5210]
type    = A
movetype= I
physics = N
anim = 5210
ctrl = 0

[State 5210, 1] ;Blink white
type = PalFX
trigger1 = Time = 0
time = 3
add = 128,128,128 ;256,256,256

[State 5210, 1]
type = PosFreeze
trigger1 = Time = 0
value = 4

[State 5210, 2] ;Turn if not facing opponent
type = Turn
trigger1 = Time = 0
trigger1 = p2dist X < -20

[State 5210, 1] 
type = VelMul
trigger1 = Time = 4
x = .8
y = .8

[State 5210, 1]
type = VelAdd
trigger1 = Time = 4
y = -4.5

[State 5210, 1] 
type = VelMul
trigger1 = Time = 4
trigger1 = Vel Y > 0
y = .5

[State 5210, 1]
type = VelAdd
trigger1 = Time = 4
trigger1 = Vel Y > -3
y = -2

[State 5210, 1]
type = VelAdd
trigger1 = Time = 4
trigger1 = Vel Y > -2
y = -1

[State 5210, 2] ;Go up
type = VelAdd
trigger1 = Time = 4
trigger1 = Command = "holdup"
y = -4

[State 5210, 2] ;Go down
type = VelAdd
trigger1 = Time = 4
trigger1 = Command = "holddown"
y = 1.5

[State 5210, 2] ;Go fwd
type = VelMul
trigger1 = Time = 4
trigger1 = Command = "holdfwd"
x = 1

[State 5210, 2] ;Go back
type = VelAdd
trigger1 = Time = 4
trigger1 = Command = "holdback"
x = -1

[State 5210]
type = veladd
trigger1 = time = 4
trigger1 = command ="holdfwd"
x = 3
y = -3

[State 5210]
type = veladd
trigger1 = time = 4
trigger1 = command ="holdback"
x = -3
y = -3

[State 5210, 3]
type = NotHitBy
trigger1 = Time = 0
value = SCA
time = 18

[State 5210]
type = varrandom
trigger1 = time = 0
v = 3
range = 1

[STate 5210]
type = PlaySnd
trigger1 = Time = 1 && numhelper(2025) = 0
value = 0,58
channel = 2

[STate 5210]
type = PlaySnd
trigger1 = Time = 1 && var(3) = 0 && numhelper(2025)
value = 0,15
channel = 2

[STate 5210]
type = PlaySnd
trigger1 = Time = 1 && var(3) = 1 && numhelper(2025)
value = 0,29
channel = 2

[State 5210, 4]
type = CtrlSet
trigger1 = Time = 20
value = 1

[State 5210, 5]
type = VelAdd;Gravity
trigger1 = Time >= 4
y = .5

[State 5210, 5] ;Land on ground
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value = 52 ;JUMP_LAND
ctrl = 1

[State 5210,helper]
type = destroyself
trigger1 = Ishelper

;---------------------------------------------------------------------------
; Continue?
[Statedef 5500]
type = S
ctrl = 0
anim = 5300
velset = 0,0

[State 5500, 1] ;Use continue animation if available
type = ChangeAnim
trigger1 = time = 0
trigger1 = SelfAnimExist(5500)
value = 5500

;---------------------------------------------------------------------------
; Initialize (at the start of the round)
[Statedef 5900]
type = S

[State 5900, 1] ;Clear all int variables
type = varRangeSet
trigger1 = roundno = 1
value = 0

[State 5900, 2] ;Clear all float variables
type = null;varRangeSet
trigger1 = roundno = 1
fvalue = 0

[State 5900, 3] ;Intro
type = ChangeState
trigger1 = roundno = 1
value = 190



