"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const co_1 = __importDefault(require("co"));
const AwaitLock_1 = __importDefault(require("../AwaitLock"));
it('can be acquired asynchronously and released', async () => {
    let lock = new AwaitLock_1.default();
    await lock.acquireAsync();
    lock.release();
});
it('can be acquired with yield running in co', co_1.default.wrap(function* () {
    let lock = new AwaitLock_1.default();
    yield lock.acquireAsync();
    lock.release();
}));
it('throws if released while unacquired', () => {
    let lock = new AwaitLock_1.default();
    expect(() => {
        lock.release();
    }).toThrow();
});
it('blocks async code that has not acquired the lock', async () => {
    let lock = new AwaitLock_1.default();
    let semaphore = 1;
    async function testSemaphore() {
        await lock.acquireAsync();
        expect(semaphore).toBe(1);
        semaphore--;
        await Promise.resolve();
        expect(semaphore).toBe(0);
        semaphore++;
        lock.release();
    }
    await Promise.all([testSemaphore(), testSemaphore()]);
});
describe('tryAcquire', () => {
    it('acquires the lock immediately without waiting', async () => {
        let lock = new AwaitLock_1.default();
        let acquired1 = lock.tryAcquire();
        expect(acquired1).toBe(true);
        let acquired2 = false;
        lock.acquireAsync().then(() => {
            acquired2 = true;
        });
        await Promise.resolve();
        expect(acquired2).toBe(false);
    });
    it('returns false if the lock is not free', async () => {
        let lock = new AwaitLock_1.default();
        let acquired1 = lock.tryAcquire();
        expect(acquired1).toBe(true);
        let acquired2 = lock.tryAcquire();
        expect(acquired2).toBe(false);
        lock.release();
        let acquired3 = lock.tryAcquire();
        expect(acquired3).toBe(true);
    });
});
//# sourceMappingURL=AwaitLock-test.js.map