/*
 * Copyright 2020 Palantir Technologies, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// simplified typings copied from @types/prop-types, to avoid that explicit dependency

export type Validator = (
    props: { [key: string]: any },
    propName: string,
    componentName: string,
    location: string,
    propFullName: string,
) => Error | null;

export type ValidationMap<T> = { [K in keyof T]?: Validator };
