/*------------------------------------------------------------------------------*
 * File Name: Automation.c				 										*
 * Creation: ER, 07/24/02														*
 * Purpose: OriginC Source C for Tutorial on Automation                         *
 * Copyright (c) OriginLab Corp.2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
//
#include <origin.h> 
//
////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////
//
// This function accepts a file name, and then does the following processing:
// 1> reads in the data and plots a new graph
// 2> perforsm nonlinear fit on plotted data
// 3> exports graph with fit results to a BMP file
//
void Process(string strFileName)
{	
	// Open file for processing
	stdioFile ffDataFile;
	bool bRet = ffDataFile.Open(strFileName, file::modeRead);	
	if(!bRet)
	{
		printf("File not found!\n");
		return;
	}
	printf("Processing file: %s...",strFileName);
	
	// Create a worksheet
	Worksheet wksData;	
	bool bRetW = wksData.Create();

	// Declare datasets in worksheet to copy data from file
	Dataset dsX(wksData,0);
	Dataset dsY(wksData,1);
	
	// Read and discard header lines in file
	string strHdr;
	ffDataFile.ReadString(strHdr);
	ffDataFile.ReadString(strHdr);

	// Loop thru and read all lines from file, and fill data into worksheet columns
	bool bRead;
	do
	{
		bRead = ffDataFile.ReadString(strHdr); 
		if(bRead)
		{
			int ii = dsX.GetSize();
			dsX.SetSize(ii+1);							// increment size of datasets
			dsY.SetSize(ii+1);
			string str1 = strHdr.GetToken(0);			// break string into tokens
			dsX[ii] = atof(str1);						// convert string to number
			str1 = strHdr.GetToken(1);
			dsY[ii] = atof(str1);
		}
	}while (bRead);
		
	// Create a graph
	GraphPage grphData;
	bool bRetG = grphData.Create("Origin");				// use the "Origin" template for graph
	
	// Point to active layer in current graph page
	GraphLayer grphLayer = grphData.Layers();
	
	// Declare a curve object using x,y columns of worksheet
	Curve crvData(wksData, 0, 1);
	
	// Plot data curve to active layer
	int	nPlot = grphLayer.AddPlot(crvData, IDM_PLOT_SCATTER);
	grphLayer.Rescale();

	// Get name of curve
	string strYDataName;						
	crvData.GetName(strYDataName);

	// Perform nonlinear fitting
	using NLSF = LabTalk.NLSF;					// Point to the NLSF object
	NLSF.Init();								// Initialize the fitter
	NLSF.Func$ = "gaussamp";					// Assign fitting function
	NLSF.FitData$ = strYDataName;				// Assign dataset name
	NLSF.Execute("parainit");					// Perform automatic parameter initialization
	NLSF.Fit(100);								// Perform fit - up to 100 iterations
	NLSF.PasteParams("p");						// Paste fit results to graph	
	
	// Export the graph page to a bmp file
	using Image = LabTalk.Image;								// access Image object
	Image.FileName$ = "AutomationTutorial.bmp";					// set export file name
	Image.ShowOptions = 0;										// turn off options dialog
	Image.Export.PagePixel( "BMP", 640, 480, 24, 0 );			// perform export

	printf("done!\n");
}
// end

