/*------------------------------------------------------------------------------*
 * File Name: oPlotIDs.h														*
 * Creation: CPY 6/29/2003														*
 * Purpose: Origin C and Origin internal consts related to plotting and controls*
 * Copyright (c) OriginLab Corp.	2003										*
 * All Rights Reserved															*
 * Modification Log:															*
 *	ML 7/7/2003 MORE_NEW_SELECT_COLUMNS_FOR_PLOTTING_WORK						*
 *	ML 7/11/2003 MULTILAYER_SCP_LC												*
 *	ML 7/15/2003 LC_DATAPLOT_EDITING_PRELIMINARY_WORK							*
 *	ML 7/21/2004 LC_DATAPLOTS_TABLE_SELCHANGE									*
 *	ML 7/22/2003 CORRECT_ROW_INSERTION											*
 *	ML 7/25/2003 STYLES_HOLDERS_IN_SCP_LC										*
 *	CPY 08/05/03 QA70-4488 v7.5647 DATASET_FUNC_PLOTS_IN_SCP					*
 *	ML 8/11/2003 LC_3D_MATRIX_PLOTS												*
 *	ML 8/19/2003 QA70-5022 FILL_AREA_TYPE_NAME									*
 *	ML 8/26/2003 COLOR_SIZE_MODIFIER_PLOT_TYPES									*
 *	CPY 9/5/03 v7.5685 ERR_BARS_SEPARATE_FROM_LABEL								*
 *	RVD 9/3/2003 QA70-5078 v7.0682 PLOT_RANGE_APPLY								*
 *------------------------------------------------------------------------------*/

#ifndef _O_PLOT_IDS_H
#define _O_PLOT_IDS_H

//----- CPY 08/05/03 QA70-4488 v7.5647 DATASET_FUNC_PLOTS_IN_SCP
// the following are only for Project.GetPlotTypeInfo to get dataset and function plot col designations
#define IDM_DATASETS_PLOT		1
#define IDM_FUNCS_PLOT			2
//----- end	DATASET_FUNC_PLOTS_IN_SCP

// plot ids moved from orgmenus.h
//--------------------- CPY 4/25/99 v6.0188 t4500 Z_COL_ADD_TO_3D_MESH_PLOT
//#define		IDM_PLOT_BEGIN		IDM_PLOT_INDEX
//#define		IDM_PLOT_END		IDM_PLOT_UNKNOWN
#define		IDM_PLOT_BEGIN		180
#define		IDM_PLOT_END		255
//--------------------- end t4500

#define		IDM_PLOT_BAR_MULTI	187
#define		IDM_PLOT_COLUMN_MULTI	188
#define		IDM_PLOT_AREA_MULTI	189
#define		IDM_PLOT_INDEX		190
#define		IDM_PLOT_SMITH_CHART	191//--------- CPY 06/26/2001 t6834 v6.9018 ADD_SMITH_CHART_PLOT_HOOK_UP
#define		IDM_PLOT_POLAR		192

//------------------ CPY 3/19/99 v6.0176 t5596 MOVE_COMPLEX_PLOT_NOT_FROM_SCRIPT
// plot id must be between 190 and 255
#define	IDM_PLOT_INDEX_SIZE						193
#define	IDM_PLOT_INDEX_SIZE_COLOR_SAME_COLOUMN	194
//------------------ end MOVE_COMPLEX_PLOT_NOT_FROM_SCRIPT

#define		IDM_PLOT_LINE		200
#define		IDM_PLOT_SCATTER	201
#define		IDM_PLOT_LINESYMB	202
#define		IDM_PLOT_COLUMN		203
#define		IDM_PLOT_AREA		204
#define		IDM_PLOT_HILOCLOSE	205
#define		IDM_PLOT_BOX		206

/// CPY v3.8 8/8/95 FLOAT_BARS
#define		IDM_PLOT_COLUMN_FLOAT	207
///
///sth v3.98 12/14/95 VECTOR_PLOTS_DIALOG
#define		IDM_PLOT_VECTOR		208
///end VECTOR_PLOTS_DIALOG

///CPY v3.98 1/14/95 DOT_PLOT
#define		IDM_PLOT_DOT		209
///

/// SFX 7/7/98 v6.0125 ADD_3D_BAR_RIBBON_WALL_CLASSES
#define		IDM_PLOT_3D_WALL	210
#define		IDM_PLOT_3D_RIBBON	211
#define		IDM_PLOT_3D_BAR		212
/// end ADD_3D_BAR_RIBBON_WALL_CLASSES

///sth v4.132 f1320 8/21/96 HISTOGRAMS_FROM_C
//#define		IDM_PLOT_HISTOGRAM_ID	210
///end HISTOGRAMS_FROM_C
#define		IDM_PLOT_COLUMN_STACK	213
#define		IDM_PLOT_AREA_STACK	214
#define		IDM_PLOT_BAR		215
#define		IDM_PLOT_BAR_STACK	216
#define		IDM_PLOT_DBLY		217

/// SFX 6/4/98 v6.0123 ADD_FLOW_VECTOR_PLOT_TYPE
#define		IDM_PLOT_FLOWVECTOR		218
/// end ADD_FLOW_VECTOR_PLOT_TYPE

/// GCJ 7/10/98 t1320 DRAW_HISTOGRAM_PLOT
#define		IDM_PLOT_HISTOGRAM_TYPE	219
/// end DRAW_HISTOGRAM_PLOT

/// EJP 07-12-2001 v6.9049 t8239 PLOT_MATRIX_AS_IMAGE_PLOT
#define IDM_PLOT_MATRIX_IMAGE		220
/// end PLOT_MATRIX_AS_IMAGE_PLOT

#define		IDM_PLOT_DLL_BEG	225
///JLIU 12/3/97 OK60_DRAW_PIE				
#define		IDM_PLOT_PIE_TYPE	225			
///end 
#define		IDM_PLOT_CONTOUR	226 /// CPY v3.8 IDM_PLOT_CONTOUR 7/7/95
#define		IDM_PLOT_DLL_END	229

#define		IDM_PLOT_UNKNOWN	230

				
#define		IDM_PLOT_AS			IDM_PLOT_LINE

/* these are for return codes from series_plot_type only
 * they have to be after plot end because they can not
 * be reinit or changed
 */
#define		IDM_PLOT_ERRBAR		231
#define		IDM_PLOT_TEXT		232
#define		IDM_PLOT_X_ERRBAR	233 ///--------- CPY v4.9987 7/9/97 b2681 ADD_X_ERR_BAR_PLOT_ID

/// SFX 3/15/99 v6.0174 CLEANUP_CODES_FOR_TYPE_CHANGING
#define		IDM_PLOT_SURFACE_COLORMAP	236
#define		IDM_PLOT_SURFACE_COLORFILL	237
#define		IDM_PLOT_SURFACE_WIREFRAME	238
#define		IDM_PLOT_SURFACE_BARS		239
/// end CLEANUP_CODES_FOR_TYPE_CHANGING

#define		IDM_PLOT_3D_LINE	240
#define		IDM_PLOT_3D_TEXT	241
#define		IDM_PLOT_3D_MESH	242

///CPY v4.09 5/30/96 ADD_TRI_PLOT_MENU
#define	IDM_PLOT_XYZ_TRIANGULAR		245
//--------- CPY v4.987 5/19/97 ADD_LINE_SERIES_PLOT_ID
#define IDM_PLOT_LINE_SERIES		246
#define IDM_PLOT_INDEX_COLOR		247
#define IDM_PLOT_INDEX_SIZE_COLOR	248
#define IDM_PLOT_FILL_COLOR_BAND	249
//--------------- CPY v6.0127 8/4/98 SERIES_CONNECT_CLEAN_UP
//#define IDM_PLOT_PIE				250
//#define IDM_PLOT_PIE_PERCENT		251
//------------------------------------------- end SERIES_CONNECT_CLEAN_UP 
#define IDM_PLOT_HISTOGRAM_PROB		252
#define IDM_PLOT_CURVE_FIT			253
#define IDM_PLOT_Y_ERROR_BARS		254/// CPY v4.997 t2445 6/11/97 ADD_ERR_BAR_PLOT_ID
#define IDM_PLOT_XY_ERROR_BARS		255

/// ML 8/26/2003 COLOR_SIZE_MODIFIER_PLOT_TYPES
#define	IDM_PLOT_3D_INDEX_SIZE			258		// never a bPlotType
#define	IDM_PLOT_3D_INDEX_COLOR			259		// never a bPlotType
#define	IDM_PLOT_3D_INDEX_SIZE_COLOR	260		// never a bPlotType
/// end COLOR_SIZE_MODIFIER_PLOT_TYPES
    

//---- CPY 8/9/03 ADD_3D_SCATTER_TO_PLOT_SETUP
#define ID_3D_GRAPH_SCATTER             0X8AF0
#define ID_3D_GRAPH_TRAJECTORY          0X8AF1
//----
//----- CPY 6/15/03 QA70-4488 v7.0603 SEL_COLS_PLOTTING_DLG
// the following enum is for all Select Columns for Plotting dialog only, please note the difference between this
// and those in OKDATAOBJ_DESIGNATION designation
typedef enum tagPlotDesignationEx {
	COLDESIG_NONE = 0,
	COLDESIG_X = 1,
	COLDESIG_Y,
	COLDESIG_Z,
	COLDESIG_ERROR_OR_LABEL_BEGIN,
	COLDESIG_LABEL = COLDESIG_ERROR_OR_LABEL_BEGIN,
	COLDESIG_XERROR,
	COLDESIG_YERROR,
	COLDESIG_YPLUSERROR,
	COLDESIG_ERROR_OR_LABEL_END,
	COLDESIG_YMINUSERROR = COLDESIG_ERROR_OR_LABEL_END,
	COLDESIG_SIZE,    // for symbol size in bubble plots
	COLDESIG_COLOR,    // for symbol color in scatter color plots
	COLDESIG_VECTOR_ANGLE,  // for vector XYAM plots
	COLDESIG_VECTOR_MAGNITUDE,  // for vector XYAM plots
	COLDESIG_VECTOR_XEND,  // for vector XYXY plots
	COLDESIG_VECTOR_YEND  // for vector XYXY plots
} PlotDesignationEx;
//----- end SEL_COLS_PLOTTING_DLG

/// ML 7/7/2003 MORE_NEW_SELECT_COLUMNS_FOR_PLOTTING_WORK
enum 
{
	ADDPLOTSFROMTREE_EDIT						= 0x00010000UL,
	ADDPLOTSFROMTREE_RESCALE					= 0x00020000UL,
	ADDPLOTSFROMTREE_NEW						= 0x00040000UL,
	ADDPLOTSFROMTREE_IMPLICIT_STYLEHOLDERS		= 0x00080000UL,
};
/// end MORE_NEW_SELECT_COLUMNS_FOR_PLOTTING_WORK

/// ML 7/25/2003 STYLES_HOLDERS_IN_SCP_LC
// GetLayerContents:
enum
{
	GETLC_DATAPLOTS						= 0x00010000UL,
	GETLC_STYLE_HOLDERS					= 0x00020000UL,
	GETLC_NO_LIMITS						= 0x00040000UL,	/// RVD 9/3/2003 QA70-5078 v7.0682 PLOT_RANGE_APPLY
};
/// end STYLES_HOLDERS_IN_SCP_LC


//---------------------------- CPY v6.0174 3/13/99 t5343 CHECK_PLOT_TYPE_AGAINST_SELECTION
#define PCD_PREFER_X				0x1000 /// assume 1st column X always unless SHIFT key if press
#define	PCD_MUST_HAVE_X				0x2000 /// ignore shift-key and require must have 1st column as X
#define PCD_EXACT_YCOLS				0x4000	/// need exact number of Y columns, may or may not need X column
#define PCD_X_OPTIONAL				0x8000
#define PCD_NO_X					0x0100
#define PCD_REPEAT_2				0x0200
#define PCD_EXACT_YCOLS_OR_LESS_ONE	0x0400
#define	PCD_Z_PREFER_Y				0x0800
#define	PCD_CAN_ADD_E_H_L			0x0080
#define PCD_XERR_BEFORE_Y			0x0040 //----CPY v6.0188 4/25/99 t5872 XEYE_PLOT_FAILED
#define	PCD_EXACT_ONE_GROUP			0x0020 // ------ CPY v6.0190 4/28/99 t6082 XYXY_VECTOR_FAILED
/// ML 7/15/2003 LC_DATAPLOT_EDITING_PRELIMINARY_WORK
#define	PCD_ONLY_ONE_Z				0x0010	// one Z and nothing else allowed
/// end LC_DATAPLOT_EDITING_PRELIMINARY_WORK
//----- CPY 6/27/03 QA70-4658 v7.0613 SEL_COLS_PLOTTING_DLG
// highest bits will be used for optional settings
#define PCD_SHOW_X_ERR				0x10000000
#define PCD_SHOW_POS_NEG_ERR		0x20000000
#define PCD_HIDE_ERR_BARS			0x40000000  // CPY 9/5/03 ERR_BARS_SEPARATE_FROM_LABEL

#define PCD_MODIFIER_SIZE			0x01000000
#define PCD_MODIFIER_COLOR			0x02000000
#define PCD_MODIFIER_VEC_AM			0x00100000
#define PCD_MODIFIER_VEC_XYEND		0x00200000
/// ML 8/11/2003 LC_3D_MATRIX_PLOTS
#define	PCD_LTPLOTINFO_HAS_NEXVAL	0x00400000
/// end LC_3D_MATRIX_PLOTS
/// ML 8/19/2003 QA70-5022 FILL_AREA_TYPE_NAME
#define	PCD_PLOT_TYPE_AUX_BIT_1		0x00800000
#define	PCD_PLOT_TYPE_AUX_BITS		(PCD_PLOT_TYPE_AUX_BIT_1)
#define	PCD_PLOT_TYPE_FILL_AREA		PCD_PLOT_TYPE_AUX_BIT_1		// used only if IDM_PLOT_HILOCLOSE to denote Fill Area 
/// end FILL_AREA_TYPE_NAME

// layer related bits
/// ML 7/11/2003 MULTILAYER_SCP_LC
//#define MASK_PCD_LAYER_BITS			0x000F0000
#define MASK_PCD_LAYER_BITS			0x00070000
#define PCD_GROUP_MULTI_YS			0x00080000	//CPY 7/23/03, group the plots if multiple Ys is selected
/// end MULTILAYER_SCP_LC
#define PCD_LAYER_EXCHANGE			0x00010000 // Bar graph
#define PCD_LAYER_POLAR				0x00020000
#define PCD_LAYER_TRI				0x00030000
#define PCD_LAYER_SMITH				0x00040000
#define PCD_LAYER_3D				0x00050000
#define PCD_LAYER_3D_XYY			0x00060000	//---------------- CPY 9/23/03 QA70-5134 v7.5704 3D_LAYER_HAS_LEFT_RIGHT_HAND_TYPE	
//-----
//---------------------------- end CHECK_PLOT_TYPE_AGAINST_SELECTION

#define IS_LAYER_BITS_ANY_3D(_DW)	(((_DW) & MASK_PCD_LAYER_BITS) == PCD_LAYER_3D || ((_DW) & MASK_PCD_LAYER_BITS) == PCD_LAYER_3D_XYY)	//---------------- CPY 9/23/03 QA70-5134 v7.5704 3D_LAYER_HAS_LEFT_RIGHT_HAND_TYPE

#define IS_ALLOW_ERR_BARS(_DW)	(((_DW) & PCD_CAN_ADD_E_H_L) && !((_DW) & PCD_HIDE_ERR_BARS))	// CPY 9/5/03 ERR_BARS_SEPARATE_FROM_LABEL
//----- CPY 9/8/03 v7.5687 FLOAT_COLS_CHECK_NUM_OF_YS
// we are running out of bits, so I have to combine PCD_EXACT_YCOLS	and PCD_EXACT_YCOLS_OR_LESS_ONE
#define PCD_EXACT_YCOLS_OR_MORE	(PCD_EXACT_YCOLS | PCD_EXACT_YCOLS_OR_LESS_ONE)
#define IS_PCD_EXACT_Y_COLS_OR_MORE(_DW)		(((_DW) & PCD_EXACT_YCOLS_OR_MORE) == PCD_EXACT_YCOLS_OR_MORE)
#define IS_PCD_EXACT_Y_COLS(_DW)				((_DW & PCD_EXACT_YCOLS) && !(_DW & PCD_EXACT_YCOLS_OR_LESS_ONE))
#define IS_PCD_EXACT_Y_COLS_OR_ONE_LESS(_DW)	((_DW & PCD_EXACT_YCOLS_OR_LESS_ONE) && !(_DW & PCD_EXACT_YCOLS))
//----- end	FLOAT_COLS_CHECK_NUM_OF_YS

//---- CPY v7.5642 QA70-4488 8/2/03 PLOT_SETUP_DLG_SUPPORT_3D_GRAPHS
// argument for GetSystemInfo of Layer class
#define GLI_PCD_BITS	0  // get layer bits like PCD_LAYER_POLAR
//---- end PLOT_SETUP_DLG_SUPPORT_3D_GRAPHS

/// ML 7/11/2003 MULTILAYER_SCP_LC
// dwLTPlotInfo  bits for SCP:
enum {
	LTPI_LAYERS_NUMBER_MASK					= 0x0000000FUL,		// the number of layers
	/// ML 8/11/2003 LC_3D_MATRIX_PLOTS
	LTPI_NEXVAL_MASK						= 0x0000FF00UL,		// if PCD_LTPLOTINFO_HAS_NEXVAL in dwAuxTypeInfo is on, then HIBYTE of LOWORD of dwLTPlotInfo contains nExValue
	/// end LC_3D_MATRIX_PLOTS
	
	LTPI_LAYERS_CONFIG_MASK					= 0x00030000UL,		// geometrical configuration of multiple layers
	// Possible values of LTPI_LAYERS_CONFIG_MASK bits (the total number of layers is in LTPI_LAYERS_NUMBER_MASK bits):
	LTPI_LAYERS_CONFIG_MULTI_Y				= 0x00000000UL,		// overlapping multi-y axis
	LTPI_LAYERS_CONFIG_STACKED				= 0x00010000UL,		// a "onedimensional" array of layers 
	LTPI_LAYERS_CONFIG_GRID					= 0x00020000UL,		// a "twodimensional" array of layers 
};
/// end MULTILAYER_SCP_LC

/// ML 8/11/2003 LC_3D_MATRIX_PLOTS
#define		NEXVAL_MASK_BITSHIFT_IN_LTPI		8	// so that (dwLTPlotInfo & LTPI_NEXVAL_MASK) >> NEXVAL_MASK_BITSHIFT_IN_LTPI becomes nExValue
/// end LC_3D_MATRIX_PLOTS


/// ML 7/21/2004 LC_DATAPLOTS_TABLE_SELCHANGE
// Possible values of dwOptions in TreeEditor::GetInfo(DWORD dwOptions) 
// to specify what kind of information is desired (if dataplots page).
enum {
	TREDTINFOOPTS_ENUM_MASK					= 0x000000FFUL,
	TREDTINFOOPTS_IS_EDIT_ALLOWED			= 0x00000001UL,		// is selection such that it allows editing
	TREDTINFOOPTS_HAS_STYLE_HOLDERS			= 0x00000002UL,		// does it have any style holders?
};
/// end LC_DATAPLOTS_TABLE_SELCHANGE


/// ML 7/22/2003 CORRECT_ROW_INSERTION
enum {
	DPL_INVALID				= 0,
	DPL_PLOT_OUTSIDE_GROUP,
	DPL_PLOT_IN_GROUP,
	DPL_GROUP,
	DPL_LAYER,
	DPL_STYLE_HOLDER_OUTSIDE_GROUP,
	DPL_STYLE_HOLDER_IN_GROUP,
};
/// end CORRECT_ROW_INSERTION

/// ML 8/1/2003 SHOWING_HIDING_STYLE_HOLDERS
// View filter for DataPlots tree editor:
enum {
	DPEDTVIEW_HIDE_STYLEHOLDERS				= 0x00010000UL,
	DPEDTVIEW_HIDE_LIMITS					= 0x00020000UL,	/// RVD 9/3/2003 QA70-5078 v7.0682 PLOT_RANGE_APPLY
};
/// end SHOWING_HIDING_STYLE_HOLDERS


/// ML 8/11/2003 LC_3D_MATRIX_PLOTS
enum {
	OBJMESH_RIBON_PIECES,
	OBJMESH_RIBON,
	OBJMESH_WIRE_FRAME,
	OBJMESH_BAR,
};
#define		OBJMESH_MASK		OBJMESH_BAR	// 0x3	
/// end LC_3D_MATRIX_PLOTS




#endif //_O_PLOT_IDS_H
