/*------------------------------------------------------------------------------*
 * File Name: MSWin.h															*
 * Creation: CPY 4/12/2001														*
 * Purpose: Win32 functions														*
 * Copyright (c) OriginLab Corp.2001											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * CPY 11/15/02 v7.0434 ORIGIN_8_FEATURES										*	
 *------------------------------------------------------------------------------*/

#ifndef _MSWIN_H
#define _MSWIN_H

#ifndef _OC_TYPES_H
#include <OC_types.h> // if not already included, this will provide SYSTEMTIME
#endif

//--------------------------------------------------------------------------
// From Microsoft's windef.h
//--------------------------------------------------------------------------
typedef DWORD COLORREF;
typedef DWORD *LPCOLORREF;

//--------------------------------------------------------------------------
// From Microsoft's wingdi.h
//--------------------------------------------------------------------------
/* Logical Font */
#define LF_FACESIZE         32

#define RGB(r,g,b) ((COLORREF)(((BYTE)(r)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(b))<<16)))
// some colors
#ifndef COLOR_RED
	#define COLOR_RED		RGB(255,0,0)
	#define COLOR_GREEN		RGB(0,255,0)
	#define COLOR_BLUE		RGB(0,0,255)
	#define COLOR_YELLOW	RGB(255,255,0)
	
	#define COLOR_NAVY		RGB(0,0,128)	
	#define COLOR_LTYELLOW	RGB(255,255,128)
	#define COLOR_ORANGE	RGB(255,128,0)
	
	#define COLOR_BLACK		RGB(0,0,0)
	#define COLOR_WHITE		RGB(255,255,255)
#endif

#define ANSI_CHARSET            0
#define DEFAULT_CHARSET         1
#define SYMBOL_CHARSET          2
#define SHIFTJIS_CHARSET        128


//--------------------------------------------------------------------------
// From Microsoft's winuser.h
//--------------------------------------------------------------------------
#define WM_CLOSE                        0x0010
#define WM_QUERYENDSESSION              0x0011



//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

//-------- CPY 11/15/02 v7.0434 ORIGIN_8_FEATURES
// Origin 8 or later
#if  _OC_VER > 0x0703

typedef struct tagRECT
{
    int    left;
    int    top;
    int    right;
    int    bottom;
} RECT;

#define RECT_WIDTH(_RR) (_RR.right - _RR.left)
#define RECT_HEIGHT(_RR) (_RR.bottom - _RR.top)
#define RECT_X(_RR)		((_RR.left + _RR.right)/2)
#define RECT_Y(_RR)		((_RR.bottom + _RR.top)/2)
typedef struct tagSIZE
{
    LONG	cx;
    LONG    cy;
} SIZE;



/* Stock Logic fonts */
#define ORIGIN_FIXED_FONT	(-1)
#define ORIGIN_VAR_FONT		(-2)
#define ORIGIN_MENU_FONT	(-3)

#define OEM_FIXED_FONT      10
#define ANSI_FIXED_FONT     11
#define ANSI_VAR_FONT       12
#define SYSTEM_FONT         13
#define DEVICE_DEFAULT_FONT 14
#define SYSTEM_FIXED_FONT   16
#define DEFAULT_GUI_FONT    17


#define LOGPIXELSX    88    /* Logical pixels/inch in X                 */
#define LOGPIXELSY    90    /* Logical pixels/inch in Y                 */

#define HDC LPVOID

/** >User Interface Controls
		The DeviceContext class defines a class of device-context objects.
	Example:
		Page pb;
		pb = Project.Pages(); // Get the project's active page
		if( pb.IsValid() )
		{
			Window	myWindow = pb.GetWindow();
			DeviceContext myDC = myWindow.GetDC();
			int nPixels = myDC.GetDeviceCaps(LOGPIXELSX);
		}
*/
class DeviceContext
{
public:

	/**
	*/
	DeviceContext();
	
	/**
	*/
	DeviceContext(DeviceContext &dc);
	
	/**
	*/
	~DeviceContext();
	
public:
	
	/**
		Use hDC set internal hDC value. 
	*/
	BOOL Attach(HDC hDC );

	/**
		Return internal hDC value of class and set internal hDC to NULL
	*/
	HDC Detach( );

	/**
		This method retrieves a wide range of device-specific information about the display device.
	Parameters:
		nIndex = the type of information to return. 
	Return:
		The value of the requested capability if the function is successful.
	*/
	int GetDeviceCaps(int nIndex) const;

	/**
		Computes the width and height of a line of text on the attribute device context using the current font to determine the dimensions.
	Parameters:
		lpszString = Points to a string of characters. 
		nCount = Specifies the number of characters in the string.
	Return:
		The dimensions of the string (in logical units) in a SIZE structure.

	Example:
		void test()
		{
			Window wnd = MyDlg.GetWindow();
			DeviceContext dc = wnd.GetDC();
			SIZE sz[10];
			sz[2] = dc.GetTextExtent("ABC",3);
			out_int("x_width = ", sz[2].cx);
			out_int("y_width = ", sz[2].cy);
		}
	*/
	SIZE GetTextExtent(LPCTSTR lpszString, int nCount);

	/**
		Computes the width and height of a line of text on the attribute device context using the current font to determine the dimensions.
	Parameters:
		str = A string object. 
	Return:
		The dimensions of the string (in logical units) in a SIZE structure.

	Example:
		void test()
		{
			Window wnd = MyDlg.GetWindow();
			DeviceContext dc = wnd.GetDC();
			SIZE sz[10];
			sz[2] = dc.GetTextExtent("ABC",3);
			out_int("x_width = ", sz[2].cx);
			out_int("y_width = ", sz[2].cy);
		}
	*/
	SIZE GetTextExtent(const string &str);
};

/** >User Interface Controls
	
	Example:
*/	
class CmdTarget
{
public:
	
	/**
	*/
	CmdTarget();
	
protected:
	Msgmap m_msgmap;
};

	
	
	
/** >User Interface Controls
		The Window class is the base class for all window classes.
		This class is similar to the MFC CWnd class
	Example:
		// Get "Data1" worksheet window...if not valid...
		WorksheetPage  wksPg("Data1");
		Window winWks = wksPg.GetWindow();
		if(winWks)
		{
			printf("Worksheet window is %s\n", winWks.Text);
		}
		
*/
class Window :public CmdTarget
{
public:
	
	/**
	*/
	Window();

	/**
	*/
	Window(HWND hWnd);

	/**
	*/
	Window(Window& ctrl);
	
	/**
			This function returns the window handle 
		Example:
			// make active window iconized
			Window winDlg = myDlg.GetWindow();
			MessageBox(winDlg.GetSafeHwnd(), "Hello", "Test", MB_OK);

		Return:
			Returns the window handle for a window. 
			Returns NULL if the Window class is not attached to a window. 

	*/
	HWND	GetSafeHwnd();	
	
	/**
	*/
	BOOL	Attach(Window& ctrl);
	
	/**
		Return:
			The previous position of the scroll box.

		Parameters:
			nBar = the scroll bar to be set. This parameter can be either of the following: 
				SB_HORZ   Sets the position of the scroll box in the horizontal scroll bar of the window.
				SB_VERT   Sets the position of the scroll box in the vertical scroll bar of the window. 
			nPos = the new position of the scroll box. It must be within the scrolling range.

			bRedraw = whether the scroll bar should be repainted to reflect the new scroll-box position. 
				If this parameter is TRUE, the scroll bar is repainted; if FALSE, the scroll bar is not repainted.

		Remarks:
			Sets the current position of a scroll box and, if requested, redraws the scroll bar to reflect the new position of the scroll box. 
			Setting bRedraw to FALSE is useful whenever the scroll bar will be redrawn by a subsequent call to another function.
	*/
	int SetScrollPos( int nBar, int nPos, BOOL bRedraw = TRUE );

	/**
		Return:
			The previous position of the scroll box.

		Parameters:
			nBar = the scroll bar to be set. This parameter can be either of the following: 
					SB_HORZ   Sets the position of the scroll box in the horizontal scroll bar of the window.
					SB_VERT   Sets the position of the scroll box in the vertical scroll bar of the window. 
			nPos = the new position of the scroll box. It must be within the scrolling range.

			bRedraw= whether the scroll bar should be repainted to reflect the new scroll-box position. If this parameter is TRUE, the scroll bar is repainted; if FALSE, the scroll bar is not repainted.

		Remarks:
			Sets the current position of a scroll box and, if requested, redraws the scroll bar to reflect the new position of the scroll box. 
			Setting bRedraw to FALSE is useful whenever the scroll bar will be redrawn by a subsequent call to another function.
	*/
	void SetScrollRange( int nBar, int nMinPos, int nMaxPos, BOOL bRedraw = TRUE );

	/**
		Return:
			Specifies the current position of the scroll box in the scroll bar if successful; otherwise 0.
		Parameters:
			nBar = the scroll bar to examine. The parameter can take one of the following values: 
				SB_HORZ   Retrieves the position of the horizontal scroll bar.
				SB_VERT   Retrieves the position of the vertical scroll bar. 
		Remarks:
			Retrieves the current position of the scroll box of a scroll bar. 
			The current position is a relative value that depends on the current scrolling range. 
			For example, if the scrolling range is 50 to 100 and the scroll box is in the middle of the bar, the current position is 75.
	*/
	int GetScrollPos( int nBar ) const;

	/**

		Parameters:
			nBar = the scroll bar to examine. The parameter can take one of the following values: 
					SB_HORZ   Retrieves the position of the horizontal scroll bar.
					SB_VERT   Retrieves the position of the vertical scroll bar. 
			nMinPos = integer variable that is to receive the minimum position.
			nMaxPos =  integer variable that is to receive the maximum position.

		Remarks:
			Copies the current minimum and maximum scroll-bar positions for the given scroll bar to the locations specified by lpMinPos and lpMaxPos. 
			If window does not have a scroll bar, then the GetScrollRange member function copies 0 to lpMinPos and lpMaxPos. 

			The default range for a standard scroll bar is 0 to 100. The default range for a scroll-bar control is empty (both values are 0).
	*/
	void GetScrollRange( int nBar, int& nMinPos, int& nMaxPos ) const;

	/**
	*/
	UINT	SendMessage(uint msg, DWORD wParam = 0, DWORD lParam = 0);

	/**
	*/
	BOOL	PostMessage(uint msg, DWORD wParam = 0, DWORD lParam = 0);

	/**
	    Remark:
			This function sets the specified window's show state. 
		Parameters:
			nCmdShow = SW_HIDE, SW_NORMAL, SW_MINIMIZE, SW_MAXIMIZE etc.
		Example:
			// make "Data1" worksheet window iconized
			WorksheetPage  wksPg("Data1");
			Window winWks = wksPg.GetWindow();
			if(winWks)
				winWks.ShowWindow(SW_MINIMIZE);

		Return:
			If the window was previously visible, the return value is TRUE. 
			If the window was previously hidden, the return value is FALSE. 
	*/
	BOOL	ShowWindow(int nCmdShow);
	
	/**
	    Remark:
			Changes the position and dimensions. 
		Parameters:
			lpRect:   Points to a RECT structure that specifies the new size and position
			bRepaint:   Specifies whether Window is to be repainted. 
		Example:
			//Please make sure you have a "Data1" worksheet window exist when you run the example
			void test_MoveWindow()
			{
				WorksheetPage testWks("Data1");
				Window testWin = testWks.GetWindow();
				testWin.ShowWindow(SW_NORMAL);
				
				RECT RecNew = {144, 200, 500, 600};;
				testWin.MoveWindow(&RecNew);
			}		
	*/
	void	MoveWindow(const RECT * lpRect, BOOL bRepaint = TRUE);

	/**
	    Remark:
			Copies the dimensions of the bounding rectangle of the CWnd object to the structure pointed
			to by lpRect. The dimensions are given in screen coordinates relative to the upper-left
			corner of the display screen. The dimensions of the caption, border, and scroll bars,
			if present, are included.
		Parameters:
			lpRect: Points to a RECT structure that will receive the screen coordinates of the upper-left and lower-right corners. 
		Example:
			//Please make sure you have a "Data1" worksheet window exist when you run the example
			void test_GetWindowRect()
			{
				WorksheetPage testWks("Data1");
				Window testWin = testWks.GetWindow();
				testWin.ShowWindow(SW_NORMAL);
				
				RECT rect;
				testWin.GetWindowRect(&rect);
				printf("upper-left position, x:%d, y:%d\n", rect.left, rect.top);
				printf("lower-right position: x:%d, y:%d\n", rect.right, rect.bottom);
			}		
	*/
	void	GetWindowRect(RECT * lpRect);

	/**
	    Remark:
			Copies the client coordinates of the CWnd client area into the structure pointed to by lpRect. 
			The client coordinates specify the upper-left and lower-right corners of the client area. Since
			client coordinates are relative to the upper-left corners of the CWnd client area, the 
			coordinates of the upper-left corner are (0,0).
		Parameters:
			Points to a RECT structure that will receive the coordinates of the upper-left and lower-right corners of the client area. 
		Example:
			//Please make sure you have a "Data1" worksheet window exist when you run the example
			void test_GetClientRect()
			{
				WorksheetPage testWks("Data1");
				Window testWin = testWks.GetWindow();
				testWin.ShowWindow(SW_NORMAL);
				
				RECT rect;
				testWin.GetClientRect(&rect);
				printf("upper-left position to client area, x:%d, y:%d\n", rect.left, rect.top);
				printf("lower-right position to client area: x:%d, y:%d\n", rect.right, rect.bottom);
			}		
	*/
	void	GetClientRect(RECT * lpRect);

	/**
			Converts the client coordinates of a given RECT structure pointer on the display to screen coordinates. 
			Example:
			//Please make sure you have a "Data1" worksheet window exist when you run the example
			void run_ClientToScreen()
			{
				WorksheetPage testWks("Data1");
				Window testWin = testWks.GetWindow();
				testWin.ShowWindow(SW_NORMAL);
				
				RECT rect;
				testWin.GetClientRect(&rect);
				testWin.ClientToScreen(&rect);
				printf("upper-left position on screen, x:%d, y:%d\n", rect.left, rect.top);
				printf("lower-right position on screen: x:%d, y:%d\n", rect.right, rect.bottom);
			}		
	*/
	void	ClientToScreen(RECT * lpRect); 

	//void	ClientToScreen(point * lpPoint);

//	void	ScreenToClient(point * lpPoint);

	/**
	Remarks:
		Converts the screen coordinates of a given RECT structure pointer on the display to client coordinates.
	Example:
		//Please make sure you have a "Data1" worksheet window exist when you run the example
		void run_ScreenToClient()
		{
			WorksheetPage testWks("Data1");
			Window testWin = testWks.GetWindow();
			testWin.ShowWindow(SW_NORMAL);
				
			RECT rect;
			rect.left=100;
			rect.right=200;
			rect.top=200;
			rect.bottom=300;
			testWin.ScreenToClient(&rect);
			printf("upper-left position to client area, x:%d, y:%d\n", rect.left, rect.top);
			printf("lower-right position to client area: x:%d, y:%d\n", rect.right, rect.bottom);
		}
	*/
	void	ScreenToClient(RECT * lpRect);
	
	/**
	*/
	BOOL	Enable;

	/**
	Example:
		void test_IsWindowVisible()
		{
			for(int ii = 0; ii <= OGW_NUM_WIN_TYPES; ii++)
			{
				Window ww(GetWindow(ii));
				printf("Index %d:", ii);
				if(ww)
				{
					if(ww.Visible)
					{
						RECT rect;
						ww.GetClientRect(&rect);
						printf("%[%d:%d], width=%d, height=%d\n", rect.left, rect.top, rect.right-rect.left, rect.bottom-rect.top);
					}
					else
						out_str("Hidden");
				}
				else
					out_str("Not available");
			}
		}
	*/
	BOOL	Visible;

	/**
	*/	
	string	Text;

	/**
	    Remark:
			This function checks if window is maximized. 
		Return:
			Return TRUE if the window is maximized, otherwise, FALSE.. 
	*/
	BOOL	IsZoomed();

	/**
	    Remark:
			This function checks if window is minimized. 
		Return:
			Return TRUE if the window is minimized, otherwise, FALSE.. 
	*/
	BOOL	IsIconic();
	
	/** 
		Set stock logic font for the control
	Example:
		RichEdit richEdit = EditBoxes.GetItem(IDC_RICHEDIT1);		
	
		richEdit.SetFont(OEM_FIXED_FONT);
		
	Parameters:
		nFontNumber
			the Stock Logic font number, can be one of following,
			OEM_FIXED_FONT,      
			ANSI_FIXED_FONT,     
			ANSI_VAR_FONT,       
			SYSTEM_FONT,         
			DEVICE_DEFAULT_FONT, 
			SYSTEM_FIXED_FONT.   
	Return:
		None.
	*/
	void SetFont(int nFontNumber);
	
	/**
	*/
	Window	GetDlgItem(int nChildWinID);
	
	/**
	*/
	Window	GetParent();

#ifdef	ORIGIN_COM_SUPPORT
	/**
		This function provides COM support for ActiveX controls that are placed into Origin windows or Dialog Builder winodws.
	Remarks:
		This function is available only for OriginPro versions, or with a special COM enabled license
	Example:
		static void UpdateMatrixGraph()
		{
			Matrix myMat("Matrix1");
			
			if(myMat)
			{
				Object CWKnob1 = MyDlg.GetItem(IDC_CWKNOB1).GetActiveXControl();
				double dNoiseLevel = CWKnob1.Value;
				
				Object CWSlide1 = MyDlg.GetItem(IDC_CWSLIDE1).GetActiveXControl();
				double vv = CWSlide1.Value;
				double dPeakHalfWidth = 5. / (vv+1.);
				fill_mat_with_values(myMat, 0.2, 0.4, 15.0, dPeakHalfWidth, dNoiseLevel);
				
				Object CW3DGraph1 = MyDlg.GetItem(IDC_CWGRAPH3D1).GetActiveXControl();
				_VARIANT	var = myMat;
				CW3DGraph1.Plot3DSimpleSurface(var);
			}
		}
		
	*/
	_VARIANT GetActiveXControl();
	
#endif //#ifdef	ORIGIN_COM_SUPPORT

	/**
		Identifies the device context for the window client area if successful; otherwise, the return value is NULL.
	Example:
		int get_pixels_per_inch(bool bX = true)
		{
			DeviceContext dc = MyDlg.GetWindow().GetDC();
			return dc.GetDeviceCaps(bX? LOGPIXELSX : LOGPIXELSY);
		}
	*/
	DeviceContext GetDC( );
	
	/**
			This method retrieves the identifier of the currently checked radio button in the specified group.
		Parameters:
			nIDFirstButton: Specifies the integer identifier of the first radio button in the group. 
			nIDLastButton: Specifies the integer identifier of the last radio button in the group. 
		Return:
				ID of the checked radio button, or zero if none is selected.
	*/
	int GetCheckedRadioButton( int nIDFirstButton, int nIDLastButton );
	/**
			This method selects, adds a check mark to a specified radio button in a group and clears, removes a check 
			mark from all other radio buttons in the group. 
		Parameters:
			nIDFirstButton: Specifies the integer identifier of the first radio button in the group. 
			nIDLastButton: Specifies the integer identifier of the last radio button in the group. 
			nIDCheckButton: Specifies the integer identifier of the radio button to be checked. 
	*/
	void CheckRadioButton( int nIDFirstButton, int nIDLastButton, int nIDCheckButton );
	
	/**
		read only
		Example:
			void Run_FontName()
			{
				MyDlg.GetWindow().SetFont(SYSTEM_FONT);
				string strFont = MyDlg.GetWindow().FontName;	
				out_str(strFont);
				
				double dSize = MyDlg.GetWindow().FontSize;	
				out_double("",dSize);	
			}
	*/
	string FontName;

	/**
		read only
		SeeAlso:
			FontName
	*/
	double	FontSize;// in points
};




/*
 * ShowWindow() Commands
 */
#define SW_HIDE             0
#define SW_SHOWNORMAL       1
#define SW_NORMAL           1
#define SW_SHOWMINIMIZED    2
#define SW_SHOWMAXIMIZED    3
#define SW_MAXIMIZE         3
#define SW_SHOWNOACTIVATE   4
#define SW_SHOW             5
#define SW_MINIMIZE         6
#define SW_SHOWMINNOACTIVE  7
#define SW_SHOWNA           8
#define SW_RESTORE          9
#define SW_SHOWDEFAULT      10
#define SW_FORCEMINIMIZE    11
#define SW_MAX              11

#ifndef NOSCROLL

/*
 * Scroll Bar Constants
 */
#define SB_HORZ             0
#define SB_VERT             1
#define SB_CTL              2
#define SB_BOTH             3

/*
 * Scroll Bar Commands
 */
#define SB_LINEUP           0
#define SB_LINELEFT         0
#define SB_LINEDOWN         1
#define SB_LINERIGHT        1
#define SB_PAGEUP           2
#define SB_PAGELEFT         2
#define SB_PAGEDOWN         3
#define SB_PAGERIGHT        3
#define SB_THUMBPOSITION    4
#define SB_THUMBTRACK       5
#define SB_TOP              6
#define SB_LEFT             6
#define SB_BOTTOM           7
#define SB_RIGHT            7
#define SB_ENDSCROLL        8

#endif /* !NOSCROLL */


#endif // _OC_VER > 0x0703
//-------- end ORIGIN_8_FEATURES

#pragma dll(kernel32, system)


#define MAX_PATH          260

#define LOWORD(l)           ((WORD)(l))
#define HIWORD(l)           ((WORD)(((DWORD)(l) >> 16) & 0xFFFF))
#define LOBYTE(w)           ((BYTE)(w))
#define HIBYTE(w)           ((BYTE)(((WORD)(w) >> 8) & 0xFF))


#define DeleteFile  DeleteFileA
/** >File Management
		Delete an existing file.
	Parameters:
		lpFileName = null-terminated string that specifies the file to be deleted. 
	Return:
		If the function succeeds, the return value is nonzero.
		If the function fails, the return value is zero.
	Example:
		string str = "c:\\mytempfile.txt"; 
		if( DeleteFile(str) )
			printf("%s deleted\n", str);
		else
			printf("%s was not deleted\n", str);
*/
BOOL WINAPI DeleteFile(LPCTSTR lpFileName); // Delete an existing file.

/** >System
		The GetTickCount function retrieves the number of milliseconds that have elapsed since the system was started.
		It is limited to the resolution of the system timer.
		It is often used to measure time needed to complete an operation (see the example).
	Parameters:
		None.
	Return:
		the number of milliseconds ellapsed since the system was restarted.
	Example:
		// This example measures how much time (in milliseconds) it takes
		// to execute an empty for-loop of 1000.
		void	run_GetTickCount()
		{
			DWORD dw1 = GetTickCount();
			
			for(int ii = 0; ii < 1000; ii++)
				;
			
			printf("Empty loop of 1000 takes %d ms\n",GetTickCount()-dw1);
		}		
*/
UINT WINAPI GetTickCount();// Retrieve number of milliseconds elapsed since the system was started

/** >System
		Retrieve current version number of the operating system.
	Parameters:
		None.
	Return:
		the version number. The low byte of the low word is the major OS version, the high byte
		of the low word is the minor OS version. The highest bit determines the platform: it is
		on for Windows 95, 98, and Me, it is off for Windows NT, 2000, XP.
	Example:
		// This example checks if the operating system is of "NT-type"
		// (which means Windows NT, 2000, XP).
		bool is_OS_NT_type()
		{
			DWORD	dwVersion = GetVersion();
			// Get major and minor version numbers of Windows
			WORD loword = LOWORD(dwVersion);
			int lowbyte = LOBYTE(loword);
			int hibyte =  HIBYTE(loword);
				
			printf("Window major version = %d and minor version = %d\n", lowbyte, hibyte);
			
			if(!(dwVersion & 0x80000000))                // Windows NT, 2000, XP
				return TRUE;
			else         // Windows 95, 98, ME
				return FALSE;
		}
*/
UINT WINAPI GetVersion();

/** >System
		It puts the application to a halt for the specified number of milliseconds.
	Parameters:
		dwMilliseconds - the number of milliseconds to sleep.
	Return:
		none
	Example:
		void	run_Sleep()
		{
			out_str("Before Sleep");
			Sleep(1000);	// sleep for one second
			out_str("After Sleep");
		}
*/
void WINAPI Sleep(DWORD dwMilliseconds);

////////////////////////////////////////////////////////
////// begin Global memory functions
////////////////////////////////////////////////////////
typedef HANDLE HGLOBAL;
#define GMEM_FIXED          0x0000
#define GMEM_MOVEABLE       0x0002
#define GMEM_NOCOMPACT      0x0010
#define GMEM_NODISCARD      0x0020
#define GMEM_ZEROINIT       0x0040
#define GMEM_MODIFY         0x0080
#define GMEM_DISCARDABLE    0x0100
#define GMEM_NOT_BANKED     0x1000
#define GMEM_SHARE          0x2000
#define GMEM_DDESHARE       0x2000
#define GMEM_NOTIFY         0x4000
#define GMEM_LOWER          GMEM_NOT_BANKED
#define GMEM_VALID_FLAGS    0x7F72
#define GMEM_INVALID_HANDLE 0x8000

#define GHND                (GMEM_MOVEABLE | GMEM_ZEROINIT)

/** >Memory Management
	Parameters:
		uFlags = Memory allocation attributes. If zero is specified, the default is GMEM_FIXED. 
		This parameter can be one or more of the following values, except for the incompatible combinations that are specifically noted. 
		dwBytes = Number of bytes to allocate. 	If this parameter is zero and the uFlags parameter specifies GMEM_MOVEABLE, 
		the function returns a handle to a memory object that is marked as discarded. 
		
	Return:
		If the function succeeds, the return value is a handle to the newly allocated memory object.
		If the function fails, the return value is NULL.
		
	Example:
		void Test_Global_Memory()
		{	
			string 		strTemp = "Test GlobalAlloc!";
			int nMemSize = strTemp.GetLength() + 1;    
				    
			HANDLE hData = GlobalAlloc(GHND,nMemSize);
			if( !hData )
			{
				out_str("failed!");
				return;
			}
					
			DWORD	dSize = GlobalSize(hData);
			if( dSize != nMemSize )
			{
				out_str("failed!");
			}
			
			LPSTR lpData = (LPSTR)GlobalLock(hData);	
			lstrcpyn(lpData, strTemp, nMemSize);
			GlobalUnlock(hData);
			
			if( NULL == GlobalReAlloc(hData, nMemSize*2, GMEM_MOVEABLE) )
			{
				out_str("failed");
				return;
			}
			else
			{
				if( nMemSize*2 != GlobalSize(hData))
				{
					out_str("failed!");
				}
			}	
					
			if( NULL != GlobalFree(hData) )
			{
				out_str("failed!");
			}
		}
*/
HGLOBAL WINAPI GlobalAlloc(UINT uFlags, DWORD dwBytes);

/** >Memory Management
	Parameters:
		hMem = Handle to the global memory object to be reallocated.
		dwBytes = New size of the memory block, in bytes. If uFlags specifies GMEM_MODIFY, this parameter is ignored.
		uFlags = Reallocation options.
	Return:
		If the function succeeds, the return value is a handle to the reallocated memory object.
		If the function fails, the return value is NULL.
	SeeAlso:
		GlobalAlloc
*/
HGLOBAL WINAPI GlobalReAlloc(HGLOBAL hMem, DWORD dwBytes, UINT uFlags);

/** >Memory Management
	Parameters:
		hMem = Handle to the global memory object.
	Return:
		If the function succeeds, the return value is NULL.
		If the function fails, the return value is equal to a handle to the global memory object.
	SeeAlso:
		GlobalAlloc
*/
HGLOBAL WINAPI GlobalFree(HGLOBAL hMem);

/** >Memory Management
	Parameters:
		hMem = Handle to the global memory object.
	Return:
		If the function succeeds, the return value is the size of the specified global memory object, in bytes.
	SeeAlso:
		GlobalAlloc		
*/
DWORD WINAPI GlobalSize(HGLOBAL hMem);

/** >Memory Management
	Parameters:
		hMem = Handle to the global memory object.
	Return:
		If the function succeeds, the return value is a pointer to the first byte of the memory block.
		If the function fails, the return value is NULL.
	SeeAlso:
		GlobalAlloc
*/
LPVOID WINAPI GlobalLock(HGLOBAL hMem);

/** >Memory Management
	Parameters:
		hMem = Handle to the global memory object.
	Return values:
		If the memory object is still locked after decrementing the lock count, the return value is a nonzero value.
		If the function fails, the return value is zero.
	SeeAlso:
		GlobalAlloc
*/
BOOL WINAPI GlobalUnlock(HGLOBAL hMem);

////////////////////////////////////////////////////////
////// end Global memory functions
////////////////////////////////////////////////////////

#define SetEnvironmentVariable  SetEnvironmentVariableA
#define GetEnvironmentVariable  GetEnvironmentVariableA

/** >System
		This function retrieves the value of the specified variable from the environment block 
		of the calling process. The value is in the form of a null-terminated string of characters.
	Parameters:
		lpcszName = environment variable name
  		lpBuffer = buffer for variable value
  		nSize =    size of buffer
.
	Return:
		If the function succeeds, the return value is the number of characters stored into the buffer 
		pointed to by lpBuffer, not including the terminating null character. 
		If the specified environment variable name was not found in the environment block for the current process, 
		the return value is zero. 

		If the buffer pointed to by lpBuffer is not large enough, the return value is the buffer size, in characters, 
		required to hold the value string and its terminating null character. 

	Example:
	// usage:
	// show_environment_str path;
	// show_environment_str temp;
	void show_environment_str(string strName)
	{
		char szTemp[MAXFULLPATH];
		
		int	nResult = GetEnvironmentVariable(strName, szTemp, MAXFULLPATH);
		
		if(nResult > 0)
		{
			if(nResult == lstrlen(szTemp))
				out_str(szTemp);
			else
				printf("The %s environment variable is too big (%d bytes)\n",strName,nResult);
		}
		else
			out_str("Error: Environment variable not found.");
	}
*/
DWORD WINAPI GetEnvironmentVariable(LPCSTR lpcszName, LPSTR lpBuffer, DWORD nSize);

/** >System
		This function sets the value of an environment variable for the current process. 
	Parameters:
		lpcszName = environment variable name
  		lpcszValue = new value for environment variable
.
	Return:
		TRUE for success
		
	Example:
	// usage:
	// set_environment_str test "A new string for testing";
	// show_environment_str test;
	void set_environment_str(string strName, string strValue)
	{
		if(SetEnvironmentVariable(strName, strValue))
			return;
		out_str("error calling SetEnvironmentVariable");
	}
*/
BOOL WINAPI SetEnvironmentVariable(LPCSTR lpcszName, LPCSTR lpcszValue);

/** >File Management
		This function closes an open object handle. 
	Parameters:
		hObject = [in/out] Handle to an open object. 
	Return:
		TRUE for success
	SeeAlso:
		CreateFile
*/
BOOL WINAPI CloseHandle(HANDLE hObject);

//
//  The following are masks for the predefined standard access types
//
#define DELETE                           (0x00010000L)
#define READ_CONTROL                     (0x00020000L)
#define WRITE_DAC                        (0x00040000L)
#define WRITE_OWNER                      (0x00080000L)
#define SYNCHRONIZE                      (0x00100000L)

#define STANDARD_RIGHTS_REQUIRED         (0x000F0000L)
#define STANDARD_RIGHTS_READ             (READ_CONTROL)
#define STANDARD_RIGHTS_WRITE            (READ_CONTROL)
#define STANDARD_RIGHTS_EXECUTE          (READ_CONTROL)

#define STANDARD_RIGHTS_ALL              (0x001F0000L)
#define SPECIFIC_RIGHTS_ALL              (0x0000FFFFL)
//
// AccessSystemAcl access type
//
#define ACCESS_SYSTEM_SECURITY           (0x01000000L)
//
// MaximumAllowed access type
//
#define MAXIMUM_ALLOWED                  (0x02000000L)
//
//  These are the generic rights.
//
#define GENERIC_READ                     (0x80000000L)
#define GENERIC_WRITE                    (0x40000000L)
#define GENERIC_EXECUTE                  (0x20000000L)
#define GENERIC_ALL                      (0x10000000L)

#define CREATE_NEW          1
#define CREATE_ALWAYS       2
#define OPEN_EXISTING       3
#define OPEN_ALWAYS         4
#define TRUNCATE_EXISTING   5

#define CreateFile  CreateFileA
typedef struct _SECURITY_ATTRIBUTES {
    DWORD nLength;
    LPVOID lpSecurityDescriptor;
    BOOL bInheritHandle;
} SECURITY_ATTRIBUTES;

/** >File Management
		This function creates or opens an objects and returns a handle that can be used to access the object. 
	Parameters:
		lpFileName = [in] A fullpath file name
		dwDesiredAccess = [in] Specifies the type of access to the object. This parameter can be 0, GENERIC_READ, GENERIC_WRITE
		dwShareMode = [in] Specifies how the object can be shared. If dwShareMode is 0, and CreateFile succeeds, the object cannot be shared and cannot be opened again until the handle is closed.
		lpSecurityAttributes = [in] Pointer to a SECURITY_ATTRIBUTES structure that determines whether the returned handle can be inherited by child processes. Use NULL if no need for the handle to be inherited. 
		dwCreationDisposition = [in] Specifies which action to take on files that exist, and which action to take when files do not exist. Can be CREATE_NEW, CREATE_ALWAYS, OPEN_EXISTING, OPEN_ALWAYS, TRUNCATE_EXISTING
		dwFlagsAndAttributes = [in] Specifies the file attributes and flags for the file. 
		hTemplateFile = [in] Specifies a handle with GENERIC_READ access to a template file. The template file supplies file attributes and extended attributes for the file being created. 
	Return:
		If the function succeeds, the return value is an open handle to the specified file. 
		If the function fails, the return value is INVALID_HANDLE_VALUE. 
	Example:
		//opens an existing file for reading.
		bool test_read_file(LPCSTR lpcszFilename)
		{
			HANDLE hFile; 
			hFile = CreateFile(lpcszFilename, 
			                GENERIC_READ,              // open for reading 
			                FILE_SHARE_READ,           // share for reading 
			                NULL,                      // no security 
			                OPEN_EXISTING,             // existing file only 
			                FILE_ATTRIBUTE_NORMAL,     // normal file 
			                NULL);                     // no attr. template 
			if (hFile == INVALID_HANDLE_VALUE) 
			{ 
				out_str("Could not open file.");   // process error
				return false;
			} 
	        // codes to read the file
	        CloseHandle(hFile);// must close file after reading
	        return true;
		}
		
	SeeAlso:
		CloseHandle
*/
HANDLE WINAPI CreateFile(LPCSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, SECURITY_ATTRIBUTES* lpSecurityAttributes, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile);

typedef struct _FILETIME {
    DWORD dwLowDateTime;
    DWORD dwHighDateTime;
} FILETIME;

#define INVALID_HANDLE_VALUE (HANDLE)-1

#define FindFirstFile  FindFirstFileA
#define FindNextFile  FindNextFileA
typedef struct _WIN32_FIND_DATAA {
    DWORD dwFileAttributes;
    FILETIME ftCreationTime;
    FILETIME ftLastAccessTime;
    FILETIME ftLastWriteTime;
    DWORD nFileSizeHigh;
    DWORD nFileSizeLow;
    DWORD dwReserved0;
    DWORD dwReserved1;
    char   cFileName[ MAX_PATH ];
    char   cAlternateFileName[ 14 ];
} WIN32_FIND_DATAA;

/** >File Management
		Searches a directory for a file whose name matches the specified file name (wildcards
		are allowed). One can use this function in combination with FindNextFile and FindClose 
		to find all the files in the specified directory.
	Parameters:
		lpFileName = the wildcard pattern which the file name must match
		lpFindFileData = pointer to a structure WIN32_FIND_DATAA which will receive the information
						about each file
	Example:
		// a DOS dir command
		// can type into ScriptWindow "dir c:\*.*", for example.
		//
		void dir(string strFile)
		{
			WIN32_FIND_DATAA	find;
			HANDLE	hFile;

			//out_str(strFile);
			int	nCount = 0;
			
			if((hFile=FindFirstFile(strFile,&find)) != INVALID_HANDLE_VALUE)
			{
				out_str(find.cFileName);
				nCount++;
				while(FindNextFile(hFile,&find))
				{
					out_str(find.cFileName);
					nCount++;
				}
				printf("%d files found\n",nCount);
				FindClose(hFile);		// must close  the hadle
			}
			else
				printf("%s: file(s) not found\n",strFile);
		}
	SeeAlso:
		FindNextFile
*/
HANDLE WINAPI FindFirstFile(LPCSTR lpFileName, WIN32_FIND_DATAA *lpFindFileData);

/** >File Management
	SeeAlso:
		FindFirstFile
*/
BOOL WINAPI	FindNextFile(HANDLE hFindFile, WIN32_FIND_DATAA *lpFindFileData);

/** >File Management
	SeeAlso:
		FindFirstFile
*/
BOOL WINAPI	FindClose(HANDLE hFindFile);

typedef struct _WIN32_FILE_ATTRIBUTE_DATA {
    DWORD dwFileAttributes;
    FILETIME ftCreationTime;
    FILETIME ftLastAccessTime;
    FILETIME ftLastWriteTime;
    DWORD nFileSizeHigh;
    DWORD nFileSizeLow;
} WIN32_FILE_ATTRIBUTE_DATA;

#define FILE_SHARE_READ                 0x00000001  
#define FILE_SHARE_WRITE                0x00000002  
#define FILE_SHARE_DELETE               0x00000004  
// dwFileAttributes are defined as follows
#define FILE_ATTRIBUTE_READONLY             0x00000001  
#define FILE_ATTRIBUTE_HIDDEN               0x00000002  
#define FILE_ATTRIBUTE_SYSTEM               0x00000004  
#define FILE_ATTRIBUTE_DIRECTORY            0x00000010  
#define FILE_ATTRIBUTE_ARCHIVE              0x00000020  
#define FILE_ATTRIBUTE_ENCRYPTED            0x00000040  
#define FILE_ATTRIBUTE_NORMAL               0x00000080  
#define FILE_ATTRIBUTE_TEMPORARY            0x00000100  
#define FILE_ATTRIBUTE_SPARSE_FILE          0x00000200  
#define FILE_ATTRIBUTE_REPARSE_POINT        0x00000400  
#define FILE_ATTRIBUTE_COMPRESSED           0x00000800  
#define FILE_ATTRIBUTE_OFFLINE              0x00001000  
#define FILE_ATTRIBUTE_NOT_CONTENT_INDEXED  0x00002000  


#define GetFileAttributes  GetFileAttributesA
/** >File Management
		Retrieves given file attributes.
	Parameters:
		lpcszFilename = full pathname of the file.
	Return:
		a bitfield with the following possible bits:
		FILE_ATTRIBUTE_READONLY             0x00000001  
		FILE_ATTRIBUTE_HIDDEN               0x00000002  
		FILE_ATTRIBUTE_SYSTEM               0x00000004  
		FILE_ATTRIBUTE_DIRECTORY            0x00000010  
		FILE_ATTRIBUTE_ARCHIVE              0x00000020  
		FILE_ATTRIBUTE_ENCRYPTED            0x00000040  
		FILE_ATTRIBUTE_NORMAL               0x00000080  
		FILE_ATTRIBUTE_TEMPORARY            0x00000100  
		FILE_ATTRIBUTE_SPARSE_FILE          0x00000200  
		FILE_ATTRIBUTE_REPARSE_POINT        0x00000400  
		FILE_ATTRIBUTE_COMPRESSED           0x00000800  
		FILE_ATTRIBUTE_OFFLINE              0x00001000  
		FILE_ATTRIBUTE_NOT_CONTENT_INDEXED  0x00002000  
	Example:
		void	run_GetFileAttributes()
		{
			DWORD	dwAttributes = GetFileAttributes("c:\\config.sys");
			printf("File attributes are: %#x\n", dwAttributes);
		}
*/
DWORD WINAPI GetFileAttributes(LPCSTR lpcszFilename);

#define GetFileAttributesEx  GetFileAttributesExA
/**# File Management
		Retrieves attributes for a specified file or directory.
		It is similar to GetFileAttributes, but it returns more information - 
		in addition to attributes, it also returns various file times and file size.
	Parameters:
		lpcszFilename = full pathname of the file
		nInfoLevel = must be 0.
		lpFileInfo = pointer to the WIN32_FILE_ATTRIBUTE_DATA which will receive the information
					about the file:
					typedef struct _WIN32_FILE_ATTRIBUTE_DATA {
					    DWORD dwFileAttributes;		// attributes (the same as for the function GetFileAttributes)
					    FILETIME ftCreationTime;	// creation time
					    FILETIME ftLastAccessTime;	// last access time
					    FILETIME ftLastWriteTime;	// last modification time
					    DWORD nFileSizeHigh;		// the high DWORD of the file size (it is zero unless the file is over four gigabytes)
					    DWORD nFileSizeLow;			// the low DWORD of thr file size
					} WIN32_FILE_ATTRIBUTE_DATA;
	Returns:
		Returns FALSE if file sepcified is not a valid file name or directory name
		Returns TRUE if succeed
	Examples:
		void run_GetFileAttributesEx(string filename)
		{
			WIN32_FILE_ATTRIBUTE_DATA	fileInfo;
		
			if(GetFileAttributesEx(filename, 0, &fileInfo))
			{
				int	nSize = fileInfo.nFileSizeLow;
				out_int("File size=", nSize);
			}
			else
				out_str("file not found");
		}
*/
BOOL WINAPI GetFileAttributesEx(
	LPCSTR lpcszFilename, 	  // file or directory
	int nInfoLevel, 		  // must be set to 0
	WIN32_FILE_ATTRIBUTE_DATA* lpFileInfo  // pointer to the structure
	);

#define SetFileAttributes  SetFileAttributesA
/** >File Management
		It sets file attributes.
	Parameters:
		lpcszFilename = full pathname of the file.
		dwFileAttributes = new attributes
	Return:
		nonzero if it succeeds, 0 if it fails.
	Example:
		// This example shows how to change file attributes of a file.
		// Note that the file c:\myfile.txt must exist for this example to run.
		void	run_SetFileAttributes()
		{
			string		strFile = "c:\\myfile.txt";
			
			// First get and display the old attributes:
			DWORD	dwAttributes = GetFileAttributes(strFile);
			printf("File attributes are: %#x\n", dwAttributes);
			
			// Change the attributes:
			SetFileAttributes(strFile, 0x22);
			
			// Display again:
			dwAttributes = GetFileAttributes(strFile);
			printf("File attributes are: %#x\n", dwAttributes);
		}
*/
BOOL WINAPI SetFileAttributes(LPCSTR lpcszFilename,DWORD dwFileAttributes); //set a file's attributes


//
// Routines to convert back and forth between system time and file time
//
/** >File Management
		Converts a 64-bit file time (in form of a FILETIME structure) to system time format.
	Parameters:
		lpFileTime = the pointer to the 64-bit file time (usually obtained from GetFileAttributesEx() function as one of the
						members of the WIN32_FILE_ATTRIBUTE_DATA structure).
		lpSystemTime = the pointer to the SYSTEMTIME structure which will receive the result. The members of SYSTEMTIME
						structure provide a human-readable form of date and time.
	Returns:
		nonzero for success, 0 for failure.
	Example:
		// The example displays system time of one file.
		// Note that the file c:\myfile.txt must exist for this example to run.
		void	run_FileTimeToSystemTime()
		{
			string						strFile = "c:\\myfile.txt";
			WIN32_FILE_ATTRIBUTE_DATA	fileInfo;
			// Get the attributes structure of the file
			if ( GetFileAttributesEx(strFile, 0, &fileInfo) )
			{
				SYSTEMTIME		stSystemTime;
				// Convert the last access time to SYSTEMTIME structure: 
				if ( FileTimeToSystemTime(&fileInfo.ftLastAccessTime, &stSystemTime) )
				{
					printf("Year = %d,  Month = %d,  Day = %d,  Hour = %d,  Minute = %d\n", stSystemTime.wYear, stSystemTime.wMonth, stSystemTime.wDay, stSystemTime.wHour, stSystemTime.wMinute);
				}
			}
			else
				out_str("Cannot get file attributes!");
		}


	SeeAlso:
		SystemTimeToFileTime
*/
BOOL WINAPI FileTimeToSystemTime(
    const FILETIME *lpFileTime,
    SYSTEMTIME* lpSystemTime
    );

/**# >File Management
	Converts a system time to 64-bit file time
	SeeAlso:
		SetFileTime
*/
BOOL WINAPI SystemTimeToFileTime(
    const SYSTEMTIME *lpSystemTime,
    FILETIME* lpFileTime
    );

/** >File Management
	This function sets the date and time that a file was created, last accessed, or last modified.
	Parameters
		hFile = [in] Handle to the file for which to set the dates and times. The file handle must have been created with GENERIC_WRITE access to the file. 
		lpCreationTime = [in] Pointer to a FILETIME structure that contains the date and time the file was created. This parameter can be NULL if the application does not need to set this information. 
		lpLastAccessTime = [in] Pointer to a FILETIME structure that contains the date and time the file was last accessed. The last access time includes the last time the file was written to, read from, or (in the case of executable files) run. This parameter can be NULL if the application does not need to set this information. 
		lpLastWriteTime = [in] Pointer to a FILETIME structure that contains the date and time the file was last written to. This parameter can be NULL if the application does not want to set this information. 
	Return:
		TRUE if success, FALSE if error
	Example:
		BOOL SetFileToCurrentTime(LPCSTR lpcszFilename)
		{
			BOOL bRet = FALSE;
			HANDLE hFile = CreateFile(lpcszFilename, GENERIC_WRITE, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
			if (hFile != INVALID_HANDLE_VALUE)
			{
				FILETIME ft;
				SYSTEMTIME st;
				GetSystemTime(&st);              // gets current time
				SystemTimeToFileTime(&st, &ft);  // converts to file time format
				bRet = SetFileTime(hFile,NULL, NULL, &ft);
				CloseHandle(hFile);
			}
			return bRet;
		}
	SeeAlso:
		FileTimeToSystemTime
*/
BOOL WINAPI SetFileTime(HANDLE hFile, const FILETIME *lpCreationTime, const FILETIME *lpLastAccessTime, const FILETIME *lpLastWriteTime);

/** >Date Time
	This function retrieves the current system date and time. The system time is expressed in Coordinated Universal Time (UTC). 
	Parameters:
		lpSystemTime = pointer to the SYSTEM struct to receive the date and time
	SeeAlso:
		SetFileTime, FileTimeToSystemTime, SystemTimeToJulianDate
*/
void WINAPI GetSystemTime(SYSTEMTIME* lpSystemTime);

    
/** >File Management
	The FileTimeToLocalFileTime function converts a file time to a local file time. 

	Remark:
		This function uses the current settings for the time zone and daylight saving time.
		Therefore, if it is daylight saving time, this function will take daylight saving time 
		into account, even if the time you are converting is in standard time. 

	Parameters:
		lpFileTime = pointer to file time to convert
		lpLocalFileTime = pointer to a FILETIME struct to receive the converted value
	Return:
		TRUE if success, FALSE if error
	Example:
		bool show_file_time(LPCSTR lpcsFilename)
		{
			WIN32_FILE_ATTRIBUTE_DATA	fileInfo;
		
			if(GetFileAttributesEx(lpcsFilename, 0, &fileInfo))
			{
				FILETIME localFiletime;
				if(FileTimeToLocalFileTime(&fileInfo.ftLastWriteTime, &localFiletime))
				{
					SYSTEMTIME sysTime;
					if(FileTimeToSystemTime(&localFiletime, &sysTime))
					{
						printf("%s is last modified at %.2d-%.2d-%4d %.2d:%.2d:%.2d\n",
						lpcsFilename,
						sysTime.wMonth,sysTime.wDay,sysTime.wYear,
						sysTime.wHour, sysTime.wMinute, sysTime.wSecond);
						return TRUE;
					}
				}
			}
			return FALSE;
		}

*/
BOOL WINAPI FileTimeToLocalFileTime(
    const FILETIME *lpFileTime,	// file time to convert
    FILETIME* lpLocalFileTime	// receives system time
    );

/**# >File Management
*/
BOOL WINAPI LocalFileTimeToFileTime(
    const FILETIME *lpLocalFileTime,
    FILETIME* lpFileTime
    );

/** >File Management
		compares two 64-bit file times
	Parameters:
		lpFileTime1 = pointer to the first file time
		lpFileTime2 = pointer to the second file time
	Return:
			-1 First file time is less than second file time. 
			0 First file time is equal to second file time. 
			+1 First file time is greater than second file time.
	Example:
		// Note that the file c:\myfile.txt must exist for this example to run.
		void	run_CompareFileTime()
		{
			string						strFile = "c:\\myfile.txt";
			WIN32_FILE_ATTRIBUTE_DATA	fileInfo;
			// Get the attributes structure of the file
			if ( GetFileAttributesEx(strFile, 0, &fileInfo) )
			{
				int		nCompare = CompareFileTime(&fileInfo.ftLastAccessTime, &fileInfo.ftLastWriteTime);
				if (nCompare < 0)
					out_str("Last access time is less than last write time");
				else if (0 == nCompare)
					out_str("Last access time is the same as last write time");
				else
					out_str("Last access time is greater than last write time");
			}
			else
				out_str("Cannot get file attributes!");
		}
*/
LONG WINAPI CompareFileTime(
    const FILETIME *lpFileTime1,
    const FILETIME *lpFileTime2
    );

/**# >File Management
	converts a 64-bit file time to MS-DOS date and time values
	Parameters:
	lpFatDate = Pointer to a variable to receive the MS-DOS date.
		The date is a packed 16-bit value with the following bits Contents 
			0-4 Day of the month (1-31) 
			5-8 Month (1 = January, 2 = February, etc.) 
			9-15 Year offset from 1980 (add 1980 to get actual year) 
	lpFatTime = Pointer to a variable to receive the MS-DOS time.
		The time is a packed 16-bit value with the following bits Contents 
			0-4 Second divided by 2 
			5-10 Minute (0-59) 
			11-15 Hour (023 on a 24-hour clock)
	Example:
		void Run_FileTimeToDosDateTime(string& strFile)
		{	
			
			WORD			FatDate;
			WORD			FatTime;
			FILETIME	 	localFiletime;	
			WIN32_FILE_ATTRIBUTE_DATA	fileInfo;	
			
			if(!GetFileAttributesEx(strFile, 0, &fileInfo))
			{
				return;
			}
			
			FileTimeToLocalFileTime(&fileInfo.ftLastWriteTime, &localFiletime);	
			FileTimeToDosDateTime(&localFiletime, &FatDate, &FatTime);
		
			int nYear = ((FatDate/512)& 255) +1980 ;	//9-15  bits
			int nMonth = (FatDate/32) & 15;				//5-8   bits
			int nDay = FatDate & 31;					//0-4   bits
			
			FILETIME		FileTime;
			DosDateTimeToFileTime(FatDate, FatTime, &FileTime);	
			ASSERT(0 == CompareFileTime(&FileTime, &localFiletime) );
			
			FILETIME	ToFileTime;
			if( LocalFileTimeToFileTime(&fileInfo.ftLastAccessTime,&ToFileTime) )
			{
				ASSERT( 0 != ToFileTime.dwLowDateTime );
				ASSERT( 0 != ToFileTime.dwHighDateTime );
			}	
		}

*/
BOOL WINAPI FileTimeToDosDateTime(
    const FILETIME *lpFileTime,
    WORD* lpFatDate,
    WORD* lpFatTime
    );

/**# >File Management
	SeeAlso:
		FileTimeToDosDateTime
*/
BOOL WINAPI DosDateTimeToFileTime(
    WORD wFatDate,
    WORD wFatTime,
    FILETIME* lpFileTime
    );

#define	GetTempPath	GetTempPathA
/** >File Management
	The GetTempPath function retrieves the path of the directory designated for temporary files.
	Parameter:
		nBufferLength = Specifies the size, in TCHARs, of the string buffer identified by lpBuffer. 
		lpBuffer = Pointer to a string buffer that receives the null-terminated string specifying the temporary file path. The returned string ends with a backslash, for example, C:\TEMP\. 
 	Return:
 		If the function succeeds, the return value is the length, not including the terminating null character. 
 		If the return value is greater than nBufferLength, the return value is the size of the buffer required to hold the path. 
		If the function fails, the return value is zero.
	Example:
		void	run_GetTempPath()
		{
			char		sztemp[MAXFULLPATH];
			DWORD		aa = GetTempPath(MAXFULLPATH, sztemp);
			out_str(sztemp);
		}
*/
DWORD WINAPI GetTempPath(
	DWORD nBufferLength, 
	LPSTR lpBuffer);

#define	GetTempFileName	GetTempFileNameA
/** >File Management
	This function creates a name for a temporary file.
	Parameter:
		lpPathName = A null-terminated string that specifies the directory path for the filename. 
		lpPrefixString = A null-terminated prefix string. The function uses the first three characters of this string as the prefix of the filename
		uUnique = An unsigned integer that the function converts to a hexadecimal string for use in creating the temporary filename.
		If nonzero, the function appends the hexadecimal string to lpPrefixString. In this case, the function does not create the specified file nor test whether the filename is unique.
		If zero, the function uses a hexadecimal string derived from the current system time. In this case, the function uses different values until it finds a unique filename, and then it creates the file in the lpPathName directory.
		lpTempFileName = Buffer that receives the filename. The buffer size should be at least MAX_PATH.
 	Return:
 		If the function succeeds, the return value specifies the unique numeric value used in the temporary filename. If the uUnique parameter is nonzero, the return value specifies that same number.
		If the function fails, the return value is zero.
	Example:
		void test_TempFileNameInTempPath()
		{
			string strFile;
			char sz[MAXFULLPATH];
			DWORD dw = GetTempPath(MAXFULLPATH, sz);
			if( dw )
			{
				strFile = sz;
				dw = GetTempFileName(strFile, "Origin", 0, sz);
				if( dw )
					strFile = sz;
				else
					strFile.Empty();
			}
			out_str(strFile);
		}
*/
DWORD WINAPI GetTempFileName(
	LPCSTR lpPathName, 
	LPCSTR lpPrefixString, 
	DWORD uUnique, 
	LPSTR lpTempFileName);


#define CreateDirectory  CreateDirectoryA
/** >File Management
		The CreateDirectory function creates a new directory. 
		If the underlying file system supports security on files and directories, the function applies a specified security descriptor to the new directory
	Parameters:
		lpPathName = Pointer to a null-terminated string that specifies the path of the directory to be created.
			There is a default string size limit for paths of 248 characters. This limit is related to how the CreateDirectory function parses paths.
		lpSecurityAttributes = Pointer to a SECURITY_ATTRIBUTES structure.
			The lpSecurityDescriptor member of the structure specifies a security descriptor for the new directory. If lpSecurityAttributes is NULL, the directory gets a default security descriptor. The target file system must support security on files and directories for this parameter to have an effect. 
	Return:
		TRUE the function succeeds.
	
	Example:
		void	run_CreateDirectory()
		{
			char	szDirPath[] = "c:\\TEXTRO\\"; 
			if (!CreateDirectory(szDirPath, NULL)) 
			{ 
				out_str("Couldn't create new directory."); 
			}
		}
*/
BOOL WINAPI CreateDirectory(LPCSTR lpPathName,SECURITY_ATTRIBUTES * lpSecurityAttributes);

#define CopyFile CopyFileA
/** >File Management
		This function copies an existing file to a new file
	Parameters:
		lpExistingFileName = [in] Pointer to a null-terminated string that specifies the name of an existing file. 
		lpNewFileName =	[in] Pointer to a null-terminated string that specifies the name of the new file. 
			The name is limited to MAX_PATH characters. 

		bFailIfExists =	[in] Specifies how this operation is to proceed if a file of the same name as that specified by lpNewFileName already exists. 
			If this parameter is TRUE and the new file already exists, the function fails. 
			If this parameter is FALSE and the new file already exists, the function overwrites the existing file and succeeds. 

	Return:
		TRUE for success.

	Example:
		void	test_CopyFile()
		{
			string strTemp = GetAppPath() + "Origin.ini";
			string strNew =  GetAppPath() + "junk.ini";
			if(!strTemp.IsFile())
			{
				out_str("No Origin.ini found");
				return;
			}
			if(strNew.IsFile())
				out_str("junk.ini already existed before we copy");

			if (!CopyFile(strTemp, strNew)) 
			{
				out_str("Copy file failed");
				return;
			}
			if(!strNew.IsFile())
				out_str("Error: Copy file did not create the junk.ini even though it said it did");
		}
*/
BOOL WINAPI CopyFile(LPCSTR lpExistingFileName, LPCSTR lpNewFileName, BOOL bFailIfExists = FALSE);



////////////////////////////////////////////
// functions from Win32 User dll, mostly GUI related
//
#pragma dll(User32, system)

/**#
*/
BOOL WINAPI InvalidateRect(HWND hWnd, const RECT *lpRect, BOOL bErase);

/**#
*/
BOOL WINAPI UpdateWindow(HWND hWnd);

#define IDOK                1
#define IDCANCEL            2
#define IDABORT             3
#define IDRETRY             4
#define IDIGNORE            5
#define IDYES               6
#define IDNO                7
#define IDCLOSE         	8
#define IDHELP          	9

#ifndef NOMB

/*
 * MessageBox() Flags
 */
#define MB_OK                       0x00000000L
#define MB_OKCANCEL                 0x00000001L
#define MB_ABORTRETRYIGNORE         0x00000002L
#define MB_YESNOCANCEL              0x00000003L
#define MB_YESNO                    0x00000004L
#define MB_RETRYCANCEL              0x00000005L


#define MB_ICONHAND                 0x00000010L
#define MB_ICONQUESTION             0x00000020L
#define MB_ICONEXCLAMATION          0x00000030L
#define MB_ICONASTERISK             0x00000040L

#define MB_ICONINFORMATION          MB_ICONASTERISK
#define MB_ICONSTOP                 MB_ICONHAND

#define MB_DEFBUTTON1               0x00000000L
#define MB_DEFBUTTON2               0x00000100L
#define MB_DEFBUTTON3               0x00000200L

#define MB_APPLMODAL                0x00000000L
#define MB_SYSTEMMODAL              0x00001000L
#define MB_TASKMODAL                0x00002000L

//#define MB_NOFOCUS                  0x00008000L
//#define MB_SETFOREGROUND            0x00010000L
//#define MB_DEFAULT_DESKTOP_ONLY     0x00020000L

//#if(WINVER >= 0x0400)
//#define MB_TOPMOST                  0x00040000L
//#define MB_RIGHT                    0x00080000L
//#define MB_RTLREADING               0x00100000L
//#endif /* WINVER >= 0x0400 */


#define MB_TYPEMASK                 0x0000000FL
#define MB_ICONMASK                 0x000000F0L
#define MB_DEFMASK                  0x00000F00L
#define MB_MODEMASK                 0x00003000L
#define MB_MISCMASK                 0x0000C000L

#define MessageBox  MessageBoxA


/** >User Interface Controls
		Open a Window's message box.
	Parameters:
		hWnd = Handle of parent window
		lpText = Text of the message to be displayed
		lpCaption = Title of the message box, default is NULL
		uType = Constants describing the characteristics of the message box. One constant from each group below
			can be combined using the bitwise OR operator "|", default is MB_OK
		
			Buttons on message box:			MB_OK, MB_OKCANCEL, MB_ABORTRETRYIGNORE, MB_YESNOCANCEL, MB_YESNO,
											MB_RETRYCANCEL
			Icon on message box:			MB_ICONHAND, MB_ICONQUESTION, MB_ICONEXCLAMATION, MB_ICONASTERISK,
											MB_ICONINFORMATION, MB_ICONSTOP		
			Default button of message box:	MB_DEFBUTTON1, MB_DEFBUTTON2, MB_DEFBUTTON3
			Modality of message box:		MB_APPLMODAL, MB_SYSTEMMODAL, MB_TASKMODAL
			Mask of message box:			MB_TYPEMASK, MB_ICONMASK, MB_DEFMASK, MB_MODEMASK, MB_MISCMASK
	Return:
		Returns one of the following integer constants depending on which button is clicked: IDOK=1,
			IDCANCEL=2, IDABORT=3, IDRETRY=4, IDIGNORE=5, IDYES=6, IDNO=7, IDCLOSE=8, IDHELP=9
	Example:
		void	run_MessageBox()
		{
			if( MessageBox( GetWindow(), "Undo not available. Do you want to continue?", "Warning!" , MB_YESNO | MB_ICONQUESTION | MB_DEFBUTTON2 ) == IDNO )
			{
				out_str("\"No\" was clicked.");
				return;
			}
			out_str("\"Yes\" was clicked.");
		}
*/
int WINAPI MessageBox( HWND hWnd, LPCSTR lpText, LPCSTR lpCaption = NULL, UINT uType = MB_OK );	// Open a Windows message box.

/** >User Interface Controls
		MessageBeep plays a waveform sound. The waveform sound for each sound type is identified by an entry
		in the registry which can be accessed from the Sounds or Multi-Media applet in the Window's Control Panel.
	Parameters:
		uType=-1 for standard beep using the computer speaker or MB_ICONASTERISK, MB_ICONEXCLAMATION, MB_ICONHAND,
			MB_ICONQUESTION, or MB_OK (for system default)
	Return:
		Returns TRUE on successful exit and FALSE on error.
	Example:
		MessageBeep( -1 ); // Beep standard computer speaker
*/
BOOL WINAPI MessageBeep( UINT uType );

#endif /* !NOMB */


////////////////////////////////////////////////////////
////// begin clipboard functions
////////////////////////////////////////////////////////
#ifndef NOCLIPBOARD

/*
 * Predefined Clipboard Formats
 */
#define CF_TEXT             1
#define CF_BITMAP           2
#define CF_METAFILEPICT     3
#define CF_SYLK             4
#define CF_DIF              5
#define CF_TIFF             6
#define CF_OEMTEXT          7
#define CF_DIB              8
#define CF_PALETTE          9
#define CF_PENDATA          10
#define CF_RIFF             11
#define CF_WAVE             12
#define CF_UNICODETEXT      13
#define CF_ENHMETAFILE      14

#endif /* !NOCLIPBOARD */

/** >System
		This function opens the clipboard for examination and prevents other applications from modifying the clipboard content. .
	Parameters:
		hWndNewOwner = [in] Handle to the window to be associated with the open clipboard. If this parameter is NULL, the open clipboard is associated with the current task. 
	Remarks:
		OpenClipboard fails if another window has the clipboard open. 
		An application should call the CloseClipboard function after every successful call to OpenClipboard. 
		The window identified by the hWndNewOwner parameter does not become the clipboard owner unless the EmptyClipboard function is called. 
	Return:
		Returns TRUE on successful exit and FALSE on error.
	Example:
		void test_clipboard()
		{
			if(!OpenClipboard(NULL))
				return;
			
			if(IsClipboardFormatAvailable(CF_TEXT))
			{
				HANDLE hData = GetClipboardData(CF_TEXT);
				LPCSTR lpData = (LPCSTR)GlobalLock(hData);
				string str = lpData;
				GlobalUnlock(hData);
				out_str(str);
			}
			else
				out_str("No Text in clipboard");
			
			CloseClipboard();
		}
*/
BOOL WINAPI OpenClipboard(HWND hWndNewOwner);

/** >System
		This function closes the clipboard 
	Return:
		Returns TRUE for success.
	Remarks:
		When the window has finished examining or changing the clipboard, close the clipboard by calling CloseClipboard. 
		This enables other windows to access the clipboard. Do not place an object on the clipboard after calling CloseClipboard. 
	Example:
		void empty_clipboard()
		{
			if(OpenClipboard(NULL))
			{
				EmptyClipboard();
				CloseClipboard();
			}
		}
*/
BOOL WINAPI CloseClipboard(void);

/** >System
	This function determines whether the clipboard contains data in the specified format. 
	Parameters:
		uFormat = [in] Specifies a standard or registered clipboard format, like CF_TEXT, CF_DIB etc	
	Return:
		Returns TRUE if the clipboard format is available, otherwise returns FALSE
	Example:
		void any_text_in_clipboard()
		{
			if(OpenClipboard(NULL))
			{
				if(IsClipboardFormatAvailable(CF_TEXT))
					out_str("Yes,  Text in clipboard");
				else
					out_str("No Text in clipboard");
				
				CloseClipboard();
			}
		}
*/
BOOL WINAPI IsClipboardFormatAvailable(UINT uFormat);

/** >System
	This function function retrieves data from the clipboard in a specified format. The clipboard must have been opened previously. 
	Parameters:
		uFormat = [in] Specifies a standard or registered clipboard format, like CF_TEXT, CF_DIB etc	
	Return:
		If the function succeeds, the return value is the handle to a clipboard object in the specified format. 
		If the function fails, the return value is NULL.
	Remarks:
		The clipboard controls the handle that the GetClipboardData function returns, not the application.
		The application should copy the data immediately. The application must not free the handle nor leave it locked. 
		The application must not use the handle after the EmptyClipboard or CloseClipboard function is called, 
		or after the SetClipboardData function is called with the same clipboard format. 
		The system performs implicit data format conversions between certain clipboard formats when an application calls the 
		GetClipboardData function. For example, if the CF_OEMTEXT format is on the clipboard, a window can retrieve data in the CF_TEXT format. 
		The format on the clipboard is converted to the requested format on demand.

	Example:
		void test_clipboard()
		{
			if(!OpenClipboard(NULL))
				return;
			
			if(IsClipboardFormatAvailable(CF_TEXT))
			{
				HANDLE hData = GetClipboardData(CF_TEXT);
				LPCSTR lpData = (LPCSTR)GlobalLock(hData);
				string str = lpData;
				GlobalUnlock(hData);
				out_str(str);
			}
			else
				out_str("No Text in clipboard");
			
			CloseClipboard();
		}
*/
HANDLE WINAPI GetClipboardData(UINT uFormat);

/** >System
		This function places data on the clipboard in a specified clipboard format. 
		The window must be the current clipboard owner, and the application must have called the OpenClipboard function. 
	Parameters:
		uFormat = [in] Specifies a standard or registered clipboard format, like CF_TEXT, CF_DIB etc.
		hMem = [in] Handle to the data in the specified format.
	Return:
		If the function succeeds, the return value is the handle to the data. If the function fails, the return value is NULL. 

	Remarks:
		Before calling SetClipboardData, an application must open the clipboard by using the OpenClipboard function. 
		The hMem data will be passed to the clipboard, which means that the application must create this data and 
		not to lock and not to free it after giving it to the clipboard

	Example:
		void put_text_to_clipboard(string str)
		{
			int nMemSize = str.GetLength() + 1;// need terminating zero
			HANDLE hData = GlobalAlloc(GHND,nMemSize);
			LPSTR lpData = (LPSTR)GlobalLock(hData);
			lstrcpyn(lpData, str, nMemSize);
			GlobalUnlock(hData);
			if(OpenClipboard(NULL))
			{
				EmptyClipboard();
				SetClipboardData(CF_TEXT,hData);
				CloseClipboard();
			}
		}
*/

HANDLE WINAPI SetClipboardData(UINT uFormat, HANDLE hMem);
/** >System
		This function empties the clipboard and frees handles to data in the clipboard. 
		The function then assigns ownership of the clipboard to the window that currently has the clipboard open. 
	Return:
		Returns TRUE for success.
	Remarks:
		Before calling EmptyClipboard, an application must open the clipboard by using the OpenClipboard function. 
		If the application specifies a NULL window handle when opening the clipboard, EmptyClipboard succeeds but 
		sets the clipboard owner to NULL. 

	Example:
		void empty_clipboard()
		{
			if(OpenClipboard(NULL))
			{
				EmptyClipboard();
				CloseClipboard();
			}
		}
*/
BOOL WINAPI EmptyClipboard(void);

////////////////////////////////////////////////////////
////// end clipboard functions
////////////////////////////////////////////////////////

//-------- CPY 11/15/02 v7.0434 ORIGIN_8_FEATURES
// Origin 8 or later
#if  _OC_VER > 0x0703

/**# >User Interface Controls
	This function moves the specified rectangle by the specified offsets.
	Parameters:
		lprc = [in/out] Pointer to a RECT structure that contains the logical coordinates of the rectangle to be moved. 
		dx = [in] Specifies the amount to move the rectangle left or right. This parameter must be a negative value to move the rectangle to the left. 
		dy = [in] Specifies the amount to move the rectangle up or down. This parameter must be a negative value to move the rectangle up. 
	Return:
		Returns TRUE for success.

*/
BOOL WINAPI OffsetRect(RECT *lprc, int dx, int dy);

/**# >User Interface Controls
	Increases or decreases the width and height of the specified rectangle. 
	Remarks:
	The InflateRect function adds dx units to the left and right ends of the rectangle and dy units to the top and bottom. The dx and dy parameters are signed values; positive values increase the width and height, and negative values decrease them. 
	Parameters:
		lprc = [in/out] Pointer to a RECT structure that increases or decreases in size. 
		dx = [in] Specifies the amount to increase or decrease the rectangle width. This parameter must be negative to decrease the width. 
		dy = [in] Specifies the amount to increase or decrease the rectangle height. This parameter must be negative to decrease the height. 
	Return:
		Returns TRUE for success.

*/
BOOL WINAPI InflateRect(RECT *lprc, int dx, int dy);

#endif //_OC_VER > 0x0703

/** >System
	This function retrieves the visibility state of the specified window.
	Parameters:
		hWnd = [in] Handle to the window to test. 
	Return:
		If the specified window, its parent window, its parent's parent window, and so forth, have the WS_VISIBLE style, the return value is TRUE. 
		Otherwise, the return value is FALSE.
		
	Remarks:
		Because the return value specifies whether the window has the WS_VISIBLE style, it may be TRUE even if the window is totally obscured by other windows. 

	Example:
		if(!IsWindowVisible(GetWindow()))
			out_str("The Origin window is hidden.");

*/
BOOL WINAPI IsWindowVisible(HWND hWnd);

/** >System
	This function sets the specified window's show state
	Parameters:
		hWnd = [in] Handle to the window to test.
		nCmdShow = SW_HIDE, SW_NORMAL, SW_MINIMIZE, SW_MAXIMIZE etc.
	Examples:
		// make the Origin main window minimized
	    HWND  hWnd = GetWindow();
	    if(hWnd)
	   		ShowWindow(hWnd, SW_MINIMIZE);

	Return:
		If the window was previously visible, the return value is TRUE. 
		If the window was previously hidden, the return value is FALSE. 
*/	
BOOL WINAPI ShowWindow(HWND hWnd, int nCmdShow);

#ifndef NOSYSMETRICS

/*
 * GetSystemMetrics() codes
 */

#define SM_CXSCREEN             0
#define SM_CYSCREEN             1
#define SM_CXVSCROLL            2
#define SM_CYHSCROLL            3
#define SM_CYCAPTION            4 // height of window title bar
#define SM_CXBORDER             5
#define SM_CYBORDER             6
#define SM_CXDLGFRAME           7
#define SM_CYDLGFRAME           8
#define SM_CYVTHUMB             9
#define SM_CXHTHUMB             10
#define SM_CXICON               11
#define SM_CYICON               12
#define SM_CXCURSOR             13
#define SM_CYCURSOR             14
#define SM_CYMENU               15
#define SM_CXFULLSCREEN         16
#define SM_CYFULLSCREEN         17
#define SM_CYKANJIWINDOW        18
#define SM_MOUSEPRESENT         19
#define SM_CYVSCROLL            20
#define SM_CXHSCROLL            21
#define SM_DEBUG                22
#define SM_SWAPBUTTON           23
#define SM_RESERVED1            24
#define SM_RESERVED2            25
#define SM_RESERVED3            26
#define SM_RESERVED4            27
#define SM_CXMIN                28
#define SM_CYMIN                29
#define SM_CXSIZE               30
#define SM_CYSIZE               31
#define SM_CXFRAME              32
#define SM_CYFRAME              33
#define SM_CXMINTRACK           34
#define SM_CYMINTRACK           35
#define SM_CXDOUBLECLK          36
#define SM_CYDOUBLECLK          37
#define SM_CXICONSPACING        38
#define SM_CYICONSPACING        39
#define SM_MENUDROPALIGNMENT    40
#define SM_PENWINDOWS           41
#define SM_DBCSENABLED          42
#define SM_CMOUSEBUTTONS        43

#define SM_CXFIXEDFRAME           SM_CXDLGFRAME  
#define SM_CYFIXEDFRAME           SM_CYDLGFRAME  
#define SM_CXSIZEFRAME            SM_CXFRAME     
#define SM_CYSIZEFRAME            SM_CYFRAME     

#define SM_SECURE               44
#define SM_CXEDGE               45
#define SM_CYEDGE               46
#define SM_CXMINSPACING         47
#define SM_CYMINSPACING         48
#define SM_CXSMICON             49
#define SM_CYSMICON             50
#define SM_CYSMCAPTION          51
#define SM_CXSMSIZE             52
#define SM_CYSMSIZE             53
#define SM_CXMENUSIZE           54
#define SM_CYMENUSIZE           55
#define SM_ARRANGE              56
#define SM_CXMINIMIZED          57
#define SM_CYMINIMIZED          58
#define SM_CXMAXTRACK           59
#define SM_CYMAXTRACK           60
#define SM_CXMAXIMIZED          61
#define SM_CYMAXIMIZED          62
#define SM_NETWORK              63
#define SM_CLEANBOOT            67
#define SM_CXDRAG               68
#define SM_CYDRAG               69
#define SM_SHOWSOUNDS           70
#define SM_CXMENUCHECK          71
#define SM_CYMENUCHECK          72
#define SM_SLOWMACHINE          73
#define SM_MIDEASTENABLED       74
#define SM_MOUSEWHEELPRESENT    75

#define SM_XVIRTUALSCREEN       76
#define SM_YVIRTUALSCREEN       77
#define SM_CXVIRTUALSCREEN      78
#define SM_CYVIRTUALSCREEN      79
#define SM_CMONITORS            80
#define SM_SAMEDISPLAYFORMAT    81
#define SM_CMETRICS             83

/** >System
	This function retrieves various system metrics (widths and heights of display elements) and system configuration settings. 
	All dimensions retrieved by GetSystemMetrics are in pixels. 

	Parameters:
		nIndex = [in] Specifies the system metric or configuration setting to retrieve. All SM_CX* values are widths. All SM_CY* values are heights.
		
	Return:
		If the function succeeds, the return value is the requested system metric or configuration setting.	If the function fails, the return value is zero.
		
	Remarks:
		System metrics may vary from display to display.  

	Example:
		void run_GetSystemMetrics()  
		{
			int i = GetSystemMetrics(4);
			printf("%d",i);  //output should be 19
		}

*/
int	WINAPI GetSystemMetrics(int nIndex);

#endif // NOSYSMETRICS

/*
 * Key State Masks for Mouse Messages
 */
#define MK_LBUTTON          0x0001
#define MK_RBUTTON          0x0002
#define MK_SHIFT            0x0004
#define MK_CONTROL          0x0008
#define MK_MBUTTON          0x0010


/*
 * Virtual Keys
 */
#define VK_LBUTTON        0x01
#define VK_RBUTTON        0x02
#define VK_CANCEL         0x03
#define VK_MBUTTON        0x04    /* NOT contiguous with L & RBUTTON */

#define VK_BACK           0x08	// backspace
#define VK_TAB            0x09

#define VK_CLEAR          0x0C
#define VK_RETURN         0x0D

#define VK_SHIFT          0x10
#define VK_CONTROL        0x11
#define VK_MENU           0x12
#define VK_PAUSE          0x13
#define VK_CAPITAL        0x14

#define VK_ESCAPE         0x1B
#define VK_SPACE          0x20
#define VK_PRIOR          0x21
#define VK_NEXT           0x22
#define VK_END            0x23
#define VK_HOME           0x24
#define VK_LEFT           0x25
#define VK_UP             0x26
#define VK_RIGHT          0x27
#define VK_DOWN           0x28
#define VK_SELECT         0x29
#define VK_PRINT          0x2A
#define VK_EXECUTE        0x2B
#define VK_SNAPSHOT       0x2C
#define VK_INSERT         0x2D
#define VK_DELETE         0x2E
#define VK_HELP           0x2F
#define VK_F1             0x70
#define VK_F2             0x71
#define VK_F3             0x72
#define VK_F4             0x73
#define VK_F5             0x74
#define VK_F6             0x75
#define VK_F7             0x76
#define VK_F8             0x77
#define VK_F9             0x78
#define VK_F10            0x79

/** >System
	This function retrieves the status of the specified virtual key. 
	The status specifies whether the key is up, down, or toggled (on, off - alternating each time the key is pressed). 

	Example:This function get the state of the Tab key.
		void run_GetKeyState()  
		{
			short i = GetKeyState(0x09);
			printf("%d",i);
		}
*/
short WINAPI GetKeyState(int nVirtKey);

// Windows related functions exported from Origin
#pragma dll(@OK)


/** >System
		retrieves the Windows handle of Origin's internal windows.
	Parameters:
		nWin = one of the OGW_MAIN, OGW_MDICLIENT, OGW_SCRIPT_WINDOW, OGW_OUTPUT_LOG, OGW_CODEBUILDER, OGW_DB_ACTIVE_DLG, OGW_NUM_WIN_TYPES.
	Return:
		The window handle of an Origin window.
	Example:
		void	run_GetWindow()
		{
 	 		HWND	hwnd = GetWindow();
			MessageBox(hwnd, "This is a test", "TestGetWindow"); 
		}
*/
HWND GetWindow(int nWin = OGW_MAIN); // get Origin window handle
// GetWindow was originally in utilities.h, moved to this file by CPY ADD_HWND_CONSTRUCTOR_TO_WINDOW


#endif //_MSWIN_H
