/*------------------------------------------------------------------------------*
 * File Name:Profiler.h															*
 * Creation: AW 6/20/2003														*
 * Purpose: OriginC profiler class for function speed measurement				*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _PROFILER_H
#define _PROFILER_H

#include <sys_utils.h>
#include <tree_utils.h>

/** >Utility
		This class is only available to OriginPro users. 

		The Profiler class can be used to measure various function calls to identify the slower functions

	Example:
		#include <origin.h>
		#include <profiler.h>
		void test()
		{
			Profiler tempObj; // just need to place this as 1st line in function
			
			INIFile nlsf_ini(GetAppPath() + "nlsf.ini");
			Tree trTemp;
			if(tree_read_ini(trTemp, nlsf_ini))
				tree_dump(trTemp, "nlsf.ini", WRITE_COMPILER_OUTPUT);
		}
*/
class Profiler
{
public:
	
	/**
	*/
	Profiler(int nDisplayNum = 10)
	{
		m_nDisplayNum = nDisplayNum;
		Project.Profile(TRUE, TRUE);
	}

	/**
	*/
	~Profiler()
	{
		BOOL bOK = Project.GetProfileData(m_vsFuncNames, m_vnNumCalls, m_vdTimes);
		int nCount = m_vsFuncNames.GetSize();
		if ( nCount > m_nDisplayNum )
		   nCount = m_nDisplayNum;
		if(nCount < 1)
		{
			printf("Insignificant data...\n");
			return; //too few calls
		}
		
		vector<uint> vnIndeces;
		m_vdTimes.Sort(SORT_DESCENDING, TRUE, vnIndeces);
		m_vsFuncNames.Reorder(vnIndeces);
		m_vnNumCalls.Reorder(vnIndeces);
		int nMaxFunDisplaySize = 40;
		printf("Top %d most time consuming functions:\n", nCount);
		string strFuncNameTitle = "Function Name";
		append_blanks_to_size(strFuncNameTitle, nMaxFunDisplaySize);
		printf("%sTime(sec)\tNum of Calls\n", strFuncNameTitle);
		for ( int ii = 0; ii < nCount; ii++ )
		{
			string str;
			str.Format("<%d> %s", ii+1, m_vsFuncNames[ii]);
			append_blanks_to_size(str, nMaxFunDisplaySize);
			
			printf("%s%f\t%d\n", str, m_vdTimes[ii], m_vnNumCalls[ii]);
		}
	}
   
private:
   int				m_nDisplayNum;
   vector<string>	m_vsFuncNames;
   vector<uint>		m_vnNumCalls;
   vector<double>	m_vdTimes;
};

#endif //_PROFILER_H
