/*------------------------------------------------------------------------------*
 * File Name: OC_Const.h														*
 * Creation: CPY 6/5/2001														*
 * Purpose: Origin C enum and define constants shared with internal codes		*
 * Copyright (c) OriginLab Corp.	2001										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * TD 10-05-01	INTEGRAL_TYPE_IDS_FOR_ALL_TYPES_OF_PAGE_OBJECTS					*
 *	YuI 09/27/01 v6.9091 t9456 IMPLEMENTATION_OF_CATEGORICAL_PLOT				*
 *	ML 10/16/2001 t9482 RECORDSET_INTO_WORKSHEET								*
 *	ML 10/31/2001 t9481 CREATING_WORKSHEETS_FROM_ORIGINC						*
 *	AW 11/06/01 PADDING_WAY_FOR_WINDOW											*
 *  JJ 12/17/2001 t9578 SMITH_CHART_IMPROVMENTS									*
 *	ML 12/21/2001 tQA70-105 TYPE_WKS_FROM_ORIGINC								*
 *	YuI 3/13/2 QA70-1043 v7.0233 GET_ROI_DATA									*
 *	AW 04/26/02 v7.0292 QA70-1610 MORE_WORK_ON_IS_PAGE_IN_FOLDER				*
 *	ML 5/20/2002 QA70-1847 GETTING_WORKSHEET_SELECTION_ORIGIN_C					*
 *	ML 5/23/2002 QA70-1847 DISCONTIGUOUS_BIT									*
 *	RVD 6/12/2002 QA70-2043 v7.0318 PAGE_NO_WINDOW_BIT							*
 *	ML 7/11/2002 QA70-1939 AXIS_SCALE_TYPE										*
 *	AW 07/31/02 v7.0357	QA70-2540 SUPPORT_SHOW_HIDE_PE_WINDOW_IN_ORIGINC		*
 *	TCZ 08/3/02 QA70-2390	v7.0361 HISTOGRAM_FUNCTION_IN_ORIGIN_C				*
 *  TCZ 08/08/02 QA70-2624 v7.0363  GET_INTERPOLATED_VALUE_AT_X_Y				*
 *	CPY  8/23/02 QA70-2802 v7.0383 CENTRALIZATION_OF_CONST_TO_OC_CONST			*
 *	YuI 8/26/02 v7.0385 QA70-2683 FREQUENCY_COUNT_FOR_CATEGORICAL_DATA			*
 *	LY 11/4/02 QA70-3256 v7.0428 BINARY_IMPORT									*
 *	LY 11/13/02 QA70-2135 v7.0434 RETRIEVE_PAGE_WINDOW_STATUS					*
 *	ML 11/20/2002 VIEW_MODES													*
 *	ML 11/25/2002 MORE_TREE_SAVING_OPTIONS										*
 *	RVD 1/22/2003 QA70-3748 v7.0493 IMPLEMENT_FORMAT_FILTER						*
 *  EJP 01-27-2003 QA70-3753 GET_DATE_STR_FOR_OC								*
 *  JCG 02/13/03 tQA-3073 v7.0513 ADD_BSPLN_OFF_OPTION_FOR_CURVE_DERIVATIVE		*
 *	RVD 2/18/2003 QA70-3094 v7.0517 ADD_ARRAYS									*
 *  SY 02-21-2003 QA70-3941 v7.0520 ADD_PROJECT_GetDatasetInfo_METHOD			*
 *	LY  3/13/2003 v7.0535 QA70-4059 OC_UTILITY_FUNCTION_EXPORT_IMG				*
 *	RVD 3/17/2003 QA70-3855 v7.0539 SYSTEM_THEME								*
 *	YuI 3/11/03 qa70-4044 v7.0533 WORK_ON_INCREMENTOR							*
 *	ML 3/23/2003 QA70-4113 INITIALIZING_VECTOR_FROM_COLUMN_FOR_WRITEBACK		*
 *	RVD 10/4/2002 QA70-4155 v7.0547 OPERATION_TREE_METHODS						*
 *	RVD 3/31/2003 QA70-4164 v7.0549 CACHE_BRANCH_PROPERTY_BITS					*
 *	RVD 4/14/2003 QA70-4259 v7.0561 IGNORE_SYSTEM_THEME_FLAG					*
 *	CPY 4/20/03 QA70-4278 v7.0565 WKS_HEADER_REGION_CHANGE_PARAM_BUTTON			*
 *	ML 4/23/2003 QA70-4318 MASKED_EDIT_PROPERTY_FOR_DATA_RANGE					*
 *	JCG 04/30/03 v7.0574 QA70-4355 ADD_NOTIFICATION_MSG_ON_TYPE_DESI_CHANGE		*
 *	RVD 5/8/2003 QA70-4410 v7.0580 STORAGE_PRINT_SETTINGS						*
 *	YuI 5/08/03 v7.0580 QA70-4371 OPERATION_GUI_EXPANSION						*
 *	CPY 5/15/03 QA70-1390 SORT_STRING_DEFAULT_CASE_SENSITIVE_IS_WRONG			*
 *	ML 5/17/2003 QA70-4493 TEMPORARY_CURVE_CONSTRUCTOR_WITH_MISSING_VALUES_REMOVAL
 *	ML 5/21/2003 QA70-4431 HEADER_TABLE_TREE_MODIFICATION_NOTIFICATION			*
 *	RVD 5/20/2003 QA70-4230 v7.0588 REPORT_TREE_EDIT							*
 *	ML 5/24/2003 QA70-4517 TYPE_WKS_MULTIPLE_REPEAT_COLUMNS						*
 *	DVT 5/27/03 QA70-4433 v7.0580 DELETE_OPERATION_WITH_WKS_OPTION				*
 *	TD 6-10-03 QA70-4631 MODAL_TO_BE_NOMODAL_ON_ROLLUP							*
 *	ML 6/10/2003 OUTPUTLOG_ANALYSIS_HEADER										*
 *	RVD 6/11/2003 QA70-4627 v7.0601 LAST_DEPENDENT_COLUMN_OFFSET				*
 *	CPY 6/15/03 QA70-4488 v7.0603 SEL_COLS_PLOTTING_DLG							*
 *  SY 06-16-2003 QA70-4469 v7.0603 ADD_TITLESHOW_PROPERTY_FOR_PAGE				*
 *	ML 6/17/2003 QA70-4678 MULTI_COLUMN_EDIT_PAGE								*
 *	RVD 6/13/2003 QA70-4650 v7.0601 OBJECT_PROPERTY_ACCESS						*
 *	DSC 6/26/03 QA70-1527 CLIENT_ORIGIN_WITH_EXE_ON_CLIENT_SIDE					*
 *	RVD 6/30/2003 QA70-4739 v7.0613 THEME_SUPPORT_TEXT_POSITION					*
 *	YuI 7/14/03 v7.0624 QA70-4700 GENERIC_OGS_BASED_EVENT_HANDLING				*
 *  SY 07-23-2003 v7.0631 QA70-4858 ASCII_EXPORT_FROM_OC						*
 *	ML 7/25/2003 STYLES_HOLDERS_IN_SCP_LC										*
 *	RVD 7/25/2003 v7.0633 PAGE_VIEWMODE_FROM_OC									*
 *	YuI 8/4/03 v7.0644 QA70-4963 SAVE_AS_PROJECT_METHOD_TO_FOLDER_CLASS			*
 *	RVD 8/7/2003 QA70-4971 v7.0649 MULTI_LEGEND_AUTOUPDATE						*
 *	RVD 9/11/2003 QA70-4650 v7.0691 OBJECT_PROPERTY_ACCESS_MORE_WORK			*
 *	ML 9/15/2003 DP_DELETE_ROWS_NOTIFICATION									*
 *	RVD 9/15/2003 QA70-5179 v7.0695 NOCLICK_KEEP_SELECTION						*
 *	RVD 9/15/2003 QA70-5179 v7.0695 THEME_SPECIAL_CONTEXT_MENU					*
 * EJP 10-09-2003 v7.5715 QA70-5317 ADD_DATE_FORMAT_TO_ASCIMP_STRUCT			*
 *	YuI 10/22/03 v7.5728 QA70-5409 SET_RANGE_SHOULD_SUPPORT_AUTORANGE			*
 *	ML 11/6/2003 QA70-5489 OPTIONALLY_SETTING_COLUMN_LABELS_TO_FIELD_NAMES		*
 *------------------------------------------------------------------------------*/
#ifndef _OC_CONST_H
#define _OC_CONST_H



// repaint constants for Dataset Append method
typedef enum { DATA_APPEND_NO_REDRAW = 0, DATA_APPEND_REFRESH, DATA_APPEND_REDRAW_ON_IDLE} DataAppenRepaintModes;

//the struct for the worksheet

//#define MAX_NUMBER_OF_LINE   20000
//#define MAX_NUMBER_OF_COLUMN   500
#define MAXLINE				120
#define NAME_SIZE			25
#define SHORT_NAME_SIZE		12
#define MAXFULLPATH			260 ///MAX_PATH in win32 is defined as 260
#define	MAX_FILENAME		266 //to allow for .xxx extension

/// ML 4/18/2001 VARIABLE_ARG_LIST_CALLS
#define	VARIABLE_ARG_MEMORY_MAX_SIZE			(5 * MAXLINE)			// it will be used to store all the arguments
																				// (VARIABLE_ARG_MEMORY_MAX_SIZE == 600 bytes is enough for
																				// 600 / 8 = 75 doubles, or 600 / 4 = 150 integers or LPCSTRs,
																				// which should be more then plenty
/// end VARIABLE_ARG_LIST_CALLS

//---------- CPY  8/23/02 QA70-2802 v7.0383 CENTRALIZATION_OF_CONST_TO_OC_CONST
// the following const are taken from NLSF and moved here so OC can have access
#define NLSF_MAX_PARAM						200
#define	NLSF_CATEGORY_NAME_SIZE				64
#define	NLSF_FUNCTION_NAME_SIZE				64
//----------

// constants to be used in string.Write and string.WriteLine
enum {WRITE_SCRIPT_WINDOW, WRITE_STATUS_BAR, WRITE_OUTPUT_LOG, WRITE_MESSAGE_BOX, WRITE_COMPILER_OUTPUT};

//------ CPY 12/8/02 v7.0456 ADD_HWND_CONSTRUCTOR_TO_WINDOW	
// consts to be used to retrive window handles from Origin
enum {OGW_MAIN, OGW_MDICLIENT, OGW_SCRIPT_WINDOW, OGW_OUTPUT_LOG, OGW_CODEBUILDER, OGW_DB_ACTIVE_DLG, OGW_NUM_WIN_TYPES};
//------

//the following enum are used in the column class function
//typedef enum { DEFAULT_DECIMAL_DIGITS, SET_DECIMAL_PLACES, SIGNIFICANT_DIGITS } ColDigitMode;
typedef enum {DIGITS_FREE_FORM, DIGITS_DECIMAL, DIGITS_SIGNIFICANT} ColDigitMode;
typedef enum { COL_JUSTIFY_LEFT = 1, COL_JUSTIFY_RIGHT, COL_JUSTIFY_CENTER } ColJustify;

#ifndef OKCOLTYPE_MASK
	#define		OKCOLTYPE_NUMERIC			0
	#define		OKCOLTYPE_TEXT				1
	#define		OKCOLTYPE_TIME				2
	#define		OKCOLTYPE_DATE				3
	#define		OKCOLTYPE_MONTH				4
	#define		OKCOLTYPE_WEEKDAY			5
	#define		OKCOLTYPE_COLUMN			6
	#define		OKCOLTYPE_DATASET			7
	#define		OKCOLTYPE_DATASET_X			8
	/// internal formats, reserved 6, 7, 8
	#define		OKCOLTYPE_TEXT_NUMERIC		9
	/// YuI 09/27/01 v6.9091 t9456 IMPLEMENTATION_OF_CATEGORICAL_PLOT
	#define		OKCOLTYPE_CATEGORICAL		0x000A
	/// end IMPLEMENTATION_OF_CATEGORICAL_PLOT

	#define		OKCOLTYPE_MASK				0x000F/// CPY v4.97 3/11/97 TEST_CELL_NUMERIC_OR_NOT
/// ML 2/28/97 DATAOBJECT__DESIGNATIONS
// The order is important!!!!!!! Do NOT change it!!!!!!! Also, the first must be zero!!!
	enum
	{
		OKDATAOBJ_DESIGNATION_Y = 0,
		OKDATAOBJ_DESIGNATION_NONE,	 //	DISREGARD
		OKDATAOBJ_DESIGNATION_ERROR,
		OKDATAOBJ_DESIGNATION_X,
		OKDATAOBJ_DESIGNATION_L,
		OKDATAOBJ_DESIGNATION_Z,
		OKDATAOBJ_DESIGNATION_X_ERROR,
	};
/// end DATAOBJECT__DESIGNATIONS
#endif //!OKCOLTYPE_MASK



// AW 11/06/01 PADDING_WAY_FOR_WINDOW
enum
	{
		MFILTER_ZEROPADDINGWINDOW,
		MFILTER_MAPPADDINGWINDOW,
	};
// END PADDING_WAY_FOR_WINDOW


#ifndef GNTS_NORMAL_NAME
	enum {
		FSI_DOUBLE = 0,
		FSI_REAL,
		FSI_SHORT,
		FSI_LONG,
		FSI_CHAR,
		FSI_TEXT,
		FSI_MIXED,///CPY v4.09 5/6/96 VAR_SIZE_COL
		FSI_BYTE,
		FSI_USHORT,
		FSI_ULONG,
		FSI_COMPLEX	// AW 08/09/02 QA70-2400 v7.0365 GET_INTERNALTYPE_OF_VECTORBASE
	};		 //datatype for the column class.
	//-------- CPY 8/11/01 v6.9069 TEMP_DATASET_USE_NORMAL_NAME
	// const that can be used in combination with the type value above
	#define GNTS_NORMAL_NAME	0x10000000L
	//--------
#endif //!GNTS_NORMAL_NAME

//------ CPY 8/11/03 v7.5656 GET_FONT_NAMES_FROM_LABUTIL
// getting system font info	in function
// BOOL  get_system_font_info(int nType, LPLONG lpnFontSize, LPBYTE lpnCharSet, LPSTR lpszFontName, int nNameSize);
// for nType of 
enum {GSFI_TYPE_DEFAULT, GSFI_TYPE_FIXED_WIDTH, GSFI_TYPE_SCALABLE};
//------


/// JCG 02/13/03 tQA-3073 v7.0513 ADD_BSPLN_OFF_OPTION_FOR_CURVE_DERIVATIVE
/// JJ 01/31/2002 NAG_SPLINE_RUTINE_CLEAN_UP
///	//enum{LET_THE_PROGRAM_CHOOSE = -3, INTERPOLATING_SPLINE, WEIGTHED_LEAST_SQURE_POLYNOMIAL};
///	enum{ BSPLN_AUTO = -3, BSPLN_INTERPOLATE, BSPLN_WEIGTHED_LEAST_SQUARE_POLYNOMIAL };
///	/// end NAG_SPLINE_RUTINE_CLEAN_UP
//
enum{ BSPLN_AUTO = -3, BSPLN_INTERPOLATE, BSPLN_WEIGTHED_LEAST_SQUARE_POLYNOMIAL, BSPLN_OFF };
/// end ADD_BSPLN_OFF_OPTION_FOR_CURVE_DERIVATIVE
							   
/// TD 10-05-01	INTEGRAL_TYPE_IDS_FOR_ALL_TYPES_OF_PAGE_OBJECTS
// The following constants are the return values of the OriginC Function PageBase::GetType()
// Thei constants are in Sync with the return Value of the LabTalk Exist(Window_Name) function
/**
exist(name) Returns a value indicating what the object is:
0 does not exist, 1 dataset, 2 worksheet, 3
graph, 4 variable, 5 matrix, 6 macro, 7 tool, 9
notes window.
*/


//#define EXIST_NONE					0 //Invalid Name/Page
//#define EXIST_WKS					2
#define EXIST_GRAPH					3
//#define EXIST_MATRIX				5
//#define EXIST_NOTES					9
/// end	INTEGRAL_TYPE_IDS_FOR_ALL_TYPES_OF_PAGE_OBJECTS*/

// Origin obj type , return from exist() 
#define EXIST_NONE      0
#define EXIST_DATA      1
#define EXIST_WKS       2
#define EXIST_PLOT      3
#define EXIST_VAR       4
#define EXIST_MATRIX    5
#define EXIST_TOOLBAR   7

/// CPY v3.782 4/13/95, add EXIST_PLOT_3D
//#define EXIST_MACRO     6
#define EXIST_MACRO     8
#define	EXIST_PLOT_3D	6 /// has to keep inside 7 as the wnd_mask
///

/// CPY v3.8 LABTEXT_Notes
#define	EXIST_NOTES		9
///

#define EXIST_ACTIVE    10

///sth v3.85 11/7/95 LAYOUT_PAGE_DETECTION
#define EXIST_LAYOUT	11
///end LAYOUT_PAGE_DETECTION

///--- CPY v4.977 t1953 ADD_EXCEL_EXIST_TYPE
#define	EXIST_EXTERN_WKS	12	/// this must be used as extended exist type related function only
// ------------END  ADD_GET_PAGE_TYPE

#define EXIST_PAGE	13	/// ALL_TYPE_OF_PAGE_DETECTION

/// ML 10/16/2001 t9482 RECORDSET_INTO_WORKSHEET
/// ML 11/6/2003 QA70-5489 OPTIONALLY_SETTING_COLUMN_LABELS_TO_FIELD_NAMES
//// Possible values for the "nOptions" argument of "GetRecordsetData()" 
//enum {
//	LAYWKGETRECORDSET_BY_COLUMN_INDEX = 0,						// beginning with the starting column nColBegin retrieve all fields (will add columns as necessary)
//	LAYWKGETRECORDSET_BY_COLUMN_INDEX_WITH_COLUMN_RENAMING,		// same as LAYWKGETRECORDSET_BY_COLUMN_INDEX, except that it will also rename all columns the field names
//	LAYWKGETRECORDSET_BY_COLUMN_NAME,							// it retrieves only the data from those fields whose names match column names
//	LAYWKGETRECORDSET_BY_COLUMN_LABEL,							// it retrieves only the data from those fields whose names match column labels 
//};

// Possible values for the "nOptions" argument of "GetRecordsetData()" 
enum {
	LAYWKGETRECORDSET_BY_COLUMN_INDEX = 1,						// beginning with the starting column nColBegin retrieve all fields (will add columns as necessary)
	
	LAYWKGETRECORDSET_BY_COLUMN_NAME = 2,						// it retrieves only the data from those fields whose names match column names
	LAYWKGETRECORDSET_BY_COLUMN_LABEL = 4,							// it retrieves only the data from those fields whose names match column labels 

	LAYWKGETRECORDSET_SET_COLUMN_NAME = 0x00010000,				// used in conjunction with LAYWKGETRECORDSET_BY_COLUMN_INDEX to set column names to field names						
	LAYWKGETRECORDSET_SET_COLUMN_LABEL = 0x00020000,				// used in conjunction with LAYWKGETRECORDSET_BY_COLUMN_INDEX to set column labels to field names						

	LAYWKGETRECORDSET_BY_COLUMN_INDEX_WITH_COLUMN_RENAMING = LAYWKGETRECORDSET_BY_COLUMN_INDEX | LAYWKGETRECORDSET_SET_COLUMN_NAME,		// same as LAYWKGETRECORDSET_BY_COLUMN_INDEX, except that it will also rename all columns to the field names

};
/// end OPTIONALLY_SETTING_COLUMN_LABELS_TO_FIELD_NAMES

/// end RECORDSET_INTO_WORKSHEET

/// ML 10/31/2001 t9481 CREATING_WORKSHEETS_FROM_ORIGINC
// nOption for creating new worksheets (methods "CreateCopy" and "Create" of the "Worksheet" class)
enum {
	CREATE_TEMP = 0,		// it will be destroyed when destroying the object (when it exits the scope) and is created invisible
	CREATE_VISIBLE_SAME,	// visibility is that of the source worksheet
	CREATE_VISIBLE,			// create visible
	CREATE_HIDDEN,			// create hidden

	CREATE_NO_REMOVE_TEMPLATEPICT = 0x00010000UL,	// to prevent removing template picture object on loading
	/// RVD 6/12/2002 QA70-2043 v7.0318 PAGE_NO_WINDOW_BIT
	CREATE_NO_GUI_ACCESS		= 0x00020000,		// to prevent project explorer access, should only be set with CREATE_HIDDEN
	CREATE_BIT_MASK				= 0x000F0000,
	/// end PAGE_NO_WINDOW_BIT
};
/// end CREATING_WORKSHEETS_FROM_ORIGINC

/// YuI 6/04/03 v7.0597 QA70-4593 SMART_DUPLICATE_PAGE
typedef enum tagDUPLICATECNTRL
{
	DCTRL_COPY_DATA						= 0x00000001,
	DCTRL_COPY_IN_OPERATIONS			= 0x00000002,
	DCTRL_COPY_OUT_OPERATIONS			= 0x00000004,
	DCTRL_COPY_DEFAULT = DCTRL_COPY_DATA | DCTRL_COPY_OUT_OPERATIONS,
}	DUPLICATECNTRL;
/// end SMART_DUPLICATE_PAGE

typedef	enum tagCATEGORICALMAPTYPE
{
	CMT_NONE	=	0,
	CMT_NOMINAL,
	CMT_ORDINAL,
}	CATEGORICALMAPTYPE;


/// CPY 12/20/2001 t9578 moved here from frame.h
enum {
	FRAME_COOR_CART=0,	// XY Cartesian coordinate system
	FRAME_COOR_POLAR,
	FRAME_COOR_TERNARY,
	FRAME_COOR_SMITH_CHART
};
///


#define	CMT_RESET_COLUMN_TYPE_ON_DESTRUCTION  0x10000


/// ML 12/21/2001 tQA70-105 TYPE_WKS_FROM_ORIGINC
// Possible targets for various "type" functions (the bits can be combined)
enum {
	TYPETARGET_SCRIPT_WINDOW		= 0x00000001UL,		// to the Script window
	TYPETARGET_NAMED_WINDOW			= 0x00000002UL,		// to the particular Notes window
	TYPETARGET_OUTPUTLOG			= 0x00000004UL,		// to output log
	TYPETARGET_SHOW_ERROR			= 0x00000008UL,		// show errors
	/// ML 6/10/2003 OUTPUTLOG_ANALYSIS_HEADER
	TYPETARGET_OUTPUTLOG_HEADER		= 0x00010000UL,		// to dump the output log analysis header
	TYPETARGET_NO_COLUMN_HEADERS	= 0x00020000UL,		// not to dump column headers
	/// end OUTPUTLOG_ANALYSIS_HEADER
};
/// end TYPE_WKS_FROM_ORIGINC

/// Redraw modes for Dataset Append	BEGIN
enum {
	REDRAW_NONE, 
	REDRAW_REALTIME, 
	REDRAW_REALTIME_WKS, 
	REDRAW_REFRESH, 
	REDRAW_REALTIME_SCOPE,
	REDRAW_MODE_INVALID 
};

enum {REALTIME_ON_IDLE=0x1000}; 

/// Redraw modes for Dataset Append	END

// AW 04/26/02 v7.0292 QA70-1610 MORE_WORK_ON_IS_PAGE_IN_FOLDER
// move from tooltree.h
#define N_PE_ILLEGAL			-1
#define N_PE_SHOW_NONE			0
#define N_PE_SHOW_ONLY_SEL		1
#define N_PE_SHOW_SEL_RECURSIVE 2
//now to be removed
#define N_PE_SHOW_REGARDLESS	3

enum ViewModePE
{
	VIEW_PE_ILLEGAL = N_PE_ILLEGAL,
	VIEW_PE_SHOW_NONE = N_PE_SHOW_NONE,
	VIEW_PE_SHOW_ONLY_SEL = N_PE_SHOW_ONLY_SEL,
	VIEW_PE_SHOW_SEL_RECURSIVE = N_PE_SHOW_SEL_RECURSIVE,
	//// Nothing after this line
	VIEW_PE_SHOW_REGARDLESS = N_PE_SHOW_REGARDLESS
};
// END MORE_WORK_ON_IS_PAGE_IN_FOLDER

enum tagSetOPtion
{
	MATREPL_TEST_LESSTHAN	= 1,
	MATREPL_TEST_EQUAL		= 2,
	MATREPL_TEST_GREATER	= 4,
	MATREPL_USE_ABSOLUTE_VALUE_IN_TEST	= 8,
	MATREPL_KEEP_ORIGINAL_SIGN_WHEN_TEST_RESULT_IS_TRUE		= 16,
	MATREPL_SET_TO_MISSING_VALUE_WHEN_TEST_RESULT_IS_FALSE	= 32
};

/// ML 5/20/2002 QA70-1847 GETTING_WORKSHEET_SELECTION_ORIGIN_C
#define	WKS_SEL_NONE  			0x0000				// no selection
#define	WKS_SEL_EDIT			0x0001				// one cell being edited
#define	WKS_SEL_COLUMN			0x0002				// one or more entire columns selected
#define	WKS_SEL_ROW				0x0004				// one or more entire rows selected
#define	WKS_SEL_RANGE			0x0008				// more than one cell selected
#define	WKS_SEL_ONE_COL			0x0010				// exactly one column selected
/// ML 5/23/2002 QA70-1847 DISCONTIGUOUS_BIT
#define	WKS_SEL_DISCONTIGUOUS	0x0020				// discontiguous columns selected
/// end DISCONTIGUOUS_BIT
#define	WKS_SEL_ALL		(WKS_SEL_RANGE | WKS_SEL_COLUMN | WKS_SEL_ROW )	// entire worksheet
/// end GETTING_WORKSHEET_SELECTION_ORIGIN_C


/// ML 7/11/2002 QA70-1939 AXIS_SCALE_TYPE
#define LINEAR_SPACE            0
#define LOG10_SPACE             1
#define PROB_SPACE              2
#define PROBIT_SPACE            3
#define RECIPROCAL_SPACE        4
#define OFFSET_RECIP_SPACE      5
#define LOGIT_SPACE             6
#define LOGE_SPACE              7
#define LOG2_SPACE              8
/// end AXIS_SCALE_TYPE

///-------AW 07/31/02 v7.0357	QA70-2540 SUPPORT_SHOW_HIDE_PE_WINDOW_IN_ORIGINC
enum  ControlWinType
{
	CWT_PROJECT_EXPLORER, 
	CWT_SCRIPT_WINDOW, 
	CWT_CODE_BUILDER,
	CWT_RESULTS_LOG,
};
/// ------ END SUPPORT_SHOW_HIDE_PE_WINDOW_IN_ORIGINC

/// YuI 8/26/02 v7.0385 QA70-2683 FREQUENCY_COUNT_FOR_CATEGORICAL_DATA
//	/// TCZ 08/3/02 QA70-2390	v7.0361 HISTOGRAM_FUNCTION_IN_ORIGIN_C
//	enum FrequncyAccounOutBin
//	{
//		FAB_NOT_INCLUDE_OUTLIERS = 0,
//		FAB_INCLUDE_LESS_DMIN_BIN,
//		FAB_INCLUDE_MORE_DMAX_BIN,
//		FAB_INCLUDE_BOTH_OUTLIER_BIN ,
//	};
//	/// end HISTOGRAM_FUNCTION_IN_ORIGIN_C

// frequency count conrl should be bit based, not just enumeration of possible combinations
typedef enum tagFREQUENCYCOUNTCTRL
{
	FC_INCLUDE_LEFT				= 0x00000001,
	FC_INCLUDE_RIGHT			= 0x00000002,
	FC_INCLUDE_BOTH				= FC_INCLUDE_LEFT | FC_INCLUDE_RIGHT,
}	FREQUENCYCOUNTCTRL;

enum FrequncyAccounOutBin
{
	FAB_NOT_INCLUDE_OUTLIERS = 0,
	FAB_INCLUDE_LESS_DMIN_BIN = FC_INCLUDE_LEFT,
	FAB_INCLUDE_MORE_DMAX_BIN = FC_INCLUDE_RIGHT,
	FAB_INCLUDE_BOTH_OUTLIER_BIN = FC_INCLUDE_BOTH,
};
/// end FREQUENCY_COUNT_FOR_CATEGORICAL_DATA

/// TCZ 08/08/02 QA70-2624 v7.0363  GET_INTERPOLATED_VALUE_AT_X_Y
enum MatrixInterpolateMethod
{
	  INTERPOLATE_NEAREST = 0, 
	  INTERPOLATE_BILINEAR, 
	  INTERPOLATE_BICUBIC, 
	  INTERPOLATE_2DSPLINE, 
	  INTERPOLATE_VERTICINTERPOL,
};
/// end GET_INTERPOLATED_VALUE_AT_X_Y

// GJL 08/23/02 DEFINE_DEFAULT_TOLERANCES
#define DEFAULT_TOLERANCE					1E-14
#define DOUBLE_COMPARE_DEFAULT_RESOLUTION	1E-14
// End GJL 08/23/02 DEFINE_DEFAULT_TOLERANCES

//--------- CPY 9/24/02 v7.0404 QA70-2658 ASCII_IMPORT_FROM_OC
// the following error codes are related to ASCII file import
#define ERR_FILE_NOT_FOUND	3000
#define ERR_FILE_EMPTY		3001
#define ERR_FILE_NOT_TABLE	3002 // no column can be found
#define ERR_STRUCT_INPUT	3003
#define ERR_IMPORT_INTERNAL	3006
#define ERR_FILE_READ_DATA	3009
#define ERR_FILE_TOO_BIG	3012
//--------- end CPY 9/24/02 v7.0404 QA70-2658 ASCII_IMPORT_FROM_OC

//LY	11/4/02 QA70-3256 v7.0428 BINARY_IMPORT
#define BIP_FLAG_REAL		0x0001
#define BIP_FLAG_SIGNED		0x0002
#define BIP_FLAG_STRING		0x0004

#define BIP_TYPE_REAL		(BIP_FLAG_REAL | BIP_FLAG_SIGNED)
#define BIP_TYPE_STRING		(BIP_FLAG_STRING)
#define BIP_TYPE_INT		(BIP_FLAG_SIGNED)
#define BIP_TYPE_UINT		(0)
//end BINARY_IMPORT

//LY 11/13/02 QA70-2135 v7.0434 RETRIEVE_PAGE_WINDOW_STATUS
enum PageShowState
{
	PAGE_NORMAL = 0,
	PAGE_MINIMIZED,
	PAGE_MAXIMIZED,
	PAGE_HIDDEN,
	PAGE_ACTIVATE,
};
//end RETRIEVE_PAGE_WINDOW_STATUS

//---- CPY 11/19/02, temp const for tree editor
#define TN_CHECKBOX		10
#define TN_EDITBOX		11
#define TN_DROPLIST		13
#define TN_DROPFLOAT	14
//----


/// ML 11/20/2002 VIEW_MODES
enum {
	// Branch stuff:
	VIEWFLT_BRANCH_EMPTY				= 0x00020000,
	VIEWFLT_BRANCH_NON_COLLECTION		= 0x00040000,
	VIEWFLT_BRANCH_COLLECTION			= 0x00080000,

	VIEWFLT_BRANCH_ALL					= VIEWFLT_BRANCH_EMPTY | VIEWFLT_BRANCH_COLLECTION | VIEWFLT_BRANCH_NON_COLLECTION,
	

	// Property stuff:
	VIEWFLT_PROP_COLOR					= 0x00100000,
	VIEWFLT_PROP_FONT					= 0x00200000,
	VIEWFLT_PROP_OTHER					= 0x00400000,	// whatever is not special already

	VIEWFLT_PROPERTY_ALL				= VIEWFLT_PROP_COLOR | VIEWFLT_PROP_FONT | VIEWFLT_PROP_OTHER,	// all properties (not branches)

	VIEWFLT_FULL_PATHS_IN_LABELS		= 0x01000000,

	
	// Everything:
	VIEWFLT_EVERYTHING					= 0xFFFFFFFF
};
/// end VIEW_MODES


//---- CPY 1/3/03 QA70-3609 v7.0479 TWO_GRAPHS_SAMPLE_SHOW_PROBLEMS
// page disable mouse clicking
enum
{
	NOCLICK_AXES		= 0x0001,
	NOCLICK_DATA_PLOT	= 0x0002,
	NOCLICK_LABEL		= 0x0004,
	NOCLICK_BUTTONS		= 0x0008, // buttons include all UIM objects and any other graphic objects that will execute LabTalk upon mouse up
	NOCLICK_LAYER		= 0x0010, // the layer frame for moving or resizing of layer
	NOCLICK_TICKLABEL	= 0x0020,
	NOCLICK_LAYERICON	= 0x0040,
	NOCLICK_WINDOW		= 0x0080,
	NOCLICK_KEEP		= 0x0100,	/// RVD 9/15/2003 QA70-5179 v7.0695 NOCLICK_KEEP_SELECTION
	NOCLICK_USE_DEFAULT = 0x1000, // follow system settings
};
//---- end 	1/3/03 QA70-3609

/// RVD 1/22/2003 QA70-3748 v7.0493 IMPLEMENT_FORMAT_FILTER
typedef enum
{
	FPB_RESERVED				= 0x0000003F,	// reserved bits
	FPB_DIMENSION				= 0x00000080,	// dimension bit
	FPB_STYLE					= 0x0FFFFF40,	// style bits
	FPB_STYLE_SYMBOL_MASK		= 0x00000F40,	// symbol mask bits
	FPB_STYLE_SYMBOL_TYPE		= 0x00000040,	// symbol type bit
	FPB_STYLE_SYMBOL_SHAPE		= 0x00000100,	// symbol shape bit
	FPB_STYLE_SYMBOL_INTERIOR	= 0x00000200,	// symbol interior bit
	FPB_STYLE_SYMBOL_CHARACTER	= 0x00000400,	// symbol character bit
	FPB_STYLE_SYMBOL_USER		= 0x00000800,	// symbol user bit
	FPB_STYLE_LIST_MASK			= 0x0001F000,	// list mask bits
	FPB_STYLE_SHAPE_LIST		= 0x00001000,	// shape list bit
	FPB_STYLE_LINE_LIST			= 0x00002000,	// line list bit
	FPB_STYLE_FILL_LIST			= 0x00004000,	// fill list bit
	FPB_STYLE_INTERIOR_LIST		= 0x00008000,	// interior list bit
	FPB_STYLE_COLOR_MASK		= 0x000F0000,	// color mask bits
	FPB_STYLE_COLOR_LIST		= 0x00010000,	// color list bit
	FPB_STYLE_COLOR				= 0x00020000,	// color bit
	FPB_STYLE_FONT				= 0x00F00000,	// font bits
	FPB_STYLE_BORDER			= 0x01000000,	// border bit
	FPB_STYLE_LINE				= 0x02000000,	// line bit
	FPB_STYLE_FILL				= 0x04000000,	// fill bit
	FPB_STYLE_SIZE				= 0x08000000,	// size bit
	FPB_TEXT					= 0x10000000,	// text bit
	FPB_SHOW					= 0x20000000,	// show bit
	FPB_SCALE					= 0x40000000,	// scale bit
	FPB_OTHER					= 0x80000000,	// other
	FPB_NONE					= 0x00000000,	// none
	FPB_ALL						= 0xFFFFFFFF,	// all bits
}	FILTERPROPERTYBITS;

typedef enum
{
	/// RVD 9/15/2003 QA70-5179 v7.0695 THEME_SPECIAL_CONTEXT_MENU
	//FOB_RESERVED				= 0x01FFE000,	// reserved bits
	//FOB_AXIS					= 0x0000000F,	// axis mask
	//FOB_AXIS_TICKS				= 0x00000001,	// axis ticks
	//FOB_AXIS_GRIDS				= 0x00000002,	// axis grids
	//FOB_AXIS_LABELS				= 0x00000004,	// axis labels
	FOB_RESERVED				= 0x01F0E000,	// reserved bits
	FOB_SPECIAL					= 0x0000000F,	// special bits
	FOB_AXIS					= 0x000F0000,	// axis mask
	FOB_AXIS_TICKS				= 0x00010000,	// axis ticks
	FOB_AXIS_GRIDS				= 0x00020000,	// axis grids
	FOB_AXIS_LABELS				= 0x00040000,	// axis labels
	/// end THEME_SPECIAL_CONTEXT_MENU
	FOB_OBJECT					= 0x000000F0,	// object mask
	FOB_LABELS					= 0x00000010,	// labels
	FOB_LINES					= 0x00000020,	// lines
	FOB_SHAPES					= 0x00000040,	// shapes
	FOB_PLOT					= 0x00001F00,	// plot mask
	FOB_PLOT_CURVE				= 0x00000100,	// curve bit
	FOB_PLOT_COLUMN				= 0x00000200,	// column bit
	FOB_PLOT_PIE				= 0x00000400,	// pie bit
	FOB_PLOT_DATALABEL			= 0x00000800,	// datalabel bit
	FOB_PLOT_SURFACE			= 0x00001000,	// surface bit
	/// RVD 9/11/2003 QA70-4650 v7.0691 OBJECT_PROPERTY_ACCESS_MORE_WORK
	FOB_PLOT_CONTOUR			= 0x00002000,	// contour bit
	FOB_PLOT_IMAGE				= 0x00004000,	// image bit
	/// end OBJECT_PROPERTY_ACCESS_MORE_WORK
	FOB_INCREMENT				= 0x02000000,	// incrementor bit
	FOB_DIMENSION				= 0x04000000,	// dimension
	FOB_SCALE					= 0x08000000,	// scale
	FOB_COLORMAP				= 0x10000000,	// colormap
	FOB_BACKGROUND				= 0x20000000,	// background
	FOB_GLOBAL					= 0x40000000,	// global
	FOB_OTHER					= 0x80000000,	// other
	FOB_NONE					= 0x00000000,	// none
	/// RVD 9/15/2003 QA70-5179 v7.0695 THEME_SPECIAL_CONTEXT_MENU
	//FOB_ALL						= 0xFFFFFFFF,	// all bits
	FOB_ALL						= 0xFFFFFFF0,	// all bits
	/// end THEME_SPECIAL_CONTEXT_MENU
}	FILTEROBJECTBITS;
/// end IMPLEMENT_FORMAT_FILTER

/// EJP 01-27-2003 QA70-3753 GET_DATE_STR_FOR_OC
enum{
	LDF_SHORT,									// 0
	LDF_LONG,									// 1
	LDF_ALPHAMONTH_NUMERICDAY,					// 2
	LDF_NUMERICMONTH_NUMERICDAY,				// 3
	LDF_NUMERICDAY,								// 4
	LDF_ALPHAWEEKDAY_3CHR,						// 5
	LDF_ALPHAWEEKDAY_1CHR,						// 6
	LDF_NUMERICYEAR_4DIGIT,						// 7
	LDF_NUMERICYEAR_2DIGIT,						// 8
	LDF_SHORT_AND_HHMM_SEPARCOLON,				// 9
	LDF_SHORT_AND_HHMMSS_SEPARCOLON,			// 10
	LDF_YYMMDD,									// 11
	LDF_YYMMDD_AND_HHMM_SEPARCOLON,				// 12
	LDF_YYMMDD_AND_HHMMSS_SEPARCOLON,			// 13
	LDF_YYMMDD_AND_HHMM,						// 14
	LDF_YYMMDD_AND_HHMMSS,						// 15
	LDF_ALPHAMON_3CHR,							// 16
	LDF_ALPHAMON_1CHR,							// 17
	LDF_QUARTER,								// 18
	LDF_CUSTOM1,								// 19
	LDF_CUSTOM2,								// 20
};
/// end GET_DATE_STR_FOR_OC

//----- CPY v7.0510 QA70-3277 2/8/03 GET_N_BOX_FROM_OC
// the ONODETYPE_* const are the different editors that
// are used in Theme editing and in GetNBox
//////////////////////////////////////////
// node types:
enum ONODETYPE
{
	ONODETYPE_INVALID = 0,
	ONODETYPE_CHECKBOX = 10,
	ONODETYPE_EDIT_BOX_ONELINE_TEXT,
	ONODETYPE_EDIT_BOX_MULTILINE_TEXT,
	ONODETYPE_DROPLIST_STRINGS,

	ONODETYPE_EDIT_BOX_NUMERIC_FLOAT,
	ONODETYPE_EDIT_BOX_NUMERIC_UINT,
	ONODETYPE_EDIT_BOX_NUMERIC_INT,

	ONODETYPE_DROPDOWN_NUMERIC_FLOAT,
	ONODETYPE_DROPDOWN_LINE_THICKNESS,

	ONODETYPE_DROPLIST_NONNEGATIVE_INTEGERS,
	ONODETYPE_DROPLIST_COLORS,			// uses OCOLOR; constants COLORLIST_* should be put into dwParam1, see 
										// macros DWPARAM1_FOR_DROPLIST_COLORS and OXTHEME_PROP_ENTRY_DROPLIST_COLORS
	ONODETYPE_COLORS_CNTRL,				// uses OCOLOR; constants COLORLIST_* should be put into dwParam1,

	ONODETYPE_DROPLIST_IMAGELIST,
	ONODETYPE_DROPLIST_IMAGELIST_LARGE_BITMAP_EFFECTIVE_HEIGHT,	 	/// ML 1/21/2003 LINE_PLOT_CONNECT_32_BY_32_IMAGES

	ONODETYPE_DROPLIST_PATTERNS,
	ONODETYPE_DROPLIST_FONTS,
	ONODETYPE_DROPLIST_FONTS_NO_AUTO,
	ONODETYPE_DROPDOWN_FONT_SIZES,

	ONODETYPE_DROPDOWN_SIZES_WITH_COLUMN_OFFSETS,

	ONODETYPE_DROPLIST_IMAGELIST_WITH_COLUMN_OFFSETS,
	
	/// YuI 3/11/03 qa70-4044 v7.0533 WORK_ON_INCREMENTOR
	ONODETYPE_DROPLIST_CHARACTERS,
	/// end WORK_ON_INCREMENTOR
	/// ML 4/23/2003 QA70-4318 MASKED_EDIT_PROPERTY_FOR_DATA_RANGE
	ONODETYPE_EDIT_RANGE,
	/// end MASKED_EDIT_PROPERTY_FOR_DATA_RANGE
	
	//------- CPY 6/1/03 v7.0596 REPORT_SETTINGS_NOTE_MORE_OPTION
	ONODETYPE_DROPLIST_TEXT,
	ONODETYPE_BUTTON_FILE_PATH,
	//-------
	/// ML 7/25/2003 STYLES_HOLDERS_IN_SCP_LC
	ONODETYPE_ICON,
	/// end STYLES_HOLDERS_IN_SCP_LC

	ONODETYPE_BRANCH					= 0x10000000,	// branch bit

	/// RVD 2/18/2003 QA70-3094 v7.0517 ADD_ARRAYS
	ONODETYPE_ARRAY						= 0x20000000,	// array bit
	ONODETYPE_BRANCH_COMPOSITE			= 0x40000000,	// composite branch bit
	
	// array controls
	ONODETYPE_CTRL_COLOR_ARRAY			= ONODETYPE_ARRAY | ONODETYPE_DROPLIST_COLORS,			// int array
	ONODETYPE_CTRL_CHECKBOX_ARRAY		= ONODETYPE_ARRAY | ONODETYPE_CHECKBOX,					// int array
	ONODETYPE_CTRL_EDITBOX_FLOAT_ARRAY	= ONODETYPE_ARRAY | ONODETYPE_EDIT_BOX_NUMERIC_FLOAT,	// double array
	ONODETYPE_CTRL_IMAGE_ARRAY			= ONODETYPE_ARRAY | ONODETYPE_DROPLIST_IMAGELIST,		// int array
	ONODETYPE_CTRL_LINE_WIDTH_ARRAY		= ONODETYPE_ARRAY | ONODETYPE_DROPDOWN_LINE_THICKNESS,	// double array
	
	/// YuI 3/11/03 qa70-4044 v7.0533 WORK_ON_INCREMENTOR
	ONODETYPE_CTRL_CHARACTER_ARRAY		= ONODETYPE_ARRAY | ONODETYPE_DROPLIST_CHARACTERS,		// int array
	/// end WORK_ON_INCREMENTOR

	// branch content displayed in a separate dialog
	ONODETYPE_BRANCH_DIALOG				= ONODETYPE_BRANCH_COMPOSITE,
	ONODETYPE_COLORMAP_ENTRIES,
	ONODETYPE_INCREMENTOR,
	ONODETYPE_INCREMENT_LIST, ///CPY 2/24/03 QA70-3955 v7.0522 EDITOR_FOR_INCREMENTOR_COLORMAP
	/// end ADD_ARRAYS

};


//------- CPY 6/1/03 v7.0596 REPORT_SETTINGS_NOTE_MORE_OPTION
typedef enum {
	WINOUT_NONE, WINOUT_APPEND, WINOUT_REPLACE, WINOUT_ENUM_NEW_WINDOW
} WindowOutputMode;
//------- CPY 6/1/03 v7.0596 REPORT_SETTINGS_NOTE_MORE_OPTION


///////////////////////////////////////
// The node value types:
enum {
	OXVT_NONE = 0,
	OXVT_bool = 1,
	OXVT_UINT,
	OXVT_DOUBLE,
	OXVT_STRING,	/// RVD 10/4/2002 QA70-3094 v7.0406 IMPLEMENT_THEME
	/// RVD 2/18/2003 QA70-3094 v7.0517 ADD_ARRAYS
	OXVT_INT_ARRAY,
	OXVT_DOUBLE_ARRAY,
	/// end ADD_ARRAYS
};


//------ end CPY v7.0510 QA70-3277 2/8/03 GET_N_BOX_FROM_OC

// options for Dialog::DoModal and Create
enum {
	DLG_OPTIONS_USE_OPS = 0x0001,
	DLG_OPTIONS_SHIFT_SHOW_DEFAULT_TRUE = 0x0002,
	DLG_MODAL_WITH_KEY					= 0x0004,/// TD 6-10-03 QA70-4631 MODAL_TO_BE_NOMODAL_ON_ROLLUP
	DLG_NO_DEFAULT_REPOSITION			= 0x0008,// CPY 7/8/03 QA70-4796 v7.0620 GET_N_BOX_EVENT_FUNC_MOVE_WIN
};
//----- end	 GET_N_BOX_FROM_OC

/// SY 02-21-2003 QA70-3941 v7.0520 ADD_PROJECT_GetDatasetInfo_METHOD
enum {
	PGDN_PLOTTABLE =	0x0001,
	PGDN_IN_WKS =		0x0002,
	PGDN_IN_MATRIX =	0x0004,
	PGDN_IS_DATASET =	0x0008, 
	PGDN_LOOSE =		0x0010,
	PGDN_FOLDER =		0x0020,
	PGDN_FOLDER_SUB =	0x0040,
	PGDN_FUNCTION =		0x1000	// CPY 8/5/03 function plot dataset
};
/// end ADD_PROJECT_GetDatasetInfo_METHOD

//------- CPY 3/3/03 v7.0527 CPY 3/3/03 v7.0526 CENTRALIZED_TREE_NODE_DISPLAY_NAME
#define STR_LABEL_ATTRIB			"Label"
#define STR_COMBO_ATTRIB			"Combo"
#define	STR_DATA_ATTRIB				"Data"
#define STR_ID_ATTRIB				"NodeID"
// for TreeEditor notifications

/// ML 6/17/2003 QA70-4678 MULTI_COLUMN_EDIT_PAGE
// attribute names and string format templates for multicolumn tree editor
#define		MC_TREE_EDT_COLUMN_NAMES	"MCCOLNAMES"	 
#define		MC_TREE_EDT_VALUE_FORMAT	"COL_%d_" 
#define		MC_TREE_EDT_TYPE_FORMAT		"COL_%d_type" 
/// end MULTI_COLUMN_EDIT_PAGE


/// RVD 3/31/2003 QA70-4164 v7.0549 CACHE_BRANCH_PROPERTY_BITS
#define		THEME_OBJECT_BITS_NAME		"Objects"
#define		THEME_PROPERTY_BITS_NAME	"Properies"
#define		THEME_COUNT_NAME			"Count"
/// end CACHE_BRANCH_PROPERTY_BITS
//#define WM_USER_RECONSTRUCT 		WM_USER + 408
#define WM_USER_ON_CHILD_KILL_FOCUS	(WM_USER + 405)
#define WM_USER_ON_CHILD_NEXT_CNTRL	(WM_USER + 406)
#define WM_USER_ON_SET_FOCUSTO_GRID	(WM_USER + 407)
#define WM_USER_RECONSTRUCT 		(WM_USER + 408)
#define WM_USER_ON_CONTROL_CHANGE 	(WM_USER + 409)
/// ML 9/15/2003 DP_DELETE_ROWS_NOTIFICATION
// Special negative values of wParam for WM_USER_ON_CONTROL_CHANGE:  
enum {
	ONCTRLCHNG_DELETE_ROWS				= -10,
};
/// end DP_DELETE_ROWS_NOTIFICATION

#define WM_USER_OPEN_EDIT_DLG		(WM_USER + 410)
//------- end CENTRALIZED_TREE_NODE_DISPLAY_NAME

/// JCG 04/30/03 v7.0574 QA70-4355 ADD_NOTIFICATION_MSG_ON_TYPE_DESI_CHANGE
// WorksheetCtrl column message
#define WKSCTRL_EVENT_TYPE_CHANGE		(WM_USER + 411)
#define WKSCTRL_EVENT_DESI_CHANGE		(WM_USER + 412)
/// end ADD_NOTIFICATION_MSG_ON_TYPE_DESI_CHANGE
#define	WKSCTRL_EVENT_HEADER_TABLE_TREE_CHANGE	(WM_USER + 413)			/// ML 5/21/2003 QA70-4431 HEADER_TABLE_TREE_MODIFICATION_NOTIFICATION

#define WM_USER_RESIZE_CONTROLS	(WM_USER + 429)   //CPY 9/13/03 PLOT_SETUP_PANEL_RESIZE_FROM_INSIDE_GRID
enum {LPARAM_RESIZE_CONTROLS_INCREASE, LPARAM_RESIZE_CONTROLS_DECREASE};
//--------- CPY 5/15/03 QA70-1390 SORT_STRING_DEFAULT_CASE_SENSITIVE_IS_WRONG
// please note that this SORT_ enum was changed on 4/18/03 for Origin 8
// in Origin 7 SR4 and earlier, it was SORT_ASCENDING = 0. The change was to make consistent with vectorbase sort
//enum {SORT_DESCENDING = 0, SORT_ASCENDING};  // AW 03/12/03 QA70-2336 v7.0534 SORT_METHODS_IN_WORKSHEET
// Also, in SR4, SORT_CASE_SENSITIVE was default, and in Origin8, we have changed to case insensitive as default for vector<string>
enum {
	SORT_DESCENDING = 0, 
	SORT_ASCENDING,
	SORT_CASE_SENSITIVE = 4
}; 
//--------- end SORT_STRING_DEFAULT_CASE_SENSITIVE_IS_WRONG

//LY  3/13/2003 v7.0535 QA70-4059 OC_UTILITY_FUNCTION_EXPORT_IMG
//--------------------------------------------------------------------------
// The IL_FORMAT_ constants for for refering to an image format by value.
// There is a constant for all the formats Origin supports.
//--------------------------------------------------------------------------
#define IL_FORMAT_VECTOR	0x0100 // Flag used to mark a format as a vector format

#define IL_FORMAT_INVALID	0x0000

#define IL_FORMAT_AI		(0x0001 | IL_FORMAT_VECTOR)
#define IL_FORMAT_BMP		0x0002
#define IL_FORMAT_CGM		(0x0003 | IL_FORMAT_VECTOR)
#define IL_FORMAT_DXF		(0x0004 | IL_FORMAT_VECTOR)
#define IL_FORMAT_EMF		(0x0005 | IL_FORMAT_VECTOR)
#define IL_FORMAT_EPS		(0x0006 | IL_FORMAT_VECTOR)
#define IL_FORMAT_GIF		0x0007
#define IL_FORMAT_JPG		0x0008
#define IL_FORMAT_PCX		0x0009
#define IL_FORMAT_PCT		(0x000A | IL_FORMAT_VECTOR)
#define IL_FORMAT_PDF		(0x000B | IL_FORMAT_VECTOR)
#define IL_FORMAT_PNG		0x000C
#define IL_FORMAT_PSD		0x000D
#define IL_FORMAT_TGA		0x000E
#define IL_FORMAT_TIF		0x000F
#define IL_FORMAT_WMF		(0x0010 | IL_FORMAT_VECTOR)
#define IL_FORMAT_XPM		0x0011
#define IL_FORMAT_XWD		0x0012
#define IL_FORMAT_FAX		0x0013			
//end OC_UTILITY_FUNCTION_EXPORT_IMG


///---- CPY 3/13/03 Theme related
#define THEME_SUB_FOLDER	"Themes"
#define THEME_FILE_EXT		"OTH"
#define THEME_INI_SECTION	"Display"
#define THEME_INI_ITEM		"SysTheme"
//-----

/// RVD 3/17/2003 QA70-3855 v7.0539 SYSTEM_THEME
#define	_OKEventMsgMap			OKEventMessageMap
#define	_OKEventMsgMapName		"OKEventMessageMap"
#define	_OKEventMsgMapFile		"OriginEvents.c"

/// YuI 7/14/03 v7.0624 QA70-4700 GENERIC_OGS_BASED_EVENT_HANDLING
// moved to new file oEvents.h
/*
typedef enum
{
	OE_CREATE_NEW_GRAPH_PAGE_ADD_DATA,	// fires after create new graph page and add data
	OE_AFTER_LOAD_FROM_TEMPLATE,		// fires after loading from template
}	ORIGINEVENT;
*/
/// end GENERIC_OGS_BASED_EVENT_HANDLING
/// end SYSTEM_THEME

/// ML 3/23/2003 QA70-4113 INITIALIZING_VECTOR_FROM_COLUMN_FOR_WRITEBACK
enum {
	WRITEBACK_NO = 0,
	WRITEBACK_NO_RESIZE = 0x1,
	WRITEBACK_INSERT_ON_EXPAND = 0x2,
	WRITEBACK_DELETE_ON_SHRINK = 0x8,
};
/// end INITIALIZING_VECTOR_FROM_COLUMN_FOR_WRITEBACK

/// RVD 10/4/2002 QA70-4155 v7.0547 OPERATION_TREE_METHODS
#define		TREE_Range			"RANGE"
#define		TREE_r1				"R1"
#define		TREE_r2				"R2"
#define		TREE_c1				"C1"
#define		TREE_c2				"C2"
#define		TREE_Data			"DATA"
#define		TREE_Wks			"WKS"
/// end OPERATION_TREE_METHODS


/// ML 5/24/2003 QA70-4517 TYPE_WKS_MULTIPLE_REPEAT_COLUMNS
#define		REPEAT_COLUMNS_PREFIX		"FixedC"
/// end TYPE_WKS_MULTIPLE_REPEAT_COLUMNS


/// RVD 5/8/2003 QA70-4410 v7.0580 STORAGE_PRINT_SETTINGS
#define		TREE_Auto			"AUTO"
#define		TREE_DPI			"DPI"
#define		TREE_NumberOfCopies	"NUMBEROFCOPIES"
#define		TREE_PaperSource	"PAPERSOURCE"
#define		TREE_PrinterName	"PRINTERNAME"
#define		TREE_Printing		"PRINTING"
/// end STORAGE_PRINT_SETTINGS

/// RVD 5/20/2003 QA70-4230 v7.0588 REPORT_TREE_EDIT
#define		TREE_Content		"CONTENT"
#define		TREE_Exporting		"EXPORTING"
#define		TREE_Graph			"GRAPH"
#define		TREE_Mode			"MODE"
#define		TREE_Name			"NAME"
#define		TREE_Note			"NOTE"
#define		TREE_Output			"OUTPUT"
#define		TREE_Print			"PRINT"
#define		TREE_Report			"REPORT"
#define		TREE_Reporting		"REPORTING"
#define		TREE_Settings		"SETTINGS"
/// end REPORT_TREE_EDIT

//////////////////////////////////////////////////////////////////////////
//////////////////////////// Message Map related /////////////////////////
//////////////////////////////////////////////////////////////////////////
// Argument Types used for declaring function prototype for Message Map
#define		VTS_VOID			""
#define		VTS_I2              "\x02"      // a 'short'
#define		VTS_I4              "\x03"      // a 'long'	DWORD, LPARAM, WPARAM etc
#define		VTS_R4              "\x04"      // a 'float'
#define		VTS_R8              "\x05"      // a 'double'
#define		VTS_BOOL            "\x0B"      // a 'BOOL'
#define		VTS_BSTR            "\x0E"		// an 'LPCSTR'
// Pointers
#define		VTS_PI2             "\x42"      // a 'short*'
#define		VTS_PI4             "\x43"      // a 'long*'
#define		VTS_PR4             "\x44"      // a 'float*'
#define		VTS_PR8             "\x45"      // a 'double*'
#define		VTS_PDATE           "\x47"      // a 'DATE*'
#define		VTS_PBSTR           "\x48"      // a 'BSTR*'
#define		VTS_PBOOL           "\x4B"      // a 'VARIANT_BOOL*'
#define		VTS_PVARIANT        "\x4C"      // a 'VARIANT*'
//Refernces
#define		VTS_RI2             "\x22"      // a 'short*'
#define		VTS_RI4             "\x23"      // a 'long*'
#define		VTS_RR4             "\x24"      // a 'float*'
#define		VTS_RR8             "\x25"      // a 'double*'
#define		VTS_RDATE           "\x27"      // a 'DATE*'
#define		VTS_RBSTR           "\x28"      // a 'BSTR*'
#define		VTS_RBOOL           "\x2B"      // a 'VARIANT_BOOL*'
#define		VTS_RVARIANT        "\x2C"      // a 'VARIANT*'
#define		VTS_PDISPATCH       "\x49"      // an 'IDispatch**'

#define		VTS_STR             VTS_BSTR
// Special Types 
// "Ox1_"	is Origin Object 
// "Ox3_"	is Refrence to "0x1_"     
// "Ox5_"	is Pointer to "0x1_"     
#define		VTS_CTRL			"\x10"
#define		VTS_ORIGINOBJ		"\x11"		// origin object /// RVD 3/17/2003 QA70-3855 v7.0539 SYSTEM_THEME
#define		VTS_RORIGINOBJ		"\x31"		// origin object /// RVD 3/17/2003 QA70-3855 v7.0539 SYSTEM_THEME
/// TD 9-8-03 QA70-NOTRACKER OCMSG_ON_RESIZE_BY_INI
#define		VTS_RECT			"\x12"		// origin object /// RVD 3/17/2003 QA70-3855 v7.0539 SYSTEM_THEME
#define		VTS_RRECT			"\x32"		// origin object /// RVD 3/17/2003 QA70-3855 v7.0539 SYSTEM_THEME
/// end OCMSG_ON_RESIZE_BY_INI

#define		MHO_NONE				0x00000000
#define		MHO_BEFORE				0x00000001
#define		MHO_DIRECT				MHO_BEFORE
#define		MHO_AFTER				0x00000002
#define		MHO_OGS					MHO_AFTER
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


/// RVD 4/14/2003 QA70-4259 v7.0561 IGNORE_SYSTEM_THEME_FLAG
// moved from graphic.h - comments stripped
typedef enum tagPAGECNTRL
{
	PPDWCNTRL_MATRIX_VIEW_IMAGE			= 0x00000001,
	PPDWCNTRL_MATRIX_SHOW_XY			= 0x00000002,
	PPDWCNTRL_DRAW_SEPARATED_LAYERS		= 0x00000004,
	PPDWCNTRL_SAVED_AS_EMBEDDING		= 0x00000008,
	PPDWCNTRL_IGNORE_SYSTEM_THEME		= 0x00000010,
	PPDWCNTRL_MULTI_LEGEND				= 0x00000020,	/// RVD 8/7/2003 QA70-4971 v7.0649 MULTI_LEGEND_AUTOUPDATE
}	PAGECNTRL;
/// end IGNORE_SYSTEM_THEME_FLAG

//-------- CPY 4/20/03 QA70-4278 v7.0565 WKS_HEADER_REGION_CHANGE_PARAM_BUTTON
#define IDD_WKS_MAT_HEADER_DIALOG_BAR		1181 // defined in helpid.h as well, needs to be consistent
#define IDC_WKS_HEADER						0x9F10 // this is a resource const in OUserRes.h
//-------- end WKS_HEADER_REGION_CHANGE_PARAM_BUTTON

/// YuI 4/21/03 qa70-4273 v7.0565 ADDITIONAL_INFO_INTO_OPERATION_CLASS
typedef enum tagDIALOGINFOBARCNTRL
{
	DBAR_TOP, 
	DBAR_LEFT, 
	DBAR_BOTTOM, 
	DBAR_RIGHT, 
	DBAR_FLOAT, 
	DBAR_TYPES,
	DBAR_NONE = DBAR_TYPES,
}	DIALOGINFOBARCNTRL;
/// end ADDITIONAL_INFO_INTO_OPERATION_CLASS

//---- CPY 5/8/03 QA70-4371
// numeric values are taklen from APTFN_USE_PROG_DIR etc.
// and APTFN_USE_PROG_DIR are redefined to refer to these constants
typedef enum tagOPATH_SEARCH
{
	OPATH_INI_THEN_EXE	= 3,
	OPATH_INI			= 2,
	OPATH_EXE			= 1,
	OPATH_EXE_THEN_INI	= 4,
	OPATH_LOCAL_EXE		= 5,  ///DSC 6/26/03 QA70-1527 CLIENT_ORIGIN_WITH_EXE_ON_CLIENT_SIDE

} OPATH_SEARCH;
//----

/// YuI 5/08/03 v7.0580 QA70-4371 OPERATION_GUI_EXPANSION
typedef	enum	tagOPERATIONRESULTINDICATOR
{
	ORI_NONE,
	ORI_WORKSHEET,
	ORI_COLUMN,
}	OPERATIONRESULTINDICATOR;
/// end OPERATION_GUI_EXPANSION


/// ML 5/17/2003 QA70-4493 TEMPORARY_CURVE_CONSTRUCTOR_WITH_MISSING_VALUES_REMOVAL
enum {
	CURVECOPY_SCAN_OVER_MISSING_FROM_LEFT	= 0x00000001,   // if on, it will scan from the left (see the parameter nLower) until it finds the first nonmissing value
	CURVECOPY_SCAN_OVER_MISSING_FROM_RIGHT	= 0x00000002,   // if on, it will scan back from the right (see the parameter nUpper) until it finds the first nonmissing value
	CURVECOPY_SKIP_MISSING_INSIDE			= 0x00000004,   // if on, it will not copy any missing values found in the middle
	CURVECOPY_REPLACE_MISSING_INSIDE		= 0x00000008,   // if on, any missing values in the middle will be replaced with the average of neighboring points (not used if the bit CURVECOPY_SKIP_MISSING_INSIDE  is on)
};
/// end TEMPORARY_CURVE_CONSTRUCTOR_WITH_MISSING_VALUES_REMOVAL

typedef enum tagOPTIONALMESSAGEBOXRETURN
{
	OM_RETURN_NOT_PRESENT		= -1,
	OM_RETURN_YNC_CANCEL		= 2,
	OM_RETURN_OK				= 1,
	OM_RETURN_CANCEL			= 0,
	OM_RETURN_YES				= OM_RETURN_OK,
	OM_RETURN_NO				= OM_RETURN_CANCEL,
}	OPTIONALMESSAGEBOXRETURN;

///	end DELETE_OPERATION_WITH_WKS_OPTION

typedef enum tagANALYSISERROR
{
	ERROR_NO_ERROR,
	ERROR_INVALID_CURVE,
	ERROR_INVALID_TREENODE,
	ERROR_TO_FEW_PTS,
	ERROR_UNEQUAL_N,
	ERROR_X_RANGE,
	ERROR_SETTINGS
}	ANALYSISERROR;


/// RVD 6/11/2003 QA70-4627 v7.0601 LAST_DEPENDENT_COLUMN_OFFSET
typedef enum
{
	DOO_LEFT		= 0x10000000,		// left offset
	DOO_ERRORBAR	= 0x00010000,		// errorbars
	DOO_MODIFIER	= 0x00020000,		// modifiers
	DOO_TYPE_MASK	= 0x000F0000,		// type mask
}	DEPENDENTOBJOFFSET;
/// end LAST_DEPENDENT_COLUMN_OFFSET

/// SY 06-16-2003 QA70-4469 v7.0603 ADD_TITLESHOW_PROPERTY_FOR_PAGE
// Move from orgdll.h - comments stripped
#define	WIN_TITLE_AUTO			0
#define	WIN_TITLE_SHOW_LABEL	1
#define	WIN_TITLE_SHOW_NAME		2
#define	WIN_TITLE_SHOW_BOTH		3
#define WIN_TITLE_SHOW_AUTO		WIN_TITLE_SHOW_NAME
/// end ADD_TITLESHOW_PROPERTY_FOR_PAGE

/// RVD 6/13/2003 QA70-4650 v7.0601 OBJECT_PROPERTY_ACCESS
// moved from okconst.h
typedef enum tagAXISOBJECT
{
	AXISOBJPOS_MINOR_GRID = 0,		// 0
	AXISOBJPOS_MAJOR_GRID,			// 1
	AXISOBJPOS_LABEL_FIRST,			// 2
	AXISOBJPOS_AXIS_FIRST,			// 3
	AXISOBJPOS_LABEL_SECOND,		// 4
	AXISOBJPOS_AXIS_SECOND,			// 5

	AXISOBJ_TOTAL_NUM,
}	AXISOBJECT;

typedef enum
{
	XAXIS = 0,
	YAXIS,
	ZAXIS,
}	AXES;
/// end OBJECT_PROPERTY_ACCESS

/// SY 07-23-2003 v7.0631 QA70-4858 ASCII_EXPORT_FROM_OC
#define WKS_EXPORT_HEADING	0x0001	// col name
#define WKS_EXPORT_ALL		0x0002	// ignore c1c2r1r2
#define WKS_EXPORT_LABELS	0x0004	// col label
#define WKS_EXPORT_SELECTED 0x0008	// only selected cols
#define WKS_EXPORT_MISSING_AS_BLANK 0x0010 // missing values will be exported as "", default is "--"
/// end ASCII_EXPORT_FROM_OC

/// RVD 7/25/2003 v7.0633 PAGE_VIEWMODE_FROM_OC
// moved from okconst.h
///Page View Mode
#define	OKPAGEVIEWMOVE_PREVIEW	0
#define	OKPAGEVIEWMOVE_PAGE		1
#define	OKPAGEVIEWMOVE_WINDOW	2
#define	OKPAGEVIEWMOVE_DRAFT	3
/// end PAGE_VIEWMODE_FROM_OC


///CPY 07/20/03 moved from okconst.h,original from IV 02/25/99 t5413 DATA_OK_TO_GROUP
#define GOGT_NORMAL	  0x0001
#define GOGT_NEVER	  0x0002
#define GOGT_ALWAYS	  0x0003
///end DATA_OK_TO_GROUP

/// YuI 8/4/03 v7.0644 QA70-4963 SAVE_AS_PROJECT_METHOD_TO_FOLDER_CLASS
typedef enum tagSAVEFOLDERCTRL
{
	SFC_INCLUDE_SUBFOLDERS		=	0x00000001,
	SFC_INCLUDE_ATTACHED_FILES	=	0x00000002,
}	SAVEFOLDERCTRL;
/// end SAVE_AS_PROJECT_METHOD_TO_FOLDER_CLASS

//--- CPY 9/4/03 v7.5684 USE_NULL_TREE_TO_CHECK_PLOT_DESIGNATION
// return values from MakeDataplotsTree
enum {
  MDPT_SUCCESS = 0, 
  MDPT_INCOMPLETE,  // column designations are not finished for the specified plot type. typically when X or Y is missing 
  MDPT_WRONG_ORDER // Example: for bubble plots the column that determines the size of symbols must be after the y-column. 
};
//----

/// YuI 10/22/03 v7.5728 QA70-5409 SET_RANGE_SHOULD_SUPPORT_AUTORANGE
enum
{	
	SETRANGE_FULL		= -1,
	SETRANGE_UNCHANGED	= -2,
};
/// end SET_RANGE_SHOULD_SUPPORT_AUTORANGE

//--- CPY v7.5701 9/22/03 SOME_OCOLOR_CONST_MOVED_TO_OC
#define HIGHEST_BIT						0X80000000UL
#define OCOLOR_RGB_BITS					0X00FFFFFFUL
#define OCOLOR_RGB_FLAG_BIT				0X01000000UL
#define OCOLOR_RGB_NONE_BIT				0X02000000UL	// make RGB to transparent and keep R, G, and B values

#define OCOLOR_IS_RGB(oc)				((((oc) & OCOLOR_RGB_FLAG_BIT) != 0) && ((oc & HIGHEST_BIT) == 0) && (((oc) & OCOLOR_RGB_NONE_BIT) == 0))
#define OCOLOR_IS_TRANSPARENT_RGB(oc)	((((oc) & OCOLOR_RGB_FLAG_BIT) != 0) && ((oc & HIGHEST_BIT) == 0) && (((oc) & OCOLOR_RGB_NONE_BIT) != 0))
#define GET_CRF_FROM_RGBOCOLOR(oc)		((oc) & OCOLOR_RGB_BITS)

#define RGB2OCOLOR(rgb)					(((DWORD)(rgb) & OCOLOR_RGB_BITS) | OCOLOR_RGB_FLAG_BIT)

//--- end SOME_OCOLOR_CONST_MOVED_TO_OC

/// EJP 10-09-2003 v7.5715 QA70-5317 ADD_DATE_FORMAT_TO_ASCIMP_STRUCT, moved to here from okconst.h
#define MAX_SIZE_CUSTOM_FORMAT				61		// 60 + one extra character for '\0'
/// end ADD_DATE_FORMAT_TO_ASCIMP_STRUCT

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
#endif // _OC_CONST_H

