
/* <OCN_g11.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library g02 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2156 (Feb 1998).
 * Mark 6 revised. IER-3041 (July 2000).
 */

#ifndef NAGG11
#define NAGG11

//#importdll "ONAG" // NAG DLL prepared by OriginLab
#pragma dll(ONAG)	
#include <NAG\nag_types.h>



/* begin proto */

/**	g11aac
		computes Chi-square statistics for a two-way contingency table. For a 22 
		table with a small number of observations exact probabilities are computed.

Example 1:
	Assume we have a matrix "Matrix1"'s size is 3X3 and the data type is integer.
	We have put 9 data in Matrix1.  We need get the Probability, Pearson Chi-square 
	statistic, Likelihood ratio test statistic and Degrees of freedom.
	
	double prob, chi, g, df;
	Matrix <int> mnobst("Matrix1");
	matrix <int> nobst;
	nobst.SetSize(3, 3);
	nobst = mnobst;
	matrix expt, chist;
	expt.SetSize(3, 3);
	chist.SetSize(3, 3);
	int ncol = 3, nrow = 3, tda = 3;
	
	nag_chi_sq_2_way_table(nrow, ncol, nobst, tda, expt,chist, &prob, &chi, &g, &df);
	printf("Probability = %6.4f\n", prob);
	printf("Pearson Chi-square statistic = %8.3f\n", chi);
	printf("Likelihood ratio test statistic = %8.3f\n", g);
	printf("Degrees of freedom = %4.0f\n", df);
			
Example 2:
	The data below, taken from Everitt (1977), is from 141 patients with brain tumours. 
	The row classification variable is the site of the tumour: frontal lobes, temporal 
	lobes and other cerebral areas. The column classification variable is the type of 
	tumour: benign, malignant and other cerebral tumours.
	
void test_nag_chi_sq_2_way_table()
{
	double prob;
	matrix expt;
	expt.SetSize(3,3);
	double g;
	matrix chist;
	chist.SetSize(3,3);
	double df, chi;
	int ncol;
	int nrow;
	int nobst1[9];
	matrix<int> nobst = {{23, 9, 6}, {21, 4, 3}, {34, 24, 17}};;
	nobst.SetSize(3,3);
	int tda = 3;

	nrow = 3;
	ncol = 3;

	nag_chi_sq_2_way_table(nrow, ncol, nobst, tda, expt,chist, &prob, &chi, &g, &df);
	printf("Probability = %6.4f\n", prob);
	printf("Pearson Chi-square statistic = %8.3f\n", chi);
	printf("Likelihood ratio test statistic = %8.3f\n", g);
	printf("Degrees of freedom = %4.0f\n", df);

}


The output is following:
	
	Probability = 0.0975
	Pearson Chi-square statistic = 7.844
	Likelihood ratio test statistic = 8.096
	Degrees of freedom = 4
	
Return:
	This function returns NAG error code, 0 if no error.

	11: On entry, nrow must not be less than 2: nrow = _value_ On entry, ncol must not be less than 2: ncol = _value_
	17: On entry tdt=_value_ while ncol = _value_. These parameters must satisfy tdt = ncol
	596: On entry nobst[_value_][_value_]=_value_. All elements of this array must be = 0.
	597: On entry all elements of the array nobst are 0. At least one element of this array must be > 0.
	598: On entry a 2*2 table has a row or column with both elements zero i.e., the table is degenerate.
	599: At least one cell has expected frequency = 0.5. The chi-square approximation may be poor.
	74: An internal error has occurred in this function. Check the function call and array sizes.  If the function call is correct, please consult NAG for assistance.
	
	successfully call of the nag_chi_sq_2_way_table function.	
*/

	int  nag_chi_sq_2_way_table(
		int nrow, // the number of rows in the contingency table.
		int ncol, // the number of columns in the contingency table.
		const int nobst[], // the contingency table.
		int tdt, 		// the last dimension of the arrays nobst. 
		double expt[], 	// the table of expected values.  
		double chist[], // the table of Chi-square contributions.
		double *prob, 	// contains the two-tail significance level for Fisher's exact test, otherwise prob contains the significance level from the Pearson ?2 statistic.
		double *chi, 	// the Pearson Chi-square statistic.
		double *g, 		// the likelihood ratio test statistic.
		double *df		// the degrees of freedom for the statistics
  ); // computes Chi-square statistics for a two-way contingency table. For a 22 table with a small number of observations exact probabilities are computed.


/** g11bac
		computes a table from a set of classification factors using a selected statistics
	
Example:
	The data, given by John and Quenouille (1977), is for  a 3 by 6 factorial 
	experiment in 3 blocks of 18 units.  The data is input in the order: 
	blocks, factor with 3 levels, factor with 6 levels, yield.  The 3 by 6 
	table of treatment means for yield over blocks is computed and printed.

void test_nag_tabulate_stats()
{
	char stat[2], weight[2];
	double comm_ar[36];
	double wt[54];
	double table[18];
	int items, i;
	int count[18];
	int	idim[3];
	int isf[3] = {0, 1, 1};
	int j, k, tdf;
	int lfac[3] = {3, 3, 6};
	int ltmax, maxt, n, ncells, ncol, ndim, nfac;
	int nrow;
	Nag_TableStats  stat_enum;
	Nag_Weightstype weight_enum;
	

	
	n = 54;
	nfac =3;
	ltmax = 18;
	maxt = ltmax;
	printf("the input data are as following\n");
	printf("n = 54, nfac = 3, ltmax = 18, maxt = ltmax,tdf  = 3,maxt = ltmax,\n");
	printf("stat_enum = Nag_TableStatsAv,weight_enum = Nag_NoWeights;\n");
	
	int factor[162] = {1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 2, 1, 2, 2, 1, 3, 2, 1, 1,
	3, 1, 2, 3, 1, 3, 3, 1, 1, 4, 1, 2, 4, 1, 3, 4, 1, 1, 5, 1, 2, 5, 1, 3, 5,
	1, 1, 6, 1, 2, 6, 1, 3, 6, 2, 1, 1, 2, 2, 1, 2, 3, 1, 2, 1, 2, 2, 2, 2, 2, 
	3, 2, 2, 1, 3, 2, 2, 3, 2, 3, 3, 2, 1, 4, 2, 2, 4, 2, 3, 4, 2, 1, 5, 2, 2,
	5, 2, 3, 5, 2, 1, 6, 2, 2, 6, 2, 3, 6, 3, 1, 1, 3, 2, 1, 3, 3, 1, 3, 1, 2, 
	3, 2, 2, 3, 3, 2, 3, 1, 3, 3, 2, 3, 3, 3, 3, 3, 1, 4, 3, 2, 4, 3, 3, 4, 3, 
	1, 5, 3, 2, 5, 3, 3, 5, 3, 1, 6, 3, 2, 6, 3, 3, 6};

	printf("\nfactor:\n");
	for(i = 0; i < 162; i++)
	{
		printf("%d, ",factor[i]);
		if((i + 1) % 8 == 0)
			printf("\n");
	}
	
	double y[54] = {274, 361, 253, 325, 317, 339, 326, 402, 336, 379, 
	345, 361, 352, 334, 318, 339, 393, 358, 350, 340, 203, 397, 356, 298, 382,
	376, 355, 418, 387, 379, 432, 339, 293, 322, 417, 342, 82, 297, 133, 306,
	352, 361, 220, 333, 270, 388, 379, 274, 336, 307, 266, 389, 333, 353};
	
	printf("\ny:\n");
	for(i = 0; i < 54; i++)
	{
		printf("%3.0f, ",y[i]);
		if((i + 1) % 9 == 0)
			printf("\n");
	}

	printf("\nlfac:\n");
	for(i = 0; i < 3; i++)
	{
		printf("%d, ",lfac[i]);
		
	}
	printf("\nisf:\n");
	for(i = 0; i < 3; i++)
	{
		printf("%d, ",isf[i]);
		
	}
	
	printf("\nthe results are as following:\n");
	tdf  = 3;
	maxt = ltmax;
	stat_enum = Nag_TableStatsAv;
	weight_enum = Nag_NoWeights; 
			
	nag_tabulate_stats(stat_enum, Nag_TableUpdateI, weight_enum, n, nfac, isf, lfac, factor, tdf, 
						y, wt, table, maxt, &ncells, &ndim, idim, count, comm_ar);
						
	printf("\n");
	printf("Table\n");
	printf("\n");
	ncol = idim[ndim -1];
	nrow = ncells /ncol;
	k = 1;
	items = 0;
	for(i = 1; i <= nrow; i++)
	{
			for(j = k, items = 1; j <= k + ncol -1; ++j, items++)
		{
			printf("%8.2f(%2ld)",table[j - 1],count[j - 1]);
			if(items % 6 == 0)
				printf("\n");			
		}
		k = k + ncol; 
	}	
}

	The output is following:
	235.33(3)	342.67(3)	309.33(3)	395.00(3)	373.33(3)	350.00(3)
	332.67(3)	341.67(3)	370.33(3)	370.33(3)	326.67(3)	381.00(3)
	196.33(3)	332.67(3)	320.33(3)	338.00(3)	292.33(3)	351.00(3)	
	
Return: 
	This function returns NAG error code, 0 if no error.
	
	11: On entry, n must not be less than 2: n = <value>.  On entry, nfac must not be less than 1: nfac = <value>.
	17: On entry, tdf = <value> while nfac = <value>.  These parameters must satisfy tdf >= nfac.
	70: On entry, parameter stat had an illegal value.  On entry, parameter weight had an illegal value.  On entry, parameter update had an illegal value.  
	510: The wt array argument must not be NULL when the weight argument indicates weights.
	57: On entry, wt[<value>] = <value>.  Constraint: if weight = Nag_Weights or Nag_Weightsvar, wt[i]>=0.
	104: On entr, sf[<value>] = <value> while lfac[0] = <value>.  Constraint: if sf[i] > 0, lfac[i] >= 2 for i = 0, 1 , 2, .., nfac.
	105: On entry, factor[<value>][<value>] = <value>.  Constraint: factor{i}{j} >= 1 for i = 0, 1, .., n-1; j = 0, 1, ..., nfac - 1.
	107: On entry, factor[<value>][<value>] = <value> while lfac[0] = <value>.  Constraint: factor[i][j] <= lfac[j] for i = 0, 1, .., n - 1; j = 0, 1, .., nfac - 1.
	600: The maximum size of the table to be computed, maxt is too small.
	601: stat Nag_TableStatsVar and the divisor for the variance <= 0.
	602: update = Nag_TableUpdateU and at least one of ncells, table, comm_ar or count have been changed since previous call to nag_tabulate_stats.
	73: Memory allocation failed.
	74: An internal error has occurred in this function.  Check the function call and array sizes.  If the function call is correct, please consult NAG for assistance.
		
	successfully call of the nag_tabulate_stats function.
*/

	int nag_tabulate_stats(
		Nag_TableStats  stat, //indicates which statistic is to be computed for the table cells
		Nag_TableUpdate update, //indicates if an existing table is to be updated by further observation.
		Nag_Weightstype weight, //indicates if weights are to be used
		int n,	//the number of observations
		int nfac, //the number of classifying factor
		const int sf[], //indicates which factor in factor are to be used in the tabulation
		const int lfac[], //the number of levels of the classifying factors in factor
		const int factor[], //the nfac coded classification factors for the n observation;
		int tdf, //the second dimension of the array factor 
		const double y[], //the variable to be tabulated
		const double wt[],// the weights
		double table[], //the computed table
		int maxt,	//the maximum size of the table 
		int *ncells, //the number of cells
		int *ndim,	//the number of factors
		int idim[], //the number of levels
		int count[], //a table containing the number of observations 
		double comm_ar[] //the sum of the weights contributing to each cells
  ); // computes a table from a set of classification factors using a selected statistics.


/** g11bbc
	computes a table from a set of calssification factors using a 
	given  percentile or quantile, for example the median
	
Example:
	The data, given by John and Quenouille (1977) are for a 3 by 6 factorial 
	experiment in 3 blocks of 18 units.  The data is input in the order: 
	blocks, factor with 3 levels, factor with 6 levels, yield, and the 3 by 6 
	table of treatment medians for yield over blocks is computed and printed.
	

void test_nag_tabulate_percentile()
{
	char stat[2], weight[2];
	double percnt;
	double wt[54];
	double *wtptr;
	double table[18];
	int ifail;
	int items, i;
	int count[18];
	int	idim[3];
	int sf[3] = {0, 1, 1};
	int j, k, tdf;
	int lfac[3] = {3, 3, 6};
	int ltmax, maxt, n, ncells, ncol, ndim, nfac;
	int nrow;
	Nag_TabulateVar type_enum;
		
	n = 54;
	nfac = 3;
	percnt =50.0;
	ltmax = 18;
	maxt = ltmax;
	printf("the input are as folowing\n");
	printf("n = 54;nfac = 3 ;percnt =50.0;ltmax = 18;maxt = ltmax;\n");
	printf("tdf  = nfac;ifail = 0;wtptr = NULL;	type_enum = Nag_TabulateVarCont;\n");
	
	int factor[162] = {1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 2, 1, 2, 2, 1, 3, 2, 1, 1,
	3, 1, 2, 3, 1, 3, 3, 1, 1, 4, 1, 2, 4, 1, 3, 4, 1, 1, 5, 1, 2, 5, 1, 3, 5,
	1, 1, 6, 1, 2, 6, 1, 3, 6, 2, 1, 1, 2, 2, 1, 2, 3, 1, 2, 1, 2, 2, 2, 2, 2, 
	3, 2, 2, 1, 3, 2, 2, 3, 2, 3, 3, 2, 1, 4, 2, 2, 4, 2, 3, 4, 2, 1, 5, 2, 2,
	5, 2, 3, 5, 2, 1, 6, 2, 2, 6, 2, 3, 6, 3, 1, 1, 3, 2, 1, 3, 3, 1, 3, 1, 2, 
	3, 2, 2, 3, 3, 2, 3, 1, 3, 3, 2, 3, 3, 3, 3, 3, 1, 4, 3, 2, 4, 3, 3, 4, 3, 
	1, 5, 3, 2, 5, 3, 3, 5, 3, 1, 6, 3, 2, 6, 3, 3, 6};
	
	printf("\nfactor:\n");
	for(i = 0; i < 162; i++)
	{
		printf("%d, ",factor[i]);
		if((i + 1) % 8 == 0)
			printf("\n");
	}

	double y[54] = {274, 361, 253, 325, 317, 339, 326, 402, 336, 379, 
	345, 361, 352, 334, 318, 339, 393, 358, 350, 340, 203, 397, 356, 298, 382,
	376, 355, 418, 387, 379, 432, 339, 293, 322, 417, 342, 82, 297, 133, 306,
	352, 361, 220, 333, 270, 388, 379, 274, 336, 307, 266, 389, 333, 353};
	
	printf("\ny:\n");
	for(i = 0; i < 54; i++)
	{
		printf("%3.0f, ",y[i]);
		if((i + 1) % 9 == 0)
			printf("\n");
	}
	
	printf("\nlfac:\n");
	for(i = 0; i < 3; i++)
	{
		printf("%d, ",lfac[i]);
		
	}
	printf("\nsf:\n");
	for(i = 0; i < 3; i++)
	{
		printf("%d, ",sf[i]);
		
	}
	
	printf("\nthe results are as following:\n");
	
	tdf  = nfac;
	ifail = 0;
	wtptr = NULL;		
	type_enum = Nag_TabulateVarCont;
	nag_tabulate_percentile(type_enum, n, nfac, sf, lfac, factor, tdf, percnt,
						y, wtptr, table, maxt, &ncells, &ndim, idim, count);
						
	printf("\n");
	printf("Table for the %4.0fth percentile\n",percnt);
	printf("\n");
//	printf("ndim = %d",ndim-1); 
	ncol = idim[ndim -1];
	nrow = ncells /ncol;
	k = 1;
	for(i = 1; i <= nrow; i++)
	{
			for(j = k, items = 1; j <= k + ncol -1; ++j, items++)
		{
			printf("%8.2f(%2ld)",table[j - 1],count[j - 1]);
			if(items % 6 == 0)
				printf("\n");
		}
		k = k + ncol; 
	}	
}
	
	The output is following:
	
	Table for 50th percentile
	
	226.00(3)	320.25(3)	299.50(3)	385.75(3)	348.00(3)	334.75(3)
	329.25(3)	343.25(3)	365.25(3)	370.50(3)	327.25(3)	378.00(3)
	185.50(3)	328.75(3)	319.50(3)	339.25(3)	286.25(3)	350.25(3)
	
Return: 
	This function returns NAG error code, 0 if no error.
	
	11: On entry, n must not be less than 2: n= <value>.  On entry, nfac must not be less than 1: nfac = <value>.
	17: On entry, tdf = <value> while nfac = <value>.  These parameters must satisfy tdf >= nfac.
	96: On entry, percnt = <value>.  Constraint: 0 < percnt < 100.
	70: On entry, parameter type had an illegal value.
	57: On entry, wt[<value>] = <value>.  Constraint: wt[i] >= 0, for i = , 1, .., n - 1.
	104: On entry, sf[<value>] = <value> while lfac{<value>] = <value>.  Constraint: if sf[i] > 0, lfac[i] >= 2, for i = 0, 1, ..., nfac - 1.
	105: On entry, factor[<value>][<value>] = <value>.  Constraint: factor[i][j] >= 1, for i = 0, 1, .. , n - 1; j = 0, 1, ..., nfac - 1.	
	107: On entry, factor[<value>][<value>] = <value> while lfac{<value>] = <value>.  Constraint: factor[i][j] <= lfac[j], for i = 0, 1, .. , n - 1; j = 0, 1, ..., nfac - 1.	
	600: The maximum size of the table to be computed, maxt is too small.
	603:  At least one cell is empty.
	73: Memory allocation failed.
	74: An internal error has occurred in this function.  Check the function call and array sizes.  If the function call is correct, please consult NAG for assistance.
	
	successfully call of the nag_tabulate_percentile	
*/

	int nag_tabulate_percentile(
		Nag_TabulateVar type,	// indicates whether the variable to be tabulated is discrete or continous
		int n, //the number of observation
		int nfac, //the number of classifying factors
		const int sf[], //indicates which factor in factor is to be used in the tabulation 
		const int lfac[], //the number of levels of the classifying factors in factor
		const int factor[], //the nfac coded classification factors for the n observation;
		int tdf, //the second dimension of the array factor 
		double percnt,	//the percentile to be tabulated
		const double y[], //the variable to be tabulated
		const double wt[],	//the weights
		double table[],	//the computed table
		int maxt, //the maximum size of the table to be computed
		int *ncells, //the number of cells in the table
		int *ndim, //the number of factors
		int idim[], //the number of levels
		int count[]	//the number of observations
	);


#ifdef __cplusplus
}
#endif
#endif /* not NAGA02 */
