/* READJNW Header file
 * GD 2001.08.07
 */
 
 #ifndef _READJNB_H
 #define _READJNB_H

//	1,2,4,8, default is 8
#pragma pack(push,1)

// The first byte of the Worksheet Stream indicates whether it's a worksheet or just text
//	0x00	Indicates a worksheet.
//	0xFF	Indicates long text. Next two bytes determines length.
//	else	Indicates short text. The value indicates length.

// The first byte in the stream (see above) is included in this structure,
// so we need to do a 'rewind' and start again
// The Worksheet Header
 struct Header {
 	char	WksID[4];		// Must match 0x00, 0x81, 0x05, 0x00
 	int		BytesLeft;		// Bytes remaining in file
 	char	Unk3[4];		// Must match 0x02, 0x70, 0x00, 0x00
 	int		Unk4;			// Probably size of string which follows - always 16
 	char	WksIDText[16];		// 'JSDataWorksheet', 0x00
 	char	FileType[4];	// 0x84, 0x20, {0x03=Type1 | 0x05=Type2}, 0x08
 	int		TypeSize;		// Probably size of structure which follows
 							// 0x08 for Type1 files and 0x10 for Type2 files
 };

 struct Type1Met {
 	int		Unk1;			// ignore - always 0?
 	USHORT	MaxCol0;		// Zero-base maximum number of columns
 	USHORT	MaxRow0;		// Zero-base maximum number of rows
 };
 
 struct Type2Met {
 	int		Unk1;			// ignore - always 0?
 	int		Unk2;			// ignore - always 0?
 	int		MaxCol0;		// Zero-base maximum number of columns
 	int		MaxRow0;		// Zero-base maximum number of rows
 };
 
#pragma pack(pop)

// Prototypes

int read_header(file &fid, uint *piFileType, uint *piNumCols, uint iFileSize);
int	seek_start(file &fid, uint iFileSize, uint *piOffset, uint *piRecordType);
int	read_file(file &fid, uint *piOffset, uint iFileSize, uint iFileType, uint *piRecordType);
int ImportJNB(Page& pgTarget, TreeNode& trFilter, LPCSTR lpcszFile, int nFile);

#endif // _READJNB_H
