/*------------------------------------------------------------------------------*
 * File Name: Page_Utils.cpp													*
 * Creation: July 25, 2003														*
 * Purpose: Define page utility functions										*
 * Copyright (c) OriginLab Corp. 2003											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	RVD 9/3/2003 QA70-5078 v7.0682 PLOT_RANGE_APPLY								*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
static bool get_storage_and_section_names(string& strStorage, string& strSection, LPCSTR lpcszStorageSection)
{
	if( lpcszStorageSection )
	{
		string strStorageSection(lpcszStorageSection);
		if( 2 == strStorageSection.GetNumTokens('.') )
		{		
			strStorage = strStorageSection.GetToken(0, '.');
			strSection = strStorageSection.GetToken(1, '.');
			return true;
		}
	}
	return false;
}

bool info_get_section(OriginObject& obj, TreeNode& trSection, LPCSTR lpcszStorageSection)
{
	if( obj )
	{
		string strStorage, strSection;
		if( get_storage_and_section_names(strStorage, strSection, lpcszStorageSection) )
		{
			storage st;
			st = obj.GetStorage(strStorage);
			if( st )
				return st.GetSection(strSection, trSection);
		}
	}
	return false;
}

bool info_set_section(OriginObject& obj, TreeNode& trSection, LPCSTR lpcszStorageSection)
{
	if( obj )
	{
		string strStorage, strSection;
		if( get_storage_and_section_names(strStorage, strSection, lpcszStorageSection) )
		{
			storage st;
			st = obj.GetStorage(strStorage, true); // true = add if does not exist
			if( st )
				return st.SetSection(strSection, trSection);
		}
	}
	return false;
}

bool page_get_info_var_value(Page& pg, LPCSTR lpcszVarName, string& strVarVal, LPCSTR lpcszStorageSection)
{
	string strStorageSection("User.Variables");
	if( lpcszStorageSection )
		strStorageSection = lpcszStorageSection;

	Tree trSection;
	if( info_get_section(pg, trSection, strStorageSection) )
	{
		string strVarName(lpcszVarName);
		strVarName.MakeUpper();

		TreeNode trnVar;
		trnVar = trSection.GetNode(strVarName);
		if( trnVar )
		{
			strVarVal = trnVar.strVal;
			return true;
		}
	}
	return false;
}

bool page_set_info_var_value(Page& pg, LPCSTR lpcszVarName, LPCSTR lpcszVarVal, LPCSTR lpcszStorageSection)
{
	string strStorageSection("User.Variables");
	if( lpcszStorageSection )
		strStorageSection = lpcszStorageSection;

	Tree trSection;
	if( info_get_section(pg, trSection, strStorageSection) )
	{
		string strVarName(lpcszVarName);
		strVarName.MakeUpper();

		TreeNode trnVar;
		trnVar = trSection.GetNode(strVarName);
		if( !trnVar )
			trnVar = trSection.AddNode(lpcszVarName);
		if( trnVar )
		{
			trnVar.strVal = lpcszVarVal;
			return info_set_section(pg, trSection, strStorageSection);
		}
	}
	return false;
}

bool page_get_info_var_value(Page& pg, LPCSTR lpcszVarName, double& dVarVal, LPCSTR lpcszStorageSection)
{
	string strVarVal;
	if( page_get_info_var_value(pg, lpcszVarName, strVarVal, lpcszStorageSection) )
	{
		dVarVal = atof(strVarVal);
		return true;
	}
	return false;
}

bool page_set_info_var_value(Page& pg, LPCSTR lpcszVarName, double dVarVal, LPCSTR lpcszStorageSection)
{
	string strVarVal;
	strVarVal.Format("%f", dVarVal);
	return page_set_info_var_value(pg, lpcszVarName, strVarVal, lpcszStorageSection);
}

bool page_get_storage_str(Page& pg, LPCSTR lpcszName, string &strValue)
{
	if( pg && lpcszName )
	{
		vector<byte> vb;
		if( pg.GetMemory(lpcszName, vb) )
			return strValue.SetBytes(vb);
	}
	return false;
}

bool page_set_storage_str(Page& pg, LPCSTR lpcszName, LPCSTR lpcstrValue)
{
	if( pg && lpcszName && lpcstrValue )
	{
		string strValue(lpcstrValue);
		vector<byte> vb;
		if( strValue.GetBytes(vb) )
			return pg.SetMemory(lpcszName, vb);
	}
	return false;
}

int	gpage_get_plots(const GraphPage &pg, TreeNode &tr)
{
	if(pg == NULL)
		return 0;
	
	int				nCount = 0;
	
	tr.RemoveChild("DataPlots");
	TreeNode		trRoot = tr.AddNode("DataPlots");
	if (!trRoot.IsValid())
		return false;
	int nActiveLayerIndex = -1;
	int nRet = 0;
	foreach (GraphLayer lay in pg.Layers)
	{
		if (lay)
		{
			Tree		trLayer;
			int nn;

			/// RVD 9/3/2003 QA70-5078 v7.0682 PLOT_RANGE_APPLY
			//if (nn = lay.GetLayerContents(trLayer, GETLC_DATAPLOTS | GETLC_STYLE_HOLDERS))
			DWORD dwCntrl = GETLC_DATAPLOTS | GETLC_STYLE_HOLDERS;

			DWORD dwPlotView;

			if( dlg_load_registry(STR_PLOT_SETUP_DLG, STR_PLOT_VIEW, dwPlotView) )
			{
				if( dwPlotView & DPEDTVIEW_HIDE_LIMITS )
					dwCntrl |= GETLC_NO_LIMITS;
			}

			if( nn = lay.GetLayerContents(trLayer, dwCntrl) )
			/// end PLOT_RANGE_APPLY
			{
				//TreeNode	trDP = trLayer.DataPlots.Clone();
				TreeNode	trL = trLayer.FirstNode;
				TreeNode	trDP = trL.Clone();
				DWORD		dwLayerBits = lay.GetSystemParam(GLI_PCD_BITS);
				string strTemp = dwLayerBits;
				trDP.SetAttribute(STR_LAYER_TYPE_BITS, strTemp);
				//TreeNode	trLayer = trRoot.AddNode("Layer");					
				trRoot.AddNode(trDP);
				//trLayer = trDP;
				if(0==nRet)
					nRet = nn;
			}
			else
				ASSERT(FALSE);
		}
		else
			ASSERT(FALSE);
	}
	if(nRet)
	{
		nActiveLayerIndex = page_active_layer_index(pg);
		if(nActiveLayerIndex >= 0)
		{
			string strTemp = nActiveLayerIndex;
			trRoot.SetAttribute(STR_ACTIVE_LAYER, strTemp);
		}
	}
	return nRet;
}


int page_active_layer_index(Page& pg)
{
	Page activePg = Project.Pages();
	if(activePg.GetName() != pg.GetName())
		return -1;
	
	Layer lay = pg.Layers();
	
	return lay.GetIndex();
}
