/*------------------------------------------------------------------------------*
 * File Name: ThemeApply.c														*
 * Creation: CPY 1/27/03														*
 * Purpose: Origin C support for a Theme Gallery and Apply dialog				*
 * Copyright (c) OriginLab Corp.2003											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON										*
 *	CPY 4/25/03 ADD_FILE_DATE and ADD_TOOLTIPS									*
 *	CPY 4/30/03 ADD_UNDO_APPLY													*				
 *	RVD 6/13/2003 QA70-4650 v7.0601 OBJECT_PROPERTY_ACCESS						*
 *	CPY 8/18/03 BOLD_SYSTEM_THEME_WHOLE_ROW										*
 *	CPY 8/19/03 INCREMENT_LIST_NO_SYSTEM_THEME_SUPPORT							*
 *	CPY 9/20/03 THEME_DUPLICATE_LEAD_TO_SIZE_OF_NEGATIVE_1						*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
#include <Origin.h>
//#include <Project.h>
//#include <sys_utils.h> // basic routines implemeted through Origin C, see sys_utils.c
#include <Dialog.h>
//#include <utilities.h>
#include "ResizeDialog.h"
#include <vsFlexGrid.h>
#include "theme_utils.h"
#include "Odlg.h"
#include "HelpID.h"
#include "GridControl.h"

#define _CAT "Theme"

#define _DBINT(_STR, _INT)	//out_int(_STR, _INT);
#define _DBSTR(_STR)		//out_str(_STR);
#define _DBPRINTF(_FMT, _ARG)	//printf(_FMT, _ARG);

//putting ';' in front of labtalk to make the execution delayed, so it will be executed after
//event has been handled, which is safer
#define STR_THEME_REMINDER_MSG_RENAME	";type -M ThemeHowToRename"
#define STR_THEME_REMINDER_MSG_DEL		";type -M ThemeFolderOfDel"

// the following is the col arrangement, so the str and the enum must be consistent
//--- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
//#define STR_THEME_GRID_COLS "System|Location|Contents|Name"
#define STR_THEME_GRID_COLS "System|Name|Size|Date|Path" //CPY 4/25/03 ADD_FILE_DATE added date column
//---

enum {
	GRID_COL_IS_SYSTEM,
	GRID_COL_NAME,
	//--- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
	//GRID_COL_EDIT,
	GRID_COL_SIZE,
	//---
	GRID_COL_DATE,	//CPY 4/25/03 ADD_FILE_DATE
	GRID_COL_LOCATION,
	GRID_COL_TOTAL
};

#define NUM_DATA_PTS 20

//////////////////////////////////////////////////////////
/////////// Tooltips  ////////////////////////////////////
//////////////////////////////////////////////////////////
static string strTootips get_col_heading_tooltips(int nCol)
{
	string strTemp;
	switch(nCol)
	{
	case GRID_COL_IS_SYSTEM:
		//strTemp = "Click to check one of the theme to become a System Theme";
		break;
	case GRID_COL_SIZE:
		strTemp = _L("Size = total number of properties, click to sort");
		break;
	case GRID_COL_NAME:
		strTemp = _L("double-click a Theme's name to rename");
		break;
	case GRID_COL_DATE:
		strTemp = _L("Last time a Theme file was modified, click to sort");
		break;
	case GRID_COL_LOCATION:
		strTemp = _L("Theme files are stored in Origin's system folder or in user's Origin folder");
		break;		
	}
	return strTemp;
}




//////////////////////////////////////////////////////////
/////////// Theme Collection//////////////////////////////
//////////////////////////////////////////////////////////


static bool theme_is_increment_theme(LPCSTR lpcszThemeFilename)
{
	Tree trTemp(lpcszThemeFilename);
	string strName = GetFileName(lpcszThemeFilename);
	_DBPRINTF("%s:", strName)
	//out_tree(trTemp);
	/// TD 8-10-03 
	if(!trTemp)
	{
		_DBPRINTF("Fail to load XML %s:", strName)
		return false;
	}
	/// end -------TD 8-10-03 
	int nObjBits = 0;
	int nStyleBits = 0;
	if(trTemp.GetAttribute(THEME_PROPERTY_BITS_NAME, nStyleBits))
	{
		trTemp.GetAttribute(THEME_OBJECT_BITS_NAME, nObjBits);
		uint dwBits  = nStyleBits;
		uint dwOtherStyleBits = ~FPB_STYLE_LIST_MASK & dwBits;
		_DBPRINTF("property bits = %X\n", dwBits)
		if((dwBits & FPB_STYLE_LIST_MASK) && dwOtherStyleBits == 0 && nObjBits == FOB_GLOBAL)
			return true;
	}
	else
	{
		_DBSTR("No objects info");
	}
	return false;
}

//////////////////////////////////////////////////////////
/////////// end	    //////////////////////////////////////
//////////////////////////////////////////////////////////

enum {THEME_ADD, THEME_SEPARATOR, 
THEME_EDIT, THEME_DELETE, 
	THEME_SEPARATOR1,
THEME_DUPLICATE, THEME_COMBINE, 
	THEME_SEPARATOR2, 
THEME_SET_SYSTEM, THEME_CLEAR_SYSTEM,
	THEME_SEPARATOR3,
THEME_SHOW_TOOLTIPS};

//--WAIT_FIX, cannot put into constructors
//bool bIsSystemTheme;
//bool bMultiSel = false;
//---
class ThemeListControlMenu : public Menu
{
public:
	ThemeListControlMenu(bool bIsSystemTheme, bool bHasSystemTheme, bool bIsInThemeList, bool bMultiSel, bool bIsCanbeSystemTheme, bool bShowTips) : Menu()
	{
		m_nChoice = -1;
		Add(_L("Add &New"), OnMenuItem);
		Add(NULL, OnMenuItem);
		Add(_L("&Edit..."), OnMenuItem, (bIsInThemeList && !bMultiSel) ? MF_ENABLED : MF_GRAYED);
		Add(_L("&Delete"), OnMenuItem, bIsInThemeList? MF_ENABLED : MF_GRAYED);
		Add(NULL, OnMenuItem);
		Add(_L("D&uplicate"), OnMenuItem, (bIsInThemeList && !bMultiSel) ? MF_ENABLED : MF_GRAYED);
		Add(_L("Com&bine"), OnMenuItem, (bIsInThemeList && bMultiSel) ? MF_ENABLED : MF_GRAYED);
		
		Add(NULL, OnMenuItem);

		Add(_L("&Set as System Theme"), OnMenuItem, (bIsCanbeSystemTheme && bIsInThemeList && !bIsSystemTheme && !bMultiSel) ? MF_ENABLED : MF_GRAYED );
		Add(_L("&Clear System Theme"), OnMenuItem, bHasSystemTheme? MF_ENABLED : MF_GRAYED );
		
		Add(NULL, OnMenuItem);
		
		Add(_L("Show &Tooltips"), OnMenuItem, bShowTips?MF_CHECKED : MF_UNCHECKED);
	}
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= THEME_ADD && m_nChoice <= THEME_SHOW_TOOLTIPS)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
private:
	int	m_nChoice;
};





typedef bool (* P_THEME_EDITOR)(LPCSTR lpcszThemeFilename, HWND hWndParent);
	

class ThemeListControl : public GridListControl
{
public:
	void Init(int nID, Dialog& dlg)
	{
		GridListControl::Init(nID, dlg);
		Reset();
		m_flx.ExtendLastCol = true;
		m_flx.SelectionMode = flexSelectionListBox;
		m_flx.AllowSelection = true;
		m_flx.Editable = flexEDKbdMouse;
		// allow sorting
		m_flx.ExplorerBar = flexExSortShow;
		
		//---- CPY 4/25/03 ADD_FILE_DATE
		m_flx.ColFormat(GRID_COL_DATE) ="General Date"; //"Medium Date";
		m_flx.ColDataType(GRID_COL_DATE) = flexDTDate;
		//----
		
		SetAlternateRowColors();
		
		HideCol(GRID_COL_IS_SYSTEM);
	}
	void Reset()
	{
		//m_flx.FormatString = STR_THEME_GRID_COLS;
		SetFormatStrLocal(STR_THEME_GRID_COLS, _CAT);
		m_flx.Rows = 1;
		m_flx.FixedRows = 1;
		m_flx.FixedCols = 0;//hide the Row heading
		m_flx.Cols = GRID_COL_TOTAL;
	}
		

	int AddTheme(const string& str, int nType, bool bIsIncrementList)
	{
		int	nRow = m_flx.Rows;
		m_flx.AddItem(str);
		SetCellData(nRow, GRID_COL_LOCATION, nType);
		SetItalic(nRow, GRID_COL_NAME, bIsIncrementList);
		return nRow;
	}

};

const static int s_arrThemeApply[] = {THEMEAPPLY_ACTIVE, THEMEAPPLY_FOLDER, THEMEAPPLY_PROJECT};

class ThemeGalleryDlg : public ResizeDialog
{
private:
	ThemeListControl	m_themeList;	
	ComboBox m_cmbApplyTo;
	string	m_strWksName;
	string	m_strThemeFilename;
	bool	m_bExcludeIncremenTypes;
	int		m_nUndoStackCount;
	string	m_strOldStr;
	bool	m_bPreviewGraphReady;
	Control m_cntrlSystemTheme;
	bool	m_bActiveWinIsGraph;
	
public:
	ThemeGalleryDlg() : ResizeDialog(IDD_THEME_GALLERY, "ODlg")
	{
		m_bExcludeIncremenTypes = true;
		m_nUndoStackCount = 0;
		m_strOptionsSecName = "ThemeGallery";
		m_strOptionsValName = "Options";
	}
	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();// will be called from internal later
		int nRet = DoModal(hWndParent);
		
		return nRet;
	}
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	
	ON_CONTEXTMENU(OnShowMenu)

	ON_CBN_SELCHANGE(IDC_THEME_APPLY_TO, OnApplyToComboChange)

	//ON_SIZE(OnResize)
	ON_GRID_BEFORE_EDIT(IDC_THEME_GRID, OnBeforeEdit)
	ON_GRID_AFTER_EDIT(IDC_THEME_GRID, OnAfterEdit)
	//ON_GRID_AFTER_SEL_CHANGE(IDC_THEME_GRID, OnAfterSelChange)
	ON_GRID_SEL_CHANGE(IDC_THEME_GRID, OnSelChange)
	ON_GRID_MOUSE_MOVE(IDC_THEME_GRID, OnMouseMove)	//CPY 4/25/03 ADD_FILE_DATE and ADD_TOOLTIPS
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_THEME_GRID, OnBeforeMouseDown)
	ON_GRID_DBLCLICK(IDC_THEME_GRID, OnDblClick)
	//--- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
	//ON_GRID_BUTTON_CLICK(IDC_THEME_GRID, OnEditTheme)
	//---
	ON_BN_CLICKED(IDC_THEME_SHOW_GRAPH_ONLY, OnShowThemeTypes)
	ON_BN_CLICKED(IDC_THEME_APPLY, OnApplyButton)
	ON_BN_CLICKED(IDC_THEME_UNDO, OnUndoApplyButton) //CPY 4/30/03 ADD_UNDO_APPLY
EVENTS_END
	/////////////////////////////////////////////////
	// Event handling ///////////////////////////////
	/////////////////////////////////////////////////
	BOOL OnInitDialog()
	{
		waitCursor junk;
		ResizeDialog::OnInitDialog(IDC_THEME_GRID);
		
		load_options();
		
		m_cntrlSystemTheme = GetItem(IDC_THEME_CURRENT_SYSTEM);
		m_cmbApplyTo = GetItem(IDC_THEME_APPLY_TO);
		m_cmbApplyTo.SetCurSel(0);
		m_themeList.Init(IDC_THEME_GRID, *this);
		
		Button btnShowGraphTypes = GetItem(IDC_THEME_SHOW_GRAPH_ONLY);
		btnShowGraphTypes.Check = m_bExcludeIncremenTypes;
		
		load_themes_to_grid(false, false);
							
		Button btnApply = GetItem(IDC_THEME_APPLY);
		btnApply.Enable = false;
		
		//--- CPY 4/30/03 ADD_UNDO_APPLY
		undo_enabled(true, 0);
		//---
		
		GraphLayer gly = Project.ActiveLayer();
		if(gly)
			m_bActiveWinIsGraph = true;
		else
			m_bActiveWinIsGraph = false;
		
		//CPY 8/20/03
		OnDlgResize(0, GetDlgExtent(false), GetDlgExtent(true));
		return TRUE;
	}
	BOOL OnDestroy()
	{
		save_options();
		Worksheet wks(m_strWksName);
		if(wks)
			wks.Destroy();
		m_strWksName.Empty();
		
		if(m_strThemeFilename.IsFile())
			DeleteFile(m_strThemeFilename);
		m_strThemeFilename.Empty();
		
		//m_trThemes.Reset();
		return TRUE;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		uint nCntrlsRight[] = {
			IDC_THEME_APPLY_GROUP,
			IDC_THEME_APPLY_TO,
			IDC_THEME_APPLY,
			IDC_THEME_UNDO,
			IDCANCEL,
			0};
		uint nCntrlsBottom[] = {
			IDC_THEME_SHOW_GRAPH_ONLY,
			0};
		ResizeMoveControlsRightBottom(IDC_THEME_GRID, nCntrlsRight, nCntrlsBottom, cx, cy);
		return TRUE;
	}
	BOOL OnShowThemeTypes(Control cntrl)
	{
		Button btnShowGraphTypes = GetItem(IDC_THEME_SHOW_GRAPH_ONLY);
		m_bExcludeIncremenTypes = btnShowGraphTypes.Check;
		load_themes_to_grid();
		return TRUE;
	}
	//////////////////////////
	// Add New Theme
	//////////////////////////
	BOOL OnAdd(Control cntrl)
	{
		string strFilename;
		if(!theme_get_next_file_name(strFilename))
			return false;
		
		/// RVD 6/13/2003 QA70-4650 v7.0601 OBJECT_PROPERTY_ACCESS
		//GraphPage gp;
		//gp.Create(NULL, CREATE_HIDDEN);
		//Tree trTheme;
		//trTheme = gp.GetFormat();
		//gp.Destroy();
		Tree trTheme;
		trTheme = Project.CreateNewTheme();
		/// end OBJECT_PROPERTY_ACCESS
		
		trTheme.Save(strFilename);
		if(strFilename.IsFile())
		{
			//load_themes_to_grid();
			add_theme_to_grid(strFilename);
			LT_execute(STR_THEME_REMINDER_MSG_RENAME);
		}
		
		return TRUE;
	}
	BOOL OnDuplicate(Control cntrl)
	{
		string		strSelThemeFile;
		if(!getSelThemeFile(strSelThemeFile))
			return TRUE; // nothing to do
		
		string strFilename;
		if(!getCopyOfThemeFileName(strFilename, strSelThemeFile))
			return false;
		
		if(FileCopy(strSelThemeFile, strFilename, FILE_ATTRIBUTE_NORMAL, true))
		{
			//load_themes_to_grid();
			add_theme_to_grid(strFilename);
			LT_execute(STR_THEME_REMINDER_MSG_RENAME);
		}
		return TRUE;
	}
	BOOL OnCombine(Control cntrl)
	{
		StringArray vstrThemeFilenames;

		if( !getSelThemeFiles(vstrThemeFilenames) )
			return TRUE; // nothing to do
		
		string strFilename;
		if(!getCombineThemeFileName(strFilename, vstrThemeFilenames[0]))
			return false;
		
		if( FileCopy(vstrThemeFilenames[0], strFilename, FILE_ATTRIBUTE_NORMAL, true) )
		{
			for(int ii=1; ii<vstrThemeFilenames.GetSize(); ii++)
			{
				if( !CombineThemes(strFilename, vstrThemeFilenames[ii]) )
					return FALSE;
			}
			
			add_theme_to_grid(strFilename);
			LT_execute(STR_THEME_REMINDER_MSG_RENAME);
		}
		
		return TRUE;
	}
	BOOL OnApplyToComboChange(Control cntrl)
	{
		enable_buttons();
		return TRUE;
	}		
	BOOL OnApplyButton(Control cntrl)
	{		
		string		strApplyFile;

		if( !getSelThemeFile(strApplyFile) )
			return TRUE; // nothing to do
		
		BOOL bResult = theme_apply(getThemeApply(), strApplyFile);

		undo_enabled(true, 1); 

		return bResult;
	}
	
	//---- CPY 4/30/03 ADD_UNDO_APPLY
	BOOL OnUndoApplyButton(Control cntrl)
	{
		if(undo_enabled())
		{
			Project.Undo();
			undo_enabled(true, -1);
		}
		
		return true;
	}
	//---- end
	
	//////////////////////////
	// Delete Theme
	// move file into folder called "Deleted"
	//////////////////////////
		
	BOOL OnDelTheme(Control cntrl)
	{
		waitCursor junk;
		
		StringArray vstrThemeFilenames;

		if( !getSelThemeFiles(vstrThemeFilenames) )
			return TRUE; // nothing to do

		string strPath = theme_get_path();
		strPath += "Deleted";
		
		if( CheckMakePath(strPath) )
		{
			bool bDeleted = false;
			
			for(int ii=0; ii<vstrThemeFilenames.GetSize(); ii++)
			{
				string strTemp = GetFileName(vstrThemeFilenames[ii]);
				FileCopy(vstrThemeFilenames[ii], strPath + "\\" + strTemp);
				DeleteFile(vstrThemeFilenames[ii]);
				bDeleted = true;
			}
			
			if( bDeleted )
			{
				load_themes_to_grid();
				LT_execute(STR_THEME_REMINDER_MSG_DEL);
			}
		}
		
		return TRUE;
	}
	///////////////////////////////////////////////////////////////////////////////
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{
		if(IDC_THEME_GRID == nResIDCtrl)
		{
			int nRow = 0, nCol = 0;
			bool bIsInsideGrid = false;
			if(nx < 0 || ny < 0) // keyboard activated 
				bIsInsideGrid = m_themeList.GetSelCell(nx, ny, nRow, nCol);
			else
				bIsInsideGrid = m_themeList.FindCell(nx, ny, nRow, nCol);

			bool bHasSystemTheme = hasSystemTheme();
			bool bIsSystemTheme = m_themeList.GetCheck(nRow, GRID_COL_IS_SYSTEM);
			bool bIsCanbeSystemTheme = false;
			StringArray vstrThemes;
			getSelThemeFiles(vstrThemes);
			
			bool bMulti = vstrThemes.GetSize() > 1;
			//---- CPY 8/19/03 INCREMENT_LIST_NO_SYSTEM_THEME_SUPPORT
			if(!bMulti && !isIncrementListRow(nRow)) // increment list theme is shown as italic
				bIsCanbeSystemTheme = true;
			//----
			ThemeListControlMenu	myMenu(bIsSystemTheme, bHasSystemTheme, bIsInsideGrid, bMulti, bIsCanbeSystemTheme, m_bShowTooltips);
			myMenu.TrackPopupMenu(0,  nx, ny, m_wndDlg.GetSafeHwnd());
			int nCmd;
			if(myMenu.GetCommand(nCmd))
			{
				Control flxControl = GetItem(IDC_THEME_GRID);
				switch(nCmd)
				{
				case THEME_ADD:
					OnAdd(flxControl);
					break;
				case THEME_EDIT:
					OnEditTheme(flxControl);
					break;
				case THEME_DELETE:
					OnDelTheme(flxControl);
					break;
				case THEME_DUPLICATE:
					OnDuplicate(flxControl);
					break;
				case THEME_COMBINE:
					OnCombine(flxControl);
					break;
				case THEME_SET_SYSTEM:
					setSystemTheme(nRow);
					break;
				case THEME_CLEAR_SYSTEM:
					clearSystemTheme();
					break;
				case THEME_SHOW_TOOLTIPS:
					m_bShowTooltips = m_bShowTooltips? false:true;
					break;
				}
			}
			return FALSE;
		}
		return TRUE;
	}	
	//------------ vcFlex Grid Event Handlers ------------
	/////////////////////////////////////////
	//
	void OnBeforeMouseDown(Control flxControl, short nButton, short nShift, float X, float Y, BOOL* pCancel) // listCols arg not used for now, maybe needed later
	{
		int nRow, nCol, nx, ny;
		bool bIsInsideGrid = m_themeList.GetMousePixel(X, Y, nRow, nCol, nx, ny);
		
		if(m_themeList.CheckSelRow(nRow, false))
		{
			*pCancel= TRUE;
			if(nRow < 0)
				enable_buttons();
		}
	}
	void OnDblClick(Control flxControl)
	{
		int nRow = 0, nCol = 0;
		int nx = -1, ny = -1;
		m_themeList.GetSelCell(nx, ny, nRow, nCol);
		if(nCol != GRID_COL_NAME)
			OnEditTheme(flxControl);
	}

	void OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	{	
		//--- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
		//if(nCol != GRID_COL_NAME && nCol != GRID_COL_IS_SYSTEM && nCol != GRID_COL_EDIT)
		if(nCol != GRID_COL_NAME && nCol != GRID_COL_IS_SYSTEM)
		//---
		{
			*pCancel = TRUE;
			return;
		}
		
		if( GRID_COL_NAME == nCol)
			m_strOldStr = m_themeList.GetCell(nRow, nCol);
		else
			m_strOldStr = "";
	}
	
	void OnAfterEdit(Control flxControl, int nRow, int nCol)
	{
		if(GRID_COL_NAME == nCol)
		{
			string strNew = m_themeList.GetCell(nRow, nCol);
			if(strNew.CompareNoCase(m_strOldStr) != 0)
			{
				// need to rename file
				bool bIsEXEPath = m_themeList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
				if(!theme_rename(strNew, m_strOldStr, bIsEXEPath))
					m_themeList.SetCell(nRow, nCol, m_strOldStr);
				else
					checkSystemTheme(nRow);
			}
			return;
		}
		/*
		else if(GRID_COL_IS_SYSTEM == nCol)
		{
			bool bCheck = m_themeList.GetCheck(nRow, nCol);
			string strTheme = m_themeList.GetCell(nRow, GRID_COL_NAME);
			bool bIsEXEPath = m_themeList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
			theme_system_getset(strTheme, true, bCheck, bIsEXEPath);
			// next we need to clean those other checked since only one system theme is allowed
			checkSystemTheme();
		}
		*/
	}
	void OnSelChange(Control flxControl)
	{
		enable_buttons();	
	}	
	BOOL OnEditTheme(Control cntrl)
	{
		string		strThemeFile;
		if(!getSelThemeFile(strThemeFile))
			return TRUE; // nothing to do
		
		int nSelRow = m_themeList.GetSelectedRow();
		P_THEME_EDITOR fnThemeEditor = Project.FindFunction("ThemeEditor");
		if(fnThemeEditor)
		{
			if(fnThemeEditor(strThemeFile, GetSafeHwnd()))
			{
				// need to update size col
				Tree themeTree(strThemeFile);
				if(themeTree)
					m_themeList.SetCell(nSelRow, GRID_COL_SIZE, tree_count_items(themeTree));
			}
		}
		return TRUE;
	}
	//---------- CPY 4/25/03 ADD_FILE_DATE and ADD_TOOLTIPS
	void OnMouseMove(Control flxControl, short nButton, short nShift, float X, float Y)
	{
		string strTooltips;
		if(!m_bShowTooltips)
			return;
		
		int nRow, nCol;
		if(!m_themeList.GetMouseCell(nRow, nCol))
			return;
		
		if(m_themeList.IsColHeadingRow(nRow))
			strTooltips = get_col_heading_tooltips(nCol);
		else if(GRID_COL_NAME == nCol)
			strTooltips = get_theme_tooltips(nRow);	
		
		// this is not working, will need a ADO version, I suspect
		//flx.ToolTipText = strTooltips;
		show_tooltip_text(strTooltips);
		
	}
	//---------- end ADD_TOOLTIPS

private:
	bool hasSystemTheme()
	{
		string str = m_cntrlSystemTheme.Text;
		return str.IsEmpty()? false:true;
	}
	void setSystemTheme(int nRow)
	{
		if(nRow < 0)
			return;
		int nCol = GRID_COL_IS_SYSTEM;
		bool bCheck = m_themeList.GetCheck(nRow, nCol);
		if(bCheck)
			return;
		bCheck = true;
		string strTheme = m_themeList.GetCell(nRow, GRID_COL_NAME);
		bool bIsEXEPath = m_themeList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
		theme_system_getset(strTheme, true, bCheck, bIsEXEPath);
		// next we need to clean those other checked since only one system theme is allowed
		checkSystemTheme();
	}
	void clearSystemTheme() // can ignore this for now
	{
		bool bIsEXEPath, bCheck;
		int nRow1, nRow2;
		m_themeList.GetRowRange(nRow1, nRow2);
		string strTheme;
		for(int nRow = nRow1; nRow <= nRow2; nRow++)
		{
			strTheme = m_themeList.GetCell(nRow, GRID_COL_NAME);
			bIsEXEPath = m_themeList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
			bCheck = theme_system_getset(strTheme)? true : false;
			if(bCheck)
			{
				bCheck = false;
				theme_system_getset(strTheme, true, bCheck, bIsEXEPath);
				m_themeList.SetCheck(nRow, GRID_COL_IS_SYSTEM, bCheck);
				//---CPY 8/18/03 BOLD_SYSTEM_THEME_WHOLE_ROW
				//m_themeList.SetBold(nRow, GRID_COL_NAME, bCheck);
				m_themeList.SetBold(nRow, -1, bCheck);
				//---
			}
		}
		m_cntrlSystemTheme.Text = "";
	}
	bool getNextThemeFileName(string& strFilename)
	{
		string strThemePath = theme_get_path();
		strFilename = strThemePath + strFilename;
		return get_next_file_name(strFilename);
	}
	bool getCopyOfThemeFileName(string& strFilename, const string& strThemeFilename)
	{
		//---- CPY 9/20/03 THEME_DUPLICATE_LEAD_TO_SIZE_OF_NEGATIVE_1
		//string strOldThemeFilename = GetFileName(strThemeFilename);
		//strFilename.Format(_L("Copy of %s"), strOldThemeFilename);
		string strOldThemeFilename = GetFileName(strThemeFilename, TRUE); // remove ext, and add later
		strFilename.Format(_L("Copy of %s"), strOldThemeFilename);
		strFilename += "." + THEME_FILE_EXT;
		//---- end THEME_DUPLICATE_LEAD_TO_SIZE_OF_NEGATIVE_1
		return getNextThemeFileName(strFilename);
	}
	bool getCombineThemeFileName(string& strFilename, const string& strThemeFilename)
	{
		strFilename = _L("Combined theme");
		add_file_extension(strFilename, THEME_FILE_EXT);
		return getNextThemeFileName(strFilename);
	}
	bool getSelThemeFile(string& strThemeFilename)
	{
		int nSelRow = m_themeList.GetSelectedRow();
		if(nSelRow < 0)
			return false;
		
		strThemeFilename = get_theme_file_name(nSelRow);		
		return true;
	}
	bool getSelThemeFiles(StringArray& vstrThemeFilenames)
	{
		vector<uint> vnRows;
		
		if( !m_themeList.GetSelRows(vnRows) )
			return false;
		
		if( !vstrThemeFilenames.SetSize(vnRows.GetSize()) )
			return false;
		
		for(int ii=0; ii<vnRows.GetSize(); ii++)
			vstrThemeFilenames[ii] = get_theme_file_name(vnRows[ii]);
			
		return true;
	}
	string get_theme_file_name(int nRow)
	{
		string strTheme = m_themeList.GetCell(nRow, GRID_COL_NAME);
		bool bIsEXEPath = m_themeList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
		return theme_get_theme_file_name(strTheme, bIsEXEPath);
	}
	string get_theme_tooltips(int nRow)
	{
		string strThemeFile = get_theme_file_name(nRow);
		string strComments;
		Tree trTemp(strThemeFile);
		if(trTemp)
			trTemp.GetAttribute(STR_THEME_COMMENT_ATTRIB, strComments);
		
		return strComments;
	}
	// there seems to be no tooltip support for this version of vsFlex, so
	// just use dialog title for now
	void show_tooltip_text(string& str)
	{
		m_themeList.SetToolTipsText(str);
	}
	int		getThemeApply()
	{
		int nApplyTo = m_cmbApplyTo.GetCurSel();
		//if( nApplyTo >= 0 && nApplyTo < sizeof(arrThemeApply)/sizeof(arrThemeApply[0]) )
		if( nApplyTo >= 0 && nApplyTo < sizeof(s_arrThemeApply)/sizeof(int) )
			return s_arrThemeApply[nApplyTo];
		
		return THEMEAPPLY_ACTIVE;
	}
	void enable_buttons()
	{
		int nSelRow = m_themeList.GetSelectedRow();
		int nBtnIds[] = {IDC_THEME_APPLY,0};//, IDC_THEME_APPLY_TO, IDC_THEME_UNDO, 0};
		int ii = 0;
		bool bEnable = nSelRow<0? false:true;
		if(getThemeApply() == THEMEAPPLY_ACTIVE && !m_bActiveWinIsGraph)
			bEnable = false;
		while(nBtnIds[ii] > 0)
		{
			Button btn = GetItem(nBtnIds[ii++]);
			btn.Enable = bEnable;
		}
	}
	// if bUpdateButton, then
	// nInc = 0 --> init
	// inc > 0 or < 0, inc/decrement count
	bool undo_enabled(bool bUpdateButton = false, int nInc = 0)
	{
		Button btnUndo = GetItem(IDC_THEME_UNDO);
		if(bUpdateButton)
		{
			if(0==nInc)
				m_nUndoStackCount = 0;
			else
				m_nUndoStackCount += nInc;
			
			btnUndo.Enable = m_nUndoStackCount > 0? true:false;
		}
		
		return btnUndo.Enable;
	}
	void checkSystemTheme(int nRowToCheck = -1) // 
	{	
		string strThemeName;
		int nRow1 = nRowToCheck, nRow2 = nRowToCheck;
		if(nRowToCheck < 0)
			m_themeList.GetRowRange(nRow1, nRow2);
		string strSystemTheme;
		for(int nRow = nRow1; nRow <= nRow2; nRow++)
		{
			strThemeName = m_themeList.GetCell(nRow, GRID_COL_NAME);
			bool bCheck = theme_system_getset(strThemeName)? true : false;
			if(bCheck)
				strSystemTheme = strThemeName;
				
			m_themeList.SetCheck(nRow, GRID_COL_IS_SYSTEM, bCheck);
			//---CPY 8/18/03 BOLD_SYSTEM_THEME_WHOLE_ROW
			//m_themeList.SetBold(nRow, GRID_COL_NAME, bCheck);
			m_themeList.SetBold(nRow, -1, bCheck);
			//---
		}
		m_cntrlSystemTheme.Text = strSystemTheme;
	}
	int addThemes(TreeNode& trNode)
	{
		int nRow = -1;
		string str, strLocation, strThemeName;
		foreach(TreeNode tn in trNode.Children)
		{
			int nType;
			tn.GetAttribute(THEME_TYPE_ATTRIBUTE, nType);
			bool bIsEXEPath = nType == THTYPE_SYSTEM? true:false;
			if(bIsEXEPath)
				strLocation = STR_THEME_TYPE_SYSTEM;
			else
				strLocation = STR_THEME_TYPE_USER;
			
			strThemeName = tn.strVal;
			//--- CPY 4/1/03 CHECK_BOX_TO_SHOW_ONLY_GRAPH_THEME
			string strThemeFilename = theme_get_theme_file_name(strThemeName, bIsEXEPath);
			bool bIsIncrementList = theme_is_increment_theme(strThemeFilename);
			if(m_bExcludeIncremenTypes && bIsIncrementList)
				continue;
			//---
			string strDate = GetFileModificationDate(strThemeFilename, LDF_SHORT_AND_HHMM_SEPARCOLON); //CPY 4/25/03 ADD_FILE_DATE
			
			//----- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
			//str = "\t" + strLocation + "\t" + "click->" + "\t" + strThemeName;
			int nSize = theme_count_properties(strThemeFilename);
			str = "\t" + strThemeName + "\t" + nSize + "\t" + strDate + "\t" + strLocation;
			//-----
			nRow = m_themeList.AddTheme(str, nType, bIsIncrementList);
		}
		return nRow;
	}
	
	bool isIncrementListRow(int nRow)
	{
		return m_themeList.IsItalic(nRow, GRID_COL_NAME);
	}
	
	void load_themes_to_grid(bool bRemoveOld = true, bool bSelLast = true)
	{
		if(bRemoveOld)
			m_themeList.Reset();
		
		Tree trTemp;
		trTemp.AddNode("Themes");
		
		theme_find_all_theme_files(trTemp.FirstNode);
		addThemes(trTemp.FirstNode);
		checkSystemTheme();
		resizeThemeCols();	
		m_themeList.SelRow(-1, bSelLast);
	}
	void add_theme_to_grid(const string& strThemeFilename, bool bUser = true, bool bSelIt = true)
	{
		Tree trTemp;
		trTemp.AddNode("Themes");
		theme_add_one_theme_file(trTemp.FirstNode, strThemeFilename, bUser);
		int nRow = addThemes(trTemp.FirstNode);
		checkSystemTheme();
		resizeThemeCols();	
		if(bSelIt)
			m_themeList.SelRow(nRow, true);
	}
	void resizeThemeCols()
	{
		m_themeList.ResizeCols(2);// was 3, Easwar said he has theme name longer	
	}
	void load_options()
	{
		m_bShowTooltips = true;
		vector<byte> vbCheckSettings;
		if(load_default_checkboxes(m_strOptionsSecName, vbCheckSettings, m_strOptionsValName) && vbCheckSettings.GetSize() > 0)
			m_bShowTooltips = vbCheckSettings[0];
	}
	void save_options()
	{
		vector<byte> vbCheckSettings;
		vbCheckSettings.Add(m_bShowTooltips);
		save_default_checkboxes(m_strOptionsSecName, vbCheckSettings, m_strOptionsValName);
	}
private:
	string	m_strOptionsSecName;
	string	m_strOptionsValName;
	bool	m_bShowTooltips;
};
 
int ThemeGallery()
{
	ThemeGalleryDlg themeDlg;
	
	int nRet = themeDlg.DoModalEx( GetWindow() );
	
	return 0;
}


