/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// you can include just this typical header file for most Origin built-in functions and classes
// and it takes a reasonable amount of time to compile, 
#include <OC_const.h>
#include <common.h>
#include <project.h>
#include <utilities.h>
#include <dialog.h>
// this file include most of the other header files except the NAG header, which takes longer to compile
// NAG routines
//#include <OC_nag.h> // this contains all the NAG headers, 

////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Dialog for Convert Random XYZ

static Dialog GraphDialog("GridSelectRange" ,"<ODlg>");

int  OpenGraphDialog()
{
	return GraphDialog.DoModal();
}

static double OK_Click()
{
	string gw = LabTalkDialog.GridSelectRange.placeholder.graph$;
	GraphPage gp;
	GraphLayer gl;
	GraphObject	grobj;
	gp = Project.GraphPages(gw);
	gl = gp.Layers(0);
	grobj = gl.GraphObjects("RECT");
	LabTalkDialog.Gridding.Xfrom.v1 = grobj.X - grobj.DX/2.0;
	LabTalkDialog.Gridding.Xto.v1 = grobj.X + grobj.DX/2.0;
	LabTalkDialog.Gridding.YFrom.v1 = grobj.Y - grobj.DY/2.0;
	LabTalkDialog.Gridding.Yto.v1 = grobj.Y + grobj.DY/2.0;
	return 0;
}
	
void OnInit()
{
	GraphDialog.graph.create("GSR");
	GraphDialog.placeholder.attach();
	GraphDialog.placeholder.setref();
	string gw = LabTalkDialog.GridSelectRange.placeholder.graph$;
	GraphPage gp;
	GraphLayer gl;
	GraphObject	grobj;
	gp = Project.GraphPages(gw);
	gl = gp.Layers(0);
	grobj = gl.GraphObjects("RECT");
	PageBase pbActiveWindow;
	pbActiveWindow = Project.Pages();
	string strWindowName = pbActiveWindow.GetName();
	Worksheet ws(strWindowName);
	double xd, yd;
	LT_get_var("nXcol", &xd);
	LT_get_var("nYcol", &yd);
	Curve cv(ws, xd-1, yd-1);
	gl.AddPlot(cv,IDM_PLOT_SCATTER);
	gl.Rescale();
	grobj.X = LabTalkDialog.Gridding.Xfrom.v1 + (LabTalkDialog.Gridding.Xto.v1 - LabTalkDialog.Gridding.Xfrom.v1)/2;
	grobj.Y = LabTalkDialog.Gridding.Yfrom.v1 + (LabTalkDialog.Gridding.Yto.v1 - LabTalkDialog.Gridding.Yfrom.v1)/2;
	grobj.DX = LabTalkDialog.Gridding.Xto.v1 - LabTalkDialog.Gridding.Xfrom.v1;
	grobj.DY = LabTalkDialog.Gridding.Yto.v1 - LabTalkDialog.Gridding.Yfrom.v1;
	LabTalkDialog.GridSelectRange.Xfrom.v1=LabTalkDialog.Gridding.Xfrom.v1;
	LabTalkDialog.GridSelectRange.Xto.v1=LabTalkDialog.Gridding.Xto.v1;
	LabTalkDialog.GridSelectRange.Yfrom.v1=LabTalkDialog.Gridding.Yfrom.v1;
	LabTalkDialog.GridSelectRange.Yto.v1=LabTalkDialog.Gridding.Yto.v1;
}