/*------------------------------------------------------------------------------*
 * File Name:SaveFormatAsTheme.c												*
 * Creation: CPY																*
 * Purpose: OriginC Source C file for Save Format As Theme Dialog				*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
//#include <Project.h>
//#include <sys_utils.h> // basic routines implemeted through Origin C, see sys_utils.c
#include <Dialog.h>
//#include <utilities.h>
//#include <tree_utils.h>
#include "ResizeDialog.h"
#include <TreeEditor.h>
#include <vsFlexGrid.h>
#include "ODlg.h" // resource IDs, ODlg.dll also use this file for its res ids
#include "HelpID.h"
#include "theme_utils.h"

#include "$Local.h"     // Localized definitions

#define STR_SAVE_THEME_CAPTION		_L("Theme Saving")
#define STR_SAVE_THEME_ASK_REPLACE	_L("The named theme file already existed, do you want to replace it?")
#define STR_SAVE_THEME_BAD_FILENAME _L("The specified theme name is not a valid file name.")

int SaveFormatAsTheme() 
{
	SaveThemeDlg	SaveTheme;

	int nRet = SaveTheme.DoModalEx();
	return 0;
}

class SaveThemeDlg : public ResizeDialog
{
public:
	SaveThemeDlg() : ResizeDialog(IDD_SAVE_THEME, "ODlg")
	{
		string strThemeFileName;
		if(theme_get_next_file_name(strThemeFileName))
			m_strThemeName = GetFileName(strThemeFileName, true);
		
	}
	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();// will be called from internal later
		int nRet = DoModal(hWndParent);
		
		return nRet;
	}
private:
	string	m_strThemeFileAllFormats;
	string	m_strThemeName;

	// controls
	TreeEditor	m_tree;
	Edit		m_editName;
	Edit		m_editDescription;
	//Button 		m_btnCheckAdvanced;
	//bool		m_btnCheckAdvanced;
	BitmapRadioButton	m_btnCheckAdvanced;
	
	Control 	m_cntrlOldSystemTheme;
	Control		m_cntrlSimpleGroup; 
	Button		m_chkAll;
	Button		m_chkAllStyles;
	Button		m_chkFonts;
	Button		m_chkColors;
	Button		m_chkPlots; // symbol line fill
	Button		m_chkDimension;
	Button		m_chkScale;
	Button		m_chkBkground;
	Button		m_chkText;
	
protected:
	EVENTS_BEGIN
		ON_INIT(OnInitDialog) 
		ON_OK(OnOK)
		ON_BN_CLICKED(IDC_SAVETHEME_CUSTOM, OnAdvancedCheck)
		ON_BN_CLICKED(IDC_SAVETHEME_LIST_VIEW, OnListViewCheck)
		ON_BN_CLICKED(IDC_SAVETHEME_FILTER, OnThemeFilter)
		ON_BN_CLICKED(IDC_SAVETHEME_ALL, OnSimpleGroupCheck)
		ON_BN_CLICKED(IDC_SAVETHEME_ALL_STYLES, OnSimpleGroupCheck) 
		ON_DESTROY(OnDestroy)
		ON_EN_CHANGE(IDC_SAVETHEME_NAME, OnNameChange)
	EVENTS_END
	
	BOOL OnInitDialog()
	{
		waitCursor junk;
		ResizeDialog::OnInitDialog();
		
		m_tree = GetItem(IDC_SAVETHEME_TREE);
		m_editName = GetItem(IDC_SAVETHEME_NAME);
		m_editName.Text = m_strThemeName;
		m_editDescription = GetItem(IDC_SAVETHEME_DESCRIPTION);
		
		m_btnCheckAdvanced = GetItem(IDC_SAVETHEME_CUSTOM);
		
		vector<string>  vstrTipsUpDown;
		vstrTipsUpDown.Add(_L("Edit theme details"));
		vstrTipsUpDown.Add(_L("Cancel edit"));
		m_btnCheckAdvanced.Init(2, IDB_EDIT_DOWNUP, 37, vstrTipsUpDown);
		//m_btnCheckAdvanced = false;
		
		m_chkAll = GetItem(IDC_SAVETHEME_ALL);
		m_chkAllStyles = GetItem(IDC_SAVETHEME_ALL_STYLES);
		m_chkFonts = GetItem(IDC_SAVETHEME_FONTS);
		m_chkColors = GetItem(IDC_SAVETHEME_COLORS);
		m_chkPlots = GetItem(IDC_SAVETHEME_DATAPLOT);
		m_chkDimension = GetItem(IDC_SAVETHEME_DIMS);
		m_chkScale = GetItem(IDC_SAVETHEME_SCALES);
		m_chkBkground = GetItem(IDC_SAVETHEME_BACKGROUD);
		m_chkText = GetItem(IDC_SAVETHEME_TEXT);
		
		m_chkAll.Check = true;
		updateSimpleGroup();
		
		show_controls(m_btnCheckAdvanced.Check);
		
		copyThemeAllFormats();
		if(m_btnCheckAdvanced.Check)
			load_theme_to_tree();

		//m_wndDlg.CheckRadioButton(IDC_SAVETHEME_ALL, IDC_SAVETHEME_SCALES, save_format_type_to_radio(m_nSaveFormatType));
		
		m_cntrlOldSystemTheme = GetItem(IDC_SAVETHEME_CURRENT_SYSTEM);
		m_cntrlOldSystemTheme.Text = theme_get_system_theme();
		
		m_cntrlSimpleGroup = GetItem(IDC_SAVETHEME_SIMPLE_GROUP);
		return TRUE;	
	}
	BOOL OnOK()
	{
		if(m_strThemeName.IsEmpty())
			return FALSE;
		if(!is_str_valid_for_filename(m_strThemeName))
		{
			MessageBox(GetSafeHwnd(), STR_SAVE_THEME_BAD_FILENAME, STR_SAVE_THEME_CAPTION, MB_OK);
			return FALSE;
		}
		string strTempThemeFilename;
		GetTempFileName(strTempThemeFilename);
		
		if(m_btnCheckAdvanced.Check)
			m_tree.Save(strTempThemeFilename);
		else
			getFormatsBySimpleGroup(strTempThemeFilename);

		if(strTempThemeFilename.IsFile())
		{
			// description
			string	strComments;
			if(hasDescription(strComments))
			{
				Tree trTemp(strTempThemeFilename);
				trTemp.SetAttribute(STR_THEME_COMMENT_ATTRIB, strComments);
				trTemp.Save(strTempThemeFilename);
			}
			string strThemeFileEXE = theme_get_theme_file_name(m_strThemeName, true);
			string strThemeFile = theme_get_theme_file_name(m_strThemeName);
			if((strThemeFile.IsFile() || strThemeFileEXE.IsFile()) && MessageBox(GetSafeHwnd(), STR_SAVE_THEME_ASK_REPLACE, STR_SAVE_THEME_CAPTION, MB_OKCANCEL) == IDCANCEL)
				return FALSE;
			
			CopyFile(strTempThemeFilename, strThemeFile);
			Button cSetSys = GetItem(IDC_SAVETHEME_SET_SYSTEM);
			if(cSetSys.Check)
				theme_system_getset(m_strThemeName, true, true, false);
	
			DeleteFile(strTempThemeFilename);
			return TRUE;
		}
		out_str("Err, Save Theme dialog error!");
		return TRUE;
	}
	BOOL OnDestroy(void)
	{
		if(m_strThemeFileAllFormats.IsFile())
			DeleteFile(m_strThemeFileAllFormats);
		m_strThemeFileAllFormats.Empty();
		
		return TRUE;
	}
	BOOL OnAdvancedCheck(Control oCntrl)
	{
		bool bCheck = m_btnCheckAdvanced.Check;
		show_controls(bCheck);
		if(bCheck)
			load_theme_to_tree();
		
		//oCntrl.Visible = false;
		return TRUE;
	}
	BOOL OnListViewCheck(Control oCntrl)
	{
		update_tree_view_mode();
		return TRUE;
	}
	BOOL OnNameChange(Control ctrl)
	{
		Edit editName = ctrl;
		m_strThemeName = editName.Text;
		return TRUE;
	}
	BOOL OnThemeFilter(Control ctrl)
	{
		theme_filter_dialog(*this, IDC_SAVETHEME_LIST_VIEW, IDC_SAVETHEME_TREE);
		return TRUE;
	}
	BOOL OnSimpleGroupCheck(Control ctrl)
	{
		updateSimpleGroup();
		return TRUE;
	}
private:
	bool hasDescription(string& str)
	{
		str = m_editDescription.Text;
		return str.IsEmpty()? false:true;
	}
	void update_tree_view_mode()
	{
		Button btnListView = GetItem(IDC_SAVETHEME_LIST_VIEW);//oCntrl;
		
		DWORD dwViewSettings = VIEWFLT_PROPERTY_ALL;
		
		if(btnListView.Check)
			dwViewSettings |= VIEWFLT_FULL_PATHS_IN_LABELS;
		else
			dwViewSettings |= VIEWFLT_BRANCH_NON_COLLECTION | VIEWFLT_BRANCH_EMPTY;
				
		m_tree.View = dwViewSettings;
	}
	void updateSimpleGroup()
	{
		uint nSubStyles[] = {IDC_SAVETHEME_FONTS, IDC_SAVETHEME_COLORS, IDC_SAVETHEME_DATAPLOT, IDC_SAVETHEME_BACKGROUD, 0};
		uint nOthers[] = {IDC_SAVETHEME_DIMS, IDC_SAVETHEME_SCALES, IDC_SAVETHEME_TEXT,0};
		if(m_chkAll.Check)
		{
			m_chkAllStyles.Check = false; m_chkAllStyles.Enable = false;
			EnableControls(nSubStyles, false);
			EnableControls(nOthers, false);
		}
		else
		{
			m_chkAllStyles.Enable = true;
			EnableControls(nSubStyles, m_chkAllStyles.Check?false:true);
			EnableControls(nOthers, true);
		}
		if(m_chkAllStyles.Check)
		{
			m_chkAll.Check = false; //m_chkAll.Enable = false;
		}
		//else
		//	m_chkAll.Enable = true;
	}
	void show_controls(bool bAdvanced)
	{
		bool bSimple = !bAdvanced;
		uint nSimpleItems[] = {
			IDC_SAVETHEME_ALL,IDC_SAVETHEME_ALL_STYLES,
			IDC_SAVETHEME_COLORS, IDC_SAVETHEME_FONTS,
			IDC_SAVETHEME_DIMS, IDC_SAVETHEME_SCALES,
			IDC_SAVETHEME_DATAPLOT, IDC_SAVETHEME_BACKGROUD,
			IDC_SAVETHEME_TEXT, IDC_SAVETHEME_SIMPLE_GROUP,
			0};
		uint nAdvancedItems[] = {
			IDC_SAVETHEME_TREE, IDC_SAVETHEME_FILTER,
			IDC_SAVETHEME_LIST_VIEW,IDC_SAVETHEME_CUSTOM_TEXT,
			0};
			
		ShowControls(nSimpleItems, bSimple);
		ShowControls(nAdvancedItems, bAdvanced);

		if(bAdvanced)
		{
			RECT r1;
			m_cntrlSimpleGroup.GetWindowRect(&r1);
			m_wndDlg.ScreenToClient(&r1);
			int ny = PositionControl(IDC_SAVETHEME_CUSTOM_TEXT, r1.left, r1.top);
			StretchControlWide(IDC_SAVETHEME_TREE, r1.left, ny, RECT_WIDTH(r1), 0);
			ResizeDlgToBottomOfControl(IDC_SAVETHEME_TREE);
		}
		else
			ResizeDlgToBottomOfControl(IDC_SAVETHEME_SIMPLE_GROUP);
	}
	bool copyThemeAllFormats()
	{
		if(!GetTempFileName(m_strThemeFileAllFormats))
			return false;
		/*
		theme_copy_format();
		if(!CopyThemeFromClipboard(m_strThemeFileAllFormats))
		{
			DeleteFile(m_strThemeFileAllFormats);
			m_strThemeFileAllFormats.Empty();
			return false;
		}
		*/
		if(theme_copy_format_to_file(m_strThemeFileAllFormats))
			return true;
		m_strThemeFileAllFormats.Empty();
		return false;	
	}
	void load_theme_to_tree()
	{
		if(m_strThemeFileAllFormats.IsFile())
		{
			string strTempThemeFilename;
			GetTempFileName(strTempThemeFilename);
			if(getFormatsBySimpleGroup(strTempThemeFilename))
			{
				m_tree.Load(strTempThemeFilename);
				DeleteFile(strTempThemeFilename);
			}
			else
				m_tree.Load(m_strThemeFileAllFormats);
				
			update_tree_view_mode();
		}
	}
	bool getFormatsBySimpleGroup(LPCSTR lpcszfilename)
	{
		if(!m_strThemeFileAllFormats.IsFile())
			return false;

		if(m_chkAll.Check)
		{
			CopyFile(m_strThemeFileAllFormats, lpcszfilename);
			return true;
		}

		DWORD dwObjs = 0;
		DWORD dwProps = 0;

		if(m_chkAllStyles.Check)
		{
			theme_combine_filter_bits(SAVETHEME_ALL_STYLES, dwProps, dwObjs);
		}
		else
		{
			if(m_chkFonts.Check)
				theme_combine_filter_bits(SAVETHEME_FONTS, dwProps, dwObjs);

			if(m_chkColors.Check)
				theme_combine_filter_bits(SAVETHEME_COLORS, dwProps, dwObjs);

			if(m_chkPlots.Check)
				theme_combine_filter_bits(SAVETHEME_PLOTS, dwProps, dwObjs);

			if(m_chkBkground.Check)
				theme_combine_filter_bits(SAVETHEME_BACKGROUND, dwProps, dwObjs);
		}

		if(m_chkDimension.Check)
			theme_combine_filter_bits(SAVETHEME_DIMS, dwProps, dwObjs);

		if(m_chkScale.Check)
			theme_combine_filter_bits(SAVETHEME_SCALES, dwProps, dwObjs);

		if(m_chkText.Check)
			theme_combine_filter_bits(SAVETHEME_TEXT, dwProps, dwObjs);
		
		ApplyFilterToTheme(m_strThemeFileAllFormats, lpcszfilename, dwProps, dwObjs);
		return true;
	}
};


