/*------------------------------------------------------------------------------*
 * File Name:ResizeControl.h													*
 * Creation: TD 9/5/2003														*
 * Purpose: OriginC Header file for Panel control base class					*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
#ifndef _RESIZE_CONTROL_H_
#define _RESIZE_CONTROL_H_

#define STR_INCREASE_HEIGHT	_L("Enlarge Panel")
#define STR_DECREASE_HEIGHT	_L("Shrink Panel")

// base class for a control that can serve as the main control in a control group
// that we call a Panel
class ResizeControl
{
public:
	ResizeControl()
	{
	}
	~ResizeControl()
	{
	}
	void InitControl(int nID, Dialog& dlg)
	{
		m_cntrl 	= dlg.GetItem(nID);
		m_wndDlg 	= dlg.GetWindow();
	}
	void GetRect(RECT& rect)
	{
		m_cntrl.GetWindowRect(&rect);
		m_wndDlg.ScreenToClient(&rect);
	}
	void ClientToScreen(RECT& rect)
	{
		m_wndDlg.ClientToScreen(&rect);
	}
	void ScreenToClient(RECT& rect)
	{
		m_wndDlg.ScreenToClient(&rect);
	}
	void GetWindowRect(RECT& rect)
	{
		m_cntrl.GetWindowRect(&rect);
	}
	string FontName() {return m_wndDlg.FontName;}
	int	FontSize() {return m_wndDlg.FontSize;}
	void PostDlgMessage(uint msg, DWORD wParam = 0, DWORD lParam = 0)
	{
		m_wndDlg.PostMessage(msg, wParam, lParam);
	}
	HWND	GetDlgSafeHwnd()
	{
		return m_wndDlg.GetSafeHwnd();
	}
	virtual bool SetVisible(bool bSet = true)
	{
		bool bOldVal = IsVisible();
		if(m_cntrl)
			m_cntrl.Visible = bSet;
		return bOldVal;
	}
	virtual bool IsVisible()
	{
		if(m_cntrl)
		{
			if(m_cntrl.Visible)
				return true;
		}
		return false;
	}
	void SetToolTipsText(const string& str, bool bCheckSame = true)
	{
		if(bCheckSame && m_strLastTooltips.CompareNoCase(str) == 0)
			return;
		
		m_cntrl.SetToolTip(str);
		m_strLastTooltips = str;
	}
	void MoveWindow(RECT& rect)
	{
		m_cntrl.MoveWindow(&rect);
	}
	int PixelsToTwips(int pixels, bool bX=true)
	{
		DeviceContext dc = m_cntrl.GetDC();
		double vv = 0.5 + pixels * 1440.0 / dc.GetDeviceCaps(bX? LOGPIXELSX : LOGPIXELSY);
		return vv;
	}
	int TwipsToPixels(int twips, bool bX=true)
	{
		DeviceContext dc = m_cntrl.GetDC();
		
		double vv = 0.5 + dc.GetDeviceCaps(bX? LOGPIXELSX : LOGPIXELSY) * (double)twips / 1440.0;
		return vv;
	}
public:
	virtual bool IsResize(bool bOnExpand = true) { return IsVisible();}
	virtual int	GetPanelHeight(bool bGetMin = false) {return 0;}
	virtual int GetPanelWidth(bool bGetMin = false) {return 0;}

	virtual int GetMinHeight(bool bKeepFunctional = false) {return 24;}
	virtual int GetMaxHeight(bool bKeepFunctional = false) {return GetSystemMetrics(SM_CYSCREEN)/2;}
	virtual string GetRuntimeClass()
	{
		return "ResizeControl";
	}
	// when using this control as the Main control of a Panel (group)
	virtual int GetHeight(bool bDefault = false)
	{		
		RECT r1;
		GetWindowRect(r1);
		return RECT_HEIGHT(r1);
	}
	// must return actual height, control might have minimum height
	virtual int SetHeight(int nHeight)
	{
		RECT r1;
		if(nHeight < GetMinHeight())
			return GetHeight();
		if(nHeight > GetMaxHeight())
			nHeight = GetMaxHeight();
		GetRect(r1);
		r1.bottom = r1.top + nHeight;
		MoveWindow(r1);
		return GetHeight();
	}
protected:
	Control*	GetControl() 
	{
		if(m_cntrl)
			return &m_cntrl;
		return NULL;
	}
private:
	Control 	m_cntrl;
	Window		m_wndDlg;
	string		m_strLastTooltips;
};

#endif //_RESIZE_CONTROL_H_

