/*------------------------------------------------------------------------------*
 * File Name: OriginEvents.c 													*
 * Creation: RVD																*
 * Purpose: OriginC Source C file for Origin Events								*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#include <origin.h>
#include <MsgMap.h>

#ifdef _OPERATION_H
	#include <analysis_utils.h>
#endif //_OPERATION_H

#include "theme_utils.h"
#include "oEvents.h"

#define _DBMGS(_STR)		//out_str(_STR);

BEGIN_OK_EVENT_MAP
	ON_OK_EVENT(OE_CREATE_NEW_GRAPH_PAGE_ADD_DATA, OnCreateNewGraphPageAddData)
	ON_OK_EVENT(OE_AFTER_LOAD_FROM_TEMPLATE, OnAfterLoadFromTemplate)
END_OK_EVENT_MAP

static void	ApplySystemThemeToPage(OriginObject& obj)
{
	GraphPage page;
	page = (GraphPage) obj;

	if( page )
	{
		DWORD dwCntrl = LabTalk.page.cntrl;	//temporary solution
		if( !(dwCntrl & PPDWCNTRL_IGNORE_SYSTEM_THEME) )
		{
			string str = theme_get_system_theme_file_name(THEME_APPLY_LOAD_TEMPLATE);
			if( !str.IsEmpty() )
				obj.ApplyFormat(str);
		}
	}
}


static BOOL OnCreateNewGraphPageAddData(OriginObject& obj)
{
	//MessageBox(NULL, "OnCreateNewGraphPageAddData", "Event");
	ApplySystemThemeToPage(obj);
	
	//----- reminder message box to help user to use Theme
	string strTemp = theme_get_system_theme();
	string strMsgKey;
	if(strTemp.IsEmpty())
		strMsgKey = "ThemeNewGraph";
	else
		strMsgKey = "SystemThemeInUse";
	
	strTemp.Format("queue {type -M %s}", strMsgKey);
	LT_execute(strTemp);
	//-----
	return TRUE;
}

/// YuI 9/19/03 v7.5700 SYSTEM_THEME_IS_NOT_APPLIED_TO_SOME_PLOTS
BOOL	ApplySystemThemeToActivePage()
{
	Page pg = Project.Pages();
	ApplySystemThemeToPage(pg);
	return TRUE;
}
/// end SYSTEM_THEME_IS_NOT_APPLIED_TO_SOME_PLOTS

static BOOL OnAfterLoadFromTemplate(OriginObject& obj)
{
	//MessageBox(NULL, "OnAfterLoadFromTemplate", "Event");
	ApplySystemThemeToPage(obj);
	return TRUE;
}

#ifdef _OPERATION_H
////////////////////////////////////////////////////////////////////////////
// Called (for now) from modeless dialogs on hitting "Apply", "Compute"
// and alike.
////////////////////////////////////////////////////////////////////////////
bool	do_new_operation(const TreeNode& trNode, LPCSTR lpcszName, BOOL bTry)
{
	/// temp
	//out_str("Inside do_new_operation()");
	//return TRUE;
	///
	
	string			strPathName = "OriginLab\\";
	strPathName += lpcszName;
	strPathName += ".cpp";
	OperationBase	*op = Project.NewOperation(lpcszName, strPathName, TRUE);
	//if( NULL == op ) // If unable to create operation object...
	//{
		//out_str("No operation object created!");
		//return false;
	//}
	if(NULL == op)
		return false;

	if(FALSE == op->Init(trNode))	// it should set all inputs and outputs
	{
		Project.DeleteOperation(op, TRUE);
		return false;
	}
	
	if (bTry)
		op->SetShowPageInfoHeader(DBAR_NONE);

	// Exectute operation
	//BOOL			bOK = op->Execute();
	BOOL			bOK = op->Run();
	
	BOOL			bDestroy = bTry || !bOK;
	if (FALSE == bDestroy)
		op->UpdateHeaderInfo();
	
	Project.DeleteOperation(op, bDestroy);
	
	return bOK;
}


//----- CPY 4/30/03, implemented in OriginEvents.c
bool do_operation_dlg_cancel(const TreeNode& pTree)
{
	OperationBase opb;
	opb = (OperationBase) Project.GetObject(pTree.Operation.UID.nVal);
	if( opb )
	{
		opb.Run();
		return true;
	}
	else
	{
		ASSERT(FALSE);
		return false;
	}
}

bool is_dlg_ShiftShow_checked(LPCSTR lpcszDlgName, bool bDefault) // = false
{
	INIFile iniOrigin;
	string strItem = iniOrigin.ReadString("DBWINPOS", lpcszDlgName);
	if(strItem.IsEmpty())
		return bDefault;
	
	vector<string> vsVals;
	int nTokens = strItem.GetTokens(vsVals);
	int nShiftShowPos = 6;// 1 offset
	if(nTokens < nShiftShowPos)
		return bDefault;

	string strShiftShow = vsVals[nShiftShowPos-1];
	if(strShiftShow.IsEmpty() || strShiftShow.GetLength() < 1)
		return bDefault;// we had bugs that used to put junk into that last position
	
	return strShiftShow[0] == '1'? true:false;
}
//-----




bool GetNBox_on_try_operation(TreeNode& trGUI)
{
	TreeNode trOperation = trGUI.Parent();
	if(!trOperation.IsValid())
	{
		return false;
	}
	
	_DBMGS("Inside GetNBox_on_try_operation()");
	
	//Operation opObj;// = Project.GetObject(tr.Operation.UID.nVal);
	//opObj = Project.GetObject(trOperation.Operation.UID.nVal);
	//if(opObj.IsValid())
	//	opObj.GUItoOperation(trOperation, GUI_OP_TRY);
	OperationBase &operation = Project.GetOperationObject(trOperation.Operation.UID.nVal);
	if(operation.IsValid())
		operation.GUItoOperation(trOperation, GUI_OP_TRY);
	//do_run_operation(&trOperation, trOperation.Operation.AutoUpdate.nVal);
	do_run_operation(&trOperation, TRUE); //ML said should be always TRUE
	
	++trOperation.Operation.TryCount.nVal;
		
	return true;
}

#endif //_OPERATION_H
