/*------------------------------------------------------------------------------*
 * File Name: CMATFileImportDlg.h		 										*
 * Creation: Soapy 																*
 * Purpose: MAT File Import Dialog class										*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _CMAT_FILE_IMPORT_DLG_H
#define _CMAT_FILE_IMPORT_DLG_H

#include "CMATFile.h"

#define IMPORT_MATFILE_WITHOUT_COM 
#include "MatImportDlgBase.h"

#define MATLAB_OUTPUT_NAME_COL	0

class CMATFileImportDlg : public MatImportDlgBase
{
public:
	CMATFileImportDlg() : MatImportDlgBase()
	{
		
	}
public:	
	int DoModalEx(HWND hWndParent = NULL, LPCSTR lpcszMatlabWkspaceName = NULL)
	{
		InitMsgMap();// will be called from internal later
		m_strMatlabWorkspaceFilename = lpcszMatlabWkspaceName;   // the MAT file name
		int nRet = ResizeDialog::DoModal(hWndParent);
		return nRet;
	}
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_SIZE(OnDlgResize)
	ON_OK(OnClose)
	ON_DESTROY(OnDestroy)
	ON_BN_CLICKED(IDC_MATLAB_BTN_IMPORT, OnImportAsMatrices)
	ON_BN_CLICKED(IDC_MATLAB_BTN_IMPORT_WKS, OnImportAsSingleWks)
	ON_BN_CLICKED(IDC_MATLAB_CHK_REPLACE_MAT, OnClickReplaceMat)
	ON_BN_CLICKED(IDC_MATLAB_CHK_REPLACE_WKS, OnClickReplaceCol)
	ON_GRID_SEL_CHANGE(IDC_MATLAB_GRID, OnVsFlexSelChange)
EVENTS_END	

protected:
	
	void OnVsFlexSelChange(Control ctrl);
	
	BOOL OnInitDialog();
	
	void FillTheGridWithData();
	
	bool ImportToMatrices(vector<uint>& vecIndex, StringArray& vStrName, vector<bool>& vbIsComplex);
	
	// Import as matrices
	BOOL OnImportAsMatrices(Control ctrl);
	
	// Import real array to the worksheet
	bool ImportToWks(vector<uint>& vecIndex, StringArray& vStrName);

	// Import as worksheet		
	BOOL OnImportAsSingleWks(Control ctrl);
	
private:
	CMATFile m_fMatFile;
};
	
	
	
void CMATFileImportDlg::OnVsFlexSelChange(Control ctrl)
{
	if ( m_bDisableImportBtnUpdate )
		return;
	
	BOOL bHasSelection = 0 < m_vsFlex.SelectedRows();
			
	//DVT:	should actualy disable/enable based on importability.
	//this is not complete version, should actualy de-select MATLAB_VAR_UNKNOWN rows
	BOOL bHasWksSelection = FALSE;
	BOOL bHasMatSelection = FALSE;
	
	if( bHasSelection )
	{
		int nRowsSelected = m_vsFlex.SelectedRows();
	    for( int ii=0; ii < nRowsSelected; ii++ )
	    {
			long nR = m_vsFlex.SelectedRow(ii);
			
			string strName = m_vsFlex.GetCell( nR, MATLAB_OUTPUT_NAME_COL);
			
			TreeNode trNode = m_fMatFile.m_trFileInfo.GetNode(strName);
			if(trNode.Imported.nVal== 1)
			{
				bHasMatSelection = TRUE;
				if(trNode.Type.strVal.Compare("COMPLEX") != 0)
				{
					bHasWksSelection = TRUE;
					break;
				}
			}
	    }
	}
		
	EnableImportWksBtn(bHasWksSelection);	
	EnableImportMatBtn(bHasMatSelection);	
}


BOOL CMATFileImportDlg::OnInitDialog()
{
	MatImportDlgBase::OnInitDialog();
	
	// Read the MAT file
	if(!m_fMatFile.ReadMATFile(m_strMatlabWorkspaceFilename))
	{
		out_str("Open File Fails.");
		return true;
	}
	
	// Fill the Grid
	FillTheGridWithData();
			
	m_vsFlex.ShowTheGrid( );
	
	m_bDisableImportBtnUpdate = false;
	
	return TRUE;
}

// Fill the Grid by the variable info in the CMATFile object
void CMATFileImportDlg::FillTheGridWithData()
{
	_DBSTR( strRet )

	m_vsFlex.SetupTheGrid();	//delete all but headers
	
	string strRow;
	TreeNode trNode;
	
	foreach(trNode in m_fMatFile.m_trFileInfo.Children)
	{
		strRow = trNode.tagName +"\t"+ trNode.Size.strVal + "\t" + 
		            trNode.Type.strVal +"\t";
		if(trNode.Imported.nVal == 1)
		{
			strRow += "Yes";
		}
		else
		{
			strRow += "No";
		}
		
		m_vsFlex.AddItem( strRow );
	}
	
	m_vsFlex.ReDraw();
}


bool CMATFileImportDlg::ImportToMatrices(vector<uint>& vecIndex, StringArray& vStrName, vector<bool>& vbIsComplex)
{
	matrix mReal, mImaginary;
	
	for(int ii = 0; ii<vecIndex.GetSize(); ii++)
	{
		m_fMatFile.SetMatrix(vecIndex[ii], mReal, mImaginary);
		
		if(vbIsComplex[ii] == 0)
		{
			MatrixLayer mlay;
			get_Origin_matrix(vStrName[ii], mlay);
			
			Matrix<double> mat(mlay);
			mat = mReal;
		}
		else
		{
			MatrixLayer mlay_r, mlay_i;
			get_Origin_matrix(vStrName[ii]+"r", mlay_r);
			get_Origin_matrix(vStrName[ii]+"i", mlay_i);
			
			Matrix<double> matr(mlay_r), mati(mlay_i);
			matr = mReal;
			mati = mImaginary;
		}
	}
		
	return true;
}


// Import as matrices
BOOL CMATFileImportDlg::OnImportAsMatrices(Control ctrl)
{
	int nRowsSelected = m_vsFlex.SelectedRows();
	
	vector<uint> vecIndex(0);
	StringArray vStrName(0);
	vector<bool> vbIsComplex(0);
	for(int ii=0; ii<nRowsSelected; ii++)
	{
		LONG nR = m_vsFlex.SelectedRow(ii);
		
		string strName = m_vsFlex.GetCell( nR, MATLAB_OUTPUT_NAME_COL);
			
		TreeNode trNode = m_fMatFile.m_trFileInfo.GetNode(strName);
		if(trNode.Imported.nVal == 1)
		{
			vecIndex.Add(trNode.ID);
			vStrName.Add(trNode.tagName);
				if(trNode.Type.strVal.Compare("COMPLEX") != 0)
				vbIsComplex.Add(0);
			else
				vbIsComplex.Add(1);
		}
	}
			
	return ImportToMatrices(vecIndex, vStrName,vbIsComplex);
}
	
	
// Import real array to the worksheet
bool CMATFileImportDlg::ImportToWks(vector<uint>& vecIndex, StringArray& vStrName)
{
	
	bool bWksCreated = false;
		
	Worksheet wksTemp;
	if(m_bUpdateCols)
		wksTemp.Attach(MATLAB_WKS_NAME);
		
	if(!wksTemp.IsValid())
	{
		if(!wksTemp.Create())
		{
			return FALSE;
		}
		bWksCreated = true;
	}
	if(bWksCreated)
	{
		while(wksTemp.DeleteCol(0))	 // Remove all columns in worksheet
			;
	}
		
	int nNameCount = 0;
	
	matrix mReal, mImaginary;	
	for(int ii = 0; ii<vecIndex.GetSize(); ii++)
	{
		m_fMatFile.SetMatrix(vecIndex[ii], mReal, mImaginary);
		
		nNameCount += MatToWks(mReal, wksTemp, vStrName[ii]);
	}
		
	if(bWksCreated)
	{
		if(0==nNameCount)
			wksTemp.Destroy();
		else
			wksTemp.GetPage().Rename(MATLAB_WKS_NAME);
	}

	return nNameCount > 0? TRUE : FALSE;	
}


// Import as worksheet		
BOOL CMATFileImportDlg::OnImportAsSingleWks(Control ctrl)
{
	int nRowsSelected = m_vsFlex.SelectedRows();
	
	vector<uint> vecIndex(0);
	StringArray vStrName(0);
	for(int ii=0; ii<nRowsSelected; ii++)
	{
		LONG nR = m_vsFlex.SelectedRow(ii);
		
		string strName = m_vsFlex.GetCell( nR, MATLAB_OUTPUT_NAME_COL);
			
		TreeNode trNode = m_fMatFile.m_trFileInfo.GetNode(strName);
		if((trNode.Imported.nVal == 1)&&(trNode.Type.strVal.Compare("COMPLEX") != 0))
		{
			vecIndex.Add(trNode.ID);
			vStrName.Add(trNode.tagName);
		}
	}
			
	return ImportToWks(vecIndex, vStrName);
	
}


#endif //_CMAT_FILE_IMPORT_DLG_H