/*------------------------------------------------------------------------------*
 * File Name:LT_Wks.c		 													*
 * Creation: CPY July 9 2003													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 07-10-2003 v7.0622 QA70-4745 SET_PAGE_IMPORT_INFO_ON_123_ASC_IMPORT		*
 * EJP 08-28-2003 v7.5678 QA70-4818 UPDATE_ASCIMP_FROM_FILTER_SAVED_TO_WKS		*
 *------------------------------------------------------------------------------*/
 
#include <origin.h> // main Origin C header that is precompiled and already include most headers 
//TD 10-22-03 No longer needs this file
//#include "filter_utils.h" /// EJP 08-28-2003 v7.5678 QA70-4818 UPDATE_ASCIMP_FROM_FILTER_SAVED_TO_WKS

#define SHOW_ERR(_str)	out_str(_str)

/**
	Get header lines stored in worksheet page during ASCII import
	Parameters:
		None
	Returns:
		string with header contents
	Example:
		// get string into LabTalk variable header$
		// note the $ suffix at end of command - is needed to place value of
		// string returned by function into the LT var
		header$=pg_get_header()$ 		
*/
string pg_get_header()
{
	string strHeader;
	WorksheetPage wpg = Project.Pages();
	if(wpg)
	{
		vector<byte> vb;
		if(wpg.GetMemory("ImportHeader", vb))
		{
			strHeader.SetBytes(vb);
		}
		else
			SHOW_ERR("No header available in worksheet");			
	}
	else
		SHOW_ERR("Active window must be a worksheet");
	return strHeader;
}


/**
	Dump header lines stored in worksheet page during ASCII import
	Parameters:
		nOutput = where to dump the header, 1 for script window, 0 for new notes window
	Returns:
		None
	Example:
		pg_dump_header 1; 		
*/
void pg_dump_header(int nOutput = 0)
{
	string strHeader;
	strHeader = pg_get_header();
	if(0 != strHeader.GetLength())
	{
		if(0 == nOutput)
		{
			Note nWnd;
			nWnd.Create();
			nWnd.Text = strHeader;
		}
		else
			strHeader.Write(WRITE_SCRIPT_WINDOW);
	}
}


/**
	Get string value of specified infor storage variable
	Parameters:
		strVarName = Name of info varible in page.info.user.variables section
	Returns:
		string value of specified variable
	Example:
		// get string into LabTalk variable var$
		// note the $ suffix at end of command - is needed to place value of
		// string returned by function into the LT var
		var$=pg_get_info_str("L1V1")$ 		
*/
string pg_get_info_str(string strVarName)
{
	string strVarValue;
	WorksheetPage wpg = Project.Pages();
	if(wpg)
		page_get_info_var_value(wpg, strVarName, strVarValue);
	else
		SHOW_ERR("Page not valid");
	return strVarValue;
}


/**
	Get real value of specified infor storage variable
	Parameters:
		strVarName = Name of info varible in page.info.user.variables section
	Returns:
		double, value of specified variable
	Example:
		// get value of variable into LabTalk variable myval
		myval=pg_get_info_val("L1V1") 		
*/
double pg_get_info_val(string strVarName)
{
	double dVarValue = 0.;	
	WorksheetPage wpg = Project.Pages();
	if(wpg)
		page_get_info_var_value(wpg, strVarName, dVarValue);
	else
		SHOW_ERR("Page not valid");
	return dVarValue;
}


/// EJP 07-10-2003 v7.0622 QA70-4745 SET_PAGE_IMPORT_INFO_ON_123_ASC_IMPORT
void set_ascii_import_page_info(string lpcszFile)
{
	Page pgActive = Project.Pages();
	set_page_import_info(pgActive, lpcszFile, 0); // 0 = ASCII data type
}

void set_binary_import_page_info(string lpcszFile)
{
	Page pgActive = Project.Pages();
	set_page_import_info(pgActive, lpcszFile, 1); // 1 = Binary data type
}
/// end SET_PAGE_IMPORT_INFO_ON_123_ASC_IMPORT

/// EJP 08-28-2003 v7.5678 QA70-4818 UPDATE_ASCIMP_FROM_FILTER_SAVED_TO_WKS
/**
	Update an active worksheet's ASCII import settings.  A worksheet has internal settings and can also contain an ASCII import filter.
	Call this funtion to copy the settings from one to the other.
	Parameters:
		bUpdateInternal = 0 to update filter from internal settings, non-zero to update internal settings from filter.
	Returns:
		Zero for success or non-zero to indicate update did not occur.
	Example:
		Page pgActive = Project.Pages(); // get active page
		if( fuIsFilterInPage(pgActive, FILTER_TYPE_ASCII) ) // if page contains ASCII import filter
			pg_update_ascimp(1); // update the internal import settings from the import filter

int pg_update_ascimp(int bUpdateInternal)
{
	Page pgActive = Project.Pages();
	if( !pgActive || EXIST_WKS != pgActive.GetType() )
		return 1; // active page is not a wks
	
	Tree trFilter;
	if( !fuLoadFilterFromPage(trFilter, pgActive, FILTER_TYPE_ASCII) )
		return 1; // page does not have an ASCII filter

	Worksheet wks(pgActive.GetName());
	if( !wks )
		return 1; // failed to get reference to wks

	ASCIMP ascimp;
	if( bUpdateInternal ) // update internal settings from filter
	{
		if( !fuGetASCIMP(trFilter, ascimp) )
			return 1; // failed to get ASCIMP from filter
		wks.SetASCIMP(ascimp);
	}
	else // update filter from internal settings
	{
		wks.GetASCIMP(ascimp);
		fuSetASCIMP(trFilter, ascimp);
		fuSaveFilterToPage(trFilter, pgActive);
	}
	return 0; // ascimp updated
}
*/
/// end UPDATE_ASCIMP_FROM_FILTER_SAVED_TO_WKS

//----- CPY 10/26/03 QA70-3096 WKS_IMPORT_CHK_FILE_NAME_ALLOW_USE_ORIGINAL_WKS
static string getWksPageImportFilename(const WorksheetPage& wpg)
{
	string strTemp;
	string strStorageSection("System.IMPORT");
	Tree trSection;
	if( info_get_section(wpg, trSection, strStorageSection) )
	{
		string strVarName("FILEPATH");
		strVarName.MakeUpper();

		TreeNode trnVar;
		trnVar = trSection.GetNode(strVarName);
		if( trnVar )
			return trnVar.strVal;
	}
	return strTemp;
}
// check if if given filename already existed in a worksheet, if found, then make it the active window
// return 0 normally, but return 1 if user cancel
int check_wks_same_file_set_active(string strFilename)
{
	WorksheetPage wpg_this = Project.Pages();
	if(wpg_this)
	{
		string strFile = getWksPageImportFilename(wpg_this);
		if(strFile.CompareNoCase(strFilename) == 0)
			return 0; // nothing to do, already the correct file
	}
	int		nRet;	
	string str;
	string strMsg = _L("This file was already imported into another worksheet, do you want to use that worksheet instead?");
	
	foreach(WorksheetPage wpg in Project.WorksheetPages)
	{
		str = getWksPageImportFilename(wpg);
		if(str.CompareNoCase(strFilename) == 0)
		{
			string strTemp;
			nRet = MessageBox(GetWindow(), strMsg, "Origin Import", MB_YESNOCANCEL);
			if(IDCANCEL == nRet)
				return 1;
			if(IDNO == nRet)
				return 0;
			// Yes
			strTemp.Format("win -a %s", wpg.GetName());
			LT_execute(strTemp);
			return 0;
		}
	}
	return 0;
}
//----- end WKS_IMPORT_CHK_FILE_NAME_ALLOW_USE_ORIGINAL_WKS

