/*------------------------------------------------------------------------------*
 * File Name: filter_utils.h 													*
 * Creation: 																	*
 * Purpose:  functions for working with filters									*
 * Copyright (c)2003 OriginLab Corp.											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 07-07-2003 v7.0619 QA70-4783 POST_IMPORT_EXECUTE							*
 * EJP 07-17-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS							*
 * EJP 09-09-2003 v7.5689 QA70-4818 UPDATE_ASCIMP_FROM_FILTER_SAVED_TO_WKS		*
 * EJP 09-24-2003 v7.5706 QA70-4073.55 ADD_FILTER_DESCRIPTION					*
 *------------------------------------------------------------------------------*/

#ifndef _FILTER_UTILS_H
#define _FILTER_UTILS_H

#include "binimp.h"


#define	IMPORT_FILTER_EXTENSION					"oif"
#define	IMPORT_FILTER_EXTENSION_WILD			"*.oif"

#define IMPORT_FILTER_APPLICABILITY				"APPLICABILITY"

#define IMPORT_FILTER_PLOT_TEMPLATE				"PLOT_TEMPLATE"
#define IMPORT_FILTER_PLOT_ID					"PLOT_ID"
#define IMPORT_FILTER_BINARY					"BINARY"
#define IMPORT_FILTER_ASCIMP					"ASCIMP"
#define IMPORT_FILTER_BINIMP					"BINIMP"
#define IMPORT_FILTER_DESIGNATIONS				"DESIGNATIONS"
#define IMPORT_FILTER_FORMATS					"FORMATS"
#define	IMPORT_FILTER_REPETITIVE				"REPETITIVE"
#define	FILTERS_FOLDER_NAME						"Filters\\"

#define FILTER_ASCII_OCFILE			"OriginLab\\FileImport.c"
#define FILTER_ASCII_OCFUNCTION		"ImportASCII"

#define FILTER_BINARY_OCFILE		"OriginLab\\FileImport.c"
#define FILTER_BINARY_OCFUNCTION	"ImportBinary"

enum {
	FILTER_PATH_DATA = 0,
	FILTER_PATH_ORIGIN,
	FILTER_PATH_USER
};
#define IS_FILTER_PATH_ID(_i) (FILTER_PATH_DATA <= (_i) && (_i) <= FILTER_PATH_USER)
// TD 10-22-03 MOVED_TO_PAGE_UTILS_H	
//enum {
//	FILTER_TYPE_UNKNOWN = -1,
//	FILTER_TYPE_ASCII = 0,
//	FILTER_TYPE_BINARY,
//	FILTER_TYPE_USERDEFINED,
//	FILTER_TYPE_IGNORE = 100, // use with fuIsApplicable
//};
//#define IS_FILTER_TYPE(i)		(FILTER_TYPE_ASCII <= (i) && (i) <= FILTER_TYPE_USERDEFINED)

enum {
	FILTER_DDGRAPH_OPENONLY = 0,
	FILTER_DDGRAPH_PLOT,
	FILTER_DDGRAPH_PLOTSETTINGS
};
#define IS_FILTER_DDGRAPH(i) (FILTER_DDGRAPH_OPENONLY <= (i) && (i) <= FILTER_DDGRAPH_PLOTSETTINGS)

enum {
	FILTER_DDWORKSPACE_OPENONLY = 0,
	FILTER_DDWORKSPACE_PLOT_1LAYER,
	FILTER_DDWORKSPACE_PLOT_MULTILAYER,
	FILTER_DDWORKSPACE_PLOT_MULTIWINDOW
};
#define IS_FILTER_DDWORKSPACE(i) (FILTER_DDWORKSPACE_OPENONLY <= (i) && (i) <= FILTER_DDWORKSPACE_PLOT_MULTIWINDOW)

typedef int (*PFNIMPORTFUNC)(Page &pgTarget, TreeNode &trFilter, LPCSTR lpcszFile, int iFile);
PFNIMPORTFUNC fuGetImportFunctionPtr(TreeNode &trFilter);
bool fuGetUserDefinedFunction(TreeNode &trFilter, string &strOCFile, string &strOCFunction);
bool fuSetUserDefinedFunction(TreeNode &trFilter, LPCSTR lpcszOCFile, LPCSTR lpcszOCFunction);

int fuGetFilterType(TreeNode& trFilter);
bool fuGetFilterType(TreeNode &trFilter, string &strType);

BOOL fuIsRenameWks(TreeNode& trFilter);
	
/**
*/
int fuGetDragDropGraph(TreeNode& trFilter);
void fuSetDragDropGraph(TreeNode& trFilter, int iMode);

int fuGetDragDropWorkspace(TreeNode& trFilter);
void fuSetDragDropWorkspace(TreeNode& trFilter, int iMode);

int fuGetImportMode(TreeNode& trFilter);
void fuSetImportMode(TreeNode& trFilter, int iImportMode);

BOOL fuIsTargetPageType(TreeNode& trFilter, int iPageType);
int fuGetTargetPageType(TreeNode& trFilter);
Page fuCreateTargetPage(TreeNode& trFilter, int iOption = CREATE_VISIBLE);

BOOL fuSetTargetWindow(TreeNode& trFilter, int iType, LPCSTR lpcszTemplate = NULL);
BOOL fuGetTargetWindow(TreeNode& trFilter, int& iType, string& strTemplate);


/**
		Search for a filter that can handle the specified data file.
		If a filter is found then copy it's file name into the specified string.
		If more than one filter is found then prompt user to choose one.
	Example:
		string strData("c:\\mydata.txt");
		string strFilter;
		int n = fuGetFilterFile(strFilter, strData);
		if( n == 0 )
			printf("No filter is available for handling data file %s\n", strData);
		else if( n == 1 )
			printf("Filter %s is best for handling data file %s\n", strFilter, strData);
		else if( n > 1 )
			printf("There are %d filters that can handle data file %s\n", strData);
	Parameters:
		strFilter=string to receive the filter file name
		lpcszDataFile=pointer to the data file name
	Return:
		Returns 0 to indicate no filter file name was copied to strFilter.
		Returns 1 to indicate a filter file name was copied to strFilter.
		Returns a value greater than 1 to indicate multiple filters were found and user canceled
		when prompted to choose.
*/
int fuGetFilterFile(string &strFilter, LPCSTR lpcszDataFile);

/**
*/
void fuGetFilterFiles(StringArray& sarrFilterFiles, LPCSTR lpcszFolderPath, LPCSTR lpcszDataFile = NULL, int iFilterType = FILTER_TYPE_IGNORE);

/**
*/
void fuGetFilterFiles(StringArray &saFilterFiles, int iFilterType = FILTER_TYPE_IGNORE, LPCSTR lpcszDataFile = NULL);

/**
*/
void fuAppendFilterFiles(StringArray& sarrFilterFiles, LPCSTR lpcszFolderPath, LPCSTR lpcszDataFile = NULL, int iFilterType = FILTER_TYPE_IGNORE);

/**
*/
void fuGetFilterList(StringArray &saFilterList, StringArray &saFilterFiles);
BOOL fuGetFilterFileNameFromListItem(LPCSTR lpcszFilterListItem, String &strFileName, LPCSTR lpcszDataPath=NULL);

/**
		Search for a filter that can handle the specified data file.
		If a filter is found then load it into the specified tree node.
	Example:
		string strData("c:\\mydata.txt");
		Tree trFilter;
		int n = fuLoadFilterFile(trFilter, strData);
		if( n == 0 )
			printf("No filter is available for handling data file %s\n", strData);
		else if( n == 1 )
			printf("Filter %s is best for handling data file %s\n", strFilter, strData);
		else if( n > 1 )
			printf("There are %d filters that can handle data file %s\n", strData);
	Parameters:
		trFilter=tree node to load the filter into
		lpcszDataFile=pointer to the data file name
	Return:
		Returns 0 to indicate no filter file name was copied to strFilter.
		Returns 1 to indicate a filter file name was copied to strFilter.
		Returns a value greater than 1 to indicate multiple filters were found and user canceled
		when prompted to choose.
*/
int fuLoadFilterFile(TreeNode &trFilter, LPCSTR lpcszDataFile);

/**
*/
void fuPrepareDefault(TreeNode& trFilter);
/**
*/
void fuSetRepetitive(TreeNode& trFilter, BOOL bRepetitive);
/**
*/
BOOL fuGetRepetitive(TreeNode& trFilter);

/**
		Read a filter's ASCIMP node into an ASCIMP structure.
	Parameters:
		trFilter = source filter
		ascimp = target ASCIMP structure
		bGetCommonNode = TRUE to update structure's common settings from Common node
*/
BOOL fuGetASCIMP(TreeNode& trFilter, ASCIMP& ascimp, BOOL bGetCommonNode=FALSE);

/**
		Write an ASCIMP structure into the ASCIMP node of a filter.
	Parameters:
		trFilter = target filter
		ascimp = source ASCIMP structure
		bSetCommonNode = TRUE to also set the Common node
*/
void fuSetASCIMP(TreeNode& trFilter, ASCIMP& ascimp, BOOL bSetCommonNode=FALSE);

/**
		Read a filter's BINIMP node into an BINIMP structure.
	Parameters:
		trFilter = source filter
		binimp = target BINIMP structure
		bGetCommonNode = TRUE to update structure's common settings from Common node
*/
BOOL fuGetBINIMP(TreeNode& trFilter, BINIMP& binimp, BOOL bGetCommonNode=FALSE);

/**
		Write an BINIMP structure into the BINIMP node of a filter.
	Parameters:
		trFilter = target filter
		binimp = source BINIMP structure
		bSetCommonNode = TRUE to also set the Common node
*/
void fuSetBINIMP(TreeNode& trFilter, BINIMP& binimp, BOOL bSetCommonNode=FALSE);

/**
*/
void fuSetDesignations(TreeNode& trFilter, LPCSTR lpcszDesignations);
/**
*/
string fuGetDesignations(TreeNode& trFilter);
/**
*/
void fuSetFormats(TreeNode& trFilter, LPCSTR lpcszFormats);
/**
*/
string fuGetFormats(TreeNode& trFilter);
/**
*/
void fuSetApplicability(TreeNode& trFilter, LPCSTR lpcszApplicability);
/**
*/
string fuGetApplicability(TreeNode& trFilter);

/**
*/
BOOL fuIsApplicable(LPCSTR lpcszFilterFile, LPCSTR lpcszDataFile, int iFilterType=FILTER_TYPE_IGNORE);
BOOL fuIsApplicable(TreeNode &trFilter, LPCSTR lpcszDataFile, int iFilterType=FILTER_TYPE_IGNORE);

/**
*/
void fuSetPlotID(TreeNode& trFilter, int nPlotID);

/**
*/
int fuGetPlotID(TreeNode& trFilter);

/**
*/
void fuSetPlotTemplate(TreeNode& trFilter, LPCSTR lpcszTemplate);

/**
*/
string fuGetPlotTemplate(TreeNode& trFilter);



BOOL fuRemoveHeaderParams(TreeNode &trFilter);
bool fuGetHeaderParamDefined(TreeNode &trFilter, int &nVal);
void fuSetHeaderParamDefined(TreeNode &trFilter, int nVal);
TreeNode fuGetHeaderParams(TreeNode &trFilter);
bool fuGetHeaderParamNames(TreeNode &trFilter, StringArray &saNames);
int fuGetHeaderParamCount(TreeNode &trFilter);

TreeNode fuGetHeaderParam(TreeNode &trFilter, LPCSTR lpcszName);
bool fuGetHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int &nType, int &n1, int &n2, int &n3);
bool fuGetASCHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int &nType, int &nLine, int &nPos, int &nEnd);
bool fuGetBinHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int &nType, int &nOffset, int &nSize);

bool fuAddHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int nType=0, int n1=0, int n2=0, int n3=0);
bool fuAddASCHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int nType, int nLine, int nPos, int nEnd);
bool fuAddBinHeaderParam(TreeNode &trFilter, LPCSTR lpcszName, int nType, int nOffset, int nSize);

bool fuGetHdrVarScan(TreeNode &trFilter, int &iFirstLine, int &iLastLine, int &iSeparator);
bool fuSetHdrVarScan(TreeNode &trFilter, int iFirstLine, int iLastLine, int iSeparator);

bool fuGetHdrSave(TreeNode &trFilter, int &iFirstLine, int &iNumLines);
bool fuSetHdrSave(TreeNode &trFilter, int iFirstLine, int iNumLines);

bool fuGetFileSpec(TreeNode &trFilter, string &strFileSpec);
bool fuSetFileSpec(TreeNode &trFilter, LPCSTR lpcstrFileSpec);
bool fuGetFilesOfTypeGroupName(TreeNode &trFilter, string &strName);
bool fuSetFilesOfTypeGroupName(TreeNode &trFilter, LPCSTR lpcstrName);
bool fuGetFilesOfType(TreeNode &trFilter, StringArray &saFileSpecNames);
bool fuSetFilesOfType(TreeNode &trFilter, StringArray &saFileSpecNames);

BOOL fuIsFileNameToWksLabel(TreeNode &trFilter);
void fuSetFileNameToWksLabel(TreeNode &trFilter, BOOL bSet=TRUE);

/// EJP 07-07-2003 v7.0619 QA70-4783 POST_IMPORT_EXECUTE
bool fuGetPostImportScript(TreeNode &trFilter, string &strScript);
void fuSetPostImportScript(TreeNode &trFilter, LPCSTR lpcszScript);
/// end POST_IMPORT_EXECUTE

/// EJP 07-17-2003 v7.0627 QA70-4818 SAVE_FILTER_IN_WKS
bool fuSaveFilterToPage(TreeNode &trFilter, Page &pgTarget);
bool fuLoadFilterFromPage(TreeNode &trFilter, Page &pgTarget, int iType);
bool fuIsFilterInPage(Page &pgTarget, int iType, LPCSTR lpcszDataFile=NULL);
bool fuIsOneFilterInPage(Page &pgTarget, LPCSTR lpcszDataFile, int &iFilterType);
/// end SAVE_FILTER_IN_WKS

/// EJP 09-09-2003 v7.5689 QA70-4818 UPDATE_ASCIMP_FROM_FILTER_SAVED_TO_WKS
bool fuUpdatePageASCIMP(Page &pg, bool bUpdateInternal);
typedef bool (*PFNUPDATEPGASCIMP)(Page &pg, bool bUpdateInternal);
/// end UPDATE_ASCIMP_FROM_FILTER_SAVED_TO_WKS

bool fuSave(TreeNode &trFilter, LPCSTR lpcszFile);
bool fuLoad(TreeNode &trFilter, LPCSTR lpcszFile);

/// EJP 09-24-2003 v7.5706 QA70-4073.55 ADD_FILTER_DESCRIPTION
bool fuGetDescription(TreeNode &trFilter, string &strDescrip);
bool fuSetDescription(TreeNode &trFilter, LPCSTR lpcszDescrip);
/// end ADD_FILTER_DESCRIPTION

#endif // _FILTER_UTILS_H
