/*------------------------------------------------------------------------------*
 * File Name: FileImport.h				 										*
 * Purpose: Declare functions defined n FileImport.c							*
 * Copyright (c)2003 OriginLab Corp.											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 07-28-2003 v7.0637 QA70-4911 IMPROVE_HDR_VAR_SCAN						*
 * EJP 09-24-2003 v7.5706 QA70-5230 NOTIFY_USER_OF_IMPORT_ERROR					*
 *------------------------------------------------------------------------------*/

#ifndef _FILEIMPORT_H
#define _FILEIMPORT_H

#include <Tree.h>
#include <Page.h>

/// EJP 09-24-2003 v7.5706 QA70-5230 NOTIFY_USER_OF_IMPORT_ERROR
enum {
	IMPERR_NONE = 0,
	IMPERR_NO_FILTER,
	IMPERR_LOAD_FILTER,
	IMPERR_NO_TARGET_PAGE,
	IMPERR_GET_IMPORT_FUNC,
	IMPERR_IMPORT_FUNC_ERR,
	IMPERR_PREPARE_WKS,
	IMPERR_FILTER_TYPE,
	IMPERR_CANCEL_ON_LOCKED_COL,
};
/// end NOTIFY_USER_OF_IMPORT_ERROR

/// EJP 10-30-2003 v7.5736 QA70-5448 NOTIFY_USER_OF_IMPORT_ERROR
int ImportErrorMsgBox(int iErr, LPCSTR lpcszFilter=NULL);
/// end NOTIFY_USER_OF_IMPORT_ERROR

int ImportFile(Page &pgTarget, LPCSTR lpcszFilter, LPCSTR lpcszFile, int nFile=0);
int ImportFile(Page &pgTarget, TreeNode &trFilter, LPCSTR lpcszFile, int nFile=0);
int ImportASCII(Page &pgTarget, TreeNode &trFilter, LPCSTR lpcszFile, int iFile=0);
int ImportBinary(Page &pgTarget, TreeNode &trFilter, LPCSTR lpcszFile, int iFile=0);
int PrepareWksColsForImport(Page &pgTarget, TreeNode &trFilter, LPCSTR lpcszFile);

bool BatchProcessing();

/// EJP 07-28-2003 v7.0637 QA70-4911 IMPROVE_HDR_VAR_SCAN
void get_ascii_file_header_variables(StringArray &saNames, StringArray &saValues, LPCSTR lpcszFile, TreeNode &trFilter);
/// end IMPROVE_HDR_VAR_SCAN

#endif // _FILEIMPORT_H
