/*------------------------------------------------------------------------------*
 * File Name: Dlg_Utils.h														*
 * Creation: GJL 10/15/2002														*
 * Purpose: Header file for Dlg_Utils.c											*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#ifndef _DLG_UTILS_H
#define _DLG_UTILS_H

////////////////////////////////////////////////////////////////////////////////////
// Included header files
//////////////////////////////////////////////////////////////////////////////////
/*
#include <Dialog.h>         // Dialog class
#include <Tree.h>           // Tree class
#include <common.h>         // Basic data types
#include <mswin.h>          // WIN API functions
#include "Wks_Utils.h"      // Wks_Utils function prototypes and non-localized constants 
#include "App_Utils.h"      // App_Utils function prototypes and non-localized constants 
#include "Dlg_Utils.h"      // Dlg_Utils function prototypes and non-localized constants
*/
//////////////////////////////////////////////////////////////////////////////////
// Non-Localzed constants and literals used in Dlg_Utils.c
//////////////////////////////////////////////////////////////////////////////////
//
#define DLG_UTILS_NO_ERROR					0
#define DLG_UTILS_NO_FILES_FOUND_ERROR		100
#define DLG_UTILS_INVALID_TREENODE_ERROR	101
#define DLG_UTILS_INVALID_EBX_ERROR			102
#define DLG_UTILS_INVALID_LBX_ERROR			103
#define DLG_UTILS_NO_SINGLE_COL_ERROR		104

#define DLG_UTILS_FILE_WITH_PATH	0
#define DLG_UTILS_FILE_NO_PATH		1
#define DLG_UTILS_FILE_NO_EXT		2

//////////////////////////////////////////////////////////////////////////////////
// Prototypes of functions in Dlg_Utils.c
//////////////////////////////////////////////////////////////////////////////////
//

/**
		Get the current worksheet/workbook sheet selection as a list of non-contiguous
		ranges and populate the specified Dialog Builder list box with the list. The list
		box name and property must be specified but the function enumerates as needed. This
		function can be used with Dialog Builder list boxes, comboxes, and list controls.
	Example:
		string strMsg;
		// Populate Data Range list box, type out error if problem
		if( PopulateListBoxWithNonContiguousSelection( "StatisticsOn!Tab.Operation.DataLBX" ) )
		{
			strMsg = SO_WKS_DATA_SEL_ERROR_MSG;     // Output error message and return
			strMsg.Write( WRITE_MESSAGE_BOX );
			return FALSE;
		}
	Parameters:
		strListBoxName=Input name of Dialog Builder list box, combox, or list control
		strPropertyName=Input name of Dialog Builder property to set like ".V" or .V2_, default is ".V"
		bAppend=Input option to append new selected ranges in list box (TRUE) or to reset list box and
			populate starting in first row (default FALSE)
		bSelectAll=Input option to select entire worksheet/workbook sheet if there is no selection (TRUE)
			or to return a no selection warning code if there is no selection (default FALSE)
	Return:
		Returns DLG_UTILS_NO_ERROR on success and a DLG_UTILS warning or error code on failure.
*/
int PopulateListBoxWithNonContiguousSelection(LPCSTR strListBoxName, LPCSTR strPropertyName = NULL, BOOL bAppend = FALSE, 
	BOOL bSelectAll = FALSE);

/**
		Get the current worksheet/workbook sheet selection range and populate the specified
		Dialog Builder edit box with it. The selection range must be contiguous and the edit
		box name must be specified as an argument.
	Example:
		string strMsg;
		// Populate Weighting edit box, type out error if problem
		if( PopulateEditBoxWithContiguousSelection( "StatisticsOn!Tab.Operation.WeightingEBX" ) )
		{
			strMsg = SO_WKS_WEIGHT_SEL_ERROR_MSG; // Output error message and return
			strMsg.Write( WRITE_MESSAGE_BOX );
			return FALSE;
		}
	Parameters:
		strEditBoxName=Input name of Dialog Builder edit box
		bSelectAll=Input option to select entire worksheet/workbook sheet if there is no selection (TRUE)
			or to return a no selection warning code if there is no selection (default FALSE)
	Return:
		Returns DLG_UTILS_NO_ERROR on success and a DLG_UTILS warning or error code on failure.
*/
int PopulateEditBoxWithContiguousSelection(LPCSTR lpcstrEditBoxName, BOOL bSelectAll = FALSE);

/**
		Search a windows folder adding any files that match a specified file filter to a Dialog Builder
		list box. Options specify whether or not subfolders are to be recursively searched and whether
		or not the files are to be appended to or are to replace existing files in the list box. The list
		box name and property must be specified but the function enumerates as needed. This function can
		be used with Dialog Builder list boxes, comboxes, and list controls.
	Example:
		string strPath = GetAppPath() + "Filters\";
		PopulateListBoxWithFilenames( "AIW!Page.Source.Filters", ".V", FALSE, strPath, "*.oaf", 3 );
	Parameters:
		strListBoxName=Input name of Dialog Builder list box, combox, or list control
		strPropertyName=Input name of Dialog Builder property to set like ".V" or .V2_, default is ".V"
		bAppend=Input option to append new selected ranges in list box (TRUE) or to reset list box and
			populate starting in first row (default FALSE)
		strPath=Input path to start searching, default "" is path to Origin ini file  
		strFileFilter=Input file filter which may include DOS wild card characters, default is "*.*"
		bRecursive=Input option to recursively search subfolders, default is FALSE
		wDisplayOptions=Input bitwise flag specifying display options, default value DLG_UTILS_FILE_WITH_PATH
			displays path, filename and filetype, DLG_UTILS_FILE_NO_PATH displays filename and filetype without
			path, DLG_UTILS_FILE_NO_EXT displays path and filename with out filetype extension, and
			DLG_UTILS_FILE_NO_PATH | DLG_UTILS_FILE_NO_EXT displays file name without path or filetype extension
	Return:
		Returns DLG_UTILS_NO_ERROR on success and a DLG_UTILS warning or error code on failure.
*/
int PopulateListBoxWithFilenames(
	LPCSTR strListBoxName,
	LPCSTR strPropertyName = NULL,
	BOOL bAppend = FALSE, 
	LPCSTR strPath = NULL,
	LPCSTR strFileFilter = NULL,
	BOOL bRecursive = FALSE, UINT wDisplayOptions = DLG_UTILS_FILE_WITH_PATH);

/**
		Get the current worksheet/workbook sheet selection range and populate the specified
		Dialog Builder edit box with it. The selection range must be contained within a single
		worksheet/workbook column and the Dialog Builder edit box control must be passed by
		reference.
	Example:
		Edit ebxWeighting = dlgStatisticsOn.GetItem(IDC_SO_WEIGHT_EBX, IDD_SO_OP_TAB);
		// Populate Weighting edit box, type out error if problem
		if( PopulateEditBoxWithOneColumnRange(ebxWeighting) )
		{
			strMsg = SO_WKS_WEIGHT_SEL_ERROR_MSG; // Output error message and return
			strMsg.Write(WRITE_MESSAGE_BOX);
			return false;
		}
	Parameters:
		ebx=Input reference to Dialog Builder edit box
	Return:
		Returns DLG_UTILS_NO_ERROR on success and a DLG_UTILS warning or error code on failure.
*/
int PopulateEditBoxWithOneColumnRange(Edit& ebx);

/**
		Populate the specified list box with string values from each subnode of the 
		specified TreeNode.
	Example:
		See function call in StatisticsOn.c.
	Parameters:
		tr=Input TreeNode whose subnodes will be used to populate a list box
		bAppend=Input option to append string values from each subnode (true) or to
			reset list box and populate starting in first item (default false)
	Return:
		Returns DLG_UTILS_NO_ERROR on success.
*/
int PopulateListBoxFromTreeNode(ListBox& lbx, TreeNode& tr, bool bAppend = false);

#endif // _DLG_UTILS_H