/*------------------------------------------------------------------------------*
 * File Name: App_Utils.h														*
 * Creation: GJL 7/13/2001														*
 * Purpose: Header file for App_Utils.C											*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	 CPY 7/20/02 v7.0347 OSTAT_COMPILE_PROBLEM									*
 *------------------------------------------------------------------------------*/

#ifndef _APP_UTILS_H
#define _APP_UTILS_H


// Include definitions of all localized strings. $ causes CodeBuilder to look for 
// correct version of Local.h depending on Windows Regional settings.

//////////////////////////////////////////////////////////////////////////////////
// Function synonyms for backward compatibility...no longer using "au" function
// name prefix 
//////////////////////////////////////////////////////////////////////////////////
//
#define GetFilename GetFileName
#define auGetFilename GetFilename
#define auGetFilenameWithoutExt GetFilenameWithoutExt
#define auGetFilenamesInFolder GetFilenamesInFolder
#define auGetFileSize GetFileSize
#define auGetLayerNumbers GetLayerNumbers
#define auGetSystemFiles GetSystemFiles
#define auFindFiles FindFiles
#define auGetSystemFilePath GetSystemFilePath

//////////////////////////////////////////////////////////////////////////////////
// Non-Localzed constants and literals used in App_Utils.c
//////////////////////////////////////////////////////////////////////////////////
//
#define APP_UTILS_NO_ERROR_OUTPUT			-1
#define APP_UTILS_NO_ERROR					0
#define APP_UTILS_ERROR1					1
#define APP_UTILS_NO_FILES_FOUND_ERROR		2

#define APP_UTILS_BLANK_SPACE				" "
#define APP_UTILS_SEPARATOR					"---"

#define APP_UTILS_FILE_WITH_PATH			0
#define APP_UTILS_FILE_NO_PATH				1
#define APP_UTILS_FILE_NO_EXT				2

////////////////////////////////////////////////////////////////////////////////////
// Window related functions
////////////////////////////////////////////////////////////////////////////////////
//
/**
		Create new window using specified template, options, and enumerated base name.
	Example:
		// Create hidden matrix window with no GUI access allowed
		CreateWindow( "Origin.OTM", CREATE_HIDDEN | CREATE_NO_GUI_ACCESS );
	Parameters:
		strTemplateName=Input path and name of template to use, default is "Origin.OTW"
		iCreateOptions=Input create options as specified by bitwise CREATE_ constants in
			OC_const.h, default is CREATE_HIDDEN  
		strBaseWindowName=Input enumerated base name for created window, default "" automatically
			uses Origin default enumerated names like Data1, Data2, etc.
		bAlwaysEnumerate=Input flag specifying whether or not to enumerate strBaseWindowName
			if a window by that name does not already exist, default is TRUE 
	Return:
		Returns the name of the newly created window on success and returns "" on failure.  
*/
string CreateWindow( string strTemplateName = "Origin.OTW", int iCreateOptions = CREATE_HIDDEN,
	 string strBaseWindowName = "", BOOL bAlwaysEnumerate = TRUE );

////////////////////////////////////////////////////////////////////////////////////
// Output related functions
////////////////////////////////////////////////////////////////////////////////////
//
int Type_Separator( int nSeps );

int Type_ErrorMsg( string strErrMsg, int iDestination = WRITE_MESSAGE_BOX );

int Type_ErrorMsg1( string strErrMsg, string strErrMsgArg, int iDestination = WRITE_MESSAGE_BOX ); // CPY 7/20/02 v7.0347 OSTAT_COMPILE_PROBLEM

int Type_Insert_Blank_Lines_in_Wks( Worksheet &wksOutputWks, int iRow, int nRows = 1 );

int Type_Blank_Lines_To_Wks( Worksheet &wksOutputWks, int iRow = -1, int nRows = 1 );

int Type_Separator_Line_To_Wks( Worksheet &wksOutputWks, int iRow );

int	Set_Range_Of_Wks_Cells( Worksheet &wksOutputWks, string strOutputString = APP_UTILS_BLANK_SPACE,
	int iRow1 = -1, int iRow2 = -1, int jCol1 = -1, int jCol2 = -1 );

string LocalizeDouble( double dValueToLocalize, string strPrintfFormat = "%f" );

////////////////////////////////////////////////////////////////////////////////////
// GUI related functions
////////////////////////////////////////////////////////////////////////////////////
//
/**
		This function writes to the Data Display Window.
*/
void Write_Data_Display_Text( string strDataDisplayText );

////////////////////////////////////////////////////////////////////////////////////
// Matrix related functions
////////////////////////////////////////////////////////////////////////////////////
//
int OutputMatrix( matrix &InternalMatrix, string strMatrixName );

////////////////////////////////////////////////////////////////////////////////////
// Dataset related functions 
////////////////////////////////////////////////////////////////////////////////////
//
BOOL DatasetHasNonNumericValues( Dataset &dsTestData );

////////////////////////////////////////////////////////////////////////////////////
// Worksheet related functions
////////////////////////////////////////////////////////////////////////////////////
//
/**
		This function looks for duplicate X,Y pairs in the dataset. If duplciates are found,
		they are replaced with one X,Y pair with a Z value equal to that of the average of
		all duplicate points for that X,Y pair. This function sorts x,y,z data and then
		removes/replaces duplicates.
	Example:
	Parameters:
		wksData=name of worksheet with raw data
		colx=position of x column in data worksheet
		coly=pos of y col
		colz=pos of z col
		wksCopy=name of worksheet copy - x,y,z assumed to be in the first three cols
			method: method for replacing duplicates:
			0: replace with mean
			1: replace with max
			2: replace with min
	Return:
*/
int RemoveDuplicates( string wksData, int colx, int coly, int colz, string wksCopy );

////////////////////////////////////////////////////////////////////////////////////
// File related functions
////////////////////////////////////////////////////////////////////////////////////

/**
		Get the file extension from a string containing a filename. 
	Example:
		string strFile("c:\\somefolder\\myfile.txt");
		string strExt = GetFileExtension(strFile);
		ASSERT(0 == strExt.Compare("txt"));
	Parameters:
		lpcszFile=Input string containing a file name
	Return:
		Returns a string containing the file extension found in the input string.
		If the input string does not contain an extension then an empty string is returned.
*/
string GetFileExtension(LPCSTR lpcszFile);

/**
		Get the path and/or just filename without extension from a string containing a path and/or
		just filename. 
	Example:
		string strFilenameWithoutExt, strFilenameWithExt;
		strFilenameWithExt = "Default.oaf";
		strFilenameWithoutExt = GetFilenameWithoutExt( strFilenameWithExt );
		ASSERT( strFilenameWithoutExt.Compare( "Default" ) == 0 );
	Parameters:
		strFilenameWithExt=Input string containing an optional path and a filename with filetype extension
	Return:
		Returns a filename without filetype extension (but with path if in original string) from an optional
		path and filename with extension.
*/
string GetFilenameWithoutExt( string strPathAndFilename );

/**
		Search a windows folder adding any filenames that match a specified file filter to an output string.
		Options specify whether or not subfolders are to be recursively searched and whether or not path
		and file extension are to be included with file name.
	Example:
		string strTemplateFileList;
		GetFilenamesInFolder(strTemplateFileList, "", "*.otw", FALSE, 3);
	Parameters:
		strListOfFilenames=Output list of formatted filenames found in folder 
		lpcstrPath=Input path to start searching, default "" is path to Origin software folder  
		lpcstrFileFilter=Input file filter which may include DOS wild card characters, default is "*.*"
		bRecursive=Input option to recursively search subfolders, default is FALSE
		wDisplayOptions=Input bitwise flag specifying display options, default value APP_UTILS_FILE_WITH_PATH
			displays path, filename and filetype, APP_UTILS_FILE_NO_PATH displays filename and filetype without
			path, APP_UTILS_FILE_NO_EXT displays path and filename with out filetype extension, and
			APP_UTILS_FILE_NO_PATH | APP_UTILS_FILE_NO_EXT displays file name without path or filetype extension
	Return:
		Returns APP_UTILS_NO_ERROR on success or an APP_UTILS warning or error code on failure.
*/
int GetFilenamesInFolder(
	string& strListOfFilenames,
	LPCSTR lpcstrPath = "",
	LPCSTR lpcstrFileFilter = "",
	BOOL bRecursive = FALSE,
	UINT wDisplayOptions = APP_UTILS_FILE_WITH_PATH);

/**
		Get the file size of a file from an input string containing a path
		and filename.
	Example:
		string strFileSize, strDataFile = "C:\\Origin80\\Origin.ini";
		strFileSize = GetFileSize(strDataFile);
	Parameters:
		strPathAndFilename=Input string containing a path and filename with filetype extension
	Return:
		Returns a Windows like file size formatted for display. 
*/
string GetFileSize(string strPathAndFilename);

////////////////////////////////////////////////////////////////////////////////////
// Graph related functions
////////////////////////////////////////////////////////////////////////////////////
//
/**
		Builds a list of the layer numbers in the active graph. The list is returned
		as a series of tokens separated by the | character. The active layer number
		is also returned.
	Example:
		string str;
		int iActive;
		iActive = GetLayerNumbers(str);
	Return:
		Returns a list of the layer numbers in the active graph as a series of tokens
		separated by the | character. The layer number of the active layer is returned
		on success and -1 is returned on failure.
*/
int GetLayerNumbers(string& strLayerNumbers);

////////////////////////////////////////////////////////////////////////////////////
// File related functions
////////////////////////////////////////////////////////////////////////////////////
//
/**
	List all files of a specified file type found in the Origin
	App Data folder and/or in the Origin software folder. 
	
Example:
	int iRetCode;
	StringArray saResult;
	iRetCode = GetSystemFiles(saResult, "otw");
Parameters:
	saResult = the referrence of string array will receive the finding results
	lpcszExt = the file extension name to matach file finding.
Return:
	Returns TRUE for success, otherwise failure.
*/
BOOL GetSystemFiles(StringArray& saResult, LPCSTR lpcszExt);


/**
	Get the path of a specified Origin system file if it exists.
Example:
	int iRetCode;
	string strResult;
	iRetCode = GetSystemFilePath(strResult, "Origin.otw");
Parameters:
	strFilePath = the referrence of string to receive the file path name.
	lpcstrFileNameAndExt = the file name for file finding.lpcstrFileNameAndExt
Return:
	Returns TRUE for success, otherwise failure.
*/
BOOL GetSystemFilePath(string& strFilePath, LPCSTR lpcstrFileNameAndExt);

/**
	Get the contents of a text file.
Example:
	string strText;
	int iError = LoadTextFile(strText, "C:\\Origin80\\Origin.ini");
Parameters:
	lpcszFile=Input full path and file name to read
	iNumLines=Input number of lines to read not counting skipped lines, default 0 reads all lines (after iFirstLine) 
	iFirstLine=Input first line to read, default 0 reads first line
	iSkipLines=Input number of lines to skip for every one line read, default 0 skips no lines
Return:
	Returns the contents of a text file on success and "" on failure.  
*/
int LoadTextFile(string &strText, LPCSTR lpcszFile, uint iNumLines = 0, uint iFirstLine = 0, uint iSkipLines = 0);

/**
	Read specified lines from a text file into an array of strings.
Example:
	StringArray saLines;
	int iError = ReadFileLines(saLines, "C:\\Origin80\\Origin.ini");
Parameters:
	saLines=Reference to a string array that will hold the lines
	lpcszFile=Name of file to read
	iNumLines=Number of lines to read into the string array. If 0 then all lines are read.
	iFirstLine=Zero based index of the first line to read into the string array.
	iSkipLines=Number of lines to skip after every one line read.
Return:
	Returns zero for success or non-zero to indicate error.  
*/
int ReadFileLines(StringArray &saLines, LPCSTR lpcszFile, uint iNumLines=0, uint iFirstLine=0, uint iSkipLines=0);

////////////////////////////////////////////////////////////////////////////////////
// Error redirection functions
////////////////////////////////////////////////////////////////////////////////////
//

/**
	Get the LabTalk error redirection variable.
Example:
	See related function OutputErrorMessage in App_Utils.c.
Return:
	Returns the LabTalk error redirection variable which may have any of the following
	values:
		APP_UTILS_NO_ERROR_OUTPUT
		WRITE_SCRIPT_WINDOW
		WRITE_STATUS_BAR
		WRITE_OUTPUT_LOG
		WRITE_MESSAGE_BOX
		WRITE_COMPILER_OUTPUT
*/
int GetErrOut();

/**
	Output an error message redirected by the LabTalk error redirection variable.
Example:
	if(	PopulateTreeNodeWithNonContiguousSelection(trStat.Data) )
	{
		OutputErrorMessage(SOC_WKS_DATA_SEL_ERROR_MSG);
		return false;
	}
*/
void OutputErrorMessage(LPCSTR lpcszMessage);

/**
	Set the LabTalk error redirection variable.
Example:
	SetErrOut(WRITE_MESSAGE_BOX);
Parameters:
	iErrOut=Input LabTalk error redirection variable which may have any of the following
	values:
		APP_UTILS_NO_ERROR_OUTPUT
		WRITE_SCRIPT_WINDOW (default)
		WRITE_STATUS_BAR
		WRITE_OUTPUT_LOG
		WRITE_MESSAGE_BOX
		WRITE_COMPILER_OUTPUT
Return:
	Returns the previous value of the LabTalk error redirection variable.
*/
int SetErrOut(int iErrOut = WRITE_SCRIPT_WINDOW);

#endif //_APP_UTILS_H