#include	<windows.h>
#include 	<math.h>
#include	"..\..\include\FitFuncDef.h"

/*The function bellow is an example of two explanatory (independent) variables*/

/*The Nernst equation describes the relationship betwee the potential 
of a specific ion electrode and a chemical substance.
Reference:"Handbook of Nonlinear Regression Models", David A. Ratkowsky, 7.2.1

Equation:   y=a-b[log(x1+c) -log x2]
*/

int FAR PASCAL Nernst(FIT_PARA_LIST)
{
//parameters
#define a		p[1]
#define b		p[2]
#define c		p[3]
//explanatory variables
#define x1		x[1]
#define x2		x[2]

	if ( HAS_FUNC_DERIV )
	{
		return NONE;      ///we do not have analytical derivative in the implementation here
	}            

	if ( GET_FUNC_VALUE )
	{                          

		y[1] = a-b*(log(x1+c) -log (x2));

		if ( MATH_ERR )
		{
			RETURN_ERR;
		}
		return 0;
	}

	return 0;

#undef  a
#undef  b
#undef  c
#undef	x1
#undef	x2


}

/* The function bellow is an example where expressions for the partial derivatives
with respect to the parameters are provided; in this case the Origin NLSF 
will use these expressions (rather than using numerical differentiation)*/

/* Asymptotic Function 
Reference:"Handbook of Nonlinear Regression Models", David A. Ratkowsky, 4.3.2
Equation:		y = a-b*exp(-k*x)
Parameters:
a - asymptote as x->infinity; 
b - range of the response y between x=0 and x=infinity; 
k - rate at which y changes fro its initial value at x=0 to its final value a; k > 0
the curve describes growth (i.e.is increasing) when a > 0 & b > 0 - limited growth model  */


int FAR PASCAL Asymptotic2(FIT_PARA_LIST)
{
//parameters
#define	a		p[1]
#define	b		p[2]
#define	k		p[3]
//derivatives
#define	da		dy[1]
#define	db		dy[2]
#define	dk		dy[3]
//explanatory variable                     
#define xcol		x[1]
	//response
#define ycol		y[1]
		                 
	if ( HAS_FUNC_DERIV )
	{ 
		return YES;   //this will tell the NLSF that we provide expressions 
		              //for the derivative  -  see bellow
	}            
	if ( GET_FUNC_VALUE )
	{                          
		if ( k<=0.0 )
		{
			ycol = NANUM;
			return 1;
		}

		ycol = a - b*exp(-k*xcol);
		
		if ( MATH_ERR )
		{
			RETURN_ERR;
		}
		return 0;
	}                                     
	if ( GET_FUNC_DERIV )  
	{   
		if (k<=0.0 )
		{
			ycol = NANUM;
			da = NANUM;
			db = NANUM;
			dk = NANUM;
			return 1;
		}
		//expressions for the derivatives
		da = 1.0;
		db = -exp(-k*xcol);
		if ( MATH_ERR )
		{
			da = NANUM;
			db = NANUM;
			dk = NANUM;
			RETURN_ERR;
		}
		ycol = b*db;
		dk = -xcol*ycol;
		ycol += a;
		return 0;
	}

	return 0;

#undef	a
#undef	b               
#undef	k
#undef	da
#undef	db
#undef	dk

#undef xcol
#undef ycol

}


