// OriginServer.h : header file
//


#include "ORGDDE.h"

/////////////////////////////////////////////////////////////////////////////
// OriginServer

class OriginServer : public CObject
{
public:
	OriginServer();
	virtual ~OriginServer();

public:
	BOOL	IsServerRunning();
	BOOL	IsServerNotFound();
	BOOL	ConnectServer(HWND hWnd, LPCTSTR lpCmdLine);
	BOOL	IsFirstAttemptToConnect();
	BOOL	SendData(HANDLE hData, LPCTSTR lpcszItem, WORD wOriginDDEFormat);
	WORD	GetOriginDDEClipboardFormat() {return m_cfDataWksheet;}
	//IV 04/07/99 t3291 FINISH_MOVE_DDEDEMO_32BIT
	int    SendCommandString(LPCTSTR lpstrCommand);
	//end FINISH_MOVE_DDEDEMO_32BIT
	///------------------------- DDE window proc commands
	void	On_WM_DDE_ACK(HWND hWnd, WPARAM wParam, LPARAM lParam);
	void	On_WM_DDE_TERMINATE(HWND hWnd);
	void	On_WM_CLOSE(HWND hWnd);
	///--------------------------

private:
	BOOL	InitiateConnection();
	BOOL	StartNewServer(LPCTSTR lpCmdLine);
	BOOL	CheckInitiateConnection();

private:
	HWND	m_hwndClientDDE;  /// if not NULL, attemp must have been made before
	HWND	m_hwndServerDDE;
	/// DDE related
	WORD	m_wAckState;
	INT		m_nAckTimeOut;
	BOOL	m_bDataTransfer;
	WORD	m_cfDataWksheet;
	enum { INITIATE=1,ADVISE,UNADVISE,POKE,REQUEST,EXECUTE };

private:
	HANDLE	GetSavedServerProcess() {return m_pi.hProcess;}
	PROCESS_INFORMATION	m_pi;// if the server needed to be started by us, we should keep its info

};

/////////////////////////////////////////////////////////////////////////////
const char szcTopicName[] ="ORG";
const char szcAppName[] = "Origin";

