/*------------------------------------------------------------------------------*
 *	File Name: 	orgdll.h     													*
 *	Purpose:	Origin and DLL interface constants and other def   				*
 *   	Date:		1/1/92														* 
 *  	Copyright Microcal Software Inc. 1992-1995								*
 *	Modification log                                                        	*
 *		SB v3.77 add WCB_DATA_SET_NO_X  and WCB_DATA_CLEAN_TEMP_DATASET			*
 *		STH v3.78 4/4/95 FIND_INI written qcao added by sth						*
 *	CPY v3.781 add WCB_DATA_GET_RAW_VALUE										*
 *	CPY v3.781 copied over Dr. Cao's changes in /// QZCao v3.78, March,20,95	*
 *	CPY v3.781 copied over Dr. Cao's changes in /// QZCao v3.78, March 19, 95	*
 *	CPY v3.781 removed STH v3.78 4/4/95 FIND_INI, as it has already been added	*
 *		by Dr. Cao in March 20													*
 *	QZCao v3.782, 4/13/95, Added WCB_STATUS_MSG, it will replace				*
 *		WCB_DATA_MSG_STATUS eventually.											*
 *	CPY v3.782 add WCB_DATA_GET_COL_ID 4/14/95									*
 *	QZCao v3.782, 4/24/95 WCB_DATA_CHECK_RANGE2, similar to WCB_DATA_CHECK_RANGE*
 *		to be merged in the future.												*
 *	QZCao, v3.782, 4/24/95, added WCB_DATA_CREATE_DATA to create all types of 	*
 *		datasets																*
 * 	QZCao, V3.7841, 5/12/95, WCB_GET_DOUBLE_VALUE, get double value				* 
 *	QZCao, v3.8, 7/18/95, WCB_CAL_EXPRESSION, cal expression					*
 *	QZCao, v3.8, 7/20/95, add label to plot and type to script, WCB_ADD_LABEL,	*
 *		WCB_TYPE_SCRIPT															* 
 *	QZCao, v3.8, WCB_DATA_GET_XY_RANGE, get dataset both x & y range			*
 *	QZCao, v3.8, 7/21/95, del a variable, WCB_DEL_VARIABLE:						*
 *	CPY v3.8 INTERIM_MODATA 6/25/95, add SET_XY_VALUE as needed in MoData 		*
 *	CPY v3.8 WCB_DATA_CHECK_INC 8/3/95, check dataset instead of X dataset		*
 *	QZCao, v3.8, 8/14/95, get init path,	WCB_GET_INI_PATH					*
 *	QZCao, v3.8, 8/21/95, get window name and ptr WCB_GET_WIN_NAME & 			*
 *		WCB_GET_WIN_ID 															*
 *	QZCao, v3.8, 8/23/95, load a dll in origin standard way	WCB_LOAD_DLL:		*
 *  ML v3.821 8/30/95 ONE_DATASET_ONLY											*   
 *	jliu v3.83 	9/7/95, MATRIX_SET                                       		*
 *	QZCao, v3.83, 9/19/95, set modaless:WCB_SET_MODALESS						*
 *  ML v3.84 9/25/95 KILL_DATASET_TOGETHER_WITH_ITS_DEPENDENT                   *
 *	CPY v3.84 CPP_UPDATE, make this file includable in cpp files				*
 *  ML v3.840 10/13/95 WCB_GET_DLL_PATH                                         *
 *	QZCao, v3.85, 10/31/95, WCB_DLL_BALOON 										*
 *  ML v3.850 11/1/95 REMOVE_COMMENTS                                           *
 * QZCao, 11/6/95, v3.85, GET_X_COL_VAL_IN_PLOT									*
 *  ML v3.97 12/11/95 WCB_DATA_IS_TEXT_DATASET                                  *
 *  ML v3.970 12/11/95 TEXT_DATASET_VALUE                                       *
 *	DSB v3.980 12/15/95 TITLE_DEFS												*
 *  ML v3.980 1/4/96 MOMASK_IMPLEMENTATION                                      *
 *	CPY v3.98 VECTOR_ASSIGNMENT                                                 *
 *	CPY v3.98 1/15/96 EGO_MESSAGE                                               *
 *  ML v3.980 1/15/96 WCB_DATA_GET_COL_FROM_COLNAME								*
 *	CPY v3.98 1/16/95 EGO_MSG_CONSISTANT										*
 *  ML v3.980 1/17/96 WCB_WKS_GET_NUM_COLS										*
 *  ML 3.981 1/23/96 MOVED_FROM_MARK_H_TO_ORGDLL_H								*
 *  ML v3.981 1/23/96 WCB_DATA_GET_NUM_VALUE_AS_TEXT							*
 *  ML v4.00 1/25/96 TO_PROVIDE_COMMUNICATION_WITH_LABMASK						*
 *	CPY v4.01 2/13/96 MERGE_CONTOUR_3D_COLOR	                                *
 *	JL  v4.03 3/5/96  DEFINE_O_CALLBACK											*
 *	CPY v4.05 3/8/96 WCB_WKS_HANDLING											*
 *  ML v4.08 4/7/96 STORE_GAPSIZE_IN_MEMORY_OBJECT								*
 *	sth v4.08 4/8/96 DOUBLE_ANOVA_WKS											*
 *  ML v4.08 4/11/96 NAME_OF_SUBJECT_COLUMN_PLUS_ADDITIONAL_STILL_UNUSED_MEMBERS*
 *  ML v4.08 4/12/96 STORING_NAMES_OF_SUBJECT_AND_RESPONSE_COLUMNS				*
 *	ML v4.08 4/17/96 STORE_THE_NAME_OF_THE_SECOND_FACTOR_COLUMN					*
 *	EJP v4.08 04-19-96 WCB_GET_CTRL_HWND										*
 *	ML 4/20/96 ONE_WAY_MEMORY_OBJECT_FOR_ONEWAY_REPEATED_MEASUREMENT_PURPOSES 	*
 *	ML v4.09 4/26/96 MOVED_TO_PSDLL_H											*
 *	ML 5/1/96 GET_COLUMN_LABEL													*
 *	ML v4.090 5/3/96 VARIOUS_WORKSHEET_MANIPULATIONS 							*
 *	ML v4.090 5/17/96 CREATE_NEW_EMPTY_WORKSHEET								*
 *	ML v4.090 5/17/96 DESTROY_WORKSHEET											*
 *	ML v4.090 5/17/96 RANK_ONE_DATASET											*
 *	ML v4.090 5/19/96 VARIOUS_COLUMN_SETTINGS									*
 *	ML v4.090 5/19/96 CREATE_DATA_AND_PLOT										*
 *	sth v4.09 5/21/96 REMOVING_DOUBLE_EGO_CMD_DEFINITION						*
 *	ML v4.090 5/22/96 MORE_WORKSHEET_STUFF										*
 *  ML v4.090 5/23/96 CREATE_NON_EMPTY_WORKSHEET_ON_OPTION                      *
 *	ML v4.090 5/24/96 SET_COLUMN_NAME											*
 *  YN v4.090 5/28/96 SET_WKS_LABEL                                             *
 *	EJP v4.09 05-29-96 WNDBASED_UIM_OBJ_EVENTS, define WCB_EVENT_WNDBASED		*
 *	ML 6/3/96 SET_COLUMN_TYPE_AS												*
 *	CPY v4.10 6/10/96 WKS_DLL_MODIFICATION_SUPPORT								*
 *  YN  v4.10 6/14/96  ADD_GetColumnWidth_FUNCTIONS                             *
 *	ML v4.10 6/18/96 GET_COLUMN_TYPE											*
 *	ML v4.11 7/1/96 MOVED_FROM_COMMON_H_TO_ORGDLL_H_SO_THAT_STSDLL_CAN_ACCESS_IT*
 *	ML v4.11 7/1/96 SHOW_WORKSHEET_NAME_LABEL_OR_BOTH							*
 *	ML v4.11 7/8/96 CHANGE_OFFSET (only comment changes)						*
 *	CPY v4.133 8/29/96 WCB_FRAME_ACCESS											*
 *	ML v4.133 8/30/96 FRAME_AND_MEMORY_OBJECT_ACCESS							*
 *	ML v4.133 9/5/96 CREATE_NEW_GRAPH											*
 *	ML v4.133 9/5/96 CREATE_ONE_TEMPORARY_SERIES								*
 *	ML v4.133 9/6/96 PLOT_TYPES_AND_STRUCTURE									*
 *	CPY v4.133 9/9/96 CREATE_TEXT_LABEL											*
 *	ML v4.133 9/24/96 EXE_CALLING_DLL_FOR_GRAPH									*
 *	ML v4.133 9/27/96 IDS_OF_BASIC_POWERSTAT_METHODS							*
 *	ML v4.133 9/27/96 WCB_POWERSTAT_GET_TEMPLATE_PATHS							*
 *  YN  11/18/96  ADD_CONDITIONAL_COMPILATION									*
 *	ANU v4.14 12/23/96 SETCOLUMNTITLE, new public function in Mowks class		*
 *	CPY v4.97 3/11/97 TEST_CELL_NUMERIC_OR_NOT									*
 *	ANU	v4.97 03/19/97 MOVE_DISK_OBJ_TO_UIM										*
 *	ANU v4.979 4/25/97 CREATE_OBJ												*
 *  JLIU nad DSC v4.982 5/7/97 MOVE_FROM_ORGDLL_TO_MODLL for the ati dll		*
 *	sth v4.982 b2083 5/7/97 RIGHT_MOUSE_DOWN_CODE_BLOCK							*
 *	ANU v4.983 5/9/97 CREATE_OBJ_STRUCT_MEMORY									*
 *	YL CPY v4.983 5/9/97 ADD_SET_LABEL_FROM_ID									*
 *  YN v4.986 5/16/97 CHECK_USING_SYSTEM_VARIABLES_IN_NLSF						*
 *	HYYU v4.997 t2341 DISABLE_OR_ENABLE_LABEL_WORKSHEET_EDIT					*
 *	CPY v4.9994 b2800 7/23/97 LAYER_NUMBER_ACCESS_FROM_WCB						*
 *	HYYU v4.9994 t1462 CHANGE_NUMERIC_FORMAT_FROM_WCB							*
 *	CPY v4.9994 b2837 7/24/97 SIMULATE_USE_SEPARATE_WKS							*	
 *	CPY v5.002 7/30/97 b2869 X_RANGE_FOR_X_DATASET								*
 *	CPY v5.004 8/4/97 t2897 FDLOG_SETDEFAULT_MUST_ALWAYS_SET_PATH				*
 *	CPY v5.005 8/5/97 FITTER_HELP_TO_GENERAL_CONTENTS							*
 *	CPY v5.028 11/24/97 b3252 STAT_NAME_COUNT_INDEP_DATASET						*
 *	CPY v5.036 1/22/98 t3479 MODATA_SET_RANGE_CHANGE							*
 *	CPY v5.039 b3558 REALTIME_DRAW_BUFFERRING									*
 *	ML 3/23/98 OK_NEW_COLORMAP_FOR_CONTOUR										*
 *	ML 7/20/98 SCRIPT_RESOURCE_DLL_DIALOGS										*
 *	RB 9/15/98 v6.0129 t4194 FFT_EXPONENT_SIGN_CHOICE							*
 *	GCJ 11/6/98 t4423 v6.0136 WRONG_STEREO_WAVEFILE_IMPORT						*
 *	CPY v6.0142 t4628 12/7/98 READ_ONLY_LAYER									*
 *	DVT 3/1/99 v6.0169 t5373 AVAILABLE_SERIES_FROM_CUR_FOLDER					*
 *	GCJ 3/4/99 t5510 v6.0169 ENUMERATE_WORKSHEET_PROPERTY						*
 *	ML 4/19/99 t4345 ADDING_SUPPORT_FOR_SCRIPT_BASED_RESOURCE_DLLS				*
 *	CPY v6.0187 4/22/99 OPP_SCOPE_MODE											*
 *------------------------------------------------------------------------------*/      

#ifndef _ORGDLL_H

#define	_ORGDLL_H

#ifdef	__cplusplus
extern "C" {
#endif
   

#ifndef	NAME_SIZE
#define MAXLINE		80
#define NAME_SIZE	25
#endif    //NAME_SIZE
///ANU v4.983 5/9/97 CREATE_OBJ_STRUCT_MEMORY
#define SNAME_SIZE		NAME_SIZE
#ifndef WKS_NAME_SIZE
	#define WKS_NAME_SIZE	12
#endif // WKS_NAME_SIZE
///

#ifndef USHORT
#define	ULONG		DWORD
#define	USHORT		WORD
#endif

/// CPY v3.74
#ifndef	X_AXIS
	#define	X_AXIS	0x0002
	#define	Y_AXIS	0x0004
#endif


#ifndef	NANUM	/* the missing value */
#define	NANUM		(-1.23456789E-300)
#endif

/// JL  v4.03 3/5/96  DEFINE_O_CALLBACK	 consistence with ScriptCallBack in ToolBar.c
typedef DWORD (CALLBACK*      O_CALLBACK)(HWND,UINT,WPARAM,LPARAM);
///


/* 
 * Messages sent to Origin to get access
 * to Origin's data
 * 
 */

#define	WM_DLL_BEGIN		(WM_USER+100)

#define WM_DLL_OPEN_DATA	(WM_DLL_BEGIN+ 1)
	/* return FAR pointer to beginning of data
	 * double only
	 */
	 
#define	WM_DLL_GET_RANGE		(WM_DLL_BEGIN + 2)
	/* return in LoWord the beginning index and
	 * in HiWord the end index.
	 * These are C type index so they start from
	 * zero and end at the next element. 
	 * LabTalk index starts at 1 and end at the
	 * end element.
	 */

#define	WM_DLL_GET_RANGE_EXT		(WM_DLL_BEGIN + 3)

#define	WM_DLL_GET_SIZE			(WM_DLL_BEGIN + 4)
	/* return data element size in loword
	 * 8 = double, 4 = float
	 * hiword is non zero if not real numbers 
	 */
	 
#define WM_DLL_CLOSE_DATA		(WM_DLL_BEGIN + 11)
	/* close the data set specified by the string
	 * pointed to by lParam.
	 * Update the data if wParam == 1.
	 */

#define	WM_DLL_OPEN_MATRIX		(WM_DLL_BEGIN + 13)
	/* similar to OPEN_DATA but also
	 * setup a matrix for DLL control
	 * return FAR pointer to beginning of matrix
	 * data array.
	 * lParam = (LPSTR)matrix_name
	 */
	 
#define	WM_DLL_CLOSE_MATRIX		(WM_DLL_BEGIN + 18)
	
#define	WM_DLL_OPEN_WKSHEET		(WM_DLL_BEGIN + 20)
	/* worksheet name in lParam
	 * wParam = 0
	 */
///HYYU v4.997 t2341 DISABLE_OR_ENABLE_LABEL_WORKSHEET_EDIT	
#define WM_DLL_UPDATEEDIT_WKSHEET	(WM_DLL_BEGIN + 21)
	/* worksheet name in lParam
	 * wParam is the value of worksheet editable
	 */
///end DISABLE_OR_ENABLE_LABEL_WORKSHEET_EDIT 

#define	WM_DLL_WKS_COL_NAME		(WM_DLL_BEGIN + 22)
	/* get name of column specified by wParam
	 * lParam must point to a buffer to receive the
	 * the name, which has a maximum size of NAME_SIZE
	 */

#define	WM_DLL_MATRIX_GET_DIM		(WM_DLL_BEGIN + 24)
	/* get Ncols x Nrows of the opened matrix
	 * reutrn MAKELONG(nCols,nRows)
	 */

#define	WM_DLL_MATRIX_GET_XY		(WM_DLL_BEGIN + 25)
	/* get matrix X and Y boundaries
	 * wParam is ingored and must be set to zero
	 * lParam is LPDOUBLE to x1,y1,x2,y2
	 */
	 
#define	WM_DLL_WKS_OPEN_COL		(WM_DLL_BEGIN + 26)
	/* Similar to WM_DLL_OPEN_DATA
	 * If lParam == NULL opens the column specified
	 * by wParam (1,2,3..)
	 * If lParam != NULL, opens the column 
	 * specified by the string in lParam, which
	 * can be either the name of the column or
	 * the numeric string for the column number.
	 */
	 
#define	WM_DLL_WKS_CLOSE_COL	(WM_DLL_BEGIN + 27)
	/* Similar to WM_DLL_CLOSE_DATA
	 * The interpretation of lParam is the same
	 * as WM_DLL_WKS_OPEN_COL, but only the
	 * LOBYTE of wParam is used for column number
	 * if lParam == NULL.
	 * the HIBYTE is used to indicate updating of the
	 * column.
	 */
#define	WM_DLL_WKS_SETRANGE		(WM_DLL_BEGIN + 30)
	/* MAKELONG(i,i2) as lParam */

#define	WM_DLL_WKS_PUT_DATA		(WM_DLL_BEGIN + 32)
	/* use the DataWorksheet format to set worksheet data
	 * lParam == LP to DataWorksheet structure
	 * wParam is ignored and must set to zero
	 */
	 
#define	WM_DLL_PASTE_ASCII		(WM_DLL_BEGIN + 35)

#define	WM_DLL_WKS_SET_ROW		(WM_DLL_BEGIN + 40)
	/* set current row, this is for accessing the worksheet
	 * row by row.
	 * row number is in wParam, lParam must be NULL
	 */

#define	WM_DLL_WKS_GET_CELL		(WM_DLL_BEGIN + 42)
	/* get cell content in the current row and the
	 * specified column (wParam)
	 * lParam must point to a buffer to receive the
	 * the content, which has a maximum size of MAXLINE
	 */

#define	WM_DLL_WKS_CREATE_OBJ	(WM_DLL_BEGIN + 44)
	/* create a memory object in the open worksheet
	 * with a name and specified size.
	 * lParam = LPSTR to the name of the obj, must be less than 8 chars
	 * wParam = intended size of the object.
	 *
	 * returns 1 if error, 0 if obj is created.
	 * obj must be open before use and close after use
	 */

/// CPY 4/12/94 v3.31
#define	WM_DLL_CREATE_OBJ	WM_DLL_WKS_CREATE_OBJ
#define	WM_DLL_OPEN_OBJ	WM_DLL_WKS_OPEN_OBJ
#define	WM_DLL_CLOSE_OBJ	WM_DLL_WKS_CLOSE_OBJ

#define	WM_DLL_WKS_OPEN_OBJ		(WM_DLL_BEGIN + 45)
	/* open the named obj, 
	 * lParam = LPSTR to the obj's name.
	 * wParam = required size of the obj, if the obj
	 * has a smaller size, it is increased to the specified size
	 *
	 * returns LPSTR to the obj's data buffer
	 * or return NULL if the obj does not exist
	 */
	 
#define	WM_DLL_WKS_CLOSE_OBJ	(WM_DLL_BEGIN + 46)
	/* close the currently open obj, lParam and wParam
	 * are both ignored
	 */

#define	WM_DLL_WKS_SET_DIM_EXT		(WM_DLL_BEGIN + 47)
	/* lParam is LPLONG to nCols and nRows */

#define	WM_DLL_WKS_GET_DIM		(WM_DLL_BEGIN + 48)
	/* get Ncols x Nrows of the opened worksheet
	 * nRows is the size of a column, which is
	 * greater or equal
	 * reutrn MAKELONG(nCols,nRows)
	 */
#define	WM_DLL_WKS_GET_DIM_EXT		(WM_DLL_BEGIN + 49)
	/* same but use LPLONG to return the dim
	 * return 0 if OK 1 if err
	 */

#define	WM_DLL_CLOSE_WKSHEET	(WM_DLL_BEGIN + 50)
	/* close the currently open worksheet
	 * All open columns are closed by this message.
	 * Updating is indicated by the wParam, while
	 * the lParam is ignored.
	 */

#define	WM_DLL_OPEN_LAYER		(WM_DLL_BEGIN + 60)
	/* PlotWindow name in lParam, NULL if current plot
	 * layer numer in wParam, 0 if current layer
	 */

#define	WM_DLL_CLOSE_LAYER		(WM_DLL_BEGIN + 90)
	/* Updating is indicated by the wParam, while
	 * the lParam is ignored.
	 */  

///jliu 9/7/95 MATRIX_SET
#define	WM_DLL_MATRIX_SET_DIM		(WM_DLL_BEGIN + 95)
	/* set Ncols x Nrows of the opened matrix
	 * reutrn MAKELONG(nCols,nRows)
	 */

#define	WM_DLL_MATRIX_SET_XY		(WM_DLL_BEGIN + 96)
	/* set matrix X and Y boundaries
	 * wParam is ingored and must be set to zero
	 * lParam is LPDOUBLE to x1,y1,x2,y2
	 */
///MATRIX_SET	 	 

#define	WM_DLL_SET_VARIABLE			(WM_DLL_BEGIN + 190)
#define	WM_DLL_GET_VARIABLE			(WM_DLL_BEGIN + 191)
	/* set or get one variable in Origin
	 * wParam ignored.
	 * lParam is LP to the following structurn */
typedef	struct	VARSETGET {
	double	value;
	char	name[NAME_SIZE];
}VARSETGET, FAR *LPVARSETGET;
	 /* return 1 if WM_GET_VARIABLE does not
	  * exist, WM_SET_VARIABLE always return zero
	  * variable name must be all upper case
	  */

#define	WM_DLL_SET_STRING			(WM_DLL_BEGIN + 194)
#define	WM_DLL_GET_STRING			(WM_DLL_BEGIN + 196)
	/* set or get one string variable in Origin
	 * wParam = 0,1,2,.. for %A,%B, %C.
	 * lParam is LPSTR to to set or get the string variable
	 * return 1 if OK, return 0 if error
	 */
	  
	  
	  
#define	WM_DLL_GETINITFILENAME	(WM_DLL_BEGIN + 200)

#define	WM_DLL_GET_MEMORY		(WM_DLL_BEGIN + 210)


/// ML 3/23/98 OK_NEW_COLORMAP_FOR_CONTOUR 
#define	WM_DLL_GET_COLORMAP_CLBCK		(WM_DLL_BEGIN + 230)
/// end OK_NEW_COLORMAP_FOR_CONTOUR 


#define	WM_DLL_NOTIFY			(WM_DLL_BEGIN+ 295)
/* message to the nofify function
 *
 * DWORD FAR PASCAL Notify(hWnd,wMsg,wParam,lParam)
 *
 * This function must be exported with the name "NOTIFY"
 */

///HYYU v4.9994 t1462 CHANGE_NUMERIC_FORMAT_FROM_WCB
#define WM_DLL_CHANGENUMFORMAT	(WM_DLL_BEGIN+ 296)
///end CHANGE_NUMERIC_FORMAT_FROM_WCB


#define	NOTIFY_GET_MSG_ID		0
	/* must return the registered WM message id
	 * wParam and lParam are both zeros
	 */
#define	NOTIFY_NOTIFY			1
	/* wParam and lParam are valid values */ 


#define	WM_DLL_SETUP			(WM_DLL_BEGIN+ 298) ///CPY v4.01 2/13/96 MERGE_CONTOUR_3D_COLOR
#define	WM_DLL_CLEAN_UP			(WM_DLL_BEGIN+ 299)
#define WM_DLL_END		(WM_DLL_BEGIN+ 300)


/* internal ids, these ids may be in conflict with
 * other WM_ ids, but they are sent only internally
 */
#define	DDM_TEST_ID			0
#define	DDM_SET_NOTIFY		1	/* in lparam */

/* use this to test whether id is within range */ 


/* To support LabEngine, there must a function
 * with the following ordinal number
 */
#define	ID_DLL_SET_CALLBACK	9999


/* function prototype within Origin for extern DLL messages */
ULONG	do_DLL_message(HWND, USHORT, USHORT, ULONG);



/***********************************************************
 * The struct and msg defined below are implemented for
 * Data Acquisition purpose, but is generally available.
 * A DLL can use a callback function instead of SendMessage
 * to communicate with Origin, and is thus much faster.
 * To use this mechanizm, the DLL must be decleared through
 * the ORIGIN.EXT file and the DLL is invoked directly through
 * the command defined in origin.ext, for example, a LabData.DLL
 * can be defined as the command DAS as follows:
 * 
 * das labdata
 *
 * in a line in Origin.ext file
 *
 * The DLL function must be defined as
 * int FAR PASCAL LabData(HWND,LPSTR,LPCALLBK);
 *
 * please note that one can continue to use the SendMessage 
 * mechanism to communicate with Origin
 *
 ***********************************************************/

typedef	ULONG	(FAR PASCAL *LPCALLBK)(HWND,USHORT,LPSTR,LPSTR);

/* WCB_* messages must all be bigger than WM_DLL_END which is 1424
 * and smaller then WM_DLL_BEGIN which is 1124
 */
#define	MASK_WCB_TYPE			0xF000
#define	MASK_WCB_NO_HWND		0x1000///
#define	MASK_WCB_OPTION_HWND	0x2000///


#define	MASK_DATASET			0x3000///
#define	MASK_DATASET_SERIES		0x0400

#define	MASK_FIT				0x4000///

#define	MASK_NEED_DRAW			0x5000///
#define	MASK_DRAWING_MODE		0x0400 // share DATA_SERIES 
	// must in between _BEGIN and _END
#define	MASK_DRAWING_OPTN_COOR	0x0800

#define	MASK_WCB_WKS			0x6000///CPY v4.05 3/8/96 WCB_WKS_HANDLING
#define	MASK_PKFIT				0x8000///
	///CPY v4.133 8/29/96 WCB_FRAME_ACCESS
#ifdef WCB_FRAME_ACCESS
	#define MASK_FRAME			0x9000
#endif ///WCB_FRAME_ACCESS
///
		
/*********************************************************
 * the callback function takes the following command id
 * as the wParam argument
 *********************************************************/
 
#define	WCB_SCRIPT_MSG		MASK_WCB_NO_HWND
#define	WCB_SET_VAR		(MASK_WCB_NO_HWND+1)
#define	WCB_GET_VAR		(MASK_WCB_NO_HWND+2)
#define	WCB_GET_HWND		(MASK_WCB_NO_HWND+3)

#define	WCB_EXECUTE		(MASK_WCB_NO_HWND+4)

#define	WCB_TEST		(MASK_WCB_NO_HWND+5)
#define	WCB_SET_INDEX		(MASK_WCB_NO_HWND+6)
#define	WCB_SET_TIME		(MASK_WCB_NO_HWND+7)
#define	WCB_GET_VALUE		(MASK_WCB_NO_HWND+8)

#define WCB_GET_OBJ		(MASK_WCB_NO_HWND+9)

#define	WCB_SET_DATASET		(MASK_WCB_NO_HWND+10)
#define	WCB_GET_DATASET		(MASK_WCB_NO_HWND+11)

#define	WCB_SET_STRING		(MASK_WCB_NO_HWND+12)
/// QZC 4/10/94
#define	WCB_GET_STRING		(MASK_WCB_NO_HWND+18)

#define	WCB_TYPE_ASCII		(MASK_WCB_NO_HWND+13)
#define	WCB_CVT_ASCII		(MASK_WCB_NO_HWND+14)

#define	WCB_GET_BUFFER		(MASK_WCB_NO_HWND+15)

#define	WCB_GET_PATH		(MASK_WCB_NO_HWND+16)

#define	WCB_GET_PROCESS_FN	(MASK_WCB_NO_HWND+17)

#define	WCB_GET_INIT_TIME	(MASK_WCB_NO_HWND+19)

/// QZCao v3.78, March,20,95
#define	WCB_NEXT_TERM		(MASK_WCB_NO_HWND+20)
#define	WCB_ARG_COPY		(MASK_WCB_NO_HWND+21)
#define	WCB_SET_PLOT_TITLE	(MASK_WCB_NO_HWND+22)
#define	WCB_OPEN_MC_FILE	(MASK_WCB_NO_HWND+23)
#define	WCB_SHOW_I		(MASK_WCB_NO_HWND+24)
#define	WCB_GET_INIT_FILE	(MASK_WCB_NO_HWND+25)
#define	WCB_ADD_VARIABLE	(MASK_WCB_NO_HWND+26)
///

/// QZCao v3.782, 4/13/95
#define	WCB_STATUS_MSG		(MASK_WCB_NO_HWND+27)
///

/// QZCao, V3.7841, 5/12/95, WCB_GET_DOUBLE_VALUE, get double value 
#define	WCB_GET_DOUBLE_VALUE	(MASK_WCB_NO_HWND+28)
///

/// QZCao, v3.8, cal expression
#define	WCB_CAL_EXPRESSION	(MASK_WCB_NO_HWND+29)
///

/// QZCao, v3.8, 7/20/95, add label to plot and type to script
#define	WCB_ADD_LABEL		(MASK_WCB_NO_HWND+30)
#define	WCB_TYPE_SCRIPT		(MASK_WCB_NO_HWND+31)
///

/// QZCao, v3.8, 7/21/95, del a variable
#define	WCB_DEL_VARIABLE	(MASK_WCB_NO_HWND+32)

/// QZCao, v3.8, 8/14/95, get init path
#define	WCB_GET_INI_PATH	(MASK_WCB_NO_HWND+33)

/// QZCao, v3.8, 8/21/95, get window name and ptr
#define	WCB_GET_WIN_NAME	(MASK_WCB_NO_HWND+34)
#define	WCB_GET_WIN_ID		(MASK_WCB_NO_HWND+35)
///

/// QZCao, v3.8, 8/23/95, load a dll in origin standard way
#define	WCB_LOAD_DLL		(MASK_WCB_NO_HWND+36)
///

/// QZCao, v3.83, 9/19/95, set modaless
#define	WCB_SET_MODALESS	(MASK_WCB_NO_HWND+37)
///
/// ML v3.840 10/13/95 WCB_GET_DLL_PATH
#define	WCB_GET_DLL_PATH		(MASK_WCB_NO_HWND+38)
/// end 10/13/95 WCB_GET_DLL_PATH

///	QZCao, v3.85, 10/31/95, WCB_DLL_BALOON
#define	WCB_DLL_BALOON		(MASK_WCB_NO_HWND+39)
///                        
/// ML v3.850 11/1/95 REMOVE_COMMENTS
#define	WCB_STRIP_COMMENTS		(MASK_WCB_NO_HWND + 40)	
/// end REMOVE_COMMENTS

/// EJP v4.08 04-19-96 WCB_GET_CTRL_HWND
/// callback msg to get a window handle for a window based UIM object.
#define WCB_GET_CTRL_HWND		(MASK_WCB_NO_HWND + 41)
/// end WCB_GET_CTRL_HWND

/// EJP v4.09 05-29-96 WNDBASED_UIM_OBJ_EVENTS
///	callback msg to process script associated with WndBased UIM object events.
#ifdef WNDBASED_UIM_OBJ_EVENTS
	#define WCB_WNDBASED_EVENT				(MASK_WCB_NO_HWND + 42)
#endif // WNDBASED_UIM_OBJ_EVENTS
/// end WNDBASED_UIM_OBJ_EVENTS
/// ML v4.133 9/27/96 WCB_POWERSTAT_GET_TEMPLATE_PATHS
#define	WCB_POWERSTAT_GET_TEMPLATE_PATHS	(MASK_WCB_NO_HWND + 43)
/// end WCB_POWERSTAT_GET_TEMPLATE_PATHS

///ANU	v4.97 03/19/97 MOVE_DISK_OBJ_TO_UIM	
///this is needed to use the new O_PAGE_ID instead
///of hwnd to do things
#define	WCB_GET_PAGE_ID						(MASK_WCB_NO_HWND + 44)
///end MOVE_DISK_OBJ_TO_UIM

//------------- CPY v4.9994 b2800 7/23/97 LAYER_NUMBER_ACCESS_FROM_WCB
#define WCB_GET_ACTIVE_LAYER_NUMBER			(MASK_WCB_NO_HWND + 45)
#define WCB_SET_ACTIVE_WIN_LAYER			(MASK_WCB_NO_HWND + 46)
//------------- LAYER_NUMBER_ACCESS_FROM_WCB

//-------------- CPY v5.004 8/4/97 t2897 FDLOG_SETDEFAULT_MUST_ALWAYS_SET_PATH
#define WCB_GET_DEFAULT_PATH				(MASK_WCB_NO_HWND + 47)
//-------------- FDLOG_SETDEFAULT_MUST_ALWAYS_SET_PATH

//--------------- CPY v5.005 8/5/97 FITTER_HELP_TO_GENERAL_CONTENTS
#define WCB_GET_ONLINE_HELP					(MASK_WCB_NO_HWND + 48)
//--------------- FITTER_HELP_TO_GENERAL_CONTENTS


//---------- CPY v5.028 11/24/97 b3252 STAT_NAME_COUNT_INDEP_DATASET
#define WCB_IS_WKSNAME_USED					(MASK_WCB_NO_HWND + 49)
//---------- STAT_NAME_COUNT_INDEP_DATASET

/// RB 9/15/98 v6.0129 t4194 FFT_EXPONENT_SIGN_CHOICE
#define WCB_GET_FFT_EXPONENT_SIGN			(MASK_WCB_NO_HWND + 50)
/// end  FFT_EXPONENT_SIGN_CHOICE

/// DVT 3/1/99 v6.0169 t5373 AVAILABLE_SERIES_FROM_CUR_FOLDER
#define WCB_IS_SERIES_FROM_CUR_FOLDER			(MASK_WCB_NO_HWND + 51)
#define WCB_TOGGLE_SAVE_SERIES_FROM_CUR_FOLDER	(MASK_WCB_NO_HWND + 52)
/// end  AVAILABLE_SERIES_FROM_CUR_FOLDER

///CPY v4.133 8/29/96 WCB_FRAME_ACCESS
#ifdef WCB_FRAME_ACCESS
/// ML v4.133 8/30/96 FRAME_AND_MEMORY_OBJECT_ACCESS
// possible values for wOption:
enum {
	MOLAYER_WKS = 1,
	MOLAYER_GRAPH,	// nLayer contains the layer number, -1 for active
};
/// end FRAME_AND_MEMORY_OBJECT_ACCESS
	#define WCB_FRAME_GET_ID			(MASK_FRAME + 1) 
	/// ML v4.133 9/5/96 CREATE_NEW_GRAPH
	#define	WCB_FRAME_CREATE_NEW_GRAPH	(MASK_FRAME + 2)
	/// end CREATE_NEW_GRAPH
	/// ML v4.133 9/6/96 PLOT_TYPES_AND_STRUCTURE
	#define	WCB_FRAME_STAT_PLOT			(MASK_FRAME + 3)
	/// ML end PLOT_TYPES_AND_STRUCTURE
	


	typedef	struct FR_LAYER_OPTION
	{
		int		nLayer;
		WORD	wOption;
	}FR_LAYER_OPTION, FAR *LP_FR_LAYER_OPTION;
	#define	MASK_FRAME_OBJ			0x0400
	typedef struct FR_MEM_OBJ_SIZE
	{
		DWORD 	id_fr;
		WORD	wSize;
		///CPY v4.133 9/9/96 CREATE_TEXT_LABEL
		LPSTR	lpBuffer;/// use for  MASK_FRAME_TEXT_OBJ only, ignore for mem obj
	}FR_MEM_OBJ_SIZE, FAR *LP_FR_MEM_OBJ_SIZE;	
	#define	WCB_FRAME_OBJ_CREATE	(MASK_FRAME | MASK_FRAME_OBJ)	
	#define	WCB_FRAME_OBJ_OPEN			(WCB_FRAME_OBJ_CREATE + 1)	
	#define	WCB_FRAME_OBJ_CREATE_OPEN	(WCB_FRAME_OBJ_CREATE + 2)	
	#define	WCB_FRAME_OBJ_CLOSE			(WCB_FRAME_OBJ_CREATE + 3)
	#define	WCB_FRAME_OBJ_CHECK  		(WCB_FRAME_OBJ_CREATE + 4)
	///CPY v4.133 9/9/96 CREATE_TEXT_LABEL 
	#define MASK_FRAME_TEXT_OBJ			0x0200
	#define	WCB_FRAME_TEXT_GET			(MASK_FRAME | MASK_FRAME_OBJ | MASK_FRAME_TEXT_OBJ)
	#define	WCB_FRAME_TEXT_SET			(WCB_FRAME_TEXT_GET + 1)
	/// CREATE_TEXT_LABEL

#endif //WCB_FRAME_ACCESS


///CPY v4.05 3/8/96 WCB_WKS_HANDLING, change WCB_WKS_GET_NUM_COLS's def
/// ML v3.980 1/17/96 WCB_WKS_GET_NUM_COLS
//#define	WCB_WKS_GET_NUM_COLS	(MASK_WCB_NO_HWND + 41)
/// end WCB_WKS_GET_NUM_COLS
#define	WCB_WKS_GET_ID						(MASK_WCB_WKS + 1)
/// ML v4.090 5/19/96 CREATE_DATA_AND_PLOT
#define	WCB_WKS_CREATE_DATA_AND_PLOT		(MASK_WCB_WKS + 2)
///ANU v4.979 4/25/97 CREATE_OBJ
#define WCB_CREATE_DATA_WKS					(MASK_WCB_WKS + 3)
	#define MAX_NUM_CREATE_OBJS			20
	typedef struct CREATE_OBJ_INFO
	{
		BYTE	nColType[MAX_NUM_CREATE_OBJS]; //column type	
		int		nNumTypes;						//number of types actually used
		char	szWksName[MAX_PATH];		//name of the new wks
		char	szTemplate[MAX_PATH];	//name of the template
		int		nPts;		///total rows in the  column
		//------------------------------------------------------------- CPY v6.0142 t4628 12/7/98 READ_ONLY_LAYER
		//BOOL	bEnum;		//enumerate the col names or not
		USHORT	wCntrl;// read_only, enumerate_col_names etc.
		//------------------------------------------------------------- end READ_ONLY_LAYER
		/// GCJ 3/4/99 t5510 v6.0169 ENUMERATE_WORKSHEET_PROPERTY
		char	szWksLabel[MAX_PATH];		//label of the new wks
		/// ENUMERATE_WORKSHEET_PROPERTY
		int		nTypeN;		//type to repeat if there are more columns than types
		///ANU v4.983 5/9/97 CREATE_OBJ_STRUCT_MEMORY
		///char*	strDataName[MAX_NUM_CREATE_OBJS]; //names of the dataset created
		char	strDataName[MAX_NUM_CREATE_OBJS][SNAME_SIZE]; //names of the dataset created
		///end CREATE_OBJ_STRUCT_MEMORY
	}CREATE_OBJ_INFO, FAR *LPCREATE_OBJ_INFO;
	//------------------------------------------------------------- CPY v6.0142 t4628 12/7/98 READ_ONLY_LAYER
	#define COI_READ_ONLY 0x1000
	#define COI_ENUM_COL_NAME	0x2000
	//------------------------------------------------------------- end READ_ONLY_LAYER
	/// GCJ 3/4/99 t5510 v6.0169 ENUMERATE_WORKSHEET_PROPERTY
	#define COI_ENUM_WKS_NAME	0x4000
	/// ENUMERATE_WORKSHEET_PROPERTY
BOOL	CreateDataWks( LPCREATE_OBJ_INFO lpCreateInfo, LPSTR lpstrColNames );
BOOL	MakeColStr( LPSTR	lpstInput );
BOOL	DeleteDataSet(LPCREATE_OBJ_INFO lpCreateInfo, LPSTR pstrColName);

#define WCB_DELETE_DATA_WKS_COLS					(MASK_WCB_WKS + 4)
//end	CREATE_OBJ

/// end CREATE_DATA_AND_PLOT
#define	MASK_WCB_WKS_NEED_ID		0x0800 /// 0xF000 is wks type mask
#define	WCB_WKS_GET_NUM_COLUMNS		(MASK_WCB_WKS | MASK_WCB_WKS_NEED_ID ) /// have to change name to ensure no old codes are using this
#define	WCB_WKS_GET_COL_NAME		(WCB_WKS_GET_NUM_COLUMNS + 1)
/// ML 5/1/96 GET_COLUMN_LABEL
#define	WCB_WKS_GET_COL_LABEL		(WCB_WKS_GET_NUM_COLUMNS + 2)
/// end GET_COLUMN_LABEL
/// ML v4.090 5/3/96 VARIOUS_WORKSHEET_MANIPULATIONS 
#define WCB_WKS_CLEAR_WORKSHEET_OF_DATA		(WCB_WKS_GET_NUM_COLUMNS + 3)
#define WCB_WKS_REMOVE_COLUMN_BY_NUMBER		(WCB_WKS_GET_NUM_COLUMNS + 4)
#define WCB_WKS_REMOVE_COLUMN_BY_NAME		(WCB_WKS_GET_NUM_COLUMNS + 5)
#define WCB_WKS_INSERT_COLUMN				(WCB_WKS_GET_NUM_COLUMNS + 6)
#define WCB_WKS_SET_BY_NUM_COLUMN_LABEL		(WCB_WKS_GET_NUM_COLUMNS + 7)
#define WCB_WKS_SET_BY_NAME_COLUMN_LABEL	(WCB_WKS_GET_NUM_COLUMNS + 8)
/// end VARIOUS_WORKSHEET_MANIPULATIONS
/// ML v4.090 5/17/96 CREATE_NEW_EMPTY_WORKSHEET
/// ML v4.090 5/23/96 CREATE_NON_EMPTY_WORKSHEET_ON_OPTION
//#define	WCB_WKS_CREATE_NEW_EMPTY			(WCB_WKS_GET_NUM_COLUMNS + 9)
#define	WCB_WKS_CREATE_NEW					(WCB_WKS_GET_NUM_COLUMNS + 9)
/// end CREATE_NON_EMPTY_WORKSHEET_ON_OPTION
/// end CREATE_NEW_EMPTY_WORKSHEET
/// ML v4.090 5/17/96 DESTROY_WORKSHEET
#define WCB_WKS_DESTROY						(WCB_WKS_GET_NUM_COLUMNS + 10)
/// end DESTROY_WORKSHEET
/// ML v4.090 5/19/96 VARIOUS_COLUMN_SETTINGS
#define WCB_WKS_SET_COLUMN_AS				(WCB_WKS_GET_NUM_COLUMNS + 11)
#define WCB_WKS_SET_COL_WIDTH				(WCB_WKS_GET_NUM_COLUMNS + 12)
#define WCB_WKS_SET_COL_NUM_DEC_PLACES		(WCB_WKS_GET_NUM_COLUMNS + 13)
/// end VARIOUS_COLUMN_SETTINGS
/// ML v4.090 5/22/96 MORE_WORKSHEET_STUFF
#define WCB_WKS_SHOW_COLUMN_LABELS			(WCB_WKS_GET_NUM_COLUMNS + 14)
#define WCB_WKS_SHOW_COLUMN_NAMES			(WCB_WKS_GET_NUM_COLUMNS + 15)
#define WCB_WKS_SET_COL_HEADING_HEIGHT		(WCB_WKS_GET_NUM_COLUMNS + 16)
#define WCB_WKS_GET_COL_LABEL_BY_NAME		(WCB_WKS_GET_NUM_COLUMNS + 17)
/// end MORE_WORKSHEET_STUFF
/// ML v4.090 5/24/96 SET_COLUMN_NAME
#define WCB_WKS_SET_COL_NAME				(WCB_WKS_GET_NUM_COLUMNS + 18)
/// end SET_COLUMN_NAME
/// YN v4.090 5/28/96 SET_WKS_LABEL
#define WCB_WKS_SET_WKS_LABEL				(WCB_WKS_GET_NUM_COLUMNS + 19)
/// end SET_WKS_LABEL
/// ML 6/3/96 SET_COLUMN_TYPE_AS
#define	WCB_WKS_SET_COL_TYPE				(WCB_WKS_GET_NUM_COLUMNS + 20)
// see below for possible types:
/// end SET_COLUMN_TYPE_AS  
///  YN  v4.10 6/14/96  ADD_GetColumnWidth_FUNCTIONS
#define WCB_WKS_GET_COL_WIDTH				(WCB_WKS_GET_NUM_COLUMNS + 21)
///  end  ADD_GetColumnWidth_FUNCTIONS
/// ML v4.10 6/18/96 GET_COLUMN_TYPE
#define WCB_WKS_GET_COL_TYPE				(WCB_WKS_GET_NUM_COLUMNS + 22)
/// end GET_COLUMN_TYPE
/// ML v4.11 7/1/96 SHOW_WORKSHEET_NAME_LABEL_OR_BOTH
#define	WCB_WKS_SHOW_WIN_NAME_LABEL_BOTH	(WCB_WKS_GET_NUM_COLUMNS + 23)
/// end SHOW_WORKSHEET_NAME_LABEL_OR_BOTH
///ANU v4.14 12/23/96 SETCOLUMNTITLE, new public function
#define	WCB_WKS_SET_BY_NUM_COLUMN_TITLE		(WCB_WKS_GET_NUM_COLUMNS + 24)
///end SETCOLUMNTITLE

//-------------	CPY v5.036 1/22/98 t3479 MODATA_SET_RANGE_CHANGE
#define	WCB_WKS_SET_RANGE					(WCB_WKS_GET_NUM_COLUMNS + 25)
/// additional constants for redraw options in the lpLong[4] parameter
/// GCJ 11/6/98 t4423 v6.0136 WRONG_STEREO_WAVEFILE_IMPORT
#define WCB_WKS_SET_MAX_ROW_SIZE			(WCB_WKS_GET_NUM_COLUMNS + 26)
/// end  WRONG_STEREO_WAVEFILE_IMPORT
	#define	WSR_SETRANGE_EXPAND	0x0200
	/* data range has been increased, need to update
	 * all the plots to the new range.
	 */
	#define	WSR_SETRANGE_DRAW_ALL	0x0100
	/* Redraw all the data points */
	
	#define	WSR_SETRANGE_DRAW_RANGE	0x4000
	/* Redraw only the specified range, must
	 * use together with WSR_SETRANGE_EXPAND
	 */
//-------------	end CPY v5.036 1/22/98 t3479 MODATA_SET_RANGE_CHANGE

 

//// WCB_WKS_HANDLING




/// ML v4.10 6/18/96 MOVED_TO_ORGDLL_H
///// ML 6/3/96 SET_COLUMN_TYPE_AS
////  possible types for WCB_WKS_SET_COL_TYPE and WCB_WKS_INSERT_COLUMN: 
//enum {
//	WKSCOL_NUMERIC = 0,
//	WKSCOL_TEXTUAL,
//	WKSCOL_MIXED,
//};
/// end SET_COLUMN_TYPE_AS
///	CPY v4.97 3/11/97 TEST_CELL_NUMERIC_OR_NOT
//#define	LABELS_TYPE		0x000F	// numberic, date, text-from-data
#define	LABELS_TYPE			OKCOLTYPE_MASK 

//
	///CPY 11/7/96 EXTERANL_DATA, introduce OKCOLTYPE_ 
#define	LABELS_NUMERIC		OKCOLTYPE_NUMERIC	//0
#define	LABELS_TEXT			OKCOLTYPE_TEXT		//1
#define	LABELS_TIME			OKCOLTYPE_TIME		//2
#define	LABELS_DATE			OKCOLTYPE_DATE		//3
#define	LABELS_MONTH		OKCOLTYPE_MONTH		//4
#define	LABELS_DAY			OKCOLTYPE_WEEKDAY	//5
#define	LABELS_COLUMN		OKCOLTYPE_COLUMN	//6
#define	LABELS_DATASET		OKCOLTYPE_DATASET	//7
#define	LABELS_DATASET_X	OKCOLTYPE_DATASET_X	//8
#define	LABELS_MIXED		OKCOLTYPE_TEXT_NUMERIC	//9 ///CPY v4.09 5/6/96 VAR_SIZE_COL
/// end MOVED_TO_ORGDLL_H

/// ML v4.11 7/1/96 MOVED_FROM_COMMON_H_TO_ORGDLL_H_SO_THAT_STSDLL_CAN_ACCESS_IT
#define	PLOT_CNTRL3_WIN_TITLE_BITS			0x0300
#define	PAGE_WIN_TITLE_STYLE(p)				(((p)->cntrl3 & PLOT_CNTRL3_WIN_TITLE_BITS) >> 8)
#define	SET_PAGE_WIN_TITLE_STYLE(p,n)	 	(p)->cntrl3 &= ~PLOT_CNTRL3_WIN_TITLE_BITS,(p)->cntrl3 |= ((n)&0x0003) << 8
#define	WIN_TITLE_AUTO			0
#define	WIN_TITLE_SHOW_LABEL	1
#define	WIN_TITLE_SHOW_NAME		2
#define	WIN_TITLE_SHOW_BOTH		3

///EJP v4.03 03-07-96 WIN_TITLE_SHOW_AUTO
#define WIN_TITLE_SHOW_AUTO		WIN_TITLE_SHOW_NAME
///end WIN_TITLE_SHOW_AUTO

///	 WIN_TITLE_SHOW_NAME_LABEL
//-------------------------------------------------
/// end MOVED_FROM_COMMON_H_TO_ORGDLL_H_SO_THAT_STSDLL_CAN_ACCESS_IT











#define	WCB_DOBUTTON		MASK_WCB_OPTION_HWND
/// CPY v3.69
#define	WCB_AXIS_SCALE_CVT	(MASK_WCB_OPTION_HWND+1) /// use axis transform to cvt double
///

/****************************************************
 * the following command need a valid worksheet hWnd
 ****************************************************/
 
#define	WCB_PUT_DATA		0
#define	WCB_CNTRL_DATA		1
#define	WCB_GET_PROCESSES	2
#define	WCB_GET_CELL		10 /* single cell */
#define	WCB_GET_DATA		11 /* pass HPSHORT to get data */
#define	WCB_GET_WKS_SIZE	13 /* LP long array of two # = nRows,nCols */
#define	WCB_SETUP_OBJ		17 /* set up real-time object */

#define	WCB_SET_UPDATE		18 /* check animation properties of all related plots */

// drawing related commands
#define	WCB_DRAW_BEGIN		MASK_NEED_DRAW
// the following has to be between BEGIN and END

#define	WCB_DRAW_END		(MASK_NEED_DRAW | MASK_DRAWING_MODE)
#define	WCB_DRAW_AP_TO_LP	(WCB_DRAW_END+1)
	// cvt axes point to logical point
#define	WCB_DRAW_LP_TO_AP	(WCB_DRAW_END+2)

// basic drawing lines
#define	WCB_DRAW_MOVETO		(MASK_DRAWING_OPTN_COOR | MASK_NEED_DRAW | MASK_DRAWING_MODE)
#define WCB_DRAW_LINETO		(WCB_DRAW_MOVETO+1)

///CPY v4.05 3/8/96 WCB_WKS_HANDLING
ULONG	WCB_wks_callback(HWND hWnd,USHORT msg,DWORD lParam,LPSTR lpStr);
/// WCB_WKS_HANDLING

// dataset access to Origin
ULONG	DataSetAccess(HWND hWnd,USHORT msg,DWORD lParam,LPSTR lpStr);

#define	WCB_DATA_GET_ID		MASK_DATASET	// get a column id from a given name
/// CPY v3.782 GET_WKS_COL_ID
#define	WCB_DATA_GET_COL_ID	(MASK_DATASET + 1) // col number is specified in range[0] and starts from 1
///

#define	WCB_DATA_ADD_CURVE	(MASK_DATASET + 3) // add a curve to current layer
#define	WCB_DATA_RMV_CURVE	(MASK_DATASET + 4) // remove a curve from the current layer
#define	WCB_DATA_SET_XVAL_4_Y	(MASK_DATASET + 5) // Set a y column's x values
#define	WCB_DATA_SET_XCOL_4_Y	(MASK_DATASET + 6) // Set a x col for y col.
#define	WCB_DATA_GET_XCOL_4_Y	(MASK_DATASET + 7) // Get a x col for y col.
#define	WCB_DATA_CREATE_XDATA	(MASK_DATASET + 8) // Create an x col
#define	WCB_DATA_CREATE_YDATA	(MASK_DATASET + 9) // Create a y col
#define	WCB_DATA_SET_SAME_X	(MASK_DATASET + 10) // assign x col of one col to another   
/// CPY v3.69
#define	WCB_DATA_SET_INTERNAL	(MASK_DATASET + 11) // set internal flags to enable/disable using axes transform for GET_XY_VALUES
	/// flags defined so far
	#define	WDSI_X_TRANSFORM	X_AXIS
	#define	WDSI_Y_TRANSFORM	Y_AXIS     
///SB v3.77 3/7/95
#define WCB_DATA_CLEAN_TEMP_DATASET (MASK_DATASET + 12) //clean temporary dataset
///
/// QZCao, 11/6/95, v3.85, GET_X_COL_VAL_IN_PLOT
#define	WCB_DATA_GET_X_4_Y_PLOT  (MASK_DATASET + 13)// Get x col or value for y col when the dataset is inside a plot.
///
/// ML v3.980 1/15/96 WCB_DATA_GET_COL_FROM_COLNAME
#define WCB_DATA_GET_COL_FROM_COLNAME	(MASK_DATASET + 14)
/// end WCB_DATA_GET_COL_FROM_COLNAME
/// ML v4.133 9/5/96 CREATE_ONE_TEMPORARY_SERIES
#define	WCB_DATA_CREATE_ONE_TEMPORARY	(MASK_DATASET + 15)
/// end CREATE_ONE_TEMPORARY_SERIES

//--------------- CPY v4.9994 b2837 7/24/97 SIMULATE_USE_SEPARATE_WKS
//#define	WCB_DATA_ID_FROM_COL_NUM	(WCB_DATA_GET_VALUE + 37)
//#define	WCB_DATA_ID_FROM_COL_NAME	(WCB_DATA_GET_VALUE + 38)
#define	WCB_DATA_ID_FROM_COL_NUM	(MASK_DATASET + 16)
#define	WCB_DATA_ID_FROM_COL_NAME	(MASK_DATASET + 17)

#define	WCB_DATA_OPEN_OBJ	(MASK_DATASET + 18) // Open an object for saving the peak fitting data such as parameters
#define	WCB_DATA_CLOSE_OBJ	(MASK_DATASET + 19) // Open an object for saving the peak fitting data such as parameters
#define WCB_DATA_CHECK_STOP	(MASK_DATASET + 20)
#define	WCB_DATA_MSG_BOX	(MASK_DATASET + 21)
#define WCB_DATA_MSG_STATUS	(MASK_DATASET + 22)

#define WCB_CHK_SYSTEM_VAR	(MASK_DATASET + 23)
#define	WCB_DATA_GET_WKS_INFO	(MASK_DATASET + 24)

#define	WCB_DATA_GET_SCR_VAL	(MASK_DATASET + 25) // Get screen space value
#define	WCB_DATA_GET_ACT_VAL	(MASK_DATASET + 26) // Get real value
#define	WCB_DATA_SET_PARA_VALUE	(MASK_DATASET + 27) // Set para value 2 origin.
#define	WCB_DATA_DEL_VARIABLE	(MASK_DATASET + 28) // del a variable
#define	WCB_DATA_ADD_VARIABLE	(MASK_DATASET + 29) // Add a variable
#define	WCB_DATA_CAL_YSCRIPT	(MASK_DATASET + 30)	// Calculate yscript
#define	WCB_DATA_CAL_EXPRESSION	(MASK_DATASET + 31)	// Calculate expression
#define	WCB_DATA_GET_DATASET_LIST	(MASK_DATASET + 32)
#define	WCB_DATA_CREATE_DATA	(MASK_DATASET + 33)
#define	WCB_DATA_CHECK_LINEAR	(MASK_DATASET + 34)
#define	WCB_DATA_LINEAR_FIT		(MASK_DATASET + 35)
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
//--------------- SIMULATE_USE_SEPARATE_WKS



#define	WCB_DATA_GET_VALUE	(MASK_DATASET | MASK_DATASET_SERIES)
#define	WCB_DATA_SET_VALUE	(WCB_DATA_GET_VALUE + 1)
#define	WCB_DATA_GET_2VALUE	(WCB_DATA_GET_VALUE + 2)
#define	WCB_DATA_GET_XY_VALUE	(WCB_DATA_GET_VALUE + 3)
#define	WCB_DATA_GET_Y_FROM_X	(WCB_DATA_GET_VALUE + 4)
#define	WCB_DATA_GET_X_FROM_Y	(WCB_DATA_GET_VALUE + 5) // get x val for given y col
#define	WCB_DATA_TEST_ID	(WCB_DATA_GET_VALUE + 6)
#define	WCB_DATA_SET_RANGE	(WCB_DATA_GET_VALUE + 7)
#define	WCB_DATA_GET_RANGE	(WCB_DATA_GET_VALUE + 8) // get a column range;
#define	WCB_DATA_CHECK_RANGE	(WCB_DATA_GET_VALUE + 9)

/// QZCao, v3.8, get dataset both x & y range
#define	WCB_DATA_GET_XY_RANGE	(WCB_DATA_GET_VALUE + 10)
///
//-------------	CPY v5.036 1/22/98 t3479 MODATA_SET_RANGE_CHANGE
#define	WCB_DATA_SET_RANGE_REDRAW	(WCB_DATA_GET_VALUE + 11)	
//-------------	end CPY v5.036 1/22/98 t3479 MODATA_SET_RANGE_CHANGE
///
#define	WCB_DATA_SET_XY_VALUE	(WCB_DATA_GET_VALUE + 12)
///

//--------------- CPY v4.9994 b2837 7/24/97 SIMULATE_USE_SEPARATE_WKS
//#define	WCB_DATA_TEST_DATA	(WCB_DATA_GET_VALUE + 21) // test if a column of given name exists
//#define	WCB_DATA_GET_SCR_VAL	(WCB_DATA_GET_VALUE + 22) // Get screen space value
//#define	WCB_DATA_GET_ACT_VAL	(WCB_DATA_GET_VALUE + 23) // Get real value
//#define	WCB_DATA_SET_PARA_VALUE	(WCB_DATA_GET_VALUE + 24) // Set para value 2 origin.
//#define	WCB_DATA_DEL_VARIABLE	(WCB_DATA_GET_VALUE + 25) // del a variable
//#define	WCB_DATA_ADD_VARIABLE	(WCB_DATA_GET_VALUE + 26) // Add a variable
/// QZCao, v3.781, 4/12/95, no need for this removed
//#define	WCB_DATA_RUN_SCRIPT	(WCB_DATA_GET_VALUE + 27) // run a piece of scripts
///
//--------------- CPY v4.9994 b2837 7/24/97 SIMULATE_USE_SEPARATE_WKS
//#define	WCB_DATA_OPEN_OBJ	(WCB_DATA_GET_VALUE + 28) // Open an object for saving the peak fitting data such as parameters
//#define	WCB_DATA_CLOSE_OBJ	(WCB_DATA_GET_VALUE + 29) // Open an object for saving the peak fitting data such as parameters
//#define WCB_DATA_CHECK_STOP	(WCB_DATA_GET_VALUE + 30)
//#define	WCB_DATA_MSG_BOX	(WCB_DATA_GET_VALUE + 31)
//#define WCB_DATA_MSG_STATUS	(WCB_DATA_GET_VALUE + 32)
//---------------

//#define	WCB_DATA_CAL_YSCRIPT	(WCB_DATA_GET_VALUE + 33)	// Calculate yscript
//#define	WCB_DATA_CAL_EXPRESSION	(WCB_DATA_GET_VALUE + 34)	// Calculate expression

//#define	WCB_DATA_GET_DATASET_LIST	(WCB_DATA_GET_VALUE + 35)
#define	WCB_DATA_GET_ERRORBAR_COL	(WCB_DATA_GET_VALUE + 13)
//--------------- CPY v4.9994 b2837 7/24/97 SIMULATE_USE_SEPARATE_WKS
//#define	WCB_DATA_GET_WKS_INFO		(WCB_DATA_GET_VALUE + 39)

/// CPY v3.74 apparent fit and increment checking
#define	WCB_DATA_X_GET_VALUE	(WCB_DATA_GET_VALUE + 14)
#define	WCB_DATA_Y_GET_VALUE    (WCB_DATA_X_GET_VALUE + 1)
#define	WCB_DATA_X_SET_VALUE    (WCB_DATA_X_GET_VALUE + 2)
#define	WCB_DATA_Y_SET_VALUE    (WCB_DATA_X_GET_VALUE + 3)

#define	WCB_DATA_CHECK_X_INC	(WCB_DATA_X_GET_VALUE + 4) /// return 1 if inc test failed, 0 if OK
/// CPY v3.781
#define	WCB_DATA_GET_RAW_VALUE	(WCB_DATA_X_GET_VALUE + 5)
///
#define	WCB_DATA_CHECK_INC		(WCB_DATA_X_GET_VALUE + 6) /// return 1 if inc test failed, 0 if OK
/// QZCao v3.78, 4/24/95
//#define	WCB_DATA_CREATE_DATA	(WCB_DATA_GET_VALUE + 57)
#define	WCB_DATA_CHECK_RANGE2	(WCB_DATA_X_GET_VALUE + 7)

/// QZCao v3.78, March 19, 95
#define	WCB_DATA_CREATE_NAME	(WCB_DATA_X_GET_VALUE + 8)
#define	WCB_DATA_GET_ELEMENT	(WCB_DATA_X_GET_VALUE + 9) /// return ptr to element array
#define	WCB_DATA_I_FROM_X	(WCB_DATA_X_GET_VALUE + 10) ///
//#define	WCB_DATA_CHECK_LINEAR	(WCB_DATA_X_GET_VALUE + 11)
//#define	WCB_DATA_LINEAR_FIT	(WCB_DATA_X_GET_VALUE + 12)
///

/// ML v3.821 8/30/95 ONE_DATASET_ONLY
#define WCB_DATA_GET_ONE_TEMP		(WCB_DATA_X_GET_VALUE + 13)
#define WCB_DATA_KILL_ONE_TEMP		(WCB_DATA_X_GET_VALUE + 14)
/// end ONE_DATASET_ONLY
/// ML v3.840 9/22/95 PICKING_PEAKS_ORIGIN_WAY
#define	WCB_DATA_PICK_PEAKS_ORIGIN_WAY	(WCB_DATA_X_GET_VALUE + 15)
/// end PICKING_PEAKS_ORIGIN_WAY

//-------- CPY v5.002 7/30/97 b2869 X_RANGE_FOR_X_DATASET
#define WCB_DATA_GET_DEPENDENT_ID		(WCB_DATA_X_GET_VALUE + 20)
#define	WCB_DATA_GET_MATH_LIMITS		(WCB_DATA_X_GET_VALUE + 21)
//-------- X_RANGE_FOR_X_DATASET

/// ML v3.84 9/25/95 KILL_DATASET_TOGETHER_WITH_ITS_DEPENDENT
#define	WCB_DATA_KILL_WITH_DEPENDENT	(WCB_DATA_GET_VALUE + 67)
/// end KILL_DATASET_TOGETHER_WITH_ITS_DEPENDENT
/// ML v3.97 12/11/95 WCB_DATA_IS_TEXT_DATASET
#define	WCB_DATA_IS_TEXT_DATASET		(WCB_DATA_GET_VALUE + 68)
/// end WCB_DATA_IS_TEXT_DATASET
/// ML v3.970 12/11/95 TEXT_DATASET_VALUE
#define	WCB_DATA_SET_TEXT_VALUE			(WCB_DATA_GET_VALUE + 69)
#define	WCB_DATA_GET_TEXT_VALUE			(WCB_DATA_GET_VALUE + 70)
/// end TEXT_DATASET_VALUE 
/// ML v3.980 1/4/96 MOMASK_IMPLEMENTATION
#define	WCB_DATA_SET_MASK				(WCB_DATA_GET_VALUE + 71)
/// end MOMASK_IMPLEMENTATION
/// ML v3.981 1/23/96 WCB_DATA_GET_NUM_VALUE_AS_TEXT
#define	WCB_DATA_GET_NUM_VALUE_AS_TEXT	(WCB_DATA_GET_VALUE + 72)
/// end WCB_DATA_GET_NUM_VALUE_AS_TEXT
/// ML v4.090 5/17/96 RANK_ONE_DATASET
#define WCB_DATA_RANK					(WCB_DATA_GET_VALUE + 73)
/// end RANK_ONE_DATASET


//----- YL CPY v4.983 5/9/97 ADD_SET_LABEL_FROM_ID
#define WCB_DATA_SET_COL_LABEL			(WCB_DATA_GET_VALUE + 74)
//-----

//------------------- CPY v4.9994 b2837 7/24/97 SIMULATE_USE_SEPARATE_WKS
////#define	WCB_DATA_GET_DATA_NAME	(MASK_DATASET + 2) // get a column name from a given id
#define WCB_DATA_GET_WKS_NAME			 (WCB_DATA_GET_VALUE + 76)
#define WCB_DATA_GET_DATA_NAME			 (WCB_DATA_GET_VALUE + 77)
#define WCB_DATA_GET_COL_NAME			 (WCB_DATA_GET_VALUE + 78)
//------------------- SIMULATE_USE_SEPARATE_WKS

///
///STH v3.78 4/4/95 FIND_INI written qcao added by sth
/// CPY v3.781 removed after adding Dr. Cao's
//#define	WCB_GET_INIT_FILE	(MASK_WCB_NO_HWND+25)
///

///sb v 3.77 3/7/95 removed 3/8/95 because same as     WCB_DATA_SET_XVAL_4_Y
//#define WCB_DATA_SET_NO_X       (WCB_DATA_GET_VALUE + 52) // assign x col when none exists


///

/*
#define	WCB_DATA_GETINITFILE	(WCB_DATA_GET_VALUE + 45)
#define	WCB_DATA_GETPATH1	(WCB_DATA_GET_VALUE + 46)
#define	WCB_DATA_GETPATH2	(WCB_DATA_GET_VALUE + 47)
#define	WCB_DATA_OPENFITFUNC	(WCB_DATA_GET_VALUE + 48)
#define	WCB_DATA_READ1LINE	(WCB_DATA_GET_VALUE + 49)
#define	WCB_DATA_CLOSEFITFUNC	(WCB_DATA_GET_VALUE + 50)
*/

// QZCao & H v3.71, begin
typedef LPSTR FAR* LPPSTR;

#ifndef	MASK_FIT
	#define	MASK_WCB_NO_HWND	0x1000
	#define	MASK_WCB_OPTION_HWND	0x2000
	#define	MASK_FIT		0x4000
#endif

#ifndef	MASK_PKFIT
	#define	MASK_WCB_NO_HWND	0x1000
	#define	MASK_WCB_OPTION_HWND	0x2000
	#define	MASK_FIT		0x4000
	#define	MASK_PKFIT		0x8000
#endif

#define	FIT_CURVE_COLOR		0
#define	FIT_CURVE_KIND		1
#define	FIT_CURVE_SIZE		2
#define	FIT_CURVE_DASH		3
#define	FIT_CURVE_WIDTH		4
#define	FIT_CURVE_SYMBCNTRL	5
#define	FIT_CURVE_ENUMMER	6
#define	FIT_CURVE_CONNECT	7

#define	WPI_PARAM	0
#define WPI_INVALID	1
#define	WPI_NUMERIC	2
#define WPI_VARIABLE	3
/* return 
 * 0 : fitting paramter
 * 1 : invalid name
 * 2 : numeric constants
 * 3 : variable constants
 * lpstr1 is lpstr to parameter name
 * lpstr2 is lpint to parameter index
 */
// QZCao & H v3.71, end


typedef	struct	DataElement {
	LONG	index;
	double	value;
	double	xvalue;
} DataElement, DATAELEMENT, FAR *LPDATAELEMENT;


typedef struct	DATASETGET {
	LONG	i1;/* offset, starts from 0 */
	LONG	npts;
	USHORT	cntrl;
	char	name[NAME_SIZE];
} DATASETGET,FAR *LPDATASETGET;


/// ML v3.970 12/11/95 TEXT_DATASET_VALUE
typedef struct	DataTextValue {       
	LONG	index;
	LPSTR	lpszValue;
} DATATEXTVALUE, FAR *LPDATATEXTVALUE;
/// end TEXT_DATASET_VALUE


typedef	struct	WKSGETDATA {
	short	nCol1;
	LONG	nRow1;
	short	nCols;
	LONG	nRows;
	int	format;	/* data format, same as DDE_DATA_SHORT */
	int	size;	/* for string format, need to have size */
	float	max,min;/* if convert is needed, ends float values */
}WKSGETDATA,FAR *LPWKSGETDATA;


//////////////////////////////////////////////////////////////////////////////
/// EGO  section
//////////////////////////////////////////////////////////////////////////////
/// CPY v3.98 1/16/95 EGO_MSG_CONSISTANT 
#define MASK_DRAWING    			0x0100  /* need hDC */
#define MASK_MEASURE    			0x0200  /* need common size calculation */
#define	MASK_MSG_NEED_CALLBACK		0x0400
#define MASK_COMMON_MSG				0x0800
#define MASK_OBJ_MSG    			0x00FF  /* 256 obj message? */
#define MASK_SYS_MSG    			0x1000  /* related to DLL init or other system level message */
#define MASK_GLOBAL_MSG 			0x2000  /* need global handling before and after dispatch */
#define MASK_LOCAL_MSG  			0x4000

///CPY v3.98 1/15/95 EGO_MESSAGE, remove below
//#ifndef	EGO_CMD
/* return codes for set_value, get_value */
#define	EGOR_NO		0
#define	EGOR_YES	1
#define	EGOR_ERR	2
#define	EGO_SET_VALUE	17	/* set single value */
#define	EGO_GET_VALUE	18	/* get single value */
#define	EGO_SET_STR	19
#define	EGO_GET_STR	20
///CPY v3.98 1/15/95 EGO_MESSAGE, move here from labgobj.h
//#define	EGO_CMD		21
///EJP v3.98 01-02-96 UIM_OBJ_HANDLING
///sth v4.09 5/21/96 REMOVING_DOUBLE_EGO_CMD_DEFINITION
//#ifdef WNDBASED_UIM_OBJ
///end REMOVING_DOUBLE_EGO_CMD_DEFINITION
	//CPY v3.98 1/16/95 EGO_MSG_CONSISTANT
	//#define EGO_CMD         (21 + (MASK_COMMON_MSG | MASK_MSG_NEED_CALLBACK))
	//#define EGO_CMD_INIT    (22 + (MASK_COMMON_MSG))
	#define EGO_CMD         (1 + (MASK_COMMON_MSG | MASK_MSG_NEED_CALLBACK))
	#define EGO_CMD_INIT    (2 + (MASK_COMMON_MSG))
	///
///sth v4.09 5/21/96 REMOVING_DOUBLE_EGO_CMD_DEFINITION
//#else
	//#define EGO_CMD         21
	//#define EGO_CMD_INIT    22
//#endif // NO_WNDBASED_UIM_OBJ
///end REMOVING_DOUBLE_EGO_CMD_DEFINITION
///end UIM_OBJ_HANDLING

//#endif //EGO_CMD

///CPY v3.98 VECTOR_ASSIGNMENT, can not use 22 and 23
///EJP v3.98 UIM_OBJ_HANDLING, add common mask for wndbased uim objs.
///#define	EGO_GET_VECTOR_SIZE	37
///#define	EGO_SET_VECTOR_SIZE	38
#define EGO_GET_VECTOR_SIZE	(3 + (MASK_COMMON_MSG)) //CPY v3.98 1/16/95 EGO_MSG_CONSISTANT, after EGO_CMD_INIT
#define EGO_SET_VECTOR_SIZE	(4 + (MASK_COMMON_MSG))
/// see labgobj.h for range of other numbers

#ifndef	LFS_NOT_IN_LIST

/* copied from labstr.h on 7/28/93 */

typedef struct	STRLIST {
	USHORT	id;
	LPSTR	str;
}STRLIST,FAR *LPSTRLIST;

int FAR PASCAL LABUTIL_FindString(LPSTRLIST lpList,LPSTR lpstr);
#define	LFS_NOT_IN_LIST	32764

#endif







/*******************
 * LabCntrl definitions and messages
 *******************/
typedef	ULONG	(FAR PASCAL *LPFNPROCESS)(HWND,USHORT,LPSTR,LPSTR,LPCALLBK);

#define	LABCNTRL_PROCESS	2
#define	LABCNTRL_STATE_CHANGE	3
#define	LABCNTRL_WIN_OPEN	4/* any window opens */
#define	LABCNTRL_WIN_CLOSE	5
#define	LABCNTRL_BEGIN_EDIT	6
#define	LABCNTRL_END_EDIT	7

#define	LABCNTRL_START		10
#define	LABCNTRL_STOP		11



#ifdef	DDE_DATA_STRING		
/******** lpwks processing ********/
int ProcessOneCol(LPDATAWKS lpWks,int nCol,FARPROC lpfn,ULONG lParam1,ULONG lParam2);
#define	POC_BEGIN	0
#define POC_END		1
#define POC_PROCESS	2

/** callback function has the following form

int FAR PASCAL callback(LPSTR lpData,USHORT wFormat,ULONG lParam1,ULONG lParam2,USHORT msg);

**/

#endif

/* process info function
 * ULONG FAR PASCAL ProcInfo(int type,int msg,LPSTR lpstr)
 * and msg is defined below
 */
#define	PIF_LPFN_BY_TYPE	0
#define	PIF_LPFN_BY_NAME	1
	/* get function ptr of specified type */
#define	PIF_GET_TOTAL_OBJS	2	/* number of objects */
#define	PIF_GET_BMP		3	/* get the bmp of the specified obj */
#define PIF_RELEASE_BMP		4
#define PIF_GET_NAME		5	/* get the name of the spec obj */

/// Module Error codes  12/6/94

// error message groups
#define 	ERRGP_ORIGIN 		0x0000  // from A
#define		ERRGP_SETTING		0x2000
#define 	ERRGP_ARGUMENT		0x4000
#define 	ERRGP_HARDWARE		0x6000
#define 	ERRGP_EXTERNAL    	0x8000
#define 	ERRGP_MEMORY	 	0xA000
#define  	ERRGP_MISC              0xC000
// 12/28 km, the above errors are all in a module error    
//#define  	ERRGP_MODULE		0xC000 /// interface to Origin 
// 0xE000 reserved for later use 
// error message handling methods, IN .errout
enum {
	ERROUT_NO_OUTPUT,
	ERROUT_SCRIPT_WINDOW,
	ERROUT_SAVE_FILE,
	ERROUT_DIALOG_BOX,
	ERROUT_STATIS_WINDOW,
}; 


//------------- CPY v5.036 1/22/98 t3479 MODATA_SET_RANGE_CHANGE
// constants for when data is changed in a series(dataset), what kind of redraw should take place
// used mainly in the SET_RANGE_REDRAW callback function
#define SR_REDRAW_NONE			0x8000	/// for debug purpose to ensure proper calling parameter range
#define SR_REDRAW_REALTIME		0x8001
#define	SR_REDRAW_REFRESH		0x8002
#define	SR_REDRAW_REALTIME_WKS	(SR_REDRAW_REALTIME | 0x8004)
#define SR_REDRAW_REALTIME_SCOPE (SR_REDRAW_REALTIME |0x8008) // CPY v6.0187 4/22/99 OPP_SCOPE_MODE
#define	SR_MASK_REALTIME_ON_IDLE	0x0010	///---- CPY v5.039 b3558 REALTIME_DRAW_BUFFERRING
//------------- MODATA_SET_RANGE_CHANGE



/// ML v4.09 4/26/96 MOVED_TO_PSDLL_H
/*

#ifdef ORG_DATA_MASK

/// ML 3.981 1/23/96 MOVED_FROM_MARK_H_TO_ORGDLL_H
#define		MAX_NUM_MASKS					255
#define		MASK_VARIABLE_NAME_SIZE			WORD_SIZE
/// end MOVED_FROM_MARK_H_TO_ORGDLL_H


/// ML v4.00 1/25/96 TO_PROVIDE_COMMUNICATION_WITH_LABMASK

/// ML v4.08 4/11/96 NAME_OF_SUBJECT_COLUMN_PLUS_ADDITIONAL_STILL_UNUSED_MEMBERS
// Must be a multiple of 8, because it will be in a structure
#define		TW_COLUMN_NAME_SIZE				32		
/// end NAME_OF_SUBJECT_COLUMN_PLUS_ADDITIONAL_STILL_UNUSED_MEMBERS

#define		TWOWAYMEMOBJNAME	"_TWY"

typedef	struct	tagTwoWayMemObjHeader {
	ULONG	ulSizeOfThisHeader;	// it has to be set to the size of this header when created.
	DWORD	dwKindOfWorksheet;	// 0 for the original (masked) worksheet (it should be when object is
								//	 created),
								// 1 for the fully (two-way) extracted cells
								// 2 for the twoway-ANOVA arranged worksheet (after 'mark.BoxesToCols()')
	ULONG	ulNumLevsFirstWay;
	ULONG	ulNumLevsSecondWay;
	DWORD	dwOnlyNumTextSize;	// HIWORD contains the size of the strings
								// used to store formatted numeric levels for
								// the first way if it is numeric (otherwise it has to be zero)
								// LOWORD for the second way.
/// ML v4.08 4/7/96 STORE_GAPSIZE_IN_MEMORY_OBJECT
	//DWORD	dwNotUsed;
	DWORD	dwGapSize;			// Used by MARK object (Boxes To Cols) to store the size
								// of the gap.
/// end STORE_GAPSIZE_IN_MEMORY_OBJECT
	DWORD	dwKinds;			// first bit for first way, second bit for second way
	DWORD	dwSizes;			// HIWORD contains the size of the first way variable 
								// (for example: for double it will be eight (which is automatic
								// if the kind is numeric), for textual it will be the string
								// length).
								// LOWORD contains the size of the second way variable
	ULONG	ulTotNumMasks;
	ULONG	dwNumCellObservations;	// the size of the cell with the maximum number of observations
	/// ML v4.08 4/11/96 NAME_OF_SUBJECT_COLUMN_PLUS_ADDITIONAL_STILL_UNUSED_MEMBERS
	// The two character buffers are used to store the names of the two columns
	// to which the masks are set. The first one must be the name of the subject
	// column, the second one the name of the response column. 
	// If these two are empty, then it is not any of the two repeated measurement
	// cases (subject column is relevant only if it is a repeated measurements case).
	char	szSubjectColumnName[TW_COLUMN_NAME_SIZE];		// multiple of 8
	char	szResponseColumnName[TW_COLUMN_NAME_SIZE];		// multiple of 8
	/// ML v4.08 4/17/96 STORE_THE_NAME_OF_THE_SECOND_FACTOR_COLUMN
	// We need to store the name of the second factor column so that we can 
	// know those names when transforming the worksheet in mark object
	char	szSecFactColumnName[TW_COLUMN_NAME_SIZE];
	/// end STORE_THE_NAME_OF_THE_SECOND_FACTOR_COLUMN
	DWORD	dwUnusedOne;
	DWORD	dwUnusedTwo;
	DWORD	dwUnusedThree;
	DWORD	dwUnusedFour;
	DWORD	dwUnusedFive;
	DWORD	dwUnusedSix;
	DWORD	dwUnusedSeven;
	DWORD	dwUnusedEight;
	/// end NAME_OF_SUBJECT_COLUMN_PLUS_ADDITIONAL_STILL_UNUSED_MEMBERS
} TWHEADER,	FAR *	LPTWHEADER;

// Total size of the memory that follows the header must be:
//         HIWORD(dwSizes) * ulNumLevsFirstWay + LOWORD(dwSizes) * ulNumLevsSecondWay + 
//			+ HIWORD(dwOnlyNumTextSize) * ulNumLevsFirstWay + 
//			+ LOWORD(dwOnlyNumTextSize) * ulNumLevsSecondWay + 
//			+ ulTotNumMasks * [ HIWORD(dwSizes) + LOWORD(dwSizes) ]
//	The first row stores the levels for both ways, while the second stores the
//	associations for each mask (starting with mask number 1).
//
//	The memory structure that follows the header looks like this:
//	1)	a series of ulNumLevsFirstWay elements of size HIWORD(dwSizes),
//	2)	a series of ulNumLevsSecondWay elements of size LOWORD(dwSizes),
//	3)	a series of ulNumLevsFirstWay elements of size HIWORD(dwOnlyNumTextSize)
//		(does not exist if the first way is textual).
//	4)	a series of ulNumLevsSecondWay elements of size LOWORD(dwOnlyNumTextSize)
//		(does not exist if the second way is textual).
//	5)	a series of ulTotNumMasks elements of the size [ HIWORD(dwSizes) + LOWORD(dwSizes) ].
//
// The purposes are the following:
//	1) and 2) store the levels for the first and second factor. If any of these factors
//				is numeric, they are stored as numbers (not text).
//	3) and 4) are used to store according to the numeric format
//				of the orginal column the numeric levels (they do not exist for textual).
//	5) stores the mask associations (beginning with the mask number one).
//

/// end TO_PROVIDE_COMMUNICATION_WITH_LABMASK
///sth v4.08 4/8/96 DOUBLE_ANOVA_WKS
#define TWH_TWO_ANOVA_ARRANGED	2
///end DOUBLE_ANOVA_WKS




/// ML 4/20/96 ONE_WAY_MEMORY_OBJECT_FOR_ONEWAY_REPEATED_MEASUREMENT_PURPOSES 
#define		OW_COLUMN_NAME_SIZE		TW_COLUMN_NAME_SIZE
#define		ONEWAYMEMOBJNAME		"_OWY"

typedef	struct	tagOWHEADER {
	ULONG		ulSizeOfThisHeader;		
	DWORD		dwKindOfWorksheet;	// 0 for the original worksheet (with masks set), 1 for fully extracted
	DWORD		dwNumLevels;
	DWORD		dwUnused;
	char		szSubjectColumnName[OW_COLUMN_NAME_SIZE];		// multiple of 8
	char		szResponseColumnName[OW_COLUMN_NAME_SIZE];		// multiple of 8
	DWORD		dwUnusedOne;
	DWORD		dwUnusedTwo;
} OWHEADER, FAR	*LPOWHEADER;
/// end ONE_WAY_MEMORY_OBJECT_FOR_ONEWAY_REPEATED_MEASUREMENT_PURPOSES



#endif	// ORG_DATA_MASK
*/

///JLIU nad DSC v4.982 5/7/97 MOVE_FROM_ORGDLL_TO_MODLL for the ati modll
///#ifdef		POWER_STAT
///	#include	"psdll.h"
///#endif
///	end MOVE_FROM_ORGDLL_TO_MODLL


/// end MOVED_TO_PSDLL_H





///CPY v4.10 6/11/96 WKS_DLL_MODI_ADD_CALLBACK, add last argument as lpCallBack, define this as a separate one for used in Origin
#define	ORG_WKS_DLL_MODI_PARAMS						HWND hWnd,UINT msg,LONG nParam,DWORD lParam
///CPY v4.10 6/10/96 WKS_DLL_MODIFICATION_SUPPORT
/// DLL export this function as ORDINAL number 30
#define	WKS_DLL_MODI_PARAMS							ORG_WKS_DLL_MODI_PARAMS, LPCALLBK lpOriginCallBack						
typedef DWORD (CALLBACK* O_WKS_DLL_MODI)(WKS_DLL_MODI_PARAMS);
///hWnd=wks window for all messages
/// messages are defined as

	/// All the messages should return this if no handling:
	#define	DLL_DID_NOT_HANDLE		0xEDCBABCD


	#define WDM_BEGIN		0x1000				/// nParam=0, lParam = (LPSTR) wksName, return 0 if OK, DLL_DID_NOT_HANDLE if no handling
	#define	WDM_END			(WDM_BEGIN + 1)		/// nParam=lParam=0, hWnd=wks window, return 0 if OK, 1 if error 
	
	
	#define	WDM_START_MSG				0x0100
	#define	WDM_GET_CELL_COLOR_INDEX	(WDM_START_MSG + 1) 
	/// lParam = lpLong is pointer to two LONGs:
	///////  lpLong[0] = col number, 1,2,3,..., lpLong[1] =row num. = 0,1,2,..., 
	//  lpLong[0] = col number, 0,1,2,3,..., lpLong[1] =row num. = 0,1,2,...,  // ML v4.11 7/8/96 CHANGE_OFFSET (only comment changes)
	// nParam shoould contain the color number which needs to be skipped
	// return color index :0,1,2,.., or -1 for the particular cell not to be colored
	// WDM_WILL_COLOR should be sent first to see if the DLL will
	// bother to color at all.
	
	#define	WDM_WILL_COLOR				(WDM_START_MSG + 2)
	// returns FALSE if nothing colored
	
	#define	WDM_COLUMN_DLG				(WDM_START_MSG + 3)		
	// when doubleclicking on a column header. nParam = col. number 1-offset
	///CPY: lParam contains the Origin instance handle HINSTANCE
	// returns DLL_DID_NOT_HANDLE to indicate proceeding as usual
	// 0 if handled.
	
	/// more messages are defined with base id + n
/// end WKS_DLL_MODIFICATION_SUPPORT


/// ML v4.133 9/24/96 EXE_CALLING_DLL_FOR_GRAPH 
#ifdef		EXE_CALLING_DLL_FOR_GRAPH
	#define	ORG_GRAPH_DLL_ACCESS_PARAMS						HWND hWnd, UINT msg, DWORD dwParam, LPARAM lParam
	#define	GRAPH_DLL_ACCESS_PARAMS							ORG_GRAPH_DLL_ACCESS_PARAMS, LPCALLBK lpOriginCallBack

	// the function must be exported at ID_EXPORT_GRAPH_ACCESS:						
	typedef DWORD (CALLBACK* O_GRAPH_DLL_ACCESS)(GRAPH_DLL_ACCESS_PARAMS);

	// Possible values of msg: 
	#define		GDA_MESSAGE_START		1
	enum {
		GDA_BOXCHARTS_ETC = GDA_MESSAGE_START, 
		/// ML v4.133 9/27/96 IDS_OF_BASIC_POWERSTAT_METHODS
		GDA_GET_METHOD_TEMPL_SUBDIR,
		/// end IDS_OF_BASIC_POWERSTAT_METHODS
	};

///  YN  11/18/96  ADD_CONDITIONAL_COMPILATION
#else		// ! EXE_CALLING_DLL_FOR_GRAPH
	#define	ORG_GRAPH_DLL_ACCESS_PARAMS						
	#define	GRAPH_DLL_ACCESS_PARAMS							
///  end  ADD_CONDITIONAL_COMPILATION
#endif		// EXE_CALLING_DLL_FOR_GRAPH
/// end EXE_CALLING_DLL_FOR_GRAPH 


/// ML 7/20/98 SCRIPT_RESOURCE_DLL_DIALOGS
#ifdef SCRIPT_RESOURCE_DLL_DIALOGS /// added by CPY 8/11/98
typedef double FAR *LPDOUBLE;///CPY 4/19/99 added for compile release problem
/// ML 4/19/99 t4345 ADDING_SUPPORT_FOR_SCRIPT_BASED_RESOURCE_DLLS
//#define		ORESPRDLLENTRYARGUMENTS		DWORD dwMsg, LPSTR lpszFirst, LPSTR lpszSecond, LPSTR lpszThird, LPSTR lpszArg, LPDOUBLE lpValue

// dwCtrl: 
#define				OKSCRIPTRESDLL_EXECUTE					1UL 
#define				OKSCRIPTRESDLL_UNINIT					2UL 
#define				OKSCRIPTRESDLL_SET_CALLBACK				3UL 
#define				OKSCRIPTRESDLL_SET_TEXTCALLBACK			4UL 
#define				OKSCRIPTRESDLL_OBJEXECUTE				5UL 
#define		ORESPRDLLENTRYARGUMENTS		DWORD dwCtrl, DWORD dwMsg, LPSTR lpszFirst, LPSTR lpszSecond, LPSTR lpszThird, LPSTR lpszArg, LPDOUBLE lpValue	
/// end ADDING_SUPPORT_FOR_SCRIPT_BASED_RESOURCE_DLLS
typedef	LONG	(WINAPI	*PFNORESPRDLL)(ORESPRDLLENTRYARGUMENTS);

#endif //SCRIPT_RESOURCE_DLL_DIALOGS

/// end SCRIPT_RESOURCE_DLL_DIALOGS


/// DSB v3.980 12/15/95 TITLE_DEFS
#define ORIGIN_EXE_TITLE	"ORIGIN40.EXE"
#define LABENG_DLL_TITLE	"LABENG40.DLL" 
/// End TITLE_DEFS

///sth v4.982 b2083 5/7/97 RIGHT_MOUSE_DOWN_CODE_BLOCK
#define SM_WPARAM_DO_NOT_PROCESS_LBUP_SCRIPT	99
///end RIGHT_MOUSE_DOWN_CODE_BLOCK

///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
#ifdef	__cplusplus
} /* end of __cplusplus */
#endif




/////////////////////////////////////////////////////////////////////////////////
#endif //#ifndef _ORGDLL_H
