/*------------------------------------------------------------------------------*
 *	File Name: 	MOCAMatrix.h													*
 *	Purpose:	Microcal Origin Matrix classes									*
 *  Creation:	by Dr. C. P. Yang, 6/13/95(Version for New Moca TD 3/24/2000)	* 
 *  	Copyright Microcal Software Inc. 1995, 2000								*
 *	Modification log                                                            *
 *	CPY v6.0297 t8155 7/5/00 FASTER_DATASET_ACCESS_FROM_MOCA					*
 *		I have also changed indexing into UINT for all functions relevant		*
 *	EJP 10-05-2000 v6.1056 MATRIX_SETVAL_DOUBLE_OVERLOAD_TOO_SIMILAR			*
 *	TCZ	8/21/2001 t9451   XY_RANGE_OF_MATRIX									*
 *	CPY v6.9139 11/29/01 t9756 MATRIX_FROM_LAYER								*
 *	YuI 4/16/02 QA70-1478 v7.0281 MULTIFRAME_TIFF_IMPORT						*
 *------------------------------------------------------------------------------*/

#ifndef	_MOCAMATRIX_H                                                
#define	_MOCAMATRIX_H

///DEFINE_MIN_MVALUE 


#include "mocadataset.h"  

#define MIN_MVALUE     		1E-15
#define X_EQUAL				0x0010
#define Y_EQUAL				0x0020
#define X_SOURCE			0
#define Y_SOURCE			1
#define Z_SOURCE			2

/////////////////////////////////////////////////////////////////////////////
//
//	MoMatrix : Origin matrix representation class, data stored in Origin
//
/////////////////////////////////////////////////////////////////////////////
class MoMXmatrix;

class MoMatrix : public MoData
{
public:
	MoMatrix(LPCSTR name);

	MoMatrix(MODATAID mdID);	//CPY v6.9139 11/29/01 t9756 MATRIX_FROM_LAYER

    ~MoMatrix();
	
	double		val(UINT nr, UINT nc);
	double		operator ()(UINT nR, UINT nC);/// GetVal 
	UINT		nRows(); 
	UINT		nCols(); 
    WORD		GetOrder() {return m_order;}
    double 		GetxMin(); 
    double 		GetxMax();
    double 		GetyMin(); 
    double 		GetyMax(); 
    double		GetxDelta();
    double		GetyDelta();
///	TCZ	8/21/2001 t9451   XY_RANGE_OF_MATRIX
	BOOL        GetXYRange(LPDOUBLE Xy);
///	end  XY_RANGE_OF_MATRIX

	INT		GetInternalIndex(UINT nr, UINT nc);  // return -1 if bad index

	/// YuI 4/16/02 QA70-1478 v7.0281 MULTIFRAME_TIFF_IMPORT
	//int		SetDim(LPSTR name, UINT nR, UINT nC);
	//int		SetDim(UINT nR, UINT nC); 
	int		SetDim(LPSTR name, UINT nR, UINT nC, WORD wCntrl = 0);
	int		SetDim(UINT nR, UINT nC, WORD wCntrl = 0); 
	/// end MULTIFRAME_TIFF_IMPORT

	int		SetCol(UINT nC, MoData& data);  
	int		SetXY(LPDOUBLE lpd); // lpd points to MinX,MinY,MaxX,MaxY
	int		SetXY(LPSTR name, LPDOUBLE lpd);
	//-------- CPY 11-10-2001 v6.9122 IMAGE_IMOPRT_USE_POINTER_TO_MAKE_FASTER
	
	/// YuI 4/16/02 QA70-1478 v7.0281 MULTIFRAME_TIFF_IMPORT
	//BOOL	SetZRange(double z1, double z2, BOOL bRound = TRUE);
	//BOOL	GetZRange(double* pz1, double* pz2);
	BOOL	SetZRange(double z1, double z2, BOOL bRound = TRUE, int nIndex = 0);
	BOOL	GetZRange(double* pz1, double* pz2, int nIndex = 0);
	/// end MULTIFRAME_TIFF_IMPORT
	//-------- end 	CPY 11-10-2001 v6.9122 IMAGE_IMOPRT_USE_POINTER_TO_MAKE_FASTER
	int 	SetMinMax(UINT nRows, WORD cntrl, MoData& data);	
    int 	SetOrder(MoData& Data1,MoData& Data2);
	int		ReSetMinMax(UINT nRows, WORD cntrl,MoData& data, double dRes);
    int 	GetMatrixXY(LPDOUBLE Xy); 
    int 	SwapxMinMax();
    int 	SwapyMinMax();   
    int		numSets(long n);
    int		numPtsOneSet(long n);
    int 	GetxMinPos ();
	int  	GetyMinPos ();
	int 	GetxMaxPos ();
	int 	GetyMaxPos (); 
	int		GetInternalDataType(BOOL bFromOrigin=TRUE);
	int		IsError();
	//-------- CPY 11/12/01 v6.9122 MATRIX_IMPORT_AS_DATA_WHEN_VIEW_IMAGE
	//BOOL	SetInternalDataType(int iDataType);
	
	/// YuI 4/16/02 QA70-1478 v7.0281 MULTIFRAME_TIFF_IMPORT
	//BOOL	SetInternalDataType(int iDataType, BOOL bResetToViewData = TRUE);
	BOOL	SetInternalDataType(int iDataType, BOOL bResetToViewData = TRUE, BOOL bSynchronize = TRUE);
	BOOL	SwitchInternalDataType(int iDataType);
	BOOL	SetDataConverted(BOOL bOn, int nIndex);
	BOOL	IsDataConverted(int nIndex);
	/// end MULTIFRAME_TIFF_IMPORT

	//-------- end CPY 11/12/01 v6.9122 MATRIX_IMPORT_AS_DATA_WHEN_VIEW_IMAGE
	DWORD 	OriginMatrix(MOMSG msg, LPSTR lpstr, DWORD wParam = 0L);	 
	BOOL	IsValid();
    BOOL 	FallEqualCheck(long nRows,MoData& data, long* N, double approx, 
    					double aveStepSize, long* NumEq);
    BOOL 	FequalIncrement(long nRows,MoData& data, long* N, double approx, 
    					double avestepSize, long* NumInc);
    
	//------- CPY v6.0297 t8155 7/5/00 FASTER_DATASET_ACCESS_FROM_MOCA
    //virtual int SetVal(long nR,long nC, double& value);
	// these function does not check bounds

	/// EJP 10-05-2000 v6.1056 MATRIX_SETVAL_DOUBLE_OVERLOAD_TOO_SIMILAR
	/// So the compiler can distinguish between the two methods used for setting
	/// doubles we can not pass by value and reference.  We should instead pass
	/// by value and pointer.
	/// When setting a short, long, or float value using fast access we pass the
	/// value by value.  To be consistent when we set a double using fast access
	/// we should pass by value.
	///virtual int SetVal(UINT nR, UINT nC, double& value); // fast access, only works with numeric dataset
	///virtual int SetVal(UINT nR, UINT nC, double value);	// general notation, will work with Text Numeric
	virtual int SetVal(UINT nR, UINT nC, double *pvalue);	// general notation, will work with Text Numeric
	virtual int SetVal(UINT nR, UINT nC, double value);		// fast access, only works with numeric dataset
	/// end MATRIX_SETVAL_DOUBLE_OVERLOAD_TOO_SIMILAR

	virtual int SetVal(UINT nR, UINT nC, USHORT usValue);
	virtual int SetVal(UINT nR, UINT nC, short sValue);
	virtual int SetVal(UINT nR, UINT nC, long lValue);
	virtual int SetVal(UINT nR, UINT nC, float fValue);
	virtual int	GetVal(UINT nR, UINT nC);
	//------- end CPY v6.0297 t8155 7/5/00
		
	//--------- CPY v6.9121 11/10/01 SET_MATRIX_UNSIGNED
	//enum{IDT_DOUBLE, IDT_FLOAT, IDT_SHORT, IDT_LONG}; // Internal Data Types
	enum{IDT_DOUBLE, IDT_FLOAT, IDT_SHORT, IDT_LONG, IDT_CHAR,
		//---- the followings are not supported for matrix, but we need to keep there here for correct enum'
		IDT_TEXT, IDT_MIXED,
		//----
		IDT_BYTE, IDT_USHORT, IDT_ULONG,
	};
	//--------- end CPY v6.9121 11/10/01 SET_MATRIX_UNSIGNED

 

    
private:

	char			m_szMatrixName[NAME_SIZE];

	UINT			m_nRows;
	UINT			m_nCols;
	double 			m_xMin;
	double 			m_yMin;
	double 			m_xMax;
	double 			m_yMax;
    double 			m_xDelta; // For the XYZ2m routine
    double 			m_yDelta;  	             
	WORD 			m_order; 
    int 			m_numSets;
    int				m_numPtsOneSet;   

	int 			m_xMinPos;
	int  			m_yMinPos;
	int 			m_xMaxPos;
	int 			m_yMaxPos;
	//-------- CPY v6.0297 t8155 7/5/00 FASTER_DATASET_ACCESS_FROM_MOCA
	int				m_internalDataType; // need init from constructor
	//--------
///	TCZ	8/21/2001 t9451   XY_RANGE_OF_MATRIX
	BOOL        UpdateLocalXYRange(LPDOUBLE Xy);
///	end  XY_RANGE_OF_MATRIX
	
	//----CPY v6.9139 11/29/01 t9756 MATRIX_FROM_LAYER
	void			Init();
	//----
//---- CPY v7.0352 7/25/05933 QA70-2197 MATRIX_NO_UPDATE_FUNCTION_SIMILAR_TO_WKS
public:
	void			Reinit();
//---- end CPY v7.0352 7/25/05933 QA70-2197 MATRIX_NO_UPDATE_FUNCTION_SIMILAR_TO_WKS

};





#endif /// _MOCAMATRIX_H