/*------------------------------------------------------------------------------*
 *	File Name: 	omocadef.h														*
 *	Purpose:	Contains all the macro and the base defination for new MOCA		*
 *	Author:		TD																*
 *  Date:		3/16/2000														*
 *  Copyright Microcal Software Inc. 2000										*
 *																				*
 *	Modification log															*
 *	(Modification in this header are explained in the corresponding				*
 *   Source files to avoid readability problems for the users)					*
 *	TD 3/22/2000    ADD_SUPPORT_FOR_SUBOBJ_ARRAYS								*
 *  TD 6/9/2000		LABTALK_VARNAME_CHECK										*
 *  TD 7/19/2000	DEF_ONUNLOAD_FOR_MOCA_MAINOBJECT_FOR_SAFE_EXIT				*
 *  TD 7/19/2000	BORROWING_TABLES_FROM_SUBOJECT_SELECTED_DYNAMICALLY			*
 *------------------------------------------------------------------------------*/      

#ifndef _MOCADEF_H
#define	_MOCADEF_H
//===============================================================================

#include	"mocadll.h"
#include	"AFXTEMPL.H"
#include	"MOCADeclare.h"


#ifdef		_DEBUG
	#define			MOCA_DEBUG_MSG(_lpcszMsg)			//MessageBox(NULL, (_lpcszMsg), "MOCA Message", MB_OK);
#else		// !_DEBUG
	#define			MOCA_DEBUG_MSG(_lpcszMsg)
#endif		// !_DEBUG




#define		MOCA_ENTRY_POINT(_myMainObjClassName)\
	static	CMOCAObjBase *l_pMainObj = NULL;\
	\
void __MOCA_DELETE_TABLES()\
{\
	if(!l_pMainObj) \
	return;\
	else \
{\
		l_pMainObj->OnUnloadDLL();\
		l_pMainObj->ReleaseAllTables();\
		delete  l_pMainObj;\
		l_pMainObj=NULL; \
		return;\
}\
}\
\
extern "C" DWORD WINAPI MocaEntry( HWND hWnd,\
	LPSTR lpStr1,\
	LPSTR lpStr2,\
	LPMOREAL lpValue,\
	LPCALLBK lpProc,  MOMSG msg) \
	{\
	if (!l_pMainObj) {l_pMainObj = new _myMainObjClassName; if (!l_pMainObj) return EGOR_ERR;\
	else {l_pMainObj->InitAllTables();l_pMainObj->InitAllProps();} } \
	if(msg == EGO_UNINIT ){MOCA_CLEANUP  return EGOR_YES;}\
	return   l_pMainObj->ScriptEntry(hWnd,lpStr1,lpStr2,lpValue,lpProc,msg); \
}



//--------------------------------------------------------------------------------
//Useful Symbolic Constants
#define MAX_TOKEN_SIZE 3072


/////////////////////////////////////////////////////////////////////////////
//
//	MoTable	:	struct for value related table
//
/////////////////////////////////////////////////////////////////////////////


typedef		UINT	MOCASIG;

enum 
{
	// real (and int) properties:
	MOCASig_bpr = 1,		// BOOL (double&) for getting and BOOL (double) for setting

	// string properties:
	MOCASig_bpsz,			// BOOL (LPSTR) and BOOL (LPCSTR) 

	// individual values of real (and int) vectors:
	MOCASig_brvec,			// BOOL (double&, int) for getting (int index is zero-offset),
							// BOOL (double, int) for setting (int index is zero-offset),
							// BOOL (int&) for getting the vector size
							// BOOL (int) for setting the vector size
	
	// individual values of string vectors:
	MOCASig_bszvec,			// BOOL (LPSTR, int) for getting and setting (int index is zero-offset),
							// BOOL (int&) for getting the vector size
							// BOOL (int) for setting the vector size
							// BOOL (int&) for getting the vector size
							// BOOL (int) for setting the vector size

	// INTEGER_VALUES_SETTING_AND_GETTING
	MOCASig_bpn,			// BOOL (int&) for getting and BOOL (int) for setting

	// AUTO_INC_AND_DEC_INDEX_PROPERTIES
	MOCASig_bpIndex,		// BOOL (int&) for getting and BOOL (int) for setting
};
	




typedef	void (	CObject::*MOCA_PPROPFN)(void);

union	MOCAPropertyFunctions
{
	MOCA_PPROPFN		pfn;					// generic

	// specific type safe variants:
	BOOL	(	CObject::*pfn_pr)(double & lpValue);	// MOCASig_bpr	for getting
	BOOL	(	CObject::*pfn_r)(double lpValue);	// MOCASig_bpr	for setting
	
	BOOL	(	CObject::*pfn_pcsz)(LPCSTR lpValue);	// MOCASig_bpsz for setting
	BOOL	(	CObject::*pfn_psz)(LPSTR lpValue);		// MOCASig_bpsz for getting

	BOOL	(	CObject::*pfn_prvec)(double & lpValue, int);	// MOCASig_bvec	for getting individual value
	BOOL	(	CObject::*pfn_rvec)(double dValue, int);	// MOCASig_bvec	for setting individual value

	BOOL	(	CObject::*pfn_pcszvec)(LPCSTR lpValue, int);	// MOCASig_bszvec	for setting individual value
	BOOL	(	CObject::*pfn_pszvec)(LPSTR lpValue, int);	// MOCASig_bszvec	for getting individual value

	BOOL	(	CObject::*pfn_pivecsize)(int &);	// MOCASig_bvec	and MOCASig_bszvec for getting vector size
	BOOL	(	CObject::*pfn_ivecsize)(int);		// MOCASig_bvec	and MOCASig_bszvec for setting vector size

	BOOL	(	CObject::*pfn_pn)(int &);			// MOCASig_bpn	for getting
	BOOL	(	CObject::*pfn_n)(int);				// MOCASig_bpn	for setting
};



//--------------------------------------------------------------------------
// MOCATABLE
//
//--------------------------------------------------------------------------

class CMOCAObjBase; 



typedef struct MOCATable
{
	CMOCAObjBase	*pObj;
	char			*pstr;
	MOCASIG			theSig;			// describes the property			
	MOCA_PPROPFN	pfnGet;			
	MOCA_PPROPFN	pfnSet;
	MOCA_PPROPFN	pfnGetEx;		// used to get 
	MOCA_PPROPFN	pfnSetEx;		// and set vector sizes
	double			dDefaultValue;

} MOCATABLE, *LPMOCATABLE;


///  KERNEL_ID_MAPS
typedef	const	MOCATABLE	*LPCMOCATABLE;



//================================================================================

typedef	MOCATABLE	MOCATABLEENTRY;
typedef const MOCATABLEENTRY *LPCMOCATABLEENTRY;
typedef MOCATABLEENTRY *LPMOCATABLEENTRY;

//THE MACROS
#define MOCA_DECLARE_DYNAMIC(_theClass)									DECLARE_DYNAMIC(_theClass)
#define MOCA_IMPLEMENT_DYNAMIC(_theClass, _theBaseClass)				IMPLEMENT_DYNAMIC(_theClass, _theBaseClass)

//////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////MACROS FOR  PROPERTIES----
//////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////

#define		MOCA_PROP_LAST_ENTRY							{ NULL, NULL, 0, NULL, NULL, NULL, NULL }



/////////////////////////////////////////
#define		MOCA_DECLARE_PROP_MAP(_theClass)	\
				private: LPMOCATABLEENTRY m_lpPropertyMap;\
				private: LPMOCATABLEENTRY m_lpSubObjectMap;	  \
				private: LPMOCATABLEENTRY m_lpMethodFnMap;	  \
				LPCMOCATABLEENTRY		GetPropertyMap();\
				LPCMOCATABLEENTRY		GetSubObjectMap();\
				LPCMOCATABLEENTRY		GetMethodsMap();\
				protected: BOOL	InitPropertyTable();\
				protected: BOOL	InitPropDef();\
				protected: BOOL ReleasePropTable();\
				protected: BOOL ListTable(LPCSTR lpcszPrefix);\
				protected: LPCMOCATABLEENTRY	FindPropertyEntry(LPSTR lpcszSubObjectName, LPCSTR lpcszName, CMOCAObjBase **ppEntryOwner, int nSearchEntryFlag);\
				protected: LPCMOCATABLEENTRY	FindMethodsEntry(LPSTR lpcszSubObjectName, LPCSTR lpcszName, CMOCAObjBase **ppEntryOwner, int nSearchEntryFlag);
///NOTE!!!!!!!!!!!!!! NOTE!!!!!!!!!!!!!!!!!!!!!!!!!!!!! NOTE!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//The current method will only work with subobjects PROVIDED one INITIALIZES the proprty table first
//This is absolutely necessry. The REASON is that Initpropertytable initiates the subobject table to NULL, 
//WITHOUT performing any checks.  Also if all one wants is just subobjects (or METHODS)one needs to 
//declare an empty property table.  
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 

#define		MOCA_BEGIN_PROP_MAP(_theClass, _theBaseClass)	\
	LPCMOCATABLEENTRY	_theClass::GetPropertyMap() { return  m_lpPropertyMap; } \
	LPCMOCATABLEENTRY	_theClass::GetSubObjectMap() { return  m_lpSubObjectMap; } \
	LPCMOCATABLEENTRY	_theClass::GetMethodsMap() { return  m_lpMethodFnMap; } \
	LPCMOCATABLEENTRY	_theClass::FindPropertyEntry(LPSTR lpszSubObjectName, LPCSTR lpcszName, CMOCAObjBase **ppEntryOwner, int nSearchEntryFlag) { LPCMOCATABLEENTRY lpcTable = GetPropertyMap(); \
	if ( NULL != (lpcTable = FindMapEntryInTable(lpszSubObjectName, lpcszName, lpcTable, (GetSubObjectMap()), ppEntryOwner, PROP_SEARCH_FLAG, nSearchEntryFlag)) ) return lpcTable;\
	return _theBaseClass::FindPropertyEntry(lpszSubObjectName, lpcszName, ppEntryOwner, nSearchEntryFlag); } \
	LPCMOCATABLEENTRY	_theClass::FindMethodsEntry(LPSTR lpszSubObjectName, LPCSTR lpcszName, CMOCAObjBase **ppEntryOwner, int nSearchEntryFlag) { LPCMOCATABLEENTRY lpcTable = _theClass::GetMethodsMap(); \
	if ( NULL != (lpcTable = FindMapEntryInTable(lpszSubObjectName, lpcszName, lpcTable, (GetSubObjectMap()), ppEntryOwner, METH_SEARCH_FLAG, nSearchEntryFlag)) ) return lpcTable;\
	return _theBaseClass::FindMethodsEntry(lpszSubObjectName, lpcszName, ppEntryOwner, nSearchEntryFlag); } \
	BOOL	_theClass::InitPropertyTable() {\
			m_lpSubObjectMap = NULL;		\
			m_lpMethodFnMap  = NULL;		\
			MOCATABLEENTRY _PropertyTable[] = {


#define		MOCA_END_PROP_MAP(_theClass, _theBaseClass)			MOCA_PROP_LAST_ENTRY };\
						   m_lpPropertyMap = MocaCopyTable((LPCMOCATABLEENTRY)_PropertyTable); \
						   return _theBaseClass::InitPropertyTable();}\
							BOOL _theClass::ReleasePropTable(){	if (m_lpPropertyMap != NULL)\
							{MocaReleaseTable(m_lpPropertyMap); m_lpPropertyMap = NULL;}\
							if (m_lpMethodFnMap != NULL)\
							{MocaReleaseTable(m_lpMethodFnMap); m_lpMethodFnMap = NULL;}\
							if (NULL != GetSubObjectMap()) ReleaseSubObjectTable();\
							return _theBaseClass::ReleasePropTable();}\
							BOOL _theClass::InitPropDef(){if (MocaInitPropDef(GetPropertyMap()) && MocaInitSubPropDef(GetSubObjectMap())) \
							return _theBaseClass::InitPropDef(); else return FALSE;}\
							BOOL _theClass::ListTable(LPCSTR lpcszPrefix){ if (ListProperties(lpcszPrefix, GetPropertyMap())  &&  ListMethods(lpcszPrefix, _theClass::GetMethodsMap())){\
							if (ListSubObjects(lpcszPrefix, GetSubObjectMap())){ return _theBaseClass::ListTable(lpcszPrefix);}\
							else return FALSE; } else return FALSE; return TRUE;}

							
//////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////MACROS FOR  SUBOBJECTS---- NOTE SUBOBJECTS TABLE AND GET SUBOBJECTS ARE DEFINED IN THE
////////////////PROPERTIES TABLE MACROS///////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////
#define		MOCA_DECLARE_SUBOBJ_MAP(_theClass)	\
				protected: BOOL InitSubObjects();\
				protected: BOOL	InitSubObjectTable();\
				protected: BOOL ReleaseSubObjectTable();\
				protected: CMOCAObjBase*	InitSubobjectPointer(LPCSTR lpcszSubObjName);

#define		MOCA_BEGIN_SUBOBJ_MAP(_theClass, _theBaseClass)	\
	BOOL	_theClass::InitSubObjectTable() {\
			MOCATABLEENTRY _SubObjectTable[] = {


#define		MOCA_END_SUBOBJ_MAP(_theClass, _theBaseClass)		MOCA_PROP_LAST_ENTRY };\
						   m_lpSubObjectMap = MocaCopyTable((LPCMOCATABLEENTRY)_SubObjectTable); \
						   return _theBaseClass::InitSubObjectTable();}\
						   BOOL _theClass::InitSubObjects() \
							{InitSubObjectsInTable(GetSubObjectMap()); return _theBaseClass::InitSubObjects();}\
							BOOL _theClass::ReleaseSubObjectTable()\
							{ReleaseSubObjectsInTable(GetSubObjectMap());	MocaReleaseTable(m_lpSubObjectMap);\
							m_lpSubObjectMap = NULL; return TRUE;}\
							CMOCAObjBase* _theClass::InitSubobjectPointer(LPCSTR lpcszSubObjName)\
							{CMOCAObjBase* pObj =CreateSubobject(lpcszSubObjName); if(pObj){return pObj;}else\
							{ return  _theBaseClass::InitSubobjectPointer(lpcszSubObjName);}}




#define		MOCA_SUBOBJ_ENTRY(_subobj, _lpcszName) \
{(CMOCAObjBase *)&_subobj, _lpcszName, 0, NULL, NULL, NULL, NULL, (double)1.0 },

#define		MOCA_SUBOBJ_POINTER_ENTRY(_subobj, _lpcszName) \
{(CMOCAObjBase *)_subobj, _lpcszName, 0, NULL, NULL, NULL, NULL, (double)0.0 },

// *	TD 3/22/2000    ADD_SUPPORT_FOR_SUBOBJ_ARRAYS							*

typedef	CTypedPtrArray<CObArray, CMOCAObjBase*>	CMOCAObjBaseArray;

#define		MOCA_SUBOBJ_ARRAY_ENTRY(_subobj, _lpcszName) \
{(CMOCAObjBase *)&(_subobj), (_lpcszName), 0, NULL, NULL, NULL, NULL, (double)(-1.0) },

// END:	TD 3/22/2000    ADD_SUPPORT_FOR_SUBOBJ_ARRAYS							*


/////////////////////////////////////////////////////////////////////////////////////////////
////////////MACROS FOR METHODS - THE FOLLOWING  ENTRIES DEFINE THE METHOD ENTRIES IN MOCATABLE
////////////AND THE FUNCTION TYPES USED FOR HANDLING METHODS////////////////////////////////
////////////METHODFN TAKES TWO ARGUMENTS A STRING AND A REAL THAT IS RETURNED WHEN CALLED///
////////////MORETURN ( CObject::*MOCA_METHODFN)(LPMOREAL lpValue, LPOKSTR lpstrArg)
//////////////////////////////////////////////////////////////////////////////////////////////

//#define		MOCA_METH_ENTRY(lpfn, lpszString) {NULL, lpszString, NULL, (MOCA_PPROPFN)(MORETURN ( CObject::*)(LPOKSTR lpnValue))lpfn, (MOCA_PPROPFN)NULL, NULL, NULL, (double)0.0},
#define		MOCA_METH_ENTRY(lpfn, lpszString) {NULL, lpszString, NULL, (MOCA_PPROPFN)(BOOL ( CObject::*)(LPSTR lpnValue))lpfn, (MOCA_PPROPFN)NULL, NULL, NULL, (double)0.0},
//MOCA_STR_METH_ENTRY is a method entry stores a function pointer to  MOCA_STR_METHODFN
#define		MOCA_STR_METH_ENTRY(lpfn, lpszString) {NULL, lpszString, NULL, (MOCA_PPROPFN)(BOOL ( CObject::*)(LPSTR lpnValue))lpfn, (MOCA_PPROPFN)NULL, NULL, NULL, (double)1},

//typedef MORETURN ( CObject::*MOCA_METHODFN)(LPMOREAL lpValue, LPOKSTR lpstrArg);
//typedef MORETURN ( CObject::*MOCA_METHODFN)(LPMOREAL lpValue, CStringArray &argarray);
//
//#define		MOCA_METHENTRY_TO_FUNC(_lpEntry)	((MOCA_METHODFN)((_lpEntry)->pfnGet))

//typedef MORETURN ( CObject::*MOCA_METHODFN)(LPMOREAL lpValue, LPOKSTR lpstrArg);
typedef BOOL ( CObject::*MOCA_METHODFN)(double & rValue, CStringArray &argarray);
//MOCA_STR_METHODFN is pointer to a function which returns string values to origin 
typedef BOOL ( CObject::*MOCA_STR_METHODFN)(LPTSTR lpszBuffer, CStringArray &argarray);



//////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////MACROS FOR  METHODS---- NOTE METHODS TABLE AND GET METHODS ARE DEFINED IN THE
////////////////PROPERTIES TABLE MACROS///////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////

#define		MOCA_DECLARE_METH_MAP(_theClass)\
				protected: BOOL	InitMethodsTable();


#define		MOCA_BEGIN_METH_MAP(_theClass, _theBaseClass)	\
	BOOL	_theClass::InitMethodsTable() {\
	MOCATABLEENTRY _MethodsTable[] = {


#define		MOCA_END_METH_MAP(_theClass, _theBaseClass)		MOCA_PROP_LAST_ENTRY };\
						   m_lpMethodFnMap = MocaCopyTable((LPCMOCATABLEENTRY)_MethodsTable);\
						   return _theBaseClass::InitMethodsTable();}


/////////////////////////////////////////////////////////////////////////////////////////////
////////////MACROS FOR SIMPLE PROPERTIES - THE FOLLOWING  ENTRIES DEFINE THE SIMPLE PROPERTIES ENTRIES IN MOCATABLE
////////////AND THE VARIABLE TYPES USED FOR HANDLING THOSE SIMPLE PROPERTIES////////////////////////////////
////////////SIMPLE PROPERTIES ACCEPTS ONE ARGUMENTS OF TYPES DOUBLE, INT OR CSTRING AND CAN BE OF///
////////////MORETURN ( CObject::*MOCA_METHODFN)(LPMOREAL lpValue, LPOKSTR lpstrArg)
//////////////////////////////////////////////////////////////////////////////////////////////

enum
{
	//int unprotected
	MOCASig_SP_iu = 11,
	//int protected
	MOCASig_SP_ip = 12,
	//double unprotected
	MOCASig_SP_du = 13,
	//double protected
	MOCASig_SP_dp = 14,
	//CString unprotected
	MOCASig_SP_lpszu = 15,
	//CString protected
	MOCASig_SP_lpszp = 16,
	//Cstring Array Unprotected
	MOCASig_SP_lpszaru = 17,
	//CString Array  protected
	MOCASig_SP_lpszarp = 18
};

#define		MOCA_SIMPLE_PROP_ENTRY(_var, _lpszString, _Sig)		{(CMOCAObjBase *)&(_var), (char *)_lpszString, (MOCASIG)_Sig, (MOCA_PPROPFN)NULL, (MOCA_PPROPFN)NULL, (MOCA_PPROPFN)NULL, (MOCA_PPROPFN)NULL, (double)0.0},

#define		MOCA_SIMPLE_PROP_INT(_var, _lpszString)				MOCA_SIMPLE_PROP_ENTRY(_var, _lpszString, MOCASig_SP_iu) 
#define		MOCA_SIMPLE_PROP_REAL(_var, _lpszString)			MOCA_SIMPLE_PROP_ENTRY(_var, _lpszString, MOCASig_SP_du) 
#define		MOCA_SIMPLE_PROP_STR(_var, _lpszString)				MOCA_SIMPLE_PROP_ENTRY(_var, _lpszString, MOCASig_SP_lpszu) 
#define		MOCA_SIMPLE_PROP_STR_ARRAY(_var, _lpszString)		MOCA_SIMPLE_PROP_ENTRY(_var, _lpszString, MOCASig_SP_lpszaru) 
#define		MOCA_SIMPLE_PROP_INT_GET(_var, _lpszString)			MOCA_SIMPLE_PROP_ENTRY(_var, _lpszString, MOCASig_SP_ip) 
#define		MOCA_SIMPLE_PROP_REAL_GET(_var, _lpszString)		MOCA_SIMPLE_PROP_ENTRY(_var, _lpszString, MOCASig_SP_dp) 
#define		MOCA_SIMPLE_PROP_STR_GET(_var, _lpszString)			MOCA_SIMPLE_PROP_ENTRY(_var, _lpszString, MOCASig_SP_lpszp) 
#define		MOCA_SIMPLE_PROP_STR_ARRAY_GET(_var, _lpszString)	MOCA_SIMPLE_PROP_ENTRY(_var, _lpszString, MOCASig_SP_lpszarp) 

#define		MOCA_SIMPLE_PROP_INT_DEF(_var, _lpszString, _defVal)		{(CMOCAObjBase *)&(_var), _lpszString, MOCASig_SP_iu,		NULL, NULL, NULL, (MOCA_PPROPFN)(BOOL	( CObject::*)(int))DummyDefault, (double)_defVal}, 
#define		MOCA_SIMPLE_PROP_REAL_DEF(_var, _lpszString, _defVal)		{(CMOCAObjBase *)&(_var), _lpszString, MOCASig_SP_du,		NULL, NULL, NULL, (MOCA_PPROPFN)(BOOL	( CObject::*)(int))DummyDefault, (double)_defVal}, 
#define		MOCA_SIMPLE_PROP_STR_DEF(_var, _lpszString, _defVal)		{(CMOCAObjBase *)&(_var), _lpszString, MOCASig_SP_lpszu,	NULL, NULL, NULL, (MOCA_PPROPFN)(BOOL	( CObject::*)(int))DummyDefault, (double)(DWORD)(LPCSTR)_defVal},
#define		MOCA_SIMPLE_PROP_INT_GET_DEF(_var, _lpszString, _defVal)	{(CMOCAObjBase *)&(_var), _lpszString, MOCASig_SP_ip,		NULL, NULL, NULL, (MOCA_PPROPFN)(BOOL	( CObject::*)(int))DummyDefault, (double)_defVal}, 
#define		MOCA_SIMPLE_PROP_REAL_GET_DEF(_var, _lpszString, _defVal)	{(CMOCAObjBase *)&(_var), _lpszString, MOCASig_SP_dp,		NULL, NULL, NULL, (MOCA_PPROPFN)(BOOL	( CObject::*)(int))DummyDefault, (double)_defVal},
#define		MOCA_SIMPLE_PROP_STR_GET_DEF(_var, _lpszString, _defVal)	{(CMOCAObjBase *)&(_var), _lpszString, MOCASig_SP_lpszp,	NULL, NULL, NULL, (MOCA_PPROPFN)(BOOL	( CObject::*)(int))DummyDefault, (double)(DWORD)(LPCSTR)_defVal}, 


/////////////////////////////////////////////////////////////////////////////////////////////////
/////BEGIN_MOCA_TABLE_ENTRIES_REDEFINED_FROM_ODLL
//--------------------------------------------------------------------------
// MOCA_PROP_REAL:
//--------------------------------------------------------------------------

#define MOCA_PROP_REAL_DEF(lpfnGet, lpfnSet, lpszString, dDefValue) \
{NULL, lpszString, MOCASig_bpr, (MOCA_PPROPFN)(BOOL ( CObject::*)(double & lpValue))lpfnGet, (MOCA_PPROPFN)(BOOL ( CObject::*)(double dValue))lpfnSet, NULL, (MOCA_PPROPFN)(BOOL	( CObject::*)(int))DummyDefault, dDefValue },

#define MOCA_PROP_REAL(lpfnGet, lpfnSet, lpszString) \
{NULL, lpszString, MOCASig_bpr, (MOCA_PPROPFN)(BOOL ( CObject::*)(double & lpValue))lpfnGet, (MOCA_PPROPFN)(BOOL ( CObject::*)(double dValue))lpfnSet, NULL, NULL, (double)0.0 },
		
#define		MOCA_PROP_REAL_GET(lpfnGet, lpszString)				MOCA_PROP_REAL(lpfnGet, NULL, lpszString)

//--------------------------------------------------------------------------
//	MOCA_PROP_INT:
//--------------------------------------------------------------------------

#define MOCA_PROP_INT_DEF(lpfnGet, lpfnSet, lpszString, nDefValue) \
{NULL, lpszString, MOCASig_bpn, (MOCA_PPROPFN)(BOOL ( CObject::*)(int & lpnValue))lpfnGet, (MOCA_PPROPFN)(BOOL ( CObject::*)(int nValue))lpfnSet, NULL, (MOCA_PPROPFN)(BOOL	( CObject::*)(int))DummyDefault, (double)nDefValue },

#define MOCA_PROP_INT(lpfnGet, lpfnSet, lpszString) \
{NULL, lpszString, MOCASig_bpn, (MOCA_PPROPFN)(BOOL ( CObject::*)(int & lpnValue))lpfnGet, (MOCA_PPROPFN)(BOOL ( CObject::*)(int nValue))lpfnSet, NULL, NULL, (double)0.0 },

#define		MOCA_PROP_INT_GET(lpfnGet, lpszString)				MOCA_PROP_INT(lpfnGet, NULL, lpszString)
/// end INTEGER_VALUES_SETTING_AND_GETTING



//--------------------------------------------------------------------------
//	MOCA_PROP_STR:
//--------------------------------------------------------------------------
#define MOCA_PROP_STR_DEF(lpfnGet, lpfnSet, lpszString, lpcstrDefValue) \
{NULL, lpszString, MOCASig_bpsz, (MOCA_PPROPFN)(BOOL ( CObject::*)(LPSTR lpValue))lpfnGet, (MOCA_PPROPFN)(BOOL ( CObject::*)(LPCSTR lpValue))lpfnSet, NULL, (MOCA_PPROPFN)(BOOL	( CObject::*)(int))DummyDefault, (double)(DWORD)(LPCSTR)lpcstrDefValue },

#define MOCA_PROP_STR(lpfnGet, lpfnSet, lpszString) \
{NULL, lpszString, MOCASig_bpsz, (MOCA_PPROPFN)(BOOL ( CObject::*)(LPSTR lpValue))lpfnGet, (MOCA_PPROPFN)(BOOL ( CObject::*)(LPCSTR lpValue))lpfnSet, NULL, NULL, (double)0.0},

#define		MOCA_PROP_STR_GET(lpfnGet, lpszString)			MOCA_PROP_STR(lpfnGet, NULL, lpszString)


//--------------------------------------------------------------------------
//	MOCA_PROP_?_VECTOR:
//--------------------------------------------------------------------------
// vectors:
#define		MOCA_PROP_REAL_VECTOR(lpfnGet, lpfnSet, lpfnGetSize, lpfnSetSize, lpszString)	{ NULL,\
																								lpszString,\
																								MOCASig_brvec,\
																								(MOCA_PPROPFN)(BOOL	( CObject::*)(double & lpValue, int))lpfnGet,\
																								(MOCA_PPROPFN)(BOOL	( CObject::*)(double dValue, int))lpfnSet,\
																								(MOCA_PPROPFN)(BOOL	( CObject::*)(int &))lpfnGetSize,\
																								(MOCA_PPROPFN)(BOOL	( CObject::*)(int))lpfnSetSize,\
																								},    

#define		MOCA_PROP_REAL_VECTOR_GET(lpfnGet, lpfnGetSize, lpszString)		MOCA_PROP_REAL_VECTOR(lpfnGet, NULL, lpfnGetSize, NULL, lpszString)

#define		MOCA_PROP_STR_VECTOR(lpfnGet, lpfnSet, lpfnGetSize, lpfnSetSize, lpszString)	{ NULL,\
																								lpszString,\
																								MOCASig_bszvec,\
																								(MOCA_PPROPFN)(BOOL	( CObject::*)(LPSTR lpValue, int))lpfnGet,\
																								(MOCA_PPROPFN)(BOOL	( CObject::*)(LPCSTR lpValue, int))lpfnSet,\
																								(MOCA_PPROPFN)(BOOL	( CObject::*)(int &))lpfnGetSize,\
																								(MOCA_PPROPFN)(BOOL	( CObject::*)(int))lpfnSetSize,\
																								},    

#define		MOCA_PROP_STR_VECTOR_GET(lpfnGet, lpfnGetSize, lpszString)		MOCA_PROP_STR_VECTOR(lpfnGet, NULL, lpfnGetSize, NULL, lpszString)

/////////////////////////////////////////////////////////////////////////////////////////////////
/////END_MOCA_TABLE_ENTRIES_REDEFINED_FROM_ODLL


//#define		MOCAENTRY_SUBOBJ(_subobj, _lpcszName) \
//{&(_subobj), _lpcszName, 0, NULL, NULL, NULL, NULL, NULL },





			
class	MOCA_EXP_CLASS	CMOCAObjBase : public MOCAObj
{
	MOCA_DECLARE_DYNAMIC(CMOCAObjBase);
		
public:
	CMOCAObjBase();
	~CMOCAObjBase();

private:
	static LPCMOCATABLEENTRY		GetPropertyMap();
	static LPCMOCATABLEENTRY		GetSubObjectMap();
	
	BOOL						DoProperty(LPSTR lpStr1, LPSTR lpStr2, LPDOUBLE lpValue, MOMSG momsg);
	BOOL						DoMethod(LPSTR lpStr1, LPSTR lpStr2, LPMOREAL lpValue, int nMethEntryType, BOOL bPropAsMeth = FALSE);
	BOOL						InitiateListTable(LPSTR lpStr1);
	BOOL						Do_Simple_Properties(LPMOREAL lpValue, MOMSG momsg, LPCMOCATABLEENTRY	lpTheEntry, int index = -1);


protected:
	LPCMOCATABLEENTRY			FindMapEntryInTable(LPCSTR lpcszName, LPCMOCATABLEENTRY lpTable, int nSearchEntryFlag);
	LPCMOCATABLEENTRY			FindMapEntryInTable(LPSTR lpcszSubObjectName, LPCSTR lpcszName,
												  LPCMOCATABLEENTRY lpTable, LPCMOCATABLEENTRY lpSubObjTable,
												  CMOCAObjBase **ppEntryOwner, int iSearchTableFlag, int nSearchEntryFlag);
	LPMOCATABLEENTRY			MocaCopyTable(LPCMOCATABLEENTRY lpTable);
	void						MocaReleaseTable(LPMOCATABLEENTRY lpGlobalTable);

	BOOL						InitSubObjectsInTable(LPCMOCATABLEENTRY lpTable);
	virtual				BOOL	InitPropertyTable();
	virtual				BOOL	InitSubObjectTable();
	virtual				BOOL	InitSubObjects();
	virtual				BOOL	InitMethodsTable();
	virtual				BOOL	ListTable(LPCSTR lpcszPrefix);
	virtual				BOOL	ListMethods(LPCSTR  lpcszPrefix, LPCMOCATABLEENTRY lpPropTable);
	virtual				BOOL	ListProperties(LPCSTR  lpcszPrefix,	LPCMOCATABLEENTRY lpPropTable);
	virtual				BOOL	ListSubObjects(LPCSTR  lpcszPrefix, LPCMOCATABLEENTRY lpSubTable);
	virtual				BOOL	InitPropDef();
	virtual				BOOL	MocaInitPropDef(LPCMOCATABLEENTRY lpPropTable);
	virtual				BOOL	MocaInitSubPropDef(LPCMOCATABLEENTRY lpSubTable);
	virtual		CMOCAObjBase*	GetSpecialSubObjectPtr();

	void						DummyDefault();

protected:

	enum	{PROP_SEARCH_FLAG = 0,
			METH_SEARCH_FLAG  = 1};   

protected:

	/// TD 6/9/2000		LABTALK_VARNAME_CHECK
	static				int		m_nCheckNameFailedLevel;// (-1:no checking; 0:checking & success (> 0):failure level)
	CString						m_strTmpSubObjName;
	CString						m_strTmpName;
	/// end LABTALK_VARNAME_CHECK
	BOOL						ReleaseSubObjectsInTable(LPCMOCATABLEENTRY lpTable);
	virtual				BOOL	ReleasePropTable();
	virtual				BOOL	ReleaseSubObjectTable();
	/// Handling Runtime Overridable SubObject Allocation
	virtual		CMOCAObjBase*	InitSubobjectPointer(LPCSTR lpcszSubObjName);
	CMOCAObjBase*				CreateSubobject(LPCSTR	lpcszSubObjName);//Called First --Higher Presedence	, Automatically Calls Base class Functions for the ones not overriden in the derived class
	virtual				BOOL	InitAllocatedSubObjects();//Initializations thats needed from the parent objects -- call base class before or after or never depending on the situation

public:
	virtual		LPCMOCATABLEENTRY		FindPropertyEntry(LPSTR lpszSubObjectName, LPCSTR lpcszName, CMOCAObjBase **ppEntryOwner, int nSearchEntryFlag);
	virtual		LPCMOCATABLEENTRY		FindMethodsEntry(LPSTR lpszSubObjectName, LPCSTR lpcszName, CMOCAObjBase **ppEntryOwner, int nSearchEntryFlag);
	virtual		LPCMOCATABLEENTRY		LookUpSubObjectTables(CMOCAObjBase *pSubObj, LPSTR lpcszSubObjectName, LPCSTR lpcszName, int iSearchTableFlag, int nSearchEntryFlag, CMOCAObjBase	**ppEntryOwner); /// BORROWING_TABLES_FROM_SUBOJECT_SELECTED_DYNAMICALLY

	virtual		void					OnUnloadDLL(void);/// This Gets Called Only from the Main Object for Safe exit	DEF_ONUNLOAD_FOR_MOCA_MAINOBJECT_FOR_SAFE_EXIT

	MORETURN						ScriptEntry(HWND hWnd, LPSTR lpStr1, LPSTR lpStr2, LPMOREAL lpValue, LPCALLBK lpProc, WORD msg);

	BOOL							InitAllTables();
	BOOL							ReleaseAllTables();
	BOOL							InitAllProps();

};

// *	TD 3/22/2000    ADD_SUPPORT_FOR_SUBOBJ_ARRAYS							*

class  MOCA_EXP_CLASS	CMOCAAarray : public CMOCAObjBaseArray
{

public:

	CMOCAAarray();
	~CMOCAAarray();
public:
	BOOL	Cleanup();
	void RemoveAtDelete(int nIndex, int nCount = 1);
	void RemoveAt(int nIndex, int nCount = 1);
	void RemoveAll();
	void InsertAt(int nIndex, CMOCAObjBase* newElement, int nCount = 1);
	int Add(CMOCAObjBase* newElement);

};

// END:	TD 3/22/2000    ADD_SUPPORT_FOR_SUBOBJ_ARRAYS							*
//-------END OF FILE
#endif //_MOCADEF_H
