/*------------------------------------------------------------------------------*
 *	File Name: 	MOCADATA.h														*
 *	Purpose:	Microcal Origin dataset classes									*
 *  Creation:	by Dr. C. P. Yang, 5/1/95(Version for new MOCA: TD:3/24/2000)	* 
 *  	Copyright Microcal Software Inc. 1995, 2000								*
 *	Modification log															*
 *	CPY v6.0297 t8155 7/5/00 FASTER_DATASET_ACCESS_FROM_MOCA					*
 *	TD 4/3/01 t9034	OVECTOR_SUPPORT												*
 *	TD 5-16-01	MORE_ACCURATE_DATA_ACCESS_TO_ORIGINC							*
 *	TD 6-5-01  MODATA_FROM_MODATAID												*
 *	TD 6-18-01 MOCURVE_DERIVED_FROM_MODATA										*
 *	CPY 6/21/01 CURVE_OBJ_NEEDS_READ_PLOT_INFO									*
 *	TD 7-16-01 ADD_GETNAME_TO_DATASET											*
 *	TD 8-10-01 ORIGINC_DATAOBJECT_DESTRUCTOR_DO_NOT_UPDATEVALUE					*
 *	CPY 8/11/01 v6.9069 TEMP_DATASET_USE_NORMAL_NAME							*
 *	TD 8-24-01 NEW_TEMPORARY_CURVE_CLASS										*
 *	TD 10-29-01	CATEGORICAL_DATA												*
 *	CPY 11-10-2001 v6.9122 IMAGE_IMOPRT_USE_POINTER_TO_MAKE_FASTER				*
 *	LY	12/14/01 t9798 SERIESPTR_MANAGER										*
 *	TD 1-2-01 QA70-239 CURVE_CONSTRUCTION_FROM_WORKEHSEET_OBJECT				*
 *	TD 1-23-02 QA70-408 t6.9190 METHOD_UPDATE_FOR_DATA_WRPPERS_IN_ORIGIN_C		*
 *	TD 1-25-02 t9891 t6.9192 METHOD_CRATE_FOR_ODATA_TYPES						*
 *	TD 1-29-02 QA70-592 v6.9197 PROPER_HANDLING_OF_DATASET_RANGE_FROM_KERNEL	*
 *	TD 3-4-02 QA70-965 DATASET_APPEND_REFRESH_MODE								*
 *	TD 3-7-02 QA70-1082 v7.0237 TEMP_CURVE_FROM_YDATA_VALUE						*
 *	TD 3-19-02 WCB_TO_SET_IMAX_WITH_REDRAW_OPTIONS								*
 *	AW 06/06/02 QA70-1988 CONSTRUCT_FROM_DATAPLOT								*
 *	CPY v7.0352 7/25/02 QA70-2469 MATRX_DATA_CHANGE_MUST_UPDATE_Z_RANGE			*
 *	YuI 8/30/02 v7.0387 QA70-2841 LINKS_MANAGER_FOR_OBJECTS						*
 *	YuI 12/31/02 QA70-3592 v7.0477 ORIGIN_C_AND_INTERNAL_DATA_PROTECTION		*
 *	TD 4-25-03 QA70-4256 SOURCE_RANGE_IN_CURVEBASE								*
 *	YuI 5/05/03 v7.0578 QA70-4357 CURVE_AS_INPUT_OF_OPERATION					*
 *	ML 5/29/2003 QA70-4562 CURVE_EXTENSION_WITH_RELATED_DATASETS				*
 *	CPY 6/25/03 QA70-4712 v7.0610 CURVEBASE_HAS_X_SHOULD_RET_DATASET_NAME		*
 *	ML 8/8/2003 QA70-4980 MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC
 *	YuI 9/16/03 v7.5696 QA70-5184 CATEGORICAL_MAP_OC_COOKIE						*
 *------------------------------------------------------------------------------*/      

#ifndef	_MOCADATASET_H                                                
#define	_MOCADATASET_H

#include "mocadll.h"



///////////////////////////////////
///
///	MoData Error codes
///
///////////////////////////////////

#define	ERR_MODATA_INVALID			1000
#define	ERR_MODATA_TOO_FEW_PTS	    (ERR_MODATA_INVALID+1)
#define ERR_MODATA_OUT_OF_RANGE     (ERR_MODATA_INVALID+2)
#define ERR_MOERRDATA_BAR_ZERO      (ERR_MODATA_INVALID+3)
//-----------------------------------------------------------------------------

//LY	12/14/01 t9798 SERIESPTR_MANAGER
BOOL CALLBACK	MoDataCallback(DWORD dwID, DWORD dwMoData);
//end t9798 SERIESPTR_MANAGER

/////////////////////////////////////////////////////////////////////////////
//
//	MoData	:	Origin interface to Origin internal datasets
//	Baseclass for dataset access
//
/////////////////////////////////////////////////////////////////////////////


class		lrclass;

#define		OUTSIDE_DATARANGE(row)		(row < i1() || row >= i2())


class		MoOriginWks;
typedef		MoOriginWks	*MoOriginWksPtr;

class MoData : public MOCAOrigin
{
	// LY	12/14/01 t9798 SERIESPTR_MANAGER
	DECLARE_DYNAMIC(MoData);
	//end t9798 SERIESPTR_MANAGER
public:
	~MoData();/// need to check range change here
	MoData(const MoData &original);//TD 7-18-01 The copy constructor must be public

	/// ML 8/8/2003 QA70-4980 MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC
	enum InitType {
		InitType_datasetid				= 0,
		InitType_datasetname,
		InitType_wksname_colname,
		InitType_wksname_colnumber,
	};

	struct InitInfo {
		InitType			ntype;
		BOOL				bNoMarkerUse;

		union {
			LPCSTR			lpcszDatasetName;
			
			struct {
				LPCSTR		lpszWksName;
				LPCSTR		lpszColumnName;
			} stWksNameColName;
			
			struct {
				LPCSTR		lpszWksName;
				int			nColNumber;
			} stWksNameColNumber;
			
			MODATAID		mdID;
		};

		InitInfo()
		{
			memset(this, 0, sizeof(InitInfo));
		}
	};
	/// end MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC


protected:
	//-------- CPY 8/11/01 v6.9069 TEMP_DATASET_USE_NORMAL_NAME
	//MoData(UINT i1,UINT i2, BOOL bOneDataset = 0);
	MoData(UINT i1,UINT i2, DWORD dwCntrl = 0);
	//--------
	MoData(LPCSTR lpszName);/// add test for name before calling Origin
	MoData(LPCSTR name, int iCol); /// iCol=0,1,2,3...
 	MoData(LPCSTR wksname, LPCSTR lpColumnName); 
	//MoData(const MoData &original);//TD 7-18-01 The copy constructor must be public
	MoData(int type, LPCSTR lpszName);
	/// TD 6-5-01  MODATA_FROM_MODATAID
	MoData(MODATAID mdID);
	/// end  MODATA_FROM_MODATAID
	MoData(); //Unattached /// TD 8-24-01 NEW_TEMPORARY_CURVE_CLASS
	/// ML 8/8/2003 QA70-4980 MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC
	MoData(InitInfo &initinfo);
	/// end MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC

	void	check_range(long index);

	/// TD 8-24-01 NEW_TEMPORARY_CURVE_CLASS
protected:
	BOOL SetID(MODATAID mdID); //Only to be called from constructor
	void SetAsTemporary();
	/// end NEW_TEMPORARY_CURVE_CLASS
	/// TD 3-11-02 MEM_LEAKS_IN_MOCURVE
	bool TmpCloneOf(MoData &modata);
	/// end MEM_LEAKS_IN_MOCURVE

/// TD 3-7-02 QA70-1082 v7.0237 TEMP_CURVE_FROM_YDATA_VALUE

public:
	void ReInitializeAllCachedRanges(); //As is newly constructed -- aclled from trim, trim has higher presedence
	virtual int Trim(bool bLeft, DWORD dwFlag);
/// end TEMP_CURVE_FROM_YDATA_VALUE
	/// TD 3-11-02 MEM_LEAKS_IN_MOCURVE
	bool SetTempDataDeleteOnDestroy(bool bSet);
	/// end MEM_LEAKS_IN_MOCURVE


public:
    long	i1() const;
    long	i2() const;

    
    double	LeftEnd() const;
    double	RightEnd() const;

	double	operator [](long index) const;
	lrclass &		operator ()(long index);
	virtual	MoData	&	operator = (MoData &);
	virtual	MoData	&	operator = (double);
	virtual	const MoData  operator*(MoData &);
	virtual const MoData  operator+(MoData &x);
	virtual const MoData  operator-(MoData &x);
	virtual const MoData  operator/(MoData &x);
	virtual	MoData	&	operator *=(MoData &);
	virtual	MoData	&	operator /=(MoData &);
	virtual	MoData	&	operator +=(MoData &);
	virtual	MoData	&	operator -=(MoData &);	
	virtual	const MoData		operator * (double);
	friend	const MoData	operator*(double, MoData &);
	virtual	const MoData		operator / (double);
	friend	const MoData	operator/(double, MoData &);
	virtual	const MoData		operator - (double);
	friend	const MoData	operator-(double, MoData &);
	virtual	const MoData		operator + (double);
	friend	const MoData	operator+(double, MoData &);
	virtual	MoData	&	operator *=(double);
	virtual	MoData	&	operator /=(double);
	virtual	MoData	&	operator +=(double);
	virtual	MoData	&	operator -=(double);
	
	
	virtual int		SetValue(long index, double value);
	virtual int		SetValue(long index, LPSTR lpstr);
	virtual int		GetValue(long index, LPSTR lpstr) const;	
	virtual void	SetType(int type) {m_type = type;}
	virtual	int		SetRange(long i1,long i2);
	virtual	int		SetNRange(long i1,long i2); //TD 5/5/2000 clears cells from i1 -to- i2-1

	virtual	int		ResetRange();	//ORIGIN_WKS_CLASS, add this for clear wks
	/// TD 1-23-02 QA70-408 t6.9190 METHOD_UPDATE_FOR_DATA_WRPPERS_IN_ORIGIN_C
	//virtual	BOOL	UpdateRange();	//---------------------SET_RANGE_TO_CURRENT_CHANGES	
	/// TD 3-27-02 UPDATE_MUST_UNLOCK_HANDLE
	//virtual	BOOL	UpdateRange(BOOL bFromOrigin = FALSE);	//---------------------SET_RANGE_TO_CURRENT_CHANGES	
	virtual	BOOL	UpdateRange(BOOL bFromOrigin = FALSE, int nReDrawMode = -1);	//---------------------SET_RANGE_TO_CURRENT_CHANGES	
	/// end UPDATE_MUST_UNLOCK_HANDLE
	/// end METHOD_UPDATE_FOR_DATA_WRPPERS_IN_ORIGIN_C
	virtual void	SetSelRange(long i1,long i2) { m_i1 = i1; m_i2 = i2;} /// set selected range 
	virtual	int		GetXY(long index,XY &xy) const; 
	virtual	int		GetSafeXY(long index,XY &xy);    
	virtual	int		SetXY(long index,XY &xy);	
	virtual	BOOL	IsValid() const;	
	virtual	BOOL	IsEmpty();
	virtual	BOOL	HasEnoughData(int npts); /// also update m_i1,m_i2   
	virtual int		CheckXInc(double dRes); 
	virtual BOOL    CheckInc(double dRes);
	virtual	double	GetApparent(long ii);
	virtual	int		SetApparent(long ii,double& value);  
	virtual double	GetYfromX(double& value) const;
	virtual	int		clean_itself();

	long			iRange1();
	long			iRange2();	
	long			GetMissingNum() const;
	double			MakeInterpolatedDataSet(MoData &NewTempData, long NewSize) const;
	double			GetXInc();
	MORETURN		GetNumericValueAsText(long index, LPSTR lpszBuffer);
	MODATAID		GetId() const;	
	long			GetMaxi2() const;

	int				IsError(); 
    int				SetMask(long row, MOMASK mask);
	BOOL			IsTextualDataset();
	/// TD 3-19-02 WCB_TO_SET_IMAX_WITH_REDRAW_OPTIONS
	int				SetBufferSize(int iSize);
	/// end WCB_TO_SET_IMAX_WITH_REDRAW_OPTIONS
	/// TD 3-4-02 QA70-965 DATASET_APPEND_REFRESH_MODE
	BOOL			SetBufferSizeUpdateLater(int nMax);
	int				Update(int nUpdateMode, BOOL bOnlyObject = FALSE);
	int				GetRedrawMode() {return m_nReDrawMode;}
	/// end DATASET_APPEND_REFRESH_MODE
	//-------- CPY 8/11/01 v6.9069 TEMP_DATASET_USE_NORMAL_NAME
	//BOOL		m_bOneTemporary;   // set if the object holds ONE temporary dataset, cleared otherwise
	//BOOL			IsOneTemporary() const { return m_bOneTemporary; }
public:

	/// TD 1-25-02 t9891 t6.9192 METHOD_CRATE_FOR_ODATA_TYPES
	//enum {DATA_ONE_TEMP = 0x01L, DATA_NORMAL_NAME = 0x02L};
	enum{
	DATA_ONE_TEMP			= 0x01L, 
	DATA_NORMAL_NAME		= 0x02L,
	DATA_TEMP_NO_CLEANUP	= 0x04L, 
	};
	/// end METHOD_CRATE_FOR_ODATA_TYPES

	DWORD			GetCntrl()	const {return m_dwCntrl;}
	//BOOL			IsOneTemporary()  const {return (m_dwCntrl & DATA_ONE_TEMP)?TRUE:FALSE;} 
private:
	DWORD			m_dwCntrl;
public:
	//-------- end CPY 8/11/01 v6.9069 TEMP_DATASET_USE_NORMAL_NAME
	WORD			GetType() const { return m_type; }
	//------- CPY v6.0297 t8155 7/5/00 FASTER_DATASET_ACCESS_FROM_MOCA
	int				DirectValue(OCELL_VALUE *lpCell);
	//------- end
	/// TD 4/3/01 t9034	OVECTOR_SUPPORT
	LPVOID			GetBuffer( GET_DATA_BUFFER& sdbElementInfo);
	/// end	OVECTOR_SUPPORT
	//-------- CPY 11-10-2001 v6.9122 IMAGE_IMOPRT_USE_POINTER_TO_MAKE_FASTER
	LPVOID			GetBuffer();
	void			ReleaseBuffer(BOOL bChanged = FALSE);
	//-------- end CPY 11-10-2001 v6.9122
	//------------ CPY 6/21/01 CURVE_OBJ_NEEDS_READ_PLOT_INFO
	BOOL			SetToSelRange(BOOL bSet=TRUE, LPLONG lpRange=NULL); // set m_i1 and m_i2 into internal series pointer's i1 i2, FALSE to restore to m_range[0] and [1]
	//------------
	/// TD 7-16-01 ADD_GETNAME_TO_DATASET
	BOOL			GetName(CString& strName);
	/// TD 7-16-01 ADD_GETNAME_TO_DATASET
	/// TD 8-10-01 ORIGINC_DATAOBJECT_DESTRUCTOR_DO_NOT_UPDATEVALUE
	void			SetChanged(BOOL bChanged = TRUE);
	/// end ORIGINC_DATAOBJECT_DESTRUCTOR_DO_NOT_UPDATEVALUE
	/// TD 1-29-02 QA70-592 v6.9197 PROPER_HANDLING_OF_DATASET_RANGE_FROM_KERNEL
	void			SetSeriesRange(UINT nLow, UINT nHight);//Only Changes s->i1[i2] and nothing else
	void			RestoreCheckSeriesRange();//Flips back the changes from SetSeriesRange unless changed by other means
	
	//------- CPY v7.0352 7/25/02 QA70-2469 MATRX_DATA_CHANGE_MUST_UPDATE_Z_RANGE
	void			SetZRangeUpdate(BOOL bSetAutoUpdate) { DisableZUpdate(!bSetAutoUpdate); }
	//------- 
	/// TD 4-25-03 QA70-4256 SOURCE_RANGE_IN_CURVEBASE
	BOOL			GetOriginalRange(int &nLow, int &nHigh);
	/// end SOURCE_RANGE_IN_CURVEBASE

private:

	long			m_lSeriesRange[5];

	inline 	void GetOriginalSetSelectionSeriesrange()
	{
		m_lSeriesRange[4] = SERIES_RANGE_SET_NEW_RANGE | SERIES_RANGE_GET_CURRENT_RANGE;
		SetSeriesRange(i1(), i2());
		m_lSeriesRange[4] = SERIES_RANGE_SET_NEW_RANGE;
	}


	/// end PROPER_HANDLING_OF_DATASET_RANGE_FROM_KERNEL
protected:

	/// YuI 8/30/02 v7.0387 QA70-2841 LINKS_MANAGER_FOR_OBJECTS
	void			Set_m_id(MODATAID id);
	virtual void	ConnectToSeries();
	virtual void	DisconnectFromSeries(BOOL bUpdate = FALSE, DWORD dwCntrl = 0);
	/// end LINKS_MANAGER_FOR_OBJECTS

	MODATAID		m_id;
	//----------- CPY v7.0352 7/25/02 QA70-2469 MATRX_DATA_CHANGE_MUST_UPDATE_Z_RANGE
	//BOOL		m_changed;
	enum { MODATA_CHANGED = 0x01, MODATA_NO_Z_UPDATE = 0x02 };
	BYTE			m_changedBits;
	void			DisableZUpdate(BOOL bSet = TRUE) { if(bSet) m_changedBits |= MODATA_NO_Z_UPDATE; else m_changedBits &= ~MODATA_NO_Z_UPDATE;}
	//----------- end
	/// ML 8/8/2003 QA70-4980 MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC
	BOOL			Update_i1_i2_from_range_array();
	BOOL			NoMarkerUse();
	/// end MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC

private:

	/// TD 4-25-03 QA70-4256 SOURCE_RANGE_IN_CURVEBASE
	//long			m_range[4]; /// 0,1 = disp range, 2,3 = selection range
	long			m_range[RANGE_SIZE]; /// 0,1 = disp range, 2,3 = selection range, 4= has selection
	/// end SOURCE_RANGE_IN_CURVEBASE
	long			m_i1;// all for loop must use m_i1 and m_i2, like for(i=m_i1;i<m_i2;i++)
	long			m_i2;// optional for argument specified
	long			m_max_i2;// check for last value setting and will use for set range
	WORD			m_type;//X_AXIS,Y_AXIS association for apparent value getting and settings
 	void			init(LPCSTR lpName,BOOL bCheckBlank);/// bCheckBlank == 1 to test blank name
	/// ML 8/8/2003 QA70-4980 MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC
	BOOL			init_from_dataset_name(LPCSTR lpszName, BOOL bCheckBlank);
	BOOL			init_from_wksname_and_column_number(LPCSTR name, int iCol);
	BOOL			init_from_wksname_and_column_name(LPCSTR wksname, LPCSTR lpColumnName);
	BOOL			init_from_dataid(MODATAID mdID);
	/// ML 8/8/2003 QA70-4980 MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC
	BOOL			init(MoData::InitInfo &initinfo);
	/// end MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC
	/// end MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC
	void			init(int type, LPCSTR lpszName);
	void			members_init(); // otherwise we seem to have several places for these
	int				m_nReDrawMode;
	/// ML 8/8/2003 QA70-4980 MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC
	BOOL			m_bNoMarkerUse;
	/// end MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC

public:

	void		set_redraw_mode(int nMode);

	enum {
		REDRAW_NONE, // should always be first
		REDRAW_REALTIME, REDRAW_REALTIME_WKS, REDRAW_REFRESH, REDRAW_REALTIME_SCOPE,
		REDRAW_MODE_INVALID // should always be last
	};
	
	enum {REALTIME_ON_IDLE=0x1000}; ///---- CPY v5.039 b3558 REALTIME_DRAW_BUFFERRING


	/// TD 5-16-01	MORE_ACCURATE_DATA_ACCESS_TO_ORIGINC
	static LPFNElemVal m_lpfnGetElemVal;
	static LPFNDataMask m_lpfnDataMask;
	/// end MORE_ACCURATE_DATA_ACCESS_TO_ORIGINC

	/// YuI 8/30/02 v7.0387 QA70-2841 LINKS_MANAGER_FOR_OBJECTS
	//	//LY	12/14/01 t9798 SERIESPTR_MANAGER
	//	BOOL		InvalidateObj();
	//	//end t9798 SERIESPTR_MANAGER
	virtual BOOL	InvalidateObj(LPVOID pObject);
	/// end LINKS_MANAGER_FOR_OBJECTS
	
	/// YuI 12/31/02 QA70-3592 v7.0477 ORIGIN_C_AND_INTERNAL_DATA_PROTECTION
	BOOL			IsWriteProtected();
	/// end ORIGIN_C_AND_INTERNAL_DATA_PROTECTION
	/// TD 11-6-03 QAx70-5481 PARTIAL_DETACH_MOCA_ON_TYPE_CANGE
	virtual BOOL		OnLHMessage(UINT nMsg, LPVOID pObject, WPARAM wParam = 0, LPARAM lParam = 0);
	/// TD 11-14-03 QA70-5516 ALLOW_MIXED_TO_DOUBLE_SWITCH_FOR_DATASET 
	//bool				SetObjectToDetachOnTypeChange(bool bSet = true);
	//bool				ISObjectToDetachOnTypeChange();
	MOCAObj*			SetReDirectOnElementSize(MOCAObj *pObj = NULL);
	bool				IsDirectOnElementSize();
	/// end ALLOW_MIXED_TO_DOUBLE_SWITCH_FOR_DATASET 

private:

	/// TD 11-14-03 QA70-5516 ALLOW_MIXED_TO_DOUBLE_SWITCH_FOR_DATASET 
	//bool	m_bDetach;
	MOCAObj		*m_pObj;
	/// end ALLOW_MIXED_TO_DOUBLE_SWITCH_FOR_DATASET 
	/// end PARTIAL_DETACH_MOCA_ON_TYPE_CANGE
};
typedef MoData *MoDataPtr;

const MoData	operator+(double, MoData &);
const MoData	operator-(double, MoData &);
const MoData	operator*(double, MoData &);
const MoData	operator/(double, MoData &);

#define REDRAW_MODE_MASK		0x000F // enough for 15 modes
#define IS_REDRAW_MODE(nMode) (REDRAW_NONE <= ((nMode) & REDRAW_MODE_MASK) && ((nMode) & REDRAW_MODE_MASK) < REDRAW_MODE_INVALID)




class lrclass
{
public:
    lrclass();
    lrclass(double new_value);
    lrclass(const lrclass & Original);                                        
	static		double				value;
	static		long				index;
	static		BOOL				bSetValue;

	operator	double ();    
};



/////////////////////////////////////////////////////////////////////////////
//
//	MoSourceData	: independent datasets, invalid if name not supplied, operation abort if not supplied
//
/////////////////////////////////////////////////////////////////////////////
	
class MoSourceData : public MoData
{

public:

	MoSourceData(LPCSTR name);
	MoSourceData(int type, LPCSTR name);
	MoSourceData(MoOriginWks &wks, MOCOLNUM iCol);
	MoSourceData(MoOriginWks &wks, LPCSTR lpszColumnName);
	MoSourceData(LPCSTR wksname, LPCSTR lpColumnName);
	MoSourceData(LPCSTR wksname, int nCol); ///  MoColumnNum is 1,2,3,...
	/// TD 6-5-01  MODATA_FROM_MODATAID
	MoSourceData(MODATAID mdID);
	/// end TD 6-5-01  MODATA_FROM_MODATAID
	/// ML 8/8/2003 QA70-4980 MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC
	MoSourceData(MoData::InitInfo &initinfo);
	/// end MUST_NOT_USE_WKSSELECTION_FOR_DATASET_OBJECTS_IN_ORIGINC

};
typedef MoSourceData * MoSourceDataPtr;


/////////////////////////////////////////////////////////////////////////////
//
//	MoInterimData	: independent datasets, name may not be supplied, operation continues
//
/////////////////////////////////////////////////////////////////////////////
	
class MoInterimData : public MoData
{ 
 
public:

	MoInterimData(LPCSTR name);
	MoInterimData(int type, LPCSTR name);
	MoInterimData	&	operator = (const MoData &x); 
	MoInterimData & operator=(const double x);
};

/////////////////////////////////////////////////////////////////////////////
//
//	MoResultData	: independent datasets, name may not be supplied
//
/////////////////////////////////////////////////////////////////////////////
	
class MoResultData : public MoData
{
      
public:

	MoResultData(LPCSTR name);
	MoResultData(int type, LPCSTR name);
	MoResultData(LPCSTR wksname, LPCSTR lpColumnName);
	MoResultData(LPCSTR wksname, int iCol);
	MoResultData(MoOriginWksPtr pwks, int iCol);
	MoResultData(MoOriginWks &wks, int iCol);
	MoResultData(MoOriginWks &wks, LPCSTR lpszColumnName);


	MoResultData	&	operator =	(const MoData &x); 
	MoResultData	&	operator =	(const double x);
};
typedef MoResultData * MoResultDataPtr;


/////////////////////////////////////////////////////////////////////////////
//
//	MoTempData	: independent datasets, no name, just supply range
//
/////////////////////////////////////////////////////////////////////////////
	
class MoTempData : public MoData
{     
     
public:
	MoTempData(long npts);
	~MoTempData();
};

// Origin Dataset class when not attached to real Origin data
class MoTempDataset : public MoData
{
public:
	/// TD 1-25-02 t9891 t6.9192 METHOD_CRATE_FOR_ODATA_TYPES
	////-------- CPY 8/11/01 v6.9069 TEMP_DATASET_USE_NORMAL_NAME
	////MoTempDataset(long i1,  long i2);
	//MoTempDataset(UINT i1,  UINT i2);
	////--------
	MoTempDataset(UINT i1,  UINT i2, BOOL bKillOnDestroy = TRUE);
	/// end METHOD_CRATE_FOR_ODATA_TYPES
	MoTempDataset(MoData& modata);/// TD 8-24-01 NEW_TEMPORARY_CURVE_CLASS

	~MoTempDataset();

	MoData	&	operator = (MoSourceData &x);

	/// TD 3-7-02 QA70-1082 v7.0237 TEMP_CURVE_FROM_YDATA_VALUE
public:

	BOOL SetDataToXValOfAnotherData(MODATAID mdAnotherData);
	/// end TEMP_CURVE_FROM_YDATA_VALUE
};

/// ML 5/29/2003 QA70-4562 CURVE_EXTENSION_WITH_RELATED_DATASETS
#ifdef		__EXTENDED_CURVE_CLASS_WITH_RELATED__
class ORelatedDatasets
{
public:
	ORelatedDatasets();
	~ORelatedDatasets();

public:
	MoData		*Add(UINT nType, MODATAID nID);
	BOOL		RemoveByType(UINT nType);
	BOOL		RemoveByID(MODATAID nID);
	void		RemoveAll();
	MoData		*GetFromType(UINT nType);
	MoData		*GetFromID(MODATAID nID, PUINT pnType = NULL);
	int			GetSeriesInfo(CArray<OSERIESTAG, OSERIESTAG&> &arrRelated);
	int			InitForSeries(MOCAOrigin *p, MODATAID dwID);

private:
	int			GetIndexFromType(UINT nType);
	int			GetIndexFromID(MODATAID nID);
	int			RemoveByIndex(int ii);


private:

	struct ONERELATED
	{
		UINT	nType;		// EXTCURVEREL_* enumeration 
		MoData	*pMoData;
	};

	CArray<ONERELATED, ONERELATED&>		m_data;
};
#endif		// __EXTENDED_CURVE_CLASS_WITH_RELATED__
/// end CURVE_EXTENSION_WITH_RELATED_DATASETS



/// TD 6-18-01 MOCURVE_DERIVED_FROM_MODATA
class MoCurve : public MoData
{
public:
	MoCurve(LPCSTR lpszDXName, LPCSTR lpszDYName);/// create dependency		
	MoCurve(LPCSTR lpszDYName);/// Use it's x-dependancy	
	MoCurve(MoData &YData);/// Use it's x-dependancy	
	MoCurve(MoData &XData, MoData &YData);/// create dependency	
	MoCurve(MODATAID mdXID, MODATAID mdYID);/// TD 1-2-01 QA70-239 CURVE_CONSTRUCTION_FROM_WORKEHSEET_OBJECT
	MoCurve(MODATAID mdYID);	/// AW 06/06/02 QA70-1988 CONSTRUCT_FROM_DATAPLOT
	MoCurve();/// TD 3-11-02 MEM_LEAKS_IN_MOCURVE
	~MoCurve();

public:

	virtual BOOL CreateDependency(MoData& XData);
	BOOL CreateDependency(LPCSTR lpcszDatasetName);
	BOOL CreateDependency(MODATAID mdXID);/// TD 1-2-01 QA70-239 CURVE_CONSTRUCTION_FROM_WORKEHSEET_OBJECT
	MoData*	GetDependency();
	BOOL	IsValid() const;
	//------- CPY 6/25/03 QA70-4712 v7.0610 CURVEBASE_HAS_X_SHOULD_RET_DATASET_NAME
	//BOOL	HasX(); /// TD 7-31-01 NO_XDEPENDENCY_ONLY_Y_IS_VALID
	BOOL	HasX(CString* pstrXname = NULL);
	//------- end CURVEBASE_HAS_X_SHOULD_RET_DATASET_NAME
	BOOL	Sort(DWORD dwFlags);//---------------------------- CPY 8/6/01 t8777 CURVE_SORT
	/// TD 3-7-02 QA70-1082 v7.0237 TEMP_CURVE_FROM_YDATA_VALUE
	int Trim(bool bLeft, DWORD dwFlag);
	/// end TEMP_CURVE_FROM_YDATA_VALUE
	/// ML 5/29/2003 QA70-4562 CURVE_EXTENSION_WITH_RELATED_DATASETS
	#ifdef		__EXTENDED_CURVE_CLASS_WITH_RELATED__
	MoData		*GetRelatedFromType(UINT nType);
	MoData		*GetRelatedFromID(MODATAID nID, PUINT pnType = NULL);
	MoData		*AddRelated(UINT nType, MODATAID nID);
	int			InitRelated();
	#endif		// __EXTENDED_CURVE_CLASS_WITH_RELATED__
	/// end CURVE_EXTENSION_WITH_RELATED_DATASETS
	
	/// YuI 5/05/03 v7.0578 QA70-4357 CURVE_AS_INPUT_OF_OPERATION
	virtual int		GetInfo(LPVOID lpInfo, DWORD dwMsg, DWORD dwMoreInfo = 0UL);
	/// end CURVE_AS_INPUT_OF_OPERATION
protected:

	MoCurve(UINT i1,  UINT i2, DWORD dwCntrl = 0): MoData(i1, i2, dwCntrl){Init_Data();}	//TD 10-11-02
	//----------- CPY 6/21/01 CURVE_OBJ_NEEDS_READ_PLOT_INFO
	//Inline
	//void Init_Data(){m_pXData = NULL;}
	void Init_Data();
	MODATAID	m_dwOldXID;
	//----------- end CPY 6/21/01

	MoData*		m_pXData;

	char		m_bIsXChanged; //---- CPY 8/6/01 t8777 CURVE_SORT
	
	BOOL		DataOriginSetXforY(DWORD dwXID);	//CPY 4/16/03 QA70-4601 v7.0564 OC_ADD_PLOT_KEEP_CURVE_X

	/// ML 5/29/2003 QA70-4562 CURVE_EXTENSION_WITH_RELATED_DATASETS
	#ifdef		__EXTENDED_CURVE_CLASS_WITH_RELATED__
	ORelatedDatasets	m_related;
	#endif		// __EXTENDED_CURVE_CLASS_WITH_RELATED__
	/// end CURVE_EXTENSION_WITH_RELATED_DATASETS
};

/// end MOCURVE_DERIVED_FROM_MODATA

/// ----------------TD 8-24-01 NEW_TEMPORARY_CURVE_CLASS
class MoTempCurve : public MoCurve
{
public:
	/// TD 1-25-02 t9891 t6.9192 METHOD_CRATE_FOR_ODATA_TYPES
	//MoTempCurve(UINT i1,  UINT i2);
	MoTempCurve(UINT i1,  UINT i2, BOOL bKillOnDestroy = TRUE);
	/// end METHOD_CRATE_FOR_ODATA_TYPES
	MoTempCurve( MoData * pdata );
	MoTempCurve(MoCurve& mocurve);
	MoTempCurve(MoData & pModata);	//Given a tem data/// TD 3-7-02 QA70-1082 v7.0237 TEMP_CURVE_FROM_YDATA_VALUE
	/// TD 3-11-02 TEMP_CURVE_FROM_TWO_DATA_NEVER_DELETES_THE_SERIES_PTR
	MoTempCurve(MoData & mdCopyThis, MoData * pmdAttachThis);
	/// endTEMP_CURVE_FROM_TWO_DATA_NEVER_DELETES_THE_SERIES_PTR
	~MoTempCurve();

public:

	BOOL CreateDependency(MoData& XData);
	virtual	int		clean_itself();/// TD 1-25-02 t9891 t6.9192 METHOD_CRATE_FOR_ODATA_TYPES
	void CreatetempXData(MoData * pModata);/// TD 3-7-02 QA70-1082 v7.0237 TEMP_CURVE_FROM_YDATA_VALUE

};
/// ---------------- end NEW_TEMPORARY_CURVE_CLASS


/// TD 10-29-01	CATEGORICAL_DATA
class MoCategoricalData : public MoData
{
public:
	MoCategoricalData(LPCSTR lpszDSN, UINT nType);		
	MoCategoricalData(LPCSTR lpszWks, UINT nCol, UINT nType);		
	~MoCategoricalData();

public:

	/// YuI 9/16/03 v7.5696 QA70-5184 CATEGORICAL_MAP_OC_COOKIE
	//	LPVOID	GetCatMap();
	LPVOID	GetCatMap(BOOL bDoNotCreate = FALSE);
	/// end CATEGORICAL_MAP_OC_COOKIE
	BOOL	IsValid() const;

protected:

	void Init_Data(UINT nCMType);

private:

	/// YuI 9/16/03 v7.5696 QA70-5184 CATEGORICAL_MAP_OC_COOKIE
	//	LPVOID  m_pMap;
	/// end CATEGORICAL_MAP_OC_COOKIE
	DWORD	m_dwWCBData[4];	//[0]Sub WCB Msg(CM_SUBWCB_SETNEW_SAVEOLD, CM_SUBWCB_GETMAP, CM_SUBWCB_RESET_TO_OLD) defined in Orgdll.h
							//[1]Type of Catagorical dataset (Nominal, Ordinal)
							//[2]Type before construction(Nominal, Ordinal, NULL)
							//[3]LPVOID If Older type was different and Not null store the Map for reset

};
///	end CATEGORICAL_DATA

#endif /// _MOCADATASET_H
