/*------------------------------------------------------------------------------*
 * File Name:	MOCADLL.h														*
 * Purpose:		Microcal Objects and classes									*
 * Creation:	Original by Tim Ding and Dr. C. P. Yang, 4/15/95				* 
 * Copyright Microcal Software Inc. 1995,2000									*
 *																				*
 * Modification log																*
 * revised by TD on 3/27/2000													*
 * EJP 07-06-2000 t8153 GET_REGISTRATION_INFO									*
 * EJP 08-15-2000 t8153 v6.1026 WCB_GET_USER_INFO								*
 * EJP 01-09-2001 v6.1071 t8790 LABTALK_MANAGER_UI								*
 * EJP 03-09-2001 t8865 IMPLEMENT_IDE_VARIABLE_WINDOW							*
 * CPY 3/15/01 7.0 PRINT_STRING													*
 * SY 03-22-2001 ADD_GETCHILDREN_FUNCTION										*
 * SY 04-09-2001 t9041 SORT_WORKSPACE_ITEM										*
 * SY 05-07-2001 t9131 ADD_IDE_HANDING_TEMP_FILES								*
 * SY 07-25-2001 t9336 OIDE_GUI_IMPROVEMENT										*
 * LY	12/14/01 t9798 SERIESPTR_MANAGER										*
 * EJP 02-27-2002 QA70_985 ENABLE_SOFTDEV_PDF									*
 * YuI 5/22/02 v7.0303 QA70-1582 NLSF_CODE_BUILDER_COMMUNICATION				*
 * AW 07/01/02 v7.0333 QA70-2116 MORE_WORK_ON_NAG_DLL_SUPPORT					*
 * YuI 8/30/02 v7.0387 QA70-2841 LINKS_MANAGER_FOR_OBJECTS						*
 * SY 09-25-02 QA70-2437 v7.0402 MULTIFOLDERED_OC_WORKSAPCE_GUI					*
 * TD 12-05-02 QA70-3060 v7.0452 SEND_MSG_TO_MOCA_WRAPPERS						*
 *	ML 5/29/2003 QA70-4562 CURVE_EXTENSION_WITH_RELATED_DATASETS				*
 *	RVD 6/13/2003 QA70-4650 v7.0601 OBJECT_PROPERTY_ACCESS						*
 *------------------------------------------------------------------------------*/      
#ifndef	_MOCADLL_H
#define	_MOCADLL_H

////////////////////////////////////////////////////////////
////
////Macros For Multiple Usage, 
////1)Using as LIB
////2)Building the LIB
////3)Building for internal use

//1)	// Using the lib 
#ifdef		__USE_MOCA_AS_LIB__
	#define		__MOCA_AS_LIB__
	#define		MODLL_DEMO
#endif		// __USE_MOCA_AS_LIB__


//2)	// Building a lib or using it 
#ifdef		__MOCA_AS_LIB__
	#pragma	message(">>>>>>>>>>>>>>>> __OMOCA_AS_LIB__ defined <<<<<<<<<<<<<<<<<<<<<<<<")
	#define		MOCA_EXTERNAL_SUPPORT
#endif		// __MOCA_AS_LIB__

//3)	//Building  for internal Use

#ifndef				MODLL_DEMO	  
	#include		"config.h"
#endif
#ifdef			MOCA_SUPPORT_FOR_INTERNAL_USE
	#undef			MOCA_EXTERNAL_SUPPORT		
#endif	


#if	defined(MOCA_SUPPORT_FOR_INTERNAL_USE) && defined(OK_AS_EXTDLL) 
	#define		MOCA_EXPORT_IMPORT					__declspec(dllexport)
#elif	defined(MOCA_EXTERNAL_SUPPORT)			
	#define		MOCA_EXPORT_IMPORT
#else
//	#define		MOCA_EXPORT_IMPORT					__declspec(dllexport)
	#define		MOCA_EXPORT_IMPORT					__declspec(dllimport)
#endif			


///////////////////////////////////////////////////////////////////////////////////////////////////////////////
////begin macros
#ifndef			LPCOKSTR
	#define		LPCOKSTR		LPSTR
#endif
#define			MOCA_EXP_CLASS						MOCA_EXPORT_IMPORT
//#define			MOCA_EXP_FUNC						MOCA_EXPORT_IMPORT
#define			DISPLAY_MESSAGE(lpszMessage)		ScriptMessage(lpszMessage)
#define			MAX_DOUBLE						1.7E+308
#define			UNTYPED_DIVIDE(a, b, result)  {                                          \
 				if (fabs(b) >= 1. || fabs(a) < fabs(b) * MAX_DOUBLE)  \
 					(result) = (a) / (b);                                    \
 				else                                                         \
 				    (result) = NANUM;                                        \
			}	
					   
/// ML 5/29/2003 QA70-4562 CURVE_EXTENSION_WITH_RELATED_DATASETS
#ifndef		MOCA_DIVIDE
	#define		MOCA_DIVIDE_DEF(_num, _den, _def)	((fabs(_den) >= 1. || fabs(_num) < fabs(_den) * MAX_DOUBLE) ? (_num) / (_den) : (_def))
	#define		MOCA_DIVIDE(_num, _den, _def)		MOCA_DIVIDE_DEF((_num), (_den), NANUM)
#endif		// MOCA_DIVIDE
/// end CURVE_EXTENSION_WITH_RELATED_DATASETS




//#define			MOCA_OUT_MSG(str)						ScriptMessage(str)
//#define			MOCA_REAL_TO_STR(szBuf,vv)				RealToString(vv, szBuf);
//#define			MODLL_EXECUTE_SCRIPT(mobj, str) mobj->ExecuteScript(str);
//#define			ODLL_FN
//#define			PROPFNBASE							CObject
//#define			MO_RETURN_YES						EGOR_YES
//#define			MO_RETURN_NO						EGOR_NO
//#define			MO_RETURN_ERR						EGOR_ERR 
//#define			okThisFuncType
//#define		NORMAL_PROB(x, mean, sigma)			GaussianDistribution(x, mean, sigma)
//#define		MOABS(arg)						fabs(arg)
/*#ifdef			_DEBUG	
	#define		DEBUG_MSG(str)	{char szTemp[50];wsprintf(szTemp,"%s:%s",(LPSTR)SZCLASS_NAME,(LPSTR)str);OUT_MSG(szTemp);}
#else
	#define		DEBUG_MSG(str)
#endif
*/



////end macros
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////#includes

//#include	<afxwin.h>         // MFC core and standard components
#include	<math.h> 
#include	"moapi.h"
#include	"llist.h"	
#include	"orgdll.h"
#include	<afxtempl.h> 

#include    "mocanagshare.h"

////end include files
////////////////////////////////////////////////////////////////////////

class	MOCARecorder;


/// EJP 03-09-2001 t8865 IMPLEMENT_IDE_VARIABLE_WINDOW
//class MOCA_EXP_CLASS COKLTObj;
class COKLTObj;
typedef COKLTObj * COKLTObjPtr;
typedef CArray<COKLTObjPtr, COKLTObjPtr> COKLTObjPtrArray;
/// end IMPLEMENT_IDE_VARIABLE_WINDOW
/// TD 5-30-02 QA70-1336 v7.0312 SAVING_OC_COMPILED_CODE
#include "OKCONST.H"
/////////////////////////////////////////////////////////////////////////////////
// 	CLTArchiveException (class)
//	
//	This class is used to through Origin C Specific exceptions while archiving
//
class CLTArchiveException : public CException
{
	DECLARE_DYNAMIC(CLTArchiveException)

public:

	enum
	{
		NoError,
		ErrFileIdentifier,
		ErrFileVersion,
		ErrFileModified,
		ErrFnBodyCompile,
		ErrGeneric
	};

	CLTArchiveException();
	~CLTArchiveException();

public:

	void	SetError(int nError);
	int		GetError();

private:

	UINT m_nError;

};

/////////////////////////////////////////////////////////////////////////////////
// 	CLTPtrReferences
//
//	This Map object stores the refernces to a pointer loaded by CArchive
//	the storage keeps adding refernce until the owner intervenes -- in 
//	the process the owner may decide to replace the loaded object with
//	another new object, update all refernces and stop addition of future refrences
//
//	Only used by the CLTArchive loading process, storing does not use this
//
class CLTBase;

typedef  CArray<CLTBase**, CLTBase**>	ArrLTReferences;
class MOCA_EXP_CLASS CLTPtrReferences 
	: public CMap<CLTBase*, CLTBase*, ArrLTReferences*, ArrLTReferences*>
{
public:

	CLTPtrReferences();
	~CLTPtrReferences();

public:

	void AddReference(CLTBase** pLTPtrRef);
	void MarkEndOfAddingRef(CLTBase* pLTPtr);
	void CleanupRefsTo(CLTBase* pLTPtr);
	void UpdateRefernces(CLTBase* pLTPtrOld, CLTBase* pLPtrNew);

	bool Exist(CLTBase* pLTPtr);
	bool RemoveReference(CLTBase** pLTPtrRef);
	bool IsAddMoreRefernces(CLTBase* pLTPtr);
};

/////////////////////////////////////////////////////////////////////////////////
// 	CLTArchive
//
//	We may want to add more functions, partucularly once related to 
//  Forward compality of First and Second kind
//
class CLTPtrContainersBase;
//

class MOCA_EXP_CLASS CLTArchive
	: public CArchive
{
public:

	CLTArchive(CFile* pFile, UINT nMode);
	~CLTArchive();

public:

	// insertion operations
	void DoArchive(BYTE& by);
	void DoArchive(WORD& w);
	void DoArchive(LONG& l);
	void DoArchive(DWORD& dw);
	void DoArchive(float& f);
	void DoArchive(double& d);
	void DoArchive(int& i);
	void DoArchive(short& w);
	void DoArchive(char& ch);
	void DoArchive(unsigned& u);
	/// AW 05/12/03 QA70-4430 v7.0582 OC_COMPILED_FILE_SUPPORT 
	void DoArchive(tagOneOCcomplex& u);
	void DoArchive(LPVOID *pData, UINT &nSize);
	/// END OC_COMPILED_FILE_SUPPORT 
	/// RVD 6/13/2003 QA70-4650 v7.0601 OBJECT_PROPERTY_ACCESS
	void DoArchive(CUIntArray& array);
	/// end OBJECT_PROPERTY_ACCESS

	void DoArchive(CString & str);
	void DoArchive(CLTBase ** pLTBase);
	void DoArchive(CLTPtrContainersBase & LTPtrs);
	void DoArchive(CLTBase ** pLTBase, bool bPtrOwner);
	void DoArchive(CLTPtrContainersBase & LTPtrs, bool bPtrOwner);
	
	
	void ThrowException(UINT nError = CLTArchiveException::ErrGeneric);

	void CleanupRefsTo(CLTBase* pLTPtr);
	void UpdateRefernces(CLTBase* pLTPtrOld, CLTBase* pLPtrNew);
	bool AddRemoveRefFromMap(CLTBase** pLTPtrRef, bool bAdd = true);

	bool IsKindOf();

	UINT GetSavedObjVersion();
	void SetSavedObjVersionFor(CLTBase * pLTBase);

protected:

	UINT						m_nError;
	UINT						m_nSavedObjVersion;

	CLTArchiveException			m_LTAExceptions;
	CLTPtrReferences			m_mapRefernces;


protected:

	void UpdateCarchiveArrayPtr(CLTBase * pLTOld, CLTBase * pLTNew);

private:

	//Keep this as a last Data member
	enum{nIdValue = 0xECFD973A};
	DWORD m_dwIdentifier;


};

inline	void CLTArchive::DoArchive(BYTE& by)
{
	IsStoring()		?	*this << by		: *this >> by; 
}
inline	void CLTArchive::DoArchive(WORD& w)
{
	IsStoring()		?	*this << w		: *this >> w; 
}
inline	void CLTArchive::DoArchive(LONG& l)
{
	IsStoring()		?	*this << l		: *this >> l; 
}
inline	void CLTArchive::DoArchive(DWORD& dw)
{
	IsStoring()		?	*this << dw		: *this >> dw; 
}
inline	void CLTArchive::DoArchive(float& f)
{
	IsStoring()		?	*this << f		: *this >> f; 
}
inline	void CLTArchive::DoArchive(double& d)
{
	IsStoring()		?	*this << d		: *this >> d; 
}
inline	void CLTArchive::DoArchive(int& i)
{
	IsStoring()		?	*this << i		: *this >> i; 
}
inline	void CLTArchive::DoArchive(short& w)
{
	IsStoring()		?	*this << w		: *this >> w; 
}
inline	void CLTArchive::DoArchive(char& ch)
{
	IsStoring()		?	*this << ch		: *this >> ch; 
}
inline	void CLTArchive::DoArchive(unsigned& u)
{
	IsStoring()		?	*this << u		: *this >> u; 
}

inline 	void CLTArchive::DoArchive(CString & str)
{
	IsStoring()		?	*this << str	: *this >> str; 
}


inline	void CLTArchive::ThrowException(UINT nError)
{
	m_LTAExceptions.SetError(nError);
	THROW(&m_LTAExceptions);
}

inline bool CLTArchive::IsKindOf()
{
	return m_dwIdentifier == nIdValue;
}

inline void CLTArchive::CleanupRefsTo(CLTBase* pLTPtr)
{
	m_mapRefernces.CleanupRefsTo (pLTPtr);
}

inline void CLTArchive::UpdateRefernces(CLTBase* pLTPtrOld, CLTBase* pLPtrNew)
{
	m_mapRefernces.UpdateRefernces(pLTPtrOld, pLPtrNew);
}
	
inline UINT CLTArchive::GetSavedObjVersion()
{
	return m_nSavedObjVersion;
}



/////////////////////////////////////////////////////////////////////////////////
// 	CLTBase
//
//	Base class to all classes used by the compiler 
//  This class is mainly created to add saving info
//  May be reused for anything absolutely generic to all compiler related classes
//
class MOCA_EXP_CLASS CLTBase : public CObject
{
	LT_DECLARE_SERIAL(CLTBase);

public:
	CLTBase();
	~CLTBase();

public:

	void				Serialize(CArchive& ar);
	virtual CLTBase *	GetPointerOfCorrectType(CLTArchive& ar);

};
/// end SAVING_OC_COMPILED_CODE

/// EJP 01-09-2001 v6.1071 t8790 LABTALK_MANAGER_UI
//--------------------------------------------------------------------------
// COKLTObj
//
//--------------------------------------------------------------------------
/// TD 5-30-02 QA70-1336 v7.0312 SAVING_OC_COMPILED_CODE
//class MOCA_EXP_CLASS COKLTObj : public CObject
//{
//	DECLARE_DYNAMIC(COKLTObj);
class MOCA_EXP_CLASS COKLTObj : public CLTBase
{
	LT_DECLARE_SERIAL(COKLTObj);
/// end SAVING_OC_COMPILED_CODE
public: // constructors and destructors

public:

	// constants used by OnGeneralUI
	enum {
		LTUI_GET_TREE_LEVEL,		// get tree level index that represents object

		LTUI_IS_ENABLE,				// LTUI_RETURN_NOT_HANDLED=NA, LTUI_RETURN_TRUE=YES, LTUI_RETURN_FALSE=NO

		LTUI_DO_COMMAND,			// process menu item, return LTUI_RETURN_NOT_HANDLED if not processed
									// return LTUI_RETURN_TRUE if need redraw, return LTUI_RETURN_FALSE normally

		LTUI_IS_CHECK,				// LTUI_RETURN_TRUE if command is in checked state	
		/// SY 07-25-2001 t9336 OIDE_GUI_IMPROVEMENT
		LTUI_GET_CURRENT,// get current value (TRUE/FALSE) for node
		///
	};
	// return values for LTUI_IS_ENABLE
	enum {
		/// SY 09-25-02 QA70-2437 v7.0402 MULTIFOLDERED_OC_WORKSAPCE_GUI
		// Use different range from the tree level
		///	LTUI_RETURN_FALSE,
		LTUI_RETURN_FALSE = 1000,
		/// end MULTIFOLDERED_OC_WORKSAPCE_GUI
		LTUI_RETURN_TRUE,
		LTUI_RETURN_NOT_HANDLED,
	};

	/// EJP 03-09-2001 t8865 IMPLEMENT_IDE_VARIABLE_WINDOW
	enum {
		LTOBJ_TYPE_SINGLE,			// not a parent and not an array
		LTOBJ_TYPE_PARENT,			// has child objects
		LTOBJ_TYPE_ARRAY,			// can be broken into peices of same type (ex: string, vector)
	};
	/// end IMPLEMENT_IDE_VARIABLE_WINDOW
	
	/// SY 07-25-2001 t9336 OIDE_GUI_IMPROVEMENT
	enum {
		LPARAM_SET_TOGGLE,
		LPARAM_SET_TRUE,
		LPARAM_SET_FALSE,
		LPARAM_GET_CURRENT,
	};
	/// end  OIDE_GUI_IMPROVEMENT

public: // member functions
	virtual BOOL IsParent() {return FALSE;}
	virtual COKLTObj * FirstChild() {return NULL;}
	virtual COKLTObj * NextChild() {return NULL;}
	
	/// SY 03-22-2001 ADD_GETCHILDREN_FUNCTION
	virtual int GetChildren(COKLTObjPtrArray &LTObjArray);
	/// end ADD_GETCHILDREN_FUNCTION
  	
	/// EJP 03-09-2001 t8865 IMPLEMENT_IDE_VARIABLE_WINDOW
	virtual int GetLTObjType() {return LTOBJ_TYPE_SINGLE;}
	virtual BOOL GetVariableValueAsText(CString &strValue) {return FALSE;}
	/// end IMPLEMENT_IDE_VARIABLE_WINDOW

	// return icon resource id
	virtual BOOL GetDisplayInfo(CString &strName, LPINT lpIconIndex=NULL) {return FALSE;}

	/// SY 04-09-2001 t9041 SORT_WORKSPACE_ITEM
	virtual BOOL GetSortName(CString &strName);
	virtual int CompareName(COKLTObj *pLTObj);
	virtual void SortArray(COKLTObjPtrArray &LTObjArray);
	/// end	SORT_WORKSPACE_ITEM

	/// SY 05-07-2001 t9131 ADD_IDE_HANDING_TEMP_FILES 
	virtual BOOL IsTempFile() {return FALSE;}
	/// end ADD_IDE_HANDING_TEMP_FILES

	/// YuI 5/22/02 v7.0303 QA70-1582 NLSF_CODE_BUILDER_COMMUNICATION
	virtual BOOL IsHiddenFile()		{return FALSE;}
	/// end NLSF_CODE_BUILDER_COMMUNICATION

	virtual BOOL GetFileNameAndLine(CString &strName, LPINT piLine=NULL) {return FALSE;}
	
	/// SY 07-25-2001 t9336 OIDE_GUI_IMPROVEMENT
	//virtual UINT OnGeneralUI(UINT uResID, UINT msg) {return LTUI_RETURN_NOT_HANDLED;}
	virtual UINT OnGeneralUI(UINT uResID, UINT msg, LPARAM lParam = 0L) {return LTUI_RETURN_NOT_HANDLED;}
	/// end  OIDE_GUI_IMPROVEMENT

private: // data members

};
/// end LABTALK_MANAGER_UI

/////////////////////////////////////////////////////////////////////////////
//
//	MOCAObj	:	base class, Microcal Object
//
/////////////////////////////////////////////////////////////////////////////

/// EJP 01-09-2001 v6.1071 t8790 LABTALK_MANAGER_UI
///class  MOCA_EXP_CLASS	MOCAObj : public CObject
class MOCA_EXP_CLASS MOCAObj : public COKLTObj
/// end	LABTALK_MANAGER_UI
{
	DECLARE_DYNAMIC(MOCAObj);
		
	friend class 		MOCAStatus; //progressing bar
   
private:
	
	static	LPCALLBK	s_lpProc;/// Origin call back function
	static	MOINT32		s_count;  
	static	HWND		s_hWnd;	 /// Origin hWnd
	
	
public:
	MOCAObj();
	virtual		~MOCAObj();
	
	virtual		BOOL		IsValid();
	static		MOINT32 	GetCount();
	
	MORETURN	lpProc(HWND hWnd,WORD msg,LPSTR lpstr1,LPSTR lpstr2);
	MORETURN	Origin(WORD msg,LPSTR lpstr1,LPSTR lpstr2);
	MORETURN	DataOrigin(WORD msg,DWORD lParam,LPSTR lpdata);
	MOMSG		GetMoMsgFromEgoMsg(WORD msg);
	double		GaussianDistribution(double x, double mean, double sigma);
//	MORETURN	ScriptInterface(HWND hWnd, LPSTR lpStr1,LPSTR lpStr2, LPMOREAL lpValue, LPCALLBK lpProc, MOMSG msg);

	void		RealToString(double rValue, LPSTR lpszString, LPSTR lpszFormat = NULL);
	void		ScriptMessage(LPCTSTR lpstr) const;
	void		WriteString(LPCTSTR lpstr, DWORD dwCntrl) const;//CPY 3/15/01 7.0 PRINT_STRING
	void        StatusMessage(LPCTSTR lpstr);  
	static void	SetCallback(HWND hWnd,LPCALLBK lpProc);//TD 11/26/2000 	Should be static -- only intializes static members
	
	BOOL		GetOriginString( char which, LPSTR lpstr );
	BOOL		SetOriginString( char which, LPSTR lpstr );
	BOOL		GetOriginString(LPSTR lpstrLabTalk, LPSTR lpstrDest);
	BOOL		SetOriginString(LPSTR lpstrLabTalk, LPSTR lpstrSrc);
	BOOL		GetOriginNumeric(LPMOREAL pValue, LPSTR pstrVar);
	double		LabTalkStr2double(LPCSTR pstrVar);
	int			LabTalkStr2int(LPCSTR pstrVar);
	BOOL		SetOriginNumeric(LPSTR pstrVar, double Value);

	int			ExecuteScript(LPCTSTR lpcstrScript, HWND hwndOwner = NULL);
    int			clean_all_temp_datasets();

	/// EJP 07-06-2000 t8153 GET_REGISTRATION_INFO
	BOOL IsOriginRegistered();
	UINT GetRegistration(CString &strSerialNumber, CString &strCustomerID);
	/// end GET_REGISTRATION_INFO

	/// EJP 08-15-2000 t8153 v6.1026 WCB_GET_USER_INFO
	DWORD GetOriginType();
	/// end WCB_GET_USER_INFO

	/// YuI 8/30/02 v7.0387 QA70-2841 LINKS_MANAGER_FOR_OBJECTS
	//	//LY	12/14/01 t9798 SERIESPTR_MANAGER
	//	virtual		BOOL		InvalidateObj() {return FALSE;}
	//	//end t9798 SERIESPTR_MANAGER
	// for the purposes of array based types we need to provide the pointer to the object that is being destroyed
	virtual	BOOL		InvalidateObj(LPVOID pObject) {return FALSE;}
	/// end LINKS_MANAGER_FOR_OBJECTS
	/// TD 12-05-02 QA70-3060 v7.0452 SEND_MSG_TO_MOCA_WRAPPERS
	/// TD 11-14-03 QA70-5516 ALLOW_MIXED_TO_DOUBLE_SWITCH_FOR_DATASET 
	//virtual BOOL		OnLHMessage(UINT nMsg, LPVOID pObject)	{return FALSE;}
	virtual BOOL		OnLHMessage(UINT nMsg, LPVOID pObject, WPARAM wParam = 0, LPARAM lParam = 0)	{return FALSE;}
	/// end ALLOW_MIXED_TO_DOUBLE_SWITCH_FOR_DATASET 
	/// end SEND_MSG_TO_MOCA_WRAPPERS


	/// EJP 02-27-2002 QA70_985 ENABLE_SOFTDEV_PDF
	FARPROC DLLGetProcAddress(LPCTSTR lpcszFuncName, LPCTSTR lpcszDLLName, BOOL bSysPath=FALSE, BOOL bAddIfNeeded=TRUE);
	/// end ENABLE_SOFTDEV_PDF

	// AW 07/01/02 v7.0333 QA70-2116 MORE_WORK_ON_NAG_DLL_SUPPORT 
	// Move The following part from derived class-- OCAllTensorbases class
	static void	SetCallback(OK_GET_PROC_ADDDRESS lpfnGetProcAddress);
private:
	static OK_GET_PROC_ADDDRESS	m_lpfnGetProcAddress;	  
public:
	static FARPROC	GetNagFunctionAddress(LPCTSTR lpcszFuncName);	// set it as public as oconecomplex need to call it.
	// END MORE_WORK_ON_NAG_DLL_SUPPORT


protected:

	static		HWND	GetOrgWindowHandle();    
    static		MOCARecorder	s_Recorder; 
};  










/////////////////////////////////////////////////////////////////////////////
//
//	MOCAOrigin	:	Origin interface besides scripting access
//
/////////////////////////////////////////////////////////////////////////////

class MOCA_EXP_CLASS	MOCAOrigin : public MOCAObj
{
	DECLARE_DYNAMIC(MOCAOrigin);

public:
	/// YuI 8/30/02 v7.0387 QA70-2841 LINKS_MANAGER_FOR_OBJECTS
	// not really needed. So I comment it out
	//	//LY	12/14/01 t9798 SERIESPTR_MANAGER
	//	virtual		BOOL		InvalidateObj() {return FALSE;}
	//	//end t9798 SERIESPTR_MANAGER
	/// end LINKS_MANAGER_FOR_OBJECTS
};


////////////////////////////////////////////////////////////////////////////
//
//	MOCARecorder, keep a list of object pointers
//
////////////////////////////////////////////////////////////////////////////

typedef		MOCAObj			*MOCAObjPtr;
class		MOCARecObj;
typedef		MOCARecObj		*MOCARecObjPtr;

class	MOCA_EXP_CLASS	 MOCARecObj
{
public:
	MOCARecObj(MOCAObjPtr pObj);
	~MOCARecObj(); 

	MOCARecObjPtr		next; // pointer to next MOCARecObj
	BOOL				IsThisObj(MOCAObjPtr pObj);
	MOCAObjPtr			Get_pObj();
	void				Set_pObj(MOCAObjPtr p);

private:
	MOCAObjPtr			m_pObj; /// obj to be recorded
};

/////////////////////////////////////////////////////////////////////////////////
////class MOCARecorder
		
class MOCA_EXP_CLASS	MOCARecorder
{
public:

	MOCARecorder(); 
	~MOCARecorder(); 

	void			remove_all();
	void			add(MOCAObjPtr pObj);
	void			remove(MOCAObjPtr pObj);
    void			list();
    int				count();
    
private:

	MOCARecObjPtr		m_pList;
};

/////////////////////////////////////////////////////////////////////////////
//
//	MOCAPtr	: base class for new operator related class  xinyi 7/26/95
//
/////////////////////////////////////////////////////////////////////////////
class MOCA_EXP_CLASS	MOCAPtr : public MOCAObj
{
	DECLARE_DYNAMIC(MOCAPtr);

public: 
	MOCAPtr();
	~MOCAPtr();
};
  

class MOCA_EXP_CLASS	MOCAStatus: public MOCAObj
{
	DECLARE_DYNAMIC(MOCAStatus);

#ifndef MODLL_DEMO
	   
public: 
	MOCAStatus(LPSTR s); 	
	MOCAStatus(CWnd* phWnd, int begin, int end, LPSTR s); 
	~MOCAStatus();
	
	void		SetBarVal(WORD n, BOOL notpercentage);
	void 		SetBarVal(WORD n); 
	int 		Test(); 

#endif

private:

	int			m_begin;
	int			m_end;
};
 






#ifdef		_AFXDLL
	#pragma	message("<MFC><MFC><MFC><MFC><MFC><MFC><MFC>  _AFXDLL  defined   <MFC><MFC><MFC><MFC><MFC><MFC><MFC><MFC>")
#else		// !_AFXDLL
	#pragma	message("<MFC><MFC><MFC><MFC><MFC><MFC><MFC>  _AFXDLL  NOT defined   <MFC><MFC><MFC><MFC><MFC><MFC><MFC><MFC>")
#endif		// !_AFXDLL

#ifdef		_USRDLL
	#pragma	message("<MFC><MFC><MFC><MFC><MFC><MFC><MFC>  _USRDLL  defined   <MFC><MFC><MFC><MFC><MFC><MFC><MFC><MFC>")
#else		// !_USRDLL
	#pragma	message("<MFC><MFC><MFC><MFC><MFC><MFC><MFC>  _USRDLL  NOT defined   <MFC><MFC><MFC><MFC><MFC><MFC><MFC><MFC>")
#endif		// !_USRDLL

#ifdef		_WINDLL
	#pragma	message("<MFC><MFC><MFC><MFC><MFC><MFC><MFC>  _WINDLL  defined   <MFC><MFC><MFC><MFC><MFC><MFC><MFC><MFC>")
#else		// !_WINDLL
	#pragma	message("<MFC><MFC><MFC><MFC><MFC><MFC><MFC>  _WINDLL  NOT defined   <MFC><MFC><MFC><MFC><MFC><MFC><MFC><MFC>")
#endif		// !_WINDLL

#ifdef		_AFXEXT
	#pragma	message("<MFC><MFC><MFC><MFC><MFC><MFC><MFC>  _AFXEXT  defined   <MFC><MFC><MFC><MFC><MFC><MFC><MFC><MFC>")
#else		// !_AFXDLL
	#pragma	message("<MFC><MFC><MFC><MFC><MFC><MFC><MFC>  _AFXEXT  NOT defined   <MFC><MFC><MFC><MFC><MFC><MFC><MFC><MFC>")
#endif		// !_AFXDLL



#endif ///_MOCADLL_H
