/*--------------------------------------------------------------------------*
 * File Name:	datasetObj.h												*
 * Purpose:		Demonstrate how to access an Origin dataset					*
 * Creation:	March 24, 2000												*
 * Copyright Microcal Software Inc. 2000									*
 *																			*
 * Modification Log:														*
 *--------------------------------------------------------------------------*/      

#ifndef _DATASETOBJ_H
#define _DATASETOBJ_H


#include "mocamain.h" // Required header file


//---------------------------------------------------------------------------
// Define main object class
//---------------------------------------------------------------------------
class CDataSetDemo : public CMOCAObjBase
{
	// Declare Property Map if object has LabTalk properties, methods or SubObjects
	MOCA_DECLARE_PROP_MAP(CDataSetDemo);

	// Declare Method Map if object has LabTalk methods
	MOCA_DECLARE_METH_MAP(CDataSetDemo)

	// Declare SubObject Map if object has LabTalk SubObjects
	//MOCA_DECLARE_SUBOBJ_MAP(CDataSetDemo)

public: // constructor and destructor
	CDataSetDemo();
	~CDataSetDemo();

private: // data members for LabTalk Properties
	CString		m_DataSetName;		// dataset name
	CString		m_WksName;		    // worksheet name
	CString		m_ColName;			// column name
	int			m_ColNumber;		// column number

public: // member functions for LabTalk Properties
	BOOL GetLowRange(int &iValue);
	BOOL GetHighRange(int &iValue);

private: // member functions for LabTalk Methods
	BOOL MethodSetValue(double &dReturn, CStringArray &argarray);
	BOOL MethodGetValue(double &dReturn, CStringArray &argarray);
	BOOL MethodSetRange(double &dReturn, CStringArray &argarray);
	BOOL MethodLowRange(double &dReturn, CStringArray &argarray);
	BOOL MethodHighRange(double &dReturn, CStringArray &argarray);
	BOOL MethodValueString(double &dReturn, CStringArray &argarray);

	// If no name specified then the dataset will be determined by
	// the LabTalk properties.
	MoSourceData AttachToRelevant(LPCSTR);
};

#endif // _DATASETOBJ_H
