/*--------------------------------------------------------------------------*
 * File Name:	SweepObj.cpp												*
 * Purpose:		Demostrate realtime update on a graph						*
 * Creation:	April 04, 2000												*
 * Copyright (c) 2000 Microcal Software, Inc.								*
 *																			*
 * Modification Log:														*
 *--------------------------------------------------------------------------*/      

#include "SweepObj.h"

 
//---------------------------------------------------------------------------
// MOCA_ENTRY_POINT( <main object class> )
//
// This is the main object. A Moca project can have one and only one main
// object decleared by the above command which communicates with Origin.
//---------------------------------------------------------------------------
MOCA_ENTRY_POINT(CSweepObj)
 
 
//---------------------------------------------------------------------------
// Property Map:
//
// The Property Map is for declaring the properties of your LabTalk object.
//
// A property is mapped to Get and Set function.  These functions allow
// you to do error checking or any necessary conversions.  A read-only
// property can be declared by using the _GET macro.
//
// MOCA_PROP_INT( <GetFunction>,<SetFunction>,<PropertyNameStr> )
// MOCA_PROP_REAL( <GetFunction>,<SetFunction>,<PropertyNameStr> )
// MOCA_PROP_STR( <GetFunction>,<SetFunction>,<PropertyNameStr> )
// MOCA_PROP_INT_GET( <GetFunction>,<PropertyNameStr> )
// MOCA_PROP_REAL_GET( <GetFunction>,<PropertyNameStr> )
// MOCA_PROP_STR_GET( <GetFunction>,<PropertyNameStr> )
//
// A Simple Property is mapped to a data member.  There are no Get/Set
// functions for a Simple Property.  MOCA will take care of the assignment.
// A simple read-only property can be declared by using the _GET macro.
//
// MOCA_SIMPLE_PROP_INT( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_REAL( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_STR( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_INT_GET( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_REAL_GET( <DataMember>,<PropertyNameStr> )
// MOCA_SIMPLE_PROP_STR_GET( <DataMember>,<PropertyNameStr> )
//---------------------------------------------------------------------------
MOCA_BEGIN_PROP_MAP(CSweepObj, CMOCAObjBase)
	MOCA_PROP_INT(GetNumPoints, SetNumPoints, "NumPoints")
	MOCA_PROP_INT(GetMaxNumPoints, SetMaxNumPoints, "MaxNumPoints")
	MOCA_PROP_STR(GetWksName, SetWksName, "WksName")
MOCA_END_PROP_MAP(CSweepObj, CMOCAObjBase)


//---------------------------------------------------------------------------
// Method Map:
//
// INPORTANT: To have a Method Map or a SubObject Map, you must
// have a property map.  A property map can be empty.
//
// MOCA_METH_ENTRY( <MemberFunction>,<MethodNameStr> )
//
// <MemberFunction> must be declared as "BOOL foo(double &, CStringArray &);"
// The double is used for storing LabTalk's return value.
// The CStringArray contains the arguments passed from LabTalk.
//---------------------------------------------------------------------------
MOCA_BEGIN_METH_MAP(CSweepObj, CMOCAObjBase)
MOCA_END_METH_MAP(CSweepObj, CMOCAObjBase)


//---------------------------------------------------------------------------
// SubObject Map:
//
// IMPORTANT: To have a Method Map or a SubObject Map, you must
// have a property map.  A property map can be empty.
//
// MOCA_SUBOBJ_ENTRY( <m_SubObject>,<SubObjectNameStr> )
//
//---------------------------------------------------------------------------
MOCA_BEGIN_SUBOBJ_MAP(CSweepObj, CMOCAObjBase)
	MOCA_SUBOBJ_ENTRY(m_ThreadSubObj, "Thread")
MOCA_END_SUBOBJ_MAP(CSweepObj, CMOCAObjBase)


//---------------------------------------------------------------------------
CSweepObj::CSweepObj()
{
}

CSweepObj::~CSweepObj()
{
}

//---------------------------------------------------------------------------
BOOL CSweepObj::GetNumPoints(int &iValue)
{
	iValue = m_ThreadSubObj.m_iNumPoints;
	return TRUE;
}

BOOL CSweepObj::SetNumPoints(int iValue)
{
	if( iValue >= 2 && iValue <= 1000 )
	{
		m_ThreadSubObj.m_iNumPoints = iValue;
		return TRUE;
	}
	return FALSE;
}

//---------------------------------------------------------------------------
BOOL CSweepObj::GetMaxNumPoints(int &iValue)
{
	iValue = m_ThreadSubObj.m_iMaxNumPoints;
	return TRUE;
}

BOOL CSweepObj::SetMaxNumPoints(int iValue)
{
	m_ThreadSubObj.m_iMaxNumPoints = iValue;
	return TRUE;
}

//---------------------------------------------------------------------------
BOOL CSweepObj::GetWksName(LPSTR lpstr)
{
	lstrcpy(lpstr, m_ThreadSubObj.m_strWksName);
	return TRUE;
}

BOOL CSweepObj::SetWksName(LPCSTR lpcstr)
{
	m_ThreadSubObj.m_strWksName = lpcstr;
	return TRUE;
}

