/*--------------------------------------------------------------------------*
 * File Name:	FortranDemoObj.h											*
 * Purpose:		Demonstrate accessing Fortran Libraries in Origin			*
 * Creation:	April	21, 2000											*
 *  	Copyright Microcal Software Inc. 2000								*
 *																			*
 * Modification Log:														*
 *--------------------------------------------------------------------------*/      

#ifndef _FORTRANDEMOOBJ_H
#define _FORTRANDEMOOBJ_H


#include "mocamain.h" // Required header file


//---------------------------------------------------------------------------
// Define main object class
//---------------------------------------------------------------------------
class CFortran : public CMOCAObjBase
{
	// Declare Property Map if object has LabTalk properties, methods or SubObjects
	MOCA_DECLARE_PROP_MAP(CFortran);

	// Declare Method Map if object has LabTalk methods
	MOCA_DECLARE_METH_MAP(CFortran)

	// Declare SubObject Map if object has LabTalk SubObjects
	//OMOCA_DECLARE_SUBOBJECT_MAP(CDataSetDemo)

public: // constructor and destructor
	CFortran();
	~CFortran();

private:

	BOOL MethodCompute(double &dValue, CStringArray &argarray);
	BOOL MethodTranspose(double &dValue, CStringArray &argarray);
	BOOL MethodMultiply(double &dValue, CStringArray &argarray);
	BOOL MethodPlot(double &dValue, CStringArray &argarray);
};




#endif		//_FORTRANDEMOOBJ_H
