// OCConvTemp.h

#ifndef _OCCONVTEMP_H_
#define _OCCONVTEMP_H_

//--------------------------------------------------------------------------
// OCConvertTemperature
//
// This is our Origin C class handler.  It must be derived from 
// CScriptMocaObject or any class derived from CScriptMocaObject.
//
//--------------------------------------------------------------------------
class OCConvertTemperature : public CScriptMocaObject
{
	MOCA_DECLARE_DYNAMIC(OCConvertTemperature)
	DECLARE_MEMBERS_TABLE(OCConvertTemperature)

public:
	OCConvertTemperature(COCall *pCall=NULL);
	~OCConvertTemperature();

	////////////////////////////////////////////////////////////////////////
	// The following functions handle our Origin C class's data members
	////////////////////////////////////////////////////////////////////////
	int GetCelsius(COCall *pCall);
	int SetCelsius(COCall *pCall);

	int GetFahrenheit(COCall *pCall);
	int SetFahrenheit(COCall *pCall);

	////////////////////////////////////////////////////////////////////////
	// The following functions handle our Origin C class's member functions
	////////////////////////////////////////////////////////////////////////
	int CelsiusToFahrenheit(COCall *pCall);
	int FahrenheitToCelsius(COCall *pCall);

private:
	double m_dCelsius;
	double m_dFahrenheit;
};

#endif // _OCCONVTEMP_H_
